.\" $Id: vbox.conf.man,v 1.2 2000/09/15 09:10:10 paul Exp $
.\" CHECKIN $Date: 2000/09/15 09:10:10 $
.TH vbox.conf 5 "@MANDATE@" "ISDN 4 Linux @I4LVERSION@" "Linux System Administration"
.PD 0
.SH NAME
vbox.conf \- config file for vbox

.SH Description
This file is used to configure when and on what conditions calls are
taken. It can also be used to define which CALLERID is used with which
person.

Everything after the "#" is ignored, as are empty lines. All arguments
must be separated by whitespace (spaces, tabs). Arguments may not contain
whitespace.

This file consists of several sections. A section begins with
"[" NAME "]". The section name is case insensitive. A section ends at the
end of the file or at the end of a new section.

These sections exist:

.TP
.B [CALLERIDS]
This section maps CALLERID to persons and what settings to use.

On an incoming call the CALLERID of the caller is detected and compared
with this section. The SECTION of the first match is used.

.B Format : PATTERN SECTION REALNAME

.RS
.TP 4
.B PATTERN
UN*X Pattern of a CALLERID. You may not use whitespace.

.TP
.B SECTION
Name of a user section to use. You many not use whitespace. 
With a "-" STANDARD will be used, with a "*" the REALNAME will be used.

.TP
.B REALNAME
Full name of the person that should be mapped to the CALLERID. Here you
may use spaces.
.RE

.TP
\ 
At the end of the [CALLERIDS] Section, you should have the
entry "* - *** Unknown ***", so that also calls with no or unknown CALLERID
can be processed.

.TP
.B [RINGS]
In this section you set when and after how many RINGs a call is taken.

This section is the first to be examined when a call is incoming to
determine if the call should be taken. The number of RINGs can be
overruled in the user section.

.B Format : TIME DAYS RINGS

.RS
.TP 4
.B TIME
time when the call should be taken. Read the isdntime(5) man page for
details. 

.TP
.B DAYS
days when the call should be takes. Read the isdntime(5) man page for
details.

.TP
.B RINGS
Number of rings to wait before taking the call. With version 2.0 of the
hisax isdn device driver the interval between two rings is longer (now
it's nearly like a telephone; 4 - 5 seconds between rings).
.RE

.TP
.B user defined sections
Here you can make individual settings for some people. The section name
has the same format as the other sections. The names CALLERIDS and RINGS
are reserved.

.B Format : TIME DAYS MESSAGE RECTIME [FLAG] [...]

.RS
.TP 4
.B TIME
time when the call should be taken. Read the isdntime(5) man page for
details. 

.TP
.B DAYS
days when the call should be taken. Read the isdntime(5) man page for
details.

.TP
.B MESSAGE
Standard message to play for this call. You must either give the
filename with full path, or a filename relative to
@SPOOLDIR@/<user>/messages. Default is "standard.msg". You may
not use spaces or tabs.

.TP
.B RECTIME
Time in seconds: how long should vboxgetty record? Default is 60
seconds.

.TP
.B FLAGS
You can additionally give these flags:

.RS 4
.TP 4
.B NOANSWER
Don't answer this call. Default is to answer.

.TP
.B NORECORD
Don't record a message. Default is to record.

.TP
.B NOTIMEOUTMSG
Don't play timeout message. Default is to play.

.TP
.B NOBEEPMSG
Don't play beep message. Default is to play.

.TP
.B NOSTDMSG
Don't play std message. Default is to play.

.TP
.B RINGS=
Number of rings to wait before taking the call. Here you can override
the [RINGS] section.

.TP
.B TOLLRINGS=
Number of rings to wait before answering the call, if new messages are
available. This flag overrides the section [RINGS] and  the flag RINGS=
if there are new messages. The directory to search for new messages must
be given with TOLLCHECK (or you can use the default).

.TP
.B TOLLCHECK=
Directory to search for new messages. Default is
@SPOOLDIR@/<user>/incoming. 

.TP
.B SCRIPT=
TCL-Script to start after taking the call. This must be the full path or
a filename relative to @SPOOLDIR@/<user>. The default is
standard.tcl.
.RE
.RE

.SH FILES
.TP
.B @SPOOLDIR@/<user>/vbox.conf
this configuration file.

.TP
/usr/share/doc/isdnvboxserver/examples/vbox.conf
an example.

.SH SEE ALSO
.B isdntime(5)

.SH AUTHOR
This manual page was written by Andreas Jellinghaus <aj@dungeon.inka.de>,
for Debian GNU/Linux and isdn4linux.
Now maintained by Paul Slootman <paul@debian.org>.
