// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "../Color.h"
#include "CornerProperty.h"
#include "LineProperty.h"
#include "OffsetProperty.h"

#include "PropertiesTypes.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class ShadowPropertyPrivate;

/*!
\class Union::Properties::ShadowProperty
\inmodule core
\ingroup core-properties

\brief A property group containing properties relating to an element's shadow.

*/
class UNION_EXPORT ShadowProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    ShadowProperty();
    /*!
     * Copy constructor.
     */
    ShadowProperty(const ShadowProperty &other);
    /*!
     * Move constructor.
     */
    ShadowProperty(ShadowProperty &&other);
    ~ShadowProperty();

    /*!
     * Copy assignment operator.
     */
    ShadowProperty &operator=(const ShadowProperty &other);
    /*!
     * Move assignment operator.
     */
    ShadowProperty &operator=(ShadowProperty &&other);

    /*!
     * Returns offset if set or nullptr if not.
     */
    OffsetProperty *offset() const;

    /*!
     * Set the value of offset.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setOffset(std::unique_ptr<OffsetProperty> &&newValue);

    /*!
     * Returns the value of color.
     */
    std::optional<Union::Color> color() const;

    /*!
     * Set the value of color.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setColor(const std::optional<Union::Color> &newValue);

    /*!
     * Returns the value of size.
     */
    std::optional<qreal> size() const;

    /*!
     * Set the value of size.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setSize(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of blur.
     */
    std::optional<qreal> blur() const;

    /*!
     * Set the value of blur.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBlur(const std::optional<qreal> &newValue);

    /*!
     * Returns left if set or nullptr if not.
     */
    LineProperty *left() const;

    /*!
     * Set the value of left.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setLeft(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns right if set or nullptr if not.
     */
    LineProperty *right() const;

    /*!
     * Set the value of right.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setRight(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns top if set or nullptr if not.
     */
    LineProperty *top() const;

    /*!
     * Set the value of top.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTop(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns bottom if set or nullptr if not.
     */
    LineProperty *bottom() const;

    /*!
     * Set the value of bottom.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottom(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns topLeft if set or nullptr if not.
     */
    CornerProperty *topLeft() const;

    /*!
     * Set the value of topLeft.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTopLeft(std::unique_ptr<CornerProperty> &&newValue);

    /*!
     * Returns topRight if set or nullptr if not.
     */
    CornerProperty *topRight() const;

    /*!
     * Set the value of topRight.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTopRight(std::unique_ptr<CornerProperty> &&newValue);

    /*!
     * Returns bottomLeft if set or nullptr if not.
     */
    CornerProperty *bottomLeft() const;

    /*!
     * Set the value of bottomLeft.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottomLeft(std::unique_ptr<CornerProperty> &&newValue);

    /*!
     * Returns bottomRight if set or nullptr if not.
     */
    CornerProperty *bottomRight() const;

    /*!
     * Set the value of bottomRight.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottomRight(std::unique_ptr<CornerProperty> &&newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Returns a string representation of this property group.
     *
     * This is intended for debugging.
     *
     * \a indentation The amount of indentation to apply. Defaults to 0.
     * \a flags A set of flags that control conversion behavior.
     */
    QString toString(int indentation = 0, ToStringFlags flags = ToStringFlags{}) const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const ShadowProperty *source, ShadowProperty *destination);

    /*!
     * Create and return an empty ShadowProperty instance.
     *
     * This will create an empty ShadowProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static std::unique_ptr<ShadowProperty> empty();

private:
    std::unique_ptr<ShadowPropertyPrivate> d;
};

/*!
 * \relates Union::Properties::ShadowProperty
 * Equality comparison for ShadowProperty.
 */
UNION_EXPORT bool operator==(const ShadowProperty &left, const ShadowProperty &right);
}
}

/*!
 * \relates Union::Properties::ShadowProperty
 * QDebug support for ShadowProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, Union::Properties::ShadowProperty *type);