// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>

#include <QVector2D>


#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class OffsetPropertyPrivate;

/*!
\class Union::Properties::OffsetProperty
\inmodule core
\ingroup core-properties


*/
class UNION_EXPORT OffsetProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    OffsetProperty();
    /*!
     * Copy constructor.
     */
    OffsetProperty(const OffsetProperty &other);
    /*!
     * Move constructor.
     */
    OffsetProperty(OffsetProperty &&other);
    ~OffsetProperty();

    /*!
     * Copy assignment operator.
     */
    OffsetProperty &operator=(const OffsetProperty &other);
    /*!
     * Move assignment operator.
     */
    OffsetProperty &operator=(OffsetProperty &&other);

    /*!
     * Returns the value of horizontal.
     */
    std::optional<qreal> horizontal() const;
    /*!
     * Set the value of horizontal.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setHorizontal(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of vertical.
     */
    std::optional<qreal> vertical() const;
    /*!
     * Set the value of vertical.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setVertical(const std::optional<qreal> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const OffsetProperty &source, OffsetProperty &destination);

    /*!
     * Create and return an empty OffsetProperty instance.
     *
     * This will create an empty OffsetProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static OffsetProperty empty();

    /*!
       Convert an Offset property to QVector2D.

       If any values are not set, they will use 0.0.
     */
    QVector2D toVector2D() const;

private:
    std::unique_ptr<OffsetPropertyPrivate> d;
};

/*!
 * \relates Union::Properties::OffsetProperty
 * Equality comparison for OffsetProperty.
 */
UNION_EXPORT bool operator==(const OffsetProperty &left, const OffsetProperty &right);
}
}

/*!
 * \relates Union::Properties::OffsetProperty
 * QDebug support for OffsetProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, const Union::Properties::OffsetProperty &type);