/* individual-aggregator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2012, 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/small-set.h"
#include <gio/gio.h>
#include "folks-internal.h"
#include <glib/gi18n-lib.h>
#include "folks/small-set-internal.h"
#include "config.h"

#define FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA "org.freedesktop.folks"
#define FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY "primary-store"
#define FOLKS_INDIVIDUAL_AGGREGATOR__QUIESCENT_TIMEOUT ((guint) 30)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_0_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_USER_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_NUM_PROPERTIES
};
static GParamSpec* folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_internal_profile_block_free0(var) ((var == NULL) ? NULL : (var = (folks_internal_profile_block_free (var), NULL)))
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;
typedef struct _FolksIndividualAggregatorUnprepareData FolksIndividualAggregatorUnprepareData;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block6Data Block6Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;
typedef struct _FolksIndividualAggregatorEnsureIndividualPropertyWriteableData FolksIndividualAggregatorEnsureIndividualPropertyWriteableData;
typedef struct _FolksIndividualAggregatorEnsurePersonasPropertyWriteableData FolksIndividualAggregatorEnsurePersonasPropertyWriteableData;
typedef struct _FolksIndividualAggregatorLookUpIndividualData FolksIndividualAggregatorLookUpIndividualData;
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_CHANGED_SIGNAL,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_CHANGED_DETAILED_SIGNAL,
	FOLKS_INDIVIDUAL_AGGREGATOR_NUM_SIGNALS
};
static guint folks_individual_aggregator_signals[FOLKS_INDIVIDUAL_AGGREGATOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

/**
 * Errors from {@link IndividualAggregator}s.
 */
struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* _backend_store;
	GeeHashMap* _stores;
	FolksPersonaStore* _primary_store;
	FolksSmallSet* _backends;
	GSettings* _primary_store_setting;
	GHashTable* _link_map;
	gboolean _linking_enabled;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	FolksDebug* _debug;
	gchar* _configured_primary_store_type_id;
	gchar* _configured_primary_store_id;
	guint _non_quiescent_persona_store_count;
	guint _non_quiescent_backend_count;
	gboolean _is_quiescent;
	guint _quiescent_timeout_id;
	gboolean _user_configured_primary_store;
	GeeMap* _individuals;
	GeeMap* _individuals_ro;
	FolksIndividual* _user;
};

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	FolksInternalProfileBlock* profiling;
	FolksInternalProfileBlock* _tmp0_;
	gboolean _tmp1_;
	guint _tmp2_;
	FolksBackendStore* _tmp3_;
	GeeCollection* backends;
	FolksBackendStore* _tmp4_;
	GeeMap* _tmp5_;
	GeeMap* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeIterator* _backend_it;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_;
	GeeIterator* _tmp11_;
	FolksBackend* backend;
	GeeIterator* _tmp12_;
	gpointer _tmp13_;
	FolksBackendStore* _tmp14_;
	FolksBackend* _tmp15_;
	FolksBackendStore* _tmp16_;
	guint _tmp17_;
	GError* _inner_error1_;
	FolksInternalProfileBlock* _tmp18_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	gboolean _tmp0_;
	GeeIterator* _p_it;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	FolksPersonaStore* p;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FolksPersonaStore* _tmp10_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	gchar* store_id;
	FolksPersonaStore* store;
};

struct _Block3Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	GeeHashSet* candidate_inds;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	const gchar* prop_name;
};

struct _Block5Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
};

struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	FolksPersonaStore* persona_store;
	GHashTable* details;
	FolksPersona* result;
	FolksPersona* persona;
	GHashTable* details_copy;
	GHashTable* _tmp0_;
	FolksPersona* _tmp1_;
	GHashTable* _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersona* _tmp4_;
	GError* e;
	GError* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	gchar* full_id;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	gboolean _tmp18_;
	FolksPersona* _tmp19_;
	GeeSet* _tmp20_;
	GeeSet* _tmp21_;
	FolksPersona* _tmp22_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	FolksSmallSet* personas;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	FolksSmallSet* _tmp2_;
	FolksSmallSet* _persona_list;
	FolksSmallSet* _tmp3_;
	gint _persona_size;
	FolksSmallSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _persona_index;
	gint _tmp7_;
	gint _tmp8_;
	FolksPersona* persona;
	FolksSmallSet* _tmp9_;
	gconstpointer _tmp10_;
	FolksPersona* _tmp11_;
	FolksPersona* _tmp12_;
	FolksPersonaStore* _tmp13_;
	FolksPersonaStore* _tmp14_;
	FolksPersona* _tmp15_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	GeeSet* personas;
	FolksPersonaStore* key_file_store;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	FolksPersonaStore* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeIterator* _p_it;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	FolksPersona* p;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	FolksAntiLinkable* al;
	FolksPersona* _tmp9_;
	FolksAntiLinkable* _tmp10_;
	FolksAntiLinkable* _tmp11_;
	FolksAntiLinkable* _tmp12_;
	GError* _tmp13_;
	GHashTable* details;
	GHashTable* _tmp14_;
	FolksPersonaStore* _tmp15_;
	GHashTable* _tmp16_;
	FolksPersona* _tmp17_;
	FolksPersona* _tmp18_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	FolksPersonaStore* key_file_store;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FolksSmallSet* individual_personas;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	FolksSmallSet* _tmp8_;
	FolksSmallSet* key_file_personas;
	FolksSmallSet* _tmp9_;
	FolksSmallSet* _p_list;
	FolksSmallSet* _tmp10_;
	gint _p_size;
	FolksSmallSet* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _p_index;
	gint _tmp14_;
	gint _tmp15_;
	FolksPersona* p;
	FolksSmallSet* _tmp16_;
	gconstpointer _tmp17_;
	FolksPersona* _tmp18_;
	FolksPersona* _tmp19_;
	FolksPersonaStore* _tmp20_;
	FolksPersonaStore* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	FolksSmallSet* _tmp24_;
	FolksPersona* _tmp25_;
	FolksSmallSet* _tmp26_;
	FolksPersona* _tmp27_;
	FolksPersona* _tmp28_;
	FolksPersonaStore* _tmp29_;
	FolksPersonaStore* _tmp30_;
	FolksPersona* _tmp31_;
	FolksSmallSet* _vala1__p_list;
	FolksSmallSet* _tmp32_;
	gint _vala1__p_size;
	FolksSmallSet* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _vala1__p_index;
	gint _tmp36_;
	gint _tmp37_;
	FolksPersona* _vala1_p;
	FolksSmallSet* _tmp38_;
	gconstpointer _tmp39_;
	FolksPersona* _tmp40_;
	FolksAntiLinkable* al;
	FolksPersona* _tmp41_;
	FolksAntiLinkable* _tmp42_;
	FolksAntiLinkable* _tmp43_;
	FolksAntiLinkable* _tmp44_;
	FolksSmallSet* _tmp45_;
	FolksSmallSet* _pers_list;
	FolksSmallSet* _tmp46_;
	gint _pers_size;
	FolksSmallSet* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gint _pers_index;
	gint _tmp50_;
	gint _tmp51_;
	FolksPersona* pers;
	FolksSmallSet* _tmp52_;
	gconstpointer _tmp53_;
	FolksPersona* _tmp54_;
	FolksPersona* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	FolksPersona* _tmp58_;
	FolksPersona* writeable_persona;
	FolksPersona* _tmp59_;
	FolksPersonaStore* _tmp60_;
	FolksSmallSet* personas;
	FolksSmallSet* _tmp61_;
	FolksSmallSet* _tmp62_;
	FolksPersona* _tmp63_;
	GHashTable* details;
	FolksSmallSet* _tmp64_;
	GHashTable* _tmp65_;
	FolksPersona* _tmp66_;
	FolksPersonaStore* _tmp67_;
	GHashTable* _tmp68_;
	FolksPersona* _tmp69_;
	FolksPersona* _tmp70_;
	FolksPersona* _tmp71_;
	FolksPersona* _tmp72_;
	FolksSmallSet* anti_link_personas;
	FolksSmallSet* _tmp73_;
	FolksSmallSet* _tmp74_;
	FolksSmallSet* _tmp75_;
	FolksPersona* _tmp76_;
	FolksAntiLinkable* _vala1_al;
	FolksPersona* _tmp77_;
	FolksAntiLinkable* _tmp78_;
	FolksAntiLinkable* _tmp79_;
	FolksAntiLinkable* _tmp80_;
	FolksSmallSet* _tmp81_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorEnsureIndividualPropertyWriteableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	gchar* property_name;
	FolksPersona* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FolksPersona* p;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	FolksPersona* _tmp4_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorEnsurePersonasPropertyWriteableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	GeeSet* personas;
	gchar* property_name;
	FolksPersona* result;
	GeeIterator* _p1_it;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	FolksPersona* p1;
	GeeIterator* _tmp2_;
	gpointer _tmp3_;
	FolksPersona* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	FolksPersona* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GHashTable* details;
	GHashTable* _tmp11_;
	FolksPersona* new_persona;
	gboolean _tmp12_;
	FolksPersonaStore* _tmp13_;
	FolksPersonaStore* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	FolksPersona* _tmp18_;
	FolksPersonaStore* _tmp19_;
	GHashTable* _tmp20_;
	FolksPersona* _tmp21_;
	FolksPersona* _tmp22_;
	FolksPersona* _tmp23_;
	GeeIterator* _s_it;
	GeeHashMap* _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _tmp29_;
	GeeIterator* _tmp30_;
	FolksPersonaStore* s;
	GeeIterator* _tmp31_;
	gpointer _tmp32_;
	gboolean _tmp33_;
	FolksPersonaStore* _tmp34_;
	FolksPersonaStore* _tmp35_;
	FolksPersonaStore* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gint _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	FolksPersonaStore* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	FolksPersona* _tmp43_;
	FolksPersonaStore* _tmp44_;
	GHashTable* _tmp45_;
	FolksPersona* _tmp46_;
	FolksPersona* _tmp47_;
	gboolean _tmp48_;
	FolksPersona* _tmp49_;
	FolksPersonaStore* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GError* _tmp63_;
	GError* _tmp64_;
	FolksPersona* _tmp65_;
	GError* _tmp66_;
	FolksPersona* _tmp67_;
	FolksPersona* _tmp68_;
	GError* _inner_error0_;
};

struct _FolksIndividualAggregatorLookUpIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividualAggregator* self;
	gchar* id;
	FolksIndividual* result;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GError* _inner_error0_;
};

static gint FolksIndividualAggregator_private_offset;
static gpointer folks_individual_aggregator_parent_class = NULL;
static FolksIndividualAggregator* folks_individual_aggregator__instance;
static FolksIndividualAggregator* folks_individual_aggregator__instance = NULL;

static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self,
                                                        FolksBackendStore* backend_store,
                                                        FolksBackend* backend);
static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender,
                                                                                               FolksBackend* backend,
                                                                                               gpointer self);
static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self,
                                                      FolksDebug* debug);
static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender,
                                                                                gpointer self);
static void _folks_individual_aggregator_primary_store_setting_changed_cb (FolksIndividualAggregator* self,
                                                                    GSettings* settings,
                                                                    const gchar* key);
static void _folks_individual_aggregator_configure_primary_store (FolksIndividualAggregator* self,
                                                           const gchar* store_config_ids);
static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self,
                                                       const gchar* type_id,
                                                       const gchar* id);
static void _folks_individual_aggregator_set_primary_store (FolksIndividualAggregator* self,
                                                     FolksPersonaStore* store);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* _data_);
static void folks_individual_aggregator_prepare_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void _folks_individual_aggregator_notify_if_is_quiescent (FolksIndividualAggregator* self);
static void folks_individual_aggregator_unprepare_data_free (gpointer _data);
static gboolean folks_individual_aggregator_unprepare_co (FolksIndividualAggregatorUnprepareData* _data_);
static void folks_individual_aggregator_unprepare_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self,
                                               FolksBackend* backend);
static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self,
                                                                  FolksBackend* backend,
                                                                  FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender,
                                                                                                     FolksPersonaStore* store,
                                                                                                     gpointer self);
static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self,
                                                                    FolksBackend* backend,
                                                                    FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender,
                                                                                                         FolksPersonaStore* store,
                                                                                                         gpointer self);
static void _folks_individual_aggregator_backend_is_quiescent_changed_cb (FolksIndividualAggregator* self,
                                                                   GObject* obj,
                                                                   GParamSpec* pspec);
static void __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self);
static gboolean _folks_individual_aggregator_quiescent_timeout_cb (FolksIndividualAggregator* self);
static gboolean __folks_individual_aggregator_quiescent_timeout_cb_gsource_func (gpointer self);
VALA_EXTERN void folks_persona_store_set_is_primary_store (FolksPersonaStore* self,
                                               gboolean value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _folks_individual_aggregator_maybe_configure_as_primary (FolksIndividualAggregator* self,
                                                                  FolksPersonaStore* store);
static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self,
                                                       FolksPersonaStore* store,
                                                       GeeSet* added,
                                                       GeeSet* removed,
                                                       const gchar* message,
                                                       FolksPersona* actor,
                                                       FolksGroupDetailsChangeReason reason);
static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender,
                                                                                             GeeSet* added,
                                                                                             GeeSet* removed,
                                                                                             const gchar* message,
                                                                                             FolksPersona* actor,
                                                                                             FolksGroupDetailsChangeReason reason,
                                                                                             gpointer self);
static void _folks_individual_aggregator_is_primary_store_changed_cb (FolksIndividualAggregator* self,
                                                               GObject* object,
                                                               GParamSpec* pspec);
static void __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self);
static void _folks_individual_aggregator_persona_store_is_quiescent_changed_cb (FolksIndividualAggregator* self,
                                                                         GObject* obj,
                                                                         GParamSpec* pspec);
static void __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify (GObject* _sender,
                                                                                          GParamSpec* pspec,
                                                                                          gpointer self);
static void _folks_individual_aggregator_persona_store_is_user_set_default_changed_cb (FolksIndividualAggregator* self,
                                                                                GObject* obj,
                                                                                GParamSpec* pspec);
static void __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify (GObject* _sender,
                                                                                                 GParamSpec* pspec,
                                                                                                 gpointer self);
static void __lambda69_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* _result_);
static void ___lambda69__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self,
                                                            GeeSet* added,
                                                            GeeSet* removed,
                                                            GeeMultiMap* changes,
                                                            const gchar* message,
                                                            FolksPersona* actor,
                                                            FolksGroupDetailsChangeReason reason);
static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self,
                                                         FolksIndividual* individual);
static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self,
                                                         FolksIndividual* i,
                                                         FolksIndividual* replacement);
static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender,
                                                                                   FolksIndividual* replacement_individual,
                                                                                   gpointer self);
static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self,
                                                              FolksIndividual* individual);
static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self,
                                                GeeSet* added,
                                                FolksIndividual** user,
                                                GeeHashMultiMap** individuals_changes);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _______lambda67_ (Block4Data* _data4_,
                       const gchar* l);
static void ________lambda67__folks_persona_linkable_property_callback (const gchar* link,
                                                                 gpointer self);
static void _folks_individual_aggregator_add_persona_to_link_map (FolksIndividualAggregator* self,
                                                           FolksPersona* persona,
                                                           FolksIndividual* individual);
static void _folks_individual_aggregator_remove_individual_from_link_map (FolksIndividualAggregator* self,
                                                                   FolksIndividual* individual);
static void _folks_individual_aggregator_persona_linkable_property_changed_cb (FolksIndividualAggregator* self,
                                                                        GObject* obj,
                                                                        GParamSpec* pspec);
static void _folks_individual_aggregator_persona_anti_links_changed_cb (FolksIndividualAggregator* self,
                                                                 GObject* obj,
                                                                 GParamSpec* pspec);
static void _folks_individual_aggregator_connect_to_persona (FolksIndividualAggregator* self,
                                                      FolksPersona* persona);
static void __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static void __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void _folks_individual_aggregator_disconnect_from_persona (FolksIndividualAggregator* self,
                                                           FolksPersona* persona);
static void _folks_individual_aggregator_link_map_set (FolksIndividualAggregator* self,
                                                const gchar* key,
                                                FolksIndividual* individual);
static void _g_object_unref0_ (gpointer var);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _____lambda68_ (Block5Data* _data5_,
                     const gchar* l);
static void ______lambda68__folks_persona_linkable_property_callback (const gchar* link,
                                                               gpointer self);
static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self,
                                           FolksIndividual* value);
VALA_EXTERN void folks_individual_replace (FolksIndividual* self,
                               FolksIndividual* replacement_individual);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* _data_);
static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self,
                                                   GHashTable* asv);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void __lambda70_ (Block6Data* _data6_,
                  const gchar* k,
                  GValue* v);
static GValue* _g_value_dup (GValue* self);
static void ___lambda70__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* _data_);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* _data_);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* _data_);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static GHashTable* _folks_individual_aggregator_build_linking_details (FolksIndividualAggregator* self,
                                                                GeeSet* personas);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v,
                                                                    gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* _data_);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static gboolean _folks_individual_aggregator_is_anti_link_property_writeable (FolksIndividualAggregator* self,
                                                                       FolksPersona* persona);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void folks_individual_aggregator_ensure_individual_property_writeable_data_free (gpointer _data);
static gboolean folks_individual_aggregator_ensure_individual_property_writeable_co (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_);
static void _folks_individual_aggregator_ensure_personas_property_writeable (FolksIndividualAggregator* self,
                                                                      GeeSet* personas,
                                                                      const gchar* property_name,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_);
static FolksPersona* _folks_individual_aggregator_ensure_personas_property_writeable_finish (FolksIndividualAggregator* self,
                                                                                      GAsyncResult* _res_,
                                                                                      GError** error);
static void folks_individual_aggregator_ensure_individual_property_writeable_ready (GObject* source_object,
                                                                             GAsyncResult* _res_,
                                                                             gpointer _user_data_);
static void _folks_individual_aggregator_ensure_personas_property_writeable_data_free (gpointer _data);
static gboolean _folks_individual_aggregator_ensure_personas_property_writeable_co (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_);
static void _folks_individual_aggregator_ensure_personas_property_writeable_ready (GObject* source_object,
                                                                            GAsyncResult* _res_,
                                                                            gpointer _user_data_);
static void folks_individual_aggregator_look_up_individual_data_free (gpointer _data);
static gboolean folks_individual_aggregator_look_up_individual_co (FolksIndividualAggregatorLookUpIndividualData* _data_);
static void folks_individual_aggregator_look_up_individual_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self,
                                                  GeeMap* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure,
                                                                     GValue * return_value,
                                                                     guint n_param_values,
                                                                     const GValue * param_values,
                                                                     gpointer invocation_hint,
                                                                     gpointer marshal_data);
static GObject * folks_individual_aggregator_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _g_ptr_array_unref0_ (gpointer var);
static void __folks_individual_aggregator_primary_store_setting_changed_cb_g_settings_changed (GSettings* _sender,
                                                                                        const gchar* key,
                                                                                        gpointer self);
static void folks_individual_aggregator_finalize (GObject * obj);
static GType folks_individual_aggregator_get_type_once (void);
static void _vala_folks_individual_aggregator_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_folks_individual_aggregator_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
folks_individual_aggregator_error_quark (void)
{
	return g_quark_from_static_string ("folks-individual-aggregator-error-quark");
}

static GType
folks_individual_aggregator_error_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED", "add-failed"}, {FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE", "no-writeable-store"}, {FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE", "store-offline"}, {FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE, "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE", "property-not-writeable"}, {FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE, "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE", "no-primary-store"}, {0, NULL, NULL}};
	GType folks_individual_aggregator_error_type_id;
	folks_individual_aggregator_error_type_id = g_enum_register_static ("FolksIndividualAggregatorError", values);
	return folks_individual_aggregator_error_type_id;
}

GType
folks_individual_aggregator_error_get_type (void)
{
	static volatile gsize folks_individual_aggregator_error_type_id__once = 0;
	if (g_once_init_enter (&folks_individual_aggregator_error_type_id__once)) {
		GType folks_individual_aggregator_error_type_id;
		folks_individual_aggregator_error_type_id = folks_individual_aggregator_error_get_type_once ();
		g_once_init_leave (&folks_individual_aggregator_error_type_id__once, folks_individual_aggregator_error_type_id);
	}
	return folks_individual_aggregator_error_type_id__once;
}

static inline gpointer
folks_individual_aggregator_get_instance_private (FolksIndividualAggregator* self)
{
	return G_STRUCT_MEMBER_P (self, FolksIndividualAggregator_private_offset);
}

static void
__folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender,
                                                                                          FolksBackend* backend,
                                                                                          gpointer self)
{
	_folks_individual_aggregator_backend_available_cb ((FolksIndividualAggregator*) self, _sender, backend);
}

static void
__folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender,
                                                                           gpointer self)
{
	_folks_individual_aggregator_debug_print_status ((FolksIndividualAggregator*) self, _sender);
}

/**
   * Create or return the singleton {@link IndividualAggregator} class instance.
   * If the instance doesn't exist already, it will be created with the
   * default {@link BackendStore}.
   *
   * This function is thread-safe.
   *
   * @return Singleton {@link IndividualAggregator} instance
   * @since 0.9.5
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FolksIndividualAggregator*
folks_individual_aggregator_dup (void)
{
	FolksIndividualAggregator* _retval = NULL;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* retval = NULL;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* result;
	_tmp0_ = folks_individual_aggregator__instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_retval = _tmp1_;
	_tmp2_ = _retval;
	if (_tmp2_ == NULL) {
		FolksIndividualAggregator* _tmp3_;
		FolksIndividualAggregator* _tmp4_;
		_tmp3_ = folks_individual_aggregator_new ();
		_g_object_unref0 (retval);
		retval = _tmp3_;
		_tmp4_ = retval;
		folks_individual_aggregator__instance = _tmp4_;
	} else {
		FolksIndividualAggregator* _tmp5_;
		FolksIndividualAggregator* _tmp6_;
		_tmp5_ = _retval;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator));
		_g_object_unref0 (retval);
		retval = _tmp6_;
	}
	result = retval;
	_g_object_unref0 (_retval);
	return result;
}

/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal (or the
   * {@link IndividualAggregator.individuals_changed_detailed} signal), then
   * call {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed_detailed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   *
   * Folks does not support having more than one IndividualAggregator
   * instantiated at the same time. So it's recommended to use
   * {@link IndividualAggregator.dup} instead.
   */
FolksIndividualAggregator*
folks_individual_aggregator_construct (GType object_type)
{
	FolksIndividualAggregator * self = NULL;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* _tmp1_;
	_tmp0_ = folks_backend_store_dup ();
	_tmp1_ = _tmp0_;
	self = (FolksIndividualAggregator*) g_object_new (object_type, "backend-store", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

FolksIndividualAggregator*
folks_individual_aggregator_new (void)
{
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}

/**
   * Create or return the singleton {@link IndividualAggregator} class instance
   * with a custom {@link BackendStore}.
   * If the instance doesn't exist already, it will be created with
   * the given {@link BackendStore} rather than the default one.
   * If the instance already exists but is using another {@link BackendStore}
   * then a warning is raised and null is returned.
   *
   * This function is thread-safe.
   *
   * @param store the {@link BackendStore} to use instead of the default one.

   * @return Singleton {@link IndividualAggregator} instance, or null
   * @since 0.9.5
   */
FolksIndividualAggregator*
folks_individual_aggregator_dup_with_backend_store (FolksBackendStore* store)
{
	FolksIndividualAggregator* _retval = NULL;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* retval = NULL;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* result;
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = folks_individual_aggregator__instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_retval = _tmp1_;
	_tmp2_ = _retval;
	if (_tmp2_ == NULL) {
		FolksIndividualAggregator* _tmp3_;
		FolksIndividualAggregator* _tmp4_;
		_tmp3_ = folks_individual_aggregator_new_with_backend_store (store);
		_g_object_unref0 (retval);
		retval = _tmp3_;
		_tmp4_ = retval;
		folks_individual_aggregator__instance = _tmp4_;
	} else {
		FolksIndividualAggregator* _tmp5_;
		FolksBackendStore* _tmp6_;
		_tmp5_ = _retval;
		_tmp6_ = _tmp5_->priv->_backend_store;
		if (_tmp6_ != store) {
			g_warning ("individual-aggregator.vala:422: An aggregator already exists using ano" \
"ther backend store");
			result = NULL;
			_g_object_unref0 (retval);
			_g_object_unref0 (_retval);
			return result;
		} else {
			FolksIndividualAggregator* _tmp7_;
			FolksIndividualAggregator* _tmp8_;
			_tmp7_ = _retval;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator));
			_g_object_unref0 (retval);
			retval = _tmp8_;
		}
	}
	result = retval;
	_g_object_unref0 (_retval);
	return result;
}

/**
   * Create a new IndividualAggregator with a custom {@link BackendStore}.
   *
   * This behaves the same as the default constructor for
   * {@link IndividualAggregator}, but uses the given {@link BackendStore}
   * rather than the default one.
   *
   * @param store the {@link BackendStore} to use instead of the default one.
   *
   * @since 0.9.0
   */
FolksIndividualAggregator*
folks_individual_aggregator_construct_with_backend_store (GType object_type,
                                                          FolksBackendStore* store)
{
	FolksIndividualAggregator * self = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	self = (FolksIndividualAggregator*) g_object_new (object_type, "backend-store", store, NULL);
	return self;
}

FolksIndividualAggregator*
folks_individual_aggregator_new_with_backend_store (FolksBackendStore* store)
{
	return folks_individual_aggregator_construct_with_backend_store (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, store);
}

static void
_folks_individual_aggregator_primary_store_setting_changed_cb (FolksIndividualAggregator* self,
                                                               GSettings* settings,
                                                               const gchar* key)
{
	gchar* val = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (settings, key);
	val = _tmp0_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = val;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		gchar* store_full_id = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		g_debug ("individual-aggregator.vala:541: Setting primary store IDs from GSettin" \
"gs.");
		_tmp4_ = val;
		_folks_individual_aggregator_configure_primary_store (self, (const gchar*) _tmp4_);
		_tmp5_ = self->priv->_configured_primary_store_type_id;
		_tmp6_ = self->priv->_configured_primary_store_id;
		_tmp7_ = _folks_individual_aggregator_get_store_full_id (self, _tmp5_, _tmp6_);
		store_full_id = _tmp7_;
		_tmp8_ = self->priv->_stores;
		_tmp9_ = store_full_id;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, _tmp9_)) {
			FolksPersonaStore* selected_store = NULL;
			GeeHashMap* _tmp10_;
			const gchar* _tmp11_;
			gpointer _tmp12_;
			FolksPersonaStore* _tmp13_;
			_tmp10_ = self->priv->_stores;
			_tmp11_ = store_full_id;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
			selected_store = (FolksPersonaStore*) _tmp12_;
			_tmp13_ = selected_store;
			_folks_individual_aggregator_set_primary_store (self, _tmp13_);
			_g_object_unref0 (selected_store);
		}
		_g_free0 (store_full_id);
	}
	_g_free0 (val);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_folks_individual_aggregator_configure_primary_store (FolksIndividualAggregator* self,
                                                      const gchar* store_config_ids)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (store_config_ids != NULL);
	g_debug ("individual-aggregator.vala:557: _configure_primary_store to '%s'", store_config_ids);
	self->priv->_user_configured_primary_store = TRUE;
	if (string_index_of (store_config_ids, ":", 0) != -1) {
		gchar** ids = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint ids_length1;
		gint _ids_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = _tmp0_ = g_strsplit (store_config_ids, ":", 2);
		ids = _tmp1_;
		ids_length1 = _vala_array_length (_tmp0_);
		_ids_size_ = ids_length1;
		_tmp2_ = ids;
		_tmp2__length1 = ids_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_configured_primary_store_type_id);
		self->priv->_configured_primary_store_type_id = _tmp4_;
		_tmp5_ = ids;
		_tmp5__length1 = ids_length1;
		_tmp6_ = _tmp5_[1];
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->_configured_primary_store_id);
		self->priv->_configured_primary_store_id = _tmp7_;
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = g_strdup (store_config_ids);
		_g_free0 (self->priv->_configured_primary_store_type_id);
		self->priv->_configured_primary_store_type_id = _tmp8_;
		_tmp9_ = g_strdup ("");
		_g_free0 (self->priv->_configured_primary_store_id);
		self->priv->_configured_primary_store_id = _tmp9_;
	}
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self,
                                                 FolksDebug* debug)
{
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FolksPersonaStore* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GHashTable* _tmp72_;
	GHashTableIter iter = {0};
	GHashTable* _tmp73_;
	const gchar* link_key = NULL;
	GPtrArray* individuals = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	folks_debug_print_heading (debug, domain, level, "IndividualAggregator (%p)", self);
	if (self->priv->_linking_enabled) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	if (self->priv->_is_prepared) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	if (self->priv->_is_quiescent) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("yes");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf ("no (%u backends, %u persona stores left)", self->priv->_non_quiescent_backend_count, self->priv->_non_quiescent_persona_store_count);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = g_strdup_printf ("%u", ((GObject*) self)->ref_count);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_primary_store;
	_tmp8_ = g_strdup_printf ("%p", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_configured_primary_store_type_id;
	_tmp11_ = self->priv->_configured_primary_store_id;
	folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp6_, "Primary store", _tmp9_, "Configured store type id", _tmp10_, "Configured store id", _tmp11_, "Linking enabled?", _tmp0_, "Prepared?", _tmp1_, "Quiescent?", _tmp2_, NULL);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_tmp12_ = folks_individual_aggregator_get_individuals (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_map_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	folks_debug_print_line (debug, domain, level, "%u Individuals:", (guint) _tmp15_);
	folks_debug_indent (debug);
	{
		GeeIterator* _individual_it = NULL;
		GeeMap* _tmp16_;
		GeeMap* _tmp17_;
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_;
		GeeIterator* _tmp22_;
		_tmp16_ = folks_individual_aggregator_get_individuals (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_map_get_values (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_individual_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			gchar* trust_level = NULL;
			FolksIndividual* _tmp26_;
			FolksTrustLevel _tmp27_;
			FolksTrustLevel _tmp28_;
			FolksIndividual* _tmp31_;
			const gchar* _tmp32_ = NULL;
			FolksIndividual* _tmp33_;
			gboolean _tmp34_;
			gboolean _tmp35_;
			FolksIndividual* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			FolksIndividual* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			FolksIndividual* _tmp43_;
			GeeSet* _tmp44_;
			GeeSet* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			_tmp23_ = _individual_it;
			if (!gee_iterator_next (_tmp23_)) {
				break;
			}
			_tmp24_ = _individual_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			individual = (FolksIndividual*) _tmp25_;
			trust_level = NULL;
			_tmp26_ = individual;
			_tmp27_ = folks_individual_get_trust_level (_tmp26_);
			_tmp28_ = _tmp27_;
			switch (_tmp28_) {
				case FOLKS_TRUST_LEVEL_NONE:
				{
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("none");
					_g_free0 (trust_level);
					trust_level = _tmp29_;
					break;
				}
				case FOLKS_TRUST_LEVEL_PERSONAS:
				{
					gchar* _tmp30_;
					_tmp30_ = g_strdup ("personas");
					_g_free0 (trust_level);
					trust_level = _tmp30_;
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			_tmp31_ = individual;
			folks_debug_print_heading (debug, domain, level, "Individual (%p)", _tmp31_);
			_tmp33_ = individual;
			_tmp34_ = folks_individual_get_is_user (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_) {
				_tmp32_ = "yes";
			} else {
				_tmp32_ = "no";
			}
			_tmp36_ = individual;
			_tmp37_ = g_strdup_printf ("%u", ((GObject*) _tmp36_)->ref_count);
			_tmp38_ = _tmp37_;
			_tmp39_ = individual;
			_tmp40_ = folks_individual_get_id (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = trust_level;
			folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp38_, "ID", _tmp41_, "User?", _tmp32_, "Trust level", _tmp42_, NULL);
			_g_free0 (_tmp38_);
			_tmp43_ = individual;
			_tmp44_ = folks_individual_get_personas (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = gee_collection_get_size ((GeeCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			folks_debug_print_line (debug, domain, level, "%u Personas:", (guint) _tmp47_);
			folks_debug_indent (debug);
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp48_;
				GeeSet* _tmp49_;
				GeeSet* _tmp50_;
				GeeIterator* _tmp51_;
				_tmp48_ = individual;
				_tmp49_ = folks_individual_get_personas (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
				_persona_it = _tmp51_;
				while (TRUE) {
					GeeIterator* _tmp52_;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp53_;
					gpointer _tmp54_;
					FolksPersona* _tmp55_;
					const gchar* _tmp56_ = NULL;
					FolksPersona* _tmp57_;
					gboolean _tmp58_;
					gboolean _tmp59_;
					FolksPersona* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					FolksPersona* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					FolksPersona* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					FolksPersona* _tmp69_;
					const gchar* _tmp70_;
					const gchar* _tmp71_;
					_tmp52_ = _persona_it;
					if (!gee_iterator_next (_tmp52_)) {
						break;
					}
					_tmp53_ = _persona_it;
					_tmp54_ = gee_iterator_get (_tmp53_);
					persona = (FolksPersona*) _tmp54_;
					_tmp55_ = persona;
					folks_debug_print_heading (debug, domain, level, "Persona (%p)", _tmp55_);
					_tmp57_ = persona;
					_tmp58_ = folks_persona_get_is_user (_tmp57_);
					_tmp59_ = _tmp58_;
					if (_tmp59_) {
						_tmp56_ = "yes";
					} else {
						_tmp56_ = "no";
					}
					_tmp60_ = persona;
					_tmp61_ = g_strdup_printf ("%u", ((GObject*) _tmp60_)->ref_count);
					_tmp62_ = _tmp61_;
					_tmp63_ = persona;
					_tmp64_ = folks_persona_get_uid (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = persona;
					_tmp67_ = folks_persona_get_iid (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = persona;
					_tmp70_ = folks_persona_get_display_id (_tmp69_);
					_tmp71_ = _tmp70_;
					folks_debug_print_key_value_pairs (debug, domain, level, "Ref. count", _tmp62_, "UID", _tmp65_, "IID", _tmp68_, "Display ID", _tmp71_, "User?", _tmp56_, NULL);
					_g_free0 (_tmp62_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			folks_debug_unindent (debug);
			_g_free0 (trust_level);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	folks_debug_unindent (debug);
	_tmp72_ = self->priv->_link_map;
	folks_debug_print_line (debug, domain, level, "%u keys in the link map:", g_hash_table_size (_tmp72_));
	folks_debug_indent (debug);
	_tmp73_ = self->priv->_link_map;
	g_hash_table_iter_init (&iter, _tmp73_);
	while (TRUE) {
		gconstpointer _tmp74_ = NULL;
		gconstpointer _tmp75_ = NULL;
		gboolean _tmp76_;
		const gchar* _tmp77_;
		_tmp76_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp74_), (gpointer*) (&_tmp75_));
		link_key = (const gchar*) _tmp74_;
		individuals = (GPtrArray*) _tmp75_;
		if (!_tmp76_) {
			break;
		}
		_tmp77_ = link_key;
		folks_debug_print_line (debug, domain, level, "%s → {", _tmp77_);
		folks_debug_indent (debug);
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp78_ = FALSE;
				_tmp78_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp80_;
					gint _tmp81_;
					gint _tmp82_;
					FolksIndividual* ind = NULL;
					GPtrArray* _tmp83_;
					gconstpointer _tmp84_;
					FolksIndividual* _tmp85_;
					if (!_tmp78_) {
						guint _tmp79_;
						_tmp79_ = i;
						i = _tmp79_ + 1;
					}
					_tmp78_ = FALSE;
					_tmp80_ = individuals;
					_tmp81_ = vala_g_ptr_array_get_length (_tmp80_);
					_tmp82_ = _tmp81_;
					if (!(i < ((guint) _tmp82_))) {
						break;
					}
					_tmp83_ = individuals;
					_tmp84_ = g_ptr_array_index (_tmp83_, i);
					ind = (FolksIndividual*) _tmp84_;
					_tmp85_ = ind;
					folks_debug_print_line (debug, domain, level, "%p", _tmp85_);
				}
			}
		}
		folks_debug_unindent (debug);
		folks_debug_print_line (debug, domain, level, "}");
	}
	folks_debug_unindent (debug);
	folks_debug_print_line (debug, domain, level, "%s", "");
	_g_free0 (_tmp2_);
}

static void
folks_individual_aggregator_prepare_data_free (gpointer _data)
{
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, _data_);
}

void
folks_individual_aggregator_prepare (FolksIndividualAggregator* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FolksIndividualAggregatorPrepareData* _data_;
	FolksIndividualAggregator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_individual_aggregator_prepare_co (_data_);
}

void
folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal (or
   * {@link IndividualAggregator.individuals_changed_detailed} signal), or a
   * race condition could occur, with the signal being emitted before your code
   * has connected to them, and {@link Individual}s getting "lost" as a result.
   *
   * This function is guaranteed to be idempotent (since version 0.3.0).
   *
   * Concurrent calls to this function from different threads will block until
   * preparation has completed. However, concurrent calls to this function from
   * a single thread might not, i.e. the first call will block but subsequent
   * calls might return before the first one. (Though they will be safe in every
   * other respect.)
   *
   * @throws GLib.Error if preparing any of the backends failed — this error
   * will be passed through from {@link BackendStore.load_backends}
   *
   * @since 0.1.11
   */
static void
folks_individual_aggregator_prepare_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_prepare_co (_data_);
}

static gboolean
folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_internal_profiling_start ("preparing IndividualAggregator", NULL);
	_data_->profiling = _data_->_tmp0_;
	if (_data_->self->priv->_is_prepared) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp1_) {
		_folks_internal_profile_block_free0 (_data_->profiling);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp2_ = _data_->self->priv->_non_quiescent_backend_count;
		_data_->self->priv->_non_quiescent_backend_count = _data_->_tmp2_ + 1;
		_data_->_tmp3_ = _data_->self->priv->_backend_store;
		g_signal_connect_object (_data_->_tmp3_, "backend-available", (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, _data_->self, 0);
		_data_->_tmp4_ = _data_->self->priv->_backend_store;
		_data_->_tmp5_ = folks_backend_store_get_enabled_backends (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = gee_map_get_values (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->backends = _data_->_tmp8_;
		{
			_data_->_tmp9_ = _data_->backends;
			_data_->_tmp10_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp9_);
			_data_->_backend_it = _data_->_tmp10_;
			while (TRUE) {
				_data_->_tmp11_ = _data_->_backend_it;
				if (!gee_iterator_next (_data_->_tmp11_)) {
					break;
				}
				_data_->_tmp12_ = _data_->_backend_it;
				_data_->_tmp13_ = gee_iterator_get (_data_->_tmp12_);
				_data_->backend = (FolksBackend*) _data_->_tmp13_;
				_data_->_tmp14_ = _data_->self->priv->_backend_store;
				_data_->_tmp15_ = _data_->backend;
				_folks_individual_aggregator_backend_available_cb (_data_->self, _data_->_tmp14_, _data_->_tmp15_);
				_g_object_unref0 (_data_->backend);
			}
			_g_object_unref0 (_data_->_backend_it);
		}
		_data_->_tmp16_ = _data_->self->priv->_backend_store;
		_data_->_state_ = 1;
		folks_backend_store_load_backends (_data_->_tmp16_, folks_individual_aggregator_prepare_ready, _data_);
		return FALSE;
		_state_1:
		folks_backend_store_load_backends_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->backends);
			goto __finally0;
		}
		_data_->_tmp17_ = _data_->self->priv->_non_quiescent_backend_count;
		_data_->self->priv->_non_quiescent_backend_count = _data_->_tmp17_ - 1;
		_data_->self->priv->_is_prepared = TRUE;
		_data_->self->priv->_prepare_pending = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		if (_data_->self->priv->_is_quiescent == FALSE) {
			_folks_individual_aggregator_notify_if_is_quiescent (_data_->self);
		}
		_g_object_unref0 (_data_->backends);
	}
	__finally0:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_folks_internal_profile_block_free0 (_data_->profiling);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->profiling;
	_data_->profiling = NULL;
	folks_internal_profiling_end (_data_->_tmp18_);
	_folks_internal_profile_block_free0 (_data_->profiling);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_individual_aggregator_unprepare_data_free (gpointer _data)
{
	FolksIndividualAggregatorUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorUnprepareData, _data_);
}

void
folks_individual_aggregator_unprepare (FolksIndividualAggregator* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	FolksIndividualAggregatorUnprepareData* _data_;
	FolksIndividualAggregator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnprepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_individual_aggregator_unprepare_co (_data_);
}

void
folks_individual_aggregator_unprepare_finish (FolksIndividualAggregator* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	FolksIndividualAggregatorUnprepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Clean up and release resources used by the aggregator.
   *
   * This will disconnect the aggregator cleanly from any resources it or its
   * persona stores are using. It is recommended to call this method before
   * finalising the individual aggregator, but calling it is not required. If
   * this method is not called then, for example, unsaved changes in backends
   * may not be flushed.
   *
   * Concurrent calls to this function from different threads will block until
   * preparation has completed. However, concurrent calls to this function from
   * a single thread might not, i.e. the first call will block but subsequent
   * calls might return before the first one. (Though they will be safe in every
   * other respect.)
   *
   * @since 0.7.3
   * @throws GLib.Error if unpreparing the backend-specific services failed —
   * this will be a backend-specific error
   */
static void
folks_individual_aggregator_unprepare_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	FolksIndividualAggregatorUnprepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_unprepare_co (_data_);
}

static gboolean
folks_individual_aggregator_unprepare_co (FolksIndividualAggregatorUnprepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		{
			_data_->_tmp1_ = _data_->self->priv->_stores;
			_data_->_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp1_);
			_data_->_tmp3_ = _data_->_tmp2_;
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			_g_object_unref0 (_data_->_tmp4_);
			_data_->_p_it = _data_->_tmp6_;
			while (TRUE) {
				_data_->_tmp7_ = _data_->_p_it;
				if (!gee_iterator_next (_data_->_tmp7_)) {
					break;
				}
				_data_->_tmp8_ = _data_->_p_it;
				_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
				_data_->p = (FolksPersonaStore*) _data_->_tmp9_;
				_data_->_tmp10_ = _data_->p;
				_data_->_state_ = 1;
				folks_persona_store_flush (_data_->_tmp10_, folks_individual_aggregator_unprepare_ready, _data_);
				return FALSE;
				_state_1:
				folks_persona_store_flush_finish (_data_->_tmp10_, _data_->_res_);
				_g_object_unref0 (_data_->p);
			}
			_g_object_unref0 (_data_->_p_it);
		}
	}
	__finally0:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Get all matches for a given {@link Individual}.
   *
   * @param matchee the individual to find matches for
   * @param min_threshold the threshold for accepting a match
   * @return a map from matched individuals to the degree with which they match
   * ``matchee`` (which is guaranteed to at least equal ``min_threshold``);
   * if no matches could be found, an empty map is returned
   *
   * @since 0.5.1
   */
GeeMap*
folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self,
                                                   FolksIndividual* matchee,
                                                   FolksMatchResult min_threshold)
{
	GeeHashMap* matches = NULL;
	GeeHashMap* _tmp0_;
	FolksPotentialMatch* matchObj = NULL;
	FolksPotentialMatch* _tmp1_;
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (matchee != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = folks_potential_match_new ();
	matchObj = _tmp1_;
	{
		GeeIterator* _i_it = NULL;
		GeeMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = self->priv->_individuals;
		_tmp3_ = gee_map_get_values (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_i_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			FolksIndividual* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			FolksMatchResult _result_ = 0;
			FolksPotentialMatch* _tmp16_;
			FolksIndividual* _tmp17_;
			_tmp8_ = _i_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _i_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			i = (FolksIndividual*) _tmp10_;
			_tmp11_ = i;
			_tmp12_ = folks_individual_get_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = folks_individual_get_id (matchee);
			_tmp15_ = _tmp14_;
			if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
				_g_object_unref0 (i);
				continue;
			}
			_tmp16_ = matchObj;
			_tmp17_ = i;
			_result_ = folks_potential_match_potential_match (_tmp16_, _tmp17_, matchee);
			if (_result_ >= min_threshold) {
				GeeHashMap* _tmp18_;
				FolksIndividual* _tmp19_;
				_tmp18_ = matches;
				_tmp19_ = i;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp19_, (gpointer) ((gintptr) _result_));
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	return result;
}

/**
   * Get all combinations between all {@link Individual}s.
   *
   * @param min_threshold the threshold for accepting a match
   * @return a map from each individual in the aggregator to a map of the
   * other individuals in the aggregator which can be matched with that
   * individual, mapped to the degree with which they match the original
   * individual (which is guaranteed to at least equal ``min_threshold``)
   *
   * @since 0.5.1
   */
GeeMap*
folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self,
                                                       FolksMatchResult min_threshold)
{
	GeeHashMap* matches = NULL;
	GeeHashMap* _tmp0_;
	FolksIndividual** individuals = NULL;
	GeeMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gint _tmp5_ = 0;
	gpointer* _tmp6_;
	FolksIndividual** _tmp7_;
	gint _tmp7__length1;
	gint individuals_length1;
	gint _individuals_size_;
	FolksPotentialMatch* matchObj = NULL;
	FolksPotentialMatch* _tmp8_;
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = gee_map_get_values (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = gee_collection_to_array (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_g_object_unref0 (_tmp4_);
	individuals = _tmp7_;
	individuals_length1 = _tmp7__length1;
	_individuals_size_ = individuals_length1;
	_tmp8_ = folks_potential_match_new ();
	matchObj = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				FolksIndividual** _tmp11_;
				gint _tmp11__length1;
				FolksIndividual* a = NULL;
				FolksIndividual** _tmp12_;
				gint _tmp12__length1;
				FolksIndividual* _tmp13_;
				FolksIndividual* _tmp14_;
				GeeHashMap* _matches_a = NULL;
				GeeHashMap* _tmp15_;
				FolksIndividual* _tmp16_;
				gpointer _tmp17_;
				GeeHashMap* matches_a = NULL;
				GeeHashMap* _tmp18_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = individuals;
				_tmp11__length1 = individuals_length1;
				if (!(i < _tmp11__length1)) {
					break;
				}
				_tmp12_ = individuals;
				_tmp12__length1 = individuals_length1;
				_tmp13_ = _tmp12_[i];
				_tmp14_ = _g_object_ref0 (_tmp13_);
				a = _tmp14_;
				_tmp15_ = matches;
				_tmp16_ = a;
				_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
				_matches_a = (GeeHashMap*) _tmp17_;
				_tmp18_ = _matches_a;
				if (_tmp18_ == NULL) {
					GeeHashMap* _tmp19_;
					GeeHashMap* _tmp20_;
					FolksIndividual* _tmp21_;
					GeeHashMap* _tmp22_;
					_tmp19_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (matches_a);
					matches_a = _tmp19_;
					_tmp20_ = matches;
					_tmp21_ = a;
					_tmp22_ = matches_a;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp21_, _tmp22_);
				} else {
					GeeHashMap* _tmp23_;
					GeeHashMap* _tmp24_;
					_tmp23_ = _matches_a;
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_HASH_MAP, GeeHashMap));
					_g_object_unref0 (matches_a);
					matches_a = _tmp24_;
				}
				{
					gint f = 0;
					f = i + 1;
					{
						gboolean _tmp25_ = FALSE;
						_tmp25_ = TRUE;
						while (TRUE) {
							FolksIndividual** _tmp27_;
							gint _tmp27__length1;
							FolksIndividual* b = NULL;
							FolksIndividual** _tmp28_;
							gint _tmp28__length1;
							FolksIndividual* _tmp29_;
							FolksIndividual* _tmp30_;
							GeeHashMap* _matches_b = NULL;
							GeeHashMap* _tmp31_;
							FolksIndividual* _tmp32_;
							gpointer _tmp33_;
							GeeHashMap* matches_b = NULL;
							GeeHashMap* _tmp34_;
							FolksMatchResult _result_ = 0;
							FolksPotentialMatch* _tmp41_;
							FolksIndividual* _tmp42_;
							FolksIndividual* _tmp43_;
							if (!_tmp25_) {
								gint _tmp26_;
								_tmp26_ = f;
								f = _tmp26_ + 1;
							}
							_tmp25_ = FALSE;
							_tmp27_ = individuals;
							_tmp27__length1 = individuals_length1;
							if (!(f < _tmp27__length1)) {
								break;
							}
							_tmp28_ = individuals;
							_tmp28__length1 = individuals_length1;
							_tmp29_ = _tmp28_[f];
							_tmp30_ = _g_object_ref0 (_tmp29_);
							b = _tmp30_;
							_tmp31_ = matches;
							_tmp32_ = b;
							_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp32_);
							_matches_b = (GeeHashMap*) _tmp33_;
							_tmp34_ = _matches_b;
							if (_tmp34_ == NULL) {
								GeeHashMap* _tmp35_;
								GeeHashMap* _tmp36_;
								FolksIndividual* _tmp37_;
								GeeHashMap* _tmp38_;
								_tmp35_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
								_g_object_unref0 (matches_b);
								matches_b = _tmp35_;
								_tmp36_ = matches;
								_tmp37_ = b;
								_tmp38_ = matches_b;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp37_, _tmp38_);
							} else {
								GeeHashMap* _tmp39_;
								GeeHashMap* _tmp40_;
								_tmp39_ = _matches_b;
								_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_HASH_MAP, GeeHashMap));
								_g_object_unref0 (matches_b);
								matches_b = _tmp40_;
							}
							_tmp41_ = matchObj;
							_tmp42_ = a;
							_tmp43_ = b;
							_result_ = folks_potential_match_potential_match (_tmp41_, _tmp42_, _tmp43_);
							if (_result_ >= min_threshold) {
								GeeHashMap* _tmp44_;
								FolksIndividual* _tmp45_;
								GeeHashMap* _tmp46_;
								FolksIndividual* _tmp47_;
								_tmp44_ = matches_a;
								_tmp45_ = b;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp44_, _tmp45_, (gpointer) ((gintptr) _result_));
								_tmp46_ = matches_b;
								_tmp47_ = a;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp46_, _tmp47_, (gpointer) ((gintptr) _result_));
							}
							_g_object_unref0 (matches_b);
							_g_object_unref0 (_matches_b);
							_g_object_unref0 (b);
						}
					}
				}
				_g_object_unref0 (matches_a);
				_g_object_unref0 (_matches_a);
				_g_object_unref0 (a);
			}
		}
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	individuals = (_vala_array_free (individuals, individuals_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static void
__folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender,
                                                                                                FolksPersonaStore* store,
                                                                                                gpointer self)
{
	_folks_individual_aggregator_backend_persona_store_added_cb ((FolksIndividualAggregator*) self, _sender, store);
}

static void
__folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender,
                                                                                                    FolksPersonaStore* store,
                                                                                                    gpointer self)
{
	_folks_individual_aggregator_backend_persona_store_removed_cb ((FolksIndividualAggregator*) self, _sender, store);
}

static void
__folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self)
{
	_folks_individual_aggregator_backend_is_quiescent_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}

static void
_folks_individual_aggregator_add_backend (FolksIndividualAggregator* self,
                                          FolksBackend* backend)
{
	FolksSmallSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = self->priv->_backends;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, backend)) {
		FolksSmallSet* _tmp1_;
		FolksPersonaStore** stores = NULL;
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		gint _tmp7_ = 0;
		gpointer* _tmp8_;
		FolksPersonaStore** _tmp9_;
		gint _tmp9__length1;
		gint stores_length1;
		gint _stores_size_;
		FolksPersonaStore** _tmp10_;
		gint _tmp10__length1;
		_tmp1_ = self->priv->_backends;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, backend);
		g_signal_connect_object (backend, "persona-store-added", (GCallback) __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, self, 0);
		g_signal_connect_object (backend, "persona-store-removed", (GCallback) __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, self, 0);
		g_signal_connect_object ((GObject*) backend, "notify::is-quiescent", (GCallback) __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify, self, 0);
		_tmp2_ = folks_backend_get_persona_stores (backend);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_map_get_values (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp8_ = gee_collection_to_array (_tmp6_, &_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _tmp7_;
		_g_object_unref0 (_tmp6_);
		stores = _tmp9_;
		stores_length1 = _tmp9__length1;
		_stores_size_ = stores_length1;
		_tmp10_ = stores;
		_tmp10__length1 = stores_length1;
		{
			FolksPersonaStore** persona_store_collection = NULL;
			gint persona_store_collection_length1 = 0;
			gint _persona_store_collection_size_ = 0;
			gint persona_store_it = 0;
			persona_store_collection = _tmp10_;
			persona_store_collection_length1 = _tmp10__length1;
			for (persona_store_it = 0; persona_store_it < persona_store_collection_length1; persona_store_it = persona_store_it + 1) {
				FolksPersonaStore* _tmp11_;
				FolksPersonaStore* persona_store = NULL;
				_tmp11_ = _g_object_ref0 (persona_store_collection[persona_store_it]);
				persona_store = _tmp11_;
				{
					FolksPersonaStore* _tmp12_;
					_tmp12_ = persona_store;
					_folks_individual_aggregator_backend_persona_store_added_cb (self, backend, _tmp12_);
					_g_object_unref0 (persona_store);
				}
			}
		}
		stores = (_vala_array_free (stores, stores_length1, (GDestroyNotify) g_object_unref), NULL);
	}
}

static gboolean
__folks_individual_aggregator_quiescent_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = _folks_individual_aggregator_quiescent_timeout_cb ((FolksIndividualAggregator*) self);
	return result;
}

static void
_folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self,
                                                   FolksBackendStore* backend_store,
                                                   FolksBackend* backend)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = folks_backend_get_is_quiescent (backend);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FALSE) {
		guint _tmp2_;
		_tmp2_ = self->priv->_non_quiescent_backend_count;
		self->priv->_non_quiescent_backend_count = _tmp2_ + 1;
		if (self->priv->_quiescent_timeout_id == ((guint) 0)) {
			self->priv->_quiescent_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, FOLKS_INDIVIDUAL_AGGREGATOR__QUIESCENT_TIMEOUT, __folks_individual_aggregator_quiescent_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	_folks_individual_aggregator_add_backend (self, backend);
}

static void
_folks_individual_aggregator_set_primary_store (FolksIndividualAggregator* self,
                                                FolksPersonaStore* store)
{
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_debug ("individual-aggregator.vala:946: _set_primary_store()");
	_tmp0_ = self->priv->_primary_store;
	if (_tmp0_ == store) {
		return;
	}
	_tmp1_ = folks_persona_store_get_type_id (store);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_configured_primary_store_type_id;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = folks_persona_store_get_type_id (store);
		_tmp7_ = _tmp6_;
		if (g_strcmp0 (_tmp7_, "eds") != 0) {
			const gchar* _tmp8_;
			_tmp8_ = self->priv->_configured_primary_store_id;
			_tmp5_ = g_strcmp0 (_tmp8_, "") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = self->priv->_configured_primary_store_id;
			_tmp10_ = folks_persona_store_get_id (store);
			_tmp11_ = _tmp10_;
			_tmp4_ = g_strcmp0 (_tmp9_, _tmp11_) == 0;
		}
		if (_tmp4_) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			FolksPersonaStore* previous_store = NULL;
			FolksPersonaStore* _tmp16_;
			FolksPersonaStore* _tmp17_;
			FolksPersonaStore* _tmp18_;
			FolksPersonaStore* _tmp21_;
			_tmp12_ = folks_persona_store_get_type_id (store);
			_tmp13_ = _tmp12_;
			_tmp14_ = folks_persona_store_get_id (store);
			_tmp15_ = _tmp14_;
			g_debug ("individual-aggregator.vala:963: Setting primary store to %p (type ID: " \
"%s, ID: %s)", store, _tmp13_, _tmp15_);
			_tmp16_ = self->priv->_primary_store;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			previous_store = _tmp17_;
			self->priv->_primary_store = store;
			g_object_freeze_notify ((GObject*) store);
			_tmp18_ = previous_store;
			if (_tmp18_ != NULL) {
				FolksPersonaStore* _tmp19_;
				FolksPersonaStore* _tmp20_;
				_tmp19_ = previous_store;
				g_object_freeze_notify ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
				_tmp20_ = previous_store;
				folks_persona_store_set_is_primary_store (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), FALSE);
			}
			folks_persona_store_set_is_primary_store (store, TRUE);
			_tmp21_ = previous_store;
			if (_tmp21_ != NULL) {
				FolksPersonaStore* _tmp22_;
				_tmp22_ = previous_store;
				g_object_thaw_notify ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
			}
			g_object_thaw_notify ((GObject*) store);
			g_object_notify ((GObject*) self, "primary-store");
			_g_object_unref0 (previous_store);
		}
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data2_->self;
		_g_free0 (_data2_->store_id);
		_g_object_unref0 (_data2_->store);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender,
                                                                                        GeeSet* added,
                                                                                        GeeSet* removed,
                                                                                        const gchar* message,
                                                                                        FolksPersona* actor,
                                                                                        FolksGroupDetailsChangeReason reason,
                                                                                        gpointer self)
{
	_folks_individual_aggregator_personas_changed_cb ((FolksIndividualAggregator*) self, _sender, added, removed, message, actor, reason);
}

static void
__folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self)
{
	_folks_individual_aggregator_is_primary_store_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}

static void
__folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify (GObject* _sender,
                                                                                     GParamSpec* pspec,
                                                                                     gpointer self)
{
	_folks_individual_aggregator_persona_store_is_quiescent_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}

static void
__folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify (GObject* _sender,
                                                                                            GParamSpec* pspec,
                                                                                            gpointer self)
{
	_folks_individual_aggregator_persona_store_is_user_set_default_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}

static void
__lambda69_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* _result_)
{
	FolksIndividualAggregator* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (_result_ != NULL);
	{
		folks_persona_store_prepare_finish (_data2_->store, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = _data2_->store_id;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning (_ ("Error preparing persona store ‘%s’: %s"), _tmp0_, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda69__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda69_ (self, source_object, res);
	block2_data_unref (self);
}

static void
_folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self,
                                                             FolksBackend* backend,
                                                             FolksPersonaStore* store)
{
	Block2Data* _data2_;
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GeeMap* _tmp15_;
	GeeMap* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (_data2_->store);
	_data2_->store = _tmp0_;
	_tmp1_ = folks_backend_get_name (backend);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_persona_store_get_id (_data2_->store);
	_tmp4_ = _tmp3_;
	g_debug ("individual-aggregator.vala:988: _backend_persona_store_added_cb(): bac" \
"kend: %s, store: %s (%p)", _tmp2_, _tmp4_, _data2_->store);
	_tmp5_ = folks_persona_store_get_type_id (_data2_->store);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_persona_store_get_id (_data2_->store);
	_tmp8_ = _tmp7_;
	_tmp9_ = _folks_individual_aggregator_get_store_full_id (self, _tmp6_, _tmp8_);
	_data2_->store_id = _tmp9_;
	_folks_individual_aggregator_maybe_configure_as_primary (self, _data2_->store);
	_folks_individual_aggregator_set_primary_store (self, _data2_->store);
	_tmp10_ = self->priv->_stores;
	_tmp11_ = _data2_->store_id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp11_, _data2_->store);
	g_signal_connect_object (_data2_->store, "personas-changed", (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	g_signal_connect_object ((GObject*) _data2_->store, "notify::is-primary-store", (GCallback) __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data2_->store, "notify::is-quiescent", (GCallback) __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data2_->store, "notify::is-user-set-default", (GCallback) __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify, self, 0);
	_tmp12_ = folks_persona_store_get_is_quiescent (_data2_->store);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == FALSE) {
		guint _tmp14_;
		_tmp14_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp14_ + 1;
		if (self->priv->_quiescent_timeout_id == ((guint) 0)) {
			self->priv->_quiescent_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, FOLKS_INDIVIDUAL_AGGREGATOR__QUIESCENT_TIMEOUT, __folks_individual_aggregator_quiescent_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	_tmp15_ = folks_persona_store_get_personas (_data2_->store);
	_tmp16_ = _tmp15_;
	_tmp17_ = gee_map_get_size (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ > 0) {
		GeeHashSet* persona_set = NULL;
		GeeHashSet* _tmp19_;
		GeeHashSet* _tmp32_;
		FolksSmallSet* _tmp33_;
		FolksSmallSet* _tmp34_;
		_tmp19_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		persona_set = _tmp19_;
		{
			GeeIterator* _p_it = NULL;
			GeeMap* _tmp20_;
			GeeMap* _tmp21_;
			GeeCollection* _tmp22_;
			GeeCollection* _tmp23_;
			GeeCollection* _tmp24_;
			GeeIterator* _tmp25_;
			GeeIterator* _tmp26_;
			_tmp20_ = folks_persona_store_get_personas (_data2_->store);
			_tmp21_ = _tmp20_;
			_tmp22_ = gee_map_get_values (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_;
			_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
			_tmp26_ = _tmp25_;
			_g_object_unref0 (_tmp24_);
			_p_it = _tmp26_;
			while (TRUE) {
				GeeIterator* _tmp27_;
				FolksPersona* p = NULL;
				GeeIterator* _tmp28_;
				gpointer _tmp29_;
				GeeHashSet* _tmp30_;
				FolksPersona* _tmp31_;
				_tmp27_ = _p_it;
				if (!gee_iterator_next (_tmp27_)) {
					break;
				}
				_tmp28_ = _p_it;
				_tmp29_ = gee_iterator_get (_tmp28_);
				p = (FolksPersona*) _tmp29_;
				_tmp30_ = persona_set;
				_tmp31_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		_tmp32_ = persona_set;
		_tmp33_ = folks_small_set_empty (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
		_tmp34_ = _tmp33_;
		_folks_individual_aggregator_personas_changed_cb (self, _data2_->store, (GeeSet*) _tmp32_, (GeeSet*) _tmp34_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (_tmp34_);
		_g_object_unref0 (persona_set);
	}
	folks_persona_store_prepare (_data2_->store, ___lambda69__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
_folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self,
                                                               FolksBackend* backend,
                                                               FolksPersonaStore* store)
{
	guint _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	guint _tmp5_;
	GQuark _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeHashSet* removed_personas = NULL;
	GeeHashSet* _tmp11_;
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeMapIterator* _tmp14_;
	FolksSmallSet* _tmp20_;
	FolksSmallSet* _tmp21_;
	GeeHashSet* _tmp22_;
	FolksPersonaStore* _tmp23_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	g_signal_parse_name ("notify::is-quiescent", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-primary-store", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-user-set-default", G_TYPE_OBJECT, &_tmp5_, &_tmp6_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify, self);
	if (self->priv->_is_quiescent == FALSE) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = folks_persona_store_get_is_quiescent (store);
		_tmp9_ = _tmp8_;
		_tmp7_ = _tmp9_ == FALSE;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		guint _tmp10_;
		_tmp10_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp10_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
	_tmp11_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed_personas = _tmp11_;
	_tmp12_ = folks_persona_store_get_personas (store);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_map_map_iterator (_tmp13_);
	iter = _tmp14_;
	while (TRUE) {
		GeeMapIterator* _tmp15_;
		GeeHashSet* _tmp16_;
		GeeMapIterator* _tmp17_;
		gpointer _tmp18_;
		FolksPersona* _tmp19_;
		_tmp15_ = iter;
		if (!(gee_map_iterator_next (_tmp15_) == TRUE)) {
			break;
		}
		_tmp16_ = removed_personas;
		_tmp17_ = iter;
		_tmp18_ = gee_map_iterator_get_value (_tmp17_);
		_tmp19_ = (FolksPersona*) _tmp18_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
		_g_object_unref0 (_tmp19_);
	}
	_tmp20_ = folks_small_set_empty (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	_tmp21_ = _tmp20_;
	_tmp22_ = removed_personas;
	_folks_individual_aggregator_personas_changed_cb (self, store, (GeeSet*) _tmp21_, (GeeSet*) _tmp22_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (_tmp21_);
	_tmp23_ = self->priv->_primary_store;
	if (_tmp23_ == store) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp24_ = folks_persona_store_get_type_id (store);
		_tmp25_ = _tmp24_;
		_tmp26_ = folks_persona_store_get_id (store);
		_tmp27_ = _tmp26_;
		g_debug ("Unsetting primary store as store %p (type ID: %s, ID: %s) " "has been removed", store, _tmp25_, _tmp27_);
		self->priv->_primary_store = NULL;
		g_object_notify ((GObject*) self, "primary-store");
	}
	_tmp28_ = self->priv->_stores;
	_tmp29_ = folks_persona_store_get_type_id (store);
	_tmp30_ = _tmp29_;
	_tmp31_ = folks_persona_store_get_id (store);
	_tmp32_ = _tmp31_;
	_tmp33_ = _folks_individual_aggregator_get_store_full_id (self, _tmp30_, _tmp32_);
	_tmp34_ = _tmp33_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp28_, _tmp34_, NULL);
	_g_free0 (_tmp34_);
	_g_object_unref0 (iter);
	_g_object_unref0 (removed_personas);
}

static gchar*
_folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self,
                                                const gchar* type_id,
                                                const gchar* id)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strconcat (type_id, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, id, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
_folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self,
                                                       GeeSet* added,
                                                       GeeSet* removed,
                                                       GeeMultiMap* changes,
                                                       const gchar* message,
                                                       FolksPersona* actor,
                                                       FolksGroupDetailsChangeReason reason)
{
	GeeSet* _added = NULL;
	GeeSet* _removed = NULL;
	GeeMultiMap* _changes = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeSet* _tmp11_ = NULL;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_ = NULL;
	GeeSet* _tmp18_;
	FolksDebug* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GeeSet* _tmp70_;
	GeeSet* _tmp71_;
	GeeSet* _tmp72_;
	GeeSet* _tmp73_;
	GeeSet* _tmp74_;
	GeeSet* _tmp75_;
	GeeSet* _tmp76_;
	GeeSet* _tmp77_;
	GeeMultiMap* _tmp78_;
	g_return_if_fail (self != NULL);
	if (added == NULL) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_SET, GeeSet));
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_ == 0;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		if (removed == NULL) {
			_tmp5_ = TRUE;
		} else {
			gint _tmp6_;
			gint _tmp7_;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_SET, GeeSet));
			_tmp7_ = _tmp6_;
			_tmp5_ = _tmp7_ == 0;
		}
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_ = FALSE;
		if (changes == NULL) {
			_tmp8_ = TRUE;
		} else {
			gint _tmp9_;
			gint _tmp10_;
			_tmp9_ = gee_multi_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (changes, GEE_TYPE_MULTI_MAP, GeeMultiMap));
			_tmp10_ = _tmp9_;
			_tmp8_ = _tmp10_ == 0;
		}
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_g_object_unref0 (_changes);
		_g_object_unref0 (_removed);
		_g_object_unref0 (_added);
		return;
	}
	folks_internal_profiling_point ("%s", "emitting " "IndividualAggregator::individuals-changed");
	if (added != NULL) {
		GeeSet* _tmp12_;
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_SET, GeeSet));
		_g_object_unref0 (_tmp11_);
		_tmp11_ = _tmp12_;
	} else {
		FolksSmallSet* _tmp13_;
		_tmp13_ = folks_small_set_empty (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
		_g_object_unref0 (_tmp11_);
		_tmp11_ = (GeeSet*) _tmp13_;
	}
	_tmp14_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (_added);
	_added = _tmp14_;
	if (removed != NULL) {
		GeeSet* _tmp16_;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_SET, GeeSet));
		_g_object_unref0 (_tmp15_);
		_tmp15_ = _tmp16_;
	} else {
		FolksSmallSet* _tmp17_;
		_tmp17_ = folks_small_set_empty (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
		_g_object_unref0 (_tmp15_);
		_tmp15_ = (GeeSet*) _tmp17_;
	}
	_tmp18_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (_removed);
	_removed = _tmp18_;
	if (changes != NULL) {
		GeeMultiMap* _tmp19_;
		_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (changes, GEE_TYPE_MULTI_MAP, GeeMultiMap));
		_g_object_unref0 (_changes);
		_changes = _tmp19_;
	} else {
		GeeHashMultiMap* _tmp20_;
		_tmp20_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (_changes);
		_changes = (GeeMultiMap*) _tmp20_;
	}
	_tmp21_ = self->priv->_debug;
	_tmp22_ = folks_debug_get_debug_output_enabled (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == TRUE) {
		GeeMultiMap* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		GeeMapIterator* iter = NULL;
		GeeMultiMap* _tmp27_;
		GeeMapIterator* _tmp28_;
		_tmp24_ = _changes;
		_tmp25_ = gee_multi_map_get_size (_tmp24_);
		_tmp26_ = _tmp25_;
		g_debug ("individual-aggregator.vala:1151: Emitting individuals-changed-detailed" \
" with %u mappings:", (guint) _tmp26_);
		_tmp27_ = _changes;
		_tmp28_ = gee_multi_map_map_iterator (_tmp27_);
		iter = _tmp28_;
		while (TRUE) {
			GeeMapIterator* _tmp29_;
			FolksIndividual* removed_ind = NULL;
			GeeMapIterator* _tmp30_;
			gpointer _tmp31_;
			FolksIndividual* added_ind = NULL;
			GeeMapIterator* _tmp32_;
			gpointer _tmp33_;
			const gchar* _tmp34_ = NULL;
			FolksIndividual* _tmp35_;
			const gchar* _tmp39_ = NULL;
			FolksIndividual* _tmp40_;
			FolksIndividual* _tmp44_;
			FolksIndividual* _tmp45_;
			FolksIndividual* _tmp46_;
			FolksIndividual* _tmp58_;
			_tmp29_ = iter;
			if (!gee_map_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = iter;
			_tmp31_ = gee_map_iterator_get_key (_tmp30_);
			removed_ind = (FolksIndividual*) _tmp31_;
			_tmp32_ = iter;
			_tmp33_ = gee_map_iterator_get_value (_tmp32_);
			added_ind = (FolksIndividual*) _tmp33_;
			_tmp35_ = removed_ind;
			if (_tmp35_ != NULL) {
				FolksIndividual* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = removed_ind;
				_tmp37_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp38_ = _tmp37_;
				_tmp34_ = _tmp38_;
			} else {
				_tmp34_ = "";
			}
			_tmp40_ = added_ind;
			if (_tmp40_ != NULL) {
				FolksIndividual* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				_tmp41_ = added_ind;
				_tmp42_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp43_ = _tmp42_;
				_tmp39_ = _tmp43_;
			} else {
				_tmp39_ = "";
			}
			_tmp44_ = removed_ind;
			_tmp45_ = added_ind;
			g_debug ("individual-aggregator.vala:1161:     %s (%p) → %s (%p)", _tmp34_, _tmp44_, _tmp39_, _tmp45_);
			_tmp46_ = removed_ind;
			if (_tmp46_ != NULL) {
				g_debug ("individual-aggregator.vala:1168:       Removed individual's personas:");
				{
					GeeIterator* _p_it = NULL;
					FolksIndividual* _tmp47_;
					GeeSet* _tmp48_;
					GeeSet* _tmp49_;
					GeeIterator* _tmp50_;
					_tmp47_ = removed_ind;
					_tmp48_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
					_tmp49_ = _tmp48_;
					_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
					_p_it = _tmp50_;
					while (TRUE) {
						GeeIterator* _tmp51_;
						FolksPersona* p = NULL;
						GeeIterator* _tmp52_;
						gpointer _tmp53_;
						FolksPersona* _tmp54_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						FolksPersona* _tmp57_;
						_tmp51_ = _p_it;
						if (!gee_iterator_next (_tmp51_)) {
							break;
						}
						_tmp52_ = _p_it;
						_tmp53_ = gee_iterator_get (_tmp52_);
						p = (FolksPersona*) _tmp53_;
						_tmp54_ = p;
						_tmp55_ = folks_persona_get_uid (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = p;
						g_debug ("individual-aggregator.vala:1172:         %s (%p)", _tmp56_, _tmp57_);
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_it);
				}
			}
			_tmp58_ = added_ind;
			if (_tmp58_ != NULL) {
				g_debug ("individual-aggregator.vala:1178:       Added individual's personas:");
				{
					GeeIterator* _p_it = NULL;
					FolksIndividual* _tmp59_;
					GeeSet* _tmp60_;
					GeeSet* _tmp61_;
					GeeIterator* _tmp62_;
					_tmp59_ = added_ind;
					_tmp60_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
					_tmp61_ = _tmp60_;
					_tmp62_ = gee_iterable_iterator ((GeeIterable*) _tmp61_);
					_p_it = _tmp62_;
					while (TRUE) {
						GeeIterator* _tmp63_;
						FolksPersona* p = NULL;
						GeeIterator* _tmp64_;
						gpointer _tmp65_;
						FolksPersona* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						FolksPersona* _tmp69_;
						_tmp63_ = _p_it;
						if (!gee_iterator_next (_tmp63_)) {
							break;
						}
						_tmp64_ = _p_it;
						_tmp65_ = gee_iterator_get (_tmp64_);
						p = (FolksPersona*) _tmp65_;
						_tmp66_ = p;
						_tmp67_ = folks_persona_get_uid (_tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = p;
						g_debug ("individual-aggregator.vala:1182:         %s (%p)", _tmp68_, _tmp69_);
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_it);
				}
			}
			_g_object_unref0 (added_ind);
			_g_object_unref0 (removed_ind);
		}
		_g_object_unref0 (iter);
	}
	_tmp70_ = _added;
	_tmp71_ = gee_set_get_read_only_view (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp74_ = _removed;
	_tmp75_ = gee_set_get_read_only_view (_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = _tmp76_;
	g_signal_emit (self, folks_individual_aggregator_signals[FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_CHANGED_SIGNAL], 0, _tmp73_, _tmp77_, message, actor, reason);
	_g_object_unref0 (_tmp77_);
	_g_object_unref0 (_tmp73_);
	_tmp78_ = _changes;
	g_signal_emit (self, folks_individual_aggregator_signals[FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_CHANGED_DETAILED_SIGNAL], 0, _tmp78_);
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_changes);
	_g_object_unref0 (_removed);
	_g_object_unref0 (_added);
}

static void
__folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender,
                                                                              FolksIndividual* replacement_individual,
                                                                              gpointer self)
{
	_folks_individual_aggregator_individual_removed_cb ((FolksIndividualAggregator*) self, _sender, replacement_individual);
}

static void
_folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self,
                                                    FolksIndividual* individual)
{
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	g_signal_connect_object (individual, "removed", (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
	_tmp0_ = self->priv->_individuals;
	_tmp1_ = folks_individual_get_id (individual);
	_tmp2_ = _tmp1_;
	gee_map_set (_tmp0_, _tmp2_, individual);
}

static void
_folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self,
                                                         FolksIndividual* individual)
{
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = self->priv->_individuals;
	_tmp1_ = folks_individual_get_id (individual);
	_tmp2_ = _tmp1_;
	gee_map_unset (_tmp0_, _tmp2_, NULL);
	g_signal_parse_name ("removed", FOLKS_TYPE_INDIVIDUAL, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (individual, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->candidate_inds);
		_g_object_unref0 (_data3_->persona);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data4_->_data3_->self;
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_______lambda67_ (Block4Data* _data4_,
                  const gchar* l)
{
	Block3Data* _data3_;
	FolksIndividualAggregator* self;
	const gchar* prop_linking_value = NULL;
	GPtrArray* candidates = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	GPtrArray* _tmp3_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_if_fail (l != NULL);
	prop_linking_value = l;
	_tmp0_ = self->priv->_link_map;
	_tmp1_ = prop_linking_value;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	candidates = (GPtrArray*) _tmp2_;
	_tmp3_ = candidates;
	if (_tmp3_ != NULL) {
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					FolksIndividual* candidate_ind = NULL;
					GPtrArray* _tmp9_;
					gconstpointer _tmp10_;
					FolksIndividual* _tmp11_;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					FolksIndividual* _tmp14_;
					FolksTrustLevel _tmp15_;
					FolksTrustLevel _tmp16_;
					if (!_tmp4_) {
						guint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = candidates;
					_tmp7_ = vala_g_ptr_array_get_length ((GPtrArray*) _tmp6_);
					_tmp8_ = _tmp7_;
					if (!(i < ((guint) _tmp8_))) {
						break;
					}
					_tmp9_ = candidates;
					_tmp10_ = g_ptr_array_index ((GPtrArray*) _tmp9_, i);
					_tmp11_ = _g_object_ref0 ((FolksIndividual*) _tmp10_);
					candidate_ind = _tmp11_;
					_tmp14_ = candidate_ind;
					_tmp15_ = folks_individual_get_trust_level (_tmp14_);
					_tmp16_ = _tmp15_;
					if (_tmp16_ != FOLKS_TRUST_LEVEL_NONE) {
						FolksIndividual* _tmp17_;
						FolksPersona* _tmp18_;
						_tmp17_ = candidate_ind;
						_tmp18_ = _data3_->persona;
						_tmp13_ = folks_individual_has_anti_link_with_persona (_tmp17_, _tmp18_) == FALSE;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						GeeHashSet* _tmp19_;
						FolksIndividual* _tmp20_;
						_tmp19_ = _data3_->candidate_inds;
						_tmp20_ = candidate_ind;
						_tmp12_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						FolksIndividual* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp21_ = candidate_ind;
						_tmp22_ = folks_individual_get_id (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = _data4_->prop_name;
						_tmp25_ = prop_linking_value;
						g_debug ("    Found candidate individual '%s'" " by linkable property '%s' = '%s'.", _tmp23_, _tmp24_, _tmp25_);
					}
					_g_object_unref0 (candidate_ind);
				}
			}
		}
	}
}

static void
________lambda67__folks_persona_linkable_property_callback (const gchar* link,
                                                            gpointer self)
{
	_______lambda67_ (self, link);
}

static void
_folks_individual_aggregator_add_personas (FolksIndividualAggregator* self,
                                           GeeSet* added,
                                           FolksIndividual** user,
                                           GeeHashMultiMap** individuals_changes)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (*individuals_changes != NULL);
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_persona_it = _tmp0_;
		while (TRUE) {
			Block3Data* _data3_;
			GeeIterator* _tmp1_;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			FolksPersonaStoreTrust trust_level = 0;
			FolksPersona* _tmp4_;
			FolksPersonaStore* _tmp5_;
			FolksPersonaStore* _tmp6_;
			FolksPersonaStoreTrust _tmp7_;
			FolksPersonaStoreTrust _tmp8_;
			GeeHashSet* _tmp9_;
			GeeHashSet* final_personas = NULL;
			GeeHashSet* _tmp10_;
			FolksPersona* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			FolksPersona* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp56_ = FALSE;
			GeeHashSet* _tmp76_;
			FolksPersona* _tmp77_;
			gboolean _tmp78_ = FALSE;
			gboolean _tmp82_ = FALSE;
			GeeHashSet* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			FolksIndividual* final_individual = NULL;
			GeeHashSet* _tmp95_;
			FolksIndividual* _tmp96_;
			FolksIndividual* _tmp97_;
			const gchar* _tmp98_;
			const gchar* _tmp99_;
			FolksIndividual* _tmp100_;
			guint num_mappings_added = 0U;
			FolksIndividual* _tmp148_;
			gboolean _tmp149_;
			gboolean _tmp150_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->self = g_object_ref (self);
			_tmp1_ = _persona_it;
			if (!gee_iterator_next (_tmp1_)) {
				block3_data_unref (_data3_);
				_data3_ = NULL;
				break;
			}
			_tmp2_ = _persona_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			_data3_->persona = (FolksPersona*) _tmp3_;
			_tmp4_ = _data3_->persona;
			_tmp5_ = folks_persona_get_store (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = folks_persona_store_get_trust_level (_tmp6_);
			_tmp8_ = _tmp7_;
			trust_level = _tmp8_;
			_tmp9_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_data3_->candidate_inds = _tmp9_;
			_tmp10_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			final_personas = _tmp10_;
			_tmp11_ = _data3_->persona;
			_tmp12_ = folks_persona_get_uid (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _data3_->persona;
			_tmp15_ = folks_persona_get_iid (_tmp14_);
			_tmp16_ = _tmp15_;
			g_debug ("individual-aggregator.vala:1224: Aggregating persona '%s' on '%s'.", _tmp13_, _tmp16_);
			if (self->priv->_linking_enabled == TRUE) {
				FolksPersona* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				_tmp20_ = _data3_->persona;
				_tmp21_ = folks_persona_get_is_user (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp19_ = _tmp22_ == TRUE;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				_tmp18_ = (*user) != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				FolksPersona* _tmp23_;
				_tmp23_ = _data3_->persona;
				_tmp17_ = folks_individual_has_anti_link_with_persona (G_TYPE_CHECK_INSTANCE_CAST (*user, FOLKS_TYPE_INDIVIDUAL, FolksIndividual), _tmp23_) == FALSE;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				GeeHashSet* _tmp26_;
				_tmp24_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (*user, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp25_ = _tmp24_;
				g_debug ("individual-aggregator.vala:1232:     Found candidate individual '%s' a" \
"s user.", _tmp25_);
				_tmp26_ = _data3_->candidate_inds;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (*user, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			if (self->priv->_linking_enabled == TRUE) {
				_tmp27_ = trust_level != FOLKS_PERSONA_STORE_TRUST_NONE;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				GPtrArray* candidates = NULL;
				GHashTable* _tmp28_;
				FolksPersona* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gconstpointer _tmp32_;
				GPtrArray* _tmp33_;
				_tmp28_ = self->priv->_link_map;
				_tmp29_ = _data3_->persona;
				_tmp30_ = folks_persona_get_iid (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_hash_table_lookup (_tmp28_, _tmp31_);
				candidates = (GPtrArray*) _tmp32_;
				_tmp33_ = candidates;
				if (_tmp33_ != NULL) {
					{
						guint i = 0U;
						i = (guint) 0;
						{
							gboolean _tmp34_ = FALSE;
							_tmp34_ = TRUE;
							while (TRUE) {
								GPtrArray* _tmp36_;
								gint _tmp37_;
								gint _tmp38_;
								FolksIndividual* candidate_ind = NULL;
								GPtrArray* _tmp39_;
								gconstpointer _tmp40_;
								gboolean _tmp41_ = FALSE;
								gboolean _tmp42_ = FALSE;
								FolksIndividual* _tmp43_;
								FolksTrustLevel _tmp44_;
								FolksTrustLevel _tmp45_;
								if (!_tmp34_) {
									guint _tmp35_;
									_tmp35_ = i;
									i = _tmp35_ + 1;
								}
								_tmp34_ = FALSE;
								_tmp36_ = candidates;
								_tmp37_ = vala_g_ptr_array_get_length ((GPtrArray*) _tmp36_);
								_tmp38_ = _tmp37_;
								if (!(i < ((guint) _tmp38_))) {
									break;
								}
								_tmp39_ = candidates;
								_tmp40_ = g_ptr_array_index ((GPtrArray*) _tmp39_, i);
								candidate_ind = (FolksIndividual*) _tmp40_;
								_tmp43_ = candidate_ind;
								_tmp44_ = folks_individual_get_trust_level (_tmp43_);
								_tmp45_ = _tmp44_;
								if (_tmp45_ != FOLKS_TRUST_LEVEL_NONE) {
									FolksIndividual* _tmp46_;
									FolksPersona* _tmp47_;
									_tmp46_ = candidate_ind;
									_tmp47_ = _data3_->persona;
									_tmp42_ = folks_individual_has_anti_link_with_persona (_tmp46_, _tmp47_) == FALSE;
								} else {
									_tmp42_ = FALSE;
								}
								if (_tmp42_) {
									GeeHashSet* _tmp48_;
									FolksIndividual* _tmp49_;
									_tmp48_ = _data3_->candidate_inds;
									_tmp49_ = candidate_ind;
									_tmp41_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
								} else {
									_tmp41_ = FALSE;
								}
								if (_tmp41_) {
									FolksIndividual* _tmp50_;
									const gchar* _tmp51_;
									const gchar* _tmp52_;
									FolksPersona* _tmp53_;
									const gchar* _tmp54_;
									const gchar* _tmp55_;
									_tmp50_ = candidate_ind;
									_tmp51_ = folks_individual_get_id (_tmp50_);
									_tmp52_ = _tmp51_;
									_tmp53_ = _data3_->persona;
									_tmp54_ = folks_persona_get_iid (_tmp53_);
									_tmp55_ = _tmp54_;
									g_debug ("    Found candidate individual '%s' by " "IID '%s'.", _tmp52_, _tmp55_);
								}
							}
						}
					}
				}
			}
			if (self->priv->_linking_enabled == TRUE) {
				FolksPersona* _tmp57_;
				FolksPersonaStore* _tmp58_;
				FolksPersonaStore* _tmp59_;
				FolksPersonaStoreTrust _tmp60_;
				FolksPersonaStoreTrust _tmp61_;
				_tmp57_ = _data3_->persona;
				_tmp58_ = folks_persona_get_store (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = folks_persona_store_get_trust_level (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp56_ = _tmp61_ == FOLKS_PERSONA_STORE_TRUST_FULL;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				FolksPersona* _tmp62_;
				gchar** _tmp63_;
				gint _tmp63__length1;
				gint _tmp64_ = 0;
				gchar** _tmp65_;
				gint _tmp65__length1;
				_tmp62_ = _data3_->persona;
				_tmp63_ = folks_persona_get_linkable_properties (_tmp62_, &_tmp64_);
				_tmp63__length1 = _tmp64_;
				_tmp65_ = _tmp63_;
				_tmp65__length1 = _tmp63__length1;
				{
					gchar** foo_collection = NULL;
					gint foo_collection_length1 = 0;
					gint _foo_collection_size_ = 0;
					gint foo_it = 0;
					foo_collection = _tmp65_;
					foo_collection_length1 = _tmp65__length1;
					for (foo_it = 0; foo_it < foo_collection_length1; foo_it = foo_it + 1) {
						const gchar* foo = NULL;
						foo = foo_collection[foo_it];
						{
							Block4Data* _data4_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							GObjectClass* pclass = NULL;
							FolksPersona* _tmp68_;
							GObjectClass* _tmp69_;
							GObjectClass* _tmp70_;
							const gchar* _tmp71_;
							GParamSpec* _tmp72_;
							FolksPersona* _tmp74_;
							const gchar* _tmp75_;
							_data4_ = g_slice_new0 (Block4Data);
							_data4_->_ref_count_ = 1;
							_data4_->_data3_ = block3_data_ref (_data3_);
							_tmp66_ = foo;
							if (_tmp66_ == NULL) {
								block4_data_unref (_data4_);
								_data4_ = NULL;
								continue;
							}
							_tmp67_ = foo;
							_data4_->prop_name = _tmp67_;
							_tmp68_ = _data3_->persona;
							_tmp69_ = G_OBJECT_GET_CLASS ((GObject*) _tmp68_);
							pclass = _tmp69_;
							_tmp70_ = pclass;
							_tmp71_ = _data4_->prop_name;
							_tmp72_ = g_object_class_find_property (_tmp70_, _tmp71_);
							if (_tmp72_ == NULL) {
								const gchar* _tmp73_;
								_tmp73_ = _data4_->prop_name;
								g_warning (_ ("Unknown property ‘%s’ in linkable property list."), _tmp73_);
								block4_data_unref (_data4_);
								_data4_ = NULL;
								continue;
							}
							_tmp74_ = _data3_->persona;
							_tmp75_ = _data4_->prop_name;
							folks_persona_linkable_property_to_links (_tmp74_, _tmp75_, ________lambda67__folks_persona_linkable_property_callback, _data4_);
							block4_data_unref (_data4_);
							_data4_ = NULL;
						}
					}
				}
			}
			_tmp76_ = final_personas;
			_tmp77_ = _data3_->persona;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
			if (self->priv->_linking_enabled == TRUE) {
				_tmp78_ = TRUE;
			} else {
				GeeHashSet* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				_tmp79_ = _data3_->candidate_inds;
				_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp78_ = _tmp81_ == 0;
			}
			_vala_assert (_tmp78_, "this._linking_enabled == true || candidate_inds.size == 0");
			_tmp83_ = _data3_->candidate_inds;
			_tmp84_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp85_ > 0) {
				_tmp82_ = self->priv->_linking_enabled == TRUE;
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				{
					GeeIterator* _individual_it = NULL;
					GeeHashSet* _tmp86_;
					GeeIterator* _tmp87_;
					_tmp86_ = _data3_->candidate_inds;
					_tmp87_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp86_);
					_individual_it = _tmp87_;
					while (TRUE) {
						GeeIterator* _tmp88_;
						FolksIndividual* individual = NULL;
						GeeIterator* _tmp89_;
						gpointer _tmp90_;
						GeeHashSet* _tmp91_;
						FolksIndividual* _tmp92_;
						GeeSet* _tmp93_;
						GeeSet* _tmp94_;
						_tmp88_ = _individual_it;
						if (!gee_iterator_next (_tmp88_)) {
							break;
						}
						_tmp89_ = _individual_it;
						_tmp90_ = gee_iterator_get (_tmp89_);
						individual = (FolksIndividual*) _tmp90_;
						_tmp91_ = final_personas;
						_tmp92_ = individual;
						_tmp93_ = folks_individual_get_personas (_tmp92_);
						_tmp94_ = _tmp93_;
						gee_collection_add_all ((GeeCollection*) _tmp91_, (GeeCollection*) _tmp94_);
						_g_object_unref0 (individual);
					}
					_g_object_unref0 (_individual_it);
				}
			} else {
				if (!self->priv->_linking_enabled) {
					g_debug ("individual-aggregator.vala:1336:     Linking disabled.");
				} else {
					g_debug ("individual-aggregator.vala:1340:     Did not find any candidate indivi" \
"duals.");
				}
			}
			_tmp95_ = final_personas;
			_tmp96_ = folks_individual_new ((GeeSet*) _tmp95_);
			final_individual = _tmp96_;
			_tmp97_ = final_individual;
			_tmp98_ = folks_individual_get_id (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = final_individual;
			g_debug ("individual-aggregator.vala:1345:     Created new individual '%s' (%p) " \
"with personas:", _tmp99_, _tmp100_);
			{
				GeeIterator* _p_it = NULL;
				GeeHashSet* _tmp101_;
				GeeIterator* _tmp102_;
				_tmp101_ = final_personas;
				_tmp102_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp101_);
				_p_it = _tmp102_;
				while (TRUE) {
					GeeIterator* _tmp103_;
					FolksPersona* p = NULL;
					GeeIterator* _tmp104_;
					gpointer _tmp105_;
					FolksPersona* _tmp106_;
					const gchar* _tmp107_;
					const gchar* _tmp108_;
					FolksPersona* _tmp109_;
					FolksPersona* _tmp110_;
					FolksIndividual* _tmp111_;
					_tmp103_ = _p_it;
					if (!gee_iterator_next (_tmp103_)) {
						break;
					}
					_tmp104_ = _p_it;
					_tmp105_ = gee_iterator_get (_tmp104_);
					p = (FolksPersona*) _tmp105_;
					_tmp106_ = p;
					_tmp107_ = folks_persona_get_uid (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = p;
					g_debug ("individual-aggregator.vala:1349:         %s (%p)", _tmp108_, _tmp109_);
					_tmp110_ = p;
					_tmp111_ = final_individual;
					_folks_individual_aggregator_add_persona_to_link_map (self, _tmp110_, _tmp111_);
					_g_object_unref0 (p);
				}
				_g_object_unref0 (_p_it);
			}
			num_mappings_added = (guint) 0;
			{
				GeeIterator* _i_it = NULL;
				GeeHashSet* _tmp112_;
				GeeIterator* _tmp113_;
				_tmp112_ = _data3_->candidate_inds;
				_tmp113_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp112_);
				_i_it = _tmp113_;
				while (TRUE) {
					GeeIterator* _tmp114_;
					FolksIndividual* i = NULL;
					GeeIterator* _tmp115_;
					gpointer _tmp116_;
					FolksIndividual* _tmp117_;
					GeeHashSet* transitive_updates = NULL;
					GeeHashSet* _tmp118_;
					GeeMapIterator* iter = NULL;
					GeeMapIterator* _tmp119_;
					GeeHashSet* _tmp141_;
					gint _tmp142_;
					gint _tmp143_;
					_tmp114_ = _i_it;
					if (!gee_iterator_next (_tmp114_)) {
						break;
					}
					_tmp115_ = _i_it;
					_tmp116_ = gee_iterator_get (_tmp115_);
					i = (FolksIndividual*) _tmp116_;
					_tmp117_ = i;
					_folks_individual_aggregator_remove_individual_from_link_map (self, _tmp117_);
					_tmp118_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
					transitive_updates = _tmp118_;
					_tmp119_ = gee_multi_map_map_iterator ((GeeMultiMap*) (*individuals_changes));
					iter = _tmp119_;
					while (TRUE) {
						GeeMapIterator* _tmp120_;
						FolksIndividual* _tmp121_;
						GeeMapIterator* _tmp122_;
						gpointer _tmp123_;
						FolksIndividual* _tmp124_;
						gboolean _tmp125_;
						_tmp120_ = iter;
						if (!gee_map_iterator_next (_tmp120_)) {
							break;
						}
						_tmp121_ = i;
						_tmp122_ = iter;
						_tmp123_ = gee_map_iterator_get_value (_tmp122_);
						_tmp124_ = (FolksIndividual*) _tmp123_;
						_tmp125_ = _tmp121_ == _tmp124_;
						_g_object_unref0 (_tmp124_);
						if (_tmp125_) {
							GeeHashSet* _tmp126_;
							GeeMapIterator* _tmp127_;
							gpointer _tmp128_;
							FolksIndividual* _tmp129_;
							_tmp126_ = transitive_updates;
							_tmp127_ = iter;
							_tmp128_ = gee_map_iterator_get_key (_tmp127_);
							_tmp129_ = (FolksIndividual*) _tmp128_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp126_, _tmp129_);
							_g_object_unref0 (_tmp129_);
						}
					}
					{
						GeeIterator* _k_it = NULL;
						GeeHashSet* _tmp130_;
						GeeIterator* _tmp131_;
						_tmp130_ = transitive_updates;
						_tmp131_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp130_);
						_k_it = _tmp131_;
						while (TRUE) {
							GeeIterator* _tmp132_;
							FolksIndividual* k = NULL;
							GeeIterator* _tmp133_;
							gpointer _tmp134_;
							FolksIndividual* _tmp135_;
							FolksIndividual* _tmp136_;
							FolksIndividual* _tmp137_;
							_tmp132_ = _k_it;
							if (!gee_iterator_next (_tmp132_)) {
								break;
							}
							_tmp133_ = _k_it;
							_tmp134_ = gee_iterator_get (_tmp133_);
							k = (FolksIndividual*) _tmp134_;
							_tmp135_ = k;
							_tmp136_ = i;
							_vala_assert (gee_multi_map_remove ((GeeMultiMap*) (*individuals_changes), _tmp135_, _tmp136_) == TRUE, "individuals_changes.remove (k, i) == true");
							_tmp137_ = k;
							if (_tmp137_ != NULL) {
								FolksIndividual* _tmp138_;
								FolksIndividual* _tmp139_;
								guint _tmp140_;
								_tmp138_ = k;
								_tmp139_ = final_individual;
								gee_multi_map_set ((GeeMultiMap*) (*individuals_changes), _tmp138_, _tmp139_);
								_tmp140_ = num_mappings_added;
								num_mappings_added = _tmp140_ + 1;
							}
							_g_object_unref0 (k);
						}
						_g_object_unref0 (_k_it);
					}
					_tmp141_ = transitive_updates;
					_tmp142_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp141_);
					_tmp143_ = _tmp142_;
					if (_tmp143_ == 0) {
						FolksIndividual* _tmp144_;
						FolksIndividual* _tmp145_;
						guint _tmp146_;
						_tmp144_ = i;
						_tmp145_ = final_individual;
						gee_multi_map_set ((GeeMultiMap*) (*individuals_changes), _tmp144_, _tmp145_);
						_tmp146_ = num_mappings_added;
						num_mappings_added = _tmp146_ + 1;
					}
					_g_object_unref0 (iter);
					_g_object_unref0 (transitive_updates);
					_g_object_unref0 (i);
				}
				_g_object_unref0 (_i_it);
			}
			if (num_mappings_added == ((guint) 0)) {
				FolksIndividual* _tmp147_;
				_tmp147_ = final_individual;
				gee_multi_map_set ((GeeMultiMap*) (*individuals_changes), NULL, _tmp147_);
			}
			_tmp148_ = final_individual;
			_tmp149_ = folks_individual_get_is_user (_tmp148_);
			_tmp150_ = _tmp149_;
			if (_tmp150_ == TRUE) {
				FolksIndividual* _tmp151_;
				FolksIndividual* _tmp152_;
				_tmp151_ = final_individual;
				_tmp152_ = _g_object_ref0 (_tmp151_);
				_g_object_unref0 (*user);
				*user = _tmp152_;
			}
			_g_object_unref0 (final_individual);
			_g_object_unref0 (final_personas);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		_g_object_unref0 (_persona_it);
	}
}

static void
_folks_individual_aggregator_persona_linkable_property_changed_cb (FolksIndividualAggregator* self,
                                                                   GObject* obj,
                                                                   GParamSpec* pspec)
{
	FolksPersona* persona = NULL;
	const gchar* _tmp0_ = NULL;
	FolksPersona* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	FolksPersona* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FolksPersona* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FolksSmallSet* persona_set = NULL;
	FolksSmallSet* _tmp11_;
	FolksSmallSet* _tmp12_;
	FolksPersona* _tmp13_;
	FolksPersona* _tmp14_;
	FolksPersonaStore* _tmp15_;
	FolksPersonaStore* _tmp16_;
	FolksSmallSet* _tmp17_;
	FolksSmallSet* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (self->priv->_linking_enabled == FALSE) {
		return;
	}
	persona = G_TYPE_CHECK_INSTANCE_CAST (FOLKS_IS_PERSONA (obj) ? ((FolksPersona*) obj) : NULL, FOLKS_TYPE_PERSONA, FolksPersona);
	_tmp1_ = persona;
	_tmp2_ = folks_persona_get_is_user (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp4_ = pspec->name;
	_tmp5_ = persona;
	_tmp6_ = folks_persona_get_uid (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = persona;
	_tmp9_ = folks_persona_get_iid (_tmp8_);
	_tmp10_ = _tmp9_;
	g_debug ("Linkable property '%s' changed for persona '%s' " "(is user: %s, IID: %s).", _tmp4_, _tmp7_, _tmp0_, _tmp10_);
	_tmp11_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	persona_set = _tmp11_;
	_tmp12_ = persona_set;
	_tmp13_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
	_tmp14_ = persona;
	_tmp15_ = folks_persona_get_store (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = persona_set;
	_tmp18_ = persona_set;
	_folks_individual_aggregator_personas_changed_cb (self, _tmp16_, (GeeSet*) _tmp17_, (GeeSet*) _tmp18_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (persona_set);
}

static void
_folks_individual_aggregator_persona_anti_links_changed_cb (FolksIndividualAggregator* self,
                                                            GObject* obj,
                                                            GParamSpec* pspec)
{
	FolksPersona* persona = NULL;
	const gchar* _tmp0_ = NULL;
	FolksPersona* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	FolksPersona* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksPersona* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FolksSmallSet* persona_set = NULL;
	FolksSmallSet* _tmp10_;
	FolksPersona* _tmp11_;
	FolksPersona* _tmp12_;
	FolksPersonaStore* _tmp13_;
	FolksPersonaStore* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	persona = FOLKS_IS_PERSONA (obj) ? ((FolksPersona*) obj) : NULL;
	_tmp1_ = persona;
	_tmp2_ = folks_persona_get_is_user (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp4_ = persona;
	_tmp5_ = folks_persona_get_uid (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = persona;
	_tmp8_ = folks_persona_get_iid (_tmp7_);
	_tmp9_ = _tmp8_;
	g_debug ("individual-aggregator.vala:1449: Anti-links changed for persona '%s' (" \
"is user: %s, IID: %s).", _tmp6_, _tmp0_, _tmp9_);
	_tmp10_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	persona_set = _tmp10_;
	_tmp11_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) persona_set, _tmp11_);
	_tmp12_ = persona;
	_tmp13_ = folks_persona_get_store (_tmp12_);
	_tmp14_ = _tmp13_;
	_folks_individual_aggregator_personas_changed_cb (self, _tmp14_, (GeeSet*) persona_set, (GeeSet*) persona_set, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (persona_set);
}

static void
__folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	_folks_individual_aggregator_persona_linkable_property_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}

static void
__folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	_folks_individual_aggregator_persona_anti_links_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}

static void
_folks_individual_aggregator_connect_to_persona (FolksIndividualAggregator* self,
                                                 FolksPersona* persona)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	FolksAntiLinkable* al = NULL;
	FolksAntiLinkable* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_linkable_properties (persona, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp2_;
		prop_name_collection_length1 = _tmp2__length1;
		for (prop_name_it = 0; prop_name_it < prop_name_collection_length1; prop_name_it = prop_name_it + 1) {
			const gchar* prop_name = NULL;
			prop_name = prop_name_collection[prop_name_it];
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp3_ = prop_name;
				if (_tmp3_ == NULL) {
					continue;
				}
				_tmp4_ = prop_name;
				_tmp5_ = g_strconcat ("notify::", _tmp4_, NULL);
				g_signal_connect_object ((GObject*) persona, _tmp5_, (GCallback) __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify, self, 0);
				_g_free0 (_tmp5_);
			}
		}
	}
	al = FOLKS_IS_ANTI_LINKABLE (persona) ? ((FolksAntiLinkable*) persona) : NULL;
	_tmp6_ = al;
	if (_tmp6_ != NULL) {
		FolksAntiLinkable* _tmp7_;
		_tmp7_ = al;
		g_signal_connect_object ((GObject*) _tmp7_, "notify::anti-links", (GCallback) __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify, self, 0);
	}
}

static void
_folks_individual_aggregator_disconnect_from_persona (FolksIndividualAggregator* self,
                                                      FolksPersona* persona)
{
	FolksAntiLinkable* al = NULL;
	FolksAntiLinkable* _tmp0_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	al = FOLKS_IS_ANTI_LINKABLE (persona) ? ((FolksAntiLinkable*) persona) : NULL;
	_tmp0_ = al;
	if (_tmp0_ != NULL) {
		FolksAntiLinkable* _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		_tmp1_ = al;
		g_signal_parse_name ("notify::anti-links", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify, self);
	}
	_tmp4_ = folks_persona_get_linkable_properties (persona, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp6_;
		prop_name_collection_length1 = _tmp6__length1;
		for (prop_name_it = 0; prop_name_it < prop_name_collection_length1; prop_name_it = prop_name_it + 1) {
			const gchar* prop_name = NULL;
			prop_name = prop_name_collection[prop_name_it];
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				guint _tmp10_;
				GQuark _tmp11_;
				_tmp7_ = prop_name;
				if (_tmp7_ == NULL) {
					continue;
				}
				_tmp8_ = prop_name;
				_tmp9_ = g_strconcat ("notify::", _tmp8_, NULL);
				g_signal_parse_name (_tmp9_, G_TYPE_OBJECT, &_tmp10_, &_tmp11_, TRUE);
				g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, _tmp11_, NULL, (GCallback) __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify, self);
				_g_free0 (_tmp9_);
			}
		}
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
_folks_individual_aggregator_link_map_set (FolksIndividualAggregator* self,
                                           const gchar* key,
                                           FolksIndividual* individual)
{
	GPtrArray* inds = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp17_;
	FolksIndividual* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = self->priv->_link_map;
	_tmp1_ = g_hash_table_lookup (_tmp0_, key);
	inds = (GPtrArray*) _tmp1_;
	_tmp2_ = inds;
	if (_tmp2_ == NULL) {
		GPtrArray* new_inds = NULL;
		GPtrArray* _tmp3_;
		GHashTable* _tmp4_;
		gchar* _tmp5_;
		GPtrArray* _tmp6_;
		GPtrArray* _tmp7_;
		GPtrArray* _tmp8_;
		FolksIndividual* _tmp9_;
		_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		new_inds = _tmp3_;
		_tmp4_ = self->priv->_link_map;
		_tmp5_ = g_strdup (key);
		_tmp6_ = new_inds;
		_tmp7_ = _g_ptr_array_ref0 (_tmp6_);
		g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
		_tmp8_ = new_inds;
		_tmp9_ = _g_object_ref0 (individual);
		g_ptr_array_add (_tmp8_, _tmp9_);
		_g_ptr_array_unref0 (new_inds);
		return;
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GPtrArray* _tmp15_;
				gconstpointer _tmp16_;
				if (!_tmp10_) {
					guint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = inds;
				_tmp13_ = vala_g_ptr_array_get_length ((GPtrArray*) _tmp12_);
				_tmp14_ = _tmp13_;
				if (!(i < ((guint) _tmp14_))) {
					break;
				}
				_tmp15_ = inds;
				_tmp16_ = g_ptr_array_index ((GPtrArray*) _tmp15_, i);
				if (((FolksIndividual*) _tmp16_) == individual) {
					return;
				}
			}
		}
	}
	_tmp17_ = inds;
	_tmp18_ = _g_object_ref0 (individual);
	g_ptr_array_add ((GPtrArray*) _tmp17_, _tmp18_);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->individual);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_____lambda68_ (Block5Data* _data5_,
                const gchar* l)
{
	FolksIndividualAggregator* self;
	const gchar* prop_linking_value = NULL;
	self = _data5_->self;
	g_return_if_fail (l != NULL);
	prop_linking_value = l;
	g_debug ("individual-aggregator.vala:1565:             %s", prop_linking_value);
	_folks_individual_aggregator_link_map_set (self, prop_linking_value, _data5_->individual);
}

static void
______lambda68__folks_persona_linkable_property_callback (const gchar* link,
                                                          gpointer self)
{
	_____lambda68_ (self, link);
}

static void
_folks_individual_aggregator_add_persona_to_link_map (FolksIndividualAggregator* self,
                                                      FolksPersona* persona,
                                                      FolksIndividual* individual)
{
	Block5Data* _data5_;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	FolksPersonaStore* _tmp12_;
	FolksPersonaStore* _tmp13_;
	FolksPersonaStoreTrust _tmp14_;
	FolksPersonaStoreTrust _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (individual != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data5_->individual);
	_data5_->individual = _tmp0_;
	_tmp2_ = folks_persona_get_is_user (persona);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp4_ = folks_persona_get_uid (persona);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_persona_get_iid (persona);
	_tmp7_ = _tmp6_;
	g_debug ("individual-aggregator.vala:1526: Connecting to Persona: %s (is user: %" \
"s, IID: %s)", _tmp5_, _tmp1_, _tmp7_);
	_tmp8_ = folks_individual_get_id (_data5_->individual);
	_tmp9_ = _tmp8_;
	g_debug ("individual-aggregator.vala:1528:     Mapping to Individual: %s", _tmp9_);
	_tmp10_ = folks_persona_get_iid (persona);
	_tmp11_ = _tmp10_;
	_folks_individual_aggregator_link_map_set (self, _tmp11_, _data5_->individual);
	_tmp12_ = folks_persona_get_store (persona);
	_tmp13_ = _tmp12_;
	_tmp14_ = folks_persona_store_get_trust_level (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_ = 0;
		gchar** _tmp18_;
		gint _tmp18__length1;
		g_debug ("individual-aggregator.vala:1539:     Inserting links:");
		_tmp16_ = folks_persona_get_linkable_properties (persona, &_tmp17_);
		_tmp16__length1 = _tmp17_;
		_tmp18_ = _tmp16_;
		_tmp18__length1 = _tmp16__length1;
		{
			gchar** prop_name_collection = NULL;
			gint prop_name_collection_length1 = 0;
			gint _prop_name_collection_size_ = 0;
			gint prop_name_it = 0;
			prop_name_collection = _tmp18_;
			prop_name_collection_length1 = _tmp18__length1;
			for (prop_name_it = 0; prop_name_it < prop_name_collection_length1; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name = NULL;
				prop_name = prop_name_collection[prop_name_it];
				{
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					GObjectClass* pclass = NULL;
					GObjectClass* _tmp21_;
					GObjectClass* _tmp22_;
					const gchar* _tmp23_;
					GParamSpec* _tmp24_;
					const gchar* _tmp26_;
					_tmp19_ = prop_name;
					if (_tmp19_ == NULL) {
						continue;
					}
					_tmp20_ = prop_name;
					g_debug ("individual-aggregator.vala:1549:         %s", _tmp20_);
					_tmp21_ = G_OBJECT_GET_CLASS ((GObject*) persona);
					pclass = _tmp21_;
					_tmp22_ = pclass;
					_tmp23_ = prop_name;
					_tmp24_ = g_object_class_find_property (_tmp22_, _tmp23_);
					if (_tmp24_ == NULL) {
						const gchar* _tmp25_;
						_tmp25_ = prop_name;
						g_warning (_ ("Unknown property ‘%s’ in linkable property list."), _tmp25_);
						continue;
					}
					_tmp26_ = prop_name;
					folks_persona_linkable_property_to_links (persona, _tmp26_, ______lambda68__folks_persona_linkable_property_callback, _data5_);
				}
			}
		}
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
_folks_individual_aggregator_remove_individual_from_link_map (FolksIndividualAggregator* self,
                                                              FolksIndividual* individual)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	const gchar* link_key = NULL;
	GPtrArray* inds = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_id (individual);
	_tmp1_ = _tmp0_;
	g_debug ("individual-aggregator.vala:1580: Removing Individual '%s' from the lin" \
"k map.", _tmp1_);
	_tmp2_ = self->priv->_link_map;
	g_hash_table_iter_init (&iter, _tmp2_);
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
		link_key = (const gchar*) _tmp3_;
		inds = (GPtrArray*) _tmp4_;
		if (!_tmp5_) {
			break;
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					GPtrArray* _tmp11_;
					gconstpointer _tmp12_;
					if (!_tmp6_) {
						guint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = inds;
					_tmp9_ = vala_g_ptr_array_get_length (_tmp8_);
					_tmp10_ = _tmp9_;
					if (!(i < ((guint) _tmp10_))) {
						break;
					}
					_tmp11_ = inds;
					_tmp12_ = g_ptr_array_index (_tmp11_, i);
					if (((FolksIndividual*) _tmp12_) == individual) {
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						GPtrArray* _tmp16_;
						GPtrArray* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						_tmp13_ = link_key;
						_tmp14_ = folks_individual_get_id (individual);
						_tmp15_ = _tmp14_;
						g_debug ("individual-aggregator.vala:1593:     %s → %s (%p)", _tmp13_, _tmp15_, individual);
						_tmp16_ = inds;
						g_ptr_array_remove_index_fast (_tmp16_, i);
						_tmp17_ = inds;
						_tmp18_ = vala_g_ptr_array_get_length (_tmp17_);
						_tmp19_ = _tmp18_;
						if (_tmp19_ == 0) {
							g_hash_table_iter_remove (&iter);
						}
						break;
					}
				}
			}
		}
	}
}

static void
_folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self,
                                                  FolksPersonaStore* store,
                                                  GeeSet* added,
                                                  GeeSet* removed,
                                                  const gchar* message,
                                                  FolksPersona* actor,
                                                  FolksGroupDetailsChangeReason reason)
{
	GeeHashSet* removed_individuals = NULL;
	GeeHashSet* _tmp0_;
	GeeHashMultiMap* individuals_changes = NULL;
	GeeHashMultiMap* _tmp1_;
	GeeHashSet* relinked_personas = NULL;
	GeeHashSet* _tmp2_;
	GeeHashMap* replaced_individuals = NULL;
	GeeHashMap* _tmp3_;
	FolksIndividual* user = NULL;
	FolksIndividual* _tmp4_;
	FolksIndividual* _tmp5_;
	gint _tmp71_;
	gint _tmp72_;
	GeeHashSet* _tmp88_;
	FolksIndividual* _tmp116_;
	GeeHashMultiMap* _tmp117_;
	gint _tmp118_;
	gint _tmp119_;
	GeeMapIterator* iter2 = NULL;
	GeeHashMap* _tmp147_;
	GeeMapIterator* _tmp148_;
	FolksDebug* _tmp164_;
	gboolean _tmp165_;
	gboolean _tmp166_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed_individuals = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	individuals_changes = _tmp1_;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	relinked_personas = _tmp2_;
	_tmp3_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	replaced_individuals = _tmp3_;
	_tmp4_ = self->priv->_user;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	user = _tmp5_;
	g_debug ("individual-aggregator.vala:1626: Removing Personas:");
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp6_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) removed);
		_persona_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			const gchar* _tmp10_ = NULL;
			FolksPersona* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			FolksPersona* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			FolksPersona* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			FolksIndividual* ind = NULL;
			FolksPersona* _tmp20_;
			FolksIndividual* _tmp21_;
			FolksIndividual* _tmp22_;
			FolksIndividual* _tmp23_;
			FolksPersona* _tmp26_;
			_tmp7_ = _persona_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _persona_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			persona = (FolksPersona*) _tmp9_;
			_tmp11_ = persona;
			_tmp12_ = folks_persona_get_is_user (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				_tmp10_ = "yes";
			} else {
				_tmp10_ = "no";
			}
			_tmp14_ = persona;
			_tmp15_ = folks_persona_get_uid (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = persona;
			_tmp18_ = folks_persona_get_iid (_tmp17_);
			_tmp19_ = _tmp18_;
			g_debug ("individual-aggregator.vala:1630:     %s (is user: %s, IID: %s)", _tmp16_, _tmp10_, _tmp19_);
			_tmp20_ = persona;
			_tmp21_ = folks_persona_get_individual (_tmp20_);
			_tmp22_ = _tmp21_;
			ind = _tmp22_;
			_tmp23_ = ind;
			if (_tmp23_ != NULL) {
				GeeHashSet* _tmp24_;
				FolksIndividual* _tmp25_;
				_tmp24_ = removed_individuals;
				_tmp25_ = ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp26_ = persona;
			_folks_individual_aggregator_disconnect_from_persona (self, _tmp26_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	g_debug ("individual-aggregator.vala:1654: Removing Individuals due to removed l" \
"inks:");
	{
		GeeIterator* _individual_it = NULL;
		GeeHashSet* _tmp27_;
		GeeIterator* _tmp28_;
		_tmp27_ = removed_individuals;
		_tmp28_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp27_);
		_individual_it = _tmp28_;
		while (TRUE) {
			GeeIterator* _tmp29_;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp30_;
			gpointer _tmp31_;
			GeeMap* _tmp32_;
			FolksIndividual* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			FolksIndividual* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			FolksIndividual* _tmp52_;
			FolksIndividual* _tmp53_;
			FolksIndividual* _tmp54_;
			FolksIndividual* _tmp55_;
			_tmp29_ = _individual_it;
			if (!gee_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = _individual_it;
			_tmp31_ = gee_iterator_get (_tmp30_);
			individual = (FolksIndividual*) _tmp31_;
			_tmp32_ = self->priv->_individuals;
			_tmp33_ = individual;
			_tmp34_ = folks_individual_get_id (_tmp33_);
			_tmp35_ = _tmp34_;
			if (gee_map_has_key (_tmp32_, _tmp35_) == FALSE) {
				_g_object_unref0 (individual);
				continue;
			}
			_tmp36_ = individual;
			_tmp37_ = folks_individual_get_id (_tmp36_);
			_tmp38_ = _tmp37_;
			g_debug ("individual-aggregator.vala:1661:     %s", _tmp38_);
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp39_;
				GeeSet* _tmp40_;
				GeeSet* _tmp41_;
				GeeIterator* _tmp42_;
				_tmp39_ = individual;
				_tmp40_ = folks_individual_get_personas (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
				_persona_it = _tmp42_;
				while (TRUE) {
					GeeIterator* _tmp43_;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp44_;
					gpointer _tmp45_;
					gboolean _tmp46_ = FALSE;
					FolksPersona* _tmp47_;
					GeeHashSet* _tmp50_;
					FolksPersona* _tmp51_;
					_tmp43_ = _persona_it;
					if (!gee_iterator_next (_tmp43_)) {
						break;
					}
					_tmp44_ = _persona_it;
					_tmp45_ = gee_iterator_get (_tmp44_);
					persona = (FolksPersona*) _tmp45_;
					_tmp47_ = persona;
					if (gee_collection_contains ((GeeCollection*) removed, _tmp47_) == TRUE) {
						_tmp46_ = TRUE;
					} else {
						GeeHashSet* _tmp48_;
						FolksPersona* _tmp49_;
						_tmp48_ = relinked_personas;
						_tmp49_ = persona;
						_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp48_, _tmp49_) == TRUE;
					}
					if (_tmp46_) {
						_g_object_unref0 (persona);
						continue;
					}
					_tmp50_ = relinked_personas;
					_tmp51_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp52_ = user;
			_tmp53_ = individual;
			if (_tmp52_ == _tmp53_) {
				_g_object_unref0 (user);
				user = NULL;
			}
			_tmp54_ = individual;
			_folks_individual_aggregator_disconnect_from_individual (self, _tmp54_);
			_tmp55_ = individual;
			_folks_individual_aggregator_remove_individual_from_link_map (self, _tmp55_);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	g_debug ("individual-aggregator.vala:1683: Adding Personas:");
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp56_;
		_tmp56_ = gee_iterable_iterator ((GeeIterable*) added);
		_persona_it = _tmp56_;
		while (TRUE) {
			GeeIterator* _tmp57_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp58_;
			gpointer _tmp59_;
			const gchar* _tmp60_ = NULL;
			FolksPersona* _tmp61_;
			gboolean _tmp62_;
			gboolean _tmp63_;
			FolksPersona* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			FolksPersona* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			FolksPersona* _tmp70_;
			_tmp57_ = _persona_it;
			if (!gee_iterator_next (_tmp57_)) {
				break;
			}
			_tmp58_ = _persona_it;
			_tmp59_ = gee_iterator_get (_tmp58_);
			persona = (FolksPersona*) _tmp59_;
			_tmp61_ = persona;
			_tmp62_ = folks_persona_get_is_user (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_) {
				_tmp60_ = "yes";
			} else {
				_tmp60_ = "no";
			}
			_tmp64_ = persona;
			_tmp65_ = folks_persona_get_uid (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = persona;
			_tmp68_ = folks_persona_get_iid (_tmp67_);
			_tmp69_ = _tmp68_;
			g_debug ("individual-aggregator.vala:1686:     %s (is user: %s, IID: %s)", _tmp66_, _tmp60_, _tmp69_);
			_tmp70_ = persona;
			_folks_individual_aggregator_connect_to_persona (self, _tmp70_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp71_ = gee_collection_get_size ((GeeCollection*) added);
	_tmp72_ = _tmp71_;
	if (_tmp72_ > 0) {
		_folks_individual_aggregator_add_personas (self, added, &user, &individuals_changes);
	}
	g_debug ("individual-aggregator.vala:1699: Relinking Personas:");
	{
		GeeIterator* _persona_it = NULL;
		GeeHashSet* _tmp73_;
		GeeIterator* _tmp74_;
		_tmp73_ = relinked_personas;
		_tmp74_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp73_);
		_persona_it = _tmp74_;
		while (TRUE) {
			GeeIterator* _tmp75_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp76_;
			gpointer _tmp77_;
			const gchar* _tmp78_ = NULL;
			FolksPersona* _tmp79_;
			gboolean _tmp80_;
			gboolean _tmp81_;
			FolksPersona* _tmp82_;
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			FolksPersona* _tmp85_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			_tmp75_ = _persona_it;
			if (!gee_iterator_next (_tmp75_)) {
				break;
			}
			_tmp76_ = _persona_it;
			_tmp77_ = gee_iterator_get (_tmp76_);
			persona = (FolksPersona*) _tmp77_;
			_tmp79_ = persona;
			_tmp80_ = folks_persona_get_is_user (_tmp79_);
			_tmp81_ = _tmp80_;
			if (_tmp81_) {
				_tmp78_ = "yes";
			} else {
				_tmp78_ = "no";
			}
			_tmp82_ = persona;
			_tmp83_ = folks_persona_get_uid (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = persona;
			_tmp86_ = folks_persona_get_iid (_tmp85_);
			_tmp87_ = _tmp86_;
			g_debug ("individual-aggregator.vala:1702:     %s (is user: %s, IID: %s)", _tmp84_, _tmp78_, _tmp87_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp88_ = relinked_personas;
	_folks_individual_aggregator_add_personas (self, (GeeSet*) _tmp88_, &user, &individuals_changes);
	{
		GeeIterator* _individual_it = NULL;
		GeeHashSet* _tmp89_;
		GeeIterator* _tmp90_;
		_tmp89_ = removed_individuals;
		_tmp90_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp89_);
		_individual_it = _tmp90_;
		while (TRUE) {
			GeeIterator* _tmp91_;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp92_;
			gpointer _tmp93_;
			gboolean added_mapping = FALSE;
			FolksIndividual* _tmp115_;
			_tmp91_ = _individual_it;
			if (!gee_iterator_next (_tmp91_)) {
				break;
			}
			_tmp92_ = _individual_it;
			_tmp93_ = gee_iterator_get (_tmp92_);
			individual = (FolksIndividual*) _tmp93_;
			added_mapping = FALSE;
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp94_;
				GeeSet* _tmp95_;
				GeeSet* _tmp96_;
				GeeIterator* _tmp97_;
				_tmp94_ = individual;
				_tmp95_ = folks_individual_get_personas (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = gee_iterable_iterator ((GeeIterable*) _tmp96_);
				_persona_it = _tmp97_;
				while (TRUE) {
					GeeIterator* _tmp98_;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp99_;
					gpointer _tmp100_;
					gboolean _tmp101_ = FALSE;
					FolksPersona* _tmp102_;
					_tmp98_ = _persona_it;
					if (!gee_iterator_next (_tmp98_)) {
						break;
					}
					_tmp99_ = _persona_it;
					_tmp100_ = gee_iterator_get (_tmp99_);
					persona = (FolksPersona*) _tmp100_;
					_tmp102_ = persona;
					if (!gee_collection_contains ((GeeCollection*) removed, _tmp102_)) {
						_tmp101_ = TRUE;
					} else {
						FolksPersona* _tmp103_;
						_tmp103_ = persona;
						_tmp101_ = gee_collection_contains ((GeeCollection*) added, _tmp103_);
					}
					if (_tmp101_) {
						GeeHashMultiMap* _tmp104_;
						FolksPersona* _tmp105_;
						FolksIndividual* _tmp106_;
						FolksIndividual* _tmp107_;
						GeeHashMultiMap* _tmp108_;
						FolksIndividual* _tmp109_;
						FolksPersona* _tmp110_;
						FolksIndividual* _tmp111_;
						FolksIndividual* _tmp112_;
						_tmp104_ = individuals_changes;
						_tmp105_ = persona;
						_tmp106_ = folks_persona_get_individual (_tmp105_);
						_tmp107_ = _tmp106_;
						gee_multi_map_remove ((GeeMultiMap*) _tmp104_, NULL, _tmp107_);
						_tmp108_ = individuals_changes;
						_tmp109_ = individual;
						_tmp110_ = persona;
						_tmp111_ = folks_persona_get_individual (_tmp110_);
						_tmp112_ = _tmp111_;
						gee_multi_map_set ((GeeMultiMap*) _tmp108_, _tmp109_, _tmp112_);
						added_mapping = TRUE;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			if (added_mapping == FALSE) {
				GeeHashMultiMap* _tmp113_;
				FolksIndividual* _tmp114_;
				_tmp113_ = individuals_changes;
				_tmp114_ = individual;
				gee_multi_map_set ((GeeMultiMap*) _tmp113_, _tmp114_, NULL);
			}
			_tmp115_ = individual;
			folks_individual_set_personas (_tmp115_, NULL);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	_tmp116_ = user;
	folks_individual_aggregator_set_user (self, _tmp116_);
	_tmp117_ = individuals_changes;
	_tmp118_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp117_);
	_tmp119_ = _tmp118_;
	if (_tmp119_ > 0) {
		GeeHashSet* added_individuals = NULL;
		GeeHashSet* _tmp120_;
		GeeMapIterator* iter1 = NULL;
		GeeHashMultiMap* _tmp121_;
		GeeMapIterator* _tmp122_;
		GeeHashSet* _tmp144_;
		GeeHashSet* _tmp145_;
		GeeHashMultiMap* _tmp146_;
		_tmp120_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		added_individuals = _tmp120_;
		_tmp121_ = individuals_changes;
		_tmp122_ = gee_multi_map_map_iterator ((GeeMultiMap*) _tmp121_);
		iter1 = _tmp122_;
		while (TRUE) {
			GeeMapIterator* _tmp123_;
			FolksIndividual* old_ind = NULL;
			GeeMapIterator* _tmp124_;
			gpointer _tmp125_;
			FolksIndividual* new_ind = NULL;
			GeeMapIterator* _tmp126_;
			gpointer _tmp127_;
			gboolean _tmp128_ = FALSE;
			FolksIndividual* _tmp129_;
			FolksIndividual* _tmp131_;
			FolksIndividual* _tmp134_;
			gboolean _tmp138_ = FALSE;
			FolksIndividual* _tmp139_;
			_tmp123_ = iter1;
			if (!gee_map_iterator_next (_tmp123_)) {
				break;
			}
			_tmp124_ = iter1;
			_tmp125_ = gee_map_iterator_get_key (_tmp124_);
			old_ind = (FolksIndividual*) _tmp125_;
			_tmp126_ = iter1;
			_tmp127_ = gee_map_iterator_get_value (_tmp126_);
			new_ind = (FolksIndividual*) _tmp127_;
			_tmp129_ = old_ind;
			if (_tmp129_ != NULL) {
				_tmp128_ = TRUE;
			} else {
				FolksIndividual* _tmp130_;
				_tmp130_ = new_ind;
				_tmp128_ = _tmp130_ != NULL;
			}
			_vala_assert (_tmp128_, "old_ind != null || new_ind != null");
			_tmp131_ = old_ind;
			if (_tmp131_ != NULL) {
				GeeHashSet* _tmp132_;
				FolksIndividual* _tmp133_;
				_tmp132_ = removed_individuals;
				_tmp133_ = old_ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp132_, G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp134_ = new_ind;
			if (_tmp134_ != NULL) {
				GeeHashSet* _tmp135_;
				FolksIndividual* _tmp136_;
				FolksIndividual* _tmp137_;
				_tmp135_ = added_individuals;
				_tmp136_ = new_ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp135_, G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp137_ = new_ind;
				_folks_individual_aggregator_connect_to_individual (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp139_ = old_ind;
			if (_tmp139_ != NULL) {
				FolksIndividual* _tmp140_;
				_tmp140_ = new_ind;
				_tmp138_ = _tmp140_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				GeeHashMap* _tmp141_;
				FolksIndividual* _tmp142_;
				FolksIndividual* _tmp143_;
				_tmp141_ = replaced_individuals;
				_tmp142_ = old_ind;
				_tmp143_ = new_ind;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp141_, G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual), G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_g_object_unref0 (new_ind);
			_g_object_unref0 (old_ind);
		}
		_tmp144_ = added_individuals;
		_tmp145_ = removed_individuals;
		_tmp146_ = individuals_changes;
		_folks_individual_aggregator_emit_individuals_changed (self, (GeeSet*) _tmp144_, (GeeSet*) _tmp145_, (GeeMultiMap*) _tmp146_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (iter1);
		_g_object_unref0 (added_individuals);
	}
	g_debug ("individual-aggregator.vala:1777: Replacing Individuals due to linking:");
	_tmp147_ = replaced_individuals;
	_tmp148_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp147_);
	iter2 = _tmp148_;
	while (TRUE) {
		GeeMapIterator* _tmp149_;
		FolksIndividual* old_ind = NULL;
		GeeMapIterator* _tmp150_;
		gpointer _tmp151_;
		FolksIndividual* new_ind = NULL;
		GeeMapIterator* _tmp152_;
		gpointer _tmp153_;
		FolksIndividual* _tmp154_;
		const gchar* _tmp155_;
		const gchar* _tmp156_;
		FolksIndividual* _tmp157_;
		FolksIndividual* _tmp158_;
		const gchar* _tmp159_;
		const gchar* _tmp160_;
		FolksIndividual* _tmp161_;
		FolksIndividual* _tmp162_;
		FolksIndividual* _tmp163_;
		_tmp149_ = iter2;
		if (!(gee_map_iterator_next (_tmp149_) == TRUE)) {
			break;
		}
		_tmp150_ = iter2;
		_tmp151_ = gee_map_iterator_get_key (_tmp150_);
		old_ind = (FolksIndividual*) _tmp151_;
		_tmp152_ = iter2;
		_tmp153_ = gee_map_iterator_get_value (_tmp152_);
		new_ind = (FolksIndividual*) _tmp153_;
		_tmp154_ = old_ind;
		_tmp155_ = folks_individual_get_id (_tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = old_ind;
		_tmp158_ = new_ind;
		_tmp159_ = folks_individual_get_id (_tmp158_);
		_tmp160_ = _tmp159_;
		_tmp161_ = new_ind;
		g_debug ("individual-aggregator.vala:1784:     %s (%p) → %s (%p)", _tmp156_, _tmp157_, _tmp160_, _tmp161_);
		_tmp162_ = old_ind;
		_tmp163_ = new_ind;
		folks_individual_replace (_tmp162_, _tmp163_);
		_g_object_unref0 (new_ind);
		_g_object_unref0 (old_ind);
	}
	_tmp164_ = self->priv->_debug;
	_tmp165_ = folks_debug_get_debug_output_enabled (_tmp164_);
	_tmp166_ = _tmp165_;
	if (_tmp166_ == TRUE) {
		GHashTableIter link_map_iter = {0};
		GHashTable* _tmp167_;
		const gchar* link_key = NULL;
		GPtrArray* inds = NULL;
		_tmp167_ = self->priv->_link_map;
		g_hash_table_iter_init (&link_map_iter, _tmp167_);
		while (TRUE) {
			gconstpointer _tmp168_ = NULL;
			gconstpointer _tmp169_ = NULL;
			gboolean _tmp170_;
			_tmp170_ = g_hash_table_iter_next (&link_map_iter, (gpointer*) (&_tmp168_), (gpointer*) (&_tmp169_));
			link_key = (const gchar*) _tmp168_;
			inds = (GPtrArray*) _tmp169_;
			if (!_tmp170_) {
				break;
			}
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp171_ = FALSE;
					_tmp171_ = TRUE;
					while (TRUE) {
						GPtrArray* _tmp173_;
						gint _tmp174_;
						gint _tmp175_;
						FolksIndividual* individual = NULL;
						GPtrArray* _tmp176_;
						gconstpointer _tmp177_;
						FolksIndividual* _tmp178_;
						FolksIndividual* _tmp179_;
						GeeMap* _tmp180_;
						FolksIndividual* _tmp181_;
						const gchar* _tmp182_;
						const gchar* _tmp183_;
						gpointer _tmp184_;
						FolksIndividual* _tmp185_;
						FolksIndividual* _tmp186_;
						gboolean _tmp187_;
						if (!_tmp171_) {
							guint _tmp172_;
							_tmp172_ = i;
							i = _tmp172_ + 1;
						}
						_tmp171_ = FALSE;
						_tmp173_ = inds;
						_tmp174_ = vala_g_ptr_array_get_length (_tmp173_);
						_tmp175_ = _tmp174_;
						if (!(i < ((guint) _tmp175_))) {
							break;
						}
						_tmp176_ = inds;
						_tmp177_ = g_ptr_array_index (_tmp176_, i);
						_tmp178_ = _g_object_ref0 ((FolksIndividual*) _tmp177_);
						individual = _tmp178_;
						_tmp179_ = individual;
						_vala_assert (_tmp179_ != NULL, "individual != null");
						_tmp180_ = self->priv->_individuals;
						_tmp181_ = individual;
						_tmp182_ = folks_individual_get_id (_tmp181_);
						_tmp183_ = _tmp182_;
						_tmp184_ = gee_map_get (_tmp180_, _tmp183_);
						_tmp185_ = (FolksIndividual*) _tmp184_;
						_tmp186_ = individual;
						_tmp187_ = _tmp185_ != _tmp186_;
						_g_object_unref0 (_tmp185_);
						if (_tmp187_) {
							const gchar* _tmp188_;
							FolksIndividual* _tmp189_;
							const gchar* _tmp190_;
							const gchar* _tmp191_;
							FolksIndividual* _tmp192_;
							FolksIndividual* _tmp193_;
							const gchar* _tmp194_;
							const gchar* _tmp195_;
							FolksIndividual* _tmp196_;
							_tmp188_ = link_key;
							_tmp189_ = individual;
							_tmp190_ = folks_individual_get_id (_tmp189_);
							_tmp191_ = _tmp190_;
							_tmp192_ = individual;
							g_warning ("Link map contains invalid mapping:\n" "    %s → %s (%p)", _tmp188_, _tmp191_, _tmp192_);
							_tmp193_ = individual;
							_tmp194_ = folks_individual_get_id (_tmp193_);
							_tmp195_ = _tmp194_;
							_tmp196_ = individual;
							g_warning ("individual-aggregator.vala:1810: Individual %s (%p) personas:", _tmp195_, _tmp196_);
							{
								GeeIterator* _p_it = NULL;
								FolksIndividual* _tmp197_;
								GeeSet* _tmp198_;
								GeeSet* _tmp199_;
								GeeIterator* _tmp200_;
								_tmp197_ = individual;
								_tmp198_ = folks_individual_get_personas (_tmp197_);
								_tmp199_ = _tmp198_;
								_tmp200_ = gee_iterable_iterator ((GeeIterable*) _tmp199_);
								_p_it = _tmp200_;
								while (TRUE) {
									GeeIterator* _tmp201_;
									FolksPersona* p = NULL;
									GeeIterator* _tmp202_;
									gpointer _tmp203_;
									FolksPersona* _tmp204_;
									const gchar* _tmp205_;
									const gchar* _tmp206_;
									FolksPersona* _tmp207_;
									_tmp201_ = _p_it;
									if (!gee_iterator_next (_tmp201_)) {
										break;
									}
									_tmp202_ = _p_it;
									_tmp203_ = gee_iterator_get (_tmp202_);
									p = (FolksPersona*) _tmp203_;
									_tmp204_ = p;
									_tmp205_ = folks_persona_get_uid (_tmp204_);
									_tmp206_ = _tmp205_;
									_tmp207_ = p;
									g_warning ("individual-aggregator.vala:1814:     %s (%p)", _tmp206_, _tmp207_);
									_g_object_unref0 (p);
								}
								_g_object_unref0 (_p_it);
							}
						}
						{
							guint j = 0U;
							j = i + 1;
							{
								gboolean _tmp208_ = FALSE;
								_tmp208_ = TRUE;
								while (TRUE) {
									GPtrArray* _tmp210_;
									gint _tmp211_;
									gint _tmp212_;
									GPtrArray* _tmp213_;
									gconstpointer _tmp214_;
									GPtrArray* _tmp215_;
									gconstpointer _tmp216_;
									if (!_tmp208_) {
										guint _tmp209_;
										_tmp209_ = j;
										j = _tmp209_ + 1;
									}
									_tmp208_ = FALSE;
									_tmp210_ = inds;
									_tmp211_ = vala_g_ptr_array_get_length (_tmp210_);
									_tmp212_ = _tmp211_;
									if (!(j < ((guint) _tmp212_))) {
										break;
									}
									_tmp213_ = inds;
									_tmp214_ = g_ptr_array_index (_tmp213_, i);
									_tmp215_ = inds;
									_tmp216_ = g_ptr_array_index (_tmp215_, j);
									if (((FolksIndividual*) _tmp214_) == ((FolksIndividual*) _tmp216_)) {
										const gchar* _tmp217_;
										FolksIndividual* _tmp218_;
										const gchar* _tmp219_;
										const gchar* _tmp220_;
										FolksIndividual* _tmp221_;
										_tmp217_ = link_key;
										_tmp218_ = individual;
										_tmp219_ = folks_individual_get_id (_tmp218_);
										_tmp220_ = _tmp219_;
										_tmp221_ = individual;
										g_warning ("Link map contains non-unique " "Individual: %s → %s (%p) twice", _tmp217_, _tmp220_, _tmp221_);
									}
								}
							}
						}
						_g_object_unref0 (individual);
					}
				}
			}
		}
	}
	_g_object_unref0 (iter2);
	_g_object_unref0 (user);
	_g_object_unref0 (replaced_individuals);
	_g_object_unref0 (relinked_personas);
	_g_object_unref0 (individuals_changes);
	_g_object_unref0 (removed_individuals);
}

static void
_folks_individual_aggregator_is_primary_store_changed_cb (FolksIndividualAggregator* self,
                                                          GObject* object,
                                                          GParamSpec* pspec)
{
	FolksPersonaStore* store = NULL;
	FolksPersonaStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
	store = _tmp0_;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_is_primary_store (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		FolksPersonaStore* _tmp6_;
		FolksPersonaStore* _tmp7_;
		_tmp6_ = store;
		_tmp7_ = self->priv->_primary_store;
		_tmp2_ = _tmp6_ == _tmp7_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		FolksPersonaStore* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = store;
		_tmp10_ = folks_persona_store_get_is_primary_store (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == FALSE) {
			FolksPersonaStore* _tmp12_;
			FolksPersonaStore* _tmp13_;
			_tmp12_ = store;
			_tmp13_ = self->priv->_primary_store;
			_tmp8_ = _tmp12_ != _tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp1_ = _tmp8_;
	}
	_vala_assert (_tmp1_, "(store.is_primary_store == true &&               store == this._primary_store) ||           (store.is_primary_store == false &&               store != this._primary_store)");
	_g_object_unref0 (store);
}

static void
_folks_individual_aggregator_persona_store_is_quiescent_changed_cb (FolksIndividualAggregator* self,
                                                                    GObject* obj,
                                                                    GParamSpec* pspec)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (self->priv->_non_quiescent_persona_store_count > ((guint) 0)) {
		guint _tmp0_;
		_tmp0_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp0_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
}

static void
_folks_individual_aggregator_backend_is_quiescent_changed_cb (FolksIndividualAggregator* self,
                                                              GObject* obj,
                                                              GParamSpec* pspec)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (self->priv->_non_quiescent_backend_count > ((guint) 0)) {
		guint _tmp0_;
		_tmp0_ = self->priv->_non_quiescent_backend_count;
		self->priv->_non_quiescent_backend_count = _tmp0_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
}

static void
_folks_individual_aggregator_notify_if_is_quiescent (FolksIndividualAggregator* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_non_quiescent_backend_count == ((guint) 0)) {
		_tmp1_ = self->priv->_non_quiescent_persona_store_count == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->_is_quiescent == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->_configured_primary_store_type_id;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > 0) {
			FolksPersonaStore* _tmp6_;
			_tmp6_ = self->priv->_primary_store;
			_tmp2_ = _tmp6_ == NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->_configured_primary_store_type_id;
			_tmp8_ = self->priv->_configured_primary_store_id;
			g_warning ("Failed to find primary PersonaStore with type ID " "'%s' and ID '%s'.\n" "Individuals will not be linked properly " "and creating new links between Personas will not work.\n" "The configured primary PersonaStore's backend may not be " "installed. If you are unsure, check with your " "distribution.", _tmp7_, _tmp8_);
		}
		folks_internal_profiling_point ("%s", "reached quiescence in " "IndividualAggregator");
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
		if (self->priv->_quiescent_timeout_id != ((guint) 0)) {
			g_source_remove (self->priv->_quiescent_timeout_id);
			self->priv->_quiescent_timeout_id = (guint) 0;
		}
	}
}

static gboolean
_folks_individual_aggregator_quiescent_timeout_cb (FolksIndividualAggregator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_is_quiescent == FALSE) {
		g_warning ("Failed to reach quiescence normally (%u backends and %u " "persona stores still haven't reached quiescence). Forcing " "IndividualAggregator quiescence due to reaching the timeout.", self->priv->_non_quiescent_backend_count, self->priv->_non_quiescent_persona_store_count);
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
	self->priv->_quiescent_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static void
_folks_individual_aggregator_persona_store_is_user_set_default_changed_cb (FolksIndividualAggregator* self,
                                                                           GObject* obj,
                                                                           GParamSpec* pspec)
{
	FolksPersonaStore* store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FolksPersonaStore* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
	store = _tmp0_;
	_tmp1_ = store;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	g_debug ("PersonaStore.is-user-set-default changed for store %p " "(type ID: %s, ID: %s)", _tmp1_, _tmp4_, _tmp7_);
	_tmp8_ = store;
	if (_folks_individual_aggregator_maybe_configure_as_primary (self, _tmp8_)) {
		FolksPersonaStore* _tmp9_;
		_tmp9_ = store;
		_folks_individual_aggregator_set_primary_store (self, _tmp9_);
	}
	_g_object_unref0 (store);
}

static gboolean
_folks_individual_aggregator_maybe_configure_as_primary (FolksIndividualAggregator* self,
                                                         FolksPersonaStore* store)
{
	gboolean configured = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (store != NULL, FALSE);
	g_debug ("individual-aggregator.vala:1933: _maybe_configure_as_primary()");
	configured = FALSE;
	if (!self->priv->_user_configured_primary_store) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = folks_persona_store_get_is_user_set_default (store);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp3_ = folks_persona_store_get_type_id (store);
		_tmp4_ = _tmp3_;
		_tmp5_ = folks_persona_store_get_id (store);
		_tmp6_ = _tmp5_;
		g_debug ("individual-aggregator.vala:1940: Setting primary store IDs to '%s' and" \
" '%s'.", _tmp4_, _tmp6_);
		_tmp7_ = folks_persona_store_get_type_id (store);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->_configured_primary_store_type_id);
		self->priv->_configured_primary_store_type_id = _tmp9_;
		_tmp10_ = folks_persona_store_get_id (store);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (self->priv->_configured_primary_store_id);
		self->priv->_configured_primary_store_id = _tmp12_;
		configured = TRUE;
	}
	result = configured;
	return result;
}

static void
_folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self,
                                                    FolksIndividual* i,
                                                    FolksIndividual* replacement)
{
	FolksIndividual* _tmp0_;
	GeeMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	FolksIndividual* _tmp5_;
	gboolean _tmp6_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->_user;
	if (_tmp0_ == i) {
		folks_individual_aggregator_set_user (self, NULL);
	}
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = folks_individual_get_id (i);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_map_get (_tmp1_, _tmp3_);
	_tmp5_ = (FolksIndividual*) _tmp4_;
	_tmp6_ = _tmp5_ != i;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		return;
	}
	if (replacement != NULL) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = folks_individual_get_id (i);
		_tmp8_ = _tmp7_;
		_tmp9_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (replacement, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
		_tmp10_ = _tmp9_;
		g_debug ("individual-aggregator.vala:1962: Individual '%s' removed (replaced by " \
"'%s')", _tmp8_, _tmp10_);
	} else {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = folks_individual_get_id (i);
		_tmp12_ = _tmp11_;
		g_debug ("individual-aggregator.vala:1967: Individual '%s' removed (not replaced" \
")", _tmp12_);
	}
	_tmp13_ = folks_individual_get_personas (i);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > 0) {
		GeeHashMultiMap* changes = NULL;
		GeeHashMultiMap* _tmp17_;
		FolksSmallSet* individuals = NULL;
		FolksSmallSet* _tmp18_;
		FolksSmallSet* _tmp19_;
		GeeHashMultiMap* _tmp20_;
		FolksSmallSet* _tmp21_;
		GeeHashMultiMap* _tmp22_;
		_tmp17_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		changes = _tmp17_;
		_tmp18_ = folks_small_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		individuals = _tmp18_;
		_tmp19_ = individuals;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, i);
		_tmp20_ = changes;
		gee_multi_map_set ((GeeMultiMap*) _tmp20_, i, replacement);
		_tmp21_ = individuals;
		_tmp22_ = changes;
		_folks_individual_aggregator_emit_individuals_changed (self, NULL, (GeeSet*) _tmp21_, (GeeMultiMap*) _tmp22_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (individuals);
		_g_object_unref0 (changes);
	}
	_folks_individual_aggregator_disconnect_from_individual (self, i);
}

static void
folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data)
{
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->persona_store);
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, _data_);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self,
                                                      FolksIndividual* parent,
                                                      FolksPersonaStore* persona_store,
                                                      GHashTable* details,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksPersonaStore* _tmp2_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona_store != NULL);
	g_return_if_fail (details != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp1_;
	_tmp2_ = _g_object_ref0 (persona_store);
	_g_object_unref0 (_data_->persona_store);
	_data_->persona_store = _tmp2_;
	_tmp3_ = _g_hash_table_ref0 (details);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp3_;
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}

FolksPersona*
folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Add a new persona in the given {@link PersonaStore} based on the
   * ``details`` provided.
   *
   * If the target store is offline, this function will throw
   * {@link IndividualAggregatorError.STORE_OFFLINE}. It's the responsibility of
   * the caller to cache details and re-try this function if it wishes to make
   * offline adds work.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *  * message - a user-readable message to pass to the persona being added
   *
   * If a {@link Persona} with the given details already exists in the store, no
   * error will be thrown and this function will return ``null``.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to. This persona will be appended to its ordered list of personas.
   * @param persona_store the {@link PersonaStore} to add the persona to
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   * @return the new {@link Persona} or ``null`` if the corresponding
   * {@link Persona} already existed. If non-``null``, the new {@link Persona}
   * will also be added to a new or existing {@link Individual} as necessary.
   * @throws IndividualAggregatorError.STORE_OFFLINE if the persona store was
   * offline
   * @throws IndividualAggregatorError.ADD_FAILED if any other error occurred
   * while adding the persona
   *
   * @since 0.3.5
   */
static void
folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}

static gboolean
folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->persona = NULL;
	{
		_data_->_tmp0_ = _folks_individual_aggregator_asv_copy (_data_->self, _data_->details);
		_data_->details_copy = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->details_copy;
		_data_->_state_ = 1;
		folks_persona_store_add_persona_from_details (_data_->persona_store, _data_->_tmp2_, folks_individual_aggregator_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = folks_persona_store_add_persona_from_details_finish (_data_->persona_store, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->details_copy);
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch0_folks_persona_store_error;
			}
			_g_object_unref0 (_data_->persona);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->persona);
		_data_->persona = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp1_);
		_g_hash_table_unref0 (_data_->details_copy);
	}
	goto __finally0;
	__catch0_folks_persona_store_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		if (g_error_matches (_data_->_tmp5_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = _data_->_tmp6_->message;
			_data_->_tmp8_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, _data_->_tmp7_);
			_data_->_inner_error0_ = _data_->_tmp8_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp9_ = folks_persona_store_get_type_id (_data_->persona_store);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = folks_persona_store_get_id (_data_->persona_store);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = _folks_individual_aggregator_get_store_full_id (_data_->self, _data_->_tmp10_, _data_->_tmp12_);
			_data_->full_id = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->full_id;
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			_data_->_tmp17_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, _ ("Failed to add contact for persona store ID ‘%s’: %s"), _data_->_tmp14_, _data_->_tmp16_);
			_data_->_inner_error0_ = _data_->_tmp17_;
			_g_free0 (_data_->full_id);
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->persona);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->parent != NULL) {
		_data_->_tmp19_ = _data_->persona;
		_data_->_tmp18_ = _data_->_tmp19_ != NULL;
	} else {
		_data_->_tmp18_ = FALSE;
	}
	if (_data_->_tmp18_) {
		_data_->_tmp20_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_data_->parent, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->persona;
		gee_collection_add ((GeeCollection*) _data_->_tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, FOLKS_TYPE_PERSONA, FolksPersona));
	}
	_data_->result = _data_->persona;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data6_->self;
		_g_hash_table_unref0 (_data6_->retval);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
__lambda70_ (Block6Data* _data6_,
             const gchar* k,
             GValue* v)
{
	FolksIndividualAggregator* self;
	gchar* _tmp0_;
	GValue* _tmp1_;
	self = _data6_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	_tmp1_ = __g_value_dup0 (v);
	g_hash_table_insert (_data6_->retval, _tmp0_, _tmp1_);
}

static void
___lambda70__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda70_ (self, (const gchar*) key, (GValue*) value);
}

static GHashTable*
_folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self,
                                       GHashTable* asv)
{
	Block6Data* _data6_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_GValue_free0_);
	_data6_->retval = _tmp2_;
	g_hash_table_foreach (asv, ___lambda70__gh_func, _data6_);
	_tmp3_ = _g_hash_table_ref0 (_data6_->retval);
	result = _tmp3_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

static void
folks_individual_aggregator_remove_individual_data_free (gpointer _data)
{
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, _data_);
}

void
folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self,
                                               FolksIndividual* individual,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp1_;
	folks_individual_aggregator_remove_individual_co (_data_);
}

void
folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * This method is safe to call multiple times concurrently (for the same
   * individual or different individuals).
   *
   * @param individual the {@link Individual} to remove
   * @throws GLib.Error if removing the persona failed — this will be passed
   * through from {@link PersonaStore.remove_persona}
   *
   * @since 0.1.11
   */
static void
folks_individual_aggregator_remove_individual_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (_data_);
}

static gboolean
folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_individual_get_personas (_data_->individual);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = folks_small_set_copy (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeIterable*) _data_->_tmp1_, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->personas = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->personas;
		_data_->_persona_list = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->_persona_list;
		_data_->_tmp5_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_persona_size = _data_->_tmp6_;
		_data_->_persona_index = -1;
		while (TRUE) {
			_data_->_persona_index = _data_->_persona_index + 1;
			_data_->_tmp7_ = _data_->_persona_index;
			_data_->_tmp8_ = _data_->_persona_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_persona_list;
			_data_->_tmp10_ = folks_small_set_get (_data_->_tmp9_, _data_->_persona_index);
			_data_->_tmp11_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp10_);
			_data_->persona = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->persona;
			_data_->_tmp13_ = folks_persona_get_store (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp15_ = _data_->persona;
			_data_->_state_ = 1;
			folks_persona_store_remove_persona (_data_->_tmp14_, _data_->_tmp15_, folks_individual_aggregator_remove_individual_ready, _data_);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->persona);
				_g_object_unref0 (_data_->personas);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->persona);
		}
	}
	_g_object_unref0 (_data_->personas);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_individual_aggregator_remove_persona_data_free (gpointer _data)
{
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, _data_);
}

void
folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self,
                                            FolksPersona* persona,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	FolksIndividualAggregatorRemovePersonaData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksPersona* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (persona);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp1_;
	folks_individual_aggregator_remove_persona_co (_data_);
}

void
folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * This method is safe to call multiple times concurrently (for the same
   * persona or different personas).
   *
   * @param persona the {@link Persona} to remove
   * @throws GLib.Error if removing the persona failed — this will be passed
   * through from {@link PersonaStore.remove_persona}
   *
   * @since 0.1.11
   */
static void
folks_individual_aggregator_remove_persona_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (_data_);
}

static gboolean
folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store (_data_->persona);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	folks_persona_store_remove_persona (_data_->_tmp1_, _data_->persona, folks_individual_aggregator_remove_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_persona_store_remove_persona_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_individual_aggregator_link_personas_data_free (gpointer _data)
{
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, _data_);
}

void
folks_individual_aggregator_link_personas (FolksIndividualAggregator* self,
                                           GeeSet* personas,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FolksIndividualAggregatorLinkPersonasData* _data_;
	FolksIndividualAggregator* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (personas != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (personas);
	_g_object_unref0 (_data_->personas);
	_data_->personas = _tmp1_;
	folks_individual_aggregator_link_personas_co (_data_);
}

void
folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Link the given {@link Persona}s together.
   *
   * Create links between the given {@link Persona}s so that they form a single
   * {@link Individual}. The new {@link Individual} will be returned via the
   * {@link IndividualAggregator.individuals_changed} signal.
   *
   * Removal of the {@link Individual}s which the {@link Persona}s were in
   * before is signalled by {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * This method is safe to call multiple times concurrently.
   *
   * @param personas the {@link Persona}s to be linked
   * @throws IndividualAggregatorError.NO_PRIMARY_STORE if no primary store has
   * been configured for the individual aggregator
   * @throws IndividualAggregatorError if adding the linking persona failed —
   * this will be passed through from
   * {@link IndividualAggregator.add_persona_from_details}
   *
   * @since 0.5.1
   */
static void
folks_individual_aggregator_link_personas_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (_data_);
}

static gboolean
folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_stores;
	_data_->_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp0_, "key-file:relationships.ini");
	_data_->key_file_store = (FolksPersonaStore*) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->key_file_store;
	if (_data_->_tmp2_ == NULL) {
		g_warning ("individual-aggregator.vala:2139: Can't link Personas: No keyfile");
		_g_object_unref0 (_data_->key_file_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = gee_collection_get_size ((GeeCollection*) _data_->personas);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ <= 1) {
		_g_object_unref0 (_data_->key_file_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->_linking_enabled == FALSE) {
		g_debug ("individual-aggregator.vala:2151: Can't link Personas: linking disabled" \
".");
		_g_object_unref0 (_data_->key_file_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->personas);
		_data_->_p_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_p_it;
			if (!gee_iterator_next (_data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_p_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->p = (FolksPersona*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->p;
			_data_->_tmp10_ = _g_object_ref0 (FOLKS_IS_ANTI_LINKABLE (_data_->_tmp9_) ? ((FolksAntiLinkable*) _data_->_tmp9_) : NULL);
			_data_->al = _data_->_tmp10_;
			_data_->_tmp11_ = _data_->al;
			if (_data_->_tmp11_ != NULL) {
				{
					_data_->_tmp12_ = _data_->al;
					_data_->_state_ = 1;
					folks_anti_linkable_remove_anti_links (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), _data_->personas, folks_individual_aggregator_link_personas_ready, _data_);
					return FALSE;
					_state_1:
					folks_anti_linkable_remove_anti_links_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
							goto __catch0_folks_property_error;
						}
						_g_object_unref0 (_data_->al);
						_g_object_unref0 (_data_->p);
						_g_object_unref0 (_data_->_p_it);
						_g_object_unref0 (_data_->key_file_store);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				goto __finally0;
				__catch0_folks_property_error:
				{
					g_clear_error (&_data_->_inner_error0_);
					_data_->_tmp13_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE, _ ("Anti-links can’t be removed between personas being linked."));
					_data_->_inner_error0_ = _data_->_tmp13_;
					goto __finally0;
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->al);
						_g_object_unref0 (_data_->p);
						_g_object_unref0 (_data_->_p_it);
						_g_object_unref0 (_data_->key_file_store);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->al);
						_g_object_unref0 (_data_->p);
						_g_object_unref0 (_data_->_p_it);
						_g_object_unref0 (_data_->key_file_store);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			}
			_g_object_unref0 (_data_->al);
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	_data_->_tmp14_ = _folks_individual_aggregator_build_linking_details (_data_->self, _data_->personas);
	_data_->details = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->key_file_store;
	_data_->_tmp16_ = _data_->details;
	_data_->_state_ = 2;
	folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp15_, _data_->_tmp16_, folks_individual_aggregator_link_personas_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp17_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_g_object_unref0 (_data_->_tmp18_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->details);
			_g_object_unref0 (_data_->key_file_store);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->details);
			_g_object_unref0 (_data_->key_file_store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->key_file_store);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static guint
_folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v,
                                                              gpointer self)
{
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}

static gboolean
_folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a,
                                                                gconstpointer b,
                                                                gpointer self)
{
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}

static GHashTable*
_folks_individual_aggregator_build_linking_details (FolksIndividualAggregator* self,
                                                    GeeSet* personas)
{
	GeeHashMultiMap* protocols_addrs_set = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* web_service_addrs_set = NULL;
	GeeHashMultiMap* _tmp1_;
	FolksSmallSet* local_ids = NULL;
	FolksSmallSet* _tmp2_;
	GHashTable* details = NULL;
	GHashFunc _tmp47_;
	GEqualFunc _tmp48_;
	GHashTable* _tmp49_;
	GeeHashMultiMap* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GeeHashMultiMap* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	FolksSmallSet* _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (personas != NULL, NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	protocols_addrs_set = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	web_service_addrs_set = _tmp1_;
	_tmp2_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	local_ids = _tmp2_;
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) personas);
		_persona_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksPersona* _tmp7_;
			FolksPersona* _tmp22_;
			FolksPersona* _tmp37_;
			_tmp4_ = _persona_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _persona_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			persona = (FolksPersona*) _tmp6_;
			_tmp7_ = persona;
			if (FOLKS_IS_IM_DETAILS (_tmp7_)) {
				FolksImDetails* im_details = NULL;
				FolksPersona* _tmp8_;
				FolksImDetails* _tmp9_;
				GeeMapIterator* iter = NULL;
				FolksImDetails* _tmp10_;
				GeeMultiMap* _tmp11_;
				GeeMultiMap* _tmp12_;
				GeeMapIterator* _tmp13_;
				_tmp8_ = persona;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, FOLKS_TYPE_IM_DETAILS, FolksImDetails));
				im_details = _tmp9_;
				_tmp10_ = im_details;
				_tmp11_ = folks_im_details_get_im_addresses (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_multi_map_map_iterator (_tmp12_);
				iter = _tmp13_;
				while (TRUE) {
					GeeMapIterator* _tmp14_;
					GeeHashMultiMap* _tmp15_;
					GeeMapIterator* _tmp16_;
					gpointer _tmp17_;
					gchar* _tmp18_;
					GeeMapIterator* _tmp19_;
					gpointer _tmp20_;
					FolksImFieldDetails* _tmp21_;
					_tmp14_ = iter;
					if (!gee_map_iterator_next (_tmp14_)) {
						break;
					}
					_tmp15_ = protocols_addrs_set;
					_tmp16_ = iter;
					_tmp17_ = gee_map_iterator_get_key (_tmp16_);
					_tmp18_ = (gchar*) _tmp17_;
					_tmp19_ = iter;
					_tmp20_ = gee_map_iterator_get_value (_tmp19_);
					_tmp21_ = (FolksImFieldDetails*) _tmp20_;
					gee_multi_map_set ((GeeMultiMap*) _tmp15_, _tmp18_, _tmp21_);
					_g_object_unref0 (_tmp21_);
					_g_free0 (_tmp18_);
				}
				_g_object_unref0 (iter);
				_g_object_unref0 (im_details);
			}
			_tmp22_ = persona;
			if (FOLKS_IS_WEB_SERVICE_DETAILS (_tmp22_)) {
				FolksWebServiceDetails* ws_details = NULL;
				FolksPersona* _tmp23_;
				FolksWebServiceDetails* _tmp24_;
				GeeMapIterator* iter = NULL;
				FolksWebServiceDetails* _tmp25_;
				GeeMultiMap* _tmp26_;
				GeeMultiMap* _tmp27_;
				GeeMapIterator* _tmp28_;
				_tmp23_ = persona;
				_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails));
				ws_details = _tmp24_;
				_tmp25_ = ws_details;
				_tmp26_ = folks_web_service_details_get_web_service_addresses (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = gee_multi_map_map_iterator (_tmp27_);
				iter = _tmp28_;
				while (TRUE) {
					GeeMapIterator* _tmp29_;
					GeeHashMultiMap* _tmp30_;
					GeeMapIterator* _tmp31_;
					gpointer _tmp32_;
					gchar* _tmp33_;
					GeeMapIterator* _tmp34_;
					gpointer _tmp35_;
					FolksWebServiceFieldDetails* _tmp36_;
					_tmp29_ = iter;
					if (!gee_map_iterator_next (_tmp29_)) {
						break;
					}
					_tmp30_ = web_service_addrs_set;
					_tmp31_ = iter;
					_tmp32_ = gee_map_iterator_get_key (_tmp31_);
					_tmp33_ = (gchar*) _tmp32_;
					_tmp34_ = iter;
					_tmp35_ = gee_map_iterator_get_value (_tmp34_);
					_tmp36_ = (FolksWebServiceFieldDetails*) _tmp35_;
					gee_multi_map_set ((GeeMultiMap*) _tmp30_, _tmp33_, _tmp36_);
					_g_object_unref0 (_tmp36_);
					_g_free0 (_tmp33_);
				}
				_g_object_unref0 (iter);
				_g_object_unref0 (ws_details);
			}
			_tmp37_ = persona;
			if (FOLKS_IS_LOCAL_ID_DETAILS (_tmp37_)) {
				{
					GeeIterator* _id_it = NULL;
					FolksPersona* _tmp38_;
					GeeSet* _tmp39_;
					GeeSet* _tmp40_;
					GeeIterator* _tmp41_;
					_tmp38_ = persona;
					_tmp39_ = folks_local_id_details_get_local_ids (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails));
					_tmp40_ = _tmp39_;
					_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
					_id_it = _tmp41_;
					while (TRUE) {
						GeeIterator* _tmp42_;
						gchar* id = NULL;
						GeeIterator* _tmp43_;
						gpointer _tmp44_;
						FolksSmallSet* _tmp45_;
						const gchar* _tmp46_;
						_tmp42_ = _id_it;
						if (!gee_iterator_next (_tmp42_)) {
							break;
						}
						_tmp43_ = _id_it;
						_tmp44_ = gee_iterator_get (_tmp43_);
						id = (gchar*) _tmp44_;
						_tmp45_ = local_ids;
						_tmp46_ = id;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
						_g_free0 (id);
					}
					_g_object_unref0 (_id_it);
				}
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp47_ = g_str_hash;
	_tmp48_ = g_str_equal;
	_tmp49_ = g_hash_table_new_full (_tmp47_, _tmp48_, _g_free0_, __vala_GValue_free0_);
	details = _tmp49_;
	_tmp50_ = protocols_addrs_set;
	_tmp51_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_ > 0) {
		GValue im_addresses_value = {0};
		GValue _tmp53_ = {0};
		GeeHashMultiMap* _tmp54_;
		GHashTable* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		GValue _tmp58_;
		GValue _tmp59_;
		GValue* _tmp60_;
		g_value_init (&_tmp53_, GEE_TYPE_MULTI_MAP);
		im_addresses_value = _tmp53_;
		_tmp54_ = protocols_addrs_set;
		g_value_set_object (&im_addresses_value, (GObject*) _tmp54_);
		_tmp55_ = details;
		_tmp56_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
		_tmp57_ = g_strdup ((const gchar*) _tmp56_);
		_tmp58_ = im_addresses_value;
		_tmp59_ = _tmp58_;
		_tmp60_ = __g_value_dup0 (&_tmp59_);
		g_hash_table_insert (_tmp55_, _tmp57_, _tmp60_);
		G_IS_VALUE (&im_addresses_value) ? (g_value_unset (&im_addresses_value), NULL) : NULL;
	}
	_tmp61_ = web_service_addrs_set;
	_tmp62_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp61_);
	_tmp63_ = _tmp62_;
	if (_tmp63_ > 0) {
		GValue web_service_addresses_value = {0};
		GValue _tmp64_ = {0};
		GeeHashMultiMap* _tmp65_;
		GHashTable* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		GValue _tmp69_;
		GValue _tmp70_;
		GValue* _tmp71_;
		g_value_init (&_tmp64_, GEE_TYPE_MULTI_MAP);
		web_service_addresses_value = _tmp64_;
		_tmp65_ = web_service_addrs_set;
		g_value_set_object (&web_service_addresses_value, (GObject*) _tmp65_);
		_tmp66_ = details;
		_tmp67_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
		_tmp68_ = g_strdup ((const gchar*) _tmp67_);
		_tmp69_ = web_service_addresses_value;
		_tmp70_ = _tmp69_;
		_tmp71_ = __g_value_dup0 (&_tmp70_);
		g_hash_table_insert (_tmp66_, _tmp68_, _tmp71_);
		G_IS_VALUE (&web_service_addresses_value) ? (g_value_unset (&web_service_addresses_value), NULL) : NULL;
	}
	_tmp72_ = local_ids;
	_tmp73_ = gee_collection_get_size ((GeeCollection*) _tmp72_);
	_tmp74_ = _tmp73_;
	if (_tmp74_ > 0) {
		GValue local_ids_value = {0};
		GValue _tmp75_ = {0};
		FolksSmallSet* _tmp76_;
		GHashTable* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		GValue _tmp80_;
		GValue _tmp81_;
		GValue* _tmp82_;
		g_value_init (&_tmp75_, GEE_TYPE_SET);
		local_ids_value = _tmp75_;
		_tmp76_ = local_ids;
		g_value_set_object (&local_ids_value, (GObject*) _tmp76_);
		_tmp77_ = details;
		_tmp78_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_LOCAL_IDS);
		_tmp79_ = g_strdup ((const gchar*) _tmp78_);
		_tmp80_ = local_ids_value;
		_tmp81_ = _tmp80_;
		_tmp82_ = __g_value_dup0 (&_tmp81_);
		g_hash_table_insert (_tmp77_, _tmp79_, _tmp82_);
		G_IS_VALUE (&local_ids_value) ? (g_value_unset (&local_ids_value), NULL) : NULL;
	}
	result = details;
	_g_object_unref0 (local_ids);
	_g_object_unref0 (web_service_addrs_set);
	_g_object_unref0 (protocols_addrs_set);
	return result;
}

static void
folks_individual_aggregator_unlink_individual_data_free (gpointer _data)
{
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, _data_);
}

void
folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self,
                                               FolksIndividual* individual,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp1_;
	folks_individual_aggregator_unlink_individual_co (_data_);
}

void
folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Unlinks the given {@link Individual} into its constituent {@link Persona}s.
   *
   * This completely unlinks the given {@link Individual}, destroying all of
   * its writeable {@link Persona}s.
   *
   * The {@link Individual}'s removal is signalled by
   * {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * The {@link Persona}s comprising the {@link Individual} will be re-linked
   * into one or more new {@link Individual}s, depending on how much linking
   * data remains (typically only implicit links remain). The addition of these
   * new {@link Individual}s will be signalled by
   * {@link IndividualAggregator.individuals_changed}.
   *
   * This method is safe to call multiple times concurrently, although
   * concurrent calls for the same individual may result in duplicate personas
   * being created.
   *
   * @param individual the {@link Individual} to unlink
   * @throws GLib.Error if removing the linking persona failed — this will be
   * passed through from {@link PersonaStore.remove_persona}
   *
   * @since 0.1.13
   */
static void
folks_individual_aggregator_unlink_individual_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (_data_);
}

static gboolean
folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_stores;
	_data_->_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp0_, "key-file:relationships.ini");
	_data_->key_file_store = (FolksPersonaStore*) _data_->_tmp1_;
	if (_data_->self->priv->_linking_enabled == FALSE) {
		_data_->_tmp2_ = folks_individual_get_id (_data_->individual);
		_data_->_tmp3_ = _data_->_tmp2_;
		g_debug ("individual-aggregator.vala:2289: Can't unlink Individual '%s': linking" \
" disabled.", _data_->_tmp3_);
		_g_object_unref0 (_data_->key_file_store);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = folks_individual_get_id (_data_->individual);
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("individual-aggregator.vala:2294: Unlinking Individual '%s':", _data_->_tmp5_);
	_data_->_tmp6_ = folks_individual_get_personas (_data_->individual);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = folks_small_set_copy (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeIterable*) _data_->_tmp7_, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->individual_personas = _data_->_tmp8_;
	_data_->_tmp9_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->key_file_personas = _data_->_tmp9_;
	{
		_data_->_tmp10_ = _data_->individual_personas;
		_data_->_p_list = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->_p_list;
		_data_->_tmp12_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_p_size = _data_->_tmp13_;
		_data_->_p_index = -1;
		while (TRUE) {
			_data_->_p_index = _data_->_p_index + 1;
			_data_->_tmp14_ = _data_->_p_index;
			_data_->_tmp15_ = _data_->_p_size;
			if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
				break;
			}
			_data_->_tmp16_ = _data_->_p_list;
			_data_->_tmp17_ = folks_small_set_get (_data_->_tmp16_, _data_->_p_index);
			_data_->_tmp18_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp17_);
			_data_->p = _data_->_tmp18_;
			_data_->_tmp19_ = _data_->p;
			_data_->_tmp20_ = folks_persona_get_store (_data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp22_ = folks_persona_store_get_type_id (_data_->_tmp21_);
			_data_->_tmp23_ = _data_->_tmp22_;
			if (g_strcmp0 (_data_->_tmp23_, "key-file") == 0) {
				g_debug ("individual-aggregator.vala:2315: Remove linking persona from key-file " \
"store");
				_data_->_tmp24_ = _data_->key_file_personas;
				_data_->_tmp25_ = _data_->p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, _data_->_tmp25_);
				_data_->_tmp26_ = _data_->individual_personas;
				_data_->_tmp27_ = _data_->p;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp26_, _data_->_tmp27_);
				_data_->_tmp28_ = _data_->p;
				_data_->_tmp29_ = folks_persona_get_store (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = _data_->p;
				_data_->_state_ = 1;
				folks_persona_store_remove_persona (_data_->_tmp30_, _data_->_tmp31_, folks_individual_aggregator_unlink_individual_ready, _data_);
				return FALSE;
				_state_1:
				folks_persona_store_remove_persona_finish (_data_->_tmp30_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->p);
					_g_object_unref0 (_data_->key_file_personas);
					_g_object_unref0 (_data_->individual_personas);
					_g_object_unref0 (_data_->key_file_store);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->p);
		}
	}
	{
		_data_->_tmp32_ = _data_->individual_personas;
		_data_->_vala1__p_list = _data_->_tmp32_;
		_data_->_tmp33_ = _data_->_vala1__p_list;
		_data_->_tmp34_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_vala1__p_size = _data_->_tmp35_;
		_data_->_vala1__p_index = -1;
		while (TRUE) {
			_data_->_vala1__p_index = _data_->_vala1__p_index + 1;
			_data_->_tmp36_ = _data_->_vala1__p_index;
			_data_->_tmp37_ = _data_->_vala1__p_size;
			if (!(_data_->_tmp36_ < _data_->_tmp37_)) {
				break;
			}
			_data_->_tmp38_ = _data_->_vala1__p_list;
			_data_->_tmp39_ = folks_small_set_get (_data_->_tmp38_, _data_->_vala1__p_index);
			_data_->_tmp40_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp39_);
			_data_->_vala1_p = _data_->_tmp40_;
			_data_->_tmp41_ = _data_->_vala1_p;
			_data_->_tmp42_ = _g_object_ref0 (FOLKS_IS_ANTI_LINKABLE (_data_->_tmp41_) ? ((FolksAntiLinkable*) _data_->_tmp41_) : NULL);
			_data_->al = _data_->_tmp42_;
			_data_->_tmp43_ = _data_->al;
			_vala_assert (_data_->_tmp43_ != NULL, "al != null");
			_data_->_tmp44_ = _data_->al;
			_data_->_tmp45_ = _data_->key_file_personas;
			_data_->_state_ = 2;
			folks_anti_linkable_remove_anti_links (_data_->_tmp44_, (GeeSet*) _data_->_tmp45_, folks_individual_aggregator_unlink_individual_ready, _data_);
			return FALSE;
			_state_2:
			folks_anti_linkable_remove_anti_links_finish (_data_->_tmp44_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->al);
				_g_object_unref0 (_data_->_vala1_p);
				_g_object_unref0 (_data_->key_file_personas);
				_g_object_unref0 (_data_->individual_personas);
				_g_object_unref0 (_data_->key_file_store);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->al);
			_g_object_unref0 (_data_->_vala1_p);
		}
	}
	g_debug ("individual-aggregator.vala:2333:     Inserting anti-links:");
	{
		_data_->_tmp46_ = _data_->individual_personas;
		_data_->_pers_list = _data_->_tmp46_;
		_data_->_tmp47_ = _data_->_pers_list;
		_data_->_tmp48_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp47_);
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_pers_size = _data_->_tmp49_;
		_data_->_pers_index = -1;
		while (TRUE) {
			_data_->_pers_index = _data_->_pers_index + 1;
			_data_->_tmp50_ = _data_->_pers_index;
			_data_->_tmp51_ = _data_->_pers_size;
			if (!(_data_->_tmp50_ < _data_->_tmp51_)) {
				break;
			}
			_data_->_tmp52_ = _data_->_pers_list;
			_data_->_tmp53_ = folks_small_set_get (_data_->_tmp52_, _data_->_pers_index);
			_data_->_tmp54_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp53_);
			_data_->pers = _data_->_tmp54_;
			_data_->_tmp55_ = _data_->pers;
			_data_->_tmp56_ = folks_persona_get_uid (_data_->_tmp55_);
			_data_->_tmp57_ = _data_->_tmp56_;
			_data_->_tmp58_ = _data_->pers;
			g_debug ("individual-aggregator.vala:2336:         Anti-linking persona '%s' (%p" \
")", _data_->_tmp57_, _data_->_tmp58_);
			_data_->_tmp59_ = _data_->pers;
			if (!_folks_individual_aggregator_is_anti_link_property_writeable (_data_->self, _data_->_tmp59_)) {
				g_debug ("individual-aggregator.vala:2340: Anti link property isn't writeable, c" \
"reate a persona in the key-file store");
				_data_->_tmp60_ = _data_->key_file_store;
				if (_data_->_tmp60_ != NULL) {
					_data_->_tmp61_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
					_data_->personas = _data_->_tmp61_;
					_data_->_tmp62_ = _data_->personas;
					_data_->_tmp63_ = _data_->pers;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp62_, _data_->_tmp63_);
					_data_->_tmp64_ = _data_->personas;
					_data_->_tmp65_ = _folks_individual_aggregator_build_linking_details (_data_->self, (GeeSet*) _data_->_tmp64_);
					_data_->details = _data_->_tmp65_;
					_data_->_tmp67_ = _data_->key_file_store;
					_data_->_tmp68_ = _data_->details;
					_data_->_state_ = 3;
					folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp67_, _data_->_tmp68_, folks_individual_aggregator_unlink_individual_ready, _data_);
					return FALSE;
					_state_3:
					_data_->_tmp69_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp66_ = _data_->_tmp69_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_hash_table_unref0 (_data_->details);
						_g_object_unref0 (_data_->personas);
						_g_object_unref0 (_data_->writeable_persona);
						_g_object_unref0 (_data_->pers);
						_g_object_unref0 (_data_->key_file_personas);
						_g_object_unref0 (_data_->individual_personas);
						_g_object_unref0 (_data_->key_file_store);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp70_ = _data_->_tmp66_;
					_data_->_tmp66_ = NULL;
					_g_object_unref0 (_data_->writeable_persona);
					_data_->writeable_persona = _data_->_tmp70_;
					_g_object_unref0 (_data_->_tmp66_);
					_g_hash_table_unref0 (_data_->details);
					_g_object_unref0 (_data_->personas);
				} else {
					g_debug ("individual-aggregator.vala:2349: Key file store doesn't exist, can cre" \
"ate a new writeable persona");
					_g_object_unref0 (_data_->writeable_persona);
					_g_object_unref0 (_data_->pers);
					continue;
				}
			} else {
				_data_->_tmp71_ = _data_->pers;
				_data_->_tmp72_ = _g_object_ref0 (_data_->_tmp71_);
				_g_object_unref0 (_data_->writeable_persona);
				_data_->writeable_persona = _data_->_tmp72_;
			}
			_data_->_tmp73_ = _data_->individual_personas;
			_data_->_tmp74_ = folks_small_set_copy (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeIterable*) _data_->_tmp73_, NULL, NULL, NULL, NULL, NULL, NULL);
			_data_->anti_link_personas = _data_->_tmp74_;
			_data_->_tmp75_ = _data_->anti_link_personas;
			_data_->_tmp76_ = _data_->pers;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp75_, _data_->_tmp76_);
			_data_->_tmp77_ = _data_->writeable_persona;
			_data_->_tmp78_ = _g_object_ref0 (FOLKS_IS_ANTI_LINKABLE (_data_->_tmp77_) ? ((FolksAntiLinkable*) _data_->_tmp77_) : NULL);
			_data_->_vala1_al = _data_->_tmp78_;
			_data_->_tmp79_ = _data_->_vala1_al;
			_vala_assert (_data_->_tmp79_ != NULL, "al != null");
			_data_->_tmp80_ = _data_->_vala1_al;
			_data_->_tmp81_ = _data_->anti_link_personas;
			_data_->_state_ = 4;
			folks_anti_linkable_add_anti_links (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp80_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), (GeeSet*) _data_->_tmp81_, folks_individual_aggregator_unlink_individual_ready, _data_);
			return FALSE;
			_state_4:
			folks_anti_linkable_add_anti_links_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp80_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->_vala1_al);
				_g_object_unref0 (_data_->anti_link_personas);
				_g_object_unref0 (_data_->writeable_persona);
				_g_object_unref0 (_data_->pers);
				_g_object_unref0 (_data_->key_file_personas);
				_g_object_unref0 (_data_->individual_personas);
				_g_object_unref0 (_data_->key_file_store);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			g_debug ("individual-aggregator.vala:2363: ");
			_g_object_unref0 (_data_->_vala1_al);
			_g_object_unref0 (_data_->anti_link_personas);
			_g_object_unref0 (_data_->writeable_persona);
			_g_object_unref0 (_data_->pers);
		}
	}
	_g_object_unref0 (_data_->key_file_personas);
	_g_object_unref0 (_data_->individual_personas);
	_g_object_unref0 (_data_->key_file_store);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
_folks_individual_aggregator_is_anti_link_property_writeable (FolksIndividualAggregator* self,
                                                              FolksPersona* persona)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = folks_persona_get_writeable_properties (persona, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	result = _vala_string_array_contains (_tmp2_, _tmp2__length1, "anti-links");
	return result;
}

static void
folks_individual_aggregator_ensure_individual_property_writeable_data_free (gpointer _data)
{
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData, _data_);
}

void
folks_individual_aggregator_ensure_individual_property_writeable (FolksIndividualAggregator* self,
                                                                  FolksIndividual* individual,
                                                                  const gchar* property_name,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	g_return_if_fail (property_name != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_ensure_individual_property_writeable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp1_;
	_tmp2_ = g_strdup (property_name);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp2_;
	folks_individual_aggregator_ensure_individual_property_writeable_co (_data_);
}

FolksPersona*
folks_individual_aggregator_ensure_individual_property_writeable_finish (FolksIndividualAggregator* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error)
{
	FolksPersona* result;
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Ensure that the given property is writeable for the given
   * {@link Individual}.
   *
   * This makes sure that there is at least one {@link Persona} in the
   * individual which has ``property_name`` in its
   * {@link Persona.writeable_properties}. If no such persona exists in the
   * individual, a new one will be created and linked to the individual. (Note
   * that due to the design of the aggregator, this will result in the previous
   * individual being removed and replaced by a new one with the new persona;
   * listen to the {@link Individual.removed} signal to see the replacement.)
   *
   * It may not be possible to create a new persona which has the given property
   * as writeable. In that case, a
   * {@link IndividualAggregatorError.NO_PRIMARY_STORE} or
   * {@link IndividualAggregatorError.PROPERTY_NOT_WRITEABLE} error will be
   * thrown.
   *
   * This method is safe to call multiple times concurrently, although
   * concurrent calls for the same individual may result in duplicate personas
   * being created.
   *
   * @param individual the individual for which ``property_name`` should be
   * writeable
   * @param property_name the name of the property which needs to be writeable
   * (this should be in lower case using hyphens, e.g. “web-service-addresses”)
   * @return a persona (new or existing) which has the given property as
   * writeable
   * @throws IndividualAggregatorError.NO_PRIMARY_STORE if no primary store was
   * configured for this individual aggregator
   * @throws IndividualAggregatorError.PROPERTY_NOT_WRITEABLE if the given
   * ``property_name`` referred to a non-writeable property
   * @throws IndividualAggregatorError if adding a new persona (using
   * {@link IndividualAggregator.add_persona_from_details}) failed, or if
   * linking personas (using {@link IndividualAggregator.link_personas}) failed
   *
   * @since 0.6.2
   */
static void
folks_individual_aggregator_ensure_individual_property_writeable_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_)
{
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_ensure_individual_property_writeable_co (_data_);
}

static gboolean
folks_individual_aggregator_ensure_individual_property_writeable_co (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_individual_get_id (_data_->individual);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("individual-aggregator.vala:2415: ensure_individual_property_writeable:" \
" %s, %s", _data_->_tmp1_, _data_->property_name);
	_data_->_tmp2_ = folks_individual_get_personas (_data_->individual);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	_folks_individual_aggregator_ensure_personas_property_writeable (_data_->self, _data_->_tmp3_, _data_->property_name, folks_individual_aggregator_ensure_individual_property_writeable_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = _folks_individual_aggregator_ensure_personas_property_writeable_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->p = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->p;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_individual_aggregator_ensure_personas_property_writeable_data_free (gpointer _data)
{
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->personas);
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData, _data_);
}

static void
_folks_individual_aggregator_ensure_personas_property_writeable (FolksIndividualAggregator* self,
                                                                 GeeSet* personas,
                                                                 const gchar* property_name,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_)
{
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	FolksIndividualAggregator* _tmp0_;
	GeeSet* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (personas != NULL);
	g_return_if_fail (property_name != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_individual_aggregator_ensure_personas_property_writeable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (personas);
	_g_object_unref0 (_data_->personas);
	_data_->personas = _tmp1_;
	_tmp2_ = g_strdup (property_name);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp2_;
	_folks_individual_aggregator_ensure_personas_property_writeable_co (_data_);
}

static FolksPersona*
_folks_individual_aggregator_ensure_personas_property_writeable_finish (FolksIndividualAggregator* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error)
{
	FolksPersona* result;
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_folks_individual_aggregator_ensure_personas_property_writeable_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_)
{
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_individual_aggregator_ensure_personas_property_writeable_co (_data_);
}

static gboolean
_folks_individual_aggregator_ensure_personas_property_writeable_co (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data_->personas);
		_data_->_p1_it = _data_->_tmp0_;
		while (TRUE) {
			_data_->_tmp1_ = _data_->_p1_it;
			if (!gee_iterator_next (_data_->_tmp1_)) {
				break;
			}
			_data_->_tmp2_ = _data_->_p1_it;
			_data_->_tmp3_ = gee_iterator_get (_data_->_tmp2_);
			_data_->p1 = (FolksPersona*) _data_->_tmp3_;
			_data_->_tmp4_ = _data_->p1;
			_data_->_tmp6_ = 0;
			_data_->_tmp5_ = folks_persona_get_writeable_properties (_data_->_tmp4_, &_data_->_tmp6_);
			_data_->_tmp5__length1 = _data_->_tmp6_;
			_data_->_tmp7_ = _data_->_tmp5_;
			_data_->_tmp7__length1 = _data_->_tmp5__length1;
			if (_vala_string_array_contains (_data_->_tmp7_, _data_->_tmp7__length1, _data_->property_name)) {
				_data_->_tmp8_ = _data_->p1;
				_data_->_tmp9_ = folks_persona_get_uid (_data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				g_debug ("individual-aggregator.vala:2435:     Returning existing persona: %s", _data_->_tmp10_);
				_data_->result = _data_->p1;
				_g_object_unref0 (_data_->_p1_it);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->p1);
		}
		_g_object_unref0 (_data_->_p1_it);
	}
	_data_->_tmp11_ = _folks_individual_aggregator_build_linking_details (_data_->self, _data_->personas);
	_data_->details = _data_->_tmp11_;
	_data_->new_persona = NULL;
	_data_->_tmp13_ = _data_->self->priv->_primary_store;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->self->priv->_primary_store;
		_data_->_tmp16_ = 0;
		_data_->_tmp15_ = folks_persona_store_get_always_writeable_properties (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), &_data_->_tmp16_);
		_data_->_tmp15__length1 = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->_tmp15_;
		_data_->_tmp17__length1 = _data_->_tmp15__length1;
		_data_->_tmp12_ = _vala_string_array_contains (_data_->_tmp17_, _data_->_tmp17__length1, _data_->property_name);
	} else {
		_data_->_tmp12_ = FALSE;
	}
	if (_data_->_tmp12_) {
		{
			g_debug ("individual-aggregator.vala:2452:     Using writeable store");
			_data_->_tmp19_ = _data_->self->priv->_primary_store;
			_data_->_tmp20_ = _data_->details;
			_data_->_state_ = 1;
			folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), _data_->_tmp20_, _folks_individual_aggregator_ensure_personas_property_writeable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp21_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp18_ = _data_->_tmp21_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					goto __catch0_folks_individual_aggregator_error;
				}
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp22_ = _data_->_tmp18_;
			_data_->_tmp18_ = NULL;
			_g_object_unref0 (_data_->new_persona);
			_data_->new_persona = _data_->_tmp22_;
			_g_object_unref0 (_data_->_tmp18_);
		}
		goto __finally0;
		__catch0_folks_individual_aggregator_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_g_object_unref0 (_data_->new_persona);
			_data_->new_persona = NULL;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp23_ = _data_->new_persona;
	if (_data_->_tmp23_ == NULL) {
		{
			_data_->_tmp24_ = _data_->self->priv->_stores;
			_data_->_tmp25_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp27_);
			_data_->_tmp29_ = _data_->_tmp28_;
			_g_object_unref0 (_data_->_tmp27_);
			_data_->_s_it = _data_->_tmp29_;
			while (TRUE) {
				_data_->_tmp30_ = _data_->_s_it;
				if (!gee_iterator_next (_data_->_tmp30_)) {
					break;
				}
				_data_->_tmp31_ = _data_->_s_it;
				_data_->_tmp32_ = gee_iterator_get (_data_->_tmp31_);
				_data_->s = (FolksPersonaStore*) _data_->_tmp32_;
				_data_->_tmp34_ = _data_->s;
				_data_->_tmp35_ = _data_->self->priv->_primary_store;
				if (_data_->_tmp34_ == _data_->_tmp35_) {
					_data_->_tmp33_ = TRUE;
				} else {
					_data_->_tmp36_ = _data_->s;
					_data_->_tmp38_ = 0;
					_data_->_tmp37_ = folks_persona_store_get_always_writeable_properties (_data_->_tmp36_, &_data_->_tmp38_);
					_data_->_tmp37__length1 = _data_->_tmp38_;
					_data_->_tmp39_ = _data_->_tmp37_;
					_data_->_tmp39__length1 = _data_->_tmp37__length1;
					_data_->_tmp33_ = !_vala_string_array_contains (_data_->_tmp39_, _data_->_tmp39__length1, _data_->property_name);
				}
				if (_data_->_tmp33_) {
					_g_object_unref0 (_data_->s);
					continue;
				}
				{
					_data_->_tmp40_ = _data_->s;
					_data_->_tmp41_ = folks_persona_store_get_id (_data_->_tmp40_);
					_data_->_tmp42_ = _data_->_tmp41_;
					g_debug ("individual-aggregator.vala:2476:     Using store %s", _data_->_tmp42_);
					_data_->_tmp44_ = _data_->s;
					_data_->_tmp45_ = _data_->details;
					_data_->_state_ = 2;
					folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp44_, _data_->_tmp45_, _folks_individual_aggregator_ensure_personas_property_writeable_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp46_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp43_ = _data_->_tmp46_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
							goto __catch1_folks_individual_aggregator_error;
						}
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp47_ = _data_->_tmp43_;
					_data_->_tmp43_ = NULL;
					_g_object_unref0 (_data_->new_persona);
					_data_->new_persona = _data_->_tmp47_;
					_g_object_unref0 (_data_->_tmp43_);
				}
				goto __finally1;
				__catch1_folks_individual_aggregator_error:
				{
					g_clear_error (&_data_->_inner_error0_);
					_g_object_unref0 (_data_->new_persona);
					_data_->new_persona = NULL;
					_g_object_unref0 (_data_->s);
					continue;
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->s);
			}
			_g_object_unref0 (_data_->_s_it);
		}
	}
	_data_->_tmp49_ = _data_->new_persona;
	if (_data_->_tmp49_ == NULL) {
		_data_->_tmp50_ = _data_->self->priv->_primary_store;
		_data_->_tmp48_ = _data_->_tmp50_ == NULL;
	} else {
		_data_->_tmp48_ = FALSE;
	}
	if (_data_->_tmp48_) {
		_data_->_tmp51_ = g_strconcat (_ ("Can’t add personas with no primary store."), "\n", NULL);
		_data_->_tmp52_ = _data_->_tmp51_;
		_data_->_tmp53_ = g_strconcat (_data_->_tmp52_, _ ("Persona store ‘%s:%s’ is configured as primary, but could not be found" \
" or failed to load."), NULL);
		_data_->_tmp54_ = _data_->_tmp53_;
		_data_->_tmp55_ = g_strconcat (_data_->_tmp54_, "\n", NULL);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = g_strconcat (_data_->_tmp56_, _ ("Check the relevant service is running, or change the default store in " \
"that service or using the ‘%s’ GSettings key."), NULL);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = _data_->self->priv->_configured_primary_store_type_id;
		_data_->_tmp60_ = _data_->self->priv->_configured_primary_store_id;
		_data_->_tmp61_ = g_strdup_printf ("%s %s", FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA, FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY);
		_data_->_tmp62_ = _data_->_tmp61_;
		_data_->_tmp63_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE, _data_->_tmp58_, _data_->_tmp59_, _data_->_tmp60_, _data_->_tmp62_);
		_data_->_tmp64_ = _data_->_tmp63_;
		_g_free0 (_data_->_tmp62_);
		_g_free0 (_data_->_tmp58_);
		_g_free0 (_data_->_tmp56_);
		_g_free0 (_data_->_tmp54_);
		_g_free0 (_data_->_tmp52_);
		_data_->_inner_error0_ = _data_->_tmp64_;
		if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp65_ = _data_->new_persona;
		if (_data_->_tmp65_ == NULL) {
			_data_->_tmp66_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE, _ ("Can’t write to requested property (‘%s’) of the writeable store."), _data_->property_name);
			_data_->_inner_error0_ = _data_->_tmp66_;
			if (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp67_ = _data_->new_persona;
	_data_->_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp67_, FOLKS_TYPE_PERSONA, FolksPersona));
	_data_->result = _data_->_tmp68_;
	_g_object_unref0 (_data_->new_persona);
	_g_hash_table_unref0 (_data_->details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_individual_aggregator_look_up_individual_data_free (gpointer _data)
{
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorLookUpIndividualData, _data_);
}

void
folks_individual_aggregator_look_up_individual (FolksIndividualAggregator* self,
                                                const gchar* id,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (FolksIndividualAggregatorLookUpIndividualData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_individual_aggregator_look_up_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	folks_individual_aggregator_look_up_individual_co (_data_);
}

FolksIndividual*
folks_individual_aggregator_look_up_individual_finish (FolksIndividualAggregator* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	FolksIndividual* result;
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Look up an individual in the aggregator.
   *
   * This returns the {@link Individual} with the given ``id`` if it exists in
   * the aggregator, and ``null`` otherwise.
   *
   * In future, when lazy-loading of individuals' properties is added to folks,
   * this method guarantees to load all properties of the individual, even if
   * the aggregator hasn't lazy-loaded anything else.
   *
   * This method is safe to call before {@link IndividualAggregator.prepare} has
   * been called, and will call {@link IndividualAggregator.prepare} itself in
   * that case.
   *
   * This method is safe to call multiple times concurrently.
   *
   * @param id ID of the individual to look up
   * @return individual with ``id``, or ``null`` if no such individual was found
   * @throws GLib.Error from {@link IndividualAggregator.prepare}
   *
   * @since 0.7.0
   */
static void
folks_individual_aggregator_look_up_individual_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_look_up_individual_co (_data_);
}

static gboolean
folks_individual_aggregator_look_up_individual_co (FolksIndividualAggregatorLookUpIndividualData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	folks_individual_aggregator_prepare (_data_->self, folks_individual_aggregator_look_up_individual_ready, _data_);
	return FALSE;
	_state_1:
	folks_individual_aggregator_prepare_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->self->priv->_individuals;
	_data_->_tmp1_ = gee_map_get (_data_->_tmp0_, _data_->id);
	_data_->result = (FolksIndividual*) _data_->_tmp1_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_prepared;
	return result;
}

gboolean
folks_individual_aggregator_get_is_quiescent (FolksIndividualAggregator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_quiescent;
	return result;
}

FolksPersonaStore*
folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self)
{
	FolksPersonaStore* result;
	FolksPersonaStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_store;
	result = _tmp0_;
	return result;
}

FolksBackendStore*
folks_individual_aggregator_get_backend_store (FolksIndividualAggregator* self)
{
	FolksBackendStore* result;
	FolksBackendStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_store;
	result = _tmp0_;
	return result;
}

static void
folks_individual_aggregator_set_backend_store (FolksIndividualAggregator* self,
                                               FolksBackendStore* value)
{
	FolksBackendStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE_PROPERTY]);
}

GeeMap*
folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individuals_ro;
	result = _tmp0_;
	return result;
}

static void
folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self,
                                             GeeMap* value)
{
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = _tmp0_;
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = gee_map_get_read_only_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_PROPERTY]);
}

FolksIndividual*
folks_individual_aggregator_get_user (FolksIndividualAggregator* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
folks_individual_aggregator_set_user (FolksIndividualAggregator* self,
                                      FolksIndividual* value)
{
	FolksIndividual* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_individual_aggregator_get_user (self);
	if (old_value != value) {
		FolksIndividual* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user);
		self->priv->_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_USER_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}

static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}

static void
__folks_individual_aggregator_primary_store_setting_changed_cb_g_settings_changed (GSettings* _sender,
                                                                                   const gchar* key,
                                                                                   gpointer self)
{
	_folks_individual_aggregator_primary_store_setting_changed_cb ((FolksIndividualAggregator*) self, _sender, key);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GObject *
folks_individual_aggregator_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksIndividualAggregator * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	FolksSmallSet* _tmp8_;
	FolksDebug* _tmp9_;
	FolksDebug* _tmp10_;
	gchar* store_config_ids = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp21_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* disable_linking = NULL;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	const gchar* _tmp42_;
	parent_class = G_OBJECT_CLASS (folks_individual_aggregator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_stores);
	self->priv->_stores = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = (GeeMap*) _tmp1_;
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = gee_map_get_read_only_view (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->_link_map);
	self->priv->_link_map = _tmp7_;
	_tmp8_ = folks_small_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_backends);
	self->priv->_backends = _tmp8_;
	_tmp9_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp9_;
	_tmp10_ = self->priv->_debug;
	g_signal_connect_object (_tmp10_, "print-status", (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self, 0);
	_tmp11_ = g_getenv ("FOLKS_PRIMARY_STORE");
	_tmp12_ = g_strdup (_tmp11_);
	store_config_ids = _tmp12_;
	_tmp13_ = store_config_ids;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = g_getenv ("FOLKS_WRITEABLE_STORE");
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (store_config_ids);
		store_config_ids = _tmp15_;
		_tmp16_ = store_config_ids;
		if (_tmp16_ != NULL) {
			gchar* deprecated_warn = NULL;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = g_strdup ("FOLKS_WRITEABLE_STORE is deprecated, ");
			deprecated_warn = _tmp17_;
			_tmp18_ = deprecated_warn;
			_tmp19_ = g_strconcat (_tmp18_, "use FOLKS_PRIMARY_STORE", NULL);
			_g_free0 (deprecated_warn);
			deprecated_warn = _tmp19_;
			_tmp20_ = deprecated_warn;
			g_warning ("individual-aggregator.vala:472: %s", _tmp20_);
			_g_free0 (deprecated_warn);
		}
	}
	_tmp21_ = store_config_ids;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		g_debug ("individual-aggregator.vala:478: Setting primary store IDs from environ" \
"ment variable.");
		_tmp22_ = store_config_ids;
		_folks_individual_aggregator_configure_primary_store (self, (const gchar*) _tmp22_);
	} else {
		GSettings* _tmp27_;
		GSettings* _tmp28_;
		gchar* _tmp29_;
		GSettings* _tmp30_;
		g_debug ("individual-aggregator.vala:483: Setting primary store IDs to defaults.");
		if (HAVE_EDS) {
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = g_strdup ("eds");
			_g_free0 (self->priv->_configured_primary_store_type_id);
			self->priv->_configured_primary_store_type_id = _tmp23_;
			_tmp24_ = g_strdup ("system-address-book");
			_g_free0 (self->priv->_configured_primary_store_id);
			self->priv->_configured_primary_store_id = _tmp24_;
		} else {
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = g_strdup ("key-file");
			_g_free0 (self->priv->_configured_primary_store_type_id);
			self->priv->_configured_primary_store_type_id = _tmp25_;
			_tmp26_ = g_strdup ("");
			_g_free0 (self->priv->_configured_primary_store_id);
			self->priv->_configured_primary_store_id = _tmp26_;
		}
		_tmp27_ = g_settings_new (FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA);
		_g_object_unref0 (self->priv->_primary_store_setting);
		self->priv->_primary_store_setting = _tmp27_;
		_tmp28_ = self->priv->_primary_store_setting;
		_tmp29_ = g_strconcat ("changed::", FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY, NULL);
		g_signal_connect_object (_tmp28_, _tmp29_, (GCallback) __folks_individual_aggregator_primary_store_setting_changed_cb_g_settings_changed, self, 0);
		_g_free0 (_tmp29_);
		_tmp30_ = self->priv->_primary_store_setting;
		_folks_individual_aggregator_primary_store_setting_changed_cb (self, _tmp30_, FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY);
	}
	_tmp31_ = self->priv->_configured_primary_store_type_id;
	_tmp32_ = self->priv->_configured_primary_store_id;
	g_debug ("individual-aggregator.vala:503: Primary store IDs are '%s' and '%s'.", _tmp31_, _tmp32_);
	_tmp33_ = g_getenv ("FOLKS_DISABLE_LINKING");
	_tmp34_ = g_strdup (_tmp33_);
	disable_linking = _tmp34_;
	_tmp35_ = disable_linking;
	if (_tmp35_ != NULL) {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp36_ = disable_linking;
		_tmp37_ = string_strip ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_utf8_strdown (_tmp38_, (gssize) -1);
		_g_free0 (disable_linking);
		disable_linking = _tmp39_;
		_g_free0 (_tmp38_);
	}
	_tmp42_ = disable_linking;
	if (_tmp42_ == NULL) {
		_tmp41_ = TRUE;
	} else {
		const gchar* _tmp43_;
		_tmp43_ = disable_linking;
		_tmp41_ = g_strcmp0 (_tmp43_, "no") == 0;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		const gchar* _tmp44_;
		_tmp44_ = disable_linking;
		_tmp40_ = g_strcmp0 (_tmp44_, "0") == 0;
	}
	self->priv->_linking_enabled = _tmp40_;
	g_debug ("individual-aggregator.vala:513: Constructing IndividualAggregator %p", self);
	_g_free0 (disable_linking);
	_g_free0 (store_config_ids);
	return obj;
}

static void
folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass,
                                        gpointer klass_data)
{
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksIndividualAggregator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_individual_aggregator_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * Whether {@link IndividualAggregator.prepare} has successfully completed for
	   * this aggregator.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED_PROPERTY, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether the aggregator has reached a quiescent state. This will happen at
	   * some point after {@link IndividualAggregator.prepare} has successfully
	   * completed for the aggregator. An aggregator is in a quiescent state when
	   * all the {@link PersonaStore}s listed by its backends have reached a
	   * quiescent state. Once it's reached a quiescent state, this property will
	   * never change again (from ``true`` to ``false``).
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link IndividualAggregator.is_prepared} has changed to ``true``.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT_PROPERTY, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Our configured primary (writeable) store.
	   *
	   * Which one to use is decided (in order or precedence)
	   * by:
	   *
	   * - the FOLKS_PRIMARY_STORE env var (mostly for debugging)
	   * - the GSettings key set in ``_PRIMARY_STORE_CONFIG_KEY`` (system set store)
	   * - going with the ``key-file`` or ``eds`` store as the fall-back option
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE_PROPERTY, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE_PROPERTY] = g_param_spec_object ("primary-store", "primary-store", "primary-store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The backend store providing the persona stores for this aggregator.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE_PROPERTY, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE_PROPERTY] = g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * A map from {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_PROPERTY, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_PROPERTY] = g_param_spec_object ("individuals", "individuals", "individuals", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The {@link Individual} representing the user.
	   *
	   * If it exists, this holds the {@link Individual} who is the user: the
	   * {@link Individual} containing the {@link Persona}s who are the owners of
	   * the accounts for their respective backends.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_USER_PROPERTY, folks_individual_aggregator_properties[FOLKS_INDIVIDUAL_AGGREGATOR_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * If more information about the relationships between {@link Individual}s
	   * which have been linked and unlinked is needed, consider connecting to
	   * {@link IndividualAggregator.individuals_changed_detailed} instead, which is
	   * emitted at the same time as this signal.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been added
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   *
	   * @since 0.5.1
	   */
	folks_individual_aggregator_signals[FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_CHANGED_SIGNAL] = g_signal_new ("individuals-changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST | G_SIGNAL_DEPRECATED, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, GEE_TYPE_SET, GEE_TYPE_SET, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This is emitted at the same time as
	   * {@link IndividualAggregator.individuals_changed}, but includes more
	   * information about the relationships between {@link Individual}s which have
	   * been linked and unlinked.
	   *
	   * Individuals which have been linked will be listed in the multi-map as
	   * mappings from the old individuals to the single new individual which
	   * replaces them (i.e. each of the old individuals will map to the same new
	   * individual). This new individual is the one which will be specified as the
	   * ``replacement_individual`` in the {@link Individual.removed} signal for the
	   * old individuals.
	   *
	   * Individuals which have been unlinked will be listed in the multi-map as
	   * a mapping from the unlinked individual to a set of one or more individuals
	   * which replace it.
	   *
	   * Individuals which have been added will be listed in the multi-map as a
	   * mapping from ``null`` to the set of added individuals. If ``null`` doesn't
	   * map to anything, no individuals have been added to the aggregator.
	   *
	   * Individuals which have been removed will be listed in the multi-map as
	   * mappings from the removed individual to ``null``.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param changes a mapping of old {@link Individual}s to new
	   * {@link Individual}s for the individuals which have changed in the
	   * aggregator
	   *
	   * @since 0.6.2
	   */
	folks_individual_aggregator_signals[FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_CHANGED_DETAILED_SIGNAL] = g_signal_new ("individuals-changed-detailed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MULTI_MAP);
}

static void
folks_individual_aggregator_instance_init (FolksIndividualAggregator * self,
                                           gpointer klass)
{
	self->priv = folks_individual_aggregator_get_instance_private (self);
	self->priv->_primary_store = NULL;
	self->priv->_primary_store_setting = NULL;
	self->priv->_linking_enabled = TRUE;
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_non_quiescent_persona_store_count = (guint) 0;
	self->priv->_non_quiescent_backend_count = (guint) 0;
	self->priv->_is_quiescent = FALSE;
	self->priv->_quiescent_timeout_id = (guint) 0;
	self->priv->_user_configured_primary_store = FALSE;
}

static void
folks_individual_aggregator_finalize (GObject * obj)
{
	FolksIndividualAggregator * self;
	FolksBackendStore* _tmp0_;
	guint _tmp1_;
	FolksDebug* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	g_debug ("individual-aggregator.vala:518: Destroying IndividualAggregator %p", self);
	if (self->priv->_quiescent_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->_quiescent_timeout_id);
		self->priv->_quiescent_timeout_id = (guint) 0;
	}
	_tmp0_ = self->priv->_backend_store;
	g_signal_parse_name ("backend-available", FOLKS_TYPE_BACKEND_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self);
	_tmp2_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self);
	folks_individual_aggregator__instance = NULL;
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_stores);
	_g_object_unref0 (self->priv->_backends);
	_g_object_unref0 (self->priv->_primary_store_setting);
	_g_hash_table_unref0 (self->priv->_link_map);
	_g_object_unref0 (self->priv->_debug);
	_g_free0 (self->priv->_configured_primary_store_type_id);
	_g_free0 (self->priv->_configured_primary_store_id);
	_g_object_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_individuals_ro);
	_g_object_unref0 (self->priv->_user);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}

/**
 * Stores {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s.
 *
 * This is the main interface for client applications.
 *
 * Linking and unlinking of personas and individuals is performed entirely
 * through the aggregator. Personas may be linked together to form individuals;
 * for example, the personas which form ``individual1`` and ``individual2`` may
 * be linked together with ``another_persona`` to give a new {@link Individual}:
 *
 * {{{
 *   var personas = new HashSet<Persona> ();
 *   personas.add_all (individual1.personas);
 *   personas.add_all (individual2.personas);
 *   personas.add (another_persona);
 *   yield my_individual_aggregator.link_personas (personas);
 * }}}
 *
 * The individuals which contained those personas will be removed when
 * {@link IndividualAggregator.link_personas} is called. Any personas in those
 * individuals which were not included in the linking call may end up implicitly
 * linked to the new individual, or may be aggregated into other new
 * individuals.
 *
 * For example, consider the situation where ``individual1`` contains two
 * personas, ``persona1A`` and ``persona1B``; ``individual2`` contains one
 * persona, ``persona2A``; and ``another_persona`` comes from ``individual3``,
 * which also contains ``persona3A`` and ``persona3B``. Calling
 * {@link IndividualAggregator.link_personas} on ``persona1A``, ``persona1B``,
 * ``persona2A`` and ``another_persona`` will result in ``individual1`` and
 * ``individual2`` being removed. A new {@link Individual} will be created
 * containing all the personas passed to the linking function. It might also
 * contain ``persona3A`` and ``persona3B``; or they might be in one or two other
 * new individuals.
 *
 * An existing individual may be unlinked to form singleton
 * individuals for each of its personas:
 * {{{
 *   yield my_individual_aggregator.unlink_individual (my_individual);
 * }}}
 *
 * Note that to link two individuals together, their two sets of personas must
 * be linked together. There is no API to directly link the individuals
 * themselves, as conceptually folks links {@link Persona}s, not
 * {@link Individual}s.
 *
 * Folks does not support having more than one IndividualAggregator
 * instantiated at the same time. Most clients should use
 * {@link IndividualAggregator.dup} to retrieve the IndividualAggregator
 * singleton.
 *
 */
static GType
folks_individual_aggregator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
	GType folks_individual_aggregator_type_id;
	folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
	FolksIndividualAggregator_private_offset = g_type_add_instance_private (folks_individual_aggregator_type_id, sizeof (FolksIndividualAggregatorPrivate));
	return folks_individual_aggregator_type_id;
}

GType
folks_individual_aggregator_get_type (void)
{
	static volatile gsize folks_individual_aggregator_type_id__once = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__once)) {
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = folks_individual_aggregator_get_type_once ();
		g_once_init_leave (&folks_individual_aggregator_type_id__once, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__once;
}

static void
_vala_folks_individual_aggregator_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FolksIndividualAggregator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_prepared (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_quiescent (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE_PROPERTY:
		g_value_set_object (value, folks_individual_aggregator_get_primary_store (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE_PROPERTY:
		g_value_set_object (value, folks_individual_aggregator_get_backend_store (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_PROPERTY:
		g_value_set_object (value, folks_individual_aggregator_get_individuals (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER_PROPERTY:
		g_value_set_object (value, folks_individual_aggregator_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_individual_aggregator_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FolksIndividualAggregator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE_PROPERTY:
		folks_individual_aggregator_set_backend_store (self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS_PROPERTY:
		folks_individual_aggregator_set_individuals (self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER_PROPERTY:
		folks_individual_aggregator_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

