import pathlib
from typing import Self

from ignore.overrides import Override


class Error(Exception):
   """
   Represents an error that can occur during operations.
   """ 

class IOError(Exception):
    """
    An error that occurs when doing I/O.

    Currently, the only case where this error is used is for operating system errors of type `ENOENT`.
    """

    errno: int

    filename: str

    def __init__(self, errno: int, strerror: str, filename: str) -> None: ...


class DirEntry:
    def path(self) -> pathlib.Path: ...

    def depth(self) -> int: ...


class Walk:
    def __init__(self, path: pathlib.Path) -> None: ...

    def __iter__(self) -> Self: ...

    def __next__(self) -> DirEntry: ...


class WalkBuilder:
    def __init__(self, path: pathlib.Path) -> None: ...

    def hidden(self, yes: bool) -> Self: ...

    def ignore(self, yes: bool) -> Self: ...

    def parents(self, yes: bool) -> Self: ...

    def git_ignore(self, yes: bool) -> Self: ...

    def git_global(self, yes: bool) -> Self: ...

    def git_exclude(self, yes: bool) -> Self: ...

    def require_git(self, yes: bool) -> Self: ...

    def overrides(self, overrides: Override) -> Self: ...

    def follow_links(self, yes: bool) -> Self: ...

    def same_file_system(self, yes: bool) -> Self: ...

    def max_depth(self, depth: int | None) -> Self: ...

    def max_filesize(self, filesize: int | None) -> Self: ...

    def add_custom_ignore_filename(self, file_name: str) -> Self: ...

    def add(self, path: pathlib.Path) -> Self: ...

    def add_ignore(self, path: pathlib.Path) -> None: ...

    def build(self) -> Walk: ...

