var libssh_tutorial =
[
    [ "Introduction", "libssh_tutorial.html#introduction", null ],
    [ "Chapter 1: A typical SSH session", "libssh_tutor_guided_tour.html", [
      [ "A typical SSH session", "libssh_tutor_guided_tour.html#ssh_session", [
        [ "Creating the session and setting options", "libssh_tutor_guided_tour.html#setup", null ],
        [ "Connecting to the server", "libssh_tutor_guided_tour.html#connect", null ],
        [ "Authenticating the server", "libssh_tutor_guided_tour.html#serverauth", null ],
        [ "Authenticating the user", "libssh_tutor_guided_tour.html#auth", null ],
        [ "Doing something", "libssh_tutor_guided_tour.html#using_ssh", null ],
        [ "Handling the errors", "libssh_tutor_guided_tour.html#errors", null ]
      ] ]
    ] ],
    [ "Chapter 2: A deeper insight on authentication", "libssh_tutor_authentication.html", [
      [ "A deeper insight on authentication", "libssh_tutor_authentication.html#authentication_details", [
        [ "Authenticating with public keys", "libssh_tutor_authentication.html#pubkeys", null ],
        [ "Authenticating with a password", "libssh_tutor_authentication.html#password", null ],
        [ "The keyboard-interactive authentication method", "libssh_tutor_authentication.html#keyb_int", null ],
        [ "Authenticating with \"none\" method", "libssh_tutor_authentication.html#none", null ],
        [ "Getting the list of supported authentications", "libssh_tutor_authentication.html#auth_list", null ],
        [ "Getting the banner", "libssh_tutor_authentication.html#banner", null ]
      ] ]
    ] ],
    [ "Chapter 3: Opening a remote shell", "libssh_tutor_shell.html", [
      [ "Opening a remote shell", "libssh_tutor_shell.html#opening_shell", [
        [ "Opening and closing a channel", "libssh_tutor_shell.html#open_channel", null ],
        [ "Interactive and non-interactive sessions", "libssh_tutor_shell.html#interactive", null ],
        [ "Displaying the data sent by the remote computer", "libssh_tutor_shell.html#read_data", null ],
        [ "Sending user input to the remote computer", "libssh_tutor_shell.html#write_data", null ],
        [ "A more elaborate way to get the remote data", "libssh_tutor_shell.html#select_loop", null ],
        [ "Using graphical applications on the remote side", "libssh_tutor_shell.html#x11", null ]
      ] ]
    ] ],
    [ "Chapter 4: Passing a remote command", "libssh_tutor_command.html", [
      [ "Passing a remote command", "libssh_tutor_command.html#remote_command", [
        [ "Executing a remote command", "libssh_tutor_command.html#exec_remote", null ]
      ] ]
    ] ],
    [ "Chapter 5: The SFTP subsystem", "libssh_tutor_sftp.html", [
      [ "The SFTP subsystem", "libssh_tutor_sftp.html#sftp_subsystem", [
        [ "Opening and closing a SFTP session", "libssh_tutor_sftp.html#sftp_session", null ],
        [ "Analyzing SFTP errors", "libssh_tutor_sftp.html#sftp_errors", null ],
        [ "Creating a directory", "libssh_tutor_sftp.html#sftp_mkdir", null ],
        [ "Writing to a file on the remote computer", "libssh_tutor_sftp.html#sftp_write", null ],
        [ "Reading a file from the remote computer", "libssh_tutor_sftp.html#sftp_read", null ],
        [ "Performing an asynchronous read/write on a file on the remote computer", "libssh_tutor_sftp.html#sftp_aio", null ],
        [ "Listing the contents of a directory", "libssh_tutor_sftp.html#sftp_ls", null ]
      ] ]
    ] ],
    [ "Chapter 6: The SCP subsystem", "libssh_tutor_scp.html", [
      [ "The SCP subsystem", "libssh_tutor_scp.html#scp_subsystem", [
        [ "Opening and closing a SCP session", "libssh_tutor_scp.html#scp_session", null ],
        [ "Creating files and directories", "libssh_tutor_scp.html#scp_write", null ],
        [ "Copying full directory trees to the remote server", "libssh_tutor_scp.html#scp_recursive_write", null ],
        [ "Reading files and directories", "libssh_tutor_scp.html#scp_read", null ],
        [ "Receiving full directory trees from the remote server", "libssh_tutor_scp.html#scp_recursive_read", null ]
      ] ]
    ] ],
    [ "Chapter 7: Forwarding connections (tunnel)", "libssh_tutor_forwarding.html", [
      [ "Forwarding connections", "libssh_tutor_forwarding.html#forwarding_connections", [
        [ "Direct port forwarding", "libssh_tutor_forwarding.html#forwarding_direct", null ],
        [ "Reverse port forwarding", "libssh_tutor_forwarding.html#forwarding_reverse", null ],
        [ "X11 tunnels", "libssh_tutor_forwarding.html#forwarding_x11", null ],
        [ "Doing direct port forwarding with libssh", "libssh_tutor_forwarding.html#libssh_direct", null ],
        [ "Doing reverse port forwarding with libssh", "libssh_tutor_forwarding.html#libssh_reverse", null ]
      ] ]
    ] ],
    [ "Chapter 8: Threads with libssh", "libssh_tutor_threads.html", [
      [ "How to use libssh with threads", "libssh_tutor_threads.html#threads_with_libssh", [
        [ "Initialization of threads", "libssh_tutor_threads.html#threads_init", null ],
        [ "Using libpthread with libssh", "libssh_tutor_threads.html#threads_pthread", null ],
        [ "Using another threading library", "libssh_tutor_threads.html#threads_other", null ]
      ] ]
    ] ],
    [ "Chapter 9: Authentication using PKCS #11 URIs", "libssh_tutor_pkcs11.html", [
      [ "How to use PKCS #11 URIs in libssh?", "libssh_tutor_pkcs11.html#how_to", null ],
      [ "Pre-requisites (OpenSSL &lt; 3.0):", "libssh_tutor_pkcs11.html#autotoc_md1", null ],
      [ "Pre-requisites (OpenSSL 3.0.8+)", "libssh_tutor_pkcs11.html#autotoc_md2", null ],
      [ "New API functions", "libssh_tutor_pkcs11.html#autotoc_md3", [
        [ "Caveats", "libssh_tutor_pkcs11.html#Caveats", null ]
      ] ]
    ] ],
    [ "Chapter 10: The SFTP asynchronous I/O", "libssh_tutor_sftp_aio.html", [
      [ "The SFTP asynchronous I/O", "libssh_tutor_sftp_aio.html#sftp_aio_api", [
        [ "Using the sftp aio API for reading (a basic example)", "libssh_tutor_sftp_aio.html#sftp_aio_read", null ],
        [ "Using the sftp aio API for writing (a basic example)", "libssh_tutor_sftp_aio.html#sftp_aio_write", null ],
        [ "Using the sftp aio API to speed up a transfer", "libssh_tutor_sftp_aio.html#sftp_aio_actual_use", null ],
        [ "Capping applied by the sftp aio API", "libssh_tutor_sftp_aio.html#sftp_aio_cap", null ],
        [ "Performing a download using the sftp aio API", "libssh_tutor_sftp_aio.html#sftp_aio_download_example", null ],
        [ "Performing an upload using the sftp aio API", "libssh_tutor_sftp_aio.html#sftp_aio_upload_example", null ],
        [ "Example showing the usage of sftp_aio_free()", "libssh_tutor_sftp_aio.html#sftp_aio_free", null ]
      ] ]
    ] ],
    [ "Chapter 11: FIDO2/U2F Keys Support", "libssh_tutor_fido2.html", [
      [ "Introduction", "libssh_tutor_fido2.html#fido2_intro", [
        [ "Resident Keys", "libssh_tutor_fido2.html#fido2_resident_keys", null ],
        [ "User Presence vs. User Verification", "libssh_tutor_fido2.html#fido2_presence_verification", null ],
        [ "The Callback Abstraction", "libssh_tutor_fido2.html#fido2_callbacks", null ],
        [ "Building with FIDO2 Support", "libssh_tutor_fido2.html#fido2_build", null ],
        [ "API Overview", "libssh_tutor_fido2.html#fido2_api_overview", null ],
        [ "Security Key Objects &amp; Metadata", "libssh_tutor_fido2.html#fido2_key_objects", null ],
        [ "Setting Security Key Context Options", "libssh_tutor_fido2.html#fido2_options", null ],
        [ "Enrollment Example", "libssh_tutor_fido2.html#fido2_enrollment", null ],
        [ "Authenticating with a Stored Security Key Public Key", "libssh_tutor_fido2.html#fido2_signing", null ],
        [ "Resident Key Enumeration", "libssh_tutor_fido2.html#fido2_resident", null ],
        [ "Signing using the sshsig API", "libssh_tutor_fido2.html#fido2_sshsig", null ],
        [ "Implementing Custom Callback Implementations", "libssh_tutor_fido2.html#fido2_custom_callbacks", [
          [ "API Version Compatibility", "libssh_tutor_fido2.html#fido2_custom_callbacks_version", null ],
          [ "Implementation Example", "libssh_tutor_fido2.html#fido2_custom_callbacks_implementation", null ],
          [ "Passing Custom Options", "libssh_tutor_fido2.html#fido2_custom_callbacks_options", null ],
          [ "OpenSSH Middleware Compatibility", "libssh_tutor_fido2.html#fido2_custom_callbacks_openssh", null ]
        ] ],
        [ "Testing and Environment Variables", "libssh_tutor_fido2.html#fido2_testing", null ]
      ] ]
    ] ],
    [ "To be done", "libssh_tutor_todo.html", [
      [ "Writing a libssh-based server", "libssh_tutor_todo.html#sshd", null ],
      [ "The libssh C++ wrapper", "libssh_tutor_todo.html#cpp", null ]
    ] ]
];