'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   This Software is provided under the Zope Public License (ZPL) Version 2.1.
''
''   Copyright (c) 2009, 2010 by the mingw-w64 project
''
''   See the AUTHORS file for the list of contributors to the mingw-w64 project.
''
''   This license has been certified as open source. It has also been designated
''   as GPL compatible by the Free Software Foundation (FSF).
''
''   Redistribution and use in source and binary forms, with or without
''   modification, are permitted provided that the following conditions are met:
''
''     1. Redistributions in source code must retain the accompanying copyright
''        notice, this list of conditions, and the following disclaimer.
''     2. Redistributions in binary form must reproduce the accompanying
''        copyright notice, this list of conditions, and the following disclaimer
''        in the documentation and/or other materials provided with the
''        distribution.
''     3. Names of the copyright holders must not be used to endorse or promote
''        products derived from this software without prior written permission
''        from the copyright holders.
''     4. The right to distribute this software or to use it for any purpose does
''        not give you the right to use Servicemarks (sm) or Trademarks (tm) of
''        the copyright holders.  Use of them is covered by separate agreement
''        with the copyright holders.
''     5. If any files are modified, you must cause the modified files to carry
''        prominent notices stating that you changed the files and the date of
''        any change.
''
''   Disclaimer
''
''   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESSED
''   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
''   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
''   EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
''   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
''   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
''   OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
''   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
''   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
''   EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#if _WIN32_WINNT >= &h0600
	#include once "winapifamily.bi"
	#include once "wlantypes.bi"

	extern "C"

	#define __WINDOT11_H__
#endif

#if _WIN32_WINNT >= &h0601
	const NWF_EXTAP_SUPPORTED = 1
	const NWF_VWIFI_SUPPORTED = 1
#endif

#if _WIN32_WINNT = &h0602
	const NWF_WFD_SUPPORTED = 1
	const NWF_POWER_SAVE_SUPPORTED = 1
#endif

#if _WIN32_WINNT >= &h0600
	const DOT11_RATE_SET_MAX_LENGTH = 126
	const DOT11_BSSID_LIST_REVISION_1 = 1
	type PDOT11_MAC_ADDRESS as UCHAR ptr

	type DOT11_BSSID_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		BSSIDs(0 to 0, 0 to 5) as UCHAR
	end type

	type PDOT11_BSSID_LIST as DOT11_BSSID_LIST ptr

	type _DOT11_PHY_TYPE as long
	enum
		dot11_phy_type_unknown = 0
		dot11_phy_type_any = dot11_phy_type_unknown
		dot11_phy_type_fhss = 1
		dot11_phy_type_dsss = 2
		dot11_phy_type_irbaseband = 3
		dot11_phy_type_ofdm = 4
		dot11_phy_type_hrdsss = 5
		dot11_phy_type_erp = 6
		dot11_phy_type_ht = 7
		dot11_phy_type_IHV_start = &h80000000
		dot11_phy_type_IHV_end = &hffffffff
	end enum

	type DOT11_PHY_TYPE as _DOT11_PHY_TYPE
	type PDOT11_PHY_TYPE as _DOT11_PHY_TYPE ptr

	type _DOT11_RATE_SET
		uRateSetLength as ULONG
		ucRateSet(0 to 125) as UCHAR
	end type

	type DOT11_RATE_SET as _DOT11_RATE_SET
	type PDOT11_RATE_SET as _DOT11_RATE_SET ptr
	type PDOT11_COUNTRY_OR_REGION_STRING as UCHAR ptr
	type DOT11_DIALOG_TOKEN as UCHAR
	type DOT11_WFD_STATUS_CODE as UCHAR
	type DOT11_WFD_MINOR_REASON_CODE as UCHAR

	const NDIS_PACKET_TYPE_MEDIA_SPECIFIC_MASK = &h0fff0000u
	const NDIS_PACKET_TYPE_802_11_RAW_DATA = &h00010000u
	const NDIS_PACKET_TYPE_802_11_DIRECTED_MGMT = &h00020000u
	const NDIS_PACKET_TYPE_802_11_BROADCAST_MGMT = &h00040000u
	const NDIS_PACKET_TYPE_802_11_MULTICAST_MGMT = &h00080000u
	const NDIS_PACKET_TYPE_802_11_ALL_MULTICAST_MGMT = &h00100000u
	const NDIS_PACKET_TYPE_802_11_PROMISCUOUS_MGMT = &h00200000u
	const NDIS_PACKET_TYPE_802_11_RAW_MGMT = &h00400000u
	const NDIS_PACKET_TYPE_802_11_DIRECTED_CTRL = &h00800000u
	const NDIS_PACKET_TYPE_802_11_BROADCAST_CTRL = &h01000000u
	const NDIS_PACKET_TYPE_802_11_PROMISCUOUS_CTRL = &h02000000u
	#define NDIS_PACKET_TYPE_ALL_802_11_FILTERS culng(culng(culng(culng(culng(culng(culng(culng(culng(culng(((((NDIS_PACKET_TYPE_DIRECTED or NDIS_PACKET_TYPE_MULTICAST) or NDIS_PACKET_TYPE_ALL_MULTICAST) or NDIS_PACKET_TYPE_BROADCAST) or NDIS_PACKET_TYPE_PROMISCUOUS) or NDIS_PACKET_TYPE_802_11_RAW_DATA) or NDIS_PACKET_TYPE_802_11_DIRECTED_MGMT) or NDIS_PACKET_TYPE_802_11_BROADCAST_MGMT) or NDIS_PACKET_TYPE_802_11_MULTICAST_MGMT) or NDIS_PACKET_TYPE_802_11_ALL_MULTICAST_MGMT) or NDIS_PACKET_TYPE_802_11_PROMISCUOUS_MGMT) or NDIS_PACKET_TYPE_802_11_RAW_MGMT) or NDIS_PACKET_TYPE_802_11_DIRECTED_CTRL) or NDIS_PACKET_TYPE_802_11_BROADCAST_CTRL) or NDIS_PACKET_TYPE_802_11_PROMISCUOUS_CTRL)
	const DOT11_MAX_PDU_SIZE = 2346
	const DOT11_MIN_PDU_SIZE = 256
	const DOT11_MAX_NUM_DEFAULT_KEY = 4
#endif

#if _WIN32_WINNT = &h0602
	const DOT11_MAX_NUM_DEFAULT_KEY_MFP = DOT11_MAX_NUM_DEFAULT_KEY + 2
#endif

#if _WIN32_WINNT >= &h0600
	const OID_DOT11_NDIS_START = &h0d010300
	const NWF_MANDATORY_OID = &h01u
	const NWF_OPTIONAL_OID = &h02u
	const NWF_OPERATIONAL_OID = &h01u
	const NWF_STATISTICS_OID = &h02u
	#define NWF_DEFINE_OID(Seq, o, m) (((&h0e000000u or ((o) shl 16)) or ((m) shl 8)) or (Seq))
	const OID_DOT11_OFFLOAD_CAPABILITY = OID_DOT11_NDIS_START + 0
	const DOT11_HW_WEP_SUPPORTED_TX = &h00000001
	const DOT11_HW_WEP_SUPPORTED_RX = &h00000002
	const DOT11_HW_FRAGMENTATION_SUPPORTED = &h00000004
	const DOT11_HW_DEFRAGMENTATION_SUPPORTED = &h00000008
	const DOT11_HW_MSDU_AUTH_SUPPORTED_TX = &h00000010
	const DOT11_HW_MSDU_AUTH_SUPPORTED_RX = &h00000020
	const DOT11_CONF_ALGO_WEP_RC4 = &h00000001
	const DOT11_CONF_ALGO_TKIP = &h00000002
	const DOT11_AUTH_ALGO_MICHAEL = &h00000001
	const DOT11_OPERATION_MODE_UNKNOWN = &h00000000
	const DOT11_OPERATION_MODE_STATION = &h00000001
	const DOT11_OPERATION_MODE_AP = &h00000002
	const DOT11_OPERATION_MODE_EXTENSIBLE_STATION = &h00000004
	const DOT11_OPERATION_MODE_EXTENSIBLE_AP = &h00000008
	const DOT11_OPERATION_MODE_WFD_DEVICE = &h00000010
	const DOT11_OPERATION_MODE_WFD_GROUP_OWNER = &h00000020
	const DOT11_OPERATION_MODE_WFD_CLIENT = &h00000040
	const DOT11_OPERATION_MODE_MANUFACTURING = &h40000000
	const DOT11_OPERATION_MODE_NETWORK_MONITOR = &h80000000
	const DOT11_PACKET_TYPE_DIRECTED_CTRL = &h00000001
	const DOT11_PACKET_TYPE_DIRECTED_MGMT = &h00000002
	const DOT11_PACKET_TYPE_DIRECTED_DATA = &h00000004
	const DOT11_PACKET_TYPE_MULTICAST_CTRL = &h00000008
	const DOT11_PACKET_TYPE_MULTICAST_MGMT = &h00000010
	const DOT11_PACKET_TYPE_MULTICAST_DATA = &h00000020
	const DOT11_PACKET_TYPE_BROADCAST_CTRL = &h00000040
	const DOT11_PACKET_TYPE_BROADCAST_MGMT = &h00000080
	const DOT11_PACKET_TYPE_BROADCAST_DATA = &h00000100
	const DOT11_PACKET_TYPE_PROMISCUOUS_CTRL = &h00000200
	const DOT11_PACKET_TYPE_PROMISCUOUS_MGMT = &h00000400
	const DOT11_PACKET_TYPE_PROMISCUOUS_DATA = &h00000800
	const DOT11_PACKET_TYPE_ALL_MULTICAST_CTRL = &h00001000
	const DOT11_PACKET_TYPE_ALL_MULTICAST_MGMT = &h00002000
	const DOT11_PACKET_TYPE_ALL_MULTICAST_DATA = &h00004000
	const DOT11_PACKET_TYPE_RESERVED = not (((((((((((((((DOT11_PACKET_TYPE_DIRECTED_CTRL or DOT11_PACKET_TYPE_DIRECTED_MGMT) or DOT11_PACKET_TYPE_DIRECTED_DATA) or DOT11_PACKET_TYPE_MULTICAST_CTRL) or DOT11_PACKET_TYPE_MULTICAST_MGMT) or DOT11_PACKET_TYPE_MULTICAST_DATA) or DOT11_PACKET_TYPE_BROADCAST_CTRL) or DOT11_PACKET_TYPE_BROADCAST_MGMT) or DOT11_PACKET_TYPE_BROADCAST_DATA) or DOT11_PACKET_TYPE_PROMISCUOUS_CTRL) or DOT11_PACKET_TYPE_PROMISCUOUS_MGMT) or DOT11_PACKET_TYPE_PROMISCUOUS_DATA) or DOT11_PACKET_TYPE_ALL_MULTICAST_CTRL) or DOT11_PACKET_TYPE_ALL_MULTICAST_MGMT) or DOT11_PACKET_TYPE_ALL_MULTICAST_DATA) or 0)
	const OID_DOT11_CURRENT_OFFLOAD_CAPABILITY = OID_DOT11_NDIS_START + 1
	const OID_DOT11_WEP_OFFLOAD = OID_DOT11_NDIS_START + 2
	const OID_DOT11_WEP_UPLOAD = OID_DOT11_NDIS_START + 3
	const OID_DOT11_DEFAULT_WEP_OFFLOAD = OID_DOT11_NDIS_START + 4
	const OID_DOT11_DEFAULT_WEP_UPLOAD = OID_DOT11_NDIS_START + 5
	const OID_DOT11_MPDU_MAX_LENGTH = OID_DOT11_NDIS_START + 6
	const OID_DOT11_OPERATION_MODE_CAPABILITY = OID_DOT11_NDIS_START + 7
	const OID_DOT11_CURRENT_OPERATION_MODE = OID_DOT11_NDIS_START + 8
	const OID_DOT11_CURRENT_PACKET_FILTER = OID_DOT11_NDIS_START + 9

	type _DOT11_OFFLOAD_CAPABILITY
		uReserved as ULONG
		uFlags as ULONG
		uSupportedWEPAlgorithms as ULONG
		uNumOfReplayWindows as ULONG
		uMaxWEPKeyMappingLength as ULONG
		uSupportedAuthAlgorithms as ULONG
		uMaxAuthKeyMappingLength as ULONG
	end type

	type DOT11_OFFLOAD_CAPABILITY as _DOT11_OFFLOAD_CAPABILITY
	type PDOT11_OFFLOAD_CAPABILITY as _DOT11_OFFLOAD_CAPABILITY ptr

	type _DOT11_CURRENT_OFFLOAD_CAPABILITY
		uReserved as ULONG
		uFlags as ULONG
	end type

	type DOT11_CURRENT_OFFLOAD_CAPABILITY as _DOT11_CURRENT_OFFLOAD_CAPABILITY
	type PDOT11_CURRENT_OFFLOAD_CAPABILITY as _DOT11_CURRENT_OFFLOAD_CAPABILITY ptr

	type _DOT11_OFFLOAD_TYPE as long
	enum
		dot11_offload_type_wep = 1
		dot11_offload_type_auth = 2
	end enum

	type DOT11_OFFLOAD_TYPE as _DOT11_OFFLOAD_TYPE
	type PDOT11_OFFLOAD_TYPE as _DOT11_OFFLOAD_TYPE ptr

	type _DOT11_IV48_COUNTER
		uIV32Counter as ULONG
		usIV16Counter as USHORT
	end type

	type DOT11_IV48_COUNTER as _DOT11_IV48_COUNTER
	type PDOT11_IV48_COUNTER as _DOT11_IV48_COUNTER ptr

	type _DOT11_WEP_OFFLOAD
		uReserved as ULONG
		hOffloadContext as HANDLE
		hOffload as HANDLE
		dot11OffloadType as DOT11_OFFLOAD_TYPE
		dwAlgorithm as ULONG
		bRowIsOutbound as WINBOOLEAN
		bUseDefault as WINBOOLEAN
		uFlags as ULONG
		ucMacAddress(0 to 5) as UCHAR
		uNumOfRWsOnPeer as ULONG
		uNumOfRWsOnMe as ULONG
		dot11IV48Counters(0 to 15) as DOT11_IV48_COUNTER
		usDot11RWBitMaps(0 to 15) as USHORT
		usKeyLength as USHORT
		ucKey(0 to 0) as UCHAR
	end type

	type DOT11_WEP_OFFLOAD as _DOT11_WEP_OFFLOAD
	type PDOT11_WEP_OFFLOAD as _DOT11_WEP_OFFLOAD ptr

	type _DOT11_WEP_UPLOAD
		uReserved as ULONG
		dot11OffloadType as DOT11_OFFLOAD_TYPE
		hOffload as HANDLE
		uNumOfRWsUsed as ULONG
		dot11IV48Counters(0 to 15) as DOT11_IV48_COUNTER
		usDot11RWBitMaps(0 to 15) as USHORT
	end type

	type DOT11_WEP_UPLOAD as _DOT11_WEP_UPLOAD
	type PDOT11_WEP_UPLOAD as _DOT11_WEP_UPLOAD ptr

	type _DOT11_KEY_DIRECTION as long
	enum
		dot11_key_direction_both = 1
		dot11_key_direction_inbound = 2
		dot11_key_direction_outbound = 3
	end enum

	type DOT11_KEY_DIRECTION as _DOT11_KEY_DIRECTION
	type PDOT11_KEY_DIRECTION as _DOT11_KEY_DIRECTION ptr

	type _DOT11_DEFAULT_WEP_OFFLOAD
		uReserved as ULONG
		hOffloadContext as HANDLE
		hOffload as HANDLE
		dwIndex as ULONG
		dot11OffloadType as DOT11_OFFLOAD_TYPE
		dwAlgorithm as ULONG
		uFlags as ULONG
		dot11KeyDirection as DOT11_KEY_DIRECTION
		ucMacAddress(0 to 5) as UCHAR
		uNumOfRWsOnMe as ULONG
		dot11IV48Counters(0 to 15) as DOT11_IV48_COUNTER
		usDot11RWBitMaps(0 to 15) as USHORT
		usKeyLength as USHORT
		ucKey(0 to 0) as UCHAR
	end type

	type DOT11_DEFAULT_WEP_OFFLOAD as _DOT11_DEFAULT_WEP_OFFLOAD
	type PDOT11_DEFAULT_WEP_OFFLOAD as _DOT11_DEFAULT_WEP_OFFLOAD ptr

	type _DOT11_DEFAULT_WEP_UPLOAD
		uReserved as ULONG
		dot11OffloadType as DOT11_OFFLOAD_TYPE
		hOffload as HANDLE
		uNumOfRWsUsed as ULONG
		dot11IV48Counters(0 to 15) as DOT11_IV48_COUNTER
		usDot11RWBitMaps(0 to 15) as USHORT
	end type

	type DOT11_DEFAULT_WEP_UPLOAD as _DOT11_DEFAULT_WEP_UPLOAD
	type PDOT11_DEFAULT_WEP_UPLOAD as _DOT11_DEFAULT_WEP_UPLOAD ptr

	type _DOT11_OPERATION_MODE_CAPABILITY
		uReserved as ULONG
		uMajorVersion as ULONG
		uMinorVersion as ULONG
		uNumOfTXBuffers as ULONG
		uNumOfRXBuffers as ULONG
		uOpModeCapability as ULONG
	end type

	type DOT11_OPERATION_MODE_CAPABILITY as _DOT11_OPERATION_MODE_CAPABILITY
	type PDOT11_OPERATION_MODE_CAPABILITY as _DOT11_OPERATION_MODE_CAPABILITY ptr

	type _DOT11_CURRENT_OPERATION_MODE
		uReserved as ULONG
		uCurrentOpMode as ULONG
	end type

	type DOT11_CURRENT_OPERATION_MODE as _DOT11_CURRENT_OPERATION_MODE
	type PDOT11_CURRENT_OPERATION_MODE as _DOT11_CURRENT_OPERATION_MODE ptr

	type _DOT11_SCAN_TYPE as long
	enum
		dot11_scan_type_active = 1
		dot11_scan_type_passive = 2
		dot11_scan_type_auto = 3
		dot11_scan_type_forced = &h80000000
	end enum

	type DOT11_SCAN_TYPE as _DOT11_SCAN_TYPE
	type PDOT11_SCAN_TYPE as _DOT11_SCAN_TYPE ptr

	type _DOT11_SCAN_REQUEST
		dot11BSSType as DOT11_BSS_TYPE
		dot11BSSID(0 to 5) as UCHAR
		dot11SSID as DOT11_SSID
		dot11ScanType as DOT11_SCAN_TYPE
		bRestrictedScan as WINBOOLEAN
		bUseRequestIE as WINBOOLEAN
		uRequestIDsOffset as ULONG
		uNumOfRequestIDs as ULONG
		uPhyTypesOffset as ULONG
		uNumOfPhyTypes as ULONG
		uIEsOffset as ULONG
		uIEsLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_SCAN_REQUEST as _DOT11_SCAN_REQUEST
	type PDOT11_SCAN_REQUEST as _DOT11_SCAN_REQUEST ptr

	type _CH_DESCRIPTION_TYPE as long
	enum
		ch_description_type_logical = 1
		ch_description_type_center_frequency = 2
		ch_description_type_phy_specific
	end enum

	type CH_DESCRIPTION_TYPE as _CH_DESCRIPTION_TYPE
	type PCH_DESCRIPTION_TYPE as _CH_DESCRIPTION_TYPE ptr

	type _DOT11_PHY_TYPE_INFO
		dot11PhyType as DOT11_PHY_TYPE
		bUseParameters as WINBOOLEAN
		uProbeDelay as ULONG
		uMinChannelTime as ULONG
		uMaxChannelTime as ULONG
		ChDescriptionType as CH_DESCRIPTION_TYPE
		uChannelListSize as ULONG
		ucChannelListBuffer(0 to 0) as UCHAR
	end type

	type DOT11_PHY_TYPE_INFO as _DOT11_PHY_TYPE_INFO
	type PDOT11_PHY_TYPE_INFO as _DOT11_PHY_TYPE_INFO ptr

	type _DOT11_SCAN_REQUEST_V2
		dot11BSSType as DOT11_BSS_TYPE
		dot11BSSID(0 to 5) as UCHAR
		dot11ScanType as DOT11_SCAN_TYPE
		bRestrictedScan as WINBOOLEAN
		udot11SSIDsOffset as ULONG
		uNumOfdot11SSIDs as ULONG
		bUseRequestIE as WINBOOLEAN
		uRequestIDsOffset as ULONG
		uNumOfRequestIDs as ULONG
		uPhyTypeInfosOffset as ULONG
		uNumOfPhyTypeInfos as ULONG
		uIEsOffset as ULONG
		uIEsLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_SCAN_REQUEST_V2 as _DOT11_SCAN_REQUEST_V2
	type PDOT11_SCAN_REQUEST_V2 as _DOT11_SCAN_REQUEST_V2 ptr

	type DOT11_PHY_TYPE_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11PhyType(0 to 0) as DOT11_PHY_TYPE
	end type

	type PDOT11_PHY_TYPE_LIST as DOT11_PHY_TYPE_LIST ptr
	const DOT11_PHY_TYPE_LIST_REVISION_1 = 1
	const DOT11_CAPABILITY_INFO_ESS = &h0001
	const DOT11_CAPABILITY_INFO_IBSS = &h0002
	const DOT11_CAPABILITY_INFO_CF_POLLABLE = &h0004
	const DOT11_CAPABILITY_INFO_CF_POLL_REQ = &h0008
	const DOT11_CAPABILITY_INFO_PRIVACY = &h0010
	const DOT11_CAPABILITY_SHORT_PREAMBLE = &h0020
	const DOT11_CAPABILITY_PBCC = &h0040
	const DOT11_CAPABILITY_CHANNEL_AGILITY = &h0080
	const DOT11_CAPABILITY_SHORT_SLOT_TIME = &h0400
	const DOT11_CAPABILITY_DSSSOFDM = &h2000
	const OID_DOT11_ATIM_WINDOW = OID_DOT11_NDIS_START + 10
	const OID_DOT11_SCAN_REQUEST = OID_DOT11_NDIS_START + 11
	const OID_DOT11_CURRENT_PHY_TYPE = OID_DOT11_NDIS_START + 12
	const OID_DOT11_JOIN_REQUEST = OID_DOT11_NDIS_START + 13
	const OID_DOT11_START_REQUEST = OID_DOT11_NDIS_START + 14
	const OID_DOT11_UPDATE_IE = OID_DOT11_NDIS_START + 15
	const OID_DOT11_RESET_REQUEST = OID_DOT11_NDIS_START + 16

	type _DOT11_BSS_DESCRIPTION
		uReserved as ULONG
		dot11BSSID(0 to 5) as UCHAR
		dot11BSSType as DOT11_BSS_TYPE
		usBeaconPeriod as USHORT
		ullTimestamp as ULONGLONG
		usCapabilityInformation as USHORT
		uBufferLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_BSS_DESCRIPTION as _DOT11_BSS_DESCRIPTION
	type PDOT11_BSS_DESCRIPTION as _DOT11_BSS_DESCRIPTION ptr

	type _DOT11_JOIN_REQUEST
		uJoinFailureTimeout as ULONG
		OperationalRateSet as DOT11_RATE_SET
		uChCenterFrequency as ULONG
		dot11BSSDescription as DOT11_BSS_DESCRIPTION
	end type

	type DOT11_JOIN_REQUEST as _DOT11_JOIN_REQUEST
	type PDOT11_JOIN_REQUEST as _DOT11_JOIN_REQUEST ptr

	type _DOT11_START_REQUEST
		uStartFailureTimeout as ULONG
		OperationalRateSet as DOT11_RATE_SET
		uChCenterFrequency as ULONG
		dot11BSSDescription as DOT11_BSS_DESCRIPTION
	end type

	type DOT11_START_REQUEST as _DOT11_START_REQUEST
	type PDOT11_START_REQUEST as _DOT11_START_REQUEST ptr

	type _DOT11_UPDATE_IE_OP as long
	enum
		dot11_update_ie_op_create_replace = 1
		dot11_update_ie_op_delete = 2
	end enum

	type DOT11_UPDATE_IE_OP as _DOT11_UPDATE_IE_OP
	type PDOT11_UPDATE_IE_OP as _DOT11_UPDATE_IE_OP ptr

	type _DOT11_UPDATE_IE
		dot11UpdateIEOp as DOT11_UPDATE_IE_OP
		uBufferLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_UPDATE_IE as _DOT11_UPDATE_IE
	type PDOT11_UPDATE_IE as _DOT11_UPDATE_IE ptr

	type _DOT11_RESET_TYPE as long
	enum
		dot11_reset_type_phy = 1
		dot11_reset_type_mac = 2
		dot11_reset_type_phy_and_mac = 3
	end enum

	type DOT11_RESET_TYPE as _DOT11_RESET_TYPE
	type PDOT11_RESET_TYPE as _DOT11_RESET_TYPE ptr

	type _DOT11_RESET_REQUEST
		dot11ResetType as DOT11_RESET_TYPE
		dot11MacAddress(0 to 5) as UCHAR
		bSetDefaultMIB as WINBOOLEAN
	end type

	type DOT11_RESET_REQUEST as _DOT11_RESET_REQUEST
	type PDOT11_RESET_REQUEST as _DOT11_RESET_REQUEST ptr

	type _DOT11_OPTIONAL_CAPABILITY
		uReserved as ULONG
		bDot11PCF as WINBOOLEAN
		bDot11PCFMPDUTransferToPC as WINBOOLEAN
		bStrictlyOrderedServiceClass as WINBOOLEAN
	end type

	type DOT11_OPTIONAL_CAPABILITY as _DOT11_OPTIONAL_CAPABILITY
	type PDOT11_OPTIONAL_CAPABILITY as _DOT11_OPTIONAL_CAPABILITY ptr
	const OID_DOT11_NIC_POWER_STATE = OID_DOT11_NDIS_START + 17
	const OID_DOT11_OPTIONAL_CAPABILITY = OID_DOT11_NDIS_START + 18
	const OID_DOT11_CURRENT_OPTIONAL_CAPABILITY = OID_DOT11_NDIS_START + 19
	const OID_DOT11_STATION_ID = OID_DOT11_NDIS_START + 20
	const OID_DOT11_MEDIUM_OCCUPANCY_LIMIT = OID_DOT11_NDIS_START + 21
	const OID_DOT11_CF_POLLABLE = OID_DOT11_NDIS_START + 22
	const OID_DOT11_CFP_PERIOD = OID_DOT11_NDIS_START + 23
	const OID_DOT11_CFP_MAX_DURATION = OID_DOT11_NDIS_START + 24
	const OID_DOT11_POWER_MGMT_MODE = OID_DOT11_NDIS_START + 25
	const OID_DOT11_OPERATIONAL_RATE_SET = OID_DOT11_NDIS_START + 26
	const OID_DOT11_BEACON_PERIOD = OID_DOT11_NDIS_START + 27
	const OID_DOT11_DTIM_PERIOD = OID_DOT11_NDIS_START + 28
	const OID_DOT11_WEP_ICV_ERROR_COUNT = OID_DOT11_NDIS_START + 29
	const OID_DOT11_MAC_ADDRESS = OID_DOT11_NDIS_START + 30
	const OID_DOT11_RTS_THRESHOLD = OID_DOT11_NDIS_START + 31
	const OID_DOT11_SHORT_RETRY_LIMIT = OID_DOT11_NDIS_START + 32
	const OID_DOT11_LONG_RETRY_LIMIT = OID_DOT11_NDIS_START + 33
	const OID_DOT11_FRAGMENTATION_THRESHOLD = OID_DOT11_NDIS_START + 34
	const OID_DOT11_MAX_TRANSMIT_MSDU_LIFETIME = OID_DOT11_NDIS_START + 35
	const OID_DOT11_MAX_RECEIVE_LIFETIME = OID_DOT11_NDIS_START + 36
	const OID_DOT11_COUNTERS_ENTRY = OID_DOT11_NDIS_START + 37

	type _DOT11_CURRENT_OPTIONAL_CAPABILITY
		uReserved as ULONG
		bDot11CFPollable as WINBOOLEAN
		bDot11PCF as WINBOOLEAN
		bDot11PCFMPDUTransferToPC as WINBOOLEAN
		bStrictlyOrderedServiceClass as WINBOOLEAN
	end type

	type DOT11_CURRENT_OPTIONAL_CAPABILITY as _DOT11_CURRENT_OPTIONAL_CAPABILITY
	type PDOT11_CURRENT_OPTIONAL_CAPABILITY as _DOT11_CURRENT_OPTIONAL_CAPABILITY ptr

	type _DOT11_POWER_MODE as long
	enum
		dot11_power_mode_unknown = 0
		dot11_power_mode_active = 1
		dot11_power_mode_powersave = 2
	end enum

	type DOT11_POWER_MODE as _DOT11_POWER_MODE
	type PDOT11_POWER_MODE as _DOT11_POWER_MODE ptr
	const DOT11_POWER_SAVE_LEVEL_MAX_PSP = 1
	const DOT11_POWER_SAVE_LEVEL_FAST_PSP = 2

	type _DOT11_POWER_MGMT_MODE
		dot11PowerMode as DOT11_POWER_MODE
		uPowerSaveLevel as ULONG
		usListenInterval as USHORT
		usAID as USHORT
		bReceiveDTIMs as WINBOOLEAN
	end type

	type DOT11_POWER_MGMT_MODE as _DOT11_POWER_MGMT_MODE
	type PDOT11_POWER_MGMT_MODE as _DOT11_POWER_MGMT_MODE ptr

	type _DOT11_COUNTERS_ENTRY
		uTransmittedFragmentCount as ULONG
		uMulticastTransmittedFrameCount as ULONG
		uFailedCount as ULONG
		uRetryCount as ULONG
		uMultipleRetryCount as ULONG
		uFrameDuplicateCount as ULONG
		uRTSSuccessCount as ULONG
		uRTSFailureCount as ULONG
		uACKFailureCount as ULONG
		uReceivedFragmentCount as ULONG
		uMulticastReceivedFrameCount as ULONG
		uFCSErrorCount as ULONG
		uTransmittedFrameCount as ULONG
	end type

	type DOT11_COUNTERS_ENTRY as _DOT11_COUNTERS_ENTRY
	type PDOT11_COUNTERS_ENTRY as _DOT11_COUNTERS_ENTRY ptr
	const OID_DOT11_SUPPORTED_PHY_TYPES = OID_DOT11_NDIS_START + 38

	type _DOT11_SUPPORTED_PHY_TYPES
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11PHYType(0 to 0) as DOT11_PHY_TYPE
	end type

	type DOT11_SUPPORTED_PHY_TYPES as _DOT11_SUPPORTED_PHY_TYPES
	type PDOT11_SUPPORTED_PHY_TYPES as _DOT11_SUPPORTED_PHY_TYPES ptr
	const OID_DOT11_CURRENT_REG_DOMAIN = OID_DOT11_NDIS_START + 39
	const OID_DOT11_TEMP_TYPE = OID_DOT11_NDIS_START + 40
	const OID_DOT11_CURRENT_TX_ANTENNA = OID_DOT11_NDIS_START + 41
	const OID_DOT11_DIVERSITY_SUPPORT = OID_DOT11_NDIS_START + 42
	const OID_DOT11_CURRENT_RX_ANTENNA = OID_DOT11_NDIS_START + 43
	const OID_DOT11_SUPPORTED_POWER_LEVELS = OID_DOT11_NDIS_START + 44
	const OID_DOT11_CURRENT_TX_POWER_LEVEL = OID_DOT11_NDIS_START + 45
	const OID_DOT11_HOP_TIME = OID_DOT11_NDIS_START + 46
	const OID_DOT11_CURRENT_CHANNEL_NUMBER = OID_DOT11_NDIS_START + 47
	const OID_DOT11_MAX_DWELL_TIME = OID_DOT11_NDIS_START + 48
	const OID_DOT11_CURRENT_DWELL_TIME = OID_DOT11_NDIS_START + 49
	const OID_DOT11_CURRENT_SET = OID_DOT11_NDIS_START + 50
	const OID_DOT11_CURRENT_PATTERN = OID_DOT11_NDIS_START + 51
	const OID_DOT11_CURRENT_INDEX = OID_DOT11_NDIS_START + 52
	const OID_DOT11_CURRENT_CHANNEL = OID_DOT11_NDIS_START + 53
	const OID_DOT11_CCA_MODE_SUPPORTED = OID_DOT11_NDIS_START + 54
	const OID_DOT11_CURRENT_CCA_MODE = OID_DOT11_NDIS_START + 55
	const OID_DOT11_ED_THRESHOLD = OID_DOT11_NDIS_START + 56
	const OID_DOT11_CCA_WATCHDOG_TIMER_MAX = OID_DOT11_NDIS_START + 57
	const OID_DOT11_CCA_WATCHDOG_COUNT_MAX = OID_DOT11_NDIS_START + 58
	const OID_DOT11_CCA_WATCHDOG_TIMER_MIN = OID_DOT11_NDIS_START + 59
	const OID_DOT11_CCA_WATCHDOG_COUNT_MIN = OID_DOT11_NDIS_START + 60
	const OID_DOT11_REG_DOMAINS_SUPPORT_VALUE = OID_DOT11_NDIS_START + 61
	const OID_DOT11_SUPPORTED_TX_ANTENNA = OID_DOT11_NDIS_START + 62
	const OID_DOT11_SUPPORTED_RX_ANTENNA = OID_DOT11_NDIS_START + 63
	const OID_DOT11_DIVERSITY_SELECTION_RX = OID_DOT11_NDIS_START + 64
	const OID_DOT11_SUPPORTED_DATA_RATES_VALUE = OID_DOT11_NDIS_START + 65
	const OID_DOT11_CURRENT_FREQUENCY = OID_DOT11_NDIS_START + 66
	const OID_DOT11_TI_THRESHOLD = OID_DOT11_NDIS_START + 67
	const OID_DOT11_FREQUENCY_BANDS_SUPPORTED = OID_DOT11_NDIS_START + 68
	const OID_DOT11_SHORT_PREAMBLE_OPTION_IMPLEMENTED = OID_DOT11_NDIS_START + 69
	const OID_DOT11_PBCC_OPTION_IMPLEMENTED = OID_DOT11_NDIS_START + 70
	const OID_DOT11_CHANNEL_AGILITY_PRESENT = OID_DOT11_NDIS_START + 71
	const OID_DOT11_CHANNEL_AGILITY_ENABLED = OID_DOT11_NDIS_START + 72
	const OID_DOT11_HR_CCA_MODE_SUPPORTED = OID_DOT11_NDIS_START + 73
	const OID_DOT11_MULTI_DOMAIN_CAPABILITY_IMPLEMENTED = OID_DOT11_NDIS_START + 74
	const OID_DOT11_MULTI_DOMAIN_CAPABILITY_ENABLED = OID_DOT11_NDIS_START + 75
	const OID_DOT11_COUNTRY_STRING = OID_DOT11_NDIS_START + 76
	const DOT11_REG_DOMAIN_OTHER = &h00000000
	const DOT11_REG_DOMAIN_FCC = &h00000010
	const DOT11_REG_DOMAIN_DOC = &h00000020
	const DOT11_REG_DOMAIN_ETSI = &h00000030
	const DOT11_REG_DOMAIN_SPAIN = &h00000031
	const DOT11_REG_DOMAIN_FRANCE = &h00000032
	const DOT11_REG_DOMAIN_MKK = &h00000040

	type _DOT11_TEMP_TYPE as long
	enum
		dot11_temp_type_unknown = 0
		dot11_temp_type_1 = 1
		dot11_temp_type_2 = 2
	end enum

	type DOT11_TEMP_TYPE as _DOT11_TEMP_TYPE
	type PDOT11_TEMP_TYPE as _DOT11_TEMP_TYPE ptr

	type _DOT11_DIVERSITY_SUPPORT as long
	enum
		dot11_diversity_support_unknown = 0
		dot11_diversity_support_fixedlist = 1
		dot11_diversity_support_notsupported = 2
		dot11_diversity_support_dynamic = 3
	end enum

	type DOT11_DIVERSITY_SUPPORT as _DOT11_DIVERSITY_SUPPORT
	type PDOT11_DIVERSITY_SUPPORT as _DOT11_DIVERSITY_SUPPORT ptr

	type _DOT11_SUPPORTED_POWER_LEVELS
		uNumOfSupportedPowerLevels as ULONG
		uTxPowerLevelValues(0 to 7) as ULONG
	end type

	type DOT11_SUPPORTED_POWER_LEVELS as _DOT11_SUPPORTED_POWER_LEVELS
	type PDOT11_SUPPORTED_POWER_LEVELS as _DOT11_SUPPORTED_POWER_LEVELS ptr
	const DOT11_CCA_MODE_ED_ONLY = &h00000001
	const DOT11_CCA_MODE_CS_ONLY = &h00000002
	const DOT11_CCA_MODE_ED_and_CS = &h00000004
	const DOT11_CCA_MODE_CS_WITH_TIMER = &h00000008
	const DOT11_CCA_MODE_HRCS_AND_ED = &h00000010

	type _DOT11_REG_DOMAIN_VALUE
		uRegDomainsSupportIndex as ULONG
		uRegDomainsSupportValue as ULONG
	end type

	type DOT11_REG_DOMAIN_VALUE as _DOT11_REG_DOMAIN_VALUE
	type PDOT11_REG_DOMAIN_VALUE as _DOT11_REG_DOMAIN_VALUE ptr

	type _DOT11_REG_DOMAINS_SUPPORT_VALUE
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11RegDomainValue(0 to 0) as DOT11_REG_DOMAIN_VALUE
	end type

	type DOT11_REG_DOMAINS_SUPPORT_VALUE as _DOT11_REG_DOMAINS_SUPPORT_VALUE
	type PDOT11_REG_DOMAINS_SUPPORT_VALUE as _DOT11_REG_DOMAINS_SUPPORT_VALUE ptr

	type _DOT11_SUPPORTED_ANTENNA
		uAntennaListIndex as ULONG
		bSupportedAntenna as WINBOOLEAN
	end type

	type DOT11_SUPPORTED_ANTENNA as _DOT11_SUPPORTED_ANTENNA
	type PDOT11_SUPPORTED_ANTENNA as _DOT11_SUPPORTED_ANTENNA ptr

	type _DOT11_SUPPORTED_ANTENNA_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11SupportedAntenna(0 to 0) as DOT11_SUPPORTED_ANTENNA
	end type

	type DOT11_SUPPORTED_ANTENNA_LIST as _DOT11_SUPPORTED_ANTENNA_LIST
	type PDOT11_SUPPORTED_ANTENNA_LIST as _DOT11_SUPPORTED_ANTENNA_LIST ptr

	type _DOT11_DIVERSITY_SELECTION_RX
		uAntennaListIndex as ULONG
		bDiversitySelectionRX as WINBOOLEAN
	end type

	type DOT11_DIVERSITY_SELECTION_RX as _DOT11_DIVERSITY_SELECTION_RX
	type PDOT11_DIVERSITY_SELECTION_RX as _DOT11_DIVERSITY_SELECTION_RX ptr

	type _DOT11_DIVERSITY_SELECTION_RX_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11DiversitySelectionRx(0 to 0) as DOT11_DIVERSITY_SELECTION_RX
	end type

	type DOT11_DIVERSITY_SELECTION_RX_LIST as _DOT11_DIVERSITY_SELECTION_RX_LIST
	type PDOT11_DIVERSITY_SELECTION_RX_LIST as _DOT11_DIVERSITY_SELECTION_RX_LIST ptr
	const MAX_NUM_SUPPORTED_RATES = 8
	const MAX_NUM_SUPPORTED_RATES_V2 = 255

	type _DOT11_SUPPORTED_DATA_RATES_VALUE
		ucSupportedTxDataRatesValue(0 to 7) as UCHAR
		ucSupportedRxDataRatesValue(0 to 7) as UCHAR
	end type

	type DOT11_SUPPORTED_DATA_RATES_VALUE as _DOT11_SUPPORTED_DATA_RATES_VALUE
	type PDOT11_SUPPORTED_DATA_RATES_VALUE as _DOT11_SUPPORTED_DATA_RATES_VALUE ptr

	type _DOT11_SUPPORTED_DATA_RATES_VALUE_V2
		ucSupportedTxDataRatesValue(0 to 254) as UCHAR
		ucSupportedRxDataRatesValue(0 to 254) as UCHAR
	end type

	type DOT11_SUPPORTED_DATA_RATES_VALUE_V2 as _DOT11_SUPPORTED_DATA_RATES_VALUE_V2
	type PDOT11_SUPPORTED_DATA_RATES_VALUE_V2 as _DOT11_SUPPORTED_DATA_RATES_VALUE_V2 ptr
	type DOT11_SUPPORTED_DATA_RATES_VALUE_V1 as DOT11_SUPPORTED_DATA_RATES_VALUE_V2
	type PDOT11_SUPPORTED_DATA_RATES_VALUE_V1 as DOT11_SUPPORTED_DATA_RATES_VALUE_V2 ptr

	const DOT11_FREQUENCY_BANDS_LOWER = &h00000001
	const DOT11_FREQUENCY_BANDS_MIDDLE = &h00000002
	const DOT11_FREQUENCY_BANDS_UPPER = &h00000004
	const DOT11_HR_CCA_MODE_ED_ONLY = &h00000001
	const DOT11_HR_CCA_MODE_CS_ONLY = &h00000002
	const DOT11_HR_CCA_MODE_CS_AND_ED = &h00000004
	const DOT11_HR_CCA_MODE_CS_WITH_TIMER = &h00000008
	const DOT11_HR_CCA_MODE_HRCS_AND_ED = &h00000010

	type _DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY
		uMultiDomainCapabilityIndex as ULONG
		uFirstChannelNumber as ULONG
		uNumberOfChannels as ULONG
		lMaximumTransmitPowerLevel as LONG
	end type

	type DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY as _DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY
	type PDOT11_MULTI_DOMAIN_CAPABILITY_ENTRY as _DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY ptr

	type _DOT11_MD_CAPABILITY_ENTRY_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11MDCapabilityEntry(0 to 0) as DOT11_MULTI_DOMAIN_CAPABILITY_ENTRY
	end type

	type DOT11_MD_CAPABILITY_ENTRY_LIST as _DOT11_MD_CAPABILITY_ENTRY_LIST
	type PDOT11_MD_CAPABILITY_ENTRY_LIST as _DOT11_MD_CAPABILITY_ENTRY_LIST ptr
	const OID_DOT11_MULTI_DOMAIN_CAPABILITY = OID_DOT11_NDIS_START + 77
	const OID_DOT11_EHCC_PRIME_RADIX = OID_DOT11_NDIS_START + 78
	const OID_DOT11_EHCC_NUMBER_OF_CHANNELS_FAMILY_INDEX = OID_DOT11_NDIS_START + 79
	const OID_DOT11_EHCC_CAPABILITY_IMPLEMENTED = OID_DOT11_NDIS_START + 80
	const OID_DOT11_EHCC_CAPABILITY_ENABLED = OID_DOT11_NDIS_START + 81
	const OID_DOT11_HOP_ALGORITHM_ADOPTED = OID_DOT11_NDIS_START + 82
	const OID_DOT11_RANDOM_TABLE_FLAG = OID_DOT11_NDIS_START + 83
	const OID_DOT11_NUMBER_OF_HOPPING_SETS = OID_DOT11_NDIS_START + 84
	const OID_DOT11_HOP_MODULUS = OID_DOT11_NDIS_START + 85
	const OID_DOT11_HOP_OFFSET = OID_DOT11_NDIS_START + 86
	const OID_DOT11_HOPPING_PATTERN = OID_DOT11_NDIS_START + 87
	const OID_DOT11_RANDOM_TABLE_FIELD_NUMBER = OID_DOT11_NDIS_START + 88
	const OID_DOT11_WPA_TSC = OID_DOT11_NDIS_START + 89
	const OID_DOT11_RSSI_RANGE = OID_DOT11_NDIS_START + 90
	const OID_DOT11_RF_USAGE = OID_DOT11_NDIS_START + 91
	const OID_DOT11_NIC_SPECIFIC_EXTENSION = OID_DOT11_NDIS_START + 92
	const OID_DOT11_AP_JOIN_REQUEST = OID_DOT11_NDIS_START + 93
	const OID_DOT11_ERP_PBCC_OPTION_IMPLEMENTED = OID_DOT11_NDIS_START + 94
	const OID_DOT11_ERP_PBCC_OPTION_ENABLED = OID_DOT11_NDIS_START + 95
	const OID_DOT11_DSSS_OFDM_OPTION_IMPLEMENTED = OID_DOT11_NDIS_START + 96
	const OID_DOT11_DSSS_OFDM_OPTION_ENABLED = OID_DOT11_NDIS_START + 97
	const OID_DOT11_SHORT_SLOT_TIME_OPTION_IMPLEMENTED = OID_DOT11_NDIS_START + 98
	const OID_DOT11_SHORT_SLOT_TIME_OPTION_ENABLED = OID_DOT11_NDIS_START + 99
	const OID_DOT11_MAX_MAC_ADDRESS_STATES = OID_DOT11_NDIS_START + 100
	const OID_DOT11_RECV_SENSITIVITY_LIST = OID_DOT11_NDIS_START + 101

	type _DOT11_HOP_ALGO_ADOPTED as long
	enum
		dot11_hop_algo_current = 0
		dot11_hop_algo_hop_index = 1
		dot11_hop_algo_hcc = 2
	end enum

	type DOT11_HOP_ALGO_ADOPTED as _DOT11_HOP_ALGO_ADOPTED
	type PDOT11_HOP_ALGO_ADOPTED as _DOT11_HOP_ALGO_ADOPTED ptr

	type _DOT11_HOPPING_PATTERN_ENTRY
		uHoppingPatternIndex as ULONG
		uRandomTableFieldNumber as ULONG
	end type

	type DOT11_HOPPING_PATTERN_ENTRY as _DOT11_HOPPING_PATTERN_ENTRY
	type PDOT11_HOPPING_PATTERN_ENTRY as _DOT11_HOPPING_PATTERN_ENTRY ptr

	type _DOT11_HOPPING_PATTERN_ENTRY_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11HoppingPatternEntry(0 to 0) as DOT11_HOPPING_PATTERN_ENTRY
	end type

	type DOT11_HOPPING_PATTERN_ENTRY_LIST as _DOT11_HOPPING_PATTERN_ENTRY_LIST
	type PDOT11_HOPPING_PATTERN_ENTRY_LIST as _DOT11_HOPPING_PATTERN_ENTRY_LIST ptr

	type _DOT11_WPA_TSC
		uReserved as ULONG
		dot11OffloadType as DOT11_OFFLOAD_TYPE
		hOffload as HANDLE
		dot11IV48Counter as DOT11_IV48_COUNTER
	end type

	type DOT11_WPA_TSC as _DOT11_WPA_TSC
	type PDOT11_WPA_TSC as _DOT11_WPA_TSC ptr

	type _DOT11_RSSI_RANGE
		dot11PhyType as DOT11_PHY_TYPE
		uRSSIMin as ULONG
		uRSSIMax as ULONG
	end type

	type DOT11_RSSI_RANGE as _DOT11_RSSI_RANGE
	type PDOT11_RSSI_RANGE as _DOT11_RSSI_RANGE ptr

	type _DOT11_NIC_SPECIFIC_EXTENSION
		uBufferLength as ULONG
		uTotalBufferLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_NIC_SPECIFIC_EXTENSION as _DOT11_NIC_SPECIFIC_EXTENSION
	type PDOT11_NIC_SPECIFIC_EXTENSION as _DOT11_NIC_SPECIFIC_EXTENSION ptr

	type _DOT11_AP_JOIN_REQUEST
		uJoinFailureTimeout as ULONG
		OperationalRateSet as DOT11_RATE_SET
		uChCenterFrequency as ULONG
		dot11BSSDescription as DOT11_BSS_DESCRIPTION
	end type

	type DOT11_AP_JOIN_REQUEST as _DOT11_AP_JOIN_REQUEST
	type PDOT11_AP_JOIN_REQUEST as _DOT11_AP_JOIN_REQUEST ptr

	type _DOT11_RECV_SENSITIVITY
		ucDataRate as UCHAR
		lRSSIMin as LONG
		lRSSIMax as LONG
	end type

	type DOT11_RECV_SENSITIVITY as _DOT11_RECV_SENSITIVITY
	type PDOT11_RECV_SENSITIVITY as _DOT11_RECV_SENSITIVITY ptr

	type _DOT11_RECV_SENSITIVITY_LIST
		union
			dot11PhyType as DOT11_PHY_TYPE
			uPhyId as ULONG
		end union

		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11RecvSensitivity(0 to 0) as DOT11_RECV_SENSITIVITY
	end type

	type DOT11_RECV_SENSITIVITY_LIST as _DOT11_RECV_SENSITIVITY_LIST
	type PDOT11_RECV_SENSITIVITY_LIST as _DOT11_RECV_SENSITIVITY_LIST ptr
	const OID_DOT11_WME_IMPLEMENTED = OID_DOT11_NDIS_START + 102
	const OID_DOT11_WME_ENABLED = OID_DOT11_NDIS_START + 103
	const OID_DOT11_WME_AC_PARAMETERS = OID_DOT11_NDIS_START + 104
	const OID_DOT11_WME_UPDATE_IE = OID_DOT11_NDIS_START + 105
	const OID_DOT11_QOS_TX_QUEUES_SUPPORTED = OID_DOT11_NDIS_START + 106
	const OID_DOT11_QOS_TX_DURATION = OID_DOT11_NDIS_START + 107

	type _DOT11_AC_PARAM as long
	enum
		dot11_AC_param_BE = 0
		dot11_AC_param_BK = 1
		dot11_AC_param_VI = 2
		dot11_AC_param_VO = 3
		dot11_AC_param_max
	end enum

	type DOT11_AC_PARAM as _DOT11_AC_PARAM
	type PDOT11_AC_PARAM as _DOT11_AC_PARAM ptr

	type _DOT11_WME_AC_PARAMETERS
		ucAccessCategoryIndex as UCHAR
		ucAIFSN as UCHAR
		ucECWmin as UCHAR
		ucECWmax as UCHAR
		usTXOPLimit as USHORT
	end type

	type DOT11_WME_AC_PARAMETERS as _DOT11_WME_AC_PARAMETERS
	type PDOT11_WME_AC_PARAMETERS as _DOT11_WME_AC_PARAMETERS ptr

	type _DOT11_WME_AC_PARAMTERS_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11WMEACParameters(0 to 0) as DOT11_WME_AC_PARAMETERS
	end type

	type DOT11_WME_AC_PARAMETERS_LIST as _DOT11_WME_AC_PARAMTERS_LIST
	type PDOT11_WME_AC_PARAMETERS_LIST as _DOT11_WME_AC_PARAMTERS_LIST ptr

	type _DOT11_WME_UPDATE_IE
		uParamElemMinBeaconIntervals as ULONG
		uWMEInfoElemOffset as ULONG
		uWMEInfoElemLength as ULONG
		uWMEParamElemOffset as ULONG
		uWMEParamElemLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_WME_UPDATE_IE as _DOT11_WME_UPDATE_IE
	type PDOT11_WME_UPDATE_IE as _DOT11_WME_UPDATE_IE ptr

	type _DOT11_QOS_TX_DURATION
		uNominalMSDUSize as ULONG
		uMinPHYRate as ULONG
		uDuration as ULONG
	end type

	type DOT11_QOS_TX_DURATION as _DOT11_QOS_TX_DURATION
	type PDOT11_QOS_TX_DURATION as _DOT11_QOS_TX_DURATION ptr

	type _DOT11_QOS_TX_MEDIUM_TIME
		dot11PeerAddress(0 to 5) as UCHAR
		ucQoSPriority as UCHAR
		uMediumTimeAdmited as ULONG
	end type

	type DOT11_QOS_TX_MEDIUM_TIME as _DOT11_QOS_TX_MEDIUM_TIME
	type PDOT11_QOS_TX_MEDIUM_TIME as _DOT11_QOS_TX_MEDIUM_TIME ptr

	type _DOT11_SUPPORTED_OFDM_FREQUENCY
		uCenterFrequency as ULONG
	end type

	type DOT11_SUPPORTED_OFDM_FREQUENCY as _DOT11_SUPPORTED_OFDM_FREQUENCY
	type PDOT11_SUPPORTED_OFDM_FREQUENCY as _DOT11_SUPPORTED_OFDM_FREQUENCY ptr

	type _DOT11_SUPPORTED_OFDM_FREQUENCY_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11SupportedOFDMFrequency(0 to 0) as DOT11_SUPPORTED_OFDM_FREQUENCY
	end type

	type DOT11_SUPPORTED_OFDM_FREQUENCY_LIST as _DOT11_SUPPORTED_OFDM_FREQUENCY_LIST
	type PDOT11_SUPPORTED_OFDM_FREQUENCY_LIST as _DOT11_SUPPORTED_OFDM_FREQUENCY_LIST ptr

	type _DOT11_SUPPORTED_DSSS_CHANNEL
		uChannel as ULONG
	end type

	type DOT11_SUPPORTED_DSSS_CHANNEL as _DOT11_SUPPORTED_DSSS_CHANNEL
	type PDOT11_SUPPORTED_DSSS_CHANNEL as _DOT11_SUPPORTED_DSSS_CHANNEL ptr

	type _DOT11_SUPPORTED_DSSS_CHANNEL_LIST
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11SupportedDSSSChannel(0 to 0) as DOT11_SUPPORTED_DSSS_CHANNEL
	end type

	type DOT11_SUPPORTED_DSSS_CHANNEL_LIST as _DOT11_SUPPORTED_DSSS_CHANNEL_LIST
	type PDOT11_SUPPORTED_DSSS_CHANNEL_LIST as _DOT11_SUPPORTED_DSSS_CHANNEL_LIST ptr

	type DOT11_BYTE_ARRAY
		Header as NDIS_OBJECT_HEADER
		uNumOfBytes as ULONG
		uTotalNumOfBytes as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type PDOT11_BYTE_ARRAY as DOT11_BYTE_ARRAY ptr
	const OID_DOT11_QOS_TX_MEDIUM_TIME = OID_DOT11_NDIS_START + 108
	const OID_DOT11_SUPPORTED_OFDM_FREQUENCY_LIST = OID_DOT11_NDIS_START + 109
	const OID_DOT11_SUPPORTED_DSSS_CHANNEL_LIST = OID_DOT11_NDIS_START + 110
	#define OID_DOT11_AUTO_CONFIG_ENABLED NWF_DEFINE_OID(120, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ENUM_BSS_LIST NWF_DEFINE_OID(121, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_FLUSH_BSS_LIST NWF_DEFINE_OID(122, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_POWER_MGMT_REQUEST NWF_DEFINE_OID(123, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_DESIRED_SSID_LIST NWF_DEFINE_OID(124, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_EXCLUDED_MAC_ADDRESS_LIST NWF_DEFINE_OID(125, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	const DOT11_PHY_AUTO_CONFIG_ENABLED_FLAG = &h00000001u
	const DOT11_MAC_AUTO_CONFIG_ENABLED_FLAG = &h00000002u
	const DOT11_BSS_ENTRY_BYTE_ARRAY_REVISION_1 = 1

	type DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO_FHSS
		uHopPattern as ULONG
		uHopSet as ULONG
		uDwellTime as ULONG
	end type

	union DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO
		uChCenterFrequency as ULONG
		FHSS as DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO_FHSS
	end union

	type PDOT11_BSS_ENTRY_PHY_SPECIFIC_INFO as DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO ptr

	type DOT11_BSS_ENTRY
		uPhyId as ULONG
		PhySpecificInfo as DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO
		dot11BSSID(0 to 5) as UCHAR
		dot11BSSType as DOT11_BSS_TYPE
		lRSSI as LONG
		uLinkQuality as ULONG
		bInRegDomain as WINBOOLEAN
		usBeaconPeriod as USHORT
		ullTimestamp as ULONGLONG
		ullHostTimestamp as ULONGLONG
		usCapabilityInformation as USHORT
		uBufferLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type PDOT11_BSS_ENTRY as DOT11_BSS_ENTRY ptr
	const DOT11_POWER_SAVING_NO_POWER_SAVING = 0
	const DOT11_POWER_SAVING_FAST_PSP = 8
	const DOT11_POWER_SAVING_MAX_PSP = 16
	const DOT11_POWER_SAVING_MAXIMUM_LEVEL = 24
	const DOT11_SSID_LIST_REVISION_1 = 1
	const DOT11_MAC_ADDRESS_LIST_REVISION_1 = 1
	const DOT11_PMKID_LIST_REVISION_1 = 1

	type DOT11_SSID_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		SSIDs(0 to 0) as DOT11_SSID
	end type

	type PDOT11_SSID_LIST as DOT11_SSID_LIST ptr

	type DOT11_MAC_ADDRESS_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		MacAddrs(0 to 0, 0 to 5) as UCHAR
	end type

	type PDOT11_MAC_ADDRESS_LIST as DOT11_MAC_ADDRESS_LIST ptr
	#define OID_DOT11_DESIRED_BSSID_LIST NWF_DEFINE_OID(126, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_DESIRED_BSS_TYPE NWF_DEFINE_OID(127, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_PMKID_LIST NWF_DEFINE_OID(128, NWF_OPERATIONAL_OID, NWF_OPTIONAL_OID)
	#define OID_DOT11_CONNECT_REQUEST NWF_DEFINE_OID(129, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_EXCLUDE_UNENCRYPTED NWF_DEFINE_OID(130, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_STATISTICS NWF_DEFINE_OID(131, NWF_STATISTICS_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_PRIVACY_EXEMPTION_LIST NWF_DEFINE_OID(132, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ENABLED_AUTHENTICATION_ALGORITHM NWF_DEFINE_OID(133, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)

	type DOT11_PMKID_ENTRY
		BSSID(0 to 5) as UCHAR
		PMKID(0 to 15) as UCHAR
		uFlags as ULONG
	end type

	type PDOT11_PMKID_ENTRY as DOT11_PMKID_ENTRY ptr

	type DOT11_PMKID_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		PMKIDs(0 to 0) as DOT11_PMKID_ENTRY
	end type

	type PDOT11_PMKID_LIST as DOT11_PMKID_LIST ptr
	const DOT11_STATISTICS_UNKNOWN = cast(ULONGLONG, -1ll)

	type DOT11_PHY_FRAME_STATISTICS
		ullTransmittedFrameCount as ULONGLONG
		ullMulticastTransmittedFrameCount as ULONGLONG
		ullFailedCount as ULONGLONG
		ullRetryCount as ULONGLONG
		ullMultipleRetryCount as ULONGLONG
		ullMaxTXLifetimeExceededCount as ULONGLONG
		ullTransmittedFragmentCount as ULONGLONG
		ullRTSSuccessCount as ULONGLONG
		ullRTSFailureCount as ULONGLONG
		ullACKFailureCount as ULONGLONG
		ullReceivedFrameCount as ULONGLONG
		ullMulticastReceivedFrameCount as ULONGLONG
		ullPromiscuousReceivedFrameCount as ULONGLONG
		ullMaxRXLifetimeExceededCount as ULONGLONG
		ullFrameDuplicateCount as ULONGLONG
		ullReceivedFragmentCount as ULONGLONG
		ullPromiscuousReceivedFragmentCount as ULONGLONG
		ullFCSErrorCount as ULONGLONG
	end type

	type PDOT11_PHY_FRAME_STATISTICS as DOT11_PHY_FRAME_STATISTICS ptr

	type DOT11_MAC_FRAME_STATISTICS
		ullTransmittedFrameCount as ULONGLONG
		ullReceivedFrameCount as ULONGLONG
		ullTransmittedFailureFrameCount as ULONGLONG
		ullReceivedFailureFrameCount as ULONGLONG
		ullWEPExcludedCount as ULONGLONG
		ullTKIPLocalMICFailures as ULONGLONG
		ullTKIPReplays as ULONGLONG
		ullTKIPICVErrorCount as ULONGLONG
		ullCCMPReplays as ULONGLONG
		ullCCMPDecryptErrors as ULONGLONG
		ullWEPUndecryptableCount as ULONGLONG
		ullWEPICVErrorCount as ULONGLONG
		ullDecryptSuccessCount as ULONGLONG
		ullDecryptFailureCount as ULONGLONG
	end type

	type PDOT11_MAC_FRAME_STATISTICS as DOT11_MAC_FRAME_STATISTICS ptr
	const DOT11_STATISTICS_REVISION_1 = 1
	const DOT11_PRIVACY_EXEMPTION_LIST_REVISION_1 = 1

	type DOT11_STATISTICS
		Header as NDIS_OBJECT_HEADER
		ullFourWayHandshakeFailures as ULONGLONG
		ullTKIPCounterMeasuresInvoked as ULONGLONG
		ullReserved as ULONGLONG
		MacUcastCounters as DOT11_MAC_FRAME_STATISTICS
		MacMcastCounters as DOT11_MAC_FRAME_STATISTICS
		PhyCounters(0 to 0) as DOT11_PHY_FRAME_STATISTICS
	end type

	type PDOT11_STATISTICS as DOT11_STATISTICS ptr
	const DOT11_EXEMPT_NO_EXEMPTION = 0
	const DOT11_EXEMPT_ALWAYS = 1
	const DOT11_EXEMPT_ON_KEY_MAPPING_KEY_UNAVAILABLE = 2
	const DOT11_EXEMPT_UNICAST = 1
	const DOT11_EXEMPT_MULTICAST = 2
	const DOT11_EXEMPT_BOTH = 3

	type DOT11_PRIVACY_EXEMPTION
		usEtherType as USHORT
		usExemptionActionType as USHORT
		usExemptionPacketType as USHORT
	end type

	type PDOT11_PRIVACY_EXEMPTION as DOT11_PRIVACY_EXEMPTION ptr

	type DOT11_PRIVACY_EXEMPTION_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		PrivacyExemptionEntries(0 to 0) as DOT11_PRIVACY_EXEMPTION
	end type

	type PDOT11_PRIVACY_EXEMPTION_LIST as DOT11_PRIVACY_EXEMPTION_LIST ptr
	const DOT11_AUTH_ALGORITHM_LIST_REVISION_1 = 1
	const DOT11_AUTH_CIPHER_PAIR_LIST_REVISION_1 = 1
	const DOT11_CIPHER_ALGORITHM_LIST_REVISION_1 = 1
	const DOT11_CIPHER_DEFAULT_KEY_VALUE_REVISION_1 = 1
	#define OID_DOT11_SUPPORTED_UNICAST_ALGORITHM_PAIR NWF_DEFINE_OID(134, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ENABLED_UNICAST_CIPHER_ALGORITHM NWF_DEFINE_OID(135, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_SUPPORTED_MULTICAST_ALGORITHM_PAIR NWF_DEFINE_OID(136, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ENABLED_MULTICAST_CIPHER_ALGORITHM NWF_DEFINE_OID(137, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_CIPHER_DEFAULT_KEY_ID NWF_DEFINE_OID(138, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_CIPHER_DEFAULT_KEY NWF_DEFINE_OID(139, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)

	type DOT11_AUTH_ALGORITHM_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		AlgorithmIds(0 to 0) as DOT11_AUTH_ALGORITHM
	end type

	type PDOT11_AUTH_ALGORITHM_LIST as DOT11_AUTH_ALGORITHM_LIST ptr

	type DOT11_AUTH_CIPHER_PAIR_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		AuthCipherPairs(0 to 0) as DOT11_AUTH_CIPHER_PAIR
	end type

	type PDOT11_AUTH_CIPHER_PAIR_LIST as DOT11_AUTH_CIPHER_PAIR_LIST ptr

	type DOT11_CIPHER_ALGORITHM_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		AlgorithmIds(0 to 0) as DOT11_CIPHER_ALGORITHM
	end type

	type PDOT11_CIPHER_ALGORITHM_LIST as DOT11_CIPHER_ALGORITHM_LIST ptr

	type DOT11_CIPHER_DEFAULT_KEY_VALUE
		Header as NDIS_OBJECT_HEADER
		uKeyIndex as ULONG
		AlgorithmId as DOT11_CIPHER_ALGORITHM
		MacAddr(0 to 5) as UCHAR
		bDelete as WINBOOLEAN
		bStatic as WINBOOLEAN
		usKeyLength as USHORT
		ucKey(0 to 0) as UCHAR
	end type

	type PDOT11_CIPHER_DEFAULT_KEY_VALUE as DOT11_CIPHER_DEFAULT_KEY_VALUE ptr

	type DOT11_KEY_ALGO_TKIP_MIC
		ucIV48Counter(0 to 5) as UCHAR
		ulTKIPKeyLength as ULONG
		ulMICKeyLength as ULONG
		ucTKIPMICKeys(0 to 0) as UCHAR
	end type

	type PDOT11_KEY_ALGO_TKIP_MIC as DOT11_KEY_ALGO_TKIP_MIC ptr

	type DOT11_KEY_ALGO_CCMP
		ucIV48Counter(0 to 5) as UCHAR
		ulCCMPKeyLength as ULONG
		ucCCMPKey(0 to 0) as UCHAR
	end type

	type PDOT11_KEY_ALGO_CCMP as DOT11_KEY_ALGO_CCMP ptr

	type DOT11_KEY_ALGO_BIP
		ucIPN(0 to 5) as UCHAR
		ulBIPKeyLength as ULONG
		ucBIPKey(0 to 0) as UCHAR
	end type

	type PDOT11_KEY_ALGO_BIP as DOT11_KEY_ALGO_BIP ptr
	const DOT11_CIPHER_KEY_MAPPING_KEY_VALUE_BYTE_ARRAY_REVISION_1 = 1
	const DOT11_ASSOCIATION_INFO_LIST_REVISION_1 = 1
	#define OID_DOT11_CIPHER_KEY_MAPPING_KEY NWF_DEFINE_OID(140, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ENUM_ASSOCIATION_INFO NWF_DEFINE_OID(141, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)

	type DOT11_DIRECTION as long
	enum
		DOT11_DIR_INBOUND = 1
		DOT11_DIR_OUTBOUND
		DOT11_DIR_BOTH
	end enum

	type PDOT11_DIRECTION as DOT11_DIRECTION ptr

	type DOT11_CIPHER_KEY_MAPPING_KEY_VALUE
		PeerMacAddr(0 to 5) as UCHAR
		AlgorithmId as DOT11_CIPHER_ALGORITHM
		Direction as DOT11_DIRECTION
		bDelete as WINBOOLEAN
		bStatic as WINBOOLEAN
		usKeyLength as USHORT
		ucKey(0 to 0) as UCHAR
	end type

	type PDOT11_CIPHER_KEY_MAPPING_KEY_VALUE as DOT11_CIPHER_KEY_MAPPING_KEY_VALUE ptr

	type _DOT11_ASSOCIATION_STATE as long
	enum
		dot11_assoc_state_zero = 0
		dot11_assoc_state_unauth_unassoc = 1
		dot11_assoc_state_auth_unassoc = 2
		dot11_assoc_state_auth_assoc = 3
	end enum

	type DOT11_ASSOCIATION_STATE as _DOT11_ASSOCIATION_STATE
	type PDOT11_ASSOCIATION_STATE as _DOT11_ASSOCIATION_STATE ptr

	type _DOT11_ASSOCIATION_INFO_EX
		PeerMacAddress(0 to 5) as UCHAR
		BSSID(0 to 5) as UCHAR
		usCapabilityInformation as USHORT
		usListenInterval as USHORT
		ucPeerSupportedRates(0 to 254) as UCHAR
		usAssociationID as USHORT
		dot11AssociationState as DOT11_ASSOCIATION_STATE
		dot11PowerMode as DOT11_POWER_MODE
		liAssociationUpTime as LARGE_INTEGER
		ullNumOfTxPacketSuccesses as ULONGLONG
		ullNumOfTxPacketFailures as ULONGLONG
		ullNumOfRxPacketSuccesses as ULONGLONG
		ullNumOfRxPacketFailures as ULONGLONG
	end type

	type DOT11_ASSOCIATION_INFO_EX as _DOT11_ASSOCIATION_INFO_EX
	type PDOT11_ASSOCIATION_INFO_EX as _DOT11_ASSOCIATION_INFO_EX ptr

	type DOT11_ASSOCIATION_INFO_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11AssocInfo(0 to 0) as DOT11_ASSOCIATION_INFO_EX
	end type

	type PDOT11_ASSOCIATION_INFO_LIST as DOT11_ASSOCIATION_INFO_LIST ptr

	type DOT11_PHY_ID_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		dot11PhyId(0 to 0) as ULONG
	end type

	type PDOT11_PHY_ID_LIST as DOT11_PHY_ID_LIST ptr
	const DOT11_PHY_ID_ANY = &hffffffffu
	#define OID_DOT11_DISCONNECT_REQUEST NWF_DEFINE_OID(142, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_UNICAST_USE_GROUP_ENABLED NWF_DEFINE_OID(143, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_HARDWARE_PHY_STATE NWF_DEFINE_OID(144, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_DESIRED_PHY_LIST NWF_DEFINE_OID(145, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_CURRENT_PHY_ID NWF_DEFINE_OID(146, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_MEDIA_STREAMING_ENABLED NWF_DEFINE_OID(147, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_UNREACHABLE_DETECTION_THRESHOLD NWF_DEFINE_OID(148, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ACTIVE_PHY_LIST NWF_DEFINE_OID(149, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_EXTSTA_CAPABILITY NWF_DEFINE_OID(150, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	const DOT11_PHY_ID_LIST_REVISION_1 = 1
	const DOT11_EXTSTA_CAPABILITY_REVISION_1 = 1

	type DOT11_EXTSTA_CAPABILITY
		Header as NDIS_OBJECT_HEADER
		uScanSSIDListSize as ULONG
		uDesiredBSSIDListSize as ULONG
		uDesiredSSIDListSize as ULONG
		uExcludedMacAddressListSize as ULONG
		uPrivacyExemptionListSize as ULONG
		uKeyMappingTableSize as ULONG
		uDefaultKeyTableSize as ULONG
		uWEPKeyValueMaxLength as ULONG
		uPMKIDCacheSize as ULONG
		uMaxNumPerSTADefaultKeyTables as ULONG
	end type

	type PDOT11_EXTSTA_CAPABILITY as DOT11_EXTSTA_CAPABILITY ptr

	type DOT11_DATA_RATE_MAPPING_ENTRY
		ucDataRateIndex as UCHAR
		ucDataRateFlag as UCHAR
		usDataRateValue as USHORT
	end type

	type PDOT11_DATA_RATE_MAPPING_ENTRY as DOT11_DATA_RATE_MAPPING_ENTRY ptr

	type _DOT11_DATA_RATE_MAPPING_TABLE
		Header as NDIS_OBJECT_HEADER
		uDataRateMappingLength as ULONG
		DataRateMappingEntries(0 to 125) as DOT11_DATA_RATE_MAPPING_ENTRY
	end type

	type DOT11_DATA_RATE_MAPPING_TABLE as _DOT11_DATA_RATE_MAPPING_TABLE
	type PDOT11_DATA_RATE_MAPPING_TABLE as _DOT11_DATA_RATE_MAPPING_TABLE ptr

	type DOT11_COUNTRY_OR_REGION_STRING_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		CountryOrRegionStrings(0 to 0, 0 to 2) as UCHAR
	end type

	type PDOT11_COUNTRY_OR_REGION_STRING_LIST as DOT11_COUNTRY_OR_REGION_STRING_LIST ptr

	type DOT11_PORT_STATE_NOTIFICATION
		Header as NDIS_OBJECT_HEADER
		PeerMac(0 to 5) as UCHAR
		bOpen as WINBOOLEAN
	end type

	type PDOT11_PORT_STATE_NOTIFICATION as DOT11_PORT_STATE_NOTIFICATION ptr

	type DOT11_IBSS_PARAMS
		Header as NDIS_OBJECT_HEADER
		bJoinOnly as WINBOOLEAN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type PDOT11_IBSS_PARAMS as DOT11_IBSS_PARAMS ptr

	type DOT11_QOS_PARAMS
		Header as NDIS_OBJECT_HEADER
		ucEnabledQoSProtocolFlags as UCHAR
	end type

	type PDOT11_QOS_PARAMS as DOT11_QOS_PARAMS ptr
	const DOT11_DATA_RATE_NON_STANDARD = &h01u
	const DOT11_DATA_RATE_INDEX_MASK = &h7fu
	const DOT11_QOS_PROTOCOL_FLAG_WMM = &h01u
	const DOT11_QOS_PROTOCOL_FLAG_11E = &h02u
	#define OID_DOT11_DATA_RATE_MAPPING_TABLE NWF_DEFINE_OID(151, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_SUPPORTED_COUNTRY_OR_REGION_STRING NWF_DEFINE_OID(152, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_DESIRED_COUNTRY_OR_REGION_STRING NWF_DEFINE_OID(153, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_PORT_STATE_NOTIFICATION NWF_DEFINE_OID(154, NWF_OPERATIONAL_OID, NWF_OPTIONAL_OID)
	#define OID_DOT11_IBSS_PARAMS NWF_DEFINE_OID(155, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_QOS_PARAMS NWF_DEFINE_OID(156, NWF_OPERATIONAL_OID, NWF_OPTIONAL_OID)
	#define OID_DOT11_SAFE_MODE_ENABLED NWF_DEFINE_OID(157, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_HIDDEN_NETWORK_ENABLED NWF_DEFINE_OID(158, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ASSOCIATION_PARAMS NWF_DEFINE_OID(159, NWF_OPERATIONAL_OID, NWF_MANDATORY_OID)
	const DOT11_DATA_RATE_MAPPING_TABLE_REVISION_1 = 1
	const DOT11_COUNTRY_OR_REGION_STRING_LIST_REVISION_1 = 1
	const DOT11_PORT_STATE_NOTIFICATION_REVISION_1 = 1
	const DOT11_IBSS_PARAMS_REVISION_1 = 1
	const DOT11_QOS_PARAMS_REVISION_1 = 1
	const DOT11_ASSOCIATION_PARAMS_REVISION_1 = 1

	type DOT11_ASSOCIATION_PARAMS
		Header as NDIS_OBJECT_HEADER
		BSSID(0 to 5) as UCHAR
		uAssocRequestIEsOffset as ULONG
		uAssocRequestIEsLength as ULONG
	end type

	type PDOT11_ASSOCIATION_PARAMS as DOT11_ASSOCIATION_PARAMS ptr
	const DOT11_MAX_NUM_OF_FRAGMENTS = 16
	const DOT11_PRIORITY_CONTENTION = 0
	const DOT11_PRIORITY_CONTENTION_FREE = 1
	const DOT11_SERVICE_CLASS_REORDERABLE_MULTICAST = 0
	const DOT11_SERVICE_CLASS_STRICTLY_ORDERED = 1
	const DOT11_FLAGS_80211B_SHORT_PREAMBLE = &h00000001
	const DOT11_FLAGS_80211B_PBCC = &h00000002
	const DOT11_FLAGS_80211B_CHANNEL_AGILITY = &h00000004
	const DOT11_FLAGS_PS_ON = &h00000008
	const DOT11_FLAGS_80211G_DSSS_OFDM = &h00000010
	const DOT11_FLAGS_80211G_USE_PROTECTION = &h00000020
	const DOT11_FLAGS_80211G_NON_ERP_PRESENT = &h00000040
	const DOT11_FLAGS_80211G_BARKER_PREAMBLE_MODE = &h00000080
	const DOT11_WME_PACKET = &h00000100

	type _DOT11_FRAGMENT_DESCRIPTOR
		uOffset as ULONG
		uLength as ULONG
	end type

	type DOT11_FRAGMENT_DESCRIPTOR as _DOT11_FRAGMENT_DESCRIPTOR
	type PDOT11_FRAGMENT_DESCRIPTOR as _DOT11_FRAGMENT_DESCRIPTOR ptr

	type _DOT11_PER_MSDU_COUNTERS
		uTransmittedFragmentCount as ULONG
		uRetryCount as ULONG
		uRTSSuccessCount as ULONG
		uRTSFailureCount as ULONG
		uACKFailureCount as ULONG
	end type

	type DOT11_PER_MSDU_COUNTERS as _DOT11_PER_MSDU_COUNTERS
	type PDOT11_PER_MSDU_COUNTERS as _DOT11_PER_MSDU_COUNTERS ptr
	type PDOT11_PHY_ATTRIBUTES as DOT11_PHY_ATTRIBUTES ptr

	type DOT11_HRDSSS_PHY_ATTRIBUTES
		bShortPreambleOptionImplemented as WINBOOLEAN
		bPBCCOptionImplemented as WINBOOLEAN
		bChannelAgilityPresent as WINBOOLEAN
		uHRCCAModeSupported as ULONG
	end type

	type PDOT11_HRDSSS_PHY_ATTRIBUTES as DOT11_HRDSSS_PHY_ATTRIBUTES ptr

	type DOT11_OFDM_PHY_ATTRIBUTES
		uFrequencyBandsSupported as ULONG
	end type

	type PDOT11_OFDM_PHY_ATTRIBUTES as DOT11_OFDM_PHY_ATTRIBUTES ptr

	type DOT11_ERP_PHY_ATTRIBUTES
		union
			type
				bShortPreambleOptionImplemented as WINBOOLEAN
				bPBCCOptionImplemented as WINBOOLEAN
				bChannelAgilityPresent as WINBOOLEAN
				uHRCCAModeSupported as ULONG
			end type
		end union

		bERPPBCCOptionImplemented as WINBOOLEAN
		bDSSSOFDMOptionImplemented as WINBOOLEAN
		bShortSlotTimeOptionImplemented as WINBOOLEAN
	end type

	type PDOT11_ERP_PHY_ATTRIBUTES as DOT11_ERP_PHY_ATTRIBUTES ptr
	const DOT11_PHY_ATTRIBUTES_REVISION_1 = 1

	type DOT11_PHY_ATTRIBUTES
		Header as NDIS_OBJECT_HEADER
		PhyType as DOT11_PHY_TYPE
		bHardwarePhyState as WINBOOLEAN
		bSoftwarePhyState as WINBOOLEAN
		bCFPollable as WINBOOLEAN
		uMPDUMaxLength as ULONG
		TempType as DOT11_TEMP_TYPE
		DiversitySupport as DOT11_DIVERSITY_SUPPORT

		union
			HRDSSSAttributes as DOT11_HRDSSS_PHY_ATTRIBUTES
			OFDMAttributes as DOT11_OFDM_PHY_ATTRIBUTES
			ERPAttributes as DOT11_ERP_PHY_ATTRIBUTES
		end union

		uNumberSupportedPowerLevels as ULONG
		TxPowerLevels(0 to 7) as ULONG
		uNumDataRateMappingEntries as ULONG
		DataRateMappingEntries(0 to 125) as DOT11_DATA_RATE_MAPPING_ENTRY
		SupportedDataRatesValue as DOT11_SUPPORTED_DATA_RATES_VALUE_V2
	end type

	const DOT11_EXTSTA_ATTRIBUTES_SAFEMODE_OID_SUPPORTED = &h1
	const DOT11_EXTSTA_ATTRIBUTES_SAFEMODE_CERTIFIED = &h2
	const DOT11_EXTSTA_ATTRIBUTES_SAFEMODE_RESERVED = &hc
	const DOT11_EXTSTA_ATTRIBUTES_REVISION_1 = 1
	const DOT11_EXTSTA_ATTRIBUTES_REVISION_2 = 2
	const DOT11_EXTSTA_ATTRIBUTES_REVISION_3 = 3
	type PDOT11_EXTSTA_ATTRIBUTES as DOT11_EXTSTA_ATTRIBUTES ptr

	type DOT11_EXTSTA_ATTRIBUTES
		Header as NDIS_OBJECT_HEADER
		uScanSSIDListSize as ULONG
		uDesiredBSSIDListSize as ULONG
		uDesiredSSIDListSize as ULONG
		uExcludedMacAddressListSize as ULONG
		uPrivacyExemptionListSize as ULONG
		uKeyMappingTableSize as ULONG
		uDefaultKeyTableSize as ULONG
		uWEPKeyValueMaxLength as ULONG
		uPMKIDCacheSize as ULONG
		uMaxNumPerSTADefaultKeyTables as ULONG
		bStrictlyOrderedServiceClassImplemented as WINBOOLEAN
		ucSupportedQoSProtocolFlags as UCHAR
		bSafeModeImplemented as WINBOOLEAN
		uNumSupportedCountryOrRegionStrings as ULONG
		pSupportedCountryOrRegionStrings as PDOT11_COUNTRY_OR_REGION_STRING
		uInfraNumSupportedUcastAlgoPairs as ULONG
		pInfraSupportedUcastAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
		uInfraNumSupportedMcastAlgoPairs as ULONG
		pInfraSupportedMcastAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
		uAdhocNumSupportedUcastAlgoPairs as ULONG
		pAdhocSupportedUcastAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
		uAdhocNumSupportedMcastAlgoPairs as ULONG
		pAdhocSupportedMcastAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
		bAutoPowerSaveMode as WINBOOLEAN
		uMaxNetworkOffloadListSize as ULONG
		bMFPCapable as WINBOOLEAN
		uInfraNumSupportedMcastMgmtAlgoPairs as ULONG
		pInfraSupportedMcastMgmtAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
	end type

	type _DOT11_RECV_EXTENSION_INFO
		uVersion as ULONG
		pvReserved as PVOID
		dot11PhyType as DOT11_PHY_TYPE
		uChCenterFrequency as ULONG
		lRSSI as LONG
		lRSSIMin as LONG
		lRSSIMax as LONG
		uRSSI as ULONG
		ucPriority as UCHAR
		ucDataRate as UCHAR
		ucPeerMacAddress(0 to 5) as UCHAR
		dwExtendedStatus as ULONG
		hWEPOffloadContext as HANDLE
		hAuthOffloadContext as HANDLE
		usWEPAppliedMask as USHORT
		usWPAMSDUPriority as USHORT
		dot11LowestIV48Counter as DOT11_IV48_COUNTER
		usDot11LeftRWBitMap as USHORT
		dot11HighestIV48Counter as DOT11_IV48_COUNTER
		usDot11RightRWBitMap as USHORT
		usNumberOfMPDUsReceived as USHORT
		usNumberOfFragments as USHORT
		pNdisPackets(0 to 0) as PVOID
	end type

	type DOT11_RECV_EXTENSION_INFO as _DOT11_RECV_EXTENSION_INFO
	type PDOT11_RECV_EXTENSION_INFO as _DOT11_RECV_EXTENSION_INFO ptr

	type _DOT11_RECV_EXTENSION_INFO_V2
		uVersion as ULONG
		pvReserved as PVOID
		dot11PhyType as DOT11_PHY_TYPE
		uChCenterFrequency as ULONG
		lRSSI as LONG
		uRSSI as ULONG
		ucPriority as UCHAR
		ucDataRate as UCHAR
		ucPeerMacAddress(0 to 5) as UCHAR
		dwExtendedStatus as ULONG
		hWEPOffloadContext as HANDLE
		hAuthOffloadContext as HANDLE
		usWEPAppliedMask as USHORT
		usWPAMSDUPriority as USHORT
		dot11LowestIV48Counter as DOT11_IV48_COUNTER
		usDot11LeftRWBitMap as USHORT
		dot11HighestIV48Counter as DOT11_IV48_COUNTER
		usDot11RightRWBitMap as USHORT
		usNumberOfMPDUsReceived as USHORT
		usNumberOfFragments as USHORT
		pNdisPackets(0 to 0) as PVOID
	end type

	type DOT11_RECV_EXTENSION_INFO_V2 as _DOT11_RECV_EXTENSION_INFO_V2
	type PDOT11_RECV_EXTENSION_INFO_V2 as _DOT11_RECV_EXTENSION_INFO_V2 ptr
	const DOT11_STATUS_SUCCESS = &h00000001
	const DOT11_STATUS_RETRY_LIMIT_EXCEEDED = &h00000002
	const DOT11_STATUS_UNSUPPORTED_PRIORITY = &h00000004
	const DOT11_STATUS_UNSUPPORTED_SERVICE_CLASS = &h00000008
	const DOT11_STATUS_UNAVAILABLE_PRIORITY = &h00000010
	const DOT11_STATUS_UNAVAILABLE_SERVICE_CLASS = &h00000020
	const DOT11_STATUS_XMIT_MSDU_TIMER_EXPIRED = &h00000040
	const DOT11_STATUS_UNAVAILABLE_BSS = &h00000080
	const DOT11_STATUS_EXCESSIVE_DATA_LENGTH = &h00000100
	const DOT11_STATUS_ENCRYPTION_FAILED = &h00000200
	const DOT11_STATUS_WEP_KEY_UNAVAILABLE = &h00000400
	const DOT11_STATUS_ICV_VERIFIED = &h00000800
	const DOT11_STATUS_PACKET_REASSEMBLED = &h00001000
	const DOT11_STATUS_PACKET_NOT_REASSEMBLED = &h00002000
	const DOT11_STATUS_GENERATE_AUTH_FAILED = &h00004000
	const DOT11_STATUS_AUTH_NOT_VERIFIED = &h00008000
	const DOT11_STATUS_AUTH_VERIFIED = &h00010000
	const DOT11_STATUS_AUTH_FAILED = &h00020000
	const DOT11_STATUS_PS_LIFETIME_EXPIRED = &h00040000

	type _DOT11_STATUS_INDICATION
		uStatusType as ULONG
		ndisStatus as NDIS_STATUS
	end type

	type DOT11_STATUS_INDICATION as _DOT11_STATUS_INDICATION
	type PDOT11_STATUS_INDICATION as _DOT11_STATUS_INDICATION ptr

	type DOT11_MPDU_MAX_LENGTH_INDICATION
		Header as NDIS_OBJECT_HEADER
		uPhyId as ULONG
		uMPDUMaxLength as ULONG
	end type

	type PDOT11_MPDU_MAX_LENGTH_INDICATION as DOT11_MPDU_MAX_LENGTH_INDICATION ptr
	const DOT11_MPDU_MAX_LENGTH_INDICATION_REVISION_1 = 1
	const DOT11_ASSOCIATION_START_PARAMETERS_REVISION_1 = 1

	type DOT11_ASSOCIATION_START_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		MacAddr(0 to 5) as UCHAR
		SSID as DOT11_SSID
		uIHVDataOffset as ULONG
		uIHVDataSize as ULONG
	end type

	type PDOT11_ASSOCIATION_START_PARAMETERS as DOT11_ASSOCIATION_START_PARAMETERS ptr

	type DOT11_ENCAP_ENTRY
		usEtherType as USHORT
		usEncapType as USHORT
	end type

	type PDOT11_ENCAP_ENTRY as DOT11_ENCAP_ENTRY ptr

	type DOT11_DS_INFO as long
	enum
		DOT11_DS_CHANGED
		DOT11_DS_UNCHANGED
		DOT11_DS_UNKNOWN
	end enum

	type PDOT11_DS_INFO as DOT11_DS_INFO ptr
	type DOT11_ASSOC_STATUS as ULONG
	const DOT11_ENCAP_RFC_1042 = 1
	const DOT11_ENCAP_802_1H = 2
	const DOT11_STATUS_SCAN_CONFIRM = 1
	const DOT11_STATUS_JOIN_CONFIRM = 2
	const DOT11_STATUS_START_CONFIRM = 3
	const DOT11_STATUS_RESET_CONFIRM = 4
	const DOT11_STATUS_AP_JOIN_CONFIRM = 5
	const DOT11_STATUS_MPDU_MAX_LENGTH_CHANGED = 6
	const DOT11_ASSOC_STATUS_SUCCESS = 0
	const DOT11_ASSOC_STATUS_FAILURE = &h00000001u
	const DOT11_ASSOC_STATUS_UNREACHABLE = &h00000002u
	const DOT11_ASSOC_STATUS_RADIO_OFF = &h00000003u
	const DOT11_ASSOC_STATUS_PHY_DISABLED = &h00000004u
	const DOT11_ASSOC_STATUS_CANCELLED = &h00000005u
	const DOT11_ASSOC_STATUS_CANDIDATE_LIST_EXHAUSTED = &h00000006u
	const DOT11_ASSOC_STATUS_DISASSOCIATED_BY_OS = &h00000007u
	const DOT11_ASSOC_STATUS_DISASSOCIATED_BY_ROAMING = &h00000008u
	const DOT11_ASSOC_STATUS_DISASSOCIATED_BY_RESET = &h00000009u
	const DOT11_ASSOC_STATUS_SYSTEM_ERROR = &h0000000au
	const DOT11_ASSOC_STATUS_ROAMING_BETTER_AP_FOUND = &h0000000bu
	const DOT11_ASSOC_STATUS_ROAMING_ASSOCIATION_LOST = &h0000000cu
	const DOT11_ASSOC_STATUS_ROAMING_ADHOC = &h0000000du
	const DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED = &h00010000u
	const DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED_START = DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED
	const DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED_END = &h0001ffffu
	const DOT11_ASSOC_STATUS_PEER_DISASSOCIATED = &h00020000u
	const DOT11_ASSOC_STATUS_PEER_DISASSOCIATED_START = DOT11_ASSOC_STATUS_PEER_DISASSOCIATED
	const DOT11_ASSOC_STATUS_PEER_DISASSOCIATED_END = &h0002ffffu
	const DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE = &h00030000u
	const DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE_START = DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE
	const DOT11_ASSOC_STATUS_ASSOCIATION_RESPONSE_END = &h0003ffffu
	const DOT11_ASSOC_STATUS_REASON_CODE_MASK = &hffffu
	const DOT11_ASSOC_STATUS_IHV_START = &h80000000u
	const DOT11_ASSOC_STATUS_IHV_END = &hffffffffu
	const DOT11_ASSOCIATION_COMPLETION_PARAMETERS_REVISION_1 = 1
	const DOT11_ASSOCIATION_COMPLETION_PARAMETERS_REVISION_2 = 2

	type DOT11_ASSOCIATION_COMPLETION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		MacAddr(0 to 5) as UCHAR
		uStatus as DOT11_ASSOC_STATUS
		bReAssocReq as WINBOOLEAN
		bReAssocResp as WINBOOLEAN
		uAssocReqOffset as ULONG
		uAssocReqSize as ULONG
		uAssocRespOffset as ULONG
		uAssocRespSize as ULONG
		uBeaconOffset as ULONG
		uBeaconSize as ULONG
		uIHVDataOffset as ULONG
		uIHVDataSize as ULONG
		AuthAlgo as DOT11_AUTH_ALGORITHM
		UnicastCipher as DOT11_CIPHER_ALGORITHM
		MulticastCipher as DOT11_CIPHER_ALGORITHM
		uActivePhyListOffset as ULONG
		uActivePhyListSize as ULONG
		bFourAddressSupported as WINBOOLEAN
		bPortAuthorized as WINBOOLEAN
		ucActiveQoSProtocol as UCHAR
		DSInfo as DOT11_DS_INFO
		uEncapTableOffset as ULONG
		uEncapTableSize as ULONG

		#if _WIN32_WINNT = &h0602
			MulticastMgmtCipher as DOT11_CIPHER_ALGORITHM
			uAssocComebackTime as ULONG
		#endif
	end type

	type PDOT11_ASSOCIATION_COMPLETION_PARAMETERS as DOT11_ASSOCIATION_COMPLETION_PARAMETERS ptr
	const DOT11_CONNECTION_STATUS_SUCCESS = DOT11_ASSOC_STATUS_SUCCESS
	const DOT11_CONNECTION_STATUS_FAILURE = DOT11_ASSOC_STATUS_FAILURE
	const DOT11_CONNECTION_STATUS_CANDIDATE_LIST_EXHAUSTED = DOT11_ASSOC_STATUS_CANDIDATE_LIST_EXHAUSTED
	const DOT11_CONNECTION_STATUS_PHY_POWER_DOWN = DOT11_ASSOC_STATUS_RADIO_OFF
	const DOT11_CONNECTION_STATUS_CANCELLED = DOT11_ASSOC_STATUS_CANCELLED
	const DOT11_CONNECTION_STATUS_IHV_START = DOT11_ASSOC_STATUS_IHV_START
	const DOT11_CONNECTION_STATUS_IHV_END = DOT11_ASSOC_STATUS_IHV_END
	const DOT11_ROAMING_REASON_BETTER_AP_FOUND = DOT11_ASSOC_STATUS_ROAMING_BETTER_AP_FOUND
	const DOT11_ROAMING_REASON_ASSOCIATION_LOST = DOT11_ASSOC_STATUS_ROAMING_ASSOCIATION_LOST
	const DOT11_ROAMING_REASON_ADHOC = DOT11_ASSOC_STATUS_ROAMING_ADHOC
	const DOT11_ROAMING_REASON_IHV_START = DOT11_ASSOC_STATUS_IHV_START
	const DOT11_ROAMING_REASON_IHV_END = DOT11_ASSOC_STATUS_IHV_END
	const DOT11_DISASSOC_REASON_OS = DOT11_ASSOC_STATUS_DISASSOCIATED_BY_OS
	const DOT11_DISASSOC_REASON_PEER_UNREACHABLE = DOT11_ASSOC_STATUS_UNREACHABLE
	const DOT11_DISASSOC_REASON_PEER_DEAUTHENTICATED = DOT11_ASSOC_STATUS_PEER_DEAUTHENTICATED
	const DOT11_DISASSOC_REASON_PEER_DISASSOCIATED = DOT11_ASSOC_STATUS_PEER_DISASSOCIATED
	const DOT11_DISASSOC_REASON_RADIO_OFF = DOT11_ASSOC_STATUS_RADIO_OFF
	const DOT11_DISASSOC_REASON_PHY_DISABLED = DOT11_ASSOC_STATUS_PHY_DISABLED
	const DOT11_DISASSOC_REASON_IHV_START = DOT11_ASSOC_STATUS_IHV_START
	const DOT11_DISASSOC_REASON_IHV_END = DOT11_ASSOC_STATUS_IHV_END
	const DOT11_CONNECTION_START_PARAMETERS_REVISION_1 = 1
	const DOT11_CONNECTION_COMPLETION_PARAMETERS_REVISION_1 = 1
	const DOT11_ROAMING_START_PARAMETERS_REVISION_1 = 1
	const DOT11_ROAMING_COMPLETION_PARAMETERS_REVISION_1 = 1
	const DOT11_DISASSOCIATION_PARAMETERS_REVISION_1 = 1
	const DOT11_TKIPMIC_FAILURE_PARAMETERS_REVISION_1 = 1
	const DOT11_PMKID_CANDIDATE_LIST_PARAMETERS_REVISION_1 = 1
	const DOT11_PHY_STATE_PARAMETERS_REVISION_1 = 1
	const DOT11_LINK_QUALITY_PARAMETERS_REVISION_1 = 1
	const DOT11_EXTSTA_SEND_CONTEXT_REVISION_1 = 1
	const DOT11_EXTSTA_RECV_CONTEXT_REVISION_1 = 1

	type DOT11_CONNECTION_START_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		BSSType as DOT11_BSS_TYPE
		AdhocBSSID(0 to 5) as UCHAR
		AdhocSSID as DOT11_SSID
	end type

	type PDOT11_CONNECTION_START_PARAMETERS as DOT11_CONNECTION_START_PARAMETERS ptr

	type DOT11_CONNECTION_COMPLETION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		uStatus as DOT11_ASSOC_STATUS
	end type

	type PDOT11_CONNECTION_COMPLETION_PARAMETERS as DOT11_CONNECTION_COMPLETION_PARAMETERS ptr

	type DOT11_ROAMING_START_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		AdhocBSSID(0 to 5) as UCHAR
		AdhocSSID as DOT11_SSID
		uRoamingReason as DOT11_ASSOC_STATUS
	end type

	type PDOT11_ROAMING_START_PARAMETERS as DOT11_ROAMING_START_PARAMETERS ptr

	type DOT11_ROAMING_COMPLETION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		uStatus as DOT11_ASSOC_STATUS
	end type

	type PDOT11_ROAMING_COMPLETION_PARAMETERS as DOT11_ROAMING_COMPLETION_PARAMETERS ptr

	type DOT11_DISASSOCIATION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		MacAddr(0 to 5) as UCHAR
		uReason as DOT11_ASSOC_STATUS
		uIHVDataOffset as ULONG
		uIHVDataSize as ULONG
	end type

	type PDOT11_DISASSOCIATION_PARAMETERS as DOT11_DISASSOCIATION_PARAMETERS ptr

	type DOT11_TKIPMIC_FAILURE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		bDefaultKeyFailure as WINBOOLEAN
		uKeyIndex as ULONG
		PeerMac(0 to 5) as UCHAR
	end type

	type PDOT11_TKIPMIC_FAILURE_PARAMETERS as DOT11_TKIPMIC_FAILURE_PARAMETERS ptr

	type DOT11_PMKID_CANDIDATE_LIST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		uCandidateListSize as ULONG
		uCandidateListOffset as ULONG
	end type

	type PDOT11_PMKID_CANDIDATE_LIST_PARAMETERS as DOT11_PMKID_CANDIDATE_LIST_PARAMETERS ptr

	type DOT11_BSSID_CANDIDATE
		BSSID(0 to 5) as UCHAR
		uFlags as ULONG
	end type

	type PDOT11_BSSID_CANDIDATE as DOT11_BSSID_CANDIDATE ptr

	type DOT11_PHY_STATE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		uPhyId as ULONG
		bHardwarePhyState as WINBOOLEAN
		bSoftwarePhyState as WINBOOLEAN
	end type

	type PDOT11_PHY_STATE_PARAMETERS as DOT11_PHY_STATE_PARAMETERS ptr

	type DOT11_LINK_QUALITY_ENTRY
		PeerMacAddr(0 to 5) as UCHAR
		ucLinkQuality as UCHAR
	end type

	type PDOT11_LINK_QUALITY_ENTRY as DOT11_LINK_QUALITY_ENTRY ptr

	type DOT11_LINK_QUALITY_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		uLinkQualityListSize as ULONG
		uLinkQualityListOffset as ULONG
	end type

	type PDOT11_LINK_QUALITY_PARAMETERS as DOT11_LINK_QUALITY_PARAMETERS ptr

	type DOT11_EXTSTA_SEND_CONTEXT
		Header as NDIS_OBJECT_HEADER
		usExemptionActionType as USHORT
		uPhyId as ULONG
		uDelayedSleepValue as ULONG
		pvMediaSpecificInfo as PVOID
		uSendFlags as ULONG
	end type

	type PDOT11_EXTSTA_SEND_CONTEXT as DOT11_EXTSTA_SEND_CONTEXT ptr

	type DOT11_EXTSTA_RECV_CONTEXT
		Header as NDIS_OBJECT_HEADER
		uReceiveFlags as ULONG
		uPhyId as ULONG
		uChCenterFrequency as ULONG
		usNumberOfMPDUsReceived as USHORT
		lRSSI as LONG
		ucDataRate as UCHAR
		uSizeMediaSpecificInfo as ULONG
		pvMediaSpecificInfo as PVOID
		ullTimestamp as ULONGLONG
	end type

	type PDOT11_EXTSTA_RECV_CONTEXT as DOT11_EXTSTA_RECV_CONTEXT ptr
	const OID_DOT11_PRIVATE_OIDS_START = OID_DOT11_NDIS_START + 1024
	const OID_DOT11_CURRENT_ADDRESS = OID_DOT11_PRIVATE_OIDS_START + 2
	const OID_DOT11_PERMANENT_ADDRESS = OID_DOT11_PRIVATE_OIDS_START + 3
	const OID_DOT11_MULTICAST_LIST = OID_DOT11_PRIVATE_OIDS_START + 4
	const OID_DOT11_MAXIMUM_LIST_SIZE = OID_DOT11_PRIVATE_OIDS_START + 5
	const DOT11_RECV_FLAG_RAW_PACKET = &h00000001u
	const DOT11_RECV_FLAG_RAW_PACKET_FCS_FAILURE = &h00000002u
	const DOT11_RECV_FLAG_RAW_PACKET_TIMESTAMP = &h00000004u
	const DOT11_PMKID_CANDIDATE_PREAUTH_ENABLED = &h00000001u
	#define DEFINE_NWF_GUID(NAME, ORD) DEFINE_GUID(NAME, &h6cb9a43e + (ORD), &hc45f, &h4039, &h9f, &he6, &hd0, &h8c, &hb0, &h57, &h18, &h4c)

	extern GUID_NWF_OFFLOAD_CAPABILITY as const GUID
	extern GUID_NWF_CURRENT_OFFLOAD_CAPABILITY as const GUID
	extern GUID_NWF_WEP_OFFLOAD as const GUID
	extern GUID_NWF_WEP_UPLOAD as const GUID
	extern GUID_NWF_DEFAULT_WEP_OFFLOAD as const GUID
	extern GUID_NWF_DEFAULT_WEP_UPLOAD as const GUID
	extern GUID_NWF_MPDU_MAX_LENGTH as const GUID
	extern GUID_NWF_OPERATION_MODE_CAPABILITY as const GUID
	extern GUID_NWF_CURRENT_OPERATION_MODE as const GUID
	extern GUID_NWF_CURRENT_PACKET_FILTER as const GUID
	extern GUID_NWF_ATIM_WINDOW as const GUID
	extern GUID_NWF_SCAN_REQUEST as const GUID
	extern GUID_NWF_CURRENT_PHY_TYPE as const GUID
	extern GUID_NWF_JOIN_REQUEST as const GUID
	extern GUID_NWF_START_REQUEST as const GUID
	extern GUID_NWF_UPDATE_IE as const GUID
	extern GUID_NWF_RESET_REQUEST as const GUID
	extern GUID_NWF_NIC_POWER_STATE as const GUID
	extern GUID_NWF_OPTIONAL_CAPABILITY as const GUID
	extern GUID_NWF_CURRENT_OPTIONAL_CAPABILITY as const GUID
	extern GUID_NWF_STATION_ID as const GUID
	extern GUID_NWF_MEDIUM_OCCUPANCY_LIMIT as const GUID
	extern GUID_NWF_CF_POLLABLE as const GUID
	extern GUID_NWF_CFP_PERIOD as const GUID
	extern GUID_NWF_CFP_MAX_DURATION as const GUID
	extern GUID_NWF_POWER_MGMT_MODE as const GUID
	extern GUID_NWF_OPERATIONAL_RATE_SET as const GUID
	extern GUID_NWF_BEACON_PERIOD as const GUID
	extern GUID_NWF_DTIM_PERIOD as const GUID
	extern GUID_NWF_WEP_ICV_ERROR_COUNT as const GUID
	extern GUID_NWF_MAC_ADDRESS as const GUID
	extern GUID_NWF_RTS_THRESHOLD as const GUID
	extern GUID_NWF_SHORT_RETRY_LIMIT as const GUID
	extern GUID_NWF_LONG_RETRY_LIMIT as const GUID
	extern GUID_NWF_FRAGMENTATION_THRESHOLD as const GUID
	extern GUID_NWF_MAX_TRANSMIT_MSDU_LIFETIME as const GUID
	extern GUID_NWF_MAX_RECEIVE_LIFETIME as const GUID
	extern GUID_NWF_COUNTERS_ENTRY as const GUID
	extern GUID_NWF_SUPPORTED_PHY_TYPES as const GUID
	extern GUID_NWF_CURRENT_REG_DOMAIN as const GUID
	extern GUID_NWF_TEMP_TYPE as const GUID
	extern GUID_NWF_CURRENT_TX_ANTENNA as const GUID
	extern GUID_NWF_DIVERSITY_SUPPORT as const GUID
	extern GUID_NWF_CURRENT_RX_ANTENNA as const GUID
	extern GUID_NWF_SUPPORTED_POWER_LEVELS as const GUID
	extern GUID_NWF_CURRENT_TX_POWER_LEVEL as const GUID
	extern GUID_NWF_HOP_TIME as const GUID
	extern GUID_NWF_CURRENT_CHANNEL_NUMBER as const GUID
	extern GUID_NWF_MAX_DWELL_TIME as const GUID
	extern GUID_NWF_CURRENT_DWELL_TIME as const GUID
	extern GUID_NWF_CURRENT_SET as const GUID
	extern GUID_NWF_CURRENT_PATTERN as const GUID
	extern GUID_NWF_CURRENT_INDEX as const GUID
	extern GUID_NWF_CURRENT_CHANNEL as const GUID
	extern GUID_NWF_CCA_MODE_SUPPORTED as const GUID
	extern GUID_NWF_CURRENT_CCA_MODE as const GUID
	extern GUID_NWF_ED_THRESHOLD as const GUID
	extern GUID_NWF_CCA_WATCHDOG_TIMER_MAX as const GUID
	extern GUID_NWF_CCA_WATCHDOG_COUNT_MAX as const GUID
	extern GUID_NWF_CCA_WATCHDOG_TIMER_MIN as const GUID
	extern GUID_NWF_CCA_WATCHDOG_COUNT_MIN as const GUID
	extern GUID_NWF_REG_DOMAINS_SUPPORT_VALUE as const GUID
	extern GUID_NWF_SUPPORTED_TX_ANTENNA as const GUID
	extern GUID_NWF_SUPPORTED_RX_ANTENNA as const GUID
	extern GUID_NWF_DIVERSITY_SELECTION_RX as const GUID
	extern GUID_NWF_SUPPORTED_DATA_RATES_VALUE as const GUID
	extern GUID_NWF_CURRENT_FREQUENCY as const GUID
	extern GUID_NWF_TI_THRESHOLD as const GUID
	extern GUID_NWF_FREQUENCY_BANDS_SUPPORTED as const GUID
	extern GUID_NWF_SHORT_PREAMBLE_OPTION_IMPLEMENTED as const GUID
	extern GUID_NWF_PBCC_OPTION_IMPLEMENTED as const GUID
	extern GUID_NWF_CHANNEL_AGILITY_PRESENT as const GUID
	extern GUID_NWF_CHANNEL_AGILITY_ENABLED as const GUID
	extern GUID_NWF_HR_CCA_MODE_SUPPORTED as const GUID
	extern GUID_NWF_MULTI_DOMAIN_CAPABILITY_IMPLEMENTED as const GUID
	extern GUID_NWF_MULTI_DOMAIN_CAPABILITY_ENABLED as const GUID
	extern GUID_NWF_COUNTRY_STRING as const GUID
	extern GUID_NWF_MULTI_DOMAIN_CAPABILITY as const GUID
	extern GUID_NWF_EHCC_PRIME_RADIX as const GUID
	extern GUID_NWF_EHCC_NUMBER_OF_CHANNELS_FAMILY_INDEX as const GUID
	extern GUID_NWF_EHCC_CAPABILITY_IMPLEMENTED as const GUID
	extern GUID_NWF_EHCC_CAPABILITY_ENABLED as const GUID
	extern GUID_NWF_HOP_ALGORITHM_ADOPTED as const GUID
	extern GUID_NWF_RANDOM_TABLE_FLAG as const GUID
	extern GUID_NWF_NUMBER_OF_HOPPING_SETS as const GUID
	extern GUID_NWF_HOP_MODULUS as const GUID
	extern GUID_NWF_HOP_OFFSET as const GUID
	extern GUID_NWF_HOPPING_PATTERN as const GUID
	extern GUID_NWF_RANDOM_TABLE_FIELD_NUMBER as const GUID
	extern GUID_NWF_WPA_TSC as const GUID
	extern GUID_NWF_RSSI_RANGE as const GUID
	extern GUID_NWF_RF_USAGE as const GUID
	extern GUID_NWF_NIC_SPECIFIC_EXTENSION as const GUID
	extern GUID_NWF_AP_JOIN_REQUEST as const GUID
	extern GUID_NWF_ERP_PBCC_OPTION_IMPLEMENTED as const GUID
	extern GUID_NWF_ERP_PBCC_OPTION_ENABLED as const GUID
	extern GUID_NWF_DSSS_OFDM_OPTION_IMPLEMENTED as const GUID
	extern GUID_NWF_DSSS_OFDM_OPTION_ENABLED as const GUID
	extern GUID_NWF_SHORT_SLOT_TIME_OPTION_IMPLEMENTED as const GUID
	extern GUID_NWF_SHORT_SLOT_TIME_OPTION_ENABLED as const GUID
	extern GUID_NWF_MAX_MAC_ADDRESS_STATES as const GUID
	extern GUID_NWF_RECV_SENSITIVITY_LIST as const GUID
	extern GUID_NWF_WME_IMPLEMENTED as const GUID
	extern GUID_NWF_WME_ENABLED as const GUID
	extern GUID_NWF_WME_AC_PARAMETERS as const GUID
	extern GUID_NWF_WME_UPDATE_IE as const GUID
	extern GUID_NWF_QOS_TX_QUEUES_SUPPORTED as const GUID
	extern GUID_NWF_QOS_TX_DURATION as const GUID
	extern GUID_NWF_QOS_TX_MEDIUM_TIME as const GUID
	extern GUID_NWF_SUPPORTED_OFDM_FREQUENCY_LIST as const GUID
	extern GUID_NWF_SUPPORTED_DSSS_CHANNEL_LIST as const GUID
	extern GUID_NWF_AUTO_CONFIG_ENABLED as const GUID
	extern GUID_NWF_ENUM_BSS_LIST as const GUID
	extern GUID_NWF_FLUSH_BSS_LIST as const GUID
	extern GUID_NWF_POWER_MGMT_REQUEST as const GUID
	extern GUID_NWF_DESIRED_SSID_LIST as const GUID
	extern GUID_NWF_EXCLUDED_MAC_ADDRESS_LIST as const GUID
	extern GUID_NWF_DESIRED_BSSID_LIST as const GUID
	extern GUID_NWF_DESIRED_BSS_TYPE as const GUID
	extern GUID_NWF_PMKID_LIST as const GUID
	extern GUID_NWF_CONNECT_REQUEST as const GUID
	extern GUID_NWF_EXCLUDE_UNENCRYPTED as const GUID
	extern GUID_NWF_STATISTICS as const GUID
	extern GUID_NWF_PRIVACY_EXEMPTION_LIST as const GUID
	extern GUID_NWF_ENABLED_AUTHENTICATION_ALGORITHM as const GUID
	extern GUID_NWF_SUPPORTED_UNICAST_ALGORITHM_PAIR as const GUID
	extern GUID_NWF_ENABLED_UNICAST_CIPHER_ALGORITHM as const GUID
	extern GUID_NWF_SUPPORTED_MULTICAST_ALGORITHM_PAIR as const GUID
	extern GUID_NWF_ENABLED_MULTICAST_CIPHER_ALGORITHM as const GUID
	extern GUID_NWF_CIPHER_DEFAULT_KEY_ID as const GUID
	extern GUID_NWF_CIPHER_DEFAULT_KEY as const GUID
	extern GUID_NWF_CIPHER_KEY_MAPPING_KEY as const GUID
	extern GUID_NWF_ENUM_ASSOCIATION_INFO as const GUID
	extern GUID_NWF_DISCONNECT_REQUEST as const GUID
	extern GUID_NWF_UNICAST_USE_GROUP_ENABLED as const GUID
	extern GUID_NWF_PHY_STATE as const GUID
	extern GUID_NWF_DESIRED_PHY_LIST as const GUID
	extern GUID_NWF_CURRENT_PHY_ID as const GUID
	extern GUID_NWF_MEDIA_STREAMING_ENABLED as const GUID
	extern GUID_NWF_UNREACHABLE_DETECTION_THRESHOLD as const GUID
	extern GUID_NWF_ACTIVE_PHY_LIST as const GUID
	extern GUID_NWF_EXTSTA_CAPABILITY as const GUID
	extern GUID_NWF_DATA_RATE_MAPPING_TABLE as const GUID
	extern GUID_NWF_SUPPORTED_COUNTRY_OR_REGION_STRING as const GUID
	extern GUID_NWF_DESIRED_COUNTRY_OR_REGION_STRING as const GUID
	extern GUID_NWF_PORT_STATE_NOTIFICATION as const GUID
	extern GUID_NWF_IBSS_PARAMS as const GUID
	extern GUID_NWF_QOS_PARAMS as const GUID
	extern GUID_NWF_SAFE_MODE_ENABLED as const GUID
	extern GUID_NWF_HIDDEN_NETWORK_ENABLED as const GUID
	extern GUID_NWF_ASSOCIATION_PARAMS as const GUID
	extern GUID_NWF_CURRENT_ADDRESS as const GUID
	extern GUID_NWF_PERMANENT_ADDRESS as const GUID
	extern GUID_NWF_MULTICAST_LIST as const GUID
	extern GUID_NWF_MAXIMUM_LIST_SIZE as const GUID
#endif

#if _WIN32_WINNT >= &h0601
	const NWF_EXTAP_OID = &h03u
	#define OID_DOT11_WPS_ENABLED NWF_DEFINE_OID(&h01, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_START_AP_REQUEST NWF_DEFINE_OID(&h02, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_AVAILABLE_CHANNEL_LIST NWF_DEFINE_OID(&h03, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_AVAILABLE_FREQUENCY_LIST NWF_DEFINE_OID(&h04, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_DISASSOCIATE_PEER_REQUEST NWF_DEFINE_OID(&h05, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_INCOMING_ASSOCIATION_DECISION NWF_DEFINE_OID(&h06, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ADDITIONAL_IE NWF_DEFINE_OID(&h07, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_ENUM_PEER_INFO NWF_DEFINE_OID(&h08, NWF_EXTAP_OID, NWF_MANDATORY_OID)
	const DOT11_ASSOC_ERROR_SOURCE_OS = &h0
	const DOT11_ASSOC_ERROR_SOURCE_REMOTE = &h01
	const DOT11_ASSOC_ERROR_SOURCE_OTHER = &hff
	const DOT11_STOP_AP_REASON_FREQUENCY_NOT_AVAILABLE = &h1
	const DOT11_STOP_AP_REASON_CHANNEL_NOT_AVAILABLE = &h2
	const DOT11_STOP_AP_REASON_AP_ACTIVE = &h3
	const DOT11_STOP_AP_REASON_IHV_START = &hff000000
	const DOT11_STOP_AP_REASON_IHV_END = &hffffffff
	const DOT11_CAN_SUSTAIN_AP_REASON_IHV_START = &hff000000
	const DOT11_CAN_SUSTAIN_AP_REASON_IHV_END = &hffffffff
	const DOT11_EXTAP_ATTRIBUTES_REVISION_1 = 1
	const DOT11_INCOMING_ASSOC_STARTED_PARAMETERS_REVISION_1 = 1
	const DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS_REVISION_1 = 1
	const DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS_REVISION_1 = 1
	const DOT11_STOP_AP_PARAMETERS_REVISION_1 = 1
	const DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS_REVISION_1 = 1
	const DOT11_CAN_SUSTAIN_AP_PARAMETERS_REVISION_1 = 1
	const DOT11_AVAILABLE_CHANNEL_LIST_REVISION_1 = 1
	const DOT11_AVAILABLE_FREQUENCY_LIST_REVISION_1 = 1
	const DOT11_DISASSOCIATE_PEER_REQUEST_REVISION_1 = 1
	const DOT11_INCOMING_ASSOC_DECISION_REVISION_1 = 1
	const DOT11_ADDITIONAL_IE_REVISION_1 = 1
	const DOT11_EXTAP_SEND_CONTEXT_REVISION_1 = 1
	const DOT11_EXTAP_RECV_CONTEXT_REVISION_1 = 1
	const DOT11_PEER_INFO_LIST_REVISION_1 = 1
#endif

#if _WIN32_WINNT = &h0602
	const DOT11_INCOMING_ASSOC_DECISION_REVISION_2 = 2
#endif

#if _WIN32_WINNT >= &h0601
	#define NDIS_SIZEOF_DOT11_EXTAP_ATTRIBUTES_REVISION_1 sizeof(DOT11_EXTAP_ATTRIBUTES)
	#define DOT11_SIZEOF_INCOMING_ASSOC_DECISION_REVISION_1 sizeof(DOT11_INCOMING_ASSOC_DECISION)
#endif

#if _WIN32_WINNT = &h0602
	#define DOT11_SIZEOF_INCOMING_ASSOC_DECISION_REVISION_2 sizeof(DOT11_INCOMING_ASSOC_DECISION_V2)
#endif

#if _WIN32_WINNT >= &h0601
	type _DOT11_EXTAP_ATTRIBUTES
		Header as NDIS_OBJECT_HEADER
		uScanSSIDListSize as ULONG
		uDesiredSSIDListSize as ULONG
		uPrivacyExemptionListSize as ULONG
		uAssociationTableSize as ULONG
		uDefaultKeyTableSize as ULONG
		uWEPKeyValueMaxLength as ULONG
		bStrictlyOrderedServiceClassImplemented as WINBOOLEAN
		uNumSupportedCountryOrRegionStrings as ULONG
		pSupportedCountryOrRegionStrings as PDOT11_COUNTRY_OR_REGION_STRING
		uInfraNumSupportedUcastAlgoPairs as ULONG
		pInfraSupportedUcastAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
		uInfraNumSupportedMcastAlgoPairs as ULONG
		pInfraSupportedMcastAlgoPairs as PDOT11_AUTH_CIPHER_PAIR
	end type

	type DOT11_EXTAP_ATTRIBUTES as _DOT11_EXTAP_ATTRIBUTES
	type PDOT11_EXTAP_ATTRIBUTES as _DOT11_EXTAP_ATTRIBUTES ptr

	type _DOT11_INCOMING_ASSOC_STARTED_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerMacAddr(0 to 5) as UCHAR
	end type

	type DOT11_INCOMING_ASSOC_STARTED_PARAMETERS as _DOT11_INCOMING_ASSOC_STARTED_PARAMETERS
	type PDOT11_INCOMING_ASSOC_STARTED_PARAMETERS as _DOT11_INCOMING_ASSOC_STARTED_PARAMETERS ptr

	type _DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerMacAddr(0 to 5) as UCHAR
		bReAssocReq as WINBOOLEAN
		uAssocReqOffset as ULONG
		uAssocReqSize as ULONG
	end type

	type DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS as _DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS
	type PDOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS as _DOT11_INCOMING_ASSOC_REQUEST_RECEIVED_PARAMETERS ptr

	type _DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerMacAddr(0 to 5) as UCHAR
		uStatus as ULONG
		ucErrorSource as UCHAR
		bReAssocReq as WINBOOLEAN
		bReAssocResp as WINBOOLEAN
		uAssocReqOffset as ULONG
		uAssocReqSize as ULONG
		uAssocRespOffset as ULONG
		uAssocRespSize as ULONG
		AuthAlgo as DOT11_AUTH_ALGORITHM
		UnicastCipher as DOT11_CIPHER_ALGORITHM
		MulticastCipher as DOT11_CIPHER_ALGORITHM
		uActivePhyListOffset as ULONG
		uActivePhyListSize as ULONG
		uBeaconOffset as ULONG
		uBeaconSize as ULONG
	end type

	type DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS as _DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS
	type PDOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS as _DOT11_INCOMING_ASSOC_COMPLETION_PARAMETERS ptr

	type _DOT11_STOP_AP_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ulReason as ULONG
	end type

	type DOT11_STOP_AP_PARAMETERS as _DOT11_STOP_AP_PARAMETERS
	type PDOT11_STOP_AP_PARAMETERS as _DOT11_STOP_AP_PARAMETERS ptr

	type _DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ulPhyId as ULONG

		union
			ulChannel as ULONG
			ulFrequency as ULONG
		end union
	end type

	type DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS as _DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS
	type PDOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS as _DOT11_PHY_FREQUENCY_ADOPTED_PARAMETERS ptr

	type _DOT11_CAN_SUSTAIN_AP_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ulReason as ULONG
	end type

	type DOT11_CAN_SUSTAIN_AP_PARAMETERS as _DOT11_CAN_SUSTAIN_AP_PARAMETERS
	type PDOT11_CAN_SUSTAIN_AP_PARAMETERS as _DOT11_CAN_SUSTAIN_AP_PARAMETERS ptr

	type _DOT11_AVAILABLE_CHANNEL_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		uChannelNumber(0 to 0) as ULONG
	end type

	type DOT11_AVAILABLE_CHANNEL_LIST as _DOT11_AVAILABLE_CHANNEL_LIST
	type PDOT11_AVAILABLE_CHANNEL_LIST as _DOT11_AVAILABLE_CHANNEL_LIST ptr

	type _DOT11_AVAILABLE_FREQUENCY_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		uFrequencyValue(0 to 0) as ULONG
	end type

	type DOT11_AVAILABLE_FREQUENCY_LIST as _DOT11_AVAILABLE_FREQUENCY_LIST
	type PDOT11_AVAILABLE_FREQUENCY_LIST as _DOT11_AVAILABLE_FREQUENCY_LIST ptr

	type _DOT11_DISASSOCIATE_PEER_REQUEST
		Header as NDIS_OBJECT_HEADER
		PeerMacAddr(0 to 5) as UCHAR
		usReason as USHORT
	end type

	type DOT11_DISASSOCIATE_PEER_REQUEST as _DOT11_DISASSOCIATE_PEER_REQUEST
	type PDOT11_DISASSOCIATE_PEER_REQUEST as _DOT11_DISASSOCIATE_PEER_REQUEST ptr

	type _DOT11_INCOMING_ASSOC_DECISION
		Header as NDIS_OBJECT_HEADER
		PeerMacAddr(0 to 5) as UCHAR
		bAccept as WINBOOLEAN
		usReasonCode as USHORT
		uAssocResponseIEsOffset as ULONG
		uAssocResponseIEsLength as ULONG
	end type

	type DOT11_INCOMING_ASSOC_DECISION as _DOT11_INCOMING_ASSOC_DECISION
	type PDOT11_INCOMING_ASSOC_DECISION as _DOT11_INCOMING_ASSOC_DECISION ptr
#endif

#if _WIN32_WINNT = &h0602
	type _DOT11_INCOMING_ASSOC_DECISION_V2
		Header as NDIS_OBJECT_HEADER
		PeerMacAddr(0 to 5) as UCHAR
		bAccept as WINBOOLEAN
		usReasonCode as USHORT
		uAssocResponseIEsOffset as ULONG
		uAssocResponseIEsLength as ULONG
		WFDStatus as DOT11_WFD_STATUS_CODE
	end type

	type DOT11_INCOMING_ASSOC_DECISION_V2 as _DOT11_INCOMING_ASSOC_DECISION_V2
	type PDOT11_INCOMING_ASSOC_DECISION_V2 as _DOT11_INCOMING_ASSOC_DECISION_V2 ptr
#endif

#if _WIN32_WINNT >= &h0601
	type _DOT11_ADDITIONAL_IE
		Header as NDIS_OBJECT_HEADER
		uBeaconIEsOffset as ULONG
		uBeaconIEsLength as ULONG
		uResponseIEsOffset as ULONG
		uResponseIEsLength as ULONG
	end type

	type DOT11_ADDITIONAL_IE as _DOT11_ADDITIONAL_IE
	type PDOT11_ADDITIONAL_IE as _DOT11_ADDITIONAL_IE ptr
	type DOT11_EXTAP_SEND_CONTEXT as DOT11_EXTSTA_SEND_CONTEXT
	type PDOT11_EXTAP_SEND_CONTEXT as DOT11_EXTSTA_SEND_CONTEXT ptr
	type DOT11_EXTAP_RECV_CONTEXT as DOT11_EXTSTA_RECV_CONTEXT
	type PDOT11_EXTAP_RECV_CONTEXT as DOT11_EXTSTA_RECV_CONTEXT ptr

	type _DOT11_PEER_STATISTICS
		ullDecryptSuccessCount as ULONGLONG
		ullDecryptFailureCount as ULONGLONG
		ullTxPacketSuccessCount as ULONGLONG
		ullTxPacketFailureCount as ULONGLONG
		ullRxPacketSuccessCount as ULONGLONG
		ullRxPacketFailureCount as ULONGLONG
	end type

	type DOT11_PEER_STATISTICS as _DOT11_PEER_STATISTICS
	type PDOT11_PEER_STATISTICS as _DOT11_PEER_STATISTICS ptr

	type _DOT11_PEER_INFO
		MacAddress(0 to 5) as UCHAR
		usCapabilityInformation as USHORT
		AuthAlgo as DOT11_AUTH_ALGORITHM
		UnicastCipherAlgo as DOT11_CIPHER_ALGORITHM
		MulticastCipherAlgo as DOT11_CIPHER_ALGORITHM
		bWpsEnabled as WINBOOLEAN
		usListenInterval as USHORT
		ucSupportedRates(0 to 254) as UCHAR
		usAssociationID as USHORT
		AssociationState as DOT11_ASSOCIATION_STATE
		PowerMode as DOT11_POWER_MODE
		liAssociationUpTime as LARGE_INTEGER
		Statistics as DOT11_PEER_STATISTICS
	end type

	type DOT11_PEER_INFO as _DOT11_PEER_INFO
	type PDOT11_PEER_INFO as _DOT11_PEER_INFO ptr

	type _DOT11_PEER_INFO_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		PeerInfo(0 to 0) as DOT11_PEER_INFO
	end type

	type DOT11_PEER_INFO_LIST as _DOT11_PEER_INFO_LIST
	type PDOT11_PEER_INFO_LIST as _DOT11_PEER_INFO_LIST ptr
	const DOT11_VWIFI_COMBINATION_REVISION_1 = 1

	type _DOT11_VWIFI_COMBINATION
		Header as NDIS_OBJECT_HEADER
		uNumInfrastructure as ULONG
		uNumAdhoc as ULONG
		uNumSoftAP as ULONG
	end type

	type DOT11_VWIFI_COMBINATION as _DOT11_VWIFI_COMBINATION
	type PDOT11_VWIFI_COMBINATION as _DOT11_VWIFI_COMBINATION ptr
	#define DOT11_SIZEOF_VWIFI_COMBINATION_REVISION_1 sizeof(DOT11_VWIFI_COMBINATION)
	const DOT11_VWIFI_COMBINATION_REVISION_2 = 2

	type _DOT11_VWIFI_COMBINATION_V2
		Header as NDIS_OBJECT_HEADER
		uNumInfrastructure as ULONG
		uNumAdhoc as ULONG
		uNumSoftAP as ULONG
		uNumVirtualStation as ULONG
	end type

	type DOT11_VWIFI_COMBINATION_V2 as _DOT11_VWIFI_COMBINATION_V2
	type PDOT11_VWIFI_COMBINATION_V2 as _DOT11_VWIFI_COMBINATION_V2 ptr
	#define DOT11_SIZEOF_VWIFI_COMBINATION_REVISION_2 sizeof(DOT11_VWIFI_COMBINATION_V2)
#endif

#if _WIN32_WINNT = &h0602
	const DOT11_VWIFI_COMBINATION_REVISION_3 = 3
	#define DOT11_SIZEOF_VWIFI_COMBINATION_REVISION_3 sizeof(DOT11_VWIFI_COMBINATION_V3)

	type _DOT11_VWIFI_COMBINATION_V3
		Header as NDIS_OBJECT_HEADER
		uNumInfrastructure as ULONG
		uNumAdhoc as ULONG
		uNumSoftAP as ULONG
		uNumVirtualStation as ULONG
		uNumWFDGroup as ULONG
	end type

	type DOT11_VWIFI_COMBINATION_V3 as _DOT11_VWIFI_COMBINATION_V3
	type PDOT11_VWIFI_COMBINATION_V3 as _DOT11_VWIFI_COMBINATION_V3 ptr
#endif

#if _WIN32_WINNT >= &h0601
	const NWF_VWIFI_OID = &h04u
	#define OID_DOT11_CREATE_MAC NWF_DEFINE_OID(&h01, NWF_VWIFI_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_DELETE_MAC NWF_DEFINE_OID(&h02, NWF_VWIFI_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_PREFERRED_MAC NWF_DEFINE_OID(&h03, NWF_VWIFI_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_VIRTUAL_STATION_CAPABILITY NWF_DEFINE_OID(&h04, NWF_VWIFI_OID, NWF_OPTIONAL_OID)
	const DOT11_VWIFI_ATTRIBUTES_REVISION_1 = 1
	const DOT11_MAC_PARAMETERS_REVISION_1 = 1
	#define DOT11_SIZEOF_MAC_PARAMETERS_REVISION_1 sizeof(DOT11_MAC_PARAMETERS)

	type DOT11_VWIFI_ATTRIBUTES
		Header as NDIS_OBJECT_HEADER
		uTotalNumOfEntries as ULONG
		Combinations(0 to 0) as DOT11_VWIFI_COMBINATION
	end type

	type PDOT11_VWIFI_ATTRIBUTES as DOT11_VWIFI_ATTRIBUTES ptr

	type _DOT11_MAC_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		uOpmodeMask as ULONG
	end type

	type DOT11_MAC_PARAMETERS as _DOT11_MAC_PARAMETERS
	type PDOT11_MAC_PARAMETERS as _DOT11_MAC_PARAMETERS ptr

	type DOT11_MAC_INFO
		uReserved as ULONG
		uNdisPortNumber as ULONG
		MacAddr(0 to 5) as UCHAR
	end type

	type PDOT11_MAC_INFO as DOT11_MAC_INFO ptr
#endif

#if _WIN32_WINNT = &h0602
	const DOT11_WFD_ATTRIBUTES_REVISION_1 = 1
	#define DOT11_SIZEOF_WFD_ATTRIBUTES_REVISION_1 sizeof(DOT11_WFD_ATTRIBUTES)

	type _DOT11_WFD_ATTRIBUTES
		Header as NDIS_OBJECT_HEADER
		uNumConcurrentGORole as ULONG
		uNumConcurrentClientRole as ULONG
		WPSVersionsSupported as ULONG
		bServiceDiscoverySupported as WINBOOLEAN
		bClientDiscoverabilitySupported as WINBOOLEAN
		bInfrastructureManagementSupported as WINBOOLEAN
		uMaxSecondaryDeviceTypeListSize as ULONG
		DeviceAddress(0 to 5) as UCHAR
		uInterfaceAddressListCount as ULONG
		pInterfaceAddressList as PDOT11_MAC_ADDRESS
		uNumSupportedCountryOrRegionStrings as ULONG
		pSupportedCountryOrRegionStrings as PDOT11_COUNTRY_OR_REGION_STRING
		uDiscoveryFilterListSize as ULONG
		uGORoleClientTableSize as ULONG
	end type

	type DOT11_WFD_ATTRIBUTES as _DOT11_WFD_ATTRIBUTES
	type PDOT11_WFD_ATTRIBUTES as _DOT11_WFD_ATTRIBUTES ptr
	type DOT11_WFD_GROUP_CAPABILITY as UCHAR

	const DOT11_WFD_STATUS_SUCCESS = 0
	const DOT11_WFD_STATUS_FAILED_INFORMATION_IS_UNAVAILABLE = 1
	const DOT11_WFD_STATUS_FAILED_INCOMPATIBLE_PARAMETERS = 2
	const DOT11_WFD_STATUS_FAILED_LIMIT_REACHED = 3
	const DOT11_WFD_STATUS_FAILED_INVALID_PARAMETERS = 4
	const DOT11_WFD_STATUS_FAILED_UNABLE_TO_ACCOMODATE_REQUEST = 5
	const DOT11_WFD_STATUS_FAILED_PREVIOUS_PROTOCOL_ERROR = 6
	const DOT11_WFD_STATUS_FAILED_NO_COMMON_CHANNELS = 7
	const DOT11_WFD_STATUS_FAILED_UNKNOWN_WFD_GROUP = 8
	const DOT11_WFD_STATUS_FAILED_MATCHING_MAX_INTENT = 9
	const DOT11_WFD_STATUS_FAILED_INCOMPATIBLE_PROVISIONING_METHOD = 10
	const DOT11_WFD_STATUS_FAILED_REJECTED_BY_USER = 11
	const DOT11_WFD_MINOR_REASON_SUCCESS = 0
	const DOT11_WFD_MINOR_REASON_DISASSOCIATED_FROM_WLAN_CROSS_CONNECTION_POLICY = 1
	const DOT11_WFD_MINOR_REASON_DISASSOCIATED_NOT_MANAGED_INFRASTRUCTURE_CAPABLE = 2
	const DOT11_WFD_MINOR_REASON_DISASSOCIATED_WFD_COEXISTENCE_POLICY = 3
	const DOT11_WFD_MINOR_REASON_DISASSOCIATED_INFRASTRUCTURE_MANAGED_POLICY = 4
	const DOT11_WPS_VERSION_1_0 = &h01
	const DOT11_WPS_VERSION_2_0 = &h02
	const DOT11_WFD_GROUP_CAPABILITY_NONE = &h00
	const DOT11_WFD_GROUP_CAPABILITY_GROUP_OWNER = &h01
	const DOT11_WFD_GROUP_CAPABILITY_PERSISTENT_GROUP = &h02
	const DOT11_WFD_GROUP_CAPABILITY_GROUP_LIMIT_REACHED = &h04
	const DOT11_WFD_GROUP_CAPABILITY_INTRABSS_DISTRIBUTION_SUPPORTED = &h08
	const DOT11_WFD_GROUP_CAPABILITY_CROSS_CONNECTION_SUPPORTED = &h10
	const DOT11_WFD_GROUP_CAPABILITY_PERSISTENT_RECONNECT_SUPPORTED = &h20
	const DOT11_WFD_GROUP_CAPABILITY_IN_GROUP_FORMATION = &h40
	const DOT11_WFD_GROUP_CAPABILITY_RESERVED_7 = &h80
	const DOT11_WPS_DEVICE_NAME_MAX_LENGTH = 32

	type _DOT11_WFD_DEVICE_TYPE
		CategoryID as USHORT
		SubCategoryID as USHORT
		OUI(0 to 3) as UCHAR
	end type

	type DOT11_WFD_DEVICE_TYPE as _DOT11_WFD_DEVICE_TYPE
	type PDOT11_WFD_DEVICE_TYPE as _DOT11_WFD_DEVICE_TYPE ptr

	type _DOT11_WPS_DEVICE_NAME
		uDeviceNameLength as ULONG
		ucDeviceName(0 to 31) as UCHAR
	end type

	type DOT11_WPS_DEVICE_NAME as _DOT11_WPS_DEVICE_NAME
	type PDOT11_WPS_DEVICE_NAME as _DOT11_WPS_DEVICE_NAME ptr

	type _DOT11_WFD_CONFIGURATION_TIMEOUT
		GOTimeout as UCHAR
		ClientTimeout as UCHAR
	end type

	type DOT11_WFD_CONFIGURATION_TIMEOUT as _DOT11_WFD_CONFIGURATION_TIMEOUT
	type PDOT11_WFD_CONFIGURATION_TIMEOUT as _DOT11_WFD_CONFIGURATION_TIMEOUT ptr

	type _DOT11_WFD_GROUP_ID
		DeviceAddress(0 to 5) as UCHAR
		SSID as DOT11_SSID
	end type

	type DOT11_WFD_GROUP_ID as _DOT11_WFD_GROUP_ID
	type PDOT11_WFD_GROUP_ID as _DOT11_WFD_GROUP_ID ptr

	type _DOT11_WFD_GO_INTENT
		TieBreaker : 1 as UCHAR
		Intent : 7 as UCHAR
	end type

	type DOT11_WFD_GO_INTENT as _DOT11_WFD_GO_INTENT
	type PDOT11_WFD_GO_INTENT as _DOT11_WFD_GO_INTENT ptr

	type _DOT11_WFD_CHANNEL
		CountryRegionString(0 to 2) as UCHAR
		OperatingClass as UCHAR
		ChannelNumber as UCHAR
	end type

	type DOT11_WFD_CHANNEL as _DOT11_WFD_CHANNEL
	type PDOT11_WFD_CHANNEL as _DOT11_WFD_CHANNEL ptr

	type _DOT11_WPS_CONFIG_METHOD as long
	enum
		DOT11_WPS_CONFIG_METHOD_NULL = 0
		DOT11_WPS_CONFIG_METHOD_DISPLAY = &h0008
		DOT11_WPS_CONFIG_METHOD_PUSHBUTTON = &h0080
		DOT11_WPS_CONFIG_METHOD_KEYPAD = &h0100
	end enum

	type DOT11_WPS_CONFIG_METHOD as _DOT11_WPS_CONFIG_METHOD
	type PDOT11_WPS_CONFIG_METHOD as _DOT11_WPS_CONFIG_METHOD ptr

	type _DOT11_WPS_DEVICE_PASSWORD_ID as long
	enum
		DOT11_WPS_PASSWORD_ID_DEFAULT = &h0000
		DOT11_WPS_PASSWORD_ID_USER_SPECIFIED = &h0001
		DOT11_WPS_PASSWORD_ID_MACHINE_SPECIFIED = &h0002
		DOT11_WPS_PASSWORD_ID_REKEY = &h0003
		DOT11_WPS_PASSWORD_ID_PUSHBUTTON = &h0004
		DOT11_WPS_PASSWORD_ID_REGISTRAR_SPECIFIED = &h0005
	end enum

	type DOT11_WPS_DEVICE_PASSWORD_ID as _DOT11_WPS_DEVICE_PASSWORD_ID
	type PDOT11_WPS_DEVICE_PASSWORD_ID as _DOT11_WPS_DEVICE_PASSWORD_ID ptr
	const DOT11_WFD_DISCOVER_COMPLETE_PARAMETERS_REVISION_1 = 1
	const DOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1
	const DOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS_REVISION_1 = 1
	const DOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1
	const DOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS_REVISION_1 = 1
	const DOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1
	#define DOT11_SIZEOF_WFD_DISCOVER_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_WFD_DISCOVER_COMPLETE_PARAMETERS)
	#define DOT11_SIZEOF_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS)
	#define DOT11_SIZEOF_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS)
	#define DOT11_SIZEOF_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS)
	#define DOT11_SIZEOF_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS)
	#define DOT11_SIZEOF_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS)
	const DOT11_WFD_DISCOVER_COMPLETE_MAX_LIST_SIZE = 128

	type _DOT11_WFD_DISCOVER_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		Status as NDIS_STATUS
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		uListOffset as ULONG
		uListLength as ULONG
	end type

	type DOT11_WFD_DISCOVER_COMPLETE_PARAMETERS as _DOT11_WFD_DISCOVER_COMPLETE_PARAMETERS
	type PDOT11_WFD_DISCOVER_COMPLETE_PARAMETERS as _DOT11_WFD_DISCOVER_COMPLETE_PARAMETERS ptr

	type _DOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS as _DOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS
	type PDOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS as _DOT11_GO_NEGOTIATION_REQUEST_SEND_COMPLETE_PARAMETERS ptr

	type _DOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		RequestContext as PVOID
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS as _DOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS
	type PDOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS as _DOT11_RECEIVED_GO_NEGOTIATION_REQUEST_PARAMETERS ptr

	type _DOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS as _DOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS
	type PDOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS as _DOT11_GO_NEGOTIATION_RESPONSE_SEND_COMPLETE_PARAMETERS ptr

	type _DOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		ResponseContext as PVOID
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS as _DOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS
	type PDOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS as _DOT11_RECEIVED_GO_NEGOTIATION_RESPONSE_PARAMETERS ptr

	type _DOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS as _DOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS
	type PDOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS as _DOT11_GO_NEGOTIATION_CONFIRMATION_SEND_COMPLETE_PARAMETERS ptr
	const DOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS_REVISION_1 = 1

	type _DOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS as _DOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS
	type PDOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS as _DOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS ptr
	#define DOT11_SIZEOF_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_GO_NEGOTIATION_CONFIRMATION_PARAMETERS)
	const DOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1

	type _DOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		ReceiverAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS as _DOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS
	type PDOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS as _DOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS ptr
	#define DOT11_SIZEOF_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_INVITATION_REQUEST_SEND_COMPLETE_PARAMETERS)
	const DOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS_REVISION_1 = 1

	type _DOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		TransmitterDeviceAddress(0 to 5) as UCHAR
		BSSID(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		RequestContext as PVOID
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS as _DOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS
	type PDOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS as _DOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS ptr
	#define DOT11_SIZEOF_RECEIVED_INVITATION_REQUEST_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_INVITATION_REQUEST_PARAMETERS)
	const DOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1

	type _DOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ReceiverDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS as _DOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS
	type PDOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS as _DOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS ptr
	#define DOT11_SIZEOF_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_INVITATION_RESPONSE_SEND_COMPLETE_PARAMETERS)
	const DOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS_REVISION_1 = 1

	type _DOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		TransmitterDeviceAddress(0 to 5) as UCHAR
		BSSID(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS as _DOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS
	type PDOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS as _DOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS ptr
	#define DOT11_SIZEOF_RECEIVED_INVITATION_RESPONSE_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_INVITATION_RESPONSE_PARAMETERS)
	const DOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1

	type _DOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		ReceiverAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS as _DOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS
	type PDOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS as _DOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS ptr
	const NWF_WFD_DEVICE_OID = &h05u
	const NWF_WFD_ROLE_OID = &h06u
	const DOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS_REVISION_1 = 1
	const DOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS_REVISION_1 = 1
	const DOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS_REVISION_1 = 1
	const DOT11_WFD_DEVICE_CAPABILITY_CONFIG_REVISION_1 = 1
	const DOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG_REVISION_1 = 1
	const DOT11_WFD_DEVICE_INFO_REVISION_1 = 1
	#define DOT11_WFD_DISCOVER_DEVICE_FILTER_REVISION_1
	#define DOT11_SIZEOF_WFD_DISCOVER_DEVICE_FILTER_REVISION_1
	const DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST_REVISION_1 = 1
	const DOT11_WFD_DISCOVER_REQUEST_REVISION_1 = 1
	const DOT11_WFD_ADDITIONAL_IE_REVISION_1 = 1
	#define DOT11_SIZEOF_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_PROVISION_DISCOVERY_REQUEST_SEND_COMPLETE_PARAMETERS)
	#define DOT11_SIZEOF_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS)
	#define DOT11_SIZEOF_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS_REVISION_1 sizeof(DOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS)
	#define DOT11_SIZEOF_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS_REVISION_1 sizeof(DOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS)
	#define DOT11_SIZEOF_WFD_DEVICE_CAPABILITY_CONFIG_1 sizeof(DOT11_WFD_DEVICE_CAPABILITY_CONFIG)
	#define DOT11_SIZEOF_WFD_GROUP_CAPABILITY_CONFIG_1 sizeof(DOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG)
	#define DOT11_SIZEOF_WFD_DEVICE_INFO_REVISION_1 sizeof(DOT11_WFD_DEVICE_INFO)
	#define DOT11_SIZEOF_WFD_SECONDARY_DEVICE_TYPE_LIST_REVISION_1 FIELD_OFFSET(DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST, SecondaryDeviceTypes)
	#define DOT11_SIZEOF_WFD_DISCOVER_REQUEST_REVISION_1 sizeof(DOT11_WFD_DISCOVER_REQUEST)
	#define OID_DOT11_WFD_DEVICE_CAPABILITY NWF_DEFINE_OID(&h01, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_GROUP_OWNER_CAPABILITY NWF_DEFINE_OID(&h02, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_DEVICE_INFO NWF_DEFINE_OID(&h03, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST NWF_DEFINE_OID(&h04, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_DISCOVER_REQUEST NWF_DEFINE_OID(&h05, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_ENUM_DEVICE_LIST NWF_DEFINE_OID(&h06, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_LISTEN_STATE_DISCOVERABILITY NWF_DEFINE_OID(&h07, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_ADDITIONAL_IE NWF_DEFINE_OID(&h08, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define DOT11_WFD_DEVICE_ENTRY_GET_DEVICE_SIZE(DEV) ((sizeof(DOT11_WFD_DEVICE_ENTRY) + (DEV)->uBeaconIEsLength) + (DEV)->uProbeResponseIEsLength)

	type _DOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		TransmitterDeviceAddress(0 to 5) as UCHAR
		BSSID(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		RequestContext as PVOID
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS as _DOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS
	type PDOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS as _DOT11_RECEIVED_PROVISION_DISCOVERY_REQUEST_PARAMETERS ptr

	type _DOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ReceiverDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		Status as NDIS_STATUS
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS as _DOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS
	type PDOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS as _DOT11_PROVISION_DISCOVERY_RESPONSE_SEND_COMPLETE_PARAMETERS ptr

	type _DOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		TransmitterDeviceAddress(0 to 5) as UCHAR
		BSSID(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS as _DOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS
	type PDOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS as _DOT11_RECEIVED_PROVISION_DISCOVERY_RESPONSE_PARAMETERS ptr

	type _DOT11_WFD_DEVICE_CAPABILITY_CONFIG
		Header as NDIS_OBJECT_HEADER
		bServiceDiscoveryEnabled as WINBOOLEAN
		bClientDiscoverabilityEnabled as WINBOOLEAN
		bConcurrentOperationSupported as WINBOOLEAN
		bInfrastructureManagementEnabled as WINBOOLEAN
		bDeviceLimitReached as WINBOOLEAN
		bInvitationProcedureEnabled as WINBOOLEAN
		WPSVersionsEnabled as ULONG
	end type

	type DOT11_WFD_DEVICE_CAPABILITY_CONFIG as _DOT11_WFD_DEVICE_CAPABILITY_CONFIG
	type PDOT11_WFD_DEVICE_CAPABILITY_CONFIG as _DOT11_WFD_DEVICE_CAPABILITY_CONFIG ptr

	type _DOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG
		Header as NDIS_OBJECT_HEADER
		bPersistentGroupEnabled as WINBOOLEAN
		bIntraBSSDistributionSupported as WINBOOLEAN
		bCrossConnectionSupported as WINBOOLEAN
		bPersistentReconnectSupported as WINBOOLEAN
		bGroupFormationEnabled as WINBOOLEAN
		uMaximumGroupLimit as ULONG
	end type

	type DOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG as _DOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG
	type PDOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG as _DOT11_WFD_GROUP_OWNER_CAPABILITY_CONFIG ptr

	type _DOT11_WFD_DEVICE_INFO
		Header as NDIS_OBJECT_HEADER
		DeviceAddress(0 to 5) as UCHAR
		ConfigMethods as USHORT
		PrimaryDeviceType as DOT11_WFD_DEVICE_TYPE
		DeviceName as DOT11_WPS_DEVICE_NAME
	end type

	type DOT11_WFD_DEVICE_INFO as _DOT11_WFD_DEVICE_INFO
	type PDOT11_WFD_DEVICE_INFO as _DOT11_WFD_DEVICE_INFO ptr

	type _DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST
		Header as NDIS_OBJECT_HEADER
		uNumOfEntries as ULONG
		uTotalNumOfEntries as ULONG
		SecondaryDeviceTypes(0 to 0) as DOT11_WFD_DEVICE_TYPE
	end type

	type DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST as _DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST
	type PDOT11_WFD_SECONDARY_DEVICE_TYPE_LIST as _DOT11_WFD_SECONDARY_DEVICE_TYPE_LIST ptr

	type _DOT11_WFD_DISCOVER_TYPE as long
	enum
		dot11_wfd_discover_type_scan_only = 1
		dot11_wfd_discover_type_find_only = 2
		dot11_wfd_discover_type_auto = 3
		dot11_wfd_discover_type_scan_social_channels = 4
		dot11_wfd_discover_type_forced = &h80000000
	end enum

	type DOT11_WFD_DISCOVER_TYPE as _DOT11_WFD_DISCOVER_TYPE
	type PDOT11_WFD_DISCOVER_TYPE as _DOT11_WFD_DISCOVER_TYPE ptr

	type _DOT11_WFD_SCAN_TYPE as long
	enum
		dot11_wfd_scan_type_active = 1
		dot11_wfd_scan_type_passive = 2
		dot11_wfd_scan_type_auto = 3
	end enum

	type DOT11_WFD_SCAN_TYPE as _DOT11_WFD_SCAN_TYPE
	type PDOT11_WFD_SCAN_TYPE as _DOT11_WFD_SCAN_TYPE ptr
	const DISCOVERY_FILTER_BITMASK_DEVICE = &h1
	const DISCOVERY_FILTER_BITMASK_GO = &h2
	const DISCOVERY_FILTER_BITMASK_ANY = &hf

	type _DOT11_WFD_DISCOVER_DEVICE_FILTER
		DeviceID as zstring * 6
		ucBitmask as UCHAR
		GroupSSID as DOT11_SSID
	end type

	type DOT11_WFD_DISCOVER_DEVICE_FILTER as _DOT11_WFD_DISCOVER_DEVICE_FILTER
	type PDOT11_WFD_DISCOVER_DEVICE_FILTER as _DOT11_WFD_DISCOVER_DEVICE_FILTER ptr

	type _DOT11_WFD_DISCOVER_REQUEST
		Header as NDIS_OBJECT_HEADER
		DiscoverType as DOT11_WFD_DISCOVER_TYPE
		ScanType as DOT11_WFD_SCAN_TYPE
		uDiscoverTimeout as ULONG
		uDeviceFilterListOffset as ULONG
		uNumDeviceFilters as ULONG
		uIEsOffset as ULONG
		uIEsLength as ULONG
		bForceScanLegacyNetworks as WINBOOLEAN
	end type

	type DOT11_WFD_DISCOVER_REQUEST as _DOT11_WFD_DISCOVER_REQUEST
	type PDOT11_WFD_DISCOVER_REQUEST as _DOT11_WFD_DISCOVER_REQUEST ptr
	const DOT11_DEVICE_ENTRY_BYTE_ARRAY_REVISION_1 = 1

	type _DOT11_WFD_DEVICE_ENTRY
		uPhyId as ULONG
		PhySpecificInfo as DOT11_BSS_ENTRY_PHY_SPECIFIC_INFO
		dot11BSSID(0 to 5) as UCHAR
		dot11BSSType as DOT11_BSS_TYPE
		TransmitterAddress(0 to 5) as UCHAR
		lRSSI as LONG
		uLinkQuality as ULONG
		usBeaconPeriod as USHORT
		ullTimestamp as ULONGLONG
		ullBeaconHostTimestamp as ULONGLONG
		ullProbeResponseHostTimestamp as ULONGLONG
		usCapabilityInformation as USHORT
		uBeaconIEsOffset as ULONG
		uBeaconIEsLength as ULONG
		uProbeResponseIEsOffset as ULONG
		uProbeResponseIEsLength as ULONG
	end type

	type DOT11_WFD_DEVICE_ENTRY as _DOT11_WFD_DEVICE_ENTRY
	type PDOT11_WFD_DEVICE_ENTRY as _DOT11_WFD_DEVICE_ENTRY ptr
	const DOT11_WFD_DEVICE_NOT_DISCOVERABLE = 0
	const DOT11_WFD_DEVICE_AUTO_AVAILABILITY = 16
	const DOT11_WFD_DEVICE_HIGH_AVAILABILITY = 24

	type _DOT11_WFD_ADDITIONAL_IE
		Header as NDIS_OBJECT_HEADER
		uBeaconIEsOffset as ULONG
		uBeaconIEsLength as ULONG
		uProbeResponseIEsOffset as ULONG
		uProbeResponseIEsLength as ULONG
		uDefaultRequestIEsOffset as ULONG
		uDefaultRequestIEsLength as ULONG
	end type

	type DOT11_WFD_ADDITIONAL_IE as _DOT11_WFD_ADDITIONAL_IE
	type PDOT11_WFD_ADDITIONAL_IE as _DOT11_WFD_ADDITIONAL_IE ptr
	#define DOT11_SIZEOF_WFD_ADDITIONAL_IE_REVISION_1 sizeof(DOT11_WFD_ADDITIONAL_IE)
	#define DOT11_WFD_ADDITIONAL_IE_GET_HEADER_SIZE(ADDIE) sizeof(DOT11_WFD_ADDITIONAL_IE)
	#define DOT11_WFD_ADDITIONAL_IE_GET_HEADER_END(ADDIE) (cast(PCHAR, (ADDIE)) + sizeof(DOT11_WFD_ADDITIONAL_IE))
	#define DOT11_WFD_ADDITIONAL_IE_GET_BEACON_IE(ADDIE) (cast(PCHAR, (ADDIE)) + (ADDIE)->uBeaconIEsOffset)
	#define DOT11_WFD_ADDITIONAL_IE_SET_BEACON_IE(ADDIE, B) scope : (ADDIE)->uBeaconIEsOffset = cast(DWORD, cast(SIZE_T_, (B)) - cast(SIZE_T_, (ADDIE))) : end scope
	#define DOT11_WFD_ADDITIONAL_IE_GET_BEACON_IE_SIZE(ADDIE) (ADDIE)->uBeaconIEsLength
	#define DOT11_WFD_ADDITIONAL_IE_SET_BEACON_IE_SIZE(ADDIE, SZ) scope : (ADDIE)->uBeaconIEsLength = cast(DWORD, (SZ)) : end scope
	#define DOT11_WFD_ADDITIONAL_IE_GET_BEACON_IE_END(ADDIE) ((cast(PCHAR, (ADDIE)) + (ADDIE)->uBeaconIEsOffset) + DOT11_WFD_ADDITIONAL_IE_GET_BEACON_IE_SIZE(ADDIE))
	#define DOT11_WFD_ADDITIONAL_IE_GET_PROBE_RESPONSE_IE(ADDIE) (cast(PCHAR, (ADDIE)) + (ADDIE)->uProbeResponseIEsOffset)
	#define DOT11_WFD_ADDITIONAL_IE_SET_PROBE_RESPONSE_IE(ADDIE, _response_) scope : (ADDIE)->uProbeResponseIEsOffset = cast(DWORD, cast(SIZE_T_, (_response_)) - cast(SIZE_T_, (ADDIE))) : end scope
	#define DOT11_WFD_ADDITIONAL_IE_GET_PROBE_RESPONSE_IE_SIZE(ADDIE) (ADDIE)->uProbeResponseIEsLength
	#define DOT11_WFD_ADDITIONAL_IE_SET_PROBE_RESPONSE_IE_SIZE(ADDIE, SZ) scope : (ADDIE)->uProbeResponseIEsLength = cast(DWORD, (SZ)) : end scope
	#define DOT11_WFD_ADDITIONAL_IE_GET_PROBE_RESPONSE_IE_END(ADDIE) ((cast(PCHAR, (ADDIE)) + (ADDIE)->uProbeResponseIEsOffset) + DOT11_WFD_ADDITIONAL_IE_GET_PROBE_RESPONSE_IE_SIZE(ADDIE))
	#define DOT11_WFD_ADDITIONAL_IE_GET_PROBE_REQUEST_IE(ADDIE) (cast(PCHAR, (ADDIE)) + (ADDIE)->uDefaultRequestIEsOffset)
	#define DOT11_WFD_ADDITIONAL_IE_SET_PROBE_REQUEST_IE(ADDIE, REQ) scope : (ADDIE)->uDefaultRequestIEsOffset = cast(DWORD, cast(SIZE_T_, (REQ)) - cast(SIZE_T_, (ADDIE))) : end scope
	#define DOT11_WFD_ADDITIONAL_IE_GET_PROBE_REQUEST_IE_SIZE(ADDIE) (ADDIE)->uDefaultRequestIEsLength
	#define DOT11_WFD_ADDITIONAL_IE_SET_PROBE_REQUEST_IE_SIZE(ADDIE, SZ) scope : (ADDIE)->uDefaultRequestIEsLength = cast(DWORD, (SZ)) : end scope
	#define DOT11_WFD_ADDITIONAL_IE_GET_ALL_IE_SIZE(ADDIE) (((ADDIE)->uBeaconIEsLength + (ADDIE)->uProbeResponseIEsLength) + (ADDIE)->uDefaultRequestIEsLength)
	#define DOT11_WFD_ADDITIONAL_IE_GET_TOTAL_SIZE(ADDIE) (DOT11_WFD_ADDITIONAL_IE_GET_HEADER_SIZE(ADDIE) + DOT11_WFD_ADDITIONAL_IE_GET_ALL_IE_SIZE(ADDIE))
	#define OID_DOT11_WFD_FLUSH_DEVICE_LIST NWF_DEFINE_OID(&h09, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_SEND_GO_NEGOTIATION_REQUEST NWF_DEFINE_OID(&h0a, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	const DOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS_REVISION_1 = 1

	type _DOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		uSendTimeout as ULONG
		GroupOwnerIntent as DOT11_WFD_GO_INTENT
		MinimumConfigTimeout as DOT11_WFD_CONFIGURATION_TIMEOUT
		IntendedInterfaceAddress(0 to 5) as UCHAR
		GroupCapability as DOT11_WFD_GROUP_CAPABILITY
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS as _DOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS
	type PDOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS as _DOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS ptr
	#define DOT11_SIZEOF_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_GO_NEGOTIATION_REQUEST_PARAMETERS)
	#define OID_DOT11_WFD_SEND_GO_NEGOTIATION_RESPONSE NWF_DEFINE_OID(&h0b, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	const DOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS_REVISION_1 = 1

	type _DOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		RequestContext as PVOID
		uSendTimeout as ULONG
		Status as DOT11_WFD_STATUS_CODE
		GroupOwnerIntent as DOT11_WFD_GO_INTENT
		MinimumConfigTimeout as DOT11_WFD_CONFIGURATION_TIMEOUT
		IntendedInterfaceAddress(0 to 5) as UCHAR
		GroupCapability as DOT11_WFD_GROUP_CAPABILITY
		GroupID as DOT11_WFD_GROUP_ID
		bUseGroupID as WINBOOLEAN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS as _DOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS
	type PDOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS as _DOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS ptr
	#define DOT11_SIZEOF_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_GO_NEGOTIATION_RESPONSE_PARAMETERS)
	#define OID_DOT11_WFD_SEND_GO_NEGOTIATION_CONFIRMATION NWF_DEFINE_OID(&h0c, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	const DOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS_REVISION_1 = 1

	type _DOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		PeerDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		ResponseContext as PVOID
		uSendTimeout as ULONG
		Status as DOT11_WFD_STATUS_CODE
		GroupCapability as DOT11_WFD_GROUP_CAPABILITY
		GroupID as DOT11_WFD_GROUP_ID
		bUseGroupID as WINBOOLEAN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS as _DOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS
	type PDOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS as _DOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS ptr
	#define DOT11_SIZEOF_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_GO_NEGOTIATION_CONFIRMATION_PARAMETERS)
	#define OID_DOT11_WFD_SEND_INVITATION_REQUEST NWF_DEFINE_OID(&h0d, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)

	type _DOT11_WFD_INVITATION_FLAGS
		InvitationType : 1 as UCHAR
		Reserved : 7 as UCHAR
	end type

	type DOT11_WFD_INVITATION_FLAGS as _DOT11_WFD_INVITATION_FLAGS
	type PDOT11_WFD_INVITATION_FLAGS as _DOT11_WFD_INVITATION_FLAGS ptr

	type _DOT11_SEND_INVITATION_REQUEST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		DialogToken as DOT11_DIALOG_TOKEN
		PeerDeviceAddress(0 to 5) as UCHAR
		uSendTimeout as ULONG
		MinimumConfigTimeout as DOT11_WFD_CONFIGURATION_TIMEOUT
		InvitationFlags as DOT11_WFD_INVITATION_FLAGS
		GroupBSSID(0 to 5) as UCHAR
		bUseGroupBSSID as WINBOOLEAN
		OperatingChannel as DOT11_WFD_CHANNEL
		bUseSpecifiedOperatingChannel as WINBOOLEAN
		GroupID as DOT11_WFD_GROUP_ID
		bLocalGO as WINBOOLEAN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_INVITATION_REQUEST_PARAMETERS as _DOT11_SEND_INVITATION_REQUEST_PARAMETERS
	type PDOT11_SEND_INVITATION_REQUEST_PARAMETERS as _DOT11_SEND_INVITATION_REQUEST_PARAMETERS ptr

	type _DOT11_SEND_INVITATION_RESPONSE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ReceiverDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		RequestContext as PVOID
		uSendTimeout as ULONG
		Status as DOT11_WFD_STATUS_CODE
		MinimumConfigTimeout as DOT11_WFD_CONFIGURATION_TIMEOUT
		GroupBSSID(0 to 5) as UCHAR
		bUseGroupBSSID as WINBOOLEAN
		OperatingChannel as DOT11_WFD_CHANNEL
		bUseSpecifiedOperatingChannel as WINBOOLEAN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_INVITATION_RESPONSE_PARAMETERS as _DOT11_SEND_INVITATION_RESPONSE_PARAMETERS
	type PDOT11_SEND_INVITATION_RESPONSE_PARAMETERS as _DOT11_SEND_INVITATION_RESPONSE_PARAMETERS ptr
	#define DOT11_SIZEOF_SEND_INVITATION_REQUEST_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_INVITATION_REQUEST_PARAMETERS)
	#define DOT11_SIZEOF_SEND_INVITATION_RESPONSE_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_INVITATION_RESPONSE_PARAMETERS)
	#define OID_DOT11_WFD_SEND_INVITATION_RESPONSE NWF_DEFINE_OID(&h0e, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_SEND_PROVISION_DISCOVERY_REQUEST NWF_DEFINE_OID(&h0f, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	const DOT11_SEND_INVITATION_REQUEST_PARAMETERS_REVISION_1 = 1
	const DOT11_SEND_INVITATION_RESPONSE_PARAMETERS_REVISION_1 = 1
	const DOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS_REVISION_1 = 1

	type _DOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		DialogToken as DOT11_DIALOG_TOKEN
		PeerDeviceAddress(0 to 5) as UCHAR
		uSendTimeout as ULONG
		GroupCapability as DOT11_WFD_GROUP_CAPABILITY
		GroupID as DOT11_WFD_GROUP_ID
		bUseGroupID as WINBOOLEAN
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS as _DOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS
	type PDOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS as _DOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS ptr

	type _DOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		ReceiverDeviceAddress(0 to 5) as UCHAR
		DialogToken as DOT11_DIALOG_TOKEN
		RequestContext as PVOID
		uSendTimeout as ULONG
		uIEsOffset as ULONG
		uIEsLength as ULONG
	end type

	type DOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS as _DOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS
	type PDOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS as _DOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS ptr

	type _DOT11_WFD_DEVICE_LISTEN_CHANNEL
		Header as NDIS_OBJECT_HEADER
		ChannelNumber as UCHAR
	end type

	type DOT11_WFD_DEVICE_LISTEN_CHANNEL as _DOT11_WFD_DEVICE_LISTEN_CHANNEL
	type PDOT11_WFD_DEVICE_LISTEN_CHANNEL as _DOT11_WFD_DEVICE_LISTEN_CHANNEL ptr

	type _DOT11_WFD_GROUP_START_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		AdvertisedOperatingChannel as DOT11_WFD_CHANNEL
	end type

	type DOT11_WFD_GROUP_START_PARAMETERS as _DOT11_WFD_GROUP_START_PARAMETERS
	type PDOT11_WFD_GROUP_START_PARAMETERS as _DOT11_WFD_GROUP_START_PARAMETERS ptr

	type _DOT11_WFD_GROUP_JOIN_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		GOOperatingChannel as DOT11_WFD_CHANNEL
		GOConfigTime as ULONG
		bInGroupFormation as WINBOOLEAN
		bWaitForWPSReady as WINBOOLEAN
	end type

	type DOT11_WFD_GROUP_JOIN_PARAMETERS as _DOT11_WFD_GROUP_JOIN_PARAMETERS
	type PDOT11_WFD_GROUP_JOIN_PARAMETERS as _DOT11_WFD_GROUP_JOIN_PARAMETERS ptr
	#define OID_DOT11_WFD_SEND_PROVISION_DISCOVERY_RESPONSE NWF_DEFINE_OID(&h10, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_GET_DIALOG_TOKEN NWF_DEFINE_OID(&h11, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_STOP_DISCOVERY NWF_DEFINE_OID(&h12, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_DEVICE_LISTEN_CHANNEL NWF_DEFINE_OID(&h13, NWF_WFD_DEVICE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_DESIRED_GROUP_ID NWF_DEFINE_OID(&h01, NWF_WFD_ROLE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_START_GO_REQUEST NWF_DEFINE_OID(&h02, NWF_WFD_ROLE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_GROUP_START_PARAMETERS NWF_DEFINE_OID(&h03, NWF_WFD_ROLE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_CONNECT_TO_GROUP_REQUEST NWF_DEFINE_OID(&h04, NWF_WFD_ROLE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_DISCONNECT_FROM_GROUP_REQUEST NWF_DEFINE_OID(&h05, NWF_WFD_ROLE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_WFD_GROUP_JOIN_PARAMETERS NWF_DEFINE_OID(&h06, NWF_WFD_ROLE_OID, NWF_MANDATORY_OID)
	const DOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS_REVISION_1 = 1
	const DOT11_WFD_DEVICE_LISTEN_CHANNEL_REVISION_1 = 1
	const DOT11_WFD_GROUP_JOIN_PARAMETERS_REVISION_1 = 1
	const DOT11_WFD_GROUP_START_PARAMETERS_REVISION_1 = 1
	#define DOT11_SIZEOF_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_PROVISION_DISCOVERY_REQUEST_PARAMETERS)
	#define DOT11_SIZEOF_WFD_DEVICE_LISTEN_CHANNEL_REVISION_1 sizeof(DOT11_WFD_DEVICE_LISTEN_CHANNEL)
	#define DOT11_SIZEOF_WFD_GROUP_START_PARAMETERS_REVISION_1 sizeof(DOT11_WFD_GROUP_START_PARAMETERS)
	#define DOT11_SIZEOF_WFD_GROUP_JOIN_PARAMETERS_REVISION_1 sizeof(DOT11_WFD_GROUP_JOIN_PARAMETERS)
	#define DOT11_SIZEOF_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS_REVISION_1 sizeof(DOT11_SEND_PROVISION_DISCOVERY_RESPONSE_PARAMETERS)
	const NWF_POWER_SAVE_OID = &h07u
	#define OID_DOT11_POWER_MGMT_MODE_AUTO_ENABLED NWF_DEFINE_OID(&h01, NWF_POWER_SAVE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_POWER_MGMT_MODE_STATUS NWF_DEFINE_OID(&h02, NWF_POWER_SAVE_OID, NWF_MANDATORY_OID)
	#define OID_DOT11_OFFLOAD_NETWORK_LIST NWF_DEFINE_OID(&h03, NWF_POWER_SAVE_OID, NWF_MANDATORY_OID)
	const DOT11_MAX_CHANNEL_HINTS = 4
	const DOT11_INVALID_CHANNEL_NUMBER = 0
	const DOT11_NLO_FLAG_STOP_NLO_INDICATION = &h00000001
	const DOT11_NLO_FLAG_SCAN_ON_AOAC_PLATFORM = &h00000002
	const DOT11_NLO_FLAG_SCAN_AT_SYSTEM_RESUME = &h00000004
	const DOT11_POWER_MGMT_AUTO_MODE_ENABLED_REVISION_1 = 1
	const DOT11_OFFLOAD_NETWORK_LIST_REVISION_1 = 1
	const DOT11_POWER_MGMT_MODE_STATUS_INFO_REVISION_1 = 1
	#define DOT11_SIZEOF_OFFLOAD_NETWORK_LIST_INFO_REVISION_1(UNOE) (FIELD_OFFSET(DOT11_OFFLOAD_NETWORK_LIST_INFO, offloadNetworkList) + (sizeof(DOT11_OFFLOAD_NETWORK) * (UNOE)))
	#define DOT11_MIN_SIZEOF_OFFLOAD_NETWORK_LIST_INFO_REVISION_1 FIELD_OFFSET(DOT11_OFFLOAD_NETWORK_LIST_INFO, offloadNetworkList)
	#define DOT11_SIZEOF_POWER_MGMT_AUTO_MODE_ENABLE_INFO_REVISION_1 sizeof(DOT11_POWER_MGMT_AUTO_MODE_ENABLED_INFO)
	#define DOT11_SIZEOF_POWER_MGMT_MODE_STATUS_INFO_REVISION_1 sizeof(DOT11_POWER_MGMT_MODE_STATUS_INFO)

	type _DOT11_POWER_MGMT_AUTO_MODE_ENABLED_INFO
		Header as NDIS_OBJECT_HEADER
		bEnabled as WINBOOLEAN
	end type

	type DOT11_POWER_MGMT_AUTO_MODE_ENABLED_INFO as _DOT11_POWER_MGMT_AUTO_MODE_ENABLED_INFO
	type PDOT11_POWER_MGMT_AUTO_MODE_ENABLED_INFO as _DOT11_POWER_MGMT_AUTO_MODE_ENABLED_INFO ptr

	type _DOT11_POWER_MODE_REASON as long
	enum
		dot11_power_mode_reason_no_change = 0
		dot11_power_mode_reason_noncompliant_AP = 1
		dot11_power_mode_reason_legacy_WFD_device = 2
		dot11_power_mode_reason_compliant_AP = 3
		dot11_power_mode_reason_compliant_WFD_device = 4
		dot11_power_mode_reason_others = 5
	end enum

	type DOT11_POWER_MODE_REASON as _DOT11_POWER_MODE_REASON

	type _DOT11_POWER_MGMT_MODE_STATUS_INFO
		Header as NDIS_OBJECT_HEADER
		PowerSaveMode as DOT11_POWER_MODE
		uPowerSaveLevel as ULONG
		Reason as DOT11_POWER_MODE_REASON
	end type

	type DOT11_POWER_MGMT_MODE_STATUS_INFO as _DOT11_POWER_MGMT_MODE_STATUS_INFO
	type PDOT11_POWER_MGMT_MODE_STATUSINFO as _DOT11_POWER_MGMT_MODE_STATUS_INFO ptr

	type DOT11_CHANNEL_HINT
		Dot11PhyType as DOT11_PHY_TYPE
		uChannelNumber as ULONG
	end type

	type PDOT11_CHANNEL_HINT as DOT11_CHANNEL_HINT ptr

	type DOT11_OFFLOAD_NETWORK
		Ssid as DOT11_SSID
		UnicastCipher as DOT11_CIPHER_ALGORITHM
		AuthAlgo as DOT11_AUTH_ALGORITHM
		Dot11ChannelHints(0 to 3) as DOT11_CHANNEL_HINT
	end type

	type PDOT11_OFFLOAD_NETWORK as DOT11_OFFLOAD_NETWORK ptr

	type _DOT11_OFFLOAD_NETWORK_LIST_INFO
		Header as NDIS_OBJECT_HEADER
		ulFlags as ULONG
		FastScanPeriod as ULONG
		FastScanIterations as ULONG
		SlowScanPeriod as ULONG
		uNumOfEntries as ULONG
		offloadNetworkList(0 to 0) as DOT11_OFFLOAD_NETWORK
	end type

	type DOT11_OFFLOAD_NETWORK_LIST_INFO as _DOT11_OFFLOAD_NETWORK_LIST_INFO
	type PDOT11_OFFLOAD_NETWORK_LIST_INFO as _DOT11_OFFLOAD_NETWORK_LIST_INFO ptr
#endif

#if _WIN32_WINNT >= &h0600
	type _DOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		Status as NDIS_STATUS
	end type

	type DOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS as _DOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS
	type PDOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS as _DOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS ptr
	const NWF_MANUFACTURING_OID = &h08u
	#define DOT11_SIZEOF_OFFLOAD_NETWORK_STATUS_PARAMETERS_REVISION_1 sizeof(DOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS)
	const DOT11_MANUFACTURING_TEST_REVISION_1 = 1
	const DOT11_MANUFACTURING_CALLBACK_REVISION_1 = 1
	const DOT11_OFFLOAD_NETWORK_STATUS_PARAMETERS_REVISION_1 = 1
	#define OID_DOT11_MANUFACTURING_TEST NWF_DEFINE_OID(&h01, NWF_MANUFACTURING_OID, NWF_OPTIONAL_OID)

	type _DOT11_MANUFACTURING_TEST_TYPE as long
	enum
		dot11_manufacturing_test_unknown = 0
		dot11_manufacturing_test_self_start = 1
		dot11_manufacturing_test_self_query_result = 2
		dot11_manufacturing_test_rx = 3
		dot11_manufacturing_test_tx = 4
		dot11_manufacturing_test_query_adc = 5
		dot11_manufacturing_test_set_data = 6
		dot11_manufacturing_test_query_data = 7
		dot11_manufacturing_test_sleep = 8
		dot11_manufacturing_test_awake = 9
		dot11_manufacturing_test_IHV_start = &h80000000
		dot11_manufacturing_test_IHV_end = &hffffffff
	end enum

	type DOT11_MANUFACTURING_TEST_TYPE as _DOT11_MANUFACTURING_TEST_TYPE
	type PDOT11_MANUFACTURING_TEST_TYPE as _DOT11_MANUFACTURING_TEST_TYPE ptr

	type _DOT11_MANUFACTURING_TEST
		dot11ManufacturingTestType as DOT11_MANUFACTURING_TEST_TYPE
		uBufferLength as ULONG
		ucBuffer(0 to 0) as UCHAR
	end type

	type DOT11_MANUFACTURING_TEST as _DOT11_MANUFACTURING_TEST
	type PDOT11_MANUFACTURING_TEST as _DOT11_MANUFACTURING_TEST ptr

	type DOT11_MANUFACTURING_SELF_TEST_TYPE as long
	enum
		DOT11_MANUFACTURING_SELF_TEST_TYPE_INTERFACE = 1
		DOT11_MANUFACTURING_SELF_TEST_TYPE_RF_INTERFACE
		DOT11_MANUFACTURING_SELF_TEST_TYPE_BT_COEXISTENCE
	end enum

	type PDOT11_MANUFACTURING_SELF_TEST_TYPE as DOT11_MANUFACTURING_SELF_TEST_TYPE ptr

	type _DOT11_MANUFACTURING_SELF_TEST_SET_PARAMS
		SelfTestType as DOT11_MANUFACTURING_SELF_TEST_TYPE
		uTestID as ULONG
		uPinBitMask as ULONG
		pvContext as PVOID
		uBufferLength as ULONG
		ucBufferIn(0 to 0) as UCHAR
	end type

	type DOT11_MANUFACTURING_SELF_TEST_SET_PARAMS as _DOT11_MANUFACTURING_SELF_TEST_SET_PARAMS
	type PDOT11_MANUFACTURING_SELF_TEST_SET_PARAMS as _DOT11_MANUFACTURING_SELF_TEST_SET_PARAMS ptr

	type _DOT11_MANUFACTURING_SELF_TEST_QUERY_RESULTS
		SelfTestType as DOT11_MANUFACTURING_SELF_TEST_TYPE
		uTestID as ULONG
		bResult as WINBOOLEAN
		uPinFailedBitMask as ULONG
		pvContext as PVOID
		uBytesWrittenOut as ULONG
		ucBufferOut(0 to 0) as UCHAR
	end type

	type DOT11_MANUFACTURING_SELF_TEST_QUERY_RESULTS as _DOT11_MANUFACTURING_SELF_TEST_QUERY_RESULTS
	type PDOT11_MANUFACTURING_SELF_TEST_QUERY_RESULTS as _DOT11_MANUFACTURING_SELF_TEST_QUERY_RESULTS ptr

	type DOT11_BAND as long
	enum
		dot11_band_2p4g = 1
		dot11_band_4p9g
		dot11_band_5g
	end enum

	type PDOT11_BAND as DOT11_BAND ptr

	type _DOT11_MANUFACTURING_FUNCTIONAL_TEST_RX
		bEnabled as WINBOOLEAN
		Dot11Band as DOT11_BAND
		uChannel as ULONG
		PowerLevel as LONG
	end type

	type DOT11_MANUFACTURING_FUNCTIONAL_TEST_RX as _DOT11_MANUFACTURING_FUNCTIONAL_TEST_RX
	type PDOT11_MANUFACTURING_FUNCTIONAL_TEST_RX as _DOT11_MANUFACTURING_FUNCTIONAL_TEST_RX ptr

	type _DOT11_MANUFACTURING_FUNCTIONAL_TEST_TX
		bEnable as WINBOOLEAN
		bOpenLoop as WINBOOLEAN
		Dot11Band as DOT11_BAND
		uChannel as ULONG
		uSetPowerLevel as ULONG
		ADCPowerLevel as LONG
	end type

	type DOT11_MANUFACTURING_FUNCTIONAL_TEST_TX as _DOT11_MANUFACTURING_FUNCTIONAL_TEST_TX
	type PDOT11_MANUFACTURING_FUNCTIONAL_TEST_TX as _DOT11_MANUFACTURING_FUNCTIONAL_TEST_TX ptr

	type _DOT11_MANUFACTURING_FUNCTIONAL_TEST_QUERY_ADC
		Dot11Band as DOT11_BAND
		uChannel as ULONG
		ADCPowerLevel as LONG
	end type

	type DOT11_MANUFACTURING_FUNCTIONAL_TEST_QUERY_ADC as _DOT11_MANUFACTURING_FUNCTIONAL_TEST_QUERY_ADC
	type PDOT11_MANUFACTURING_FUNCTIONAL_TEST_QUERY_ADC as _DOT11_MANUFACTURING_FUNCTIONAL_TEST_QUERY_ADC ptr

	type _DOT11_MANUFACTURING_TEST_SET_DATA
		uKey as ULONG
		uOffset as ULONG
		uBufferLength as ULONG
		ucBufferIn(0 to 0) as UCHAR
	end type

	type DOT11_MANUFACTURING_TEST_SET_DATA as _DOT11_MANUFACTURING_TEST_SET_DATA
	type PDOT11_MANUFACTURING_TEST_SET_DATA as _DOT11_MANUFACTURING_TEST_SET_DATA ptr

	type _DOT11_MANUFACTURING_TEST_QUERY_DATA
		uKey as ULONG
		uOffset as ULONG
		uBufferLength as ULONG
		uBytesRead as ULONG
		ucBufferOut(0 to 0) as UCHAR
	end type

	type DOT11_MANUFACTURING_TEST_QUERY_DATA as _DOT11_MANUFACTURING_TEST_QUERY_DATA
	type PDOT11_MANUFACTURING_TEST_QUERY_DATA as _DOT11_MANUFACTURING_TEST_QUERY_DATA ptr

	type _DOT11_MANUFACTURING_TEST_SLEEP
		uSleepTime as ULONG
		pvContext as PVOID
	end type

	type DOT11_MANUFACTURING_TEST_SLEEP as _DOT11_MANUFACTURING_TEST_SLEEP
	type PDOT11_MANUFACTURING_TEST_SLEEP as _DOT11_MANUFACTURING_TEST_SLEEP ptr

	type _DOT11_MANUFACTURING_CALLBACK_TYPE as long
	enum
		dot11_manufacturing_callback_unknown = 0
		dot11_manufacturing_callback_self_test_complete = 1
		dot11_manufacturing_callback_sleep_complete = 2
		dot11_manufacturing_callback_IHV_start = &h80000000
		dot11_manufacturing_callback_IHV_end = &hffffffff
	end enum

	type DOT11_MANUFACTURING_CALLBACK_TYPE as _DOT11_MANUFACTURING_CALLBACK_TYPE
	type PDOT11_MANUFACTURING_CALLBACK_TYPE as _DOT11_MANUFACTURING_CALLBACK_TYPE ptr

	type DOT11_MANUFACTURING_CALLBACK_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		dot11ManufacturingCallbackType as DOT11_MANUFACTURING_CALLBACK_TYPE
		uStatus as ULONG
		pvContext as PVOID
	end type

	type PDOT11_MANUFACTURING_CALLBACK_PARAMETERS as DOT11_MANUFACTURING_CALLBACK_PARAMETERS ptr

	end extern
#endif
