/**
 * Copyright (c) 2014-2024 The xterm.js authors. All rights reserved.
 * @license MIT
 *
 * Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)
 * @license MIT
 *
 * Originally forked from (with the author's permission):
 *   Fabrice Bellard's javascript vt100 for jslinux:
 *   http://bellard.org/jslinux/
 *   Copyright (c) 2011 Fabrice Bellard
 */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var Ce=class{constructor(){this.listeners=[],this.unexpectedErrorHandler=function(e){setTimeout(()=>{throw e.stack?ae.isErrorNoTelemetry(e)?new ae(e.message+`

`+e.stack):new Error(e.message+`

`+e.stack):e},0)}}addListener(e){return this.listeners.push(e),()=>{this._removeListener(e)}}emit(e){this.listeners.forEach(t=>{t(e)})}_removeListener(e){this.listeners.splice(this.listeners.indexOf(e),1)}setUnexpectedErrorHandler(e){this.unexpectedErrorHandler=e}getUnexpectedErrorHandler(){return this.unexpectedErrorHandler}onUnexpectedError(e){this.unexpectedErrorHandler(e),this.emit(e)}onUnexpectedExternalError(e){this.unexpectedErrorHandler(e)}},pt=new Ce;function le(r){ft(r)||pt.onUnexpectedError(r)}var Re="Canceled";function ft(r){return r instanceof ee?!0:r instanceof Error&&r.name===Re&&r.message===Re}var ee=class extends Error{constructor(){super(Re),this.name=this.message}};var ae=class r extends Error{constructor(e){super(e),this.name="CodeExpectedError"}static fromError(e){if(e instanceof r)return e;let t=new r;return t.message=e.message,t.stack=e.stack,t}static isErrorNoTelemetry(e){return e.name==="CodeExpectedError"}};function Pe(r,e){let t=this,n=!1,i;return function(){if(n)return i;if(n=!0,e)try{i=r.apply(t,arguments)}finally{e()}else i=r.apply(t,arguments);return i}}function mt(r,e,t=0,n=r.length){let i=t,s=n;for(;i<s;){let a=Math.floor((i+s)/2);e(r[a])?i=a+1:s=a}return i-1}var ue=class ue{constructor(e){this._array=e;this._findLastMonotonousLastIdx=0}findLastMonotonous(e){if(ue.assertInvariants){if(this._prevFindLastPredicate){for(let n of this._array)if(this._prevFindLastPredicate(n)&&!e(n))throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.")}this._prevFindLastPredicate=e}let t=mt(this._array,e,this._findLastMonotonousLastIdx);return this._findLastMonotonousLastIdx=t+1,t===-1?void 0:this._array[t]}};ue.assertInvariants=!1;var Ke=ue;var Qe;(h=>{function r(u){return u<0}h.isLessThan=r;function e(u){return u<=0}h.isLessThanOrEqual=e;function t(u){return u>0}h.isGreaterThan=t;function n(u){return u===0}h.isNeitherLessOrGreaterThan=n,h.greaterThan=1,h.lessThan=-1,h.neitherLessOrGreaterThan=0})(Qe||={});function $e(r,e){return(t,n)=>e(r(t),r(n))}var Be=(r,e)=>r-e;var V=class V{constructor(e){this.iterate=e}forEach(e){this.iterate(t=>(e(t),!0))}toArray(){let e=[];return this.iterate(t=>(e.push(t),!0)),e}filter(e){return new V(t=>this.iterate(n=>e(n)?t(n):!0))}map(e){return new V(t=>this.iterate(n=>t(e(n))))}some(e){let t=!1;return this.iterate(n=>(t=e(n),!t)),t}findFirst(e){let t;return this.iterate(n=>e(n)?(t=n,!1):!0),t}findLast(e){let t;return this.iterate(n=>(e(n)&&(t=n),!0)),t}findLastMaxBy(e){let t,n=!0;return this.iterate(i=>((n||Qe.isGreaterThan(e(i,t)))&&(n=!1,t=i),!0)),t}};V.empty=new V(e=>{});var He=V;function Xe(r,e){let t=Object.create(null);for(let n of r){let i=e(n),s=t[i];s||(s=t[i]=[]),s.push(n)}return t}var Ye,Je,Ge=class{constructor(e,t){this.toKey=t;this._map=new Map;this[Ye]="SetWithKey";for(let n of e)this.add(n)}get size(){return this._map.size}add(e){let t=this.toKey(e);return this._map.set(t,e),this}delete(e){return this._map.delete(this.toKey(e))}has(e){return this._map.has(this.toKey(e))}*entries(){for(let e of this._map.values())yield[e,e]}keys(){return this.values()}*values(){for(let e of this._map.values())yield e}clear(){this._map.clear()}forEach(e,t){this._map.forEach(n=>e.call(t,n,n,this))}[(Je=Symbol.iterator,Ye=Symbol.toStringTag,Je)](){return this.values()}};var ce=class{constructor(){this.map=new Map}add(e,t){let n=this.map.get(e);n||(n=new Set,this.map.set(e,n)),n.add(t)}delete(e,t){let n=this.map.get(e);n&&(n.delete(t),n.size===0&&this.map.delete(e))}forEach(e,t){let n=this.map.get(e);n&&n.forEach(t)}get(e){let t=this.map.get(e);return t||new Set}};var Le;(z=>{function r(m){return m&&typeof m=="object"&&typeof m[Symbol.iterator]=="function"}z.is=r;let e=Object.freeze([]);function t(){return e}z.empty=t;function*n(m){yield m}z.single=n;function i(m){return r(m)?m:n(m)}z.wrap=i;function s(m){return m||e}z.from=s;function*a(m){for(let _=m.length-1;_>=0;_--)yield m[_]}z.reverse=a;function h(m){return!m||m[Symbol.iterator]().next().done===!0}z.isEmpty=h;function u(m){return m[Symbol.iterator]().next().value}z.first=u;function p(m,_){let y=0;for(let L of m)if(_(L,y++))return!0;return!1}z.some=p;function T(m,_){for(let y of m)if(_(y))return y}z.find=T;function*v(m,_){for(let y of m)_(y)&&(yield y)}z.filter=v;function*I(m,_){let y=0;for(let L of m)yield _(L,y++)}z.map=I;function*E(m,_){let y=0;for(let L of m)yield*_(L,y++)}z.flatMap=E;function*C(...m){for(let _ of m)yield*_}z.concat=C;function D(m,_,y){let L=y;for(let X of m)L=_(L,X);return L}z.reduce=D;function*x(m,_,y=m.length){for(_<0&&(_+=m.length),y<0?y+=m.length:y>m.length&&(y=m.length);_<y;_++)yield m[_]}z.slice=x;function J(m,_=Number.POSITIVE_INFINITY){let y=[];if(_===0)return[y,m];let L=m[Symbol.iterator]();for(let X=0;X<_;X++){let Se=L.next();if(Se.done)return[y,z.empty()];y.push(Se.value)}return[y,{[Symbol.iterator](){return L}}]}z.consume=J;async function q(m){let _=[];for await(let y of m)_.push(y);return Promise.resolve(_)}z.asyncToArray=q})(Le||={});var Tt=!1,K=null,de=class de{constructor(){this.livingDisposables=new Map}getDisposableData(e){let t=this.livingDisposables.get(e);return t||(t={parent:null,source:null,isSingleton:!1,value:e,idx:de.idx++},this.livingDisposables.set(e,t)),t}trackDisposable(e){let t=this.getDisposableData(e);t.source||(t.source=new Error().stack)}setParent(e,t){let n=this.getDisposableData(e);n.parent=t}markAsDisposed(e){this.livingDisposables.delete(e)}markAsSingleton(e){this.getDisposableData(e).isSingleton=!0}getRootParent(e,t){let n=t.get(e);if(n)return n;let i=e.parent?this.getRootParent(this.getDisposableData(e.parent),t):e;return t.set(e,i),i}getTrackedDisposables(){let e=new Map;return[...this.livingDisposables.entries()].filter(([,n])=>n.source!==null&&!this.getRootParent(n,e).isSingleton).flatMap(([n])=>n)}computeLeakingDisposables(e=10,t){let n;if(t)n=t;else{let u=new Map,p=[...this.livingDisposables.values()].filter(v=>v.source!==null&&!this.getRootParent(v,u).isSingleton);if(p.length===0)return;let T=new Set(p.map(v=>v.value));if(n=p.filter(v=>!(v.parent&&T.has(v.parent))),n.length===0)throw new Error("There are cyclic diposable chains!")}if(!n)return;function i(u){function p(v,I){for(;v.length>0&&I.some(E=>typeof E=="string"?E===v[0]:v[0].match(E));)v.shift()}let T=u.source.split(`
`).map(v=>v.trim().replace("at ","")).filter(v=>v!=="");return p(T,["Error",/^trackDisposable \(.*\)$/,/^DisposableTracker.trackDisposable \(.*\)$/]),T.reverse()}let s=new ce;for(let u of n){let p=i(u);for(let T=0;T<=p.length;T++)s.add(p.slice(0,T).join(`
`),u)}n.sort($e(u=>u.idx,Be));let a="",h=0;for(let u of n.slice(0,e)){h++;let p=i(u),T=[];for(let v=0;v<p.length;v++){let I=p[v];I=`(shared with ${s.get(p.slice(0,v+1).join(`
`)).size}/${n.length} leaks) at ${I}`;let C=s.get(p.slice(0,v).join(`
`)),D=Xe([...C].map(x=>i(x)[v]),x=>x);delete D[p[v]];for(let[x,J]of Object.entries(D))T.unshift(`    - stacktraces of ${J.length} other leaks continue with ${x}`);T.unshift(I)}a+=`


==================== Leaking disposable ${h}/${n.length}: ${u.value.constructor.name} ====================
${T.join(`
`)}
============================================================

`}return n.length>e&&(a+=`


... and ${n.length-e} more leaking disposables

`),{leaks:n,details:a}}};de.idx=0;var Ze=de;function vt(r){K=r}if(Tt){let r="__is_disposable_tracked__";vt(new class{trackDisposable(e){let t=new Error("Potentially leaked disposable").stack;setTimeout(()=>{e[r]||console.log(t)},3e3)}setParent(e,t){if(e&&e!==k.None)try{e[r]=!0}catch{}}markAsDisposed(e){if(e&&e!==k.None)try{e[r]=!0}catch{}}markAsSingleton(e){}})}function pe(r){return K?.trackDisposable(r),r}function fe(r){K?.markAsDisposed(r)}function te(r,e){K?.setParent(r,e)}function bt(r,e){if(K)for(let t of r)K.setParent(t,e)}function Q(r){if(Le.is(r)){let e=[];for(let t of r)if(t)try{t.dispose()}catch(n){e.push(n)}if(e.length===1)throw e[0];if(e.length>1)throw new AggregateError(e,"Encountered errors while disposing of store");return Array.isArray(r)?[]:r}else if(r)return r.dispose(),r}function me(...r){let e=A(()=>Q(r));return bt(r,e),e}function A(r){let e=pe({dispose:Pe(()=>{fe(e),r()})});return e}var he=class he{constructor(){this._toDispose=new Set;this._isDisposed=!1;pe(this)}dispose(){this._isDisposed||(fe(this),this._isDisposed=!0,this.clear())}get isDisposed(){return this._isDisposed}clear(){if(this._toDispose.size!==0)try{Q(this._toDispose)}finally{this._toDispose.clear()}}add(e){if(!e)return e;if(e===this)throw new Error("Cannot register a disposable on itself!");return te(e,this),this._isDisposed?he.DISABLE_DISPOSED_WARNING||console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack):this._toDispose.add(e),e}delete(e){if(e){if(e===this)throw new Error("Cannot dispose a disposable on itself!");this._toDispose.delete(e),e.dispose()}}deleteAndLeak(e){e&&this._toDispose.has(e)&&(this._toDispose.delete(e),te(e,null))}};he.DISABLE_DISPOSED_WARNING=!1;var H=he,k=class{constructor(){this._store=new H;pe(this),te(this._store,this)}dispose(){fe(this),this._store.dispose()}_register(e){if(e===this)throw new Error("Cannot register a disposable on itself!");return this._store.add(e)}};k.None=Object.freeze({dispose(){}});var F=class{constructor(){this._isDisposed=!1;pe(this)}get value(){return this._isDisposed?void 0:this._value}set value(e){this._isDisposed||e===this._value||(this._value?.dispose(),e&&te(e,this),this._value=e)}clear(){this.value=void 0}dispose(){this._isDisposed=!0,fe(this),this._value?.dispose(),this._value=void 0}clearAndLeak(){let e=this._value;return this._value=void 0,e&&te(e,null),e}};var $=class ${constructor(e){this.element=e,this.next=$.Undefined,this.prev=$.Undefined}};$.Undefined=new $(void 0);var et=$;var _t=globalThis.performance&&typeof globalThis.performance.now=="function",Te=class r{static create(e){return new r(e)}constructor(e){this._now=_t&&e===!1?Date.now:globalThis.performance.now.bind(globalThis.performance),this._startTime=this._now(),this._stopTime=-1}stop(){this._stopTime=this._now()}reset(){this._startTime=this._now(),this._stopTime=-1}elapsed(){return this._stopTime!==-1?this._stopTime-this._startTime:this._now()-this._startTime}};var gt=!1,tt=!1,yt=!1,ie;(re=>{re.None=()=>k.None;function e(d){if(yt){let{onDidAddListener:o}=d,c=ne.create(),l=0;d.onDidAddListener=()=>{++l===2&&(console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here"),c.print()),o?.()}}}function t(d,o){return I(d,()=>{},0,void 0,!0,void 0,o)}re.defer=t;function n(d){return(o,c=null,l)=>{let f=!1,b;return b=d(g=>{if(!f)return b?b.dispose():f=!0,o.call(c,g)},null,l),f&&b.dispose(),b}}re.once=n;function i(d,o,c){return T((l,f=null,b)=>d(g=>l.call(f,o(g)),null,b),c)}re.map=i;function s(d,o,c){return T((l,f=null,b)=>d(g=>{o(g),l.call(f,g)},null,b),c)}re.forEach=s;function a(d,o,c){return T((l,f=null,b)=>d(g=>o(g)&&l.call(f,g),null,b),c)}re.filter=a;function h(d){return d}re.signal=h;function u(...d){return(o,c=null,l)=>{let f=me(...d.map(b=>b(g=>o.call(c,g))));return v(f,l)}}re.any=u;function p(d,o,c,l){let f=c;return i(d,b=>(f=o(f,b),f),l)}re.reduce=p;function T(d,o){let c,l={onWillAddFirstListener(){c=d(f.fire,f)},onDidRemoveLastListener(){c?.dispose()}};o||e(l);let f=new S(l);return o?.add(f),f.event}function v(d,o){return o instanceof Array?o.push(d):o&&o.add(d),d}function I(d,o,c=100,l=!1,f=!1,b,g){let w,R,U,se=0,Z,Ve={leakWarningThreshold:b,onWillAddFirstListener(){w=d(dt=>{se++,R=o(R,dt),l&&!U&&(oe.fire(R),R=void 0),Z=()=>{let ht=R;R=void 0,U=void 0,(!l||se>1)&&oe.fire(ht),se=0},typeof c=="number"?(clearTimeout(U),U=setTimeout(Z,c)):U===void 0&&(U=0,queueMicrotask(Z))})},onWillRemoveListener(){f&&se>0&&Z?.()},onDidRemoveLastListener(){Z=void 0,w.dispose()}};g||e(Ve);let oe=new S(Ve);return g?.add(oe),oe.event}re.debounce=I;function E(d,o=0,c){return re.debounce(d,(l,f)=>l?(l.push(f),l):[f],o,void 0,!0,void 0,c)}re.accumulate=E;function C(d,o=(l,f)=>l===f,c){let l=!0,f;return a(d,b=>{let g=l||!o(b,f);return l=!1,f=b,g},c)}re.latch=C;function D(d,o,c){return[re.filter(d,o,c),re.filter(d,l=>!o(l),c)]}re.split=D;function x(d,o=!1,c=[],l){let f=c.slice(),b=d(R=>{f?f.push(R):w.fire(R)});l&&l.add(b);let g=()=>{f?.forEach(R=>w.fire(R)),f=null},w=new S({onWillAddFirstListener(){b||(b=d(R=>w.fire(R)),l&&l.add(b))},onDidAddFirstListener(){f&&(o?setTimeout(g):g())},onDidRemoveLastListener(){b&&b.dispose(),b=null}});return l&&l.add(w),w.event}re.buffer=x;function J(d,o){return(l,f,b)=>{let g=o(new z);return d(function(w){let R=g.evaluate(w);R!==q&&l.call(f,R)},void 0,b)}}re.chain=J;let q=Symbol("HaltChainable");class z{constructor(){this.steps=[]}map(o){return this.steps.push(o),this}forEach(o){return this.steps.push(c=>(o(c),c)),this}filter(o){return this.steps.push(c=>o(c)?c:q),this}reduce(o,c){let l=c;return this.steps.push(f=>(l=o(l,f),l)),this}latch(o=(c,l)=>c===l){let c=!0,l;return this.steps.push(f=>{let b=c||!o(f,l);return c=!1,l=f,b?f:q}),this}evaluate(o){for(let c of this.steps)if(o=c(o),o===q)break;return o}}function m(d,o,c=l=>l){let l=(...w)=>g.fire(c(...w)),f=()=>d.on(o,l),b=()=>d.removeListener(o,l),g=new S({onWillAddFirstListener:f,onDidRemoveLastListener:b});return g.event}re.fromNodeEventEmitter=m;function _(d,o,c=l=>l){let l=(...w)=>g.fire(c(...w)),f=()=>d.addEventListener(o,l),b=()=>d.removeEventListener(o,l),g=new S({onWillAddFirstListener:f,onDidRemoveLastListener:b});return g.event}re.fromDOMEventEmitter=_;function y(d){return new Promise(o=>n(d)(o))}re.toPromise=y;function L(d){let o=new S;return d.then(c=>{o.fire(c)},()=>{o.fire(void 0)}).finally(()=>{o.dispose()}),o.event}re.fromPromise=L;function X(d,o){return d(c=>o.fire(c))}re.forward=X;function Se(d,o,c){return o(c),d(l=>o(l))}re.runAndSubscribe=Se;class ct{constructor(o,c){this._observable=o;this._counter=0;this._hasChanged=!1;let l={onWillAddFirstListener:()=>{o.addObserver(this)},onDidRemoveLastListener:()=>{o.removeObserver(this)}};c||e(l),this.emitter=new S(l),c&&c.add(this.emitter)}beginUpdate(o){this._counter++}handlePossibleChange(o){}handleChange(o,c){this._hasChanged=!0}endUpdate(o){this._counter--,this._counter===0&&(this._observable.reportChanges(),this._hasChanged&&(this._hasChanged=!1,this.emitter.fire(this._observable.get())))}}function zt(d,o){return new ct(d,o).emitter.event}re.fromObservable=zt;function Ut(d){return(o,c,l)=>{let f=0,b=!1,g={beginUpdate(){f++},endUpdate(){f--,f===0&&(d.reportChanges(),b&&(b=!1,o.call(c)))},handlePossibleChange(){},handleChange(){b=!0}};d.addObserver(g),d.reportChanges();let w={dispose(){d.removeObserver(g)}};return l instanceof H?l.add(w):Array.isArray(l)&&l.push(w),w}}re.fromObservableLight=Ut})(ie||={});var B=class B{constructor(e){this.listenerCount=0;this.invocationCount=0;this.elapsedOverall=0;this.durations=[];this.name=`${e}_${B._idPool++}`,B.all.add(this)}start(e){this._stopWatch=new Te,this.listenerCount=e}stop(){if(this._stopWatch){let e=this._stopWatch.elapsed();this.durations.push(e),this.elapsedOverall+=e,this.invocationCount+=1,this._stopWatch=void 0}}};B.all=new Set,B._idPool=0;var Oe=B,nt=-1;var be=class be{constructor(e,t,n=(be._idPool++).toString(16).padStart(3,"0")){this._errorHandler=e;this.threshold=t;this.name=n;this._warnCountdown=0}dispose(){this._stacks?.clear()}check(e,t){let n=this.threshold;if(n<=0||t<n)return;this._stacks||(this._stacks=new Map);let i=this._stacks.get(e.value)||0;if(this._stacks.set(e.value,i+1),this._warnCountdown-=1,this._warnCountdown<=0){this._warnCountdown=n*.5;let[s,a]=this.getMostFrequentStack(),h=`[${this.name}] potential listener LEAK detected, having ${t} listeners already. MOST frequent listener (${a}):`;console.warn(h),console.warn(s);let u=new Me(h,s);this._errorHandler(u)}return()=>{let s=this._stacks.get(e.value)||0;this._stacks.set(e.value,s-1)}}getMostFrequentStack(){if(!this._stacks)return;let e,t=0;for(let[n,i]of this._stacks)(!e||t<i)&&(e=[n,i],t=i);return e}};be._idPool=1;var Ae=be,ne=class r{constructor(e){this.value=e}static create(){let e=new Error;return new r(e.stack??"")}print(){console.warn(this.value.split(`
`).slice(2).join(`
`))}},Me=class extends Error{constructor(e,t){super(e),this.name="ListenerLeakError",this.stack=t}},Fe=class extends Error{constructor(e,t){super(e),this.name="ListenerRefusalError",this.stack=t}},xt=0,G=class{constructor(e){this.value=e;this.id=xt++}},It=2,Dt=(r,e)=>{if(r instanceof G)e(r);else for(let t=0;t<r.length;t++){let n=r[t];n&&e(n)}},ve;if(gt){let r=[];setInterval(()=>{r.length!==0&&(console.warn("[LEAKING LISTENERS] GC'ed these listeners that were NOT yet disposed:"),console.warn(r.join(`
`)),r.length=0)},3e3),ve=new FinalizationRegistry(e=>{typeof e=="string"&&r.push(e)})}var S=class{constructor(e){this._size=0;this._options=e,this._leakageMon=nt>0||this._options?.leakWarningThreshold?new Ae(e?.onListenerError??le,this._options?.leakWarningThreshold??nt):void 0,this._perfMon=this._options?._profName?new Oe(this._options._profName):void 0,this._deliveryQueue=this._options?.deliveryQueue}dispose(){if(!this._disposed){if(this._disposed=!0,this._deliveryQueue?.current===this&&this._deliveryQueue.reset(),this._listeners){if(tt){let e=this._listeners;queueMicrotask(()=>{Dt(e,t=>t.stack?.print())})}this._listeners=void 0,this._size=0}this._options?.onDidRemoveLastListener?.(),this._leakageMon?.dispose()}}get event(){return this._event??=(e,t,n)=>{if(this._leakageMon&&this._size>this._leakageMon.threshold**2){let u=`[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this._size} vs ${this._leakageMon.threshold})`;console.warn(u);let p=this._leakageMon.getMostFrequentStack()??["UNKNOWN stack",-1],T=new Fe(`${u}. HINT: Stack shows most frequent listener (${p[1]}-times)`,p[0]);return(this._options?.onListenerError||le)(T),k.None}if(this._disposed)return k.None;t&&(e=e.bind(t));let i=new G(e),s,a;this._leakageMon&&this._size>=Math.ceil(this._leakageMon.threshold*.2)&&(i.stack=ne.create(),s=this._leakageMon.check(i.stack,this._size+1)),tt&&(i.stack=a??ne.create()),this._listeners?this._listeners instanceof G?(this._deliveryQueue??=new Ne,this._listeners=[this._listeners,i]):this._listeners.push(i):(this._options?.onWillAddFirstListener?.(this),this._listeners=i,this._options?.onDidAddFirstListener?.(this)),this._size++;let h=A(()=>{ve?.unregister(h),s?.(),this._removeListener(i)});if(n instanceof H?n.add(h):Array.isArray(n)&&n.push(h),ve){let u=new Error().stack.split(`
`).slice(2,3).join(`
`).trim(),p=/(file:|vscode-file:\/\/vscode-app)?(\/[^:]*:\d+:\d+)/.exec(u);ve.register(h,p?.[2]??u,h)}return h},this._event}_removeListener(e){if(this._options?.onWillRemoveListener?.(this),!this._listeners)return;if(this._size===1){this._listeners=void 0,this._options?.onDidRemoveLastListener?.(this),this._size=0;return}let t=this._listeners,n=t.indexOf(e);if(n===-1)throw console.log("disposed?",this._disposed),console.log("size?",this._size),console.log("arr?",JSON.stringify(this._listeners)),new Error("Attempted to dispose unknown listener");this._size--,t[n]=void 0;let i=this._deliveryQueue.current===this;if(this._size*It<=t.length){let s=0;for(let a=0;a<t.length;a++)t[a]?t[s++]=t[a]:i&&(this._deliveryQueue.end--,s<this._deliveryQueue.i&&this._deliveryQueue.i--);t.length=s}}_deliver(e,t){if(!e)return;let n=this._options?.onListenerError||le;if(!n){e.value(t);return}try{e.value(t)}catch(i){n(i)}}_deliverQueue(e){let t=e.current._listeners;for(;e.i<e.end;)this._deliver(t[e.i++],e.value);e.reset()}fire(e){if(this._deliveryQueue?.current&&(this._deliverQueue(this._deliveryQueue),this._perfMon?.stop()),this._perfMon?.start(this._size),this._listeners)if(this._listeners instanceof G)this._deliver(this._listeners,e);else{let t=this._deliveryQueue;t.enqueue(this,e,this._listeners.length),this._deliverQueue(t)}this._perfMon?.stop()}hasListeners(){return this._size>0}};var Ne=class{constructor(){this.i=-1;this.end=0}enqueue(e,t,n){this.i=0,this.end=n,this.current=e,this.value=t}reset(){this.i=this.end,this.current=void 0,this.value=void 0}};var it=Object.freeze(function(r,e){let t=setTimeout(r.bind(e),0);return{dispose(){clearTimeout(t)}}}),Et;(n=>{function r(i){return i===n.None||i===n.Cancelled||i instanceof We?!0:!i||typeof i!="object"?!1:typeof i.isCancellationRequested=="boolean"&&typeof i.onCancellationRequested=="function"}n.isCancellationToken=r,n.None=Object.freeze({isCancellationRequested:!1,onCancellationRequested:ie.None}),n.Cancelled=Object.freeze({isCancellationRequested:!0,onCancellationRequested:it})})(Et||={});var We=class{constructor(){this._isCancelled=!1;this._emitter=null}cancel(){this._isCancelled||(this._isCancelled=!0,this._emitter&&(this._emitter.fire(void 0),this.dispose()))}get isCancellationRequested(){return this._isCancelled}get onCancellationRequested(){return this._isCancelled?it:(this._emitter||(this._emitter=new S),this._emitter.event)}dispose(){this._emitter&&(this._emitter.dispose(),this._emitter=null)}};var Y="en",qe=!1,ze=!1,ge=!1,wt=!1,kt=!1,st=!1,St=!1,Ct=!1,Rt=!1,Pt=!1,_e,ye=Y,rt=Y,Lt,N,W=globalThis,O;typeof W.vscode<"u"&&typeof W.vscode.process<"u"?O=W.vscode.process:typeof process<"u"&&typeof process?.versions?.node=="string"&&(O=process);var ot=typeof O?.versions?.electron=="string",Ot=ot&&O?.type==="renderer";if(typeof O=="object"){qe=O.platform==="win32",ze=O.platform==="darwin",ge=O.platform==="linux",wt=ge&&!!O.env.SNAP&&!!O.env.SNAP_REVISION,St=ot,Rt=!!O.env.CI||!!O.env.BUILD_ARTIFACTSTAGINGDIRECTORY,_e=Y,ye=Y;let r=O.env.VSCODE_NLS_CONFIG;if(r)try{let e=JSON.parse(r);_e=e.userLocale,rt=e.osLocale,ye=e.resolvedLanguage||Y,Lt=e.languagePack?.translationsConfigFile}catch{}kt=!0}else typeof navigator=="object"&&!Ot?(N=navigator.userAgent,qe=N.indexOf("Windows")>=0,ze=N.indexOf("Macintosh")>=0,Ct=(N.indexOf("Macintosh")>=0||N.indexOf("iPad")>=0||N.indexOf("iPhone")>=0)&&!!navigator.maxTouchPoints&&navigator.maxTouchPoints>0,ge=N.indexOf("Linux")>=0,Pt=N?.indexOf("Mobi")>=0,st=!0,ye=globalThis._VSCODE_NLS_LANGUAGE||Y,_e=navigator.language.toLowerCase(),rt=_e):console.error("Unable to resolve platform.");var je=0;ze?je=1:qe?je=3:ge&&(je=2);var At=st&&typeof W.importScripts=="function",gn=At?W.origin:void 0;var M=N,j=ye,Mt;(n=>{function r(){return j}n.value=r;function e(){return j.length===2?j==="en":j.length>=3?j[0]==="e"&&j[1]==="n"&&j[2]==="-":!1}n.isDefaultVariant=e;function t(){return j==="en"}n.isDefault=t})(Mt||={});var Ft=typeof W.postMessage=="function"&&!W.importScripts,at=(()=>{if(Ft){let r=[];W.addEventListener("message",t=>{if(t.data&&t.data.vscodeScheduleAsyncWork)for(let n=0,i=r.length;n<i;n++){let s=r[n];if(s.id===t.data.vscodeScheduleAsyncWork){r.splice(n,1),s.callback();return}}});let e=0;return t=>{let n=++e;r.push({id:n,callback:t}),W.postMessage({vscodeScheduleAsyncWork:n},"*")}}return r=>setTimeout(r)})();var Nt=!!(M&&M.indexOf("Chrome")>=0),yn=!!(M&&M.indexOf("Firefox")>=0),xn=!!(!Nt&&M&&M.indexOf("Safari")>=0),In=!!(M&&M.indexOf("Edg/")>=0),Dn=!!(M&&M.indexOf("Android")>=0);var Wt=Symbol("MicrotaskDelay");function xe(r,e=0,t){let n=setTimeout(()=>{r(),t&&i.dispose()},e),i=A(()=>{clearTimeout(n),t?.deleteAndLeak(i)});return t?.add(i),i}var jt,Ue;(function(){typeof globalThis.requestIdleCallback!="function"||typeof globalThis.cancelIdleCallback!="function"?Ue=(r,e)=>{at(()=>{if(t)return;let n=Date.now()+15;e(Object.freeze({didTimeout:!0,timeRemaining(){return Math.max(0,n-Date.now())}}))});let t=!1;return{dispose(){t||(t=!0)}}}:Ue=(r,e,t)=>{let n=r.requestIdleCallback(e,typeof t=="number"?{timeout:t}:void 0),i=!1;return{dispose(){i||(i=!0,r.cancelIdleCallback(n))}}},jt=r=>Ue(globalThis,r)})();var qt;(t=>{async function r(n){let i,s=await Promise.all(n.map(a=>a.then(h=>h,h=>{i||(i=h)})));if(typeof i<"u")throw i;return s}t.settled=r;function e(n){return new Promise(async(i,s)=>{try{await n(i,s)}catch(a){s(a)}})}t.withAsyncBody=e})(qt||={});var P=class P{static fromArray(e){return new P(t=>{t.emitMany(e)})}static fromPromise(e){return new P(async t=>{t.emitMany(await e)})}static fromPromises(e){return new P(async t=>{await Promise.all(e.map(async n=>t.emitOne(await n)))})}static merge(e){return new P(async t=>{await Promise.all(e.map(async n=>{for await(let i of n)t.emitOne(i)}))})}constructor(e,t){this._state=0,this._results=[],this._error=null,this._onReturn=t,this._onStateChanged=new S,queueMicrotask(async()=>{let n={emitOne:i=>this.emitOne(i),emitMany:i=>this.emitMany(i),reject:i=>this.reject(i)};try{await Promise.resolve(e(n)),this.resolve()}catch(i){this.reject(i)}finally{n.emitOne=void 0,n.emitMany=void 0,n.reject=void 0}})}[Symbol.asyncIterator](){let e=0;return{next:async()=>{do{if(this._state===2)throw this._error;if(e<this._results.length)return{done:!1,value:this._results[e++]};if(this._state===1)return{done:!0,value:void 0};await ie.toPromise(this._onStateChanged.event)}while(!0)},return:async()=>(this._onReturn?.(),{done:!0,value:void 0})}}static map(e,t){return new P(async n=>{for await(let i of e)n.emitOne(t(i))})}map(e){return P.map(this,e)}static filter(e,t){return new P(async n=>{for await(let i of e)t(i)&&n.emitOne(i)})}filter(e){return P.filter(this,e)}static coalesce(e){return P.filter(e,t=>!!t)}coalesce(){return P.coalesce(this)}static async toPromise(e){let t=[];for await(let n of e)t.push(n);return t}toPromise(){return P.toPromise(this)}emitOne(e){this._state===0&&(this._results.push(e),this._onStateChanged.fire())}emitMany(e){this._state===0&&(this._results=this._results.concat(e),this._onStateChanged.fire())}resolve(){this._state===0&&(this._state=1,this._onStateChanged.fire())}reject(e){this._state===0&&(this._state=2,this._error=e,this._onStateChanged.fire())}};P.EMPTY=P.fromArray([]);var lt=P;var Ie=class extends k{constructor(t){super();this._terminal=t;this._linesCacheTimeout=this._register(new F);this._linesCacheDisposables=this._register(new F);this._lastAccessTimestamp=0;this._register(A(()=>this._destroyLinesCache()))}initLinesCache(){this._linesCache||(this._linesCache=new Array(this._terminal.buffer.active.length),this._linesCacheDisposables.value=me(this._terminal.onLineFeed(()=>this._destroyLinesCache()),this._terminal.onCursorMove(()=>this._destroyLinesCache()),this._terminal.onResize(()=>this._destroyLinesCache()))),this._lastAccessTimestamp=Date.now(),this._linesCacheTimeout.value||this._scheduleLinesCacheTimeout(15e3)}_destroyLinesCache(){this._linesCache=void 0,this._lastAccessTimestamp=0,this._linesCacheDisposables.clear(),this._linesCacheTimeout.clear()}_scheduleLinesCacheTimeout(t){this._linesCacheTimeout.value=xe(()=>{if(!this._linesCache)return;let i=Date.now()-this._lastAccessTimestamp;if(i>=15e3){this._destroyLinesCache();return}this._scheduleLinesCacheTimeout(15e3-i)},t)}getLineFromCache(t){return this._linesCache?.[t]}setLineInCache(t,n){this._linesCache&&(this._linesCache[t]=n)}translateBufferLineToStringWithWrap(t,n){let i=[],s=[0],a=this._terminal.buffer.active.getLine(t);for(;a;){let h=this._terminal.buffer.active.getLine(t+1),u=h?h.isWrapped:!1,p=a.translateToString(!u&&n);if(u&&h){let T=a.getCell(a.length-1);T&&T.getCode()===0&&T.getWidth()===1&&h.getCell(0)?.getWidth()===2&&(p=p.slice(0,-1))}if(i.push(p),u)s.push(s[s.length-1]+p.length);else break;t++,a=h}return[i.join(""),s]}};var De=class{get cachedSearchTerm(){return this._cachedSearchTerm}set cachedSearchTerm(e){this._cachedSearchTerm=e}get lastSearchOptions(){return this._lastSearchOptions}set lastSearchOptions(e){this._lastSearchOptions=e}isValidSearchTerm(e){return!!(e&&e.length>0)}didOptionsChange(e){return this._lastSearchOptions?e?this._lastSearchOptions.caseSensitive!==e.caseSensitive||this._lastSearchOptions.regex!==e.regex||this._lastSearchOptions.wholeWord!==e.wholeWord:!1:!0}shouldUpdateHighlighting(e,t){return t?.decorations?this._cachedSearchTerm===void 0||e!==this._cachedSearchTerm||this.didOptionsChange(t):!1}clearCachedTerm(){this._cachedSearchTerm=void 0}reset(){this._cachedSearchTerm=void 0,this._lastSearchOptions=void 0}};var Ee=class{constructor(e,t){this._terminal=e;this._lineCache=t}find(e,t,n,i){if(!e||e.length===0){this._terminal.clearSelection();return}if(n>this._terminal.cols)throw new Error(`Invalid col: ${n} to search in terminal of ${this._terminal.cols} cols`);this._lineCache.initLinesCache();let s={startRow:t,startCol:n},a=this._findInLine(e,s,i);if(!a)for(let h=t+1;h<this._terminal.buffer.active.baseY+this._terminal.rows&&(s.startRow=h,s.startCol=0,a=this._findInLine(e,s,i),!a);h++);return a}findNextWithSelection(e,t,n){if(!e||e.length===0){this._terminal.clearSelection();return}let i=this._terminal.getSelectionPosition();this._terminal.clearSelection();let s=0,a=0;i&&(n===e?(s=i.end.x,a=i.end.y):(s=i.start.x,a=i.start.y)),this._lineCache.initLinesCache();let h={startRow:a,startCol:s},u=this._findInLine(e,h,t);if(!u)for(let p=a+1;p<this._terminal.buffer.active.baseY+this._terminal.rows&&(h.startRow=p,h.startCol=0,u=this._findInLine(e,h,t),!u);p++);if(!u&&a!==0)for(let p=0;p<a&&(h.startRow=p,h.startCol=0,u=this._findInLine(e,h,t),!u);p++);return!u&&i&&(h.startRow=i.start.y,h.startCol=0,u=this._findInLine(e,h,t)),u}findPreviousWithSelection(e,t,n){if(!e||e.length===0){this._terminal.clearSelection();return}let i=this._terminal.getSelectionPosition();this._terminal.clearSelection();let s=this._terminal.buffer.active.baseY+this._terminal.rows-1,a=this._terminal.cols,h=!0;this._lineCache.initLinesCache();let u={startRow:s,startCol:a},p;if(i&&(u.startRow=s=i.start.y,u.startCol=a=i.start.x,n!==e&&(p=this._findInLine(e,u,t,!1),p||(u.startRow=s=i.end.y,u.startCol=a=i.end.x))),p||(p=this._findInLine(e,u,t,h)),!p){u.startCol=Math.max(u.startCol,this._terminal.cols);for(let T=s-1;T>=0&&(u.startRow=T,p=this._findInLine(e,u,t,h),!p);T--);}if(!p&&s!==this._terminal.buffer.active.baseY+this._terminal.rows-1)for(let T=this._terminal.buffer.active.baseY+this._terminal.rows-1;T>=s&&(u.startRow=T,p=this._findInLine(e,u,t,h),!p);T--);return p}_isWholeWord(e,t,n){return(e===0||" ~!@#$%^&*()+`-=[]{}|\\;:\"',./<>?".includes(t[e-1]))&&(e+n.length===t.length||" ~!@#$%^&*()+`-=[]{}|\\;:\"',./<>?".includes(t[e+n.length]))}_findInLine(e,t,n={},i=!1){let s=t.startRow,a=t.startCol;if(this._terminal.buffer.active.getLine(s)?.isWrapped){if(i){t.startCol+=this._terminal.cols;return}return t.startRow--,t.startCol+=this._terminal.cols,this._findInLine(e,t,n)}let u=this._lineCache.getLineFromCache(s);u||(u=this._lineCache.translateBufferLineToStringWithWrap(s,!0),this._lineCache.setLineInCache(s,u));let[p,T]=u,v=this._bufferColsToStringOffset(s,a),I=e,E=p;n.regex||(I=n.caseSensitive?e:e.toLowerCase(),E=n.caseSensitive?p:p.toLowerCase());let C=-1;if(n.regex){let D=RegExp(I,n.caseSensitive?"g":"gi"),x;if(i)for(;x=D.exec(E.slice(0,v));)C=D.lastIndex-x[0].length,e=x[0],D.lastIndex-=e.length-1;else x=D.exec(E.slice(v)),x&&x[0].length>0&&(C=v+(D.lastIndex-x[0].length),e=x[0])}else i?v-I.length>=0&&(C=E.lastIndexOf(I,v-I.length)):C=E.indexOf(I,v);if(C>=0){if(n.wholeWord&&!this._isWholeWord(C,E,e))return;let D=0;for(;D<T.length-1&&C>=T[D+1];)D++;let x=D;for(;x<T.length-1&&C+e.length>=T[x+1];)x++;let J=C-T[D],q=C+e.length-T[x],z=this._stringLengthToBufferSize(s+D,J),_=this._stringLengthToBufferSize(s+x,q)-z+this._terminal.cols*(x-D);return{term:e,col:z,row:s+D,size:_}}}_stringLengthToBufferSize(e,t){let n=this._terminal.buffer.active.getLine(e);if(!n)return 0;for(let i=0;i<t;i++){let s=n.getCell(i);if(!s)break;let a=s.getChars();a.length>1&&(t-=a.length-1);let h=n.getCell(i+1);h&&h.getWidth()===0&&t++}return t}_bufferColsToStringOffset(e,t){let n=e,i=0,s=this._terminal.buffer.active.getLine(n);for(;t>0&&s;){for(let a=0;a<t&&a<this._terminal.cols;a++){let h=s.getCell(a);if(!h)break;h.getWidth()&&(i+=h.getCode()===0?1:h.getChars().length)}if(n++,s=this._terminal.buffer.active.getLine(n),s&&!s.isWrapped)break;t-=this._terminal.cols}return i}};var we=class extends k{constructor(t){super();this._terminal=t;this._highlightDecorations=[];this._highlightedLines=new Set;this._register(A(()=>this.clearHighlightDecorations()))}createHighlightDecorations(t,n){this.clearHighlightDecorations();for(let i of t){let s=this._createResultDecorations(i,n,!1);if(s)for(let a of s)this._storeDecoration(a,i)}}createActiveDecoration(t,n){let i=this._createResultDecorations(t,n,!0);if(i)return{decorations:i,match:t,dispose(){Q(i)}}}clearHighlightDecorations(){Q(this._highlightDecorations),this._highlightDecorations=[],this._highlightedLines.clear()}_storeDecoration(t,n){this._highlightedLines.add(t.marker.line),this._highlightDecorations.push({decoration:t,match:n,dispose(){t.dispose()}})}_applyStyles(t,n,i){t.classList.contains("xterm-find-result-decoration")||(t.classList.add("xterm-find-result-decoration"),n&&(t.style.outline=`1px solid ${n}`)),i&&t.classList.add("xterm-find-active-result-decoration")}_createResultDecorations(t,n,i){let s=[],a=t.col,h=t.size,u=-this._terminal.buffer.active.baseY-this._terminal.buffer.active.cursorY+t.row;for(;h>0;){let T=Math.min(this._terminal.cols-a,h);s.push([u,a,T]),a=0,h-=T,u++}let p=[];for(let T of s){let v=this._terminal.registerMarker(T[0]),I=this._terminal.registerDecoration({marker:v,x:T[1],width:T[2],layer:i?"top":"bottom",backgroundColor:i?n.activeMatchBackground:n.matchBackground,overviewRulerOptions:this._highlightedLines.has(v.line)?void 0:{color:i?n.activeMatchColorOverviewRuler:n.matchOverviewRuler,position:"center"}});if(I){let E=[];E.push(v),E.push(I.onRender(C=>this._applyStyles(C,i?n.activeMatchBorder:n.matchBorder,!1))),E.push(I.onDispose(()=>Q(E))),p.push(I)}}return p.length===0?void 0:p}};var ke=class extends k{constructor(){super(...arguments);this._searchResults=[];this._onDidChangeResults=this._register(new S)}get onDidChangeResults(){return this._onDidChangeResults.event}get searchResults(){return this._searchResults}get selectedDecoration(){return this._selectedDecoration}set selectedDecoration(t){this._selectedDecoration=t}updateResults(t,n){this._searchResults=t.slice(0,n)}clearResults(){this._searchResults=[]}clearSelectedDecoration(){this._selectedDecoration&&(this._selectedDecoration.dispose(),this._selectedDecoration=void 0)}findResultIndex(t){for(let n=0;n<this._searchResults.length;n++){let i=this._searchResults[n];if(i.row===t.row&&i.col===t.col&&i.size===t.size)return n}return-1}fireResultsChanged(t){if(!t)return;let n=-1;this._selectedDecoration&&(n=this.findResultIndex(this._selectedDecoration.match)),this._onDidChangeResults.fire({resultIndex:n,resultCount:this._searchResults.length})}reset(){this.clearSelectedDecoration(),this.clearResults()}};var ut=class extends k{constructor(t){super();this._highlightTimeout=this._register(new F);this._lineCache=this._register(new F);this._state=new De;this._resultTracker=this._register(new ke);this._onAfterSearch=this._register(new S);this.onAfterSearch=this._onAfterSearch.event;this._onBeforeSearch=this._register(new S);this.onBeforeSearch=this._onBeforeSearch.event;this._highlightLimit=t?.highlightLimit??1e3}get onDidChangeResults(){return this._resultTracker.onDidChangeResults}activate(t){this._terminal=t,this._lineCache.value=new Ie(t),this._engine=new Ee(t,this._lineCache.value),this._decorationManager=new we(t),this._register(this._terminal.onWriteParsed(()=>this._updateMatches())),this._register(this._terminal.onResize(()=>this._updateMatches())),this._register(A(()=>this.clearDecorations()))}_updateMatches(){this._highlightTimeout.clear(),this._state.cachedSearchTerm&&this._state.lastSearchOptions?.decorations&&(this._highlightTimeout.value=xe(()=>{let t=this._state.cachedSearchTerm;this._state.clearCachedTerm(),this.findPrevious(t,{...this._state.lastSearchOptions,incremental:!0},{noScroll:!0})},200))}clearDecorations(t){this._resultTracker.clearSelectedDecoration(),this._decorationManager?.clearHighlightDecorations(),this._resultTracker.clearResults(),t||this._state.clearCachedTerm()}clearActiveDecoration(){this._resultTracker.clearSelectedDecoration()}findNext(t,n,i){if(!this._terminal||!this._engine)throw new Error("Cannot use addon until it has been loaded");this._onBeforeSearch.fire(),this._state.lastSearchOptions=n,this._state.shouldUpdateHighlighting(t,n)&&this._highlightAllMatches(t,n);let s=this._findNextAndSelect(t,n,i);return this._fireResults(n),this._state.cachedSearchTerm=t,this._onAfterSearch.fire(),s}_highlightAllMatches(t,n){if(!this._terminal||!this._engine||!this._decorationManager)throw new Error("Cannot use addon until it has been loaded");if(!this._state.isValidSearchTerm(t)){this.clearDecorations();return}this.clearDecorations(!0);let i=[],s,a=this._engine.find(t,0,0,n);for(;a&&(s?.row!==a.row||s?.col!==a.col)&&!(i.length>=this._highlightLimit);)s=a,i.push(s),a=this._engine.find(t,s.col+s.term.length>=this._terminal.cols?s.row+1:s.row,s.col+s.term.length>=this._terminal.cols?0:s.col+1,n);this._resultTracker.updateResults(i,this._highlightLimit),n.decorations&&this._decorationManager.createHighlightDecorations(i,n.decorations)}_findNextAndSelect(t,n,i){if(!this._terminal||!this._engine)return!1;if(!this._state.isValidSearchTerm(t))return this._terminal.clearSelection(),this.clearDecorations(),!1;let s=this._engine.findNextWithSelection(t,n,this._state.cachedSearchTerm);return this._selectResult(s,n?.decorations,i?.noScroll)}findPrevious(t,n,i){if(!this._terminal||!this._engine)throw new Error("Cannot use addon until it has been loaded");this._onBeforeSearch.fire(),this._state.lastSearchOptions=n,this._state.shouldUpdateHighlighting(t,n)&&this._highlightAllMatches(t,n);let s=this._findPreviousAndSelect(t,n,i);return this._fireResults(n),this._state.cachedSearchTerm=t,this._onAfterSearch.fire(),s}_fireResults(t){this._resultTracker.fireResultsChanged(!!t?.decorations)}_findPreviousAndSelect(t,n,i){if(!this._terminal||!this._engine)return!1;if(!this._state.isValidSearchTerm(t))return this._terminal.clearSelection(),this.clearDecorations(),!1;let s=this._engine.findPreviousWithSelection(t,n,this._state.cachedSearchTerm);return this._selectResult(s,n?.decorations,i?.noScroll)}_selectResult(t,n,i){if(!this._terminal||!this._decorationManager)return!1;if(this._resultTracker.clearSelectedDecoration(),!t)return this._terminal.clearSelection(),!1;if(this._terminal.select(t.col,t.row,t.size),n){let s=this._decorationManager.createActiveDecoration(t,n);s&&(this._resultTracker.selectedDecoration=s)}if(!i&&(t.row>=this._terminal.buffer.active.viewportY+this._terminal.rows||t.row<this._terminal.buffer.active.viewportY)){let s=t.row-this._terminal.buffer.active.viewportY;s-=Math.floor(this._terminal.rows/2),this._terminal.scrollLines(s)}return!0}};export{ut as SearchAddon};
//# sourceMappingURL=addon-search.mjs.map
