/* Utils.c generated by valac 0.56.17, the Vala compiler
 * generated from Utils.vala, do not modify */

/*-
 * Copyright (c) 2015-2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "network.h"
#include <NetworkManager.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define NETWORK_UNKNOWN_STR _ ("Unknown")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetworkParamSpecUtils NetworkParamSpecUtils;

struct _Block1Data {
	int _ref_count_;
	NMRemoteConnection* connection;
	NetworkUtilsUpdateSecretCallback callback;
	gpointer callback_target;
};

struct _NetworkParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer network_utils_parent_class = NULL;

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void network_utils_finalize (NetworkUtils * obj);
static GType network_utils_get_type_once (void);

static GType
network_utils_item_type_get_type_once (void)
{
	static const GEnumValue values[] = {{NETWORK_UTILS_ITEM_TYPE_DEVICE, "NETWORK_UTILS_ITEM_TYPE_DEVICE", "device"}, {NETWORK_UTILS_ITEM_TYPE_VIRTUAL, "NETWORK_UTILS_ITEM_TYPE_VIRTUAL", "virtual"}, {NETWORK_UTILS_ITEM_TYPE_INVALID, "NETWORK_UTILS_ITEM_TYPE_INVALID", "invalid"}, {0, NULL, NULL}};
	GType network_utils_item_type_type_id;
	network_utils_item_type_type_id = g_enum_register_static ("NetworkUtilsItemType", values);
	return network_utils_item_type_type_id;
}

GType
network_utils_item_type_get_type (void)
{
	static volatile gsize network_utils_item_type_type_id__once = 0;
	if (g_once_init_enter (&network_utils_item_type_type_id__once)) {
		GType network_utils_item_type_type_id;
		network_utils_item_type_type_id = network_utils_item_type_get_type_once ();
		g_once_init_leave (&network_utils_item_type_type_id__once, network_utils_item_type_type_id);
	}
	return network_utils_item_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->connection);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GVariant* secrets = NULL;
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		_tmp0_ = nm_remote_connection_get_secrets_finish (_data1_->connection, res, &_inner_error0_);
		secrets = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = secrets;
		nm_connection_update_secrets ((NMConnection*) _data1_->connection, NM_SETTING_WIRELESS_SECURITY_SETTING_NAME, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_variant_unref0 (secrets);
			goto __catch0_g_error;
		}
		_g_variant_unref0 (secrets);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Utils.vala:40: %s\n", _tmp3_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_data1_->callback (_data1_->callback_target);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

void
network_utils_update_secrets (NMRemoteConnection* connection,
                              NetworkUtilsUpdateSecretCallback callback,
                              gpointer callback_target)
{
	Block1Data* _data1_;
	NMRemoteConnection* _tmp0_;
	g_return_if_fail (connection != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (_data1_->connection);
	_data1_->connection = _tmp0_;
	_data1_->callback = callback;
	_data1_->callback_target = callback_target;
	nm_remote_connection_get_secrets_async (_data1_->connection, NM_SETTING_WIRELESS_SECURITY_SETTING_NAME, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

gboolean
network_utils_get_device_is_hotspot (NMDeviceWifi* wifi_device)
{
	NMActiveConnection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (wifi_device != NULL, FALSE);
	_tmp0_ = nm_device_get_active_connection ((NMDevice*) wifi_device);
	if (_tmp0_ != NULL) {
		NMRemoteConnection* connection = NULL;
		NMActiveConnection* _tmp1_;
		NMRemoteConnection* _tmp2_;
		NMRemoteConnection* _tmp3_;
		NMRemoteConnection* _tmp4_;
		_tmp1_ = nm_device_get_active_connection ((NMDevice*) wifi_device);
		_tmp2_ = nm_active_connection_get_connection (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		connection = _tmp3_;
		_tmp4_ = connection;
		if (_tmp4_ != NULL) {
			NMSettingIP4Config* ip4_setting = NULL;
			NMRemoteConnection* _tmp5_;
			NMSettingIP4Config* _tmp6_;
			NMSettingIP4Config* _tmp7_;
			gboolean _tmp8_ = FALSE;
			NMSettingIP4Config* _tmp9_;
			_tmp5_ = connection;
			_tmp6_ = nm_connection_get_setting_ip4_config ((NMConnection*) _tmp5_);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			ip4_setting = _tmp7_;
			_tmp9_ = ip4_setting;
			if (_tmp9_ != NULL) {
				NMSettingIP4Config* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = ip4_setting;
				_tmp11_ = nm_setting_ip_config_get_method ((NMSettingIPConfig*) _tmp10_);
				_tmp8_ = g_strcmp0 (_tmp11_, "shared") == 0;
			} else {
				_tmp8_ = FALSE;
			}
			result = _tmp8_;
			_g_object_unref0 (ip4_setting);
			_g_object_unref0 (connection);
			return result;
		}
		_g_object_unref0 (connection);
	}
	result = FALSE;
	return result;
}

gboolean
network_utils_get_connection_is_hotspot (NMConnection* connection)
{
	NMSettingConnection* setting_connection = NULL;
	NMSettingConnection* _tmp0_;
	NMSettingConnection* _tmp1_;
	NMSettingConnection* _tmp2_;
	const gchar* _tmp3_;
	NMSettingWireless* setting_wireless = NULL;
	NMSettingWireless* _tmp4_;
	NMSettingWireless* _tmp5_;
	gboolean _tmp6_ = FALSE;
	NMSettingWireless* _tmp7_;
	const gchar* _tmp8_;
	NMSettingWirelessSecurity* _tmp11_;
	NMSettingIP4Config* ip4_config = NULL;
	NMSettingIP4Config* _tmp12_;
	NMSettingIP4Config* _tmp13_;
	NMSettingIP4Config* _tmp14_;
	const gchar* _tmp15_;
	gboolean result;
	g_return_val_if_fail (connection != NULL, FALSE);
	_tmp0_ = nm_connection_get_setting_connection (connection);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	setting_connection = _tmp1_;
	_tmp2_ = setting_connection;
	_tmp3_ = nm_setting_connection_get_connection_type (_tmp2_);
	if (g_strcmp0 (_tmp3_, "802-11-wireless") != 0) {
		result = FALSE;
		_g_object_unref0 (setting_connection);
		return result;
	}
	_tmp4_ = nm_connection_get_setting_wireless (connection);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	setting_wireless = _tmp5_;
	_tmp7_ = setting_wireless;
	_tmp8_ = nm_setting_wireless_get_mode (_tmp7_);
	if (g_strcmp0 (_tmp8_, "adhoc") != 0) {
		NMSettingWireless* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = setting_wireless;
		_tmp10_ = nm_setting_wireless_get_mode (_tmp9_);
		_tmp6_ = g_strcmp0 (_tmp10_, "ap") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (setting_wireless);
		_g_object_unref0 (setting_connection);
		return result;
	}
	_tmp11_ = nm_connection_get_setting_wireless_security (connection);
	if (_tmp11_ == NULL) {
		result = FALSE;
		_g_object_unref0 (setting_wireless);
		_g_object_unref0 (setting_connection);
		return result;
	}
	_tmp12_ = nm_connection_get_setting_ip4_config (connection);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	ip4_config = _tmp13_;
	_tmp14_ = ip4_config;
	_tmp15_ = nm_setting_ip_config_get_method ((NMSettingIPConfig*) _tmp14_);
	if (g_strcmp0 (_tmp15_, "shared") != 0) {
		result = FALSE;
		_g_object_unref0 (ip4_config);
		_g_object_unref0 (setting_wireless);
		_g_object_unref0 (setting_connection);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (ip4_config);
	_g_object_unref0 (setting_wireless);
	_g_object_unref0 (setting_connection);
	return result;
}

gchar*
network_utils_state_to_string (NMDeviceState state)
{
	gchar* result;
	switch (state) {
		case NM_DEVICE_STATE_ACTIVATED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Connected"));
			result = _tmp0_;
			return result;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Disconnected"));
			result = _tmp1_;
			return result;
		}
		case NM_DEVICE_STATE_UNMANAGED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Unmanaged"));
			result = _tmp2_;
			return result;
		}
		case NM_DEVICE_STATE_PREPARE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("In preparation"));
			result = _tmp3_;
			return result;
		}
		case NM_DEVICE_STATE_CONFIG:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Connecting…"));
			result = _tmp4_;
			return result;
		}
		case NM_DEVICE_STATE_NEED_AUTH:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Requires more information"));
			result = _tmp5_;
			return result;
		}
		case NM_DEVICE_STATE_IP_CONFIG:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Requesting addresses…"));
			result = _tmp6_;
			return result;
		}
		case NM_DEVICE_STATE_IP_CHECK:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Checking connection…"));
			result = _tmp7_;
			return result;
		}
		case NM_DEVICE_STATE_SECONDARIES:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Waiting for connection…"));
			result = _tmp8_;
			return result;
		}
		case NM_DEVICE_STATE_DEACTIVATING:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Disconnecting…"));
			result = _tmp9_;
			return result;
		}
		case NM_DEVICE_STATE_FAILED:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("Failed to connect"));
			result = _tmp10_;
			return result;
		}
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Cable unplugged"));
			result = _tmp11_;
			return result;
		}
		default:
		case NM_DEVICE_STATE_UNKNOWN:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (NETWORK_UNKNOWN_STR);
			result = _tmp12_;
			return result;
		}
	}
}

gchar*
network_utils_type_to_string (NMDeviceType type)
{
	gchar* result;
	switch (type) {
		case NM_DEVICE_TYPE_ETHERNET:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Ethernet"));
			result = _tmp0_;
			return result;
		}
		case NM_DEVICE_TYPE_WIFI:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Wi-Fi"));
			result = _tmp1_;
			return result;
		}
		case NM_DEVICE_TYPE_UNUSED1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Not used"));
			result = _tmp2_;
			return result;
		}
		case NM_DEVICE_TYPE_UNUSED2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Not used"));
			result = _tmp3_;
			return result;
		}
		case NM_DEVICE_TYPE_BT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Bluetooth"));
			result = _tmp4_;
			return result;
		}
		case NM_DEVICE_TYPE_OLPC_MESH:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("OLPC XO"));
			result = _tmp5_;
			return result;
		}
		case NM_DEVICE_TYPE_WIMAX:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("WiMAX Broadband"));
			result = _tmp6_;
			return result;
		}
		case NM_DEVICE_TYPE_MODEM:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Modem"));
			result = _tmp7_;
			return result;
		}
		case NM_DEVICE_TYPE_INFINIBAND:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("InfiniBand device"));
			result = _tmp8_;
			return result;
		}
		case NM_DEVICE_TYPE_BOND:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Bond master"));
			result = _tmp9_;
			return result;
		}
		case NM_DEVICE_TYPE_VLAN:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("VLAN Interface"));
			result = _tmp10_;
			return result;
		}
		case NM_DEVICE_TYPE_ADSL:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("ADSL Modem"));
			result = _tmp11_;
			return result;
		}
		case NM_DEVICE_TYPE_BRIDGE:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("Bridge master"));
			result = _tmp12_;
			return result;
		}
		default:
		case NM_DEVICE_TYPE_UNKNOWN:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup (NETWORK_UNKNOWN_STR);
			result = _tmp13_;
			return result;
		}
	}
}

NetworkUtils*
network_utils_construct (GType object_type)
{
	NetworkUtils* self = NULL;
	self = (NetworkUtils*) g_type_create_instance (object_type);
	return self;
}

NetworkUtils*
network_utils_new (void)
{
	return network_utils_construct (NETWORK_TYPE_UTILS);
}

static void
network_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
network_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		network_utils_unref (value->data[0].v_pointer);
	}
}

static void
network_value_utils_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = network_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
network_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
network_value_utils_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NetworkUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = network_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
network_value_utils_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	NetworkUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = network_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
network_param_spec_utils (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	NetworkParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NETWORK_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
network_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETWORK_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
network_value_set_utils (GValue* value,
                         gpointer v_object)
{
	NetworkUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETWORK_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETWORK_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		network_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		network_utils_unref (old);
	}
}

void
network_value_take_utils (GValue* value,
                          gpointer v_object)
{
	NetworkUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETWORK_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETWORK_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		network_utils_unref (old);
	}
}

static void
network_utils_class_init (NetworkUtilsClass * klass,
                          gpointer klass_data)
{
	network_utils_parent_class = g_type_class_peek_parent (klass);
	((NetworkUtilsClass *) klass)->finalize = network_utils_finalize;
}

static void
network_utils_instance_init (NetworkUtils * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
network_utils_finalize (NetworkUtils * obj)
{
	NetworkUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_UTILS, NetworkUtils);
	g_signal_handlers_destroy (self);
}

static GType
network_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { network_value_utils_init, network_value_utils_free_value, network_value_utils_copy_value, network_value_utils_peek_pointer, "p", network_value_utils_collect_value, "p", network_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NetworkUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkUtils), 0, (GInstanceInitFunc) network_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType network_utils_type_id;
	network_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NetworkUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return network_utils_type_id;
}

GType
network_utils_get_type (void)
{
	static volatile gsize network_utils_type_id__once = 0;
	if (g_once_init_enter (&network_utils_type_id__once)) {
		GType network_utils_type_id;
		network_utils_type_id = network_utils_get_type_once ();
		g_once_init_leave (&network_utils_type_id__once, network_utils_type_id);
	}
	return network_utils_type_id__once;
}

gpointer
network_utils_ref (gpointer instance)
{
	NetworkUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
network_utils_unref (gpointer instance)
{
	NetworkUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NETWORK_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

