/* NetworkManager.c generated by valac 0.56.17, the Vala compiler
 * generated from NetworkManager.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
/* TODO put them inside the class.*/

#include "network.h"
#include <NetworkManager.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_NETWORK_MANAGER_0_PROPERTY,
	NETWORK_NETWORK_MANAGER_CLIENT_PROPERTY,
	NETWORK_NETWORK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* network_network_manager_properties[NETWORK_NETWORK_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _NetworkNetworkManagerActivateHotspotData NetworkNetworkManagerActivateHotspotData;
typedef struct _NetworkNetworkManagerDeactivateHotspotData NetworkNetworkManagerDeactivateHotspotData;

struct _NetworkNetworkManagerPrivate {
	NMClient* _client;
};

struct _NetworkNetworkManagerActivateHotspotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkNetworkManager* self;
	NMDeviceWifi* wifi_device;
	gchar* ssid;
	gchar* key;
	NMConnection* selected;
	NMClient* _tmp0_;
	NMActiveConnection* _tmp1_;
	NMActiveConnection* _tmp2_;
	GError* _error_;
	GError* _tmp3_;
	const gchar* _tmp4_;
	NMConnection* hotspot_c;
	NMConnection* _tmp5_;
	NMSettingConnection* setting_connection;
	gchar* _tmp6_;
	gchar* _tmp7_;
	NMSettingConnection* _tmp8_;
	NMConnection* _tmp9_;
	NMSettingConnection* _tmp10_;
	NMSetting* _tmp11_;
	NMSettingWireless* setting_wireless;
	NMSettingWireless* _tmp12_;
	gchar* mode;
	NMDeviceWifiCapabilities caps;
	gchar* _tmp13_;
	gchar* _tmp14_;
	NMSettingWireless* _tmp15_;
	const gchar* _tmp16_;
	NMConnection* _tmp17_;
	NMSettingWireless* _tmp18_;
	NMSetting* _tmp19_;
	NMSettingIP4Config* ip4_setting;
	gchar* _tmp20_;
	NMSettingIP4Config* _tmp21_;
	NMConnection* _tmp22_;
	NMSettingIP4Config* _tmp23_;
	NMSetting* _tmp24_;
	NMSettingWireless* _tmp25_;
	guint8* _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	GBytes* _tmp29_;
	GBytes* _tmp30_;
	NMSettingWirelessSecurity* setting_wireless_security;
	NMSettingWirelessSecurity* _tmp31_;
	const gchar* _tmp32_;
	NMSettingWirelessSecurity* _tmp33_;
	NMSettingWirelessSecurity* _tmp34_;
	NMSettingWirelessSecurity* _tmp35_;
	NMSettingWirelessSecurity* _tmp36_;
	NMSettingWirelessSecurity* _tmp37_;
	NMSettingWirelessSecurity* _tmp38_;
	NMSettingWirelessSecurity* _tmp39_;
	NMSettingWirelessSecurity* _tmp40_;
	NMSettingWirelessSecurity* _tmp41_;
	NMSettingWirelessSecurity* _tmp42_;
	NMConnection* _tmp43_;
	NMSettingWirelessSecurity* _tmp44_;
	NMSetting* _tmp45_;
	NMClient* _tmp46_;
	NMConnection* _tmp47_;
	NMActiveConnection* _tmp48_;
	NMActiveConnection* _tmp49_;
	GError* _vala1__error_;
	GError* _tmp50_;
	const gchar* _tmp51_;
	GError* _inner_error0_;
};

struct _NetworkNetworkManagerDeactivateHotspotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkNetworkManager* self;
	NMDeviceWifi* wifi_device;
	NMActiveConnection* active_connection;
	NMActiveConnection* _tmp0_;
	NMClient* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

static gint NetworkNetworkManager_private_offset;
static gpointer network_network_manager_parent_class = NULL;
static NetworkNetworkManager* network_network_manager_network_manager;
static NetworkNetworkManager* network_network_manager_network_manager = NULL;

static void network_network_manager_activate_hotspot_data_free (gpointer _data);
static gboolean network_network_manager_activate_hotspot_co (NetworkNetworkManagerActivateHotspotData* _data_);
static void network_network_manager_activate_hotspot_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void network_network_manager_set_wpa_key (NMSettingWirelessSecurity* setting,
                                          const gchar* key);
static void network_network_manager_set_wep_key (NMSettingWirelessSecurity* setting,
                                          const gchar* key);
static void network_network_manager_deactivate_hotspot_data_free (gpointer _data);
static gboolean network_network_manager_deactivate_hotspot_co (NetworkNetworkManagerDeactivateHotspotData* _data_);
static GObject * network_network_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void network_network_manager_finalize (GObject * obj);
static GType network_network_manager_get_type_once (void);
static void _vala_network_network_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_network_network_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
network_network_manager_get_instance_private (NetworkNetworkManager* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkNetworkManager_private_offset);
}

NetworkNetworkManager*
network_network_manager_get_default (void)
{
	NetworkNetworkManager* _tmp0_;
	NetworkNetworkManager* _tmp2_;
	NetworkNetworkManager* result;
	_tmp0_ = network_network_manager_network_manager;
	if (_tmp0_ == NULL) {
		NetworkNetworkManager* _tmp1_;
		_tmp1_ = network_network_manager_new ();
		_g_object_unref0 (network_network_manager_network_manager);
		network_network_manager_network_manager = _tmp1_;
	}
	_tmp2_ = network_network_manager_network_manager;
	result = _tmp2_;
	return result;
}

static void
network_network_manager_activate_hotspot_data_free (gpointer _data)
{
	NetworkNetworkManagerActivateHotspotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wifi_device);
	_g_free0 (_data_->ssid);
	_g_free0 (_data_->key);
	_g_object_unref0 (_data_->selected);
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkNetworkManagerActivateHotspotData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
network_network_manager_activate_hotspot (NetworkNetworkManager* self,
                                          NMDeviceWifi* wifi_device,
                                          const gchar* ssid,
                                          const gchar* key,
                                          NMConnection* selected,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	NetworkNetworkManagerActivateHotspotData* _data_;
	NetworkNetworkManager* _tmp0_;
	NMDeviceWifi* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	NMConnection* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wifi_device != NULL);
	g_return_if_fail (ssid != NULL);
	g_return_if_fail (key != NULL);
	_data_ = g_slice_new0 (NetworkNetworkManagerActivateHotspotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_network_manager_activate_hotspot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (wifi_device);
	_g_object_unref0 (_data_->wifi_device);
	_data_->wifi_device = _tmp1_;
	_tmp2_ = g_strdup (ssid);
	_g_free0 (_data_->ssid);
	_data_->ssid = _tmp2_;
	_tmp3_ = g_strdup (key);
	_g_free0 (_data_->key);
	_data_->key = _tmp3_;
	_tmp4_ = _g_object_ref0 (selected);
	_g_object_unref0 (_data_->selected);
	_data_->selected = _tmp4_;
	network_network_manager_activate_hotspot_co (_data_);
}

void
network_network_manager_activate_hotspot_finish (NetworkNetworkManager* self,
                                                 GAsyncResult* _res_)
{
	NetworkNetworkManagerActivateHotspotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
network_network_manager_activate_hotspot_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	NetworkNetworkManagerActivateHotspotData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_network_manager_activate_hotspot_co (_data_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
network_network_manager_activate_hotspot_co (NetworkNetworkManagerActivateHotspotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->selected != NULL) {
		{
			_data_->_tmp0_ = _data_->self->priv->_client;
			_data_->_state_ = 1;
			nm_client_activate_connection_async (_data_->_tmp0_, _data_->selected, (NMDevice*) _data_->wifi_device, NULL, NULL, network_network_manager_activate_hotspot_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = nm_client_activate_connection_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp2_ = _data_->_tmp1_;
			_g_object_unref0 (_data_->_tmp2_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp3_ = _data_->_error_;
			_data_->_tmp4_ = _data_->_tmp3_->message;
			g_critical ("NetworkManager.vala:46: %s", _data_->_tmp4_);
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = nm_simple_connection_new ();
	_data_->hotspot_c = _data_->_tmp5_;
	_data_->_tmp6_ = g_strdup ("802-11-wireless");
	_data_->_tmp7_ = g_strdup ("Hotspot");
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = (NMSettingConnection*) nm_setting_connection_new ();
	g_object_set (_data_->_tmp8_, "type", _data_->_tmp6_, NULL);
	_g_free0 (_data_->_tmp6_);
	g_object_set (_data_->_tmp8_, "id", _data_->_tmp7_, NULL);
	_g_free0 (_data_->_tmp7_);
	g_object_set (_data_->_tmp8_, "autoconnect", FALSE, NULL);
	_data_->setting_connection = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->hotspot_c;
	_data_->_tmp10_ = _data_->setting_connection;
	_data_->_tmp11_ = _g_object_ref0 ((NMSetting*) _data_->_tmp10_);
	nm_connection_add_setting (_data_->_tmp9_, _data_->_tmp11_);
	_data_->_tmp12_ = (NMSettingWireless*) nm_setting_wireless_new ();
	_data_->setting_wireless = _data_->_tmp12_;
	_data_->mode = NULL;
	_data_->caps = nm_device_wifi_get_capabilities (_data_->wifi_device);
	if ((_data_->caps & NM_WIFI_DEVICE_CAP_AP) != 0) {
		_data_->_tmp13_ = g_strdup (NM_SETTING_WIRELESS_MODE_AP);
		_g_free0 (_data_->mode);
		_data_->mode = _data_->_tmp13_;
	} else {
		_data_->_tmp14_ = g_strdup (NM_SETTING_WIRELESS_MODE_ADHOC);
		_g_free0 (_data_->mode);
		_data_->mode = _data_->_tmp14_;
	}
	_data_->_tmp15_ = _data_->setting_wireless;
	_data_->_tmp16_ = _data_->mode;
	g_object_set (_data_->_tmp15_, "mode", _data_->_tmp16_, NULL);
	_data_->_tmp17_ = _data_->hotspot_c;
	_data_->_tmp18_ = _data_->setting_wireless;
	_data_->_tmp19_ = _g_object_ref0 ((NMSetting*) _data_->_tmp18_);
	nm_connection_add_setting (_data_->_tmp17_, _data_->_tmp19_);
	_data_->_tmp20_ = g_strdup ("shared");
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = (NMSettingIP4Config*) nm_setting_ip4_config_new ();
	g_object_set ((NMSettingIPConfig*) _data_->_tmp21_, "method", _data_->_tmp20_, NULL);
	_g_free0 (_data_->_tmp20_);
	_data_->ip4_setting = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->hotspot_c;
	_data_->_tmp23_ = _data_->ip4_setting;
	_data_->_tmp24_ = _g_object_ref0 ((NMSetting*) _data_->_tmp23_);
	nm_connection_add_setting (_data_->_tmp22_, _data_->_tmp24_);
	_data_->_tmp25_ = _data_->setting_wireless;
	_data_->_tmp27_ = 0;
	_data_->_tmp26_ = string_get_data (_data_->ssid, &_data_->_tmp27_);
	_data_->_tmp26__length1 = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->_tmp26_;
	_data_->_tmp28__length1 = _data_->_tmp26__length1;
	_data_->_tmp29_ = g_bytes_new (_data_->_tmp28_, _data_->_tmp28__length1);
	_data_->_tmp30_ = _data_->_tmp29_;
	g_object_set (_data_->_tmp25_, "ssid", _data_->_tmp30_, NULL);
	_g_bytes_unref0 (_data_->_tmp30_);
	_data_->_tmp31_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
	_data_->setting_wireless_security = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->mode;
	if (g_strcmp0 (_data_->_tmp32_, NM_SETTING_WIRELESS_MODE_AP) == 0) {
		if ((_data_->caps & NM_WIFI_DEVICE_CAP_RSN) != 0) {
			_data_->_tmp33_ = _data_->setting_wireless_security;
			network_network_manager_set_wpa_key (_data_->_tmp33_, _data_->key);
			_data_->_tmp34_ = _data_->setting_wireless_security;
			nm_setting_wireless_security_add_proto (_data_->_tmp34_, "rsn");
			_data_->_tmp35_ = _data_->setting_wireless_security;
			nm_setting_wireless_security_add_pairwise (_data_->_tmp35_, "ccmp");
			_data_->_tmp36_ = _data_->setting_wireless_security;
			nm_setting_wireless_security_add_group (_data_->_tmp36_, "ccmp");
		} else {
			if ((_data_->caps & NM_WIFI_DEVICE_CAP_WPA) != 0) {
				_data_->_tmp37_ = _data_->setting_wireless_security;
				network_network_manager_set_wpa_key (_data_->_tmp37_, _data_->key);
				_data_->_tmp38_ = _data_->setting_wireless_security;
				nm_setting_wireless_security_add_proto (_data_->_tmp38_, "wpa");
				_data_->_tmp39_ = _data_->setting_wireless_security;
				nm_setting_wireless_security_add_pairwise (_data_->_tmp39_, "tkip");
				_data_->_tmp40_ = _data_->setting_wireless_security;
				nm_setting_wireless_security_add_group (_data_->_tmp40_, "tkip");
			} else {
				_data_->_tmp41_ = _data_->setting_wireless_security;
				network_network_manager_set_wep_key (_data_->_tmp41_, _data_->key);
			}
		}
	} else {
		_data_->_tmp42_ = _data_->setting_wireless_security;
		network_network_manager_set_wep_key (_data_->_tmp42_, _data_->key);
	}
	_data_->_tmp43_ = _data_->hotspot_c;
	_data_->_tmp44_ = _data_->setting_wireless_security;
	_data_->_tmp45_ = _g_object_ref0 ((NMSetting*) _data_->_tmp44_);
	nm_connection_add_setting (_data_->_tmp43_, _data_->_tmp45_);
	{
		_data_->_tmp46_ = _data_->self->priv->_client;
		_data_->_tmp47_ = _data_->hotspot_c;
		_data_->_state_ = 2;
		nm_client_add_and_activate_connection_async (_data_->_tmp46_, _data_->_tmp47_, (NMDevice*) _data_->wifi_device, NULL, NULL, network_network_manager_activate_hotspot_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp48_ = nm_client_add_and_activate_connection_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp49_ = _data_->_tmp48_;
		_g_object_unref0 (_data_->_tmp49_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp50_ = _data_->_vala1__error_;
		_data_->_tmp51_ = _data_->_tmp50_->message;
		g_critical ("NetworkManager.vala:106: %s", _data_->_tmp51_);
		_g_error_free0 (_data_->_vala1__error_);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->setting_wireless_security);
		_g_object_unref0 (_data_->ip4_setting);
		_g_free0 (_data_->mode);
		_g_object_unref0 (_data_->setting_wireless);
		_g_object_unref0 (_data_->setting_connection);
		_g_object_unref0 (_data_->hotspot_c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->setting_wireless_security);
	_g_object_unref0 (_data_->ip4_setting);
	_g_free0 (_data_->mode);
	_g_object_unref0 (_data_->setting_wireless);
	_g_object_unref0 (_data_->setting_connection);
	_g_object_unref0 (_data_->hotspot_c);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
network_network_manager_deactivate_hotspot_data_free (gpointer _data)
{
	NetworkNetworkManagerDeactivateHotspotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wifi_device);
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkNetworkManagerDeactivateHotspotData, _data_);
}

void
network_network_manager_deactivate_hotspot (NetworkNetworkManager* self,
                                            NMDeviceWifi* wifi_device,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	NetworkNetworkManagerDeactivateHotspotData* _data_;
	NetworkNetworkManager* _tmp0_;
	NMDeviceWifi* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wifi_device != NULL);
	_data_ = g_slice_new0 (NetworkNetworkManagerDeactivateHotspotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_network_manager_deactivate_hotspot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (wifi_device);
	_g_object_unref0 (_data_->wifi_device);
	_data_->wifi_device = _tmp1_;
	network_network_manager_deactivate_hotspot_co (_data_);
}

void
network_network_manager_deactivate_hotspot_finish (NetworkNetworkManager* self,
                                                   GAsyncResult* _res_)
{
	NetworkNetworkManagerDeactivateHotspotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
network_network_manager_deactivate_hotspot_co (NetworkNetworkManagerDeactivateHotspotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = nm_device_get_active_connection ((NMDevice*) _data_->wifi_device);
	_data_->active_connection = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->_client;
		nm_client_deactivate_connection (_data_->_tmp1_, _data_->active_connection, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_critical ("NetworkManager.vala:115: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
network_network_manager_set_wpa_key (NMSettingWirelessSecurity* setting,
                                     const gchar* key)
{
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_object_set (setting, "key-mgmt", "wpa-psk", NULL);
	g_object_set (setting, "psk", key, NULL);
}

static void
network_network_manager_set_wep_key (NMSettingWirelessSecurity* setting,
                                     const gchar* key)
{
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_object_set (setting, "key-mgmt", "none", NULL);
	g_object_set (setting, "wep-key0", key, NULL);
	g_object_set (setting, "wep-key-type", NM_WEP_KEY_TYPE_PASSPHRASE, NULL);
}

NetworkNetworkManager*
network_network_manager_construct (GType object_type)
{
	NetworkNetworkManager * self = NULL;
	self = (NetworkNetworkManager*) g_object_new (object_type, NULL);
	return self;
}

NetworkNetworkManager*
network_network_manager_new (void)
{
	return network_network_manager_construct (NETWORK_TYPE_NETWORK_MANAGER);
}

NMClient*
network_network_manager_get_client (NetworkNetworkManager* self)
{
	NMClient* result;
	NMClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_client;
	result = _tmp0_;
	return result;
}

static void
network_network_manager_set_client (NetworkNetworkManager* self,
                                    NMClient* value)
{
	NMClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_network_manager_get_client (self);
	if (old_value != value) {
		NMClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_client);
		self->priv->_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_network_manager_properties[NETWORK_NETWORK_MANAGER_CLIENT_PROPERTY]);
	}
}

static GObject *
network_network_manager_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkNetworkManager * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (network_network_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_NETWORK_MANAGER, NetworkNetworkManager);
	{
		NMClient* _tmp0_ = NULL;
		NMClient* _tmp1_;
		_tmp1_ = nm_client_new (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		network_network_manager_set_client (self, _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("NetworkManager.vala:37: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
network_network_manager_class_init (NetworkNetworkManagerClass * klass,
                                    gpointer klass_data)
{
	network_network_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkNetworkManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_network_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_network_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_network_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_network_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_NETWORK_MANAGER_CLIENT_PROPERTY, network_network_manager_properties[NETWORK_NETWORK_MANAGER_CLIENT_PROPERTY] = g_param_spec_object ("client", "client", "client", nm_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
network_network_manager_instance_init (NetworkNetworkManager * self,
                                       gpointer klass)
{
	self->priv = network_network_manager_get_instance_private (self);
}

static void
network_network_manager_finalize (GObject * obj)
{
	NetworkNetworkManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_NETWORK_MANAGER, NetworkNetworkManager);
	_g_object_unref0 (self->priv->_client);
	G_OBJECT_CLASS (network_network_manager_parent_class)->finalize (obj);
}

static GType
network_network_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkNetworkManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_network_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkNetworkManager), 0, (GInstanceInitFunc) network_network_manager_instance_init, NULL };
	GType network_network_manager_type_id;
	network_network_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetworkNetworkManager", &g_define_type_info, 0);
	NetworkNetworkManager_private_offset = g_type_add_instance_private (network_network_manager_type_id, sizeof (NetworkNetworkManagerPrivate));
	return network_network_manager_type_id;
}

GType
network_network_manager_get_type (void)
{
	static volatile gsize network_network_manager_type_id__once = 0;
	if (g_once_init_enter (&network_network_manager_type_id__once)) {
		GType network_network_manager_type_id;
		network_network_manager_type_id = network_network_manager_get_type_once ();
		g_once_init_leave (&network_network_manager_type_id__once, network_network_manager_type_id);
	}
	return network_network_manager_type_id__once;
}

static void
_vala_network_network_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	NetworkNetworkManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_NETWORK_MANAGER, NetworkNetworkManager);
	switch (property_id) {
		case NETWORK_NETWORK_MANAGER_CLIENT_PROPERTY:
		g_value_set_object (value, network_network_manager_get_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_network_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	NetworkNetworkManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_NETWORK_MANAGER, NetworkNetworkManager);
	switch (property_id) {
		case NETWORK_NETWORK_MANAGER_CLIENT_PROPERTY:
		network_network_manager_set_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

