/* SidebarListInterface.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SidebarListInterface.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0+
 * SPDX-FileCopyrightText: 2020-2023 elementary, Inc. (https://elementary.io)
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */

#include "pantheon-files-core.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static void sidebar_sidebar_list_interface_real_refresh_info (SidebarSidebarListInterface* self);
static void sidebar_sidebar_list_interface_real_rename_bookmark_by_uri (SidebarSidebarListInterface* self,
                                                                 const gchar* uri,
                                                                 const gchar* new_name);
static void sidebar_sidebar_list_interface_real_open_item (SidebarSidebarListInterface* self,
                                                    SidebarSidebarItemInterface* item,
                                                    FilesOpenFlag flag);
static guint32 sidebar_sidebar_list_interface_real_add_plugin_item (SidebarSidebarListInterface* self,
                                                             FilesSidebarPluginItem* plugin_item);
static void sidebar_sidebar_list_interface_real_clear (SidebarSidebarListInterface* self);
static gboolean sidebar_sidebar_list_interface_real_has_uri (SidebarSidebarListInterface* self,
                                                      const gchar* uri,
                                                      GtkListBoxRow** row);
static gboolean sidebar_sidebar_list_interface_real_select_uri (SidebarSidebarListInterface* self,
                                                         const gchar* uri);
static gboolean sidebar_sidebar_list_interface_real_remove_item_by_id (SidebarSidebarListInterface* self,
                                                                guint32 id);
static gboolean sidebar_sidebar_list_interface_real_add_favorite (SidebarSidebarListInterface* self,
                                                           const gchar* uri,
                                                           const gchar* label,
                                                           gint index);
static SidebarSidebarItemInterface* sidebar_sidebar_list_interface_real_get_item_at_index (SidebarSidebarListInterface* self,
                                                                                    gint index);
static gboolean sidebar_sidebar_list_interface_real_move_item_after (SidebarSidebarListInterface* self,
                                                              SidebarSidebarItemInterface* item,
                                                              gint target_index);
static gboolean sidebar_sidebar_list_interface_real_is_drop_target (SidebarSidebarListInterface* self);
static GType sidebar_sidebar_list_interface_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
sidebar_sidebar_list_interface_select_item (SidebarSidebarListInterface* self,
                                            GtkListBoxRow* item)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->select_item) {
		_iface_->select_item (self, item);
	}
}

void
sidebar_sidebar_list_interface_unselect_all_items (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->unselect_all_items) {
		_iface_->unselect_all_items (self);
	}
}

void
sidebar_sidebar_list_interface_refresh (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->refresh) {
		_iface_->refresh (self);
	}
}

static void
sidebar_sidebar_list_interface_real_refresh_info (SidebarSidebarListInterface* self)
{
}

void
sidebar_sidebar_list_interface_refresh_info (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->refresh_info) {
		_iface_->refresh_info (self);
	}
}

static void
sidebar_sidebar_list_interface_real_rename_bookmark_by_uri (SidebarSidebarListInterface* self,
                                                            const gchar* uri,
                                                            const gchar* new_name)
{
	g_return_if_fail (uri != NULL);
	g_return_if_fail (new_name != NULL);
}

void
sidebar_sidebar_list_interface_rename_bookmark_by_uri (SidebarSidebarListInterface* self,
                                                       const gchar* uri,
                                                       const gchar* new_name)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->rename_bookmark_by_uri) {
		_iface_->rename_bookmark_by_uri (self, uri, new_name);
	}
}

static void
sidebar_sidebar_list_interface_real_open_item (SidebarSidebarListInterface* self,
                                               SidebarSidebarItemInterface* item,
                                               FilesOpenFlag flag)
{
	FilesSidebarInterface* _tmp0_;
	FilesSidebarInterface* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (item != NULL);
	_tmp0_ = sidebar_sidebar_list_interface_get_sidebar (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_sidebar_item_interface_get_uri (item);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (_tmp1_, "path-change-request", _tmp3_, flag);
}

void
sidebar_sidebar_list_interface_open_item (SidebarSidebarListInterface* self,
                                          SidebarSidebarItemInterface* item,
                                          FilesOpenFlag flag)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->open_item) {
		_iface_->open_item (self, item, flag);
	}
}

static guint32
sidebar_sidebar_list_interface_real_add_plugin_item (SidebarSidebarListInterface* self,
                                                     FilesSidebarPluginItem* plugin_item)
{
	guint32 result;
	g_return_val_if_fail (plugin_item != NULL, 0U);
	result = (guint32) 0;
	return result;
}

guint32
sidebar_sidebar_list_interface_add_plugin_item (SidebarSidebarListInterface* self,
                                                FilesSidebarPluginItem* plugin_item)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->add_plugin_item) {
		return _iface_->add_plugin_item (self, plugin_item);
	}
	return 0U;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sidebar_sidebar_list_interface_real_clear (SidebarSidebarListInterface* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, 0);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	row = _tmp3_;
	while (TRUE) {
		GtkListBoxRow* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBox* _tmp6_;
		GtkListBoxRow* _tmp7_;
		GtkListBoxRow* _tmp8_;
		GtkListBox* _tmp10_;
		GtkListBox* _tmp11_;
		GtkListBoxRow* _tmp12_;
		GtkListBoxRow* _tmp13_;
		_tmp4_ = row;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = sidebar_sidebar_list_interface_get_list_box (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = row;
		gtk_container_remove ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
		_tmp8_ = row;
		if (SIDEBAR_IS_SIDEBAR_ITEM_INTERFACE (_tmp8_)) {
			GtkListBoxRow* _tmp9_;
			_tmp9_ = row;
			sidebar_sidebar_item_interface_destroy_bookmark (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, SidebarSidebarItemInterface));
		}
		_tmp10_ = sidebar_sidebar_list_interface_get_list_box (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_list_box_get_row_at_index (_tmp11_, 0);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (row);
		row = _tmp13_;
	}
	_g_object_unref0 (row);
}

void
sidebar_sidebar_list_interface_clear (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->clear) {
		_iface_->clear (self);
	}
}

static gboolean
sidebar_sidebar_list_interface_real_has_uri (SidebarSidebarListInterface* self,
                                             const gchar* uri,
                                             GtkListBoxRow** row)
{
	GtkListBoxRow* _vala_row = NULL;
	gint index = 0;
	GtkListBoxRow* child = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	_vala_row = NULL;
	index = 0;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	child = _tmp2_;
	while (TRUE) {
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GtkListBox* _tmp9_;
		GtkListBox* _tmp10_;
		gint _tmp11_;
		GtkListBoxRow* _tmp12_;
		_tmp3_ = child;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = child;
		if (SIDEBAR_IS_SIDEBAR_ITEM_INTERFACE (_tmp4_)) {
			GtkListBoxRow* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = child;
			_tmp6_ = sidebar_sidebar_item_interface_get_uri (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, SidebarSidebarItemInterface));
			_tmp7_ = _tmp6_;
			if (g_strcmp0 (_tmp7_, uri) == 0) {
				GtkListBoxRow* _tmp8_;
				_tmp8_ = child;
				_vala_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_row_get_type (), GtkListBoxRow);
				result = TRUE;
				if (row) {
					*row = _vala_row;
				}
				return result;
			}
		}
		_tmp9_ = sidebar_sidebar_list_interface_get_list_box (self);
		_tmp10_ = _tmp9_;
		index = index + 1;
		_tmp11_ = index;
		_tmp12_ = gtk_list_box_get_row_at_index (_tmp10_, _tmp11_);
		child = _tmp12_;
	}
	result = FALSE;
	if (row) {
		*row = _vala_row;
	}
	return result;
}

gboolean
sidebar_sidebar_list_interface_has_uri (SidebarSidebarListInterface* self,
                                        const gchar* uri,
                                        GtkListBoxRow** row)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->has_uri) {
		return _iface_->has_uri (self, uri, row);
	}
	return FALSE;
}

static gboolean
sidebar_sidebar_list_interface_real_select_uri (SidebarSidebarListInterface* self,
                                                const gchar* uri)
{
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	sidebar_sidebar_list_interface_unselect_all_items (self);
	row = NULL;
	_tmp1_ = sidebar_sidebar_list_interface_has_uri (self, uri, &_tmp0_);
	_g_object_unref0 (row);
	_tmp2_ = _g_object_ref0 (_tmp0_);
	row = _tmp2_;
	if (_tmp1_) {
		GtkListBoxRow* _tmp3_;
		_tmp3_ = row;
		sidebar_sidebar_list_interface_select_item (self, _tmp3_);
		result = TRUE;
		_g_object_unref0 (row);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (row);
	return result;
}

gboolean
sidebar_sidebar_list_interface_select_uri (SidebarSidebarListInterface* self,
                                           const gchar* uri)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->select_uri) {
		return _iface_->select_uri (self, uri);
	}
	return FALSE;
}

static gboolean
sidebar_sidebar_list_interface_real_remove_item_by_id (SidebarSidebarListInterface* self,
                                                       guint32 id)
{
	gint index = 0;
	GtkListBoxRow* child = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean result;
	index = 0;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_row_at_index (_tmp1_, index);
	child = _tmp2_;
	while (TRUE) {
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GtkListBox* _tmp16_;
		GtkListBox* _tmp17_;
		gint _tmp18_;
		GtkListBoxRow* _tmp19_;
		_tmp3_ = child;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = child;
		if (SIDEBAR_IS_SIDEBAR_ITEM_INTERFACE (_tmp4_)) {
			SidebarSidebarItemInterface* row = NULL;
			GtkListBoxRow* _tmp5_;
			SidebarSidebarItemInterface* _tmp6_;
			guint32 _tmp7_;
			guint32 _tmp8_;
			_tmp5_ = child;
			row = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, SidebarSidebarItemInterface);
			_tmp6_ = row;
			_tmp7_ = sidebar_sidebar_item_interface_get_id (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ == id) {
				SidebarSidebarItemInterface* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = row;
				_tmp10_ = sidebar_sidebar_item_interface_get_permanent (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					g_critical ("SidebarListInterface.vala:76: Attempt to remove permanent row ignored");
					result = FALSE;
					return result;
				} else {
					GtkListBox* _tmp12_;
					GtkListBox* _tmp13_;
					GtkListBoxRow* _tmp14_;
					SidebarSidebarItemInterface* _tmp15_;
					_tmp12_ = sidebar_sidebar_list_interface_get_list_box (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = child;
					gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
					_tmp15_ = row;
					sidebar_sidebar_item_interface_destroy_bookmark (_tmp15_);
					result = TRUE;
					return result;
				}
			}
		}
		_tmp16_ = sidebar_sidebar_list_interface_get_list_box (self);
		_tmp17_ = _tmp16_;
		index = index + 1;
		_tmp18_ = index;
		_tmp19_ = gtk_list_box_get_row_at_index (_tmp17_, _tmp18_);
		child = _tmp19_;
	}
	result = FALSE;
	return result;
}

gboolean
sidebar_sidebar_list_interface_remove_item_by_id (SidebarSidebarListInterface* self,
                                                  guint32 id)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->remove_item_by_id) {
		return _iface_->remove_item_by_id (self, id);
	}
	return FALSE;
}

static gboolean
sidebar_sidebar_list_interface_real_add_favorite (SidebarSidebarListInterface* self,
                                                  const gchar* uri,
                                                  const gchar* label,
                                                  gint index)
{
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (label != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
sidebar_sidebar_list_interface_add_favorite (SidebarSidebarListInterface* self,
                                             const gchar* uri,
                                             const gchar* label,
                                             gint index)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->add_favorite) {
		return _iface_->add_favorite (self, uri, label, index);
	}
	return FALSE;
}

static SidebarSidebarItemInterface*
sidebar_sidebar_list_interface_real_get_item_at_index (SidebarSidebarListInterface* self,
                                                       gint index)
{
	SidebarSidebarItemInterface* result;
	result = NULL;
	return result;
}

SidebarSidebarItemInterface*
sidebar_sidebar_list_interface_get_item_at_index (SidebarSidebarListInterface* self,
                                                  gint index)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_item_at_index) {
		return _iface_->get_item_at_index (self, index);
	}
	return NULL;
}

static gboolean
sidebar_sidebar_list_interface_real_move_item_after (SidebarSidebarListInterface* self,
                                                     SidebarSidebarItemInterface* item,
                                                     gint target_index)
{
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
sidebar_sidebar_list_interface_move_item_after (SidebarSidebarListInterface* self,
                                                SidebarSidebarItemInterface* item,
                                                gint target_index)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->move_item_after) {
		return _iface_->move_item_after (self, item, target_index);
	}
	return FALSE;
}

static gboolean
sidebar_sidebar_list_interface_real_is_drop_target (SidebarSidebarListInterface* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
sidebar_sidebar_list_interface_is_drop_target (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->is_drop_target) {
		return _iface_->is_drop_target (self);
	}
	return FALSE;
}

void
sidebar_sidebar_list_interface_focus (SidebarSidebarListInterface* self)
{
	GtkListBoxRow* focus_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp9_;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_list_box_get_selected_row (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	focus_row = _tmp3_;
	_tmp4_ = focus_row;
	if (_tmp4_ == NULL) {
		GtkListBox* _tmp5_;
		GtkListBox* _tmp6_;
		GtkListBoxRow* _tmp7_;
		GtkListBoxRow* _tmp8_;
		_tmp5_ = sidebar_sidebar_list_interface_get_list_box (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = gtk_list_box_get_row_at_index (_tmp6_, 0);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (focus_row);
		focus_row = _tmp8_;
	}
	_tmp9_ = focus_row;
	gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	_g_object_unref0 (focus_row);
}

FilesSidebarInterface*
sidebar_sidebar_list_interface_get_sidebar (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_sidebar) {
		return _iface_->get_sidebar (self);
	}
	return NULL;
}

void
sidebar_sidebar_list_interface_set_sidebar (SidebarSidebarListInterface* self,
                                            FilesSidebarInterface* value)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_sidebar) {
		_iface_->set_sidebar (self, value);
	}
}

GtkListBox*
sidebar_sidebar_list_interface_get_list_box (SidebarSidebarListInterface* self)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_list_box) {
		return _iface_->get_list_box (self);
	}
	return NULL;
}

void
sidebar_sidebar_list_interface_set_list_box (SidebarSidebarListInterface* self,
                                             GtkListBox* value)
{
	SidebarSidebarListInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SIDEBAR_SIDEBAR_LIST_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_list_box) {
		_iface_->set_list_box (self, value);
	}
}

static void
sidebar_sidebar_list_interface_default_init (SidebarSidebarListInterfaceIface * iface,
                                             gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_object ("sidebar", "sidebar", "sidebar", FILES_TYPE_SIDEBAR_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_interface_install_property (iface, g_param_spec_object ("list-box", "list-box", "list-box", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	iface->refresh_info = sidebar_sidebar_list_interface_real_refresh_info;
	iface->rename_bookmark_by_uri = sidebar_sidebar_list_interface_real_rename_bookmark_by_uri;
	iface->open_item = sidebar_sidebar_list_interface_real_open_item;
	iface->add_plugin_item = sidebar_sidebar_list_interface_real_add_plugin_item;
	iface->clear = sidebar_sidebar_list_interface_real_clear;
	iface->has_uri = sidebar_sidebar_list_interface_real_has_uri;
	iface->select_uri = sidebar_sidebar_list_interface_real_select_uri;
	iface->remove_item_by_id = sidebar_sidebar_list_interface_real_remove_item_by_id;
	iface->add_favorite = sidebar_sidebar_list_interface_real_add_favorite;
	iface->get_item_at_index = sidebar_sidebar_list_interface_real_get_item_at_index;
	iface->move_item_after = sidebar_sidebar_list_interface_real_move_item_after;
	iface->is_drop_target = sidebar_sidebar_list_interface_real_is_drop_target;
}

 G_GNUC_NO_INLINE static GType
sidebar_sidebar_list_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarSidebarListInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_sidebar_list_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType sidebar_sidebar_list_interface_type_id;
	sidebar_sidebar_list_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "SidebarSidebarListInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (sidebar_sidebar_list_interface_type_id, G_TYPE_OBJECT);
	return sidebar_sidebar_list_interface_type_id;
}

GType
sidebar_sidebar_list_interface_get_type (void)
{
	static volatile gsize sidebar_sidebar_list_interface_type_id__once = 0;
	if (g_once_init_enter (&sidebar_sidebar_list_interface_type_id__once)) {
		GType sidebar_sidebar_list_interface_type_id;
		sidebar_sidebar_list_interface_type_id = sidebar_sidebar_list_interface_get_type_once ();
		g_once_init_leave (&sidebar_sidebar_list_interface_type_id__once, sidebar_sidebar_list_interface_type_id);
	}
	return sidebar_sidebar_list_interface_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

