/* theme-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from theme-manager.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2020 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;
typedef struct _ThemeManagerPrivate ThemeManagerPrivate;
enum  {
	THEME_MANAGER_0_PROPERTY,
	THEME_MANAGER_THEME_PROPERTY,
	THEME_MANAGER_BACKGROUND_RED_PROPERTY,
	THEME_MANAGER_BACKGROUND_GREEN_PROPERTY,
	THEME_MANAGER_BACKGROUND_BLUE_PROPERTY,
	THEME_MANAGER_BACKGROUND_RADIUS_PROPERTY,
	THEME_MANAGER_TEXTURE_ALPHA_PROPERTY,
	THEME_MANAGER_APPLY_TEXTURE_PROPERTY,
	THEME_MANAGER_BORDER_RED_PROPERTY,
	THEME_MANAGER_BORDER_GREEN_PROPERTY,
	THEME_MANAGER_BORDER_BLUE_PROPERTY,
	THEME_MANAGER_BORDER_WIDTH_PROPERTY,
	THEME_MANAGER_HALF_BORDER_WIDTH_PROPERTY,
	THEME_MANAGER_SPACING_RED_PROPERTY,
	THEME_MANAGER_SPACING_GREEN_PROPERTY,
	THEME_MANAGER_SPACING_BLUE_PROPERTY,
	THEME_MANAGER_SPACING_WIDTH_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_HARD_RED_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_HARD_GREEN_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_HARD_BLUE_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_HARD_ALPHA_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_SOFT_RED_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_SOFT_GREEN_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_SOFT_BLUE_PROPERTY,
	THEME_MANAGER_HIGHLIGHT_SOFT_ALPHA_PROPERTY,
	THEME_MANAGER_SOUND_FLIP_PROPERTY,
	THEME_MANAGER_SOUND_GAMEOVER_PROPERTY,
	THEME_MANAGER_TILESET_HANDLE_PROPERTY,
	THEME_MANAGER_NUM_PROPERTIES
};
static GParamSpec* theme_manager_properties[THEME_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	THEME_MANAGER_THEME_CHANGED_SIGNAL,
	THEME_MANAGER_NUM_SIGNALS
};
static guint theme_manager_signals[THEME_MANAGER_NUM_SIGNALS] = {0};

struct _ThemeManager {
	GObject parent_instance;
	ThemeManagerPrivate * priv;
};

struct _ThemeManagerClass {
	GObjectClass parent_class;
};

struct _ThemeManagerPrivate {
	gboolean theme_set;
	gchar* _theme;
	gchar* pieces_file;
	gdouble _background_red;
	gdouble _background_green;
	gdouble _background_blue;
	gint _background_radius;
	gdouble _texture_alpha;
	gboolean _apply_texture;
	gdouble _border_red;
	gdouble _border_green;
	gdouble _border_blue;
	gint _border_width;
	gdouble _half_border_width;
	gdouble _spacing_red;
	gdouble _spacing_green;
	gdouble _spacing_blue;
	gint _spacing_width;
	gdouble _highlight_hard_red;
	gdouble _highlight_hard_green;
	gdouble _highlight_hard_blue;
	gdouble _highlight_hard_alpha;
	gdouble _highlight_soft_red;
	gdouble _highlight_soft_green;
	gdouble _highlight_soft_blue;
	gdouble _highlight_soft_alpha;
	gchar* _sound_flip;
	gchar* _sound_gameover;
	gboolean handle_loaded;
	RsvgHandle* _tileset_handle;
	gchar* old_pieces_file;
};

static gint ThemeManager_private_offset;
static gpointer theme_manager_parent_class = NULL;

VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
VALA_EXTERN void theme_manager_gtk_theme_changed (ThemeManager* self);
static const gchar* theme_manager_get_theme (ThemeManager* self);
VALA_EXTERN void theme_manager_set_theme (ThemeManager* self,
                              const gchar* value);
static void theme_manager_set_default_theme (ThemeManager* self,
                                      GKeyFile** key);
static inline void theme_manager_load_theme (ThemeManager* self,
                               GKeyFile* key);
static inline void theme_manager_load_handle (ThemeManager* self);
static void theme_manager_set_background_red (ThemeManager* self,
                                       gdouble value);
static void theme_manager_set_background_green (ThemeManager* self,
                                         gdouble value);
static void theme_manager_set_background_blue (ThemeManager* self,
                                        gdouble value);
static void theme_manager_set_background_radius (ThemeManager* self,
                                          gint value);
static void theme_manager_set_texture_alpha (ThemeManager* self,
                                      gdouble value);
VALA_EXTERN gdouble theme_manager_get_texture_alpha (ThemeManager* self);
static void theme_manager_set_apply_texture (ThemeManager* self,
                                      gboolean value);
static void theme_manager_set_border_red (ThemeManager* self,
                                   gdouble value);
static void theme_manager_set_border_green (ThemeManager* self,
                                     gdouble value);
static void theme_manager_set_border_blue (ThemeManager* self,
                                    gdouble value);
static void theme_manager_set_border_width (ThemeManager* self,
                                     gint value);
VALA_EXTERN gint theme_manager_get_border_width (ThemeManager* self);
static void theme_manager_set_half_border_width (ThemeManager* self,
                                          gdouble value);
static void theme_manager_set_spacing_red (ThemeManager* self,
                                    gdouble value);
static void theme_manager_set_spacing_green (ThemeManager* self,
                                      gdouble value);
static void theme_manager_set_spacing_blue (ThemeManager* self,
                                     gdouble value);
static void theme_manager_set_spacing_width (ThemeManager* self,
                                      gint value);
static void theme_manager_set_highlight_hard_red (ThemeManager* self,
                                           gdouble value);
static void theme_manager_set_highlight_hard_green (ThemeManager* self,
                                             gdouble value);
static void theme_manager_set_highlight_hard_blue (ThemeManager* self,
                                            gdouble value);
static void theme_manager_set_highlight_hard_alpha (ThemeManager* self,
                                             gdouble value);
static void theme_manager_set_highlight_soft_red (ThemeManager* self,
                                           gdouble value);
static void theme_manager_set_highlight_soft_green (ThemeManager* self,
                                             gdouble value);
static void theme_manager_set_highlight_soft_blue (ThemeManager* self,
                                            gdouble value);
static void theme_manager_set_highlight_soft_alpha (ThemeManager* self,
                                             gdouble value);
static void theme_manager_set_sound_flip (ThemeManager* self,
                                   const gchar* value);
static void theme_manager_set_sound_gameover (ThemeManager* self,
                                       const gchar* value);
VALA_EXTERN ThemeManager* theme_manager_new (void);
VALA_EXTERN ThemeManager* theme_manager_construct (GType object_type);
VALA_EXTERN gdouble theme_manager_get_background_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_background_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_background_blue (ThemeManager* self);
VALA_EXTERN gint theme_manager_get_background_radius (ThemeManager* self);
VALA_EXTERN gboolean theme_manager_get_apply_texture (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_border_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_border_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_border_blue (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_half_border_width (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_spacing_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_spacing_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_spacing_blue (ThemeManager* self);
VALA_EXTERN gint theme_manager_get_spacing_width (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_blue (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_hard_alpha (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_red (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_green (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_blue (ThemeManager* self);
VALA_EXTERN gdouble theme_manager_get_highlight_soft_alpha (ThemeManager* self);
VALA_EXTERN const gchar* theme_manager_get_sound_flip (ThemeManager* self);
VALA_EXTERN const gchar* theme_manager_get_sound_gameover (ThemeManager* self);
VALA_EXTERN RsvgHandle* theme_manager_get_tileset_handle (ThemeManager* self);
static void theme_manager_finalize (GObject * obj);
static GType theme_manager_get_type_once (void);
static void _vala_theme_manager_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_theme_manager_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
theme_manager_get_instance_private (ThemeManager* self)
{
	return G_STRUCT_MEMBER_P (self, ThemeManager_private_offset);
}

void
theme_manager_gtk_theme_changed (ThemeManager* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = theme_manager_get_theme (self);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = theme_manager_get_theme (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "default") == 0;
	}
	if (_tmp0_) {
		theme_manager_set_theme (self, "default");
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
theme_manager_set_default_theme (ThemeManager* self,
                                 GKeyFile** key)
{
	GtkSettings* defaults = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gchar* filename = NULL;
	gboolean _tmp2_ = FALSE;
	GtkSettings* _tmp3_;
	gchar* filepath = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*key != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	defaults = _tmp1_;
	_tmp3_ = defaults;
	if (_tmp3_ != NULL) {
		GtkSettings* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = defaults;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_settings_get_type (), GtkSettings), "gtk-theme-name", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp2_ = string_contains (_tmp7_, "HighContrast");
		_g_free0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("high_contrast.theme");
		_g_free0 (filename);
		filename = _tmp8_;
	} else {
		gboolean _tmp9_ = FALSE;
		GtkSettings* _tmp10_;
		_tmp10_ = defaults;
		if (_tmp10_ != NULL) {
			gboolean _tmp11_ = FALSE;
			GtkSettings* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = defaults;
			g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_settings_get_type (), GtkSettings), "gtk-application-prefer-dark-theme", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == TRUE) {
				_tmp11_ = TRUE;
			} else {
				GtkSettings* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = defaults;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_settings_get_type (), GtkSettings), "gtk-theme-name", &_tmp16_, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp11_ = g_strcmp0 (_tmp18_, "Adwaita-dark") == 0;
				_g_free0 (_tmp18_);
			}
			_tmp9_ = _tmp11_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("adwaita.theme");
			_g_free0 (filename);
			filename = _tmp19_;
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("classic.theme");
			_g_free0 (filename);
			filename = _tmp20_;
		}
	}
	_tmp21_ = filename;
	_tmp22_ = g_build_filename (DATA_DIRECTORY, "themes", "key", _tmp21_, NULL);
	filepath = _tmp22_;
	{
		g_key_file_load_from_file (*key, filepath, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (filepath);
		_g_free0 (filename);
		_g_object_unref0 (defaults);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (filepath);
	_g_free0 (filename);
	_g_object_unref0 (defaults);
}

static inline void
theme_manager_load_theme (ThemeManager* self,
                          GKeyFile* key)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	{
		gchar* svg_path = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gint _tmp15_ = 0;
		gdouble _tmp16_ = 0.0;
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_;
		gdouble _tmp20_ = 0.0;
		gdouble _tmp21_ = 0.0;
		gdouble _tmp22_ = 0.0;
		gint _tmp23_ = 0;
		gint _tmp24_;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		gdouble _tmp27_ = 0.0;
		gint _tmp28_ = 0;
		gdouble _tmp29_ = 0.0;
		gdouble _tmp30_ = 0.0;
		gdouble _tmp31_ = 0.0;
		gdouble _tmp32_ = 0.0;
		gdouble _tmp33_ = 0.0;
		gdouble _tmp34_ = 0.0;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		_tmp0_ = g_build_filename (DATA_DIRECTORY, "themes", "svg", NULL);
		svg_path = _tmp0_;
		_tmp2_ = g_key_file_get_string (key, "Pieces", "File", &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = svg_path;
		_tmp4_ = g_build_filename (_tmp3_, _tmp1_, NULL);
		_g_free0 (self->priv->pieces_file);
		self->priv->pieces_file = _tmp4_;
		_tmp5_ = self->priv->pieces_file;
		_tmp6_ = g_path_get_dirname (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = svg_path;
		_tmp9_ = g_strcmp0 (_tmp7_, _tmp8_) != 0;
		_g_free0 (_tmp7_);
		if (_tmp9_) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = svg_path;
			_tmp11_ = g_build_filename (_tmp10_, "black_and_white.svg", NULL);
			_g_free0 (self->priv->pieces_file);
			self->priv->pieces_file = _tmp11_;
		}
		theme_manager_load_handle (self);
		_tmp12_ = g_key_file_get_double (key, "Background", "Red", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_background_red (self, _tmp12_);
		_tmp13_ = g_key_file_get_double (key, "Background", "Green", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_background_green (self, _tmp13_);
		_tmp14_ = g_key_file_get_double (key, "Background", "Blue", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_background_blue (self, _tmp14_);
		_tmp15_ = g_key_file_get_integer (key, "Background", "Radius", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_background_radius (self, _tmp15_);
		_tmp16_ = g_key_file_get_double (key, "Background", "TextureAlpha", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_texture_alpha (self, _tmp16_);
		_tmp18_ = self->priv->_texture_alpha;
		if (_tmp18_ > 0.0) {
			gdouble _tmp19_;
			_tmp19_ = self->priv->_texture_alpha;
			_tmp17_ = _tmp19_ <= 1.0;
		} else {
			_tmp17_ = FALSE;
		}
		theme_manager_set_apply_texture (self, _tmp17_);
		_tmp20_ = g_key_file_get_double (key, "Border", "Red", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_border_red (self, _tmp20_);
		_tmp21_ = g_key_file_get_double (key, "Border", "Green", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_border_green (self, _tmp21_);
		_tmp22_ = g_key_file_get_double (key, "Border", "Blue", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_border_blue (self, _tmp22_);
		_tmp23_ = g_key_file_get_integer (key, "Border", "Width", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_border_width (self, _tmp23_);
		_tmp24_ = self->priv->_border_width;
		theme_manager_set_half_border_width (self, ((gdouble) _tmp24_) / 2.0);
		_tmp25_ = g_key_file_get_double (key, "Spacing", "Red", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_spacing_red (self, _tmp25_);
		_tmp26_ = g_key_file_get_double (key, "Spacing", "Green", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_spacing_green (self, _tmp26_);
		_tmp27_ = g_key_file_get_double (key, "Spacing", "Blue", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_spacing_blue (self, _tmp27_);
		_tmp28_ = g_key_file_get_integer (key, "Spacing", "Width", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_spacing_width (self, _tmp28_);
		_tmp29_ = g_key_file_get_double (key, "Highlight hard", "Red", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_hard_red (self, _tmp29_);
		_tmp30_ = g_key_file_get_double (key, "Highlight hard", "Green", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_hard_green (self, _tmp30_);
		_tmp31_ = g_key_file_get_double (key, "Highlight hard", "Blue", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_hard_blue (self, _tmp31_);
		_tmp32_ = g_key_file_get_double (key, "Highlight hard", "Alpha", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_hard_alpha (self, _tmp32_);
		_tmp33_ = g_key_file_get_double (key, "Highlight soft", "Red", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_soft_red (self, _tmp33_);
		_tmp34_ = g_key_file_get_double (key, "Highlight soft", "Green", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_soft_green (self, _tmp34_);
		_tmp35_ = g_key_file_get_double (key, "Highlight soft", "Blue", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_soft_blue (self, _tmp35_);
		_tmp36_ = g_key_file_get_double (key, "Highlight soft", "Alpha", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_highlight_soft_alpha (self, _tmp36_);
		_tmp38_ = g_key_file_get_string (key, "Sound", "Flip", &_inner_error0_);
		_tmp37_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_sound_flip (self, _tmp37_);
		_tmp40_ = g_key_file_get_string (key, "Sound", "GameOver", &_inner_error0_);
		_tmp39_ = _tmp40_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp37_);
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		theme_manager_set_sound_gameover (self, _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp1_);
		_g_free0 (svg_path);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("theme-manager.vala:188: Errors when loading theme: %s", _tmp42_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline void
theme_manager_load_handle (ThemeManager* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->handle_loaded) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->old_pieces_file;
		_tmp2_ = self->priv->pieces_file;
		_tmp0_ = g_strcmp0 (_tmp1_, _tmp2_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	{
		RsvgHandle* _tmp3_ = NULL;
		const gchar* _tmp4_;
		RsvgHandle* _tmp5_;
		RsvgHandle* _tmp6_;
		_tmp4_ = self->priv->pieces_file;
		_tmp5_ = rsvg_handle_new_from_file (_tmp4_, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->_tileset_handle);
		self->priv->_tileset_handle = _tmp6_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = self->priv->pieces_file;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->old_pieces_file);
	self->priv->old_pieces_file = _tmp8_;
	self->priv->handle_loaded = TRUE;
}

ThemeManager*
theme_manager_construct (GType object_type)
{
	ThemeManager * self = NULL;
	self = (ThemeManager*) g_object_new (object_type, NULL);
	return self;
}

ThemeManager*
theme_manager_new (void)
{
	return theme_manager_construct (TYPE_THEME_MANAGER);
}

static const gchar*
theme_manager_get_theme (ThemeManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->theme_set) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

void
theme_manager_set_theme (ThemeManager* self,
                         const gchar* value)
{
	GKeyFile* key = NULL;
	GKeyFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GKeyFile* _tmp15_;
	gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	key = _tmp0_;
	if (g_strcmp0 (value, "") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (value, "default") == 0;
	}
	if (_tmp1_) {
		theme_manager_set_default_theme (self, &key);
	} else {
		{
			gchar* key_path = NULL;
			gchar* _tmp2_;
			gchar* filepath = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gboolean _tmp9_;
			GKeyFile* _tmp11_;
			const gchar* _tmp12_;
			_tmp2_ = g_build_filename (DATA_DIRECTORY, "themes", "key", NULL);
			key_path = _tmp2_;
			_tmp3_ = key_path;
			_tmp4_ = g_build_filename (_tmp3_, value, NULL);
			filepath = _tmp4_;
			_tmp5_ = filepath;
			_tmp6_ = g_path_get_dirname (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = key_path;
			_tmp9_ = g_strcmp0 (_tmp7_, _tmp8_) != 0;
			_g_free0 (_tmp7_);
			if (_tmp9_) {
				GError* _tmp10_;
				_tmp10_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Theme file is not in the \"key\" directory.");
				_inner_error0_ = _tmp10_;
				_g_free0 (filepath);
				_g_free0 (key_path);
				goto __catch0_g_error;
			}
			_tmp11_ = key;
			_tmp12_ = filepath;
			g_key_file_load_from_file (_tmp11_, _tmp12_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (filepath);
				_g_free0 (key_path);
				goto __catch0_g_error;
			}
			_g_free0 (filepath);
			_g_free0 (key_path);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("theme-manager.vala:57: Failed to load theme: %s", _tmp14_);
			theme_manager_set_default_theme (self, &key);
			value = "default";
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp15_ = key;
	theme_manager_load_theme (self, _tmp15_);
	_tmp16_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp16_;
	self->priv->theme_set = TRUE;
	g_signal_emit (self, theme_manager_signals[THEME_MANAGER_THEME_CHANGED_SIGNAL], 0);
	_g_key_file_unref0 (key);
}

gdouble
theme_manager_get_background_red (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_background_red;
	return result;
}

static void
theme_manager_set_background_red (ThemeManager* self,
                                  gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_background_red = value;
}

gdouble
theme_manager_get_background_green (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_background_green;
	return result;
}

static void
theme_manager_set_background_green (ThemeManager* self,
                                    gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_background_green = value;
}

gdouble
theme_manager_get_background_blue (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_background_blue;
	return result;
}

static void
theme_manager_set_background_blue (ThemeManager* self,
                                   gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_background_blue = value;
}

gint
theme_manager_get_background_radius (ThemeManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_background_radius;
	return result;
}

static void
theme_manager_set_background_radius (ThemeManager* self,
                                     gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_background_radius = value;
}

gdouble
theme_manager_get_texture_alpha (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_texture_alpha;
	return result;
}

static void
theme_manager_set_texture_alpha (ThemeManager* self,
                                 gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_texture_alpha = value;
}

gboolean
theme_manager_get_apply_texture (ThemeManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_apply_texture;
	return result;
}

static void
theme_manager_set_apply_texture (ThemeManager* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_apply_texture = value;
}

gdouble
theme_manager_get_border_red (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_border_red;
	return result;
}

static void
theme_manager_set_border_red (ThemeManager* self,
                              gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_border_red = value;
}

gdouble
theme_manager_get_border_green (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_border_green;
	return result;
}

static void
theme_manager_set_border_green (ThemeManager* self,
                                gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_border_green = value;
}

gdouble
theme_manager_get_border_blue (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_border_blue;
	return result;
}

static void
theme_manager_set_border_blue (ThemeManager* self,
                               gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_border_blue = value;
}

gint
theme_manager_get_border_width (ThemeManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_width;
	return result;
}

static void
theme_manager_set_border_width (ThemeManager* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_border_width = value;
}

gdouble
theme_manager_get_half_border_width (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_half_border_width;
	return result;
}

static void
theme_manager_set_half_border_width (ThemeManager* self,
                                     gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_half_border_width = value;
}

gdouble
theme_manager_get_spacing_red (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_spacing_red;
	return result;
}

static void
theme_manager_set_spacing_red (ThemeManager* self,
                               gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_spacing_red = value;
}

gdouble
theme_manager_get_spacing_green (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_spacing_green;
	return result;
}

static void
theme_manager_set_spacing_green (ThemeManager* self,
                                 gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_spacing_green = value;
}

gdouble
theme_manager_get_spacing_blue (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_spacing_blue;
	return result;
}

static void
theme_manager_set_spacing_blue (ThemeManager* self,
                                gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_spacing_blue = value;
}

gint
theme_manager_get_spacing_width (ThemeManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_spacing_width;
	return result;
}

static void
theme_manager_set_spacing_width (ThemeManager* self,
                                 gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_spacing_width = value;
}

gdouble
theme_manager_get_highlight_hard_red (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_hard_red;
	return result;
}

static void
theme_manager_set_highlight_hard_red (ThemeManager* self,
                                      gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_hard_red = value;
}

gdouble
theme_manager_get_highlight_hard_green (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_hard_green;
	return result;
}

static void
theme_manager_set_highlight_hard_green (ThemeManager* self,
                                        gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_hard_green = value;
}

gdouble
theme_manager_get_highlight_hard_blue (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_hard_blue;
	return result;
}

static void
theme_manager_set_highlight_hard_blue (ThemeManager* self,
                                       gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_hard_blue = value;
}

gdouble
theme_manager_get_highlight_hard_alpha (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_hard_alpha;
	return result;
}

static void
theme_manager_set_highlight_hard_alpha (ThemeManager* self,
                                        gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_hard_alpha = value;
}

gdouble
theme_manager_get_highlight_soft_red (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_soft_red;
	return result;
}

static void
theme_manager_set_highlight_soft_red (ThemeManager* self,
                                      gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_soft_red = value;
}

gdouble
theme_manager_get_highlight_soft_green (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_soft_green;
	return result;
}

static void
theme_manager_set_highlight_soft_green (ThemeManager* self,
                                        gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_soft_green = value;
}

gdouble
theme_manager_get_highlight_soft_blue (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_soft_blue;
	return result;
}

static void
theme_manager_set_highlight_soft_blue (ThemeManager* self,
                                       gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_soft_blue = value;
}

gdouble
theme_manager_get_highlight_soft_alpha (ThemeManager* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_highlight_soft_alpha;
	return result;
}

static void
theme_manager_set_highlight_soft_alpha (ThemeManager* self,
                                        gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_soft_alpha = value;
}

const gchar*
theme_manager_get_sound_flip (ThemeManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_flip;
	result = _tmp0_;
	return result;
}

static void
theme_manager_set_sound_flip (ThemeManager* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sound_flip);
	self->priv->_sound_flip = _tmp0_;
}

const gchar*
theme_manager_get_sound_gameover (ThemeManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_gameover;
	result = _tmp0_;
	return result;
}

static void
theme_manager_set_sound_gameover (ThemeManager* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sound_gameover);
	self->priv->_sound_gameover = _tmp0_;
}

RsvgHandle*
theme_manager_get_tileset_handle (ThemeManager* self)
{
	RsvgHandle* result;
	RsvgHandle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->handle_loaded) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_tileset_handle;
	result = _tmp0_;
	return result;
}

static void
theme_manager_class_init (ThemeManagerClass * klass,
                          gpointer klass_data)
{
	theme_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ThemeManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_theme_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_theme_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = theme_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_THEME_PROPERTY, theme_manager_properties[THEME_MANAGER_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BACKGROUND_RED_PROPERTY, theme_manager_properties[THEME_MANAGER_BACKGROUND_RED_PROPERTY] = g_param_spec_double ("background-red", "background-red", "background-red", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BACKGROUND_GREEN_PROPERTY, theme_manager_properties[THEME_MANAGER_BACKGROUND_GREEN_PROPERTY] = g_param_spec_double ("background-green", "background-green", "background-green", -G_MAXDOUBLE, G_MAXDOUBLE, 0.6, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BACKGROUND_BLUE_PROPERTY, theme_manager_properties[THEME_MANAGER_BACKGROUND_BLUE_PROPERTY] = g_param_spec_double ("background-blue", "background-blue", "background-blue", -G_MAXDOUBLE, G_MAXDOUBLE, 0.4, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BACKGROUND_RADIUS_PROPERTY, theme_manager_properties[THEME_MANAGER_BACKGROUND_RADIUS_PROPERTY] = g_param_spec_int ("background-radius", "background-radius", "background-radius", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_TEXTURE_ALPHA_PROPERTY, theme_manager_properties[THEME_MANAGER_TEXTURE_ALPHA_PROPERTY] = g_param_spec_double ("texture-alpha", "texture-alpha", "texture-alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 0.25, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_APPLY_TEXTURE_PROPERTY, theme_manager_properties[THEME_MANAGER_APPLY_TEXTURE_PROPERTY] = g_param_spec_boolean ("apply-texture", "apply-texture", "apply-texture", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BORDER_RED_PROPERTY, theme_manager_properties[THEME_MANAGER_BORDER_RED_PROPERTY] = g_param_spec_double ("border-red", "border-red", "border-red", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BORDER_GREEN_PROPERTY, theme_manager_properties[THEME_MANAGER_BORDER_GREEN_PROPERTY] = g_param_spec_double ("border-green", "border-green", "border-green", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BORDER_BLUE_PROPERTY, theme_manager_properties[THEME_MANAGER_BORDER_BLUE_PROPERTY] = g_param_spec_double ("border-blue", "border-blue", "border-blue", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BORDER_WIDTH_PROPERTY, theme_manager_properties[THEME_MANAGER_BORDER_WIDTH_PROPERTY] = g_param_spec_int ("border-width", "border-width", "border-width", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HALF_BORDER_WIDTH_PROPERTY, theme_manager_properties[THEME_MANAGER_HALF_BORDER_WIDTH_PROPERTY] = g_param_spec_double ("half-border-width", "half-border-width", "half-border-width", -G_MAXDOUBLE, G_MAXDOUBLE, 1.5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_SPACING_RED_PROPERTY, theme_manager_properties[THEME_MANAGER_SPACING_RED_PROPERTY] = g_param_spec_double ("spacing-red", "spacing-red", "spacing-red", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_SPACING_GREEN_PROPERTY, theme_manager_properties[THEME_MANAGER_SPACING_GREEN_PROPERTY] = g_param_spec_double ("spacing-green", "spacing-green", "spacing-green", -G_MAXDOUBLE, G_MAXDOUBLE, 0.3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_SPACING_BLUE_PROPERTY, theme_manager_properties[THEME_MANAGER_SPACING_BLUE_PROPERTY] = g_param_spec_double ("spacing-blue", "spacing-blue", "spacing-blue", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_SPACING_WIDTH_PROPERTY, theme_manager_properties[THEME_MANAGER_SPACING_WIDTH_PROPERTY] = g_param_spec_int ("spacing-width", "spacing-width", "spacing-width", G_MININT, G_MAXINT, 2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_HARD_RED_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_HARD_RED_PROPERTY] = g_param_spec_double ("highlight-hard-red", "highlight-hard-red", "highlight-hard-red", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_HARD_GREEN_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_HARD_GREEN_PROPERTY] = g_param_spec_double ("highlight-hard-green", "highlight-hard-green", "highlight-hard-green", -G_MAXDOUBLE, G_MAXDOUBLE, 0.3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_HARD_BLUE_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_HARD_BLUE_PROPERTY] = g_param_spec_double ("highlight-hard-blue", "highlight-hard-blue", "highlight-hard-blue", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_HARD_ALPHA_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_HARD_ALPHA_PROPERTY] = g_param_spec_double ("highlight-hard-alpha", "highlight-hard-alpha", "highlight-hard-alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 0.4, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_SOFT_RED_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_SOFT_RED_PROPERTY] = g_param_spec_double ("highlight-soft-red", "highlight-soft-red", "highlight-soft-red", -G_MAXDOUBLE, G_MAXDOUBLE, 0.1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_SOFT_GREEN_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_SOFT_GREEN_PROPERTY] = g_param_spec_double ("highlight-soft-green", "highlight-soft-green", "highlight-soft-green", -G_MAXDOUBLE, G_MAXDOUBLE, 0.3, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_SOFT_BLUE_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_SOFT_BLUE_PROPERTY] = g_param_spec_double ("highlight-soft-blue", "highlight-soft-blue", "highlight-soft-blue", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_HIGHLIGHT_SOFT_ALPHA_PROPERTY, theme_manager_properties[THEME_MANAGER_HIGHLIGHT_SOFT_ALPHA_PROPERTY] = g_param_spec_double ("highlight-soft-alpha", "highlight-soft-alpha", "highlight-soft-alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 0.2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_SOUND_FLIP_PROPERTY, theme_manager_properties[THEME_MANAGER_SOUND_FLIP_PROPERTY] = g_param_spec_string ("sound-flip", "sound-flip", "sound-flip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_SOUND_GAMEOVER_PROPERTY, theme_manager_properties[THEME_MANAGER_SOUND_GAMEOVER_PROPERTY] = g_param_spec_string ("sound-gameover", "sound-gameover", "sound-gameover", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_TILESET_HANDLE_PROPERTY, theme_manager_properties[THEME_MANAGER_TILESET_HANDLE_PROPERTY] = g_param_spec_object ("tileset-handle", "tileset-handle", "tileset-handle", rsvg_handle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	theme_manager_signals[THEME_MANAGER_THEME_CHANGED_SIGNAL] = g_signal_new ("theme-changed", TYPE_THEME_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
theme_manager_instance_init (ThemeManager * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = theme_manager_get_instance_private (self);
	self->priv->theme_set = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->pieces_file = _tmp0_;
	self->priv->_background_red = 0.2;
	self->priv->_background_green = 0.6;
	self->priv->_background_blue = 0.4;
	self->priv->_background_radius = 0;
	self->priv->_texture_alpha = 0.25;
	self->priv->_apply_texture = FALSE;
	self->priv->_border_red = 0.1;
	self->priv->_border_green = 0.1;
	self->priv->_border_blue = 0.1;
	self->priv->_border_width = 3;
	self->priv->_half_border_width = 1.5;
	self->priv->_spacing_red = 0.1;
	self->priv->_spacing_green = 0.3;
	self->priv->_spacing_blue = 0.2;
	self->priv->_spacing_width = 2;
	self->priv->_highlight_hard_red = 0.1;
	self->priv->_highlight_hard_green = 0.3;
	self->priv->_highlight_hard_blue = 0.2;
	self->priv->_highlight_hard_alpha = 0.4;
	self->priv->_highlight_soft_red = 0.1;
	self->priv->_highlight_soft_green = 0.3;
	self->priv->_highlight_soft_blue = 0.2;
	self->priv->_highlight_soft_alpha = 0.2;
	_tmp1_ = g_strdup ("");
	self->priv->_sound_flip = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_sound_gameover = _tmp2_;
	self->priv->handle_loaded = FALSE;
	_tmp3_ = g_strdup ("");
	self->priv->old_pieces_file = _tmp3_;
}

static void
theme_manager_finalize (GObject * obj)
{
	ThemeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_MANAGER, ThemeManager);
	_g_free0 (self->priv->_theme);
	_g_free0 (self->priv->pieces_file);
	_g_free0 (self->priv->_sound_flip);
	_g_free0 (self->priv->_sound_gameover);
	_g_object_unref0 (self->priv->_tileset_handle);
	_g_free0 (self->priv->old_pieces_file);
	G_OBJECT_CLASS (theme_manager_parent_class)->finalize (obj);
}

static GType
theme_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeManager), 0, (GInstanceInitFunc) theme_manager_instance_init, NULL };
	GType theme_manager_type_id;
	theme_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ThemeManager", &g_define_type_info, 0);
	ThemeManager_private_offset = g_type_add_instance_private (theme_manager_type_id, sizeof (ThemeManagerPrivate));
	return theme_manager_type_id;
}

GType
theme_manager_get_type (void)
{
	static volatile gsize theme_manager_type_id__once = 0;
	if (g_once_init_enter (&theme_manager_type_id__once)) {
		GType theme_manager_type_id;
		theme_manager_type_id = theme_manager_get_type_once ();
		g_once_init_leave (&theme_manager_type_id__once, theme_manager_type_id);
	}
	return theme_manager_type_id__once;
}

static void
_vala_theme_manager_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	ThemeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME_MANAGER, ThemeManager);
	switch (property_id) {
		case THEME_MANAGER_THEME_PROPERTY:
		g_value_set_string (value, theme_manager_get_theme (self));
		break;
		case THEME_MANAGER_BACKGROUND_RED_PROPERTY:
		g_value_set_double (value, theme_manager_get_background_red (self));
		break;
		case THEME_MANAGER_BACKGROUND_GREEN_PROPERTY:
		g_value_set_double (value, theme_manager_get_background_green (self));
		break;
		case THEME_MANAGER_BACKGROUND_BLUE_PROPERTY:
		g_value_set_double (value, theme_manager_get_background_blue (self));
		break;
		case THEME_MANAGER_BACKGROUND_RADIUS_PROPERTY:
		g_value_set_int (value, theme_manager_get_background_radius (self));
		break;
		case THEME_MANAGER_TEXTURE_ALPHA_PROPERTY:
		g_value_set_double (value, theme_manager_get_texture_alpha (self));
		break;
		case THEME_MANAGER_APPLY_TEXTURE_PROPERTY:
		g_value_set_boolean (value, theme_manager_get_apply_texture (self));
		break;
		case THEME_MANAGER_BORDER_RED_PROPERTY:
		g_value_set_double (value, theme_manager_get_border_red (self));
		break;
		case THEME_MANAGER_BORDER_GREEN_PROPERTY:
		g_value_set_double (value, theme_manager_get_border_green (self));
		break;
		case THEME_MANAGER_BORDER_BLUE_PROPERTY:
		g_value_set_double (value, theme_manager_get_border_blue (self));
		break;
		case THEME_MANAGER_BORDER_WIDTH_PROPERTY:
		g_value_set_int (value, theme_manager_get_border_width (self));
		break;
		case THEME_MANAGER_HALF_BORDER_WIDTH_PROPERTY:
		g_value_set_double (value, theme_manager_get_half_border_width (self));
		break;
		case THEME_MANAGER_SPACING_RED_PROPERTY:
		g_value_set_double (value, theme_manager_get_spacing_red (self));
		break;
		case THEME_MANAGER_SPACING_GREEN_PROPERTY:
		g_value_set_double (value, theme_manager_get_spacing_green (self));
		break;
		case THEME_MANAGER_SPACING_BLUE_PROPERTY:
		g_value_set_double (value, theme_manager_get_spacing_blue (self));
		break;
		case THEME_MANAGER_SPACING_WIDTH_PROPERTY:
		g_value_set_int (value, theme_manager_get_spacing_width (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_RED_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_hard_red (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_GREEN_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_hard_green (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_BLUE_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_hard_blue (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_ALPHA_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_hard_alpha (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_RED_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_soft_red (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_GREEN_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_soft_green (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_BLUE_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_soft_blue (self));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_ALPHA_PROPERTY:
		g_value_set_double (value, theme_manager_get_highlight_soft_alpha (self));
		break;
		case THEME_MANAGER_SOUND_FLIP_PROPERTY:
		g_value_set_string (value, theme_manager_get_sound_flip (self));
		break;
		case THEME_MANAGER_SOUND_GAMEOVER_PROPERTY:
		g_value_set_string (value, theme_manager_get_sound_gameover (self));
		break;
		case THEME_MANAGER_TILESET_HANDLE_PROPERTY:
		g_value_set_object (value, theme_manager_get_tileset_handle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_theme_manager_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	ThemeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME_MANAGER, ThemeManager);
	switch (property_id) {
		case THEME_MANAGER_THEME_PROPERTY:
		theme_manager_set_theme (self, g_value_get_string (value));
		break;
		case THEME_MANAGER_BACKGROUND_RED_PROPERTY:
		theme_manager_set_background_red (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_BACKGROUND_GREEN_PROPERTY:
		theme_manager_set_background_green (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_BACKGROUND_BLUE_PROPERTY:
		theme_manager_set_background_blue (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_BACKGROUND_RADIUS_PROPERTY:
		theme_manager_set_background_radius (self, g_value_get_int (value));
		break;
		case THEME_MANAGER_TEXTURE_ALPHA_PROPERTY:
		theme_manager_set_texture_alpha (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_APPLY_TEXTURE_PROPERTY:
		theme_manager_set_apply_texture (self, g_value_get_boolean (value));
		break;
		case THEME_MANAGER_BORDER_RED_PROPERTY:
		theme_manager_set_border_red (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_BORDER_GREEN_PROPERTY:
		theme_manager_set_border_green (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_BORDER_BLUE_PROPERTY:
		theme_manager_set_border_blue (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_BORDER_WIDTH_PROPERTY:
		theme_manager_set_border_width (self, g_value_get_int (value));
		break;
		case THEME_MANAGER_HALF_BORDER_WIDTH_PROPERTY:
		theme_manager_set_half_border_width (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_SPACING_RED_PROPERTY:
		theme_manager_set_spacing_red (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_SPACING_GREEN_PROPERTY:
		theme_manager_set_spacing_green (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_SPACING_BLUE_PROPERTY:
		theme_manager_set_spacing_blue (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_SPACING_WIDTH_PROPERTY:
		theme_manager_set_spacing_width (self, g_value_get_int (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_RED_PROPERTY:
		theme_manager_set_highlight_hard_red (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_GREEN_PROPERTY:
		theme_manager_set_highlight_hard_green (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_BLUE_PROPERTY:
		theme_manager_set_highlight_hard_blue (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_HARD_ALPHA_PROPERTY:
		theme_manager_set_highlight_hard_alpha (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_RED_PROPERTY:
		theme_manager_set_highlight_soft_red (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_GREEN_PROPERTY:
		theme_manager_set_highlight_soft_green (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_BLUE_PROPERTY:
		theme_manager_set_highlight_soft_blue (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_HIGHLIGHT_SOFT_ALPHA_PROPERTY:
		theme_manager_set_highlight_soft_alpha (self, g_value_get_double (value));
		break;
		case THEME_MANAGER_SOUND_FLIP_PROPERTY:
		theme_manager_set_sound_flip (self, g_value_get_string (value));
		break;
		case THEME_MANAGER_SOUND_GAMEOVER_PROPERTY:
		theme_manager_set_sound_gameover (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

