/* history-button.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from history-button.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2019 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <librsvg/rsvg.h>
#include <gdk/gdk.h>
#include <string.h>

#define HISTORY_BUTTON_pixbuf_margin 1
#define HISTORY_BUTTON_arrow_margin_top 3.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_HISTORY_BUTTON (history_button_get_type ())
#define HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_BUTTON, HistoryButton))
#define HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_BUTTON, HistoryButtonClass))
#define IS_HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_BUTTON))
#define IS_HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_BUTTON))
#define HISTORY_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_BUTTON, HistoryButtonClass))

typedef struct _HistoryButton HistoryButton;
typedef struct _HistoryButtonClass HistoryButtonClass;
typedef struct _HistoryButtonPrivate HistoryButtonPrivate;

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;
typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())
enum  {
	HISTORY_BUTTON_0_PROPERTY,
	HISTORY_BUTTON_THEME_MANAGER_PROPERTY,
	HISTORY_BUTTON_NUM_PROPERTIES
};
static GParamSpec* history_button_properties[HISTORY_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _HistoryButton {
	GtkMenuButton parent_instance;
	HistoryButtonPrivate * priv;
};

struct _HistoryButtonClass {
	GtkMenuButtonClass parent_class;
};

struct _HistoryButtonPrivate {
	ThemeManager* _theme_manager;
	GtkStack* stack;
	GtkDrawingArea* drawing;
	gboolean drawing_configured;
	gint drawing_height;
	gint drawing_width;
	gdouble arrow_half_width;
	gint board_x;
	gint board_y;
	GdkPixbuf* tileset_pixbuf;
	cairo_pattern_t* tiles_pattern;
	Player current_player;
};

static gint HistoryButton_private_offset;
static gpointer history_button_parent_class = NULL;
static AdaptativeWidgetIface * history_button_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType history_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryButton, g_object_unref)
VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN HistoryButton* history_button_new (GMenu* menu,
                                   ThemeManager* theme_manager);
VALA_EXTERN HistoryButton* history_button_construct (GType object_type,
                                         GMenu* menu,
                                         ThemeManager* theme_manager);
static void history_button_real_set_window_size (AdaptativeWidget* base,
                                          AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void history_button_set_player (HistoryButton* self,
                                Player player);
VALA_EXTERN void history_button_update_menu (HistoryButton* self,
                                 GMenu* menu);
static gboolean history_button_configure_drawing (HistoryButton* self);
static void history_button_init_pattern (HistoryButton* self,
                                  cairo_t* cr);
static ThemeManager* history_button_get_theme_manager (HistoryButton* self);
VALA_EXTERN RsvgHandle* theme_manager_get_tileset_handle (ThemeManager* self);
static gboolean history_button_update_drawing (HistoryButton* self,
                                        cairo_t* cr);
static void history_button_draw_arrow (HistoryButton* self,
                                cairo_t* cr);
static void history_button_draw_piece (HistoryButton* self,
                                cairo_t* cr);
static void history_button_set_theme_manager (HistoryButton* self,
                                       ThemeManager* value);
static GObject * history_button_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static gboolean _history_button_configure_drawing_gtk_widget_configure_event (GtkWidget* _sender,
                                                                       GdkEventConfigure* event,
                                                                       gpointer self);
static gboolean _history_button_update_drawing_gtk_widget_draw (GtkWidget* _sender,
                                                         cairo_t* cr,
                                                         gpointer self);
static void _history_button___lambda23_ (HistoryButton* self);
static void __history_button___lambda23__theme_manager_theme_changed (ThemeManager* _sender,
                                                               gpointer self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void history_button_finalize (GObject * obj);
static GType history_button_get_type_once (void);
static void _vala_history_button_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_history_button_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
history_button_get_instance_private (HistoryButton* self)
{
	return G_STRUCT_MEMBER_P (self, HistoryButton_private_offset);
}

HistoryButton*
history_button_construct (GType object_type,
                          GMenu* menu,
                          ThemeManager* theme_manager)
{
	HistoryButton * self = NULL;
	g_return_val_if_fail (menu != NULL, NULL);
	g_return_val_if_fail (theme_manager != NULL, NULL);
	self = (HistoryButton*) g_object_new (object_type, "menu-model", menu, "theme-manager", theme_manager, NULL);
	return self;
}

HistoryButton*
history_button_new (GMenu* menu,
                    ThemeManager* theme_manager)
{
	return history_button_construct (TYPE_HISTORY_BUTTON, menu, theme_manager);
}

static void
history_button_real_set_window_size (AdaptativeWidget* base,
                                     AdaptativeWidgetWindowSize new_size)
{
	HistoryButton * self;
	self = (HistoryButton*) base;
}

void
history_button_set_player (HistoryButton* self,
                           Player player)
{
	g_return_if_fail (self != NULL);
	self->priv->current_player = player;
	if (player == PLAYER_NONE) {
		GtkStack* _tmp0_;
		_tmp0_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp0_, "label");
	} else {
		GtkStack* _tmp1_;
		GtkDrawingArea* _tmp2_;
		GtkDrawingArea* _tmp3_;
		_tmp1_ = self->priv->stack;
		_tmp2_ = self->priv->drawing;
		gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->drawing;
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	}
}

inline void
history_button_update_menu (HistoryButton* self,
                            GMenu* menu)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	gtk_menu_button_set_menu_model ((GtkMenuButton*) self, (GMenuModel*) menu);
}

static gboolean
history_button_configure_drawing (HistoryButton* self)
{
	gint height = 0;
	GtkDrawingArea* _tmp0_;
	gint width = 0;
	GtkDrawingArea* _tmp1_;
	gint new_height = 0;
	gboolean vertical_fill = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->drawing;
	height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->drawing;
	width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp1_);
	new_height = (gint) MIN ((gdouble) height, width / 2.0);
	self->priv->drawing_height = new_height;
	self->priv->arrow_half_width = (((gdouble) self->priv->drawing_height) - (2.0 * HISTORY_BUTTON_pixbuf_margin)) / 4.0;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	vertical_fill = height == new_height;
	if (vertical_fill) {
		_tmp2_ = (gint) (new_height * 2.0);
	} else {
		_tmp2_ = width;
	}
	self->priv->drawing_width = _tmp2_;
	if (vertical_fill) {
		_tmp3_ = (gint) ((width - self->priv->drawing_width) / 2.0);
	} else {
		_tmp3_ = 0;
	}
	self->priv->board_x = _tmp3_;
	if (!vertical_fill) {
		_tmp4_ = (gint) ((height - self->priv->drawing_height) / 2.0);
	} else {
		_tmp4_ = 0;
	}
	self->priv->board_y = _tmp4_;
	self->priv->drawing_configured = TRUE;
	result = TRUE;
	return result;
}

static void
history_button_init_pattern (HistoryButton* self,
                             cairo_t* cr)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_t* context = NULL;
	cairo_t* _tmp2_;
	RsvgDimensionData size = {0};
	ThemeManager* _tmp3_;
	RsvgHandle* _tmp4_;
	RsvgHandle* _tmp5_;
	RsvgDimensionData _tmp6_ = {0};
	RsvgDimensionData _tmp7_;
	RsvgDimensionData _tmp8_;
	ThemeManager* _tmp9_;
	RsvgHandle* _tmp10_;
	RsvgHandle* _tmp11_;
	cairo_pattern_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cairo_get_target (cr);
	_tmp1_ = cairo_surface_create_similar (_tmp0_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->drawing_height * 8, self->priv->drawing_height * 4);
	surface = _tmp1_;
	_tmp2_ = cairo_create (surface);
	context = _tmp2_;
	_tmp3_ = self->priv->_theme_manager;
	_tmp4_ = theme_manager_get_tileset_handle (_tmp3_);
	_tmp5_ = _tmp4_;
	rsvg_handle_get_dimensions (_tmp5_, &_tmp6_);
	size = _tmp6_;
	_tmp7_ = size;
	_tmp8_ = size;
	cairo_scale (context, (((gdouble) self->priv->drawing_height) * 8.0) / ((gdouble) _tmp7_.width), (((gdouble) self->priv->drawing_height) * 4.0) / ((gdouble) _tmp8_.height));
	_tmp9_ = self->priv->_theme_manager;
	_tmp10_ = theme_manager_get_tileset_handle (_tmp9_);
	_tmp11_ = _tmp10_;
	rsvg_handle_render_cairo (_tmp11_, context);
	_tmp12_ = cairo_pattern_create_for_surface (surface);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = _tmp12_;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
}

static gboolean
history_button_update_drawing (HistoryButton* self,
                               cairo_t* cr)
{
	cairo_pattern_t* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	if (!self->priv->drawing_configured) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->tiles_pattern;
	if (_tmp0_ == NULL) {
		history_button_init_pattern (self, cr);
	}
	history_button_draw_arrow (self, cr);
	history_button_draw_piece (self, cr);
	result = TRUE;
	return result;
}

static void
history_button_draw_arrow (HistoryButton* self,
                           cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	cairo_set_source_rgba (cr, 0.5, 0.5, 0.5, 1.0);
	cairo_set_line_width (cr, 2.0);
	cairo_translate (cr, (gdouble) self->priv->board_x, (gdouble) self->priv->board_y);
	cairo_move_to (cr, self->priv->arrow_half_width, HISTORY_BUTTON_arrow_margin_top);
	cairo_line_to (cr, 3.0 * self->priv->arrow_half_width, self->priv->drawing_height / 2.0);
	cairo_line_to (cr, self->priv->arrow_half_width, self->priv->drawing_height - HISTORY_BUTTON_arrow_margin_top);
	cairo_stroke (cr);
	cairo_restore (cr);
}

static void
history_button_draw_piece (HistoryButton* self,
                           cairo_t* cr)
{
	gint pixmap = 0;
	cairo_matrix_t matrix = {0};
	gint x = 0;
	cairo_pattern_t* _tmp0_;
	cairo_matrix_t _tmp1_;
	cairo_pattern_t* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	switch (self->priv->current_player) {
		case PLAYER_NONE:
		{
			return;
		}
		case PLAYER_DARK:
		{
			pixmap = 1;
			break;
		}
		case PLAYER_LIGHT:
		{
			pixmap = 31;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	cairo_save (cr);
	cairo_matrix_init_identity (&matrix);
	x = (self->priv->board_x + self->priv->drawing_width) - self->priv->drawing_height;
	cairo_matrix_translate (&matrix, (gdouble) (((pixmap % 8) * self->priv->drawing_height) - x), (gdouble) (((pixmap / 8) * self->priv->drawing_height) - self->priv->board_y));
	_tmp0_ = self->priv->tiles_pattern;
	_tmp1_ = matrix;
	cairo_pattern_set_matrix ((cairo_pattern_t*) _tmp0_, &_tmp1_);
	_tmp2_ = self->priv->tiles_pattern;
	cairo_set_source (cr, (cairo_pattern_t*) _tmp2_);
	cairo_rectangle (cr, (gdouble) x, (gdouble) self->priv->board_y, (gdouble) self->priv->drawing_height, (gdouble) self->priv->drawing_height);
	cairo_clip (cr);
	cairo_paint (cr);
	cairo_restore (cr);
}

static ThemeManager*
history_button_get_theme_manager (HistoryButton* self)
{
	ThemeManager* result;
	ThemeManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_manager;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
history_button_set_theme_manager (HistoryButton* self,
                                  ThemeManager* value)
{
	ThemeManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_theme_manager);
	self->priv->_theme_manager = _tmp0_;
}

static gboolean
_history_button_configure_drawing_gtk_widget_configure_event (GtkWidget* _sender,
                                                              GdkEventConfigure* event,
                                                              gpointer self)
{
	gboolean result;
	result = history_button_configure_drawing ((HistoryButton*) self);
	return result;
}

static gboolean
_history_button_update_drawing_gtk_widget_draw (GtkWidget* _sender,
                                                cairo_t* cr,
                                                gpointer self)
{
	gboolean result;
	result = history_button_update_drawing ((HistoryButton*) self, cr);
	return result;
}

static void
_history_button___lambda23_ (HistoryButton* self)
{
	if (!self->priv->drawing_configured) {
		return;
	}
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	if (self->priv->current_player != PLAYER_NONE) {
		GtkDrawingArea* _tmp0_;
		_tmp0_ = self->priv->drawing;
		gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
	}
}

static void
__history_button___lambda23__theme_manager_theme_changed (ThemeManager* _sender,
                                                          gpointer self)
{
	_history_button___lambda23_ ((HistoryButton*) self);
}

static GObject *
history_button_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	HistoryButton * self;
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	ThemeManager* _tmp2_;
	parent_class = G_OBJECT_CLASS (history_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_BUTTON, HistoryButton);
	_tmp0_ = self->priv->drawing;
	g_signal_connect_object ((GtkWidget*) _tmp0_, "configure-event", (GCallback) _history_button_configure_drawing_gtk_widget_configure_event, self, 0);
	_tmp1_ = self->priv->drawing;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "draw", (GCallback) _history_button_update_drawing_gtk_widget_draw, self, 0);
	_tmp2_ = self->priv->_theme_manager;
	g_signal_connect_object (_tmp2_, "theme-changed", (GCallback) __history_button___lambda23__theme_manager_theme_changed, self, 0);
	return obj;
}

static void
history_button_class_init (HistoryButtonClass * klass,
                           gpointer klass_data)
{
	history_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &HistoryButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_history_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_history_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = history_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = history_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_BUTTON_THEME_MANAGER_PROPERTY, history_button_properties[HISTORY_BUTTON_THEME_MANAGER_PROPERTY] = g_param_spec_object ("theme-manager", "theme-manager", "theme-manager", TYPE_THEME_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Reversi/ui/history-button.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, HistoryButton_private_offset + G_STRUCT_OFFSET (HistoryButtonPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "drawing", FALSE, HistoryButton_private_offset + G_STRUCT_OFFSET (HistoryButtonPrivate, drawing));
}

static void
history_button_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                 gpointer iface_data)
{
	history_button_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) history_button_real_set_window_size;
}

static void
history_button_instance_init (HistoryButton * self,
                              gpointer klass)
{
	self->priv = history_button_get_instance_private (self);
	self->priv->drawing_configured = FALSE;
	self->priv->drawing_height = G_MININT;
	self->priv->drawing_width = G_MININT;
	self->priv->arrow_half_width = -DBL_MAX;
	self->priv->board_x = G_MININT;
	self->priv->board_y = G_MININT;
	self->priv->tiles_pattern = NULL;
	self->priv->current_player = PLAYER_NONE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
history_button_finalize (GObject * obj)
{
	HistoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_BUTTON, HistoryButton);
	_g_object_unref0 (self->priv->_theme_manager);
	_g_object_unref0 (self->priv->tileset_pixbuf);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	G_OBJECT_CLASS (history_button_parent_class)->finalize (obj);
}

static GType
history_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryButton), 0, (GInstanceInitFunc) history_button_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) history_button_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType history_button_type_id;
	history_button_type_id = g_type_register_static (gtk_menu_button_get_type (), "HistoryButton", &g_define_type_info, 0);
	g_type_add_interface_static (history_button_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	HistoryButton_private_offset = g_type_add_instance_private (history_button_type_id, sizeof (HistoryButtonPrivate));
	return history_button_type_id;
}

GType
history_button_get_type (void)
{
	static volatile gsize history_button_type_id__once = 0;
	if (g_once_init_enter (&history_button_type_id__once)) {
		GType history_button_type_id;
		history_button_type_id = history_button_get_type_once ();
		g_once_init_leave (&history_button_type_id__once, history_button_type_id);
	}
	return history_button_type_id__once;
}

static void
_vala_history_button_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	HistoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_BUTTON, HistoryButton);
	switch (property_id) {
		case HISTORY_BUTTON_THEME_MANAGER_PROPERTY:
		g_value_set_object (value, history_button_get_theme_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_history_button_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	HistoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_BUTTON, HistoryButton);
	switch (property_id) {
		case HISTORY_BUTTON_THEME_MANAGER_PROPERTY:
		history_button_set_theme_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

