{-# LANGUAGE OverloadedStrings #-}
module Clay.Attributes where

import Clay.Selector

-- From: http://www.whatwg.org/specs/web-apps/current-work/multipage/section-index.html#index

accept, acceptCharset, accesskey, action, alt, async, autocomplete, autofocus,
  autoplay, challenge, charset, checked, class_, cols, colspan, content,
  contenteditable, contextmenu, controls, coords, crossorigin, datetime,
  default_, defer, dir, dirname, disabled, download, draggable, dropzone,
  enctype, for, formaction, formenctype, formmethod, formnovalidate,
  formtarget, headers, height, hidden, high, href, hreflang, httpEquiv, icon,
  id, inert, inputmode, ismap, itemid, itemprop, itemref, itemscope, itemtype,
  keytype, kind, lang, list, loop, low, manifest, max, maxlength, media,
  mediagroup, method, min, multiple, muted, name, novalidate, open, optimum,
  pattern, ping, placeholder, poster, preload, radiogroup, readonly, rel,
  required, reversed, rows, rowspan, sandbox, scope, scoped, seamless,
  selected, shape, size, sizes, spellcheck, src, srcdoc, srclang, srcset,
  start, step, tabindex, target, translate, type_, typemustmatch, usemap,
  value, width, wrap :: Refinement

accept = "accept"
acceptCharset = "accept-charset"
accesskey = "accesskey"
action = "action"
alt = "alt"
async = "async"
autocomplete = "autocomplete"
autofocus = "autofocus"
autoplay = "autoplay"
challenge = "challenge"
charset = "charset"
checked = "checked"
class_ = "class"
cols = "cols"
colspan = "colspan"
content = "content"
contenteditable = "contenteditable"
contextmenu = "contextmenu"
controls = "controls"
coords = "coords"
crossorigin = "crossorigin"
datetime = "datetime"
default_ = "default"
defer = "defer"
dir = "dir"
dirname = "dirname"
disabled = "disabled"
download = "download"
draggable = "draggable"
dropzone = "dropzone"
enctype = "enctype"
for = "for"
formaction = "formaction"
formenctype = "formenctype"
formmethod = "formmethod"
formnovalidate = "formnovalidate"
formtarget = "formtarget"
headers = "headers"
height = "height"
hidden = "hidden"
high = "high"
href = "href"
hreflang = "hreflang"
httpEquiv = "http-equiv"
icon = "icon"
id = "id"
inert = "inert"
inputmode = "inputmode"
ismap = "ismap"
itemid = "itemid"
itemprop = "itemprop"
itemref = "itemref"
itemscope = "itemscope"
itemtype = "itemtype"
keytype = "keytype"
kind = "kind"
lang = "lang"
list = "list"
loop = "loop"
low = "low"
manifest = "manifest"
max = "max"
maxlength = "maxlength"
media = "media"
mediagroup = "mediagroup"
method = "method"
min = "min"
multiple = "multiple"
muted = "muted"
name = "name"
novalidate = "novalidate"
open = "open"
optimum = "optimum"
pattern = "pattern"
ping = "ping"
placeholder = "placeholder"
poster = "poster"
preload = "preload"
radiogroup = "radiogroup"
readonly = "readonly"
rel = "rel"
required = "required"
reversed = "reversed"
rows = "rows"
rowspan = "rowspan"
sandbox = "sandbox"
scope = "scope"
scoped = "scoped"
seamless = "seamless"
selected = "selected"
shape = "shape"
size = "size"
sizes = "sizes"
spellcheck = "spellcheck"
src = "src"
srcdoc = "srcdoc"
srclang = "srclang"
srcset = "srcset"
start = "start"
step = "step"
tabindex = "tabindex"
target = "target"
translate = "translate"
type_ = "type"
typemustmatch = "typemustmatch"
usemap = "usemap"
value = "value"
width = "width"
wrap = "wrap"

