/* centerRenderer.c generated by valac 0.56.18, the Vala compiler
 * generated from centerRenderer.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_CENTER_RENDERER (gnome_pie_center_renderer_get_type ())
#define GNOME_PIE_CENTER_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_CENTER_RENDERER, GnomePieCenterRenderer))
#define GNOME_PIE_CENTER_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_CENTER_RENDERER, GnomePieCenterRendererClass))
#define GNOME_PIE_IS_CENTER_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_CENTER_RENDERER))
#define GNOME_PIE_IS_CENTER_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_CENTER_RENDERER))
#define GNOME_PIE_CENTER_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_CENTER_RENDERER, GnomePieCenterRendererClass))

typedef struct _GnomePieCenterRenderer GnomePieCenterRenderer;
typedef struct _GnomePieCenterRendererClass GnomePieCenterRendererClass;
typedef struct _GnomePieCenterRendererPrivate GnomePieCenterRendererPrivate;

#define GNOME_PIE_TYPE_PIE_RENDERER (gnome_pie_pie_renderer_get_type ())
#define GNOME_PIE_PIE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_PIE_RENDERER, GnomePiePieRenderer))
#define GNOME_PIE_PIE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_PIE_RENDERER, GnomePiePieRendererClass))
#define GNOME_PIE_IS_PIE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_PIE_RENDERER))
#define GNOME_PIE_IS_PIE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_PIE_RENDERER))
#define GNOME_PIE_PIE_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_PIE_RENDERER, GnomePiePieRendererClass))

typedef struct _GnomePiePieRenderer GnomePiePieRenderer;
typedef struct _GnomePiePieRendererClass GnomePiePieRendererClass;

#define GNOME_PIE_TYPE_IMAGE (gnome_pie_image_get_type ())
#define GNOME_PIE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImage))
#define GNOME_PIE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))
#define GNOME_PIE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))

typedef struct _GnomePieImage GnomePieImage;
typedef struct _GnomePieImageClass GnomePieImageClass;

#define GNOME_PIE_TYPE_COLOR (gnome_pie_color_get_type ())
#define GNOME_PIE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_COLOR, GnomePieColor))
#define GNOME_PIE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_COLOR, GnomePieColorClass))
#define GNOME_PIE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_COLOR))
#define GNOME_PIE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_COLOR))
#define GNOME_PIE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_COLOR, GnomePieColorClass))

typedef struct _GnomePieColor GnomePieColor;
typedef struct _GnomePieColorClass GnomePieColorClass;

#define GNOME_PIE_TYPE_ANIMATED_VALUE (gnome_pie_animated_value_get_type ())
#define GNOME_PIE_ANIMATED_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValue))
#define GNOME_PIE_ANIMATED_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValueClass))
#define GNOME_PIE_IS_ANIMATED_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_ANIMATED_VALUE))
#define GNOME_PIE_IS_ANIMATED_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_ANIMATED_VALUE))
#define GNOME_PIE_ANIMATED_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValueClass))

typedef struct _GnomePieAnimatedValue GnomePieAnimatedValue;
typedef struct _GnomePieAnimatedValueClass GnomePieAnimatedValueClass;
enum  {
	GNOME_PIE_CENTER_RENDERER_0_PROPERTY,
	GNOME_PIE_CENTER_RENDERER_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_center_renderer_properties[GNOME_PIE_CENTER_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_PIE_TYPE_CONFIG (gnome_pie_config_get_type ())
#define GNOME_PIE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_CONFIG, GnomePieConfig))
#define GNOME_PIE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_CONFIG, GnomePieConfigClass))
#define GNOME_PIE_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_CONFIG))
#define GNOME_PIE_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_CONFIG))
#define GNOME_PIE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_CONFIG, GnomePieConfigClass))

typedef struct _GnomePieConfig GnomePieConfig;
typedef struct _GnomePieConfigClass GnomePieConfigClass;

#define GNOME_PIE_TYPE_THEME (gnome_pie_theme_get_type ())
#define GNOME_PIE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_THEME, GnomePieTheme))
#define GNOME_PIE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_THEME, GnomePieThemeClass))
#define GNOME_PIE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_THEME))
#define GNOME_PIE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_THEME))
#define GNOME_PIE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_THEME, GnomePieThemeClass))

typedef struct _GnomePieTheme GnomePieTheme;
typedef struct _GnomePieThemeClass GnomePieThemeClass;

#define GNOME_PIE_TYPE_SLICE_RENDERER (gnome_pie_slice_renderer_get_type ())
#define GNOME_PIE_SLICE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_SLICE_RENDERER, GnomePieSliceRenderer))
#define GNOME_PIE_SLICE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_SLICE_RENDERER, GnomePieSliceRendererClass))
#define GNOME_PIE_IS_SLICE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_SLICE_RENDERER))
#define GNOME_PIE_IS_SLICE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_SLICE_RENDERER))
#define GNOME_PIE_SLICE_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_SLICE_RENDERER, GnomePieSliceRendererClass))

typedef struct _GnomePieSliceRenderer GnomePieSliceRenderer;
typedef struct _GnomePieSliceRendererClass GnomePieSliceRendererClass;

#define GNOME_PIE_TYPE_CENTER_LAYER (gnome_pie_center_layer_get_type ())
#define GNOME_PIE_CENTER_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_CENTER_LAYER, GnomePieCenterLayer))
#define GNOME_PIE_CENTER_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_CENTER_LAYER, GnomePieCenterLayerClass))
#define GNOME_PIE_IS_CENTER_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_CENTER_LAYER))
#define GNOME_PIE_IS_CENTER_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_CENTER_LAYER))
#define GNOME_PIE_CENTER_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_CENTER_LAYER, GnomePieCenterLayerClass))

typedef struct _GnomePieCenterLayer GnomePieCenterLayer;
typedef struct _GnomePieCenterLayerClass GnomePieCenterLayerClass;
typedef enum  {
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MOUSE,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_ACTIVE,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_12,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_24,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MINUTE,
	GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_SECOND
} GnomePieCenterLayerRotationMode;

#define GNOME_PIE_CENTER_LAYER_TYPE_ROTATION_MODE (gnome_pie_center_layer_rotation_mode_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GnomePieCenterRenderer {
	GObject parent_instance;
	GnomePieCenterRendererPrivate * priv;
};

struct _GnomePieCenterRendererClass {
	GObjectClass parent_class;
};

struct _GnomePieCenterRendererPrivate {
	GnomePiePieRenderer* parent;
	GnomePieImage* caption;
	GnomePieColor* color;
	GnomePieAnimatedValue* activity;
	GnomePieAnimatedValue* alpha;
};

static gint GnomePieCenterRenderer_private_offset;
static gpointer gnome_pie_center_renderer_parent_class = NULL;

VALA_EXTERN GType gnome_pie_center_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieCenterRenderer, g_object_unref)
VALA_EXTERN GType gnome_pie_pie_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePiePieRenderer, g_object_unref)
VALA_EXTERN GType gnome_pie_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieImage, g_object_unref)
VALA_EXTERN GType gnome_pie_color_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieColor, g_object_unref)
VALA_EXTERN GType gnome_pie_animated_value_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieAnimatedValue, g_object_unref)
VALA_EXTERN GnomePieCenterRenderer* gnome_pie_center_renderer_new (GnomePiePieRenderer* parent);
VALA_EXTERN GnomePieCenterRenderer* gnome_pie_center_renderer_construct (GType object_type,
                                                             GnomePiePieRenderer* parent);
VALA_EXTERN GType gnome_pie_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieConfig, g_object_unref)
VALA_EXTERN GnomePieConfig* gnome_pie_config_get_global (void);
VALA_EXTERN GType gnome_pie_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieTheme, g_object_unref)
VALA_EXTERN GnomePieTheme* gnome_pie_config_get_theme (GnomePieConfig* self);
VALA_EXTERN gdouble gnome_pie_theme_get_transition_time (GnomePieTheme* self);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_new_linear (gdouble start,
                                                            gdouble end,
                                                            gdouble duration);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_construct_linear (GType object_type,
                                                                  gdouble start,
                                                                  gdouble end,
                                                                  gdouble duration);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_in_time (GnomePieTheme* self);
VALA_EXTERN GnomePieColor* gnome_pie_color_new (void);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct (GType object_type);
VALA_EXTERN void gnome_pie_center_renderer_fade_out (GnomePieCenterRenderer* self);
VALA_EXTERN void gnome_pie_animated_value_reset_target (GnomePieAnimatedValue* self,
                                            gdouble end,
                                            gdouble duration);
VALA_EXTERN gdouble gnome_pie_theme_get_fade_out_time (GnomePieTheme* self);
VALA_EXTERN GType gnome_pie_slice_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieSliceRenderer, g_object_unref)
VALA_EXTERN void gnome_pie_center_renderer_set_active_slice (GnomePieCenterRenderer* self,
                                                 GnomePieSliceRenderer* active_slice);
VALA_EXTERN GnomePieImage* gnome_pie_slice_renderer_get_caption (GnomePieSliceRenderer* self);
VALA_EXTERN GnomePieColor* gnome_pie_slice_renderer_get_color (GnomePieSliceRenderer* self);
VALA_EXTERN void gnome_pie_center_renderer_draw (GnomePieCenterRenderer* self,
                                     gdouble frame_time,
                                     cairo_t* ctx,
                                     gdouble angle,
                                     gint slice_track);
VALA_EXTERN GType gnome_pie_center_layer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieCenterLayer, g_object_unref)
VALA_EXTERN GeeArrayList* gnome_pie_theme_get_center_layers (GnomePieTheme* self);
VALA_EXTERN void gnome_pie_animated_value_update (GnomePieAnimatedValue* self,
                                      gdouble time);
VALA_EXTERN gdouble gnome_pie_center_layer_get_active_scale (GnomePieCenterLayer* self);
VALA_EXTERN gdouble gnome_pie_animated_value_get_val (GnomePieAnimatedValue* self);
VALA_EXTERN gdouble gnome_pie_center_layer_get_inactive_scale (GnomePieCenterLayer* self);
VALA_EXTERN gdouble gnome_pie_center_layer_get_active_alpha (GnomePieCenterLayer* self);
VALA_EXTERN gdouble gnome_pie_center_layer_get_inactive_alpha (GnomePieCenterLayer* self);
VALA_EXTERN gboolean gnome_pie_center_layer_get_active_colorize (GnomePieCenterLayer* self);
VALA_EXTERN gboolean gnome_pie_center_layer_get_inactive_colorize (GnomePieCenterLayer* self);
VALA_EXTERN gdouble gnome_pie_center_layer_get_active_rotation_speed (GnomePieCenterLayer* self);
VALA_EXTERN gdouble gnome_pie_center_layer_get_inactive_rotation_speed (GnomePieCenterLayer* self);
VALA_EXTERN GType gnome_pie_center_layer_rotation_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GnomePieCenterLayerRotationMode gnome_pie_center_layer_get_active_rotation_mode (GnomePieCenterLayer* self);
VALA_EXTERN GnomePieCenterLayerRotationMode gnome_pie_center_layer_get_inactive_rotation_mode (GnomePieCenterLayer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_total_slice_count (GnomePiePieRenderer* self);
VALA_EXTERN gdouble gnome_pie_center_layer_get_rotation (GnomePieCenterLayer* self);
VALA_EXTERN void gnome_pie_center_layer_set_rotation (GnomePieCenterLayer* self,
                                          gdouble value);
VALA_EXTERN GnomePieImage* gnome_pie_center_layer_get_image (GnomePieCenterLayer* self);
VALA_EXTERN void gnome_pie_image_paint_on (GnomePieImage* self,
                               cairo_t* ctx,
                               gdouble alpha);
VALA_EXTERN gfloat gnome_pie_color_get_r (GnomePieColor* self);
VALA_EXTERN gfloat gnome_pie_color_get_g (GnomePieColor* self);
VALA_EXTERN gfloat gnome_pie_color_get_b (GnomePieColor* self);
VALA_EXTERN gboolean gnome_pie_theme_get_caption (GnomePieTheme* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_original_visible_slice_count (GnomePiePieRenderer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_slice_count (GnomePiePieRenderer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_first_slice_idx (GnomePiePieRenderer* self);
VALA_EXTERN gdouble gnome_pie_theme_get_center_radius (GnomePieTheme* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_center_x (GnomePiePieRenderer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_size_w (GnomePiePieRenderer* self);
VALA_EXTERN gint gnome_pie_pie_renderer_get_center_y (GnomePiePieRenderer* self);
static void gnome_pie_center_renderer_finalize (GObject * obj);
static GType gnome_pie_center_renderer_get_type_once (void);

static inline gpointer
gnome_pie_center_renderer_get_instance_private (GnomePieCenterRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePieCenterRenderer_private_offset);
}

GnomePieCenterRenderer*
gnome_pie_center_renderer_construct (GType object_type,
                                     GnomePiePieRenderer* parent)
{
	GnomePieCenterRenderer * self = NULL;
	GnomePieConfig* _tmp0_;
	GnomePieConfig* _tmp1_;
	GnomePieTheme* _tmp2_;
	GnomePieTheme* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GnomePieAnimatedValue* _tmp6_;
	GnomePieConfig* _tmp7_;
	GnomePieConfig* _tmp8_;
	GnomePieTheme* _tmp9_;
	GnomePieTheme* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GnomePieAnimatedValue* _tmp13_;
	GnomePieColor* _tmp14_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (GnomePieCenterRenderer*) g_object_new (object_type, NULL);
	self->priv->parent = parent;
	_tmp0_ = gnome_pie_config_get_global ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gnome_pie_config_get_theme (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gnome_pie_theme_get_transition_time (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gnome_pie_animated_value_new_linear (0.0, 0.0, _tmp5_);
	_g_object_unref0 (self->priv->activity);
	self->priv->activity = _tmp6_;
	_tmp7_ = gnome_pie_config_get_global ();
	_tmp8_ = _tmp7_;
	_tmp9_ = gnome_pie_config_get_theme (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gnome_pie_theme_get_fade_in_time (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gnome_pie_animated_value_new_linear (0.0, 1.0, _tmp12_);
	_g_object_unref0 (self->priv->alpha);
	self->priv->alpha = _tmp13_;
	_tmp14_ = gnome_pie_color_new ();
	_g_object_unref0 (self->priv->color);
	self->priv->color = _tmp14_;
	self->priv->caption = NULL;
	return self;
}

GnomePieCenterRenderer*
gnome_pie_center_renderer_new (GnomePiePieRenderer* parent)
{
	return gnome_pie_center_renderer_construct (GNOME_PIE_TYPE_CENTER_RENDERER, parent);
}

void
gnome_pie_center_renderer_fade_out (GnomePieCenterRenderer* self)
{
	GnomePieAnimatedValue* _tmp0_;
	GnomePieConfig* _tmp1_;
	GnomePieConfig* _tmp2_;
	GnomePieTheme* _tmp3_;
	GnomePieTheme* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GnomePieAnimatedValue* _tmp7_;
	GnomePieConfig* _tmp8_;
	GnomePieConfig* _tmp9_;
	GnomePieTheme* _tmp10_;
	GnomePieTheme* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->activity;
	_tmp1_ = gnome_pie_config_get_global ();
	_tmp2_ = _tmp1_;
	_tmp3_ = gnome_pie_config_get_theme (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gnome_pie_theme_get_fade_out_time (_tmp4_);
	_tmp6_ = _tmp5_;
	gnome_pie_animated_value_reset_target (_tmp0_, 0.0, _tmp6_);
	_tmp7_ = self->priv->alpha;
	_tmp8_ = gnome_pie_config_get_global ();
	_tmp9_ = _tmp8_;
	_tmp10_ = gnome_pie_config_get_theme (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gnome_pie_theme_get_fade_out_time (_tmp11_);
	_tmp13_ = _tmp12_;
	gnome_pie_animated_value_reset_target (_tmp7_, 0.0, _tmp13_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gnome_pie_center_renderer_set_active_slice (GnomePieCenterRenderer* self,
                                            GnomePieSliceRenderer* active_slice)
{
	g_return_if_fail (self != NULL);
	if (active_slice == NULL) {
		GnomePieAnimatedValue* _tmp0_;
		GnomePieConfig* _tmp1_;
		GnomePieConfig* _tmp2_;
		GnomePieTheme* _tmp3_;
		GnomePieTheme* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp0_ = self->priv->activity;
		_tmp1_ = gnome_pie_config_get_global ();
		_tmp2_ = _tmp1_;
		_tmp3_ = gnome_pie_config_get_theme (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gnome_pie_theme_get_transition_time (_tmp4_);
		_tmp6_ = _tmp5_;
		gnome_pie_animated_value_reset_target (_tmp0_, 0.0, _tmp6_);
	} else {
		GnomePieAnimatedValue* _tmp7_;
		GnomePieConfig* _tmp8_;
		GnomePieConfig* _tmp9_;
		GnomePieTheme* _tmp10_;
		GnomePieTheme* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		GnomePieImage* _tmp14_;
		GnomePieImage* _tmp15_;
		GnomePieColor* _tmp16_;
		GnomePieColor* _tmp17_;
		GnomePieColor* _tmp18_;
		_tmp7_ = self->priv->activity;
		_tmp8_ = gnome_pie_config_get_global ();
		_tmp9_ = _tmp8_;
		_tmp10_ = gnome_pie_config_get_theme (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gnome_pie_theme_get_transition_time (_tmp11_);
		_tmp13_ = _tmp12_;
		gnome_pie_animated_value_reset_target (_tmp7_, 1.0, _tmp13_);
		_tmp14_ = gnome_pie_slice_renderer_get_caption (active_slice);
		_tmp15_ = _tmp14_;
		self->priv->caption = _tmp15_;
		_tmp16_ = gnome_pie_slice_renderer_get_color (active_slice);
		_tmp17_ = _tmp16_;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (self->priv->color);
		self->priv->color = _tmp18_;
	}
}

void
gnome_pie_center_renderer_draw (GnomePieCenterRenderer* self,
                                gdouble frame_time,
                                cairo_t* ctx,
                                gdouble angle,
                                gint slice_track)
{
	GeeArrayList* layers = NULL;
	GnomePieConfig* _tmp0_;
	GnomePieConfig* _tmp1_;
	GnomePieTheme* _tmp2_;
	GnomePieTheme* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GnomePieAnimatedValue* _tmp7_;
	GnomePieAnimatedValue* _tmp8_;
	gboolean _tmp136_ = FALSE;
	gboolean _tmp137_ = FALSE;
	GnomePieConfig* _tmp138_;
	GnomePieConfig* _tmp139_;
	GnomePieTheme* _tmp140_;
	GnomePieTheme* _tmp141_;
	gboolean _tmp142_;
	gboolean _tmp143_;
	gboolean _tmp157_ = FALSE;
	gboolean _tmp158_ = FALSE;
	GnomePieAnimatedValue* _tmp159_;
	gdouble _tmp160_;
	gdouble _tmp161_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp0_ = gnome_pie_config_get_global ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gnome_pie_config_get_theme (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gnome_pie_theme_get_center_layers (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	layers = _tmp6_;
	_tmp7_ = self->priv->activity;
	gnome_pie_animated_value_update (_tmp7_, frame_time);
	_tmp8_ = self->priv->alpha;
	gnome_pie_animated_value_update (_tmp8_, frame_time);
	{
		GeeArrayList* _layer_list = NULL;
		GeeArrayList* _tmp9_;
		gint _layer_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _layer_index = 0;
		_tmp9_ = layers;
		_layer_list = _tmp9_;
		_tmp10_ = _layer_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_layer_size = _tmp12_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			GnomePieCenterLayer* layer = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			gdouble max_scale = 0.0;
			GnomePieCenterLayer* _tmp17_;
			gdouble _tmp18_;
			gdouble _tmp19_;
			GnomePieAnimatedValue* _tmp20_;
			gdouble _tmp21_;
			gdouble _tmp22_;
			GnomePieCenterLayer* _tmp23_;
			gdouble _tmp24_;
			gdouble _tmp25_;
			GnomePieAnimatedValue* _tmp26_;
			gdouble _tmp27_;
			gdouble _tmp28_;
			gdouble max_alpha = 0.0;
			GnomePieCenterLayer* _tmp29_;
			gdouble _tmp30_;
			gdouble _tmp31_;
			GnomePieAnimatedValue* _tmp32_;
			gdouble _tmp33_;
			gdouble _tmp34_;
			GnomePieCenterLayer* _tmp35_;
			gdouble _tmp36_;
			gdouble _tmp37_;
			GnomePieAnimatedValue* _tmp38_;
			gdouble _tmp39_;
			gdouble _tmp40_;
			gdouble _tmp41_ = 0.0;
			GnomePieCenterLayer* _tmp42_;
			gboolean _tmp43_;
			gboolean _tmp44_;
			gdouble _tmp48_ = 0.0;
			GnomePieCenterLayer* _tmp49_;
			gboolean _tmp50_;
			gboolean _tmp51_;
			gdouble colorize = 0.0;
			gdouble max_rotation_speed = 0.0;
			GnomePieCenterLayer* _tmp55_;
			gdouble _tmp56_;
			gdouble _tmp57_;
			GnomePieAnimatedValue* _tmp58_;
			gdouble _tmp59_;
			gdouble _tmp60_;
			GnomePieCenterLayer* _tmp61_;
			gdouble _tmp62_;
			gdouble _tmp63_;
			GnomePieAnimatedValue* _tmp64_;
			gdouble _tmp65_;
			gdouble _tmp66_;
			GnomePieCenterLayerRotationMode _tmp67_ = 0;
			GnomePieAnimatedValue* _tmp68_;
			gdouble _tmp69_;
			gdouble _tmp70_;
			GnomePieCenterLayerRotationMode rotation_mode = 0;
			gdouble direction = 0.0;
			GnomePieCenterLayer* _tmp114_;
			GnomePieCenterLayer* _tmp115_;
			gdouble _tmp116_;
			gdouble _tmp117_;
			GnomePieCenterLayer* _tmp118_;
			gdouble _tmp119_;
			gdouble _tmp120_;
			GnomePieCenterLayer* _tmp121_;
			GnomePieImage* _tmp122_;
			GnomePieImage* _tmp123_;
			GnomePieAnimatedValue* _tmp124_;
			gdouble _tmp125_;
			gdouble _tmp126_;
			_layer_index = _layer_index + 1;
			_tmp13_ = _layer_index;
			_tmp14_ = _layer_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _layer_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _layer_index);
			layer = (GnomePieCenterLayer*) _tmp16_;
			cairo_save (ctx);
			_tmp17_ = layer;
			_tmp18_ = gnome_pie_center_layer_get_active_scale (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->activity;
			_tmp21_ = gnome_pie_animated_value_get_val (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = layer;
			_tmp24_ = gnome_pie_center_layer_get_inactive_scale (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->activity;
			_tmp27_ = gnome_pie_animated_value_get_val (_tmp26_);
			_tmp28_ = _tmp27_;
			max_scale = (_tmp19_ * _tmp22_) + (_tmp25_ * (1.0 - _tmp28_));
			_tmp29_ = layer;
			_tmp30_ = gnome_pie_center_layer_get_active_alpha (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->activity;
			_tmp33_ = gnome_pie_animated_value_get_val (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = layer;
			_tmp36_ = gnome_pie_center_layer_get_inactive_alpha (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = self->priv->activity;
			_tmp39_ = gnome_pie_animated_value_get_val (_tmp38_);
			_tmp40_ = _tmp39_;
			max_alpha = (_tmp31_ * _tmp34_) + (_tmp37_ * (1.0 - _tmp40_));
			_tmp42_ = layer;
			_tmp43_ = gnome_pie_center_layer_get_active_colorize (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ == TRUE) {
				GnomePieAnimatedValue* _tmp45_;
				gdouble _tmp46_;
				gdouble _tmp47_;
				_tmp45_ = self->priv->activity;
				_tmp46_ = gnome_pie_animated_value_get_val (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp41_ = _tmp47_;
			} else {
				_tmp41_ = 0.0;
			}
			_tmp49_ = layer;
			_tmp50_ = gnome_pie_center_layer_get_inactive_colorize (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_ == TRUE) {
				GnomePieAnimatedValue* _tmp52_;
				gdouble _tmp53_;
				gdouble _tmp54_;
				_tmp52_ = self->priv->activity;
				_tmp53_ = gnome_pie_animated_value_get_val (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp48_ = 1.0 - _tmp54_;
			} else {
				_tmp48_ = 0.0;
			}
			colorize = _tmp41_ + _tmp48_;
			_tmp55_ = layer;
			_tmp56_ = gnome_pie_center_layer_get_active_rotation_speed (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = self->priv->activity;
			_tmp59_ = gnome_pie_animated_value_get_val (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = layer;
			_tmp62_ = gnome_pie_center_layer_get_inactive_rotation_speed (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = self->priv->activity;
			_tmp65_ = gnome_pie_animated_value_get_val (_tmp64_);
			_tmp66_ = _tmp65_;
			max_rotation_speed = (_tmp57_ * _tmp60_) + (_tmp63_ * (1.0 - _tmp66_));
			_tmp68_ = self->priv->activity;
			_tmp69_ = gnome_pie_animated_value_get_val (_tmp68_);
			_tmp70_ = _tmp69_;
			if (_tmp70_ > 0.5) {
				GnomePieCenterLayer* _tmp71_;
				GnomePieCenterLayerRotationMode _tmp72_;
				GnomePieCenterLayerRotationMode _tmp73_;
				_tmp71_ = layer;
				_tmp72_ = gnome_pie_center_layer_get_active_rotation_mode (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp67_ = _tmp73_;
			} else {
				GnomePieCenterLayer* _tmp74_;
				GnomePieCenterLayerRotationMode _tmp75_;
				GnomePieCenterLayerRotationMode _tmp76_;
				_tmp74_ = layer;
				_tmp75_ = gnome_pie_center_layer_get_inactive_rotation_mode (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp67_ = _tmp76_;
			}
			rotation_mode = _tmp67_;
			direction = (gdouble) 0;
			if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MOUSE) {
				direction = angle;
			} else {
				if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_ACTIVE) {
					gdouble _tmp77_ = 0.0;
					GnomePiePieRenderer* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					gdouble slice_angle = 0.0;
					_tmp78_ = self->priv->parent;
					_tmp79_ = gnome_pie_pie_renderer_get_total_slice_count (_tmp78_);
					_tmp80_ = _tmp79_;
					if (_tmp80_ > 0) {
						GnomePiePieRenderer* _tmp81_;
						gint _tmp82_;
						gint _tmp83_;
						_tmp81_ = self->priv->parent;
						_tmp82_ = gnome_pie_pie_renderer_get_total_slice_count (_tmp81_);
						_tmp83_ = _tmp82_;
						_tmp77_ = (2 * G_PI) / _tmp83_;
					} else {
						_tmp77_ = (gdouble) 0;
					}
					slice_angle = _tmp77_;
					direction = ((gint) ((angle + (0.5 * slice_angle)) / slice_angle)) * slice_angle;
				} else {
					if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_SECOND) {
						GDateTime* now = NULL;
						GDateTime* _tmp84_;
						GDateTime* _tmp85_;
						_tmp84_ = g_date_time_new_now_local ();
						now = _tmp84_;
						_tmp85_ = now;
						direction = ((2 * G_PI) * ((g_date_time_get_second (_tmp85_) + 60) - 15)) / 60;
						_g_date_time_unref0 (now);
					} else {
						if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_MINUTE) {
							GDateTime* now = NULL;
							GDateTime* _tmp86_;
							GDateTime* _tmp87_;
							_tmp86_ = g_date_time_new_now_local ();
							now = _tmp86_;
							_tmp87_ = now;
							direction = ((2 * G_PI) * ((g_date_time_get_minute (_tmp87_) + 60) - 15)) / 60;
							_g_date_time_unref0 (now);
						} else {
							if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_24) {
								GDateTime* now = NULL;
								GDateTime* _tmp88_;
								GDateTime* _tmp89_;
								GDateTime* _tmp90_;
								_tmp88_ = g_date_time_new_now_local ();
								now = _tmp88_;
								_tmp89_ = now;
								_tmp90_ = now;
								direction = (((2 * G_PI) * ((g_date_time_get_hour (_tmp89_) + 24) - 6)) / 24) + (((2 * G_PI) * g_date_time_get_minute (_tmp90_)) / (60 * 24));
								_g_date_time_unref0 (now);
							} else {
								if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_TO_HOUR_12) {
									GDateTime* now = NULL;
									GDateTime* _tmp91_;
									GDateTime* _tmp92_;
									GDateTime* _tmp93_;
									_tmp91_ = g_date_time_new_now_local ();
									now = _tmp91_;
									_tmp92_ = now;
									_tmp93_ = now;
									direction = (((2 * G_PI) * ((g_date_time_get_hour (_tmp92_) + 12) - 3)) / 12) + (((2 * G_PI) * g_date_time_get_minute (_tmp93_)) / (60 * 12));
									_g_date_time_unref0 (now);
								}
							}
						}
					}
				}
			}
			if (rotation_mode == GNOME_PIE_CENTER_LAYER_ROTATION_MODE_AUTO) {
				GnomePieCenterLayer* _tmp94_;
				GnomePieCenterLayer* _tmp95_;
				gdouble _tmp96_;
				gdouble _tmp97_;
				_tmp94_ = layer;
				_tmp95_ = layer;
				_tmp96_ = gnome_pie_center_layer_get_rotation (_tmp95_);
				_tmp97_ = _tmp96_;
				gnome_pie_center_layer_set_rotation (_tmp95_, _tmp97_ + (max_rotation_speed * frame_time));
			} else {
				gdouble diff = 0.0;
				GnomePieCenterLayer* _tmp98_;
				gdouble _tmp99_;
				gdouble _tmp100_;
				gdouble _tmp101_ = 0.0;
				gdouble smoothy = 0.0;
				gdouble step = 0.0;
				gboolean _tmp102_ = FALSE;
				direction = fmod (direction, 2 * G_PI);
				_tmp98_ = layer;
				_tmp99_ = gnome_pie_center_layer_get_rotation (_tmp98_);
				_tmp100_ = _tmp99_;
				diff = direction - _tmp100_;
				if (fabs (diff) < 0.9) {
					_tmp101_ = fabs (diff) + 0.1;
				} else {
					_tmp101_ = 1.0;
				}
				smoothy = _tmp101_;
				step = (max_rotation_speed * frame_time) * smoothy;
				if (fabs (diff) <= step) {
					_tmp102_ = TRUE;
				} else {
					_tmp102_ = fabs (diff) >= ((2.0 * G_PI) - step);
				}
				if (_tmp102_) {
					GnomePieCenterLayer* _tmp103_;
					_tmp103_ = layer;
					gnome_pie_center_layer_set_rotation (_tmp103_, direction);
				} else {
					gboolean _tmp104_ = FALSE;
					gboolean _tmp105_ = FALSE;
					if (diff > ((gdouble) 0)) {
						_tmp105_ = diff < G_PI;
					} else {
						_tmp105_ = FALSE;
					}
					if (_tmp105_) {
						_tmp104_ = TRUE;
					} else {
						_tmp104_ = diff < (-G_PI);
					}
					if (_tmp104_) {
						GnomePieCenterLayer* _tmp106_;
						GnomePieCenterLayer* _tmp107_;
						gdouble _tmp108_;
						gdouble _tmp109_;
						_tmp106_ = layer;
						_tmp107_ = layer;
						_tmp108_ = gnome_pie_center_layer_get_rotation (_tmp107_);
						_tmp109_ = _tmp108_;
						gnome_pie_center_layer_set_rotation (_tmp107_, _tmp109_ + step);
					} else {
						GnomePieCenterLayer* _tmp110_;
						GnomePieCenterLayer* _tmp111_;
						gdouble _tmp112_;
						gdouble _tmp113_;
						_tmp110_ = layer;
						_tmp111_ = layer;
						_tmp112_ = gnome_pie_center_layer_get_rotation (_tmp111_);
						_tmp113_ = _tmp112_;
						gnome_pie_center_layer_set_rotation (_tmp111_, _tmp113_ - step);
					}
				}
			}
			_tmp114_ = layer;
			_tmp115_ = layer;
			_tmp116_ = gnome_pie_center_layer_get_rotation (_tmp115_);
			_tmp117_ = _tmp116_;
			gnome_pie_center_layer_set_rotation (_tmp114_, fmod (_tmp117_ + (2 * G_PI), 2 * G_PI));
			if (colorize > 0.0) {
				cairo_push_group (ctx);
			}
			_tmp118_ = layer;
			_tmp119_ = gnome_pie_center_layer_get_rotation (_tmp118_);
			_tmp120_ = _tmp119_;
			cairo_rotate (ctx, _tmp120_);
			cairo_scale (ctx, max_scale, max_scale);
			_tmp121_ = layer;
			_tmp122_ = gnome_pie_center_layer_get_image (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = self->priv->alpha;
			_tmp125_ = gnome_pie_animated_value_get_val (_tmp124_);
			_tmp126_ = _tmp125_;
			gnome_pie_image_paint_on (_tmp123_, ctx, _tmp126_ * max_alpha);
			if (colorize > 0.0) {
				GnomePieColor* _tmp127_;
				gfloat _tmp128_;
				gfloat _tmp129_;
				GnomePieColor* _tmp130_;
				gfloat _tmp131_;
				gfloat _tmp132_;
				GnomePieColor* _tmp133_;
				gfloat _tmp134_;
				gfloat _tmp135_;
				cairo_set_operator (ctx, CAIRO_OPERATOR_ATOP);
				_tmp127_ = self->priv->color;
				_tmp128_ = gnome_pie_color_get_r (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = self->priv->color;
				_tmp131_ = gnome_pie_color_get_g (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = self->priv->color;
				_tmp134_ = gnome_pie_color_get_b (_tmp133_);
				_tmp135_ = _tmp134_;
				cairo_set_source_rgb (ctx, (gdouble) _tmp129_, (gdouble) _tmp132_, (gdouble) _tmp135_);
				cairo_paint_with_alpha (ctx, colorize);
				cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
				cairo_pop_group_to_source (ctx);
				cairo_paint (ctx);
			}
			cairo_restore (ctx);
			_g_object_unref0 (layer);
		}
	}
	_tmp138_ = gnome_pie_config_get_global ();
	_tmp139_ = _tmp138_;
	_tmp140_ = gnome_pie_config_get_theme (_tmp139_);
	_tmp141_ = _tmp140_;
	_tmp142_ = gnome_pie_theme_get_caption (_tmp141_);
	_tmp143_ = _tmp142_;
	if (_tmp143_) {
		GnomePieImage* _tmp144_;
		_tmp144_ = self->priv->caption;
		_tmp137_ = _tmp144_ != NULL;
	} else {
		_tmp137_ = FALSE;
	}
	if (_tmp137_) {
		GnomePieAnimatedValue* _tmp145_;
		gdouble _tmp146_;
		gdouble _tmp147_;
		_tmp145_ = self->priv->activity;
		_tmp146_ = gnome_pie_animated_value_get_val (_tmp145_);
		_tmp147_ = _tmp146_;
		_tmp136_ = _tmp147_ > ((gdouble) 0);
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		gdouble x = 0.0;
		gdouble y = 0.0;
		gdouble _tmp148_ = 0.0;
		gdouble _tmp149_ = 0.0;
		GnomePieImage* _tmp150_;
		GnomePieAnimatedValue* _tmp151_;
		gdouble _tmp152_;
		gdouble _tmp153_;
		GnomePieAnimatedValue* _tmp154_;
		gdouble _tmp155_;
		gdouble _tmp156_;
		cairo_save (ctx);
		cairo_get_current_point (ctx, &_tmp148_, &_tmp149_);
		x = _tmp148_;
		y = _tmp149_;
		cairo_move_to (ctx, floor (x), floor (y));
		_tmp150_ = self->priv->caption;
		_tmp151_ = self->priv->activity;
		_tmp152_ = gnome_pie_animated_value_get_val (_tmp151_);
		_tmp153_ = _tmp152_;
		_tmp154_ = self->priv->alpha;
		_tmp155_ = gnome_pie_animated_value_get_val (_tmp154_);
		_tmp156_ = _tmp155_;
		gnome_pie_image_paint_on (_tmp150_, ctx, _tmp153_ * _tmp156_);
		cairo_restore (ctx);
	}
	_tmp159_ = self->priv->alpha;
	_tmp160_ = gnome_pie_animated_value_get_val (_tmp159_);
	_tmp161_ = _tmp160_;
	if (_tmp161_ > 0.1) {
		GnomePiePieRenderer* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		GnomePiePieRenderer* _tmp165_;
		_tmp162_ = self->priv->parent;
		_tmp163_ = gnome_pie_pie_renderer_get_original_visible_slice_count (_tmp162_);
		_tmp164_ = _tmp163_;
		_tmp165_ = self->priv->parent;
		_tmp158_ = _tmp164_ < gnome_pie_pie_renderer_slice_count (_tmp165_);
	} else {
		_tmp158_ = FALSE;
	}
	if (_tmp158_) {
		GnomePiePieRenderer* _tmp166_;
		gint _tmp167_;
		gint _tmp168_;
		_tmp166_ = self->priv->parent;
		_tmp167_ = gnome_pie_pie_renderer_get_original_visible_slice_count (_tmp166_);
		_tmp168_ = _tmp167_;
		_tmp157_ = _tmp168_ > 0;
	} else {
		_tmp157_ = FALSE;
	}
	if (_tmp157_) {
		gint np = 0;
		GnomePiePieRenderer* _tmp169_;
		GnomePiePieRenderer* _tmp170_;
		gint _tmp171_;
		gint _tmp172_;
		GnomePiePieRenderer* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint cp = 0;
		GnomePiePieRenderer* _tmp176_;
		gint _tmp177_;
		gint _tmp178_;
		GnomePiePieRenderer* _tmp179_;
		gint _tmp180_;
		gint _tmp181_;
		gint r = 0;
		gint dy = 0;
		gdouble a = 0.0;
		GnomePieAnimatedValue* _tmp182_;
		gdouble _tmp183_;
		gdouble _tmp184_;
		gint dx = 0;
		GnomePieConfig* _tmp185_;
		GnomePieConfig* _tmp186_;
		GnomePieTheme* _tmp187_;
		GnomePieTheme* _tmp188_;
		gdouble _tmp189_;
		gdouble _tmp190_;
		GnomePiePieRenderer* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		GnomePiePieRenderer* _tmp194_;
		gint _tmp195_;
		gint _tmp196_;
		GnomePiePieRenderer* _tmp197_;
		gint _tmp198_;
		gint _tmp199_;
		GnomePiePieRenderer* _tmp200_;
		gint _tmp201_;
		gint _tmp202_;
		_tmp169_ = self->priv->parent;
		_tmp170_ = self->priv->parent;
		_tmp171_ = gnome_pie_pie_renderer_get_original_visible_slice_count (_tmp170_);
		_tmp172_ = _tmp171_;
		_tmp173_ = self->priv->parent;
		_tmp174_ = gnome_pie_pie_renderer_get_original_visible_slice_count (_tmp173_);
		_tmp175_ = _tmp174_;
		np = ((gnome_pie_pie_renderer_slice_count (_tmp169_) + _tmp172_) - 1) / _tmp175_;
		_tmp176_ = self->priv->parent;
		_tmp177_ = gnome_pie_pie_renderer_get_first_slice_idx (_tmp176_);
		_tmp178_ = _tmp177_;
		_tmp179_ = self->priv->parent;
		_tmp180_ = gnome_pie_pie_renderer_get_original_visible_slice_count (_tmp179_);
		_tmp181_ = _tmp180_;
		cp = _tmp178_ / _tmp181_;
		r = 8;
		dy = 20;
		_tmp182_ = self->priv->alpha;
		_tmp183_ = gnome_pie_animated_value_get_val (_tmp182_);
		_tmp184_ = _tmp183_;
		a = 0.8 * _tmp184_;
		_tmp185_ = gnome_pie_config_get_global ();
		_tmp186_ = _tmp185_;
		_tmp187_ = gnome_pie_config_get_theme (_tmp186_);
		_tmp188_ = _tmp187_;
		_tmp189_ = gnome_pie_theme_get_center_radius (_tmp188_);
		_tmp190_ = _tmp189_;
		dx = (((gint) _tmp190_) + r) + 10;
		_tmp191_ = self->priv->parent;
		_tmp192_ = gnome_pie_pie_renderer_get_center_x (_tmp191_);
		_tmp193_ = _tmp192_;
		_tmp194_ = self->priv->parent;
		_tmp195_ = gnome_pie_pie_renderer_get_size_w (_tmp194_);
		_tmp196_ = _tmp195_;
		if ((_tmp193_ + dx) > _tmp196_) {
			dx = -dx;
		}
		cairo_save (ctx);
		cairo_identity_matrix (ctx);
		_tmp197_ = self->priv->parent;
		_tmp198_ = gnome_pie_pie_renderer_get_center_x (_tmp197_);
		_tmp199_ = _tmp198_;
		_tmp200_ = self->priv->parent;
		_tmp201_ = gnome_pie_pie_renderer_get_center_y (_tmp200_);
		_tmp202_ = _tmp201_;
		cairo_translate (ctx, (gdouble) (_tmp199_ + dx), (gdouble) (_tmp202_ - (((np - 1) * dy) / 2)));
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp203_ = FALSE;
				_tmp203_ = TRUE;
				while (TRUE) {
					if (!_tmp203_) {
						gint _tmp204_;
						_tmp204_ = i;
						i = _tmp204_ + 1;
					}
					_tmp203_ = FALSE;
					if (!(i < np)) {
						break;
					}
					cairo_arc (ctx, (gdouble) 0, (gdouble) 0, (gdouble) r, (gdouble) 0, 2 * G_PI);
					if (i == cp) {
						cairo_set_source_rgba (ctx, 0.3, 0.3, 0.3, a);
						cairo_stroke_preserve (ctx);
						cairo_set_source_rgba (ctx, (gdouble) 1, (gdouble) 1, (gdouble) 1, a);
						cairo_fill (ctx);
					} else {
						cairo_set_source_rgba (ctx, (gdouble) 1, (gdouble) 1, (gdouble) 1, a);
						cairo_stroke_preserve (ctx);
						cairo_set_source_rgba (ctx, 0.3, 0.3, 0.3, a / 4);
						cairo_fill (ctx);
					}
					cairo_translate (ctx, (gdouble) 0, (gdouble) dy);
				}
			}
		}
		cairo_restore (ctx);
	}
	_g_object_unref0 (layers);
}

static void
gnome_pie_center_renderer_class_init (GnomePieCenterRendererClass * klass,
                                      gpointer klass_data)
{
	gnome_pie_center_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePieCenterRenderer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_center_renderer_finalize;
}

static void
gnome_pie_center_renderer_instance_init (GnomePieCenterRenderer * self,
                                         gpointer klass)
{
	self->priv = gnome_pie_center_renderer_get_instance_private (self);
}

static void
gnome_pie_center_renderer_finalize (GObject * obj)
{
	GnomePieCenterRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_CENTER_RENDERER, GnomePieCenterRenderer);
	_g_object_unref0 (self->priv->color);
	_g_object_unref0 (self->priv->activity);
	_g_object_unref0 (self->priv->alpha);
	G_OBJECT_CLASS (gnome_pie_center_renderer_parent_class)->finalize (obj);
}

static GType
gnome_pie_center_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieCenterRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_center_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieCenterRenderer), 0, (GInstanceInitFunc) gnome_pie_center_renderer_instance_init, NULL };
	GType gnome_pie_center_renderer_type_id;
	gnome_pie_center_renderer_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePieCenterRenderer", &g_define_type_info, 0);
	GnomePieCenterRenderer_private_offset = g_type_add_instance_private (gnome_pie_center_renderer_type_id, sizeof (GnomePieCenterRendererPrivate));
	return gnome_pie_center_renderer_type_id;
}

GType
gnome_pie_center_renderer_get_type (void)
{
	static volatile gsize gnome_pie_center_renderer_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_center_renderer_type_id__once)) {
		GType gnome_pie_center_renderer_type_id;
		gnome_pie_center_renderer_type_id = gnome_pie_center_renderer_get_type_once ();
		g_once_init_leave (&gnome_pie_center_renderer_type_id__once, gnome_pie_center_renderer_type_id);
	}
	return gnome_pie_center_renderer_type_id__once;
}

