/* OrthographyList.c generated by valac 0.56.18, the Vala compiler
 * generated from OrthographyList.vala, do not modify */

/* OrthographyList.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "font-manager.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL (font_manager_orthography_list_model_get_type ())
#define FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModel))
#define FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModelClass))
#define FONT_MANAGER_IS_ORTHOGRAPHY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL))
#define FONT_MANAGER_IS_ORTHOGRAPHY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL))
#define FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModelClass))

typedef struct _FontManagerOrthographyListModel FontManagerOrthographyListModel;
typedef struct _FontManagerOrthographyListModelClass FontManagerOrthographyListModelClass;
typedef struct _FontManagerOrthographyListModelPrivate FontManagerOrthographyListModelPrivate;
enum  {
	FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_0_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ORTHOGRAPHY_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ITEMS_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_orthography_list_model_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_NUM_PROPERTIES];
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block10Data Block10Data;

#define FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW (font_manager_orthography_list_row_get_type ())
#define FONT_MANAGER_ORTHOGRAPHY_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW, FontManagerOrthographyListRow))
#define FONT_MANAGER_ORTHOGRAPHY_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW, FontManagerOrthographyListRowClass))
#define FONT_MANAGER_IS_ORTHOGRAPHY_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW))
#define FONT_MANAGER_IS_ORTHOGRAPHY_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW))
#define FONT_MANAGER_ORTHOGRAPHY_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW, FontManagerOrthographyListRowClass))

typedef struct _FontManagerOrthographyListRow FontManagerOrthographyListRow;
typedef struct _FontManagerOrthographyListRowClass FontManagerOrthographyListRowClass;
typedef struct _FontManagerOrthographyListRowPrivate FontManagerOrthographyListRowPrivate;
enum  {
	FONT_MANAGER_ORTHOGRAPHY_LIST_ROW_0_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* font_manager_orthography_list_row_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST (font_manager_orthography_list_get_type ())
#define FONT_MANAGER_ORTHOGRAPHY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, FontManagerOrthographyList))
#define FONT_MANAGER_ORTHOGRAPHY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, FontManagerOrthographyListClass))
#define FONT_MANAGER_IS_ORTHOGRAPHY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST))
#define FONT_MANAGER_IS_ORTHOGRAPHY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST))
#define FONT_MANAGER_ORTHOGRAPHY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, FontManagerOrthographyListClass))

typedef struct _FontManagerOrthographyList FontManagerOrthographyList;
typedef struct _FontManagerOrthographyListClass FontManagerOrthographyListClass;
typedef struct _FontManagerOrthographyListPrivate FontManagerOrthographyListPrivate;
enum  {
	FONT_MANAGER_ORTHOGRAPHY_LIST_0_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ITEM_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ORTHOGRAPHY_PROPERTY,
	FONT_MANAGER_ORTHOGRAPHY_LIST_NUM_PROPERTIES
};
static GParamSpec* font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_NUM_PROPERTIES];
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	FONT_MANAGER_ORTHOGRAPHY_LIST_ORTHOGRAPHY_SELECTED_SIGNAL,
	FONT_MANAGER_ORTHOGRAPHY_LIST_NUM_SIGNALS
};
static guint font_manager_orthography_list_signals[FONT_MANAGER_ORTHOGRAPHY_LIST_NUM_SIGNALS] = {0};

struct _FontManagerOrthographyListModel {
	GObject parent_instance;
	FontManagerOrthographyListModelPrivate * priv;
};

struct _FontManagerOrthographyListModelClass {
	GObjectClass parent_class;
};

struct _FontManagerOrthographyListModelPrivate {
	JsonObject* _orthography;
	GPtrArray* _items;
};

struct _Block10Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _FontManagerOrthographyListRow {
	GtkGrid parent_instance;
	FontManagerOrthographyListRowPrivate * priv;
};

struct _FontManagerOrthographyListRowClass {
	GtkGridClass parent_class;
};

struct _FontManagerOrthographyListRowPrivate {
	GtkLabel* C_name;
	GtkLabel* native_name;
	GtkLevelBar* coverage;
};

struct _FontManagerOrthographyList {
	GtkBox parent_instance;
	FontManagerOrthographyListPrivate * priv;
};

struct _FontManagerOrthographyListClass {
	GtkBoxClass parent_class;
};

struct _FontManagerOrthographyListPrivate {
	GObject* _selected_item;
	FontManagerOrthographyListModel* _model;
	FontManagerOrthography* _selected_orthography;
	gboolean _visible_;
	gboolean update_pending;
	GtkLabel* header;
	GtkListBox* list;
	GtkRevealer* clear_revealer;
	FontManagerPlaceHolder* place_holder;
	gint selected_index;
};

static gint FontManagerOrthographyListModel_private_offset;
static gpointer font_manager_orthography_list_model_parent_class = NULL;
static GListModelInterface * font_manager_orthography_list_model_g_list_model_parent_iface = NULL;
static gint FontManagerOrthographyListRow_private_offset;
static gpointer font_manager_orthography_list_row_parent_class = NULL;
static gint FontManagerOrthographyList_private_offset;
static gpointer font_manager_orthography_list_parent_class = NULL;

VALA_EXTERN gchar* GET_ORTH_FOR (const gchar* f,
                     gint i);
VALA_EXTERN gchar* GET_BASE_ORTH_FOR (const gchar* f);
VALA_EXTERN const gchar* GET_NAME (JsonObject* o);
VALA_EXTERN gdouble GET_COVERAGE (JsonObject* o);
VALA_EXTERN GType font_manager_orthography_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerOrthographyListModel, g_object_unref)
static GType font_manager_orthography_list_model_real_get_item_type (GListModel* base);
static guint font_manager_orthography_list_model_real_get_n_items (GListModel* base);
VALA_EXTERN GPtrArray* font_manager_orthography_list_model_get_items (FontManagerOrthographyListModel* self);
static GObject* font_manager_orthography_list_model_real_get_item (GListModel* base,
                                                            guint position);
static void font_manager_orthography_list_model_update_items (FontManagerOrthographyListModel* self);
static void font_manager_orthography_list_model_set_items (FontManagerOrthographyListModel* self,
                                                    GPtrArray* value);
VALA_EXTERN JsonObject* font_manager_orthography_list_model_get_orthography (FontManagerOrthographyListModel* self);
static void ___lambda73_ (FontManagerOrthographyListModel* self,
                   JsonObject* object,
                   const gchar* name,
                   JsonNode* node);
static void ____lambda73__json_object_foreach (JsonObject* object,
                                        const gchar* member_name,
                                        JsonNode* member_node,
                                        gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint ___lambda74_ (JsonObject* a,
                   JsonObject* b);
static gint ____lambda74__gcompare_func (gconstpointer a,
                                  gconstpointer b);
VALA_EXTERN FontManagerOrthographyListModel* font_manager_orthography_list_model_new (void);
VALA_EXTERN FontManagerOrthographyListModel* font_manager_orthography_list_model_construct (GType object_type);
VALA_EXTERN void font_manager_orthography_list_model_set_orthography (FontManagerOrthographyListModel* self,
                                                          JsonObject* value);
static GObject * font_manager_orthography_list_model_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void _font_manager_orthography_list_model___lambda75_ (FontManagerOrthographyListModel* self);
static void __font_manager_orthography_list_model___lambda75__g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void font_manager_orthography_list_model_finalize (GObject * obj);
static GType font_manager_orthography_list_model_get_type_once (void);
static void _vala_font_manager_orthography_list_model_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_font_manager_orthography_list_model_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
VALA_EXTERN GType font_manager_orthography_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerOrthographyListRow, g_object_unref)
VALA_EXTERN FontManagerOrthographyListRow* font_manager_orthography_list_row_from_item (GObject* item);
VALA_EXTERN FontManagerOrthographyListRow* font_manager_orthography_list_row_new (void);
VALA_EXTERN FontManagerOrthographyListRow* font_manager_orthography_list_row_construct (GType object_type);
static void font_manager_orthography_list_row_finalize (GObject * obj);
static GType font_manager_orthography_list_row_get_type_once (void);
VALA_EXTERN GType font_manager_orthography_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerOrthographyList, g_object_unref)
VALA_EXTERN FontManagerOrthographyList* font_manager_orthography_list_new (void);
VALA_EXTERN FontManagerOrthographyList* font_manager_orthography_list_construct (GType object_type);
static void __lambda76_ (FontManagerOrthographyList* self);
VALA_EXTERN FontManagerOrthographyListModel* font_manager_orthography_list_get_model (FontManagerOrthographyList* self);
static GtkWidget* _font_manager_orthography_list_row_from_item_gtk_list_box_create_widget_func (GObject* item,
                                                                                         gpointer self);
static void ___lambda76__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void font_manager_orthography_list_set_model (FontManagerOrthographyList* self,
                                              FontManagerOrthographyListModel* value);
static void __lambda77_ (FontManagerOrthographyList* self);
static void font_manager_orthography_list_update_if_needed (FontManagerOrthographyList* self);
static void ___lambda77__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void font_manager_orthography_list_on_clear_clicked (FontManagerOrthographyList* self);
static void _font_manager_orthography_list_on_clear_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void font_manager_orthography_list_on_list_row_selected (FontManagerOrthographyList* self,
                                                         GtkListBox* box,
                                                         GtkListBoxRow* row);
VALA_EXTERN void font_manager_orthography_list_set_selected_orthography (FontManagerOrthographyList* self,
                                                             FontManagerOrthography* value);
VALA_EXTERN FontManagerOrthography* font_manager_orthography_list_get_selected_orthography (FontManagerOrthographyList* self);
static void _font_manager_orthography_list_on_list_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                                    GtkListBoxRow* row,
                                                                                    gpointer self);
static void font_manager_orthography_list_on_map_event (FontManagerOrthographyList* self);
static void _font_manager_orthography_list_on_map_event_gtk_widget_map (GtkWidget* _sender,
                                                                 gpointer self);
static void font_manager_orthography_list_on_unmap_event (FontManagerOrthographyList* self);
static void _font_manager_orthography_list_on_unmap_event_gtk_widget_unmap (GtkWidget* _sender,
                                                                     gpointer self);
static JsonObject* font_manager_orthography_list_parse_json_result (FontManagerOrthographyList* self,
                                                             const gchar* json);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void font_manager_orthography_list_update_model (FontManagerOrthographyList* self);
VALA_EXTERN GObject* font_manager_orthography_list_get_selected_item (FontManagerOrthographyList* self);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
VALA_EXTERN void font_manager_orthography_list_set_selected_item (FontManagerOrthographyList* self,
                                                      GObject* value);
static void font_manager_orthography_list_finalize (GObject * obj);
static GType font_manager_orthography_list_get_type_once (void);
static void _vala_font_manager_orthography_list_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_font_manager_orthography_list_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
GET_ORTH_FOR (const gchar* f,
              gint i)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = g_strdup_printf ("SELECT json_extract(Orthography.support, '$')\n" \
"FROM Orthography WHERE json_valid(Orthography.support)\n" \
"AND Orthography.filepath = '%s' AND Orthography.findex = '%i'; ", f, i);
	result = _tmp0_;
	return result;
}

gchar*
GET_BASE_ORTH_FOR (const gchar* f)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = g_strdup_printf ("SELECT json_extract(Orthography.support, '$')\n" \
"FROM Orthography WHERE json_valid(Orthography.support)\n" \
"AND Orthography.filepath = '%s'; ", f);
	result = _tmp0_;
	return result;
}

const gchar*
GET_NAME (JsonObject* o)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (o != NULL, NULL);
	_tmp0_ = json_object_get_string_member (o, "name");
	result = _tmp0_;
	return result;
}

gdouble
GET_COVERAGE (JsonObject* o)
{
	gdouble result;
	g_return_val_if_fail (o != NULL, 0.0);
	result = json_object_get_double_member (o, "coverage");
	return result;
}

static inline gpointer
font_manager_orthography_list_model_get_instance_private (FontManagerOrthographyListModel* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerOrthographyListModel_private_offset);
}

static GType
font_manager_orthography_list_model_real_get_item_type (GListModel* base)
{
	FontManagerOrthographyListModel * self;
	GType result;
	self = (FontManagerOrthographyListModel*) base;
	result = font_manager_orthography_get_type ();
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
font_manager_orthography_list_model_real_get_n_items (GListModel* base)
{
	FontManagerOrthographyListModel * self;
	gint _tmp0_ = 0;
	GPtrArray* _tmp1_;
	guint result;
	self = (FontManagerOrthographyListModel*) base;
	_tmp1_ = self->priv->_items;
	if (_tmp1_ != NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = (guint) _tmp0_;
	return result;
}

static GObject*
font_manager_orthography_list_model_real_get_item (GListModel* base,
                                                   guint position)
{
	FontManagerOrthographyListModel * self;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	FontManagerOrthography* _tmp2_;
	GObject* result;
	self = (FontManagerOrthographyListModel*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = font_manager_orthography_new ((JsonObject*) _tmp1_);
	result = (GObject*) _tmp2_;
	return result;
}

static void
___lambda73_ (FontManagerOrthographyListModel* self,
              JsonObject* object,
              const gchar* name,
              JsonNode* node)
{
	JsonObject* _tmp0_;
	g_return_if_fail (object != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (node != NULL);
	if (g_strcmp0 (name, "sample") == 0) {
		return;
	}
	_tmp0_ = json_node_get_object (node);
	if (GET_COVERAGE (_tmp0_) > ((gdouble) 0)) {
		GPtrArray* _tmp1_;
		JsonObject* _tmp2_;
		_tmp1_ = self->priv->_items;
		_tmp2_ = json_node_get_object (node);
		g_ptr_array_add (_tmp1_, _tmp2_);
	}
}

static void
____lambda73__json_object_foreach (JsonObject* object,
                                   const gchar* member_name,
                                   JsonNode* member_node,
                                   gpointer self)
{
	___lambda73_ ((FontManagerOrthographyListModel*) self, object, member_name, member_node);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GPtrArray* self;
		self = _data10_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gint
__lambda0_ (Block10Data* _data10_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data10_->self;
	result = _data10_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block10Data* _data10_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_ptr_array_ref (self);
	_data10_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data10_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static gint
___lambda74_ (JsonObject* a,
              JsonObject* b)
{
	gint _result_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_result_ = ((gint) GET_COVERAGE (b)) - ((gint) GET_COVERAGE (a));
	if (_result_ == 0) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = GET_NAME (a);
		_tmp1_ = GET_NAME (b);
		_result_ = font_manager_natural_sort (_tmp0_, _tmp1_);
	}
	result = _result_;
	return result;
}

static gint
____lambda74__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = ___lambda74_ ((JsonObject*) a, (JsonObject*) b);
	return result;
}

static void
font_manager_orthography_list_model_update_items (FontManagerOrthographyListModel* self)
{
	guint n_items = 0U;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	JsonObject* _tmp2_;
	g_return_if_fail (self != NULL);
	n_items = g_list_model_get_n_items ((GListModel*) self);
	font_manager_orthography_list_model_set_items (self, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	_tmp1_ = _tmp0_;
	font_manager_orthography_list_model_set_items (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, n_items, (guint) 0);
	_tmp2_ = self->priv->_orthography;
	if (_tmp2_ != NULL) {
		JsonObject* _tmp3_;
		GPtrArray* _tmp4_;
		_tmp3_ = self->priv->_orthography;
		json_object_foreach_member (_tmp3_, ____lambda73__json_object_foreach, self);
		_tmp4_ = self->priv->_items;
		vala_g_ptr_array_sort (_tmp4_, ____lambda74__gcompare_func);
	}
	g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) self));
	return;
}

FontManagerOrthographyListModel*
font_manager_orthography_list_model_construct (GType object_type)
{
	FontManagerOrthographyListModel * self = NULL;
	self = (FontManagerOrthographyListModel*) g_object_new (object_type, NULL);
	return self;
}

FontManagerOrthographyListModel*
font_manager_orthography_list_model_new (void)
{
	return font_manager_orthography_list_model_construct (FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL);
}

JsonObject*
font_manager_orthography_list_model_get_orthography (FontManagerOrthographyListModel* self)
{
	JsonObject* result;
	JsonObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_orthography;
	result = _tmp0_;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

void
font_manager_orthography_list_model_set_orthography (FontManagerOrthographyListModel* self,
                                                     JsonObject* value)
{
	JsonObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_orthography_list_model_get_orthography (self);
	if (old_value != value) {
		JsonObject* _tmp0_;
		_tmp0_ = _json_object_ref0 (value);
		_json_object_unref0 (self->priv->_orthography);
		self->priv->_orthography = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_orthography_list_model_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ORTHOGRAPHY_PROPERTY]);
	}
}

GPtrArray*
font_manager_orthography_list_model_get_items (FontManagerOrthographyListModel* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
font_manager_orthography_list_model_set_items (FontManagerOrthographyListModel* self,
                                               GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_orthography_list_model_get_items (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_items);
		self->priv->_items = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_orthography_list_model_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ITEMS_PROPERTY]);
	}
}

static void
_font_manager_orthography_list_model___lambda75_ (FontManagerOrthographyListModel* self)
{
	font_manager_orthography_list_model_update_items (self);
}

static void
__font_manager_orthography_list_model___lambda75__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	_font_manager_orthography_list_model___lambda75_ ((FontManagerOrthographyListModel*) self);
}

static GObject *
font_manager_orthography_list_model_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerOrthographyListModel * self;
	parent_class = G_OBJECT_CLASS (font_manager_orthography_list_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModel);
	g_signal_connect_object ((GObject*) self, "notify::orthography", (GCallback) __font_manager_orthography_list_model___lambda75__g_object_notify, self, 0);
	return obj;
}

static void
font_manager_orthography_list_model_class_init (FontManagerOrthographyListModelClass * klass,
                                                gpointer klass_data)
{
	font_manager_orthography_list_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerOrthographyListModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_orthography_list_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_orthography_list_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_orthography_list_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_orthography_list_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ORTHOGRAPHY_PROPERTY, font_manager_orthography_list_model_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ORTHOGRAPHY_PROPERTY] = g_param_spec_boxed ("orthography", "orthography", "orthography", json_object_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ITEMS_PROPERTY, font_manager_orthography_list_model_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ITEMS_PROPERTY] = g_param_spec_boxed ("items", "items", "items", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_orthography_list_model_g_list_model_interface_init (GListModelInterface * iface,
                                                                 gpointer iface_data)
{
	font_manager_orthography_list_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) font_manager_orthography_list_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) font_manager_orthography_list_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) font_manager_orthography_list_model_real_get_item;
}

static void
font_manager_orthography_list_model_instance_init (FontManagerOrthographyListModel * self,
                                                   gpointer klass)
{
	self->priv = font_manager_orthography_list_model_get_instance_private (self);
	self->priv->_orthography = NULL;
	self->priv->_items = NULL;
}

static void
font_manager_orthography_list_model_finalize (GObject * obj)
{
	FontManagerOrthographyListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModel);
	_json_object_unref0 (self->priv->_orthography);
	_g_ptr_array_unref0 (self->priv->_items);
	G_OBJECT_CLASS (font_manager_orthography_list_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_orthography_list_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerOrthographyListModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_orthography_list_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerOrthographyListModel), 0, (GInstanceInitFunc) font_manager_orthography_list_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) font_manager_orthography_list_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType font_manager_orthography_list_model_type_id;
	font_manager_orthography_list_model_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerOrthographyListModel", &g_define_type_info, 0);
	g_type_add_interface_static (font_manager_orthography_list_model_type_id, g_list_model_get_type (), &g_list_model_info);
	FontManagerOrthographyListModel_private_offset = g_type_add_instance_private (font_manager_orthography_list_model_type_id, sizeof (FontManagerOrthographyListModelPrivate));
	return font_manager_orthography_list_model_type_id;
}

GType
font_manager_orthography_list_model_get_type (void)
{
	static volatile gsize font_manager_orthography_list_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_orthography_list_model_type_id__once)) {
		GType font_manager_orthography_list_model_type_id;
		font_manager_orthography_list_model_type_id = font_manager_orthography_list_model_get_type_once ();
		g_once_init_leave (&font_manager_orthography_list_model_type_id__once, font_manager_orthography_list_model_type_id);
	}
	return font_manager_orthography_list_model_type_id__once;
}

static void
_vala_font_manager_orthography_list_model_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	FontManagerOrthographyListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModel);
	switch (property_id) {
		case FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ORTHOGRAPHY_PROPERTY:
		g_value_set_boxed (value, font_manager_orthography_list_model_get_orthography (self));
		break;
		case FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ITEMS_PROPERTY:
		g_value_set_boxed (value, font_manager_orthography_list_model_get_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_orthography_list_model_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	FontManagerOrthographyListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, FontManagerOrthographyListModel);
	switch (property_id) {
		case FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ORTHOGRAPHY_PROPERTY:
		font_manager_orthography_list_model_set_orthography (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_ITEMS_PROPERTY:
		font_manager_orthography_list_model_set_items (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_orthography_list_row_get_instance_private (FontManagerOrthographyListRow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerOrthographyListRow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FontManagerOrthographyListRow*
font_manager_orthography_list_row_from_item (GObject* item)
{
	FontManagerOrthography* orthography = NULL;
	FontManagerOrthography* _tmp0_;
	FontManagerOrthographyListRow* row = NULL;
	FontManagerOrthographyListRow* _tmp1_;
	gchar* name = NULL;
	FontManagerOrthography* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FontManagerOrthographyListRow* _tmp8_;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	FontManagerOrthography* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	gboolean have_native_name = FALSE;
	gchar* _tmp21_ = NULL;
	FontManagerOrthographyListRow* _tmp27_;
	GtkLabel* _tmp28_;
	FontManagerOrthographyListRow* _tmp29_;
	GtkLevelBar* _tmp30_;
	FontManagerOrthography* _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	FontManagerOrthographyListRow* _tmp34_;
	FontManagerOrthography* _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	FontManagerOrthographyListRow* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, font_manager_orthography_get_type (), FontManagerOrthography));
	orthography = _tmp0_;
	_tmp1_ = font_manager_orthography_list_row_new ();
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	_tmp2_ = orthography;
	g_object_get (_tmp2_, "name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (g_dgettext (NULL, _tmp5_));
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	name = _tmp7_;
	_tmp8_ = row;
	_tmp9_ = _tmp8_->priv->C_name;
	_tmp10_ = name;
	gtk_label_set_text (_tmp9_, _tmp10_);
	_tmp12_ = orthography;
	g_object_get (_tmp12_, "native", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ != NULL;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		FontManagerOrthography* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = orthography;
		g_object_get (_tmp17_, "native", &_tmp18_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp11_ = g_strcmp0 (_tmp20_, "") != 0;
		_g_free0 (_tmp20_);
	} else {
		_tmp11_ = FALSE;
	}
	have_native_name = _tmp11_;
	if (have_native_name) {
		FontManagerOrthography* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = orthography;
		g_object_get (_tmp22_, "native", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp24_;
	} else {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = name;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp26_;
	}
	_tmp27_ = row;
	_tmp28_ = _tmp27_->priv->native_name;
	gtk_label_set_text (_tmp28_, _tmp21_);
	_tmp29_ = row;
	_tmp30_ = _tmp29_->priv->coverage;
	_tmp31_ = orthography;
	g_object_get (_tmp31_, "coverage", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	gtk_level_bar_set_value (_tmp30_, ((gdouble) _tmp33_) / 100);
	_tmp34_ = row;
	_tmp35_ = orthography;
	g_object_get (_tmp35_, "coverage", &_tmp36_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strdup_printf ("%s : %0.f%%", _ ("Coverage"), _tmp37_);
	_tmp39_ = _tmp38_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp34_, _tmp39_);
	_g_free0 (_tmp39_);
	result = row;
	_g_free0 (_tmp21_);
	_g_free0 (name);
	_g_object_unref0 (orthography);
	return result;
}

FontManagerOrthographyListRow*
font_manager_orthography_list_row_construct (GType object_type)
{
	FontManagerOrthographyListRow * self = NULL;
	self = (FontManagerOrthographyListRow*) g_object_new (object_type, NULL);
	return self;
}

FontManagerOrthographyListRow*
font_manager_orthography_list_row_new (void)
{
	return font_manager_orthography_list_row_construct (FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW);
}

static void
font_manager_orthography_list_row_class_init (FontManagerOrthographyListRowClass * klass,
                                              gpointer klass_data)
{
	font_manager_orthography_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerOrthographyListRow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = font_manager_orthography_list_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-orthography-list-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "C_name", FALSE, FontManagerOrthographyListRow_private_offset + G_STRUCT_OFFSET (FontManagerOrthographyListRowPrivate, C_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "native_name", FALSE, FontManagerOrthographyListRow_private_offset + G_STRUCT_OFFSET (FontManagerOrthographyListRowPrivate, native_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "coverage", FALSE, FontManagerOrthographyListRow_private_offset + G_STRUCT_OFFSET (FontManagerOrthographyListRowPrivate, coverage));
}

static void
font_manager_orthography_list_row_instance_init (FontManagerOrthographyListRow * self,
                                                 gpointer klass)
{
	self->priv = font_manager_orthography_list_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_orthography_list_row_finalize (GObject * obj)
{
	FontManagerOrthographyListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_ROW, FontManagerOrthographyListRow);
	G_OBJECT_CLASS (font_manager_orthography_list_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_orthography_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerOrthographyListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_orthography_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerOrthographyListRow), 0, (GInstanceInitFunc) font_manager_orthography_list_row_instance_init, NULL };
	GType font_manager_orthography_list_row_type_id;
	font_manager_orthography_list_row_type_id = g_type_register_static (gtk_grid_get_type (), "FontManagerOrthographyListRow", &g_define_type_info, 0);
	FontManagerOrthographyListRow_private_offset = g_type_add_instance_private (font_manager_orthography_list_row_type_id, sizeof (FontManagerOrthographyListRowPrivate));
	return font_manager_orthography_list_row_type_id;
}

GType
font_manager_orthography_list_row_get_type (void)
{
	static volatile gsize font_manager_orthography_list_row_type_id__once = 0;
	if (g_once_init_enter (&font_manager_orthography_list_row_type_id__once)) {
		GType font_manager_orthography_list_row_type_id;
		font_manager_orthography_list_row_type_id = font_manager_orthography_list_row_get_type_once ();
		g_once_init_leave (&font_manager_orthography_list_row_type_id__once, font_manager_orthography_list_row_type_id);
	}
	return font_manager_orthography_list_row_type_id__once;
}

static inline gpointer
font_manager_orthography_list_get_instance_private (FontManagerOrthographyList* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerOrthographyList_private_offset);
}

static GtkWidget*
_font_manager_orthography_list_row_from_item_gtk_list_box_create_widget_func (GObject* item,
                                                                              gpointer self)
{
	GtkWidget* result;
	result = font_manager_orthography_list_row_from_item (item);
	return result;
}

static void
__lambda76_ (FontManagerOrthographyList* self)
{
	GtkListBox* _tmp0_;
	FontManagerOrthographyListModel* _tmp1_;
	_tmp0_ = self->priv->list;
	_tmp1_ = self->priv->_model;
	gtk_list_box_bind_model (_tmp0_, (GListModel*) _tmp1_, _font_manager_orthography_list_row_from_item_gtk_list_box_create_widget_func, NULL, NULL);
}

static void
___lambda76__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda76_ ((FontManagerOrthographyList*) self);
}

static void
__lambda77_ (FontManagerOrthographyList* self)
{
	self->priv->update_pending = TRUE;
	font_manager_orthography_list_update_if_needed (self);
}

static void
___lambda77__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda77_ ((FontManagerOrthographyList*) self);
}

FontManagerOrthographyList*
font_manager_orthography_list_construct (GType object_type)
{
	FontManagerOrthographyList * self = NULL;
	FontManagerOrthographyListModel* _tmp0_;
	FontManagerOrthographyListModel* _tmp1_;
	FontManagerPlaceHolder* _tmp2_;
	GtkListBox* _tmp3_;
	FontManagerPlaceHolder* _tmp4_;
	GtkLabel* _tmp5_;
	self = (FontManagerOrthographyList*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GObject*) self, "notify::model", (GCallback) ___lambda76__g_object_notify, self, 0);
	_tmp0_ = font_manager_orthography_list_model_new ();
	_tmp1_ = _tmp0_;
	font_manager_orthography_list_set_model (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (NULL, NULL, NULL, NULL);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->place_holder);
	self->priv->place_holder = _tmp2_;
	_tmp3_ = self->priv->list;
	_tmp4_ = self->priv->place_holder;
	gtk_list_box_set_placeholder (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->header;
	gtk_label_set_text (_tmp5_, _ ("Supported Orthographies"));
	g_signal_connect_object ((GObject*) self, "notify::selected-item", (GCallback) ___lambda77__g_object_notify, self, 0);
	font_manager_orthography_list_update_if_needed (self);
	return self;
}

FontManagerOrthographyList*
font_manager_orthography_list_new (void)
{
	return font_manager_orthography_list_construct (FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST);
}

static void
font_manager_orthography_list_on_clear_clicked (FontManagerOrthographyList* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list;
	gtk_list_box_unselect_all (_tmp0_);
	return;
}

static void
_font_manager_orthography_list_on_clear_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	font_manager_orthography_list_on_clear_clicked ((FontManagerOrthographyList*) self);
}

static void
font_manager_orthography_list_on_list_row_selected (FontManagerOrthographyList* self,
                                                    GtkListBox* box,
                                                    GtkListBoxRow* row)
{
	GtkRevealer* _tmp0_;
	FontManagerOrthography* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->clear_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, row != NULL);
	font_manager_orthography_list_set_selected_orthography (self, NULL);
	if (row != NULL) {
		gint index = 0;
		index = gtk_list_box_row_get_index (row);
		if (index == self->priv->selected_index) {
			GtkListBox* _tmp1_;
			self->priv->selected_index = G_MAXINT;
			_tmp1_ = self->priv->list;
			gtk_list_box_unselect_all (_tmp1_);
		} else {
			FontManagerOrthographyListModel* _tmp2_;
			GObject* _tmp3_;
			FontManagerOrthography* _tmp4_;
			self->priv->selected_index = index;
			_tmp2_ = self->priv->_model;
			_tmp3_ = g_list_model_get_item ((GListModel*) _tmp2_, (guint) self->priv->selected_index);
			_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, font_manager_orthography_get_type (), FontManagerOrthography);
			font_manager_orthography_list_set_selected_orthography (self, _tmp4_);
			_g_object_unref0 (_tmp4_);
		}
	}
	_tmp5_ = self->priv->_selected_orthography;
	g_signal_emit (self, font_manager_orthography_list_signals[FONT_MANAGER_ORTHOGRAPHY_LIST_ORTHOGRAPHY_SELECTED_SIGNAL], 0, _tmp5_);
	return;
}

static void
_font_manager_orthography_list_on_list_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                               GtkListBoxRow* row,
                                                                               gpointer self)
{
	font_manager_orthography_list_on_list_row_selected ((FontManagerOrthographyList*) self, _sender, row);
}

static void
font_manager_orthography_list_on_map_event (FontManagerOrthographyList* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_visible_ = TRUE;
	font_manager_orthography_list_update_if_needed (self);
	return;
}

static void
_font_manager_orthography_list_on_map_event_gtk_widget_map (GtkWidget* _sender,
                                                            gpointer self)
{
	font_manager_orthography_list_on_map_event ((FontManagerOrthographyList*) self);
}

static void
font_manager_orthography_list_on_unmap_event (FontManagerOrthographyList* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_visible_ = FALSE;
	return;
}

static void
_font_manager_orthography_list_on_unmap_event_gtk_widget_unmap (GtkWidget* _sender,
                                                                gpointer self)
{
	font_manager_orthography_list_on_unmap_event ((FontManagerOrthographyList*) self);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static JsonObject*
font_manager_orthography_list_parse_json_result (FontManagerOrthographyList* self,
                                                 const gchar* json)
{
	GError* _inner_error0_ = NULL;
	JsonObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (json != NULL) {
		{
			JsonParser* parser = NULL;
			JsonParser* _tmp0_;
			JsonParser* _tmp1_;
			JsonNode* root = NULL;
			JsonParser* _tmp2_;
			JsonNode* _tmp3_;
			JsonNode* _tmp4_;
			JsonNode* _tmp5_;
			_tmp0_ = json_parser_new ();
			parser = _tmp0_;
			_tmp1_ = parser;
			json_parser_load_from_data (_tmp1_, json, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parser);
				goto __catch0_g_error;
			}
			_tmp2_ = parser;
			_tmp3_ = json_parser_get_root (_tmp2_);
			_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
			root = _tmp4_;
			_tmp5_ = root;
			if (json_node_get_node_type (_tmp5_) == JSON_NODE_OBJECT) {
				JsonNode* _tmp6_;
				JsonObject* _tmp7_;
				JsonObject* _tmp8_;
				_tmp6_ = root;
				_tmp7_ = json_node_get_object (_tmp6_);
				_tmp8_ = _json_object_ref0 (_tmp7_);
				result = _tmp8_;
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				return result;
			}
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("OrthographyList.vala:191: %s", _tmp10_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
font_manager_orthography_list_update_model (FontManagerOrthographyList* self)
{
	FontManagerOrthographyListModel* _tmp0_;
	FontManagerPlaceHolder* _tmp1_;
	FontManagerPlaceHolder* _tmp2_;
	GObject* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GObject* _tmp5_;
	FontManagerPlaceHolder* _tmp7_;
	FontManagerPlaceHolder* _tmp8_;
	FontManagerFont* font = NULL;
	GObject* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_model;
	font_manager_orthography_list_model_set_orthography (_tmp0_, NULL);
	_tmp1_ = self->priv->place_holder;
	g_object_set (_tmp1_, "message", _ ("No items selected"), NULL);
	_tmp2_ = self->priv->place_holder;
	g_object_set (_tmp2_, "icon-name", "dialog-error-symbolic", NULL);
	_tmp3_ = self->priv->_selected_item;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp5_ = self->priv->_selected_item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, font_manager_font_get_type ())) {
		_tmp4_ = TRUE;
	} else {
		GObject* _tmp6_;
		_tmp6_ = self->priv->_selected_item;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, font_manager_family_get_type ());
	}
	g_return_if_fail (_tmp4_);
	_tmp7_ = self->priv->place_holder;
	g_object_set (_tmp7_, "message", _ ("Update in progress"), NULL);
	_tmp8_ = self->priv->place_holder;
	g_object_set (_tmp8_, "icon-name", "emblem-synchronizing-symbolic", NULL);
	font = NULL;
	_tmp9_ = self->priv->_selected_item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, font_manager_family_get_type ())) {
		JsonObject* source = NULL;
		GObject* _tmp10_;
		JsonObject* _tmp11_;
		JsonObject* _tmp12_;
		FontManagerFont* _tmp13_;
		FontManagerFont* _tmp14_;
		JsonObject* _tmp15_;
		_tmp10_ = self->priv->_selected_item;
		_tmp11_ = font_manager_family_get_default_variant (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, font_manager_family_get_type (), FontManagerFamily));
		_tmp12_ = _json_object_ref0 (_tmp11_);
		source = _tmp12_;
		_tmp13_ = font_manager_font_new ();
		_g_object_unref0 (font);
		font = _tmp13_;
		_tmp14_ = font;
		_tmp15_ = source;
		g_object_set (_tmp14_, "source-object", _tmp15_, NULL);
		_json_object_unref0 (source);
	} else {
		GObject* _tmp16_;
		_tmp16_ = self->priv->_selected_item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, font_manager_font_get_type ())) {
			GObject* _tmp17_;
			FontManagerFont* _tmp18_;
			_tmp17_ = self->priv->_selected_item;
			_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, font_manager_font_get_type (), FontManagerFont));
			_g_object_unref0 (font);
			font = _tmp18_;
		}
	}
	{
		FontManagerDatabase* db = NULL;
		FontManagerDatabase* _tmp19_;
		gchar* path = NULL;
		FontManagerFont* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* query = NULL;
		const gchar* _tmp26_;
		FontManagerFont* _tmp27_;
		gint64 _tmp28_;
		gint64 _tmp29_;
		gchar* _tmp30_;
		FontManagerDatabase* _tmp31_;
		const gchar* _tmp32_;
		FontManagerDatabase* _tmp33_;
		sqlite3_stmt* _tmp34_;
		FontManagerDatabase* _tmp54_;
		FontManagerPlaceHolder* _tmp55_;
		FontManagerPlaceHolder* _tmp56_;
		_tmp19_ = font_manager_database_proxy_get_default_db ();
		db = _tmp19_;
		_tmp20_ = font;
		g_object_get (_tmp20_, "filepath", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = string_replace (_tmp23_, "'", "''");
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		path = _tmp25_;
		_tmp26_ = path;
		_tmp27_ = font;
		g_object_get (_tmp27_, "findex", &_tmp28_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = GET_ORTH_FOR (_tmp26_, (gint) _tmp29_);
		query = _tmp30_;
		_tmp31_ = db;
		_tmp32_ = query;
		font_manager_database_execute_query (_tmp31_, _tmp32_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (query);
			_g_free0 (path);
			_g_object_unref0 (db);
			goto __catch0_g_error;
		}
		_tmp33_ = db;
		_tmp34_ = font_manager_database_get_cursor (_tmp33_);
		if (sqlite3_step (_tmp34_) == SQLITE_ROW) {
			FontManagerOrthographyListModel* _tmp35_;
			FontManagerDatabase* _tmp36_;
			sqlite3_stmt* _tmp37_;
			const gchar* _tmp38_;
			JsonObject* _tmp39_;
			JsonObject* _tmp40_;
			_tmp35_ = self->priv->_model;
			_tmp36_ = db;
			_tmp37_ = font_manager_database_get_cursor (_tmp36_);
			_tmp38_ = (const gchar*) sqlite3_column_text (_tmp37_, 0);
			_tmp39_ = font_manager_orthography_list_parse_json_result (self, _tmp38_);
			_tmp40_ = _tmp39_;
			font_manager_orthography_list_model_set_orthography (_tmp35_, _tmp40_);
			_json_object_unref0 (_tmp40_);
		} else {
			FontManagerDatabase* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			FontManagerDatabase* _tmp44_;
			const gchar* _tmp45_;
			FontManagerDatabase* _tmp46_;
			sqlite3_stmt* _tmp47_;
			_tmp41_ = db;
			font_manager_database_end_query (_tmp41_);
			_tmp42_ = path;
			_tmp43_ = GET_BASE_ORTH_FOR (_tmp42_);
			_g_free0 (query);
			query = _tmp43_;
			_tmp44_ = db;
			_tmp45_ = query;
			font_manager_database_execute_query (_tmp44_, _tmp45_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (query);
				_g_free0 (path);
				_g_object_unref0 (db);
				goto __catch0_g_error;
			}
			_tmp46_ = db;
			_tmp47_ = font_manager_database_get_cursor (_tmp46_);
			if (sqlite3_step (_tmp47_) == SQLITE_ROW) {
				FontManagerOrthographyListModel* _tmp48_;
				FontManagerDatabase* _tmp49_;
				sqlite3_stmt* _tmp50_;
				const gchar* _tmp51_;
				JsonObject* _tmp52_;
				JsonObject* _tmp53_;
				_tmp48_ = self->priv->_model;
				_tmp49_ = db;
				_tmp50_ = font_manager_database_get_cursor (_tmp49_);
				_tmp51_ = (const gchar*) sqlite3_column_text (_tmp50_, 0);
				_tmp52_ = font_manager_orthography_list_parse_json_result (self, _tmp51_);
				_tmp53_ = _tmp52_;
				font_manager_orthography_list_model_set_orthography (_tmp48_, _tmp53_);
				_json_object_unref0 (_tmp53_);
			}
		}
		_tmp54_ = db;
		font_manager_database_end_query (_tmp54_);
		_tmp55_ = self->priv->place_holder;
		g_object_set (_tmp55_, "message", _ ("No valid orthographies for selection"), NULL);
		_tmp56_ = self->priv->place_holder;
		g_object_set (_tmp56_, "icon-name", "action-unavailable-symbolic", NULL);
		_g_free0 (query);
		_g_free0 (path);
		_g_object_unref0 (db);
	}
	goto __finally0;
	__catch0_g_error:
	{
		FontManagerOrthographyListModel* _tmp57_;
		FontManagerFont* _tmp58_;
		JsonObject* _tmp59_;
		JsonObject* _tmp60_;
		JsonObject* _tmp61_;
		JsonObject* _tmp62_;
		JsonObject* _tmp63_;
		g_clear_error (&_inner_error0_);
		_tmp57_ = self->priv->_model;
		_tmp58_ = font;
		g_object_get (_tmp58_, "source-object", &_tmp59_, NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = _tmp60_;
		_tmp62_ = font_manager_get_orthography_results (_tmp61_);
		_tmp63_ = _tmp62_;
		font_manager_orthography_list_model_set_orthography (_tmp57_, _tmp63_);
		_json_object_unref0 (_tmp63_);
		_json_object_unref0 (_tmp61_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (font);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (font);
	return;
}

static void
font_manager_orthography_list_update_if_needed (FontManagerOrthographyList* self)
{
	gboolean _tmp0_ = FALSE;
	GtkListBox* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->_visible_) {
		_tmp0_ = self->priv->update_pending;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp1_;
		GObject* _tmp2_;
		font_manager_orthography_list_update_model (self);
		self->priv->update_pending = FALSE;
		_tmp1_ = self->priv->header;
		_tmp2_ = self->priv->_selected_item;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
	}
	_tmp3_ = self->priv->list;
	gtk_list_box_unselect_all (_tmp3_);
	return;
}

GObject*
font_manager_orthography_list_get_selected_item (FontManagerOrthographyList* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_item;
	result = _tmp0_;
	return result;
}

void
font_manager_orthography_list_set_selected_item (FontManagerOrthographyList* self,
                                                 GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_orthography_list_get_selected_item (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_item);
		self->priv->_selected_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ITEM_PROPERTY]);
	}
}

FontManagerOrthographyListModel*
font_manager_orthography_list_get_model (FontManagerOrthographyList* self)
{
	FontManagerOrthographyListModel* result;
	FontManagerOrthographyListModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

void
font_manager_orthography_list_set_model (FontManagerOrthographyList* self,
                                         FontManagerOrthographyListModel* value)
{
	FontManagerOrthographyListModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_orthography_list_get_model (self);
	if (old_value != value) {
		FontManagerOrthographyListModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_PROPERTY]);
	}
}

FontManagerOrthography*
font_manager_orthography_list_get_selected_orthography (FontManagerOrthographyList* self)
{
	FontManagerOrthography* result;
	FontManagerOrthography* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_orthography;
	result = _tmp0_;
	return result;
}

void
font_manager_orthography_list_set_selected_orthography (FontManagerOrthographyList* self,
                                                        FontManagerOrthography* value)
{
	FontManagerOrthography* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_orthography_list_get_selected_orthography (self);
	if (old_value != value) {
		FontManagerOrthography* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_orthography);
		self->priv->_selected_orthography = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ORTHOGRAPHY_PROPERTY]);
	}
}

static void
font_manager_orthography_list_class_init (FontManagerOrthographyListClass * klass,
                                          gpointer klass_data)
{
	font_manager_orthography_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerOrthographyList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_orthography_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_orthography_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_orthography_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ITEM_PROPERTY, font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_PROPERTY, font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ORTHOGRAPHY_PROPERTY, font_manager_orthography_list_properties[FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ORTHOGRAPHY_PROPERTY] = g_param_spec_object ("selected-orthography", "selected-orthography", "selected-orthography", font_manager_orthography_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-orthography-list.ui");
	font_manager_orthography_list_signals[FONT_MANAGER_ORTHOGRAPHY_LIST_ORTHOGRAPHY_SELECTED_SIGNAL] = g_signal_new ("orthography-selected", FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, font_manager_orthography_get_type ());
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header", FALSE, FontManagerOrthographyList_private_offset + G_STRUCT_OFFSET (FontManagerOrthographyListPrivate, header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list", FALSE, FontManagerOrthographyList_private_offset + G_STRUCT_OFFSET (FontManagerOrthographyListPrivate, list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clear_revealer", FALSE, FontManagerOrthographyList_private_offset + G_STRUCT_OFFSET (FontManagerOrthographyListPrivate, clear_revealer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clear_clicked", G_CALLBACK(_font_manager_orthography_list_on_clear_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_list_row_selected", G_CALLBACK(_font_manager_orthography_list_on_list_row_selected_gtk_list_box_row_selected));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_map_event", G_CALLBACK(_font_manager_orthography_list_on_map_event_gtk_widget_map));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_unmap_event", G_CALLBACK(_font_manager_orthography_list_on_unmap_event_gtk_widget_unmap));
}

static void
font_manager_orthography_list_instance_init (FontManagerOrthographyList * self,
                                             gpointer klass)
{
	self->priv = font_manager_orthography_list_get_instance_private (self);
	self->priv->_selected_item = NULL;
	self->priv->_model = NULL;
	self->priv->_selected_orthography = NULL;
	self->priv->_visible_ = FALSE;
	self->priv->update_pending = TRUE;
	self->priv->selected_index = G_MAXINT;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_orthography_list_finalize (GObject * obj)
{
	FontManagerOrthographyList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, FontManagerOrthographyList);
	_g_object_unref0 (self->priv->_selected_item);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_selected_orthography);
	_g_object_unref0 (self->priv->place_holder);
	G_OBJECT_CLASS (font_manager_orthography_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_orthography_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerOrthographyListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_orthography_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerOrthographyList), 0, (GInstanceInitFunc) font_manager_orthography_list_instance_init, NULL };
	GType font_manager_orthography_list_type_id;
	font_manager_orthography_list_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerOrthographyList", &g_define_type_info, 0);
	FontManagerOrthographyList_private_offset = g_type_add_instance_private (font_manager_orthography_list_type_id, sizeof (FontManagerOrthographyListPrivate));
	return font_manager_orthography_list_type_id;
}

GType
font_manager_orthography_list_get_type (void)
{
	static volatile gsize font_manager_orthography_list_type_id__once = 0;
	if (g_once_init_enter (&font_manager_orthography_list_type_id__once)) {
		GType font_manager_orthography_list_type_id;
		font_manager_orthography_list_type_id = font_manager_orthography_list_get_type_once ();
		g_once_init_leave (&font_manager_orthography_list_type_id__once, font_manager_orthography_list_type_id);
	}
	return font_manager_orthography_list_type_id__once;
}

static void
_vala_font_manager_orthography_list_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerOrthographyList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, FontManagerOrthographyList);
	switch (property_id) {
		case FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ITEM_PROPERTY:
		g_value_set_object (value, font_manager_orthography_list_get_selected_item (self));
		break;
		case FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_orthography_list_get_model (self));
		break;
		case FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ORTHOGRAPHY_PROPERTY:
		g_value_set_object (value, font_manager_orthography_list_get_selected_orthography (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_orthography_list_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerOrthographyList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_ORTHOGRAPHY_LIST, FontManagerOrthographyList);
	switch (property_id) {
		case FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ITEM_PROPERTY:
		font_manager_orthography_list_set_selected_item (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_ORTHOGRAPHY_LIST_MODEL_PROPERTY:
		font_manager_orthography_list_set_model (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_ORTHOGRAPHY_LIST_SELECTED_ORTHOGRAPHY_PROPERTY:
		font_manager_orthography_list_set_selected_orthography (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

