/* Controls.c generated by valac 0.56.18, the Vala compiler
 * generated from Controls.vala, do not modify */

/* Controls.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include "font-manager.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define DISPLAY_NAME _ ("Font Manager")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_BASE_CONTROLS (font_manager_base_controls_get_type ())
#define FONT_MANAGER_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls))
#define FONT_MANAGER_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))
#define FONT_MANAGER_IS_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_IS_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_BASE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))

typedef struct _FontManagerBaseControls FontManagerBaseControls;
typedef struct _FontManagerBaseControlsClass FontManagerBaseControlsClass;
typedef struct _FontManagerBaseControlsPrivate FontManagerBaseControlsPrivate;
enum  {
	FONT_MANAGER_BASE_CONTROLS_0_PROPERTY,
	FONT_MANAGER_BASE_CONTROLS_ADD_BUTTON_PROPERTY,
	FONT_MANAGER_BASE_CONTROLS_REMOVE_BUTTON_PROPERTY,
	FONT_MANAGER_BASE_CONTROLS_NUM_PROPERTIES
};
static GParamSpec* font_manager_base_controls_properties[FONT_MANAGER_BASE_CONTROLS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	FONT_MANAGER_BASE_CONTROLS_ADD_SELECTED_SIGNAL,
	FONT_MANAGER_BASE_CONTROLS_REMOVE_SELECTED_SIGNAL,
	FONT_MANAGER_BASE_CONTROLS_NUM_SIGNALS
};
static guint font_manager_base_controls_signals[FONT_MANAGER_BASE_CONTROLS_NUM_SIGNALS] = {0};

#define FONT_MANAGER_TYPE_PREVIEW_ENTRY (font_manager_preview_entry_get_type ())
#define FONT_MANAGER_PREVIEW_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREVIEW_ENTRY, FontManagerPreviewEntry))
#define FONT_MANAGER_PREVIEW_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREVIEW_ENTRY, FontManagerPreviewEntryClass))
#define FONT_MANAGER_IS_PREVIEW_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREVIEW_ENTRY))
#define FONT_MANAGER_IS_PREVIEW_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREVIEW_ENTRY))
#define FONT_MANAGER_PREVIEW_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREVIEW_ENTRY, FontManagerPreviewEntryClass))

typedef struct _FontManagerPreviewEntry FontManagerPreviewEntry;
typedef struct _FontManagerPreviewEntryClass FontManagerPreviewEntryClass;
typedef struct _FontManagerPreviewEntryPrivate FontManagerPreviewEntryPrivate;
enum  {
	FONT_MANAGER_PREVIEW_ENTRY_0_PROPERTY,
	FONT_MANAGER_PREVIEW_ENTRY_NUM_PROPERTIES
};
static GParamSpec* font_manager_preview_entry_properties[FONT_MANAGER_PREVIEW_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_TYPE_MENU_ENTRY (font_manager_menu_entry_get_type ())
typedef struct _FontManagerMenuEntry FontManagerMenuEntry;
typedef enum  {
	FONT_MANAGER_MODE_MANAGE,
	FONT_MANAGER_MODE_BROWSE,
	FONT_MANAGER_MODE_COMPARE,
	FONT_MANAGER_MODE_GOOGLE_FONTS,
	FONT_MANAGER_MODE_N_MODES
} FontManagerMode;

#define FONT_MANAGER_TYPE_MODE (font_manager_mode_get_type ())
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef enum  {
	FONT_MANAGER_SORT_TYPE_NAME,
	FONT_MANAGER_SORT_TYPE_SIZE,
	FONT_MANAGER_SORT_TYPE_NONE,
	FONT_MANAGER_SORT_TYPE_N_SORT_OPTIONS
} FontManagerSortType;

#define FONT_MANAGER_TYPE_SORT_TYPE (font_manager_sort_type_get_type ())

#define FONT_MANAGER_TYPE_BROWSE_CONTROLS (font_manager_browse_controls_get_type ())
#define FONT_MANAGER_BROWSE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControls))
#define FONT_MANAGER_BROWSE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControlsClass))
#define FONT_MANAGER_IS_BROWSE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_CONTROLS))
#define FONT_MANAGER_IS_BROWSE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_CONTROLS))
#define FONT_MANAGER_BROWSE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControlsClass))

typedef struct _FontManagerBrowseControls FontManagerBrowseControls;
typedef struct _FontManagerBrowseControlsClass FontManagerBrowseControlsClass;
typedef struct _FontManagerBrowseControlsPrivate FontManagerBrowseControlsPrivate;
typedef enum  {
	FONT_MANAGER_BROWSE_MODE_GRID,
	FONT_MANAGER_BROWSE_MODE_LIST,
	FONT_MANAGER_BROWSE_MODE_N_MODES
} FontManagerBrowseMode;

#define FONT_MANAGER_TYPE_BROWSE_MODE (font_manager_browse_mode_get_type ())
enum  {
	FONT_MANAGER_BROWSE_CONTROLS_0_PROPERTY,
	FONT_MANAGER_BROWSE_CONTROLS_MODE_PROPERTY,
	FONT_MANAGER_BROWSE_CONTROLS_GRID_PROPERTY,
	FONT_MANAGER_BROWSE_CONTROLS_LIST_PROPERTY,
	FONT_MANAGER_BROWSE_CONTROLS_NUM_PROPERTIES
};
static GParamSpec* font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS (font_manager_header_bar_widgets_get_type ())
#define FONT_MANAGER_HEADER_BAR_WIDGETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgets))
#define FONT_MANAGER_HEADER_BAR_WIDGETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgetsClass))
#define FONT_MANAGER_IS_HEADER_BAR_WIDGETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS))
#define FONT_MANAGER_IS_HEADER_BAR_WIDGETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS))
#define FONT_MANAGER_HEADER_BAR_WIDGETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgetsClass))

typedef struct _FontManagerHeaderBarWidgets FontManagerHeaderBarWidgets;
typedef struct _FontManagerHeaderBarWidgetsClass FontManagerHeaderBarWidgetsClass;
typedef struct _FontManagerHeaderBarWidgetsPrivate FontManagerHeaderBarWidgetsPrivate;
enum  {
	FONT_MANAGER_HEADER_BAR_WIDGETS_0_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_APP_MENU_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_LABEL_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_TITLE_LABEL_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_BACK_BUTTON_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_SETTINGS_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_INSTALLING_FILES_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_REMOVING_FILES_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_REVEALER_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_SPINNER_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_BROWSE_CONTROLS_PROPERTY,
	FONT_MANAGER_HEADER_BAR_WIDGETS_NUM_PROPERTIES
};
static GParamSpec* font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerBaseControls {
	GtkBox parent_instance;
	FontManagerBaseControlsPrivate * priv;
};

struct _FontManagerBaseControlsClass {
	GtkBoxClass parent_class;
};

struct _FontManagerBaseControlsPrivate {
	GtkButton* _add_button;
	GtkButton* _remove_button;
};

struct _FontManagerPreviewEntry {
	GtkEntry parent_instance;
	FontManagerPreviewEntryPrivate * priv;
};

struct _FontManagerPreviewEntryClass {
	GtkEntryClass parent_class;
};

struct _FontManagerMenuEntry {
	gchar* action_name;
	gchar* display_name;
};

struct _FontManagerBrowseControls {
	GtkBox parent_instance;
	FontManagerBrowseControlsPrivate * priv;
};

struct _FontManagerBrowseControlsClass {
	GtkBoxClass parent_class;
};

struct _FontManagerBrowseControlsPrivate {
	FontManagerBrowseMode _mode;
	GtkToggleButton* _grid;
	GtkToggleButton* _list;
};

struct _FontManagerHeaderBarWidgets {
	GObject parent_instance;
	FontManagerHeaderBarWidgetsPrivate * priv;
};

struct _FontManagerHeaderBarWidgetsClass {
	GObjectClass parent_class;
};

struct _FontManagerHeaderBarWidgetsPrivate {
	GtkMenuButton* _main_menu;
	GtkMenuButton* _app_menu;
	GtkLabel* _main_menu_label;
	GtkLabel* _title_label;
	GtkButton* _back_button;
	GSettings* _settings;
	GtkRevealer* _revealer;
	GtkSpinner* _spinner;
	FontManagerBaseControls* manage_controls;
	FontManagerBrowseControls* _browse_controls;
};

static gint FontManagerBaseControls_private_offset;
static gpointer font_manager_base_controls_parent_class = NULL;
static gpointer font_manager_preview_entry_parent_class = NULL;
static gint FontManagerBrowseControls_private_offset;
static gpointer font_manager_browse_controls_parent_class = NULL;
static gint FontManagerHeaderBarWidgets_private_offset;
static gpointer font_manager_header_bar_widgets_parent_class = NULL;

VALA_EXTERN GType font_manager_base_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseControls, g_object_unref)
VALA_EXTERN FontManagerBaseControls* font_manager_base_controls_new (void);
VALA_EXTERN FontManagerBaseControls* font_manager_base_controls_construct (GType object_type);
VALA_EXTERN GtkButton* font_manager_base_controls_get_add_button (FontManagerBaseControls* self);
VALA_EXTERN void font_manager_base_controls_set_add_button (FontManagerBaseControls* self,
                                                GtkButton* value);
VALA_EXTERN GtkButton* font_manager_base_controls_get_remove_button (FontManagerBaseControls* self);
VALA_EXTERN void font_manager_base_controls_set_remove_button (FontManagerBaseControls* self,
                                                   GtkButton* value);
static GObject * font_manager_base_controls_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
VALA_EXTERN void font_manager_set_control_sensitivity (GtkWidget* widget,
                                           gboolean sensitive);
static void _font_manager_base_controls___lambda147_ (FontManagerBaseControls* self,
                                               GtkButton* w);
static void __font_manager_base_controls___lambda147__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _font_manager_base_controls___lambda148_ (FontManagerBaseControls* self);
static void __font_manager_base_controls___lambda148__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void font_manager_base_controls_finalize (GObject * obj);
static GType font_manager_base_controls_get_type_once (void);
static void _vala_font_manager_base_controls_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_font_manager_base_controls_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN GType font_manager_preview_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreviewEntry, g_object_unref)
static void font_manager_preview_entry_real_constructed (GObject* base);
static void font_manager_preview_entry_on_changed_event (FontManagerPreviewEntry* self);
static void font_manager_preview_entry_on_icon_press_event (FontManagerPreviewEntry* self,
                                                     GtkEntry* entry,
                                                     GtkEntryIconPosition position);
static void _font_manager_preview_entry_on_icon_press_event_gtk_entry_icon_press (GtkEntry* _sender,
                                                                           GtkEntryIconPosition icon_pos,
                                                                           gpointer self);
static void _font_manager_preview_entry_on_changed_event_gtk_editable_changed (GtkEditable* _sender,
                                                                        gpointer self);
VALA_EXTERN FontManagerPreviewEntry* font_manager_preview_entry_new (void);
VALA_EXTERN FontManagerPreviewEntry* font_manager_preview_entry_construct (GType object_type);
static GType font_manager_preview_entry_get_type_once (void);
VALA_EXTERN GType font_manager_menu_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerMenuEntry* font_manager_menu_entry_dup (const FontManagerMenuEntry* self);
VALA_EXTERN void font_manager_menu_entry_free (FontManagerMenuEntry* self);
VALA_EXTERN void font_manager_menu_entry_copy (const FontManagerMenuEntry* self,
                                   FontManagerMenuEntry* dest);
VALA_EXTERN void font_manager_menu_entry_destroy (FontManagerMenuEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FontManagerMenuEntry, font_manager_menu_entry_destroy)
VALA_EXTERN GMenuModel* font_manager_get_app_menu_model (void);
VALA_EXTERN GMenuModel* font_manager_get_main_menu_model (void);
VALA_EXTERN GType font_manager_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* font_manager_mode_to_translatable_string (FontManagerMode self);
VALA_EXTERN GType font_manager_sort_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* font_manager_sort_type_to_translatable_string (FontManagerSortType self);
VALA_EXTERN gchar* font_manager_sort_type_to_string (FontManagerSortType self);
VALA_EXTERN GMenuModel* font_manager_get_sort_type_menu_model (void);
VALA_EXTERN void font_manager_toggle_spinner (GtkSpinner* spinner,
                                  GtkButton* button,
                                  const gchar* icon_name);
VALA_EXTERN GType font_manager_browse_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowseControls, g_object_unref)
VALA_EXTERN GType font_manager_browse_mode_get_type (void) G_GNUC_CONST ;
static void font_manager_browse_controls_on_toggled (FontManagerBrowseControls* self,
                                              GtkToggleButton* toggle);
VALA_EXTERN GtkToggleButton* font_manager_browse_controls_get_grid (FontManagerBrowseControls* self);
VALA_EXTERN void font_manager_browse_controls_set_mode (FontManagerBrowseControls* self,
                                            FontManagerBrowseMode value);
VALA_EXTERN FontManagerBrowseControls* font_manager_browse_controls_new (void);
VALA_EXTERN FontManagerBrowseControls* font_manager_browse_controls_construct (GType object_type);
VALA_EXTERN FontManagerBrowseMode font_manager_browse_controls_get_mode (FontManagerBrowseControls* self);
static void font_manager_browse_controls_set_grid (FontManagerBrowseControls* self,
                                            GtkToggleButton* value);
VALA_EXTERN GtkToggleButton* font_manager_browse_controls_get_list (FontManagerBrowseControls* self);
static void font_manager_browse_controls_set_list (FontManagerBrowseControls* self,
                                            GtkToggleButton* value);
static GObject * font_manager_browse_controls_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _font_manager_browse_controls_on_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self);
static void _font_manager_browse_controls___lambda163_ (FontManagerBrowseControls* self);
static void __font_manager_browse_controls___lambda163__g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void font_manager_browse_controls_finalize (GObject * obj);
static GType font_manager_browse_controls_get_type_once (void);
static void _vala_font_manager_browse_controls_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_font_manager_browse_controls_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
VALA_EXTERN GType font_manager_header_bar_widgets_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerHeaderBarWidgets, g_object_unref)
VALA_EXTERN void font_manager_header_bar_widgets_reveal_controls (FontManagerHeaderBarWidgets* self,
                                                      FontManagerMode mode);
VALA_EXTERN FontManagerBrowseControls* font_manager_header_bar_widgets_get_browse_controls (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkRevealer* font_manager_header_bar_widgets_get_revealer (FontManagerHeaderBarWidgets* self);
VALA_EXTERN FontManagerHeaderBarWidgets* font_manager_header_bar_widgets_new (GSettings* settings);
VALA_EXTERN FontManagerHeaderBarWidgets* font_manager_header_bar_widgets_construct (GType object_type,
                                                                        GSettings* settings);
VALA_EXTERN void font_manager_header_bar_widgets_set_title_label (FontManagerHeaderBarWidgets* self,
                                                      GtkLabel* value);
VALA_EXTERN GtkLabel* font_manager_header_bar_widgets_get_title_label (FontManagerHeaderBarWidgets* self);
VALA_EXTERN void font_manager_header_bar_widgets_set_main_menu (FontManagerHeaderBarWidgets* self,
                                                    GtkMenuButton* value);
VALA_EXTERN void font_manager_header_bar_widgets_set_main_menu_label (FontManagerHeaderBarWidgets* self,
                                                          GtkLabel* value);
VALA_EXTERN FontManagerMode font_manager_mode_parse (const gchar* mode);
VALA_EXTERN GtkLabel* font_manager_header_bar_widgets_get_main_menu_label (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkMenuButton* font_manager_header_bar_widgets_get_main_menu (FontManagerHeaderBarWidgets* self);
VALA_EXTERN void font_manager_header_bar_widgets_set_app_menu (FontManagerHeaderBarWidgets* self,
                                                   GtkMenuButton* value);
VALA_EXTERN GtkMenuButton* font_manager_header_bar_widgets_get_app_menu (FontManagerHeaderBarWidgets* self);
static void font_manager_header_bar_widgets_set_revealer (FontManagerHeaderBarWidgets* self,
                                                   GtkRevealer* value);
static void font_manager_header_bar_widgets_set_browse_controls (FontManagerHeaderBarWidgets* self,
                                                          FontManagerBrowseControls* value);
VALA_EXTERN void font_manager_header_bar_widgets_set_back_button (FontManagerHeaderBarWidgets* self,
                                                      GtkButton* value);
VALA_EXTERN void font_manager_header_bar_widgets_set_spinner (FontManagerHeaderBarWidgets* self,
                                                  GtkSpinner* value);
static void font_manager_header_bar_widgets_set_button_style (FontManagerHeaderBarWidgets* self);
static void ___lambda164_ (FontManagerHeaderBarWidgets* self,
                    const gchar* key);
static void ____lambda164__g_settings_changed (GSettings* _sender,
                                        const gchar* key,
                                        gpointer self);
VALA_EXTERN GSettings* font_manager_header_bar_widgets_get_settings (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkButton* font_manager_header_bar_widgets_get_back_button (FontManagerHeaderBarWidgets* self);
VALA_EXTERN void font_manager_header_bar_widgets_set_settings (FontManagerHeaderBarWidgets* self,
                                                   GSettings* value);
VALA_EXTERN void font_manager_header_bar_widgets_set_installing_files (FontManagerHeaderBarWidgets* self,
                                                           gboolean value);
VALA_EXTERN GtkSpinner* font_manager_header_bar_widgets_get_spinner (FontManagerHeaderBarWidgets* self);
VALA_EXTERN void font_manager_header_bar_widgets_set_removing_files (FontManagerHeaderBarWidgets* self,
                                                         gboolean value);
static void font_manager_header_bar_widgets_finalize (GObject * obj);
static GType font_manager_header_bar_widgets_get_type_once (void);
static void _vala_font_manager_header_bar_widgets_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_font_manager_header_bar_widgets_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const FontManagerMenuEntry FONT_MANAGER_app_menu_entries[3] = {{"win.show-help-overlay", N_ ("Keyboard Shortcuts")}, {"help", N_ ("Help")}, {"about", N_ ("About Font Manager")}};

static inline gpointer
font_manager_base_controls_get_instance_private (FontManagerBaseControls* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerBaseControls_private_offset);
}

FontManagerBaseControls*
font_manager_base_controls_construct (GType object_type)
{
	FontManagerBaseControls * self = NULL;
	self = (FontManagerBaseControls*) g_object_new (object_type, NULL);
	return self;
}

FontManagerBaseControls*
font_manager_base_controls_new (void)
{
	return font_manager_base_controls_construct (FONT_MANAGER_TYPE_BASE_CONTROLS);
}

GtkButton*
font_manager_base_controls_get_add_button (FontManagerBaseControls* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_add_button;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
font_manager_base_controls_set_add_button (FontManagerBaseControls* self,
                                           GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_controls_get_add_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_add_button);
		self->priv->_add_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_controls_properties[FONT_MANAGER_BASE_CONTROLS_ADD_BUTTON_PROPERTY]);
	}
}

GtkButton*
font_manager_base_controls_get_remove_button (FontManagerBaseControls* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_remove_button;
	result = _tmp0_;
	return result;
}

void
font_manager_base_controls_set_remove_button (FontManagerBaseControls* self,
                                              GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_base_controls_get_remove_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_remove_button);
		self->priv->_remove_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_base_controls_properties[FONT_MANAGER_BASE_CONTROLS_REMOVE_BUTTON_PROPERTY]);
	}
}

static void
_font_manager_base_controls___lambda147_ (FontManagerBaseControls* self,
                                          GtkButton* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, font_manager_base_controls_signals[FONT_MANAGER_BASE_CONTROLS_ADD_SELECTED_SIGNAL], 0);
}

static void
__font_manager_base_controls___lambda147__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_font_manager_base_controls___lambda147_ ((FontManagerBaseControls*) self, _sender);
}

static void
_font_manager_base_controls___lambda148_ (FontManagerBaseControls* self)
{
	g_signal_emit (self, font_manager_base_controls_signals[FONT_MANAGER_BASE_CONTROLS_REMOVE_SELECTED_SIGNAL], 0);
}

static void
__font_manager_base_controls___lambda148__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_font_manager_base_controls___lambda148_ ((FontManagerBaseControls*) self);
}

static GObject *
font_manager_base_controls_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerBaseControls * self;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	parent_class = G_OBJECT_CLASS (font_manager_base_controls_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls);
	gtk_box_set_spacing ((GtkBox*) self, FONT_MANAGER_DEFAULT_MARGIN);
	font_manager_widget_set_margin ((GtkWidget*) self, FONT_MANAGER_MIN_MARGIN * 2);
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic");
	gtk_widget_set_opacity ((GtkWidget*) _tmp0_, 0.9);
	gtk_button_set_has_frame (_tmp0_, FALSE);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	font_manager_base_controls_set_add_button (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic");
	gtk_widget_set_opacity ((GtkWidget*) _tmp2_, 0.9);
	gtk_button_set_has_frame (_tmp2_, FALSE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	font_manager_base_controls_set_remove_button (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_remove_button;
	font_manager_set_control_sensitivity ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->_add_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_remove_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->_add_button;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) __font_manager_base_controls___lambda147__gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->_remove_button;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) __font_manager_base_controls___lambda148__gtk_button_clicked, self, 0);
	return obj;
}

static void
font_manager_base_controls_class_init (FontManagerBaseControlsClass * klass,
                                       gpointer klass_data)
{
	font_manager_base_controls_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerBaseControls_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_base_controls_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_base_controls_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_base_controls_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_base_controls_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_CONTROLS_ADD_BUTTON_PROPERTY, font_manager_base_controls_properties[FONT_MANAGER_BASE_CONTROLS_ADD_BUTTON_PROPERTY] = g_param_spec_object ("add-button", "add-button", "add-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BASE_CONTROLS_REMOVE_BUTTON_PROPERTY, font_manager_base_controls_properties[FONT_MANAGER_BASE_CONTROLS_REMOVE_BUTTON_PROPERTY] = g_param_spec_object ("remove-button", "remove-button", "remove-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	font_manager_base_controls_signals[FONT_MANAGER_BASE_CONTROLS_ADD_SELECTED_SIGNAL] = g_signal_new ("add-selected", FONT_MANAGER_TYPE_BASE_CONTROLS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	font_manager_base_controls_signals[FONT_MANAGER_BASE_CONTROLS_REMOVE_SELECTED_SIGNAL] = g_signal_new ("remove-selected", FONT_MANAGER_TYPE_BASE_CONTROLS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
font_manager_base_controls_instance_init (FontManagerBaseControls * self,
                                          gpointer klass)
{
	self->priv = font_manager_base_controls_get_instance_private (self);
}

static void
font_manager_base_controls_finalize (GObject * obj)
{
	FontManagerBaseControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls);
	_g_object_unref0 (self->priv->_add_button);
	_g_object_unref0 (self->priv->_remove_button);
	G_OBJECT_CLASS (font_manager_base_controls_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_base_controls_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerBaseControlsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_base_controls_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerBaseControls), 0, (GInstanceInitFunc) font_manager_base_controls_instance_init, NULL };
	GType font_manager_base_controls_type_id;
	font_manager_base_controls_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerBaseControls", &g_define_type_info, 0);
	FontManagerBaseControls_private_offset = g_type_add_instance_private (font_manager_base_controls_type_id, sizeof (FontManagerBaseControlsPrivate));
	return font_manager_base_controls_type_id;
}

GType
font_manager_base_controls_get_type (void)
{
	static volatile gsize font_manager_base_controls_type_id__once = 0;
	if (g_once_init_enter (&font_manager_base_controls_type_id__once)) {
		GType font_manager_base_controls_type_id;
		font_manager_base_controls_type_id = font_manager_base_controls_get_type_once ();
		g_once_init_leave (&font_manager_base_controls_type_id__once, font_manager_base_controls_type_id);
	}
	return font_manager_base_controls_type_id__once;
}

static void
_vala_font_manager_base_controls_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	FontManagerBaseControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls);
	switch (property_id) {
		case FONT_MANAGER_BASE_CONTROLS_ADD_BUTTON_PROPERTY:
		g_value_set_object (value, font_manager_base_controls_get_add_button (self));
		break;
		case FONT_MANAGER_BASE_CONTROLS_REMOVE_BUTTON_PROPERTY:
		g_value_set_object (value, font_manager_base_controls_get_remove_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_base_controls_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	FontManagerBaseControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls);
	switch (property_id) {
		case FONT_MANAGER_BASE_CONTROLS_ADD_BUTTON_PROPERTY:
		font_manager_base_controls_set_add_button (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BASE_CONTROLS_REMOVE_BUTTON_PROPERTY:
		font_manager_base_controls_set_remove_button (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
font_manager_preview_entry_real_constructed (GObject* base)
{
	FontManagerPreviewEntry * self;
	self = (FontManagerPreviewEntry*) base;
	font_manager_preview_entry_on_changed_event (self);
	G_OBJECT_CLASS (font_manager_preview_entry_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry));
	return;
}

static void
font_manager_preview_entry_on_icon_press_event (FontManagerPreviewEntry* self,
                                                GtkEntry* entry,
                                                GtkEntryIconPosition position)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	if (position == GTK_ENTRY_ICON_SECONDARY) {
		gtk_editable_set_text ((GtkEditable*) self, "");
	}
	return;
}

static void
_font_manager_preview_entry_on_icon_press_event_gtk_entry_icon_press (GtkEntry* _sender,
                                                                      GtkEntryIconPosition icon_pos,
                                                                      gpointer self)
{
	font_manager_preview_entry_on_icon_press_event ((FontManagerPreviewEntry*) self, _sender, icon_pos);
}

static void
font_manager_preview_entry_on_changed_event (FontManagerPreviewEntry* self)
{
	gboolean empty = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* icon_name = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text_length ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	empty = _tmp1_ == ((guint) 0);
	if (!empty) {
		_tmp2_ = "edit-clear-symbolic";
	} else {
		_tmp2_ = "document-edit-symbolic";
	}
	_tmp3_ = g_strdup (_tmp2_);
	icon_name = _tmp3_;
	gtk_entry_set_icon_from_icon_name ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, icon_name);
	gtk_entry_set_icon_activatable ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, !empty);
	gtk_entry_set_icon_sensitive ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, !empty);
	_g_free0 (icon_name);
	return;
}

static void
_font_manager_preview_entry_on_changed_event_gtk_editable_changed (GtkEditable* _sender,
                                                                   gpointer self)
{
	font_manager_preview_entry_on_changed_event ((FontManagerPreviewEntry*) self);
}

FontManagerPreviewEntry*
font_manager_preview_entry_construct (GType object_type)
{
	FontManagerPreviewEntry * self = NULL;
	self = (FontManagerPreviewEntry*) g_object_new (object_type, NULL);
	return self;
}

FontManagerPreviewEntry*
font_manager_preview_entry_new (void)
{
	return font_manager_preview_entry_construct (FONT_MANAGER_TYPE_PREVIEW_ENTRY);
}

static void
font_manager_preview_entry_class_init (FontManagerPreviewEntryClass * klass,
                                       gpointer klass_data)
{
	font_manager_preview_entry_parent_class = g_type_class_peek_parent (klass);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) font_manager_preview_entry_real_constructed;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-preview-entry.ui");
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_icon_press_event", G_CALLBACK(_font_manager_preview_entry_on_icon_press_event_gtk_entry_icon_press));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_changed_event", G_CALLBACK(_font_manager_preview_entry_on_changed_event_gtk_editable_changed));
}

static void
font_manager_preview_entry_instance_init (FontManagerPreviewEntry * self,
                                          gpointer klass)
{
	gtk_widget_init_template (GTK_WIDGET (self));
}

 G_GNUC_NO_INLINE static GType
font_manager_preview_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerPreviewEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_preview_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerPreviewEntry), 0, (GInstanceInitFunc) font_manager_preview_entry_instance_init, NULL };
	GType font_manager_preview_entry_type_id;
	font_manager_preview_entry_type_id = g_type_register_static (gtk_entry_get_type (), "FontManagerPreviewEntry", &g_define_type_info, 0);
	return font_manager_preview_entry_type_id;
}

GType
font_manager_preview_entry_get_type (void)
{
	static volatile gsize font_manager_preview_entry_type_id__once = 0;
	if (g_once_init_enter (&font_manager_preview_entry_type_id__once)) {
		GType font_manager_preview_entry_type_id;
		font_manager_preview_entry_type_id = font_manager_preview_entry_get_type_once ();
		g_once_init_leave (&font_manager_preview_entry_type_id__once, font_manager_preview_entry_type_id);
	}
	return font_manager_preview_entry_type_id__once;
}

GMenuModel*
font_manager_get_app_menu_model (void)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GMenu* preferences = NULL;
	GMenu* _tmp1_;
	GMenuItem* preferences_menu_item = NULL;
	GMenuItem* _tmp2_;
	GMenu* _tmp3_;
	GMenuItem* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	GMenu* user_data = NULL;
	GMenu* _tmp7_;
	GMenuItem* import_menu_item = NULL;
	GMenuItem* _tmp8_;
	GMenuItem* export_menu_item = NULL;
	GMenuItem* _tmp9_;
	GMenu* _tmp10_;
	GMenuItem* _tmp11_;
	GMenu* _tmp12_;
	GMenuItem* _tmp13_;
	GMenuItem* user_data_submenu = NULL;
	GMenu* _tmp14_;
	GMenuItem* _tmp15_;
	GMenu* _tmp16_;
	GMenuItem* _tmp17_;
	GMenu* standard_entries = NULL;
	GMenu* _tmp18_;
	GMenu* _tmp26_;
	GMenu* _tmp27_;
	GMenu* _tmp28_;
	GMenuModel* _tmp29_;
	GMenuModel* result;
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	_tmp1_ = g_menu_new ();
	preferences = _tmp1_;
	_tmp2_ = g_menu_item_new (_ ("Preferences"), "show-preferences");
	preferences_menu_item = _tmp2_;
	_tmp3_ = preferences;
	_tmp4_ = preferences_menu_item;
	g_menu_append_item (_tmp3_, _tmp4_);
	_tmp5_ = section;
	_tmp6_ = preferences;
	g_menu_prepend_section (_tmp5_, NULL, (GMenuModel*) _tmp6_);
	_tmp7_ = g_menu_new ();
	user_data = _tmp7_;
	_tmp8_ = g_menu_item_new (_ ("Import"), "import");
	import_menu_item = _tmp8_;
	_tmp9_ = g_menu_item_new (_ ("Export"), "export");
	export_menu_item = _tmp9_;
	_tmp10_ = user_data;
	_tmp11_ = import_menu_item;
	g_menu_append_item (_tmp10_, _tmp11_);
	_tmp12_ = user_data;
	_tmp13_ = export_menu_item;
	g_menu_append_item (_tmp12_, _tmp13_);
	_tmp14_ = user_data;
	_tmp15_ = g_menu_item_new_submenu (_ ("User Data"), (GMenuModel*) _tmp14_);
	user_data_submenu = _tmp15_;
	_tmp16_ = section;
	_tmp17_ = user_data_submenu;
	g_menu_prepend_item (_tmp16_, _tmp17_);
	_tmp18_ = g_menu_new ();
	standard_entries = _tmp18_;
	{
		FontManagerMenuEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = FONT_MANAGER_app_menu_entries;
		entry_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_app_menu_entries);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			FontManagerMenuEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				GMenuItem* item = NULL;
				FontManagerMenuEntry _tmp19_;
				const gchar* _tmp20_;
				FontManagerMenuEntry _tmp21_;
				const gchar* _tmp22_;
				GMenuItem* _tmp23_;
				GMenu* _tmp24_;
				GMenuItem* _tmp25_;
				_tmp19_ = entry;
				_tmp20_ = _tmp19_.display_name;
				_tmp21_ = entry;
				_tmp22_ = _tmp21_.action_name;
				_tmp23_ = g_menu_item_new (_tmp20_, _tmp22_);
				item = _tmp23_;
				_tmp24_ = standard_entries;
				_tmp25_ = item;
				g_menu_append_item (_tmp24_, _tmp25_);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp26_ = section;
	_tmp27_ = standard_entries;
	g_menu_append_section (_tmp26_, NULL, (GMenuModel*) _tmp27_);
	_tmp28_ = section;
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, g_menu_model_get_type (), GMenuModel));
	result = _tmp29_;
	_g_object_unref0 (standard_entries);
	_g_object_unref0 (user_data_submenu);
	_g_object_unref0 (export_menu_item);
	_g_object_unref0 (import_menu_item);
	_g_object_unref0 (user_data);
	_g_object_unref0 (preferences_menu_item);
	_g_object_unref0 (preferences);
	_g_object_unref0 (section);
	return result;
}

GMenuModel*
font_manager_get_main_menu_model (void)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GEnumClass* mode_class = NULL;
	GTypeClass* _tmp1_;
	GMenu* _tmp15_;
	GMenuModel* _tmp16_;
	GMenuModel* result;
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	_tmp1_ = g_type_class_ref (FONT_MANAGER_TYPE_MODE);
	mode_class = (GEnumClass*) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* nick = NULL;
				GEnumClass* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				GMenuItem* item = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GMenuItem* _tmp9_;
				GMenuItem* _tmp10_;
				GMenuItem* _tmp11_;
				const gchar* _tmp12_;
				GMenu* _tmp13_;
				GMenuItem* _tmp14_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ((gint) FONT_MANAGER_MODE_N_MODES))) {
					break;
				}
				_tmp4_ = mode_class;
				_tmp5_ = (*g_enum_get_value (_tmp4_, i)).value_nick;
				_tmp6_ = g_strdup (_tmp5_);
				nick = _tmp6_;
				_tmp7_ = font_manager_mode_to_translatable_string ((FontManagerMode) i);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_menu_item_new (_tmp8_, NULL);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				item = _tmp10_;
				_tmp11_ = item;
				_tmp12_ = nick;
				g_menu_item_set_action_and_target (_tmp11_, "mode", "s", _tmp12_, NULL);
				_tmp13_ = section;
				_tmp14_ = item;
				g_menu_append_item (_tmp13_, _tmp14_);
				_g_object_unref0 (item);
				_g_free0 (nick);
			}
		}
	}
	_tmp15_ = section;
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_menu_model_get_type (), GMenuModel));
	result = _tmp16_;
	_g_type_class_unref0 (mode_class);
	_g_object_unref0 (section);
	return result;
}

gchar*
font_manager_sort_type_to_translatable_string (FontManagerSortType self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_SORT_TYPE_NAME:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Name"));
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_SORT_TYPE_SIZE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Size"));
			result = _tmp1_;
			return result;
		}
		default:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("None"));
			result = _tmp2_;
			return result;
		}
	}
}

gchar*
font_manager_sort_type_to_string (FontManagerSortType self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_SORT_TYPE_NAME:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("name");
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_SORT_TYPE_SIZE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("size");
			result = _tmp1_;
			return result;
		}
		default:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("none");
			result = _tmp2_;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
font_manager_sort_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_SORT_TYPE_NAME, "FONT_MANAGER_SORT_TYPE_NAME", "name"}, {FONT_MANAGER_SORT_TYPE_SIZE, "FONT_MANAGER_SORT_TYPE_SIZE", "size"}, {FONT_MANAGER_SORT_TYPE_NONE, "FONT_MANAGER_SORT_TYPE_NONE", "none"}, {FONT_MANAGER_SORT_TYPE_N_SORT_OPTIONS, "FONT_MANAGER_SORT_TYPE_N_SORT_OPTIONS", "n-sort-options"}, {0, NULL, NULL}};
	GType font_manager_sort_type_type_id;
	font_manager_sort_type_type_id = g_enum_register_static ("FontManagerSortType", values);
	return font_manager_sort_type_type_id;
}

GType
font_manager_sort_type_get_type (void)
{
	static volatile gsize font_manager_sort_type_type_id__once = 0;
	if (g_once_init_enter (&font_manager_sort_type_type_id__once)) {
		GType font_manager_sort_type_type_id;
		font_manager_sort_type_type_id = font_manager_sort_type_get_type_once ();
		g_once_init_leave (&font_manager_sort_type_type_id__once, font_manager_sort_type_type_id);
	}
	return font_manager_sort_type_type_id__once;
}

GMenuModel*
font_manager_get_sort_type_menu_model (void)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GEnumClass* mode_class = NULL;
	GTypeClass* _tmp1_;
	GMenu* _tmp15_;
	GMenuModel* _tmp16_;
	GMenuModel* result;
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	_tmp1_ = g_type_class_ref (FONT_MANAGER_TYPE_SORT_TYPE);
	mode_class = (GEnumClass*) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* nick = NULL;
				GEnumClass* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				GMenuItem* item = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GMenuItem* _tmp9_;
				GMenuItem* _tmp10_;
				GMenuItem* _tmp11_;
				const gchar* _tmp12_;
				GMenu* _tmp13_;
				GMenuItem* _tmp14_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ((gint) FONT_MANAGER_SORT_TYPE_N_SORT_OPTIONS))) {
					break;
				}
				_tmp4_ = mode_class;
				_tmp5_ = (*g_enum_get_value (_tmp4_, i)).value_nick;
				_tmp6_ = g_strdup (_tmp5_);
				nick = _tmp6_;
				_tmp7_ = font_manager_sort_type_to_translatable_string ((FontManagerSortType) i);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_menu_item_new (_tmp8_, NULL);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				item = _tmp10_;
				_tmp11_ = item;
				_tmp12_ = nick;
				g_menu_item_set_action_and_target (_tmp11_, "sort-type", "s", _tmp12_, NULL);
				_tmp13_ = section;
				_tmp14_ = item;
				g_menu_append_item (_tmp13_, _tmp14_);
				_g_object_unref0 (item);
				_g_free0 (nick);
			}
		}
	}
	_tmp15_ = section;
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_menu_model_get_type (), GMenuModel));
	result = _tmp16_;
	_g_type_class_unref0 (mode_class);
	_g_object_unref0 (section);
	return result;
}

void
font_manager_toggle_spinner (GtkSpinner* spinner,
                             GtkButton* button,
                             const gchar* icon_name)
{
	g_return_if_fail (spinner != NULL);
	g_return_if_fail (button != NULL);
	if (icon_name == NULL) {
		gtk_spinner_start (spinner);
		gtk_button_set_child (button, (GtkWidget*) spinner);
		gtk_widget_set_sensitive ((GtkWidget*) button, FALSE);
	} else {
		GtkImage* icon = NULL;
		GtkImage* _tmp0_;
		GtkImage* _tmp1_;
		gtk_spinner_stop (spinner);
		_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name);
		g_object_ref_sink (_tmp0_);
		icon = _tmp0_;
		_tmp1_ = icon;
		gtk_button_set_child (button, (GtkWidget*) _tmp1_);
		gtk_widget_set_sensitive ((GtkWidget*) button, TRUE);
		_g_object_unref0 (icon);
	}
	return;
}

static inline gpointer
font_manager_browse_controls_get_instance_private (FontManagerBrowseControls* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerBrowseControls_private_offset);
}

static void
font_manager_browse_controls_on_toggled (FontManagerBrowseControls* self,
                                         GtkToggleButton* toggle)
{
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toggle != NULL);
	_tmp1_ = self->priv->_grid;
	if (toggle == _tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = gtk_toggle_button_get_active (toggle);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		font_manager_browse_controls_set_mode (self, FONT_MANAGER_BROWSE_MODE_GRID);
	} else {
		font_manager_browse_controls_set_mode (self, FONT_MANAGER_BROWSE_MODE_LIST);
	}
	return;
}

FontManagerBrowseControls*
font_manager_browse_controls_construct (GType object_type)
{
	FontManagerBrowseControls * self = NULL;
	self = (FontManagerBrowseControls*) g_object_new (object_type, NULL);
	return self;
}

FontManagerBrowseControls*
font_manager_browse_controls_new (void)
{
	return font_manager_browse_controls_construct (FONT_MANAGER_TYPE_BROWSE_CONTROLS);
}

FontManagerBrowseMode
font_manager_browse_controls_get_mode (FontManagerBrowseControls* self)
{
	FontManagerBrowseMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
font_manager_browse_controls_set_mode (FontManagerBrowseControls* self,
                                       FontManagerBrowseMode value)
{
	FontManagerBrowseMode old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_controls_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_MODE_PROPERTY]);
	}
}

GtkToggleButton*
font_manager_browse_controls_get_grid (FontManagerBrowseControls* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_grid;
	result = _tmp0_;
	return result;
}

static void
font_manager_browse_controls_set_grid (FontManagerBrowseControls* self,
                                       GtkToggleButton* value)
{
	GtkToggleButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_controls_get_grid (self);
	if (old_value != value) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_grid);
		self->priv->_grid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_GRID_PROPERTY]);
	}
}

GtkToggleButton*
font_manager_browse_controls_get_list (FontManagerBrowseControls* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list;
	result = _tmp0_;
	return result;
}

static void
font_manager_browse_controls_set_list (FontManagerBrowseControls* self,
                                       GtkToggleButton* value)
{
	GtkToggleButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_browse_controls_get_list (self);
	if (old_value != value) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list);
		self->priv->_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_LIST_PROPERTY]);
	}
}

static void
_font_manager_browse_controls_on_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self)
{
	font_manager_browse_controls_on_toggled ((FontManagerBrowseControls*) self, _sender);
}

static void
_font_manager_browse_controls___lambda163_ (FontManagerBrowseControls* self)
{
	FontManagerBrowseMode _tmp0_;
	_tmp0_ = self->priv->_mode;
	if (_tmp0_ == FONT_MANAGER_BROWSE_MODE_GRID) {
		GtkToggleButton* _tmp1_;
		_tmp1_ = self->priv->_grid;
		gtk_toggle_button_set_active (_tmp1_, TRUE);
	} else {
		GtkToggleButton* _tmp2_;
		_tmp2_ = self->priv->_list;
		gtk_toggle_button_set_active (_tmp2_, TRUE);
	}
}

static void
__font_manager_browse_controls___lambda163__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	_font_manager_browse_controls___lambda163_ ((FontManagerBrowseControls*) self);
}

static GObject *
font_manager_browse_controls_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerBrowseControls * self;
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp3_;
	gchar** icons = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint icons_length1;
	gint _icons_size_;
	GtkToggleButton** buttons = NULL;
	GtkToggleButton* _tmp7_;
	GtkToggleButton* _tmp8_;
	GtkToggleButton* _tmp9_;
	GtkToggleButton* _tmp10_;
	GtkToggleButton** _tmp11_;
	gint buttons_length1;
	gint _buttons_size_;
	GtkToggleButton* _tmp29_;
	GtkToggleButton* _tmp30_;
	parent_class = G_OBJECT_CLASS (font_manager_browse_controls_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControls);
	_tmp0_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	font_manager_browse_controls_set_grid (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	font_manager_browse_controls_set_list (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = g_strdup ("view-grid-symbolic");
	_tmp5_ = g_strdup ("view-list-symbolic");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	icons = _tmp6_;
	icons_length1 = 2;
	_icons_size_ = icons_length1;
	_tmp7_ = self->priv->_grid;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = self->priv->_list;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_tmp11_ = g_new0 (GtkToggleButton*, 2 + 1);
	_tmp11_[0] = _tmp8_;
	_tmp11_[1] = _tmp10_;
	buttons = _tmp11_;
	buttons_length1 = 2;
	_buttons_size_ = buttons_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GtkToggleButton** _tmp14_;
				gint _tmp14__length1;
				GtkImage* icon = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				GtkImage* _tmp17_ = NULL;
				GtkToggleButton** _tmp18_;
				gint _tmp18__length1;
				GtkToggleButton* _tmp19_;
				GtkImage* _tmp20_;
				GtkToggleButton** _tmp25_;
				gint _tmp25__length1;
				GtkToggleButton* _tmp26_;
				GtkToggleButton** _tmp27_;
				gint _tmp27__length1;
				GtkToggleButton* _tmp28_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = buttons;
				_tmp14__length1 = buttons_length1;
				if (!(i < _tmp14__length1)) {
					break;
				}
				_tmp15_ = icons;
				_tmp15__length1 = icons_length1;
				_tmp16_ = _tmp15_[i];
				_tmp17_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp16_);
				gtk_widget_set_opacity ((GtkWidget*) _tmp17_, (gdouble) 0.5f);
				g_object_ref_sink (_tmp17_);
				icon = _tmp17_;
				_tmp18_ = buttons;
				_tmp18__length1 = buttons_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = icon;
				gtk_button_set_child ((GtkButton*) _tmp19_, (GtkWidget*) _tmp20_);
				if (i > 0) {
					GtkToggleButton** _tmp21_;
					gint _tmp21__length1;
					GtkToggleButton* _tmp22_;
					GtkToggleButton** _tmp23_;
					gint _tmp23__length1;
					GtkToggleButton* _tmp24_;
					_tmp21_ = buttons;
					_tmp21__length1 = buttons_length1;
					_tmp22_ = _tmp21_[i];
					_tmp23_ = buttons;
					_tmp23__length1 = buttons_length1;
					_tmp24_ = _tmp23_[0];
					gtk_toggle_button_set_group (_tmp22_, _tmp24_);
				}
				_tmp25_ = buttons;
				_tmp25__length1 = buttons_length1;
				_tmp26_ = _tmp25_[i];
				gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp26_);
				_tmp27_ = buttons;
				_tmp27__length1 = buttons_length1;
				_tmp28_ = _tmp27_[i];
				g_signal_connect_object (_tmp28_, "toggled", (GCallback) _font_manager_browse_controls_on_toggled_gtk_toggle_button_toggled, self, 0);
				_g_object_unref0 (icon);
			}
		}
	}
	_tmp29_ = self->priv->_grid;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _ ("Grid View"));
	_tmp30_ = self->priv->_list;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("List View"));
	g_signal_connect_object ((GObject*) self, "notify::mode", (GCallback) __font_manager_browse_controls___lambda163__g_object_notify, self, 0);
	buttons = (_vala_array_free (buttons, buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	return obj;
}

static void
font_manager_browse_controls_class_init (FontManagerBrowseControlsClass * klass,
                                         gpointer klass_data)
{
	font_manager_browse_controls_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerBrowseControls_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_browse_controls_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_browse_controls_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_browse_controls_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_browse_controls_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_CONTROLS_MODE_PROPERTY, font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", FONT_MANAGER_TYPE_BROWSE_MODE, FONT_MANAGER_BROWSE_MODE_GRID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_CONTROLS_GRID_PROPERTY, font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_GRID_PROPERTY] = g_param_spec_object ("grid", "grid", "grid", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_BROWSE_CONTROLS_LIST_PROPERTY, font_manager_browse_controls_properties[FONT_MANAGER_BROWSE_CONTROLS_LIST_PROPERTY] = g_param_spec_object ("list", "list", "list", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_browse_controls_instance_init (FontManagerBrowseControls * self,
                                            gpointer klass)
{
	self->priv = font_manager_browse_controls_get_instance_private (self);
	self->priv->_mode = FONT_MANAGER_BROWSE_MODE_GRID;
}

static void
font_manager_browse_controls_finalize (GObject * obj)
{
	FontManagerBrowseControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControls);
	_g_object_unref0 (self->priv->_grid);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (font_manager_browse_controls_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_browse_controls_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerBrowseControlsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_browse_controls_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerBrowseControls), 0, (GInstanceInitFunc) font_manager_browse_controls_instance_init, NULL };
	GType font_manager_browse_controls_type_id;
	font_manager_browse_controls_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerBrowseControls", &g_define_type_info, 0);
	FontManagerBrowseControls_private_offset = g_type_add_instance_private (font_manager_browse_controls_type_id, sizeof (FontManagerBrowseControlsPrivate));
	return font_manager_browse_controls_type_id;
}

GType
font_manager_browse_controls_get_type (void)
{
	static volatile gsize font_manager_browse_controls_type_id__once = 0;
	if (g_once_init_enter (&font_manager_browse_controls_type_id__once)) {
		GType font_manager_browse_controls_type_id;
		font_manager_browse_controls_type_id = font_manager_browse_controls_get_type_once ();
		g_once_init_leave (&font_manager_browse_controls_type_id__once, font_manager_browse_controls_type_id);
	}
	return font_manager_browse_controls_type_id__once;
}

static void
_vala_font_manager_browse_controls_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerBrowseControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControls);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_CONTROLS_MODE_PROPERTY:
		g_value_set_enum (value, font_manager_browse_controls_get_mode (self));
		break;
		case FONT_MANAGER_BROWSE_CONTROLS_GRID_PROPERTY:
		g_value_set_object (value, font_manager_browse_controls_get_grid (self));
		break;
		case FONT_MANAGER_BROWSE_CONTROLS_LIST_PROPERTY:
		g_value_set_object (value, font_manager_browse_controls_get_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_browse_controls_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerBrowseControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControls);
	switch (property_id) {
		case FONT_MANAGER_BROWSE_CONTROLS_MODE_PROPERTY:
		font_manager_browse_controls_set_mode (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_BROWSE_CONTROLS_GRID_PROPERTY:
		font_manager_browse_controls_set_grid (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_BROWSE_CONTROLS_LIST_PROPERTY:
		font_manager_browse_controls_set_list (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_header_bar_widgets_get_instance_private (FontManagerHeaderBarWidgets* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerHeaderBarWidgets_private_offset);
}

void
font_manager_header_bar_widgets_reveal_controls (FontManagerHeaderBarWidgets* self,
                                                 FontManagerMode mode)
{
	FontManagerBrowseControls* _tmp0_;
	FontManagerBaseControls* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkRevealer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_browse_controls;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, mode == FONT_MANAGER_MODE_BROWSE);
	_tmp1_ = self->priv->manage_controls;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, mode == FONT_MANAGER_MODE_MANAGE);
	if (mode == FONT_MANAGER_MODE_BROWSE) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = mode == FONT_MANAGER_MODE_MANAGE;
	}
	_tmp3_ = self->priv->_revealer;
	gtk_revealer_set_reveal_child (_tmp3_, _tmp2_);
	return;
}

static void
___lambda164_ (FontManagerHeaderBarWidgets* self,
               const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "headerbar-button-style") == 0) {
		font_manager_header_bar_widgets_set_button_style (self);
	}
}

static void
____lambda164__g_settings_changed (GSettings* _sender,
                                   const gchar* key,
                                   gpointer self)
{
	___lambda164_ ((FontManagerHeaderBarWidgets*) self, key);
}

FontManagerHeaderBarWidgets*
font_manager_header_bar_widgets_construct (GType object_type,
                                           GSettings* settings)
{
	FontManagerHeaderBarWidgets * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkMenuButton* _tmp3_ = NULL;
	GtkMenuButton* _tmp4_;
	GtkImage* main_menu_icon = NULL;
	GtkImage* _tmp5_;
	GtkBox* main_menu_container = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkImage* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	gchar* markup = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkLabel* _tmp15_;
	const gchar* _tmp16_;
	GtkBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkMenuButton* _tmp19_;
	GtkBox* _tmp20_;
	GtkMenuButton* _tmp21_;
	GMenuModel* _tmp22_;
	GMenuModel* _tmp23_;
	GtkMenuButton* _tmp24_ = NULL;
	GtkMenuButton* _tmp25_;
	GtkMenuButton* _tmp26_;
	GMenuModel* _tmp27_;
	GMenuModel* _tmp28_;
	GtkMenuButton* _tmp29_;
	GtkRevealer* _tmp30_;
	GtkRevealer* _tmp31_;
	GtkRevealer* _tmp32_;
	FontManagerBaseControls* _tmp33_ = NULL;
	FontManagerBrowseControls* _tmp34_;
	FontManagerBrowseControls* _tmp35_;
	FontManagerBrowseControls* _tmp36_;
	FontManagerBaseControls* _tmp37_;
	FontManagerBaseControls* _tmp38_;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	FontManagerBaseControls* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	FontManagerBaseControls* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	FontManagerBaseControls* _tmp47_;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	FontManagerBaseControls* _tmp50_;
	GtkButton* _tmp51_;
	GtkButton* _tmp52_;
	FontManagerBaseControls* _tmp53_;
	GtkButton* _tmp54_;
	GtkButton* _tmp55_;
	FontManagerBaseControls* _tmp56_;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp59_ = NULL;
	GtkSeparator* _tmp60_;
	GtkBox* container = NULL;
	GtkBox* _tmp61_;
	GtkBox* _tmp62_;
	GtkSeparator* _tmp63_;
	GtkBox* _tmp64_;
	FontManagerBaseControls* _tmp65_;
	GtkBox* _tmp66_;
	FontManagerBrowseControls* _tmp67_;
	GtkRevealer* _tmp68_;
	GtkBox* _tmp69_;
	GtkRevealer* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GtkButton* _tmp73_ = NULL;
	GtkButton* _tmp74_;
	GtkSpinner* _tmp75_;
	GtkSpinner* _tmp76_;
	self = (FontManagerHeaderBarWidgets*) g_object_new (object_type, "settings", settings, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (DISPLAY_NAME);
	gtk_label_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_NONE);
	gtk_label_set_single_line_mode (_tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	font_manager_header_bar_widgets_set_title_label (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "title");
	_tmp3_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_widget_set_opacity ((GtkWidget*) _tmp3_, 0.9);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	font_manager_header_bar_widgets_set_main_menu (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-symbolic");
	g_object_ref_sink (_tmp5_);
	main_menu_icon = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	main_menu_container = _tmp6_;
	_tmp7_ = main_menu_container;
	_tmp8_ = main_menu_icon;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	font_manager_header_bar_widgets_set_main_menu_label (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = font_manager_mode_to_translatable_string (font_manager_mode_parse ("Default"));
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("<b>%s</b>", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	markup = _tmp14_;
	_tmp15_ = self->priv->_main_menu_label;
	_tmp16_ = markup;
	gtk_label_set_markup (_tmp15_, _tmp16_);
	_tmp17_ = main_menu_container;
	_tmp18_ = self->priv->_main_menu_label;
	gtk_box_append (_tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->_main_menu;
	_tmp20_ = main_menu_container;
	gtk_menu_button_set_child (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->_main_menu;
	_tmp22_ = font_manager_get_main_menu_model ();
	_tmp23_ = _tmp22_;
	gtk_menu_button_set_menu_model (_tmp21_, _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_widget_set_opacity ((GtkWidget*) _tmp24_, 0.9);
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	font_manager_header_bar_widgets_set_app_menu (self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = self->priv->_app_menu;
	_tmp27_ = font_manager_get_app_menu_model ();
	_tmp28_ = _tmp27_;
	gtk_menu_button_set_menu_model (_tmp26_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = self->priv->_app_menu;
	gtk_menu_button_set_icon_name (_tmp29_, "open-menu-symbolic");
	_tmp30_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	font_manager_header_bar_widgets_set_revealer (self, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = self->priv->_revealer;
	gtk_revealer_set_transition_type (_tmp32_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp33_ = font_manager_base_controls_new ();
	gtk_box_set_spacing ((GtkBox*) _tmp33_, 4);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->manage_controls);
	self->priv->manage_controls = _tmp33_;
	_tmp34_ = font_manager_browse_controls_new ();
	g_object_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	font_manager_header_bar_widgets_set_browse_controls (self, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = self->priv->_browse_controls;
	gtk_widget_add_css_class ((GtkWidget*) _tmp36_, "linked");
	_tmp37_ = self->priv->manage_controls;
	font_manager_widget_set_margin ((GtkWidget*) _tmp37_, 0);
	_tmp38_ = self->priv->manage_controls;
	_tmp39_ = font_manager_base_controls_get_add_button (_tmp38_);
	_tmp40_ = _tmp39_;
	gtk_button_set_has_frame (_tmp40_, TRUE);
	_tmp41_ = self->priv->manage_controls;
	_tmp42_ = font_manager_base_controls_get_remove_button (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_button_set_has_frame (_tmp43_, TRUE);
	_tmp44_ = self->priv->manage_controls;
	_tmp45_ = font_manager_base_controls_get_remove_button (_tmp44_);
	_tmp46_ = _tmp45_;
	font_manager_set_control_sensitivity ((GtkWidget*) _tmp46_, TRUE);
	_tmp47_ = self->priv->manage_controls;
	_tmp48_ = font_manager_base_controls_get_add_button (_tmp47_);
	_tmp49_ = _tmp48_;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp49_, "install");
	_tmp50_ = self->priv->manage_controls;
	_tmp51_ = font_manager_base_controls_get_remove_button (_tmp50_);
	_tmp52_ = _tmp51_;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp52_, "remove");
	_tmp53_ = self->priv->manage_controls;
	_tmp54_ = font_manager_base_controls_get_add_button (_tmp53_);
	_tmp55_ = _tmp54_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp55_, _ ("Add Fonts"));
	_tmp56_ = self->priv->manage_controls;
	_tmp57_ = font_manager_base_controls_get_remove_button (_tmp56_);
	_tmp58_ = _tmp57_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp58_, _ ("Remove Fonts"));
	_tmp59_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp59_, 4);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp59_, 2);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp59_, 2);
	g_object_ref_sink (_tmp59_);
	separator = _tmp59_;
	_tmp60_ = separator;
	gtk_widget_add_css_class ((GtkWidget*) _tmp60_, "separator");
	_tmp61_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp61_);
	container = _tmp61_;
	_tmp62_ = container;
	_tmp63_ = separator;
	gtk_box_prepend (_tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = container;
	_tmp65_ = self->priv->manage_controls;
	gtk_box_append (_tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = container;
	_tmp67_ = self->priv->_browse_controls;
	gtk_box_append (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = self->priv->_revealer;
	_tmp69_ = container;
	gtk_revealer_set_child (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = self->priv->_revealer;
	gtk_revealer_set_reveal_child (_tmp70_, FALSE);
	_tmp71_ = g_strdup (_ ("Back"));
	_tmp72_ = g_strdup ("show-preferences");
	_tmp73_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic");
	gtk_widget_set_opacity ((GtkWidget*) _tmp73_, 0.9);
	gtk_widget_set_visible ((GtkWidget*) _tmp73_, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp73_, _tmp71_);
	_g_free0 (_tmp71_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp73_, _tmp72_);
	_g_free0 (_tmp72_);
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	font_manager_header_bar_widgets_set_back_button (self, _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp75_);
	_tmp76_ = _tmp75_;
	font_manager_header_bar_widgets_set_spinner (self, _tmp76_);
	_g_object_unref0 (_tmp76_);
	if (settings != NULL) {
		font_manager_header_bar_widgets_set_button_style (self);
		g_signal_connect_object (settings, "changed", (GCallback) ____lambda164__g_settings_changed, self, 0);
	}
	_g_object_unref0 (container);
	_g_object_unref0 (separator);
	_g_free0 (markup);
	_g_object_unref0 (main_menu_container);
	_g_object_unref0 (main_menu_icon);
	return self;
	return self;
}

FontManagerHeaderBarWidgets*
font_manager_header_bar_widgets_new (GSettings* settings)
{
	return font_manager_header_bar_widgets_construct (FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, settings);
}

static void
font_manager_header_bar_widgets_set_button_style (FontManagerHeaderBarWidgets* self)
{
	GSettings* _tmp0_;
	GtkWidget** buttons = NULL;
	GtkMenuButton* _tmp1_;
	GtkWidget* _tmp2_;
	GtkMenuButton* _tmp3_;
	GtkWidget* _tmp4_;
	GtkButton* _tmp5_;
	GtkWidget* _tmp6_;
	FontManagerBaseControls* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkWidget* _tmp10_;
	FontManagerBaseControls* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkWidget* _tmp14_;
	FontManagerBrowseControls* _tmp15_;
	GtkToggleButton* _tmp16_;
	GtkToggleButton* _tmp17_;
	GtkWidget* _tmp18_;
	FontManagerBrowseControls* _tmp19_;
	GtkToggleButton* _tmp20_;
	GtkToggleButton* _tmp21_;
	GtkWidget* _tmp22_;
	GtkWidget** _tmp23_;
	gint buttons_length1;
	gint _buttons_size_;
	gint raised = 0;
	GSettings* _tmp24_;
	GtkWidget** _tmp25_;
	gint _tmp25__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_vala_return_if_fail (_tmp0_ != NULL, "settings != null");
	_tmp1_ = self->priv->_main_menu;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	_tmp3_ = self->priv->_app_menu;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _tmp3_);
	_tmp5_ = self->priv->_back_button;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	_tmp7_ = self->priv->manage_controls;
	_tmp8_ = font_manager_base_controls_get_add_button (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = self->priv->manage_controls;
	_tmp12_ = font_manager_base_controls_get_remove_button (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	_tmp15_ = self->priv->_browse_controls;
	_tmp16_ = font_manager_browse_controls_get_grid (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 ((GtkWidget*) _tmp17_);
	_tmp19_ = self->priv->_browse_controls;
	_tmp20_ = font_manager_browse_controls_get_list (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	_tmp23_ = g_new0 (GtkWidget*, 7 + 1);
	_tmp23_[0] = _tmp2_;
	_tmp23_[1] = _tmp4_;
	_tmp23_[2] = _tmp6_;
	_tmp23_[3] = _tmp10_;
	_tmp23_[4] = _tmp14_;
	_tmp23_[5] = _tmp18_;
	_tmp23_[6] = _tmp22_;
	buttons = _tmp23_;
	buttons_length1 = 7;
	_buttons_size_ = buttons_length1;
	_tmp24_ = self->priv->_settings;
	raised = g_settings_get_enum (_tmp24_, "headerbar-button-style");
	_tmp25_ = buttons;
	_tmp25__length1 = buttons_length1;
	{
		GtkWidget** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp25_;
		button_collection_length1 = _tmp25__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkWidget* _tmp26_;
			GtkWidget* button = NULL;
			_tmp26_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp26_;
			{
				GtkWidget* _tmp27_;
				_tmp27_ = button;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_menu_button_get_type ())) {
					GtkWidget* _tmp28_;
					_tmp28_ = button;
					gtk_menu_button_set_has_frame (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_menu_button_get_type (), GtkMenuButton), raised == 0);
				} else {
					GtkWidget* _tmp29_;
					_tmp29_ = button;
					gtk_button_set_has_frame (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_button_get_type (), GtkButton), raised == 0);
				}
				_g_object_unref0 (button);
			}
		}
	}
	buttons = (_vala_array_free (buttons, buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	return;
}

GtkMenuButton*
font_manager_header_bar_widgets_get_main_menu (FontManagerHeaderBarWidgets* self)
{
	GtkMenuButton* result;
	GtkMenuButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_menu;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_main_menu (FontManagerHeaderBarWidgets* self,
                                               GtkMenuButton* value)
{
	GtkMenuButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_main_menu (self);
	if (old_value != value) {
		GtkMenuButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_main_menu);
		self->priv->_main_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_PROPERTY]);
	}
}

GtkMenuButton*
font_manager_header_bar_widgets_get_app_menu (FontManagerHeaderBarWidgets* self)
{
	GtkMenuButton* result;
	GtkMenuButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_menu;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_app_menu (FontManagerHeaderBarWidgets* self,
                                              GtkMenuButton* value)
{
	GtkMenuButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_app_menu (self);
	if (old_value != value) {
		GtkMenuButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_menu);
		self->priv->_app_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_APP_MENU_PROPERTY]);
	}
}

GtkLabel*
font_manager_header_bar_widgets_get_main_menu_label (FontManagerHeaderBarWidgets* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_menu_label;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_main_menu_label (FontManagerHeaderBarWidgets* self,
                                                     GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_main_menu_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_main_menu_label);
		self->priv->_main_menu_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_LABEL_PROPERTY]);
	}
}

GtkLabel*
font_manager_header_bar_widgets_get_title_label (FontManagerHeaderBarWidgets* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title_label;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_title_label (FontManagerHeaderBarWidgets* self,
                                                 GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_title_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_title_label);
		self->priv->_title_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_TITLE_LABEL_PROPERTY]);
	}
}

GtkButton*
font_manager_header_bar_widgets_get_back_button (FontManagerHeaderBarWidgets* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_back_button;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_back_button (FontManagerHeaderBarWidgets* self,
                                                 GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_back_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_back_button);
		self->priv->_back_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_BACK_BUTTON_PROPERTY]);
	}
}

GSettings*
font_manager_header_bar_widgets_get_settings (FontManagerHeaderBarWidgets* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_settings (FontManagerHeaderBarWidgets* self,
                                              GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_SETTINGS_PROPERTY]);
	}
}

void
font_manager_header_bar_widgets_set_installing_files (FontManagerHeaderBarWidgets* self,
                                                      gboolean value)
{
	const gchar* _tmp0_ = NULL;
	GtkSpinner* _tmp1_;
	FontManagerBaseControls* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = "list-add-symbolic";
	}
	_tmp1_ = self->priv->_spinner;
	_tmp2_ = self->priv->manage_controls;
	_tmp3_ = font_manager_base_controls_get_add_button (_tmp2_);
	_tmp4_ = _tmp3_;
	font_manager_toggle_spinner (_tmp1_, _tmp4_, _tmp0_);
	g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_INSTALLING_FILES_PROPERTY]);
}

void
font_manager_header_bar_widgets_set_removing_files (FontManagerHeaderBarWidgets* self,
                                                    gboolean value)
{
	const gchar* _tmp0_ = NULL;
	GtkSpinner* _tmp1_;
	FontManagerBaseControls* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = "list-remove-symbolic";
	}
	_tmp1_ = self->priv->_spinner;
	_tmp2_ = self->priv->manage_controls;
	_tmp3_ = font_manager_base_controls_get_remove_button (_tmp2_);
	_tmp4_ = _tmp3_;
	font_manager_toggle_spinner (_tmp1_, _tmp4_, _tmp0_);
	g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_REMOVING_FILES_PROPERTY]);
}

GtkRevealer*
font_manager_header_bar_widgets_get_revealer (FontManagerHeaderBarWidgets* self)
{
	GtkRevealer* result;
	GtkRevealer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_revealer;
	result = _tmp0_;
	return result;
}

static void
font_manager_header_bar_widgets_set_revealer (FontManagerHeaderBarWidgets* self,
                                              GtkRevealer* value)
{
	GtkRevealer* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_revealer (self);
	if (old_value != value) {
		GtkRevealer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_revealer);
		self->priv->_revealer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_REVEALER_PROPERTY]);
	}
}

GtkSpinner*
font_manager_header_bar_widgets_get_spinner (FontManagerHeaderBarWidgets* self)
{
	GtkSpinner* result;
	GtkSpinner* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spinner;
	result = _tmp0_;
	return result;
}

void
font_manager_header_bar_widgets_set_spinner (FontManagerHeaderBarWidgets* self,
                                             GtkSpinner* value)
{
	GtkSpinner* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_spinner (self);
	if (old_value != value) {
		GtkSpinner* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_spinner);
		self->priv->_spinner = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_SPINNER_PROPERTY]);
	}
}

FontManagerBrowseControls*
font_manager_header_bar_widgets_get_browse_controls (FontManagerHeaderBarWidgets* self)
{
	FontManagerBrowseControls* result;
	FontManagerBrowseControls* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_browse_controls;
	result = _tmp0_;
	return result;
}

static void
font_manager_header_bar_widgets_set_browse_controls (FontManagerHeaderBarWidgets* self,
                                                     FontManagerBrowseControls* value)
{
	FontManagerBrowseControls* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_header_bar_widgets_get_browse_controls (self);
	if (old_value != value) {
		FontManagerBrowseControls* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_browse_controls);
		self->priv->_browse_controls = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_BROWSE_CONTROLS_PROPERTY]);
	}
}

static void
font_manager_header_bar_widgets_class_init (FontManagerHeaderBarWidgetsClass * klass,
                                            gpointer klass_data)
{
	font_manager_header_bar_widgets_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerHeaderBarWidgets_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_header_bar_widgets_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_header_bar_widgets_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_header_bar_widgets_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_PROPERTY] = g_param_spec_object ("main-menu", "main-menu", "main-menu", gtk_menu_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_APP_MENU_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_APP_MENU_PROPERTY] = g_param_spec_object ("app-menu", "app-menu", "app-menu", gtk_menu_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_LABEL_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_LABEL_PROPERTY] = g_param_spec_object ("main-menu-label", "main-menu-label", "main-menu-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_TITLE_LABEL_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_TITLE_LABEL_PROPERTY] = g_param_spec_object ("title-label", "title-label", "title-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_BACK_BUTTON_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_BACK_BUTTON_PROPERTY] = g_param_spec_object ("back-button", "back-button", "back-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_SETTINGS_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_INSTALLING_FILES_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_INSTALLING_FILES_PROPERTY] = g_param_spec_boolean ("installing-files", "installing-files", "installing-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_REMOVING_FILES_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_REMOVING_FILES_PROPERTY] = g_param_spec_boolean ("removing-files", "removing-files", "removing-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_REVEALER_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_REVEALER_PROPERTY] = g_param_spec_object ("revealer", "revealer", "revealer", gtk_revealer_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_SPINNER_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_SPINNER_PROPERTY] = g_param_spec_object ("spinner", "spinner", "spinner", gtk_spinner_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_HEADER_BAR_WIDGETS_BROWSE_CONTROLS_PROPERTY, font_manager_header_bar_widgets_properties[FONT_MANAGER_HEADER_BAR_WIDGETS_BROWSE_CONTROLS_PROPERTY] = g_param_spec_object ("browse-controls", "browse-controls", "browse-controls", FONT_MANAGER_TYPE_BROWSE_CONTROLS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_header_bar_widgets_instance_init (FontManagerHeaderBarWidgets * self,
                                               gpointer klass)
{
	self->priv = font_manager_header_bar_widgets_get_instance_private (self);
	self->priv->_settings = NULL;
}

static void
font_manager_header_bar_widgets_finalize (GObject * obj)
{
	FontManagerHeaderBarWidgets * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgets);
	_g_object_unref0 (self->priv->_main_menu);
	_g_object_unref0 (self->priv->_app_menu);
	_g_object_unref0 (self->priv->_main_menu_label);
	_g_object_unref0 (self->priv->_title_label);
	_g_object_unref0 (self->priv->_back_button);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_revealer);
	_g_object_unref0 (self->priv->_spinner);
	_g_object_unref0 (self->priv->manage_controls);
	_g_object_unref0 (self->priv->_browse_controls);
	G_OBJECT_CLASS (font_manager_header_bar_widgets_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_header_bar_widgets_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerHeaderBarWidgetsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_header_bar_widgets_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerHeaderBarWidgets), 0, (GInstanceInitFunc) font_manager_header_bar_widgets_instance_init, NULL };
	GType font_manager_header_bar_widgets_type_id;
	font_manager_header_bar_widgets_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerHeaderBarWidgets", &g_define_type_info, 0);
	FontManagerHeaderBarWidgets_private_offset = g_type_add_instance_private (font_manager_header_bar_widgets_type_id, sizeof (FontManagerHeaderBarWidgetsPrivate));
	return font_manager_header_bar_widgets_type_id;
}

GType
font_manager_header_bar_widgets_get_type (void)
{
	static volatile gsize font_manager_header_bar_widgets_type_id__once = 0;
	if (g_once_init_enter (&font_manager_header_bar_widgets_type_id__once)) {
		GType font_manager_header_bar_widgets_type_id;
		font_manager_header_bar_widgets_type_id = font_manager_header_bar_widgets_get_type_once ();
		g_once_init_leave (&font_manager_header_bar_widgets_type_id__once, font_manager_header_bar_widgets_type_id);
	}
	return font_manager_header_bar_widgets_type_id__once;
}

static void
_vala_font_manager_header_bar_widgets_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	FontManagerHeaderBarWidgets * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgets);
	switch (property_id) {
		case FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_main_menu (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_APP_MENU_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_app_menu (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_LABEL_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_main_menu_label (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_TITLE_LABEL_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_title_label (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_BACK_BUTTON_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_back_button (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_settings (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_REVEALER_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_revealer (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_SPINNER_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_spinner (self));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_BROWSE_CONTROLS_PROPERTY:
		g_value_set_object (value, font_manager_header_bar_widgets_get_browse_controls (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_header_bar_widgets_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	FontManagerHeaderBarWidgets * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgets);
	switch (property_id) {
		case FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_PROPERTY:
		font_manager_header_bar_widgets_set_main_menu (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_APP_MENU_PROPERTY:
		font_manager_header_bar_widgets_set_app_menu (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_MAIN_MENU_LABEL_PROPERTY:
		font_manager_header_bar_widgets_set_main_menu_label (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_TITLE_LABEL_PROPERTY:
		font_manager_header_bar_widgets_set_title_label (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_BACK_BUTTON_PROPERTY:
		font_manager_header_bar_widgets_set_back_button (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_SETTINGS_PROPERTY:
		font_manager_header_bar_widgets_set_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_INSTALLING_FILES_PROPERTY:
		font_manager_header_bar_widgets_set_installing_files (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_REMOVING_FILES_PROPERTY:
		font_manager_header_bar_widgets_set_removing_files (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_REVEALER_PROPERTY:
		font_manager_header_bar_widgets_set_revealer (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_SPINNER_PROPERTY:
		font_manager_header_bar_widgets_set_spinner (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_HEADER_BAR_WIDGETS_BROWSE_CONTROLS_PROPERTY:
		font_manager_header_bar_widgets_set_browse_controls (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

