# tkdvi.tcl -- Basic setup for TkDVI.
# Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>.
# See file COPYING for conditions on use and distribution.
# $Id: tkdvi.tcl,v 1.1.1.1 1999/06/10 12:36:50 lingnau Exp $

package provide tkdvi 0.1

# The DVI package can be configured at load time by setting the
# following variables prior to the `package require dvi'. The values
# given here are the hard-coded defaults, which can be overridden in
# a `userInit' procedure.

# set dvi(makepk) 1
# set dvi(mfmode) ljfour
# set dvi(xresolution) 600
# set dvi(defaultfont) cmr10

package require dvi

namespace eval tkdvi {
    proc version {} {
	return "0.1 (Alpha test)"
    }
    proc reloadAll {} {
	foreach w [winfo children .] {
	    if {[string match .tkdvi* $w]} {
		tkdvi::browser::reload $w
	    }
	}
    }
}

package require tkdvi::menu
package require tkdvi::pagesel
package require tkdvi::browser
package require tkdvi::dialog
