// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
static const char rcsid[] = "$Header: dirs.C,v 1.10 91/02/22 15:57:16 hmgr Exp $";

// read font directory names into memory for fast traversal
//
// by Parag Patel

#include "defs.h"
#include "dirs.h"
#ifdef	__ZTC__
#include <dos.h>
#define	d_name	name
#else
#ifdef	BSD
#include <sys/dir.h>
#else
#include <ndir.h>
#endif
#endif


implement_array(Dirlist, Dirent);
implement_array(Pathlist, Pathent);


Pathlist pathlist;


Dirent::Dirent()
{
    name = NULL;
    val = 0;
}

Pathent::Pathent()
{
    path = NULL;
}

Pathent &Pathent::operator=(Pathent &x)
{
    path = x.path;
    dirs = x.dirs;
    return *this;
}


void setupdirs(char *path)
{
    path = strdup(path);
    char *save = path;

    pathlist.reset();

    debug(3, "Setup dirpaths = %s", path);
    while (path != NULL && *path != '\0')
    {
	char *dirpath = path;
	while (*path != PATHSEP && *path != '\0')
	    path++;
	if (*path != '\0')
	    *path++ = '\0';
	debug(4, "  DIR = %s", dirpath);

#ifndef	__ZTC__
	DIR *dir = opendir(dirpath);
	if (dir == NULL)
	{
	    warn("Cannot opendir directory \"%s\" for scanning", dirpath);
	    continue;
	}
#endif

	Pathent & path = pathlist[pathlist.size()];
	path.path = strdup(dirpath);
	path.dirs.reset();

#ifdef	__ZTC__
	char dos_dirpath[64];
	(void)strcpy(dos_dirpath, dirpath);
	(void)strcat(dos_dirpath, "/*.*");
	for (FIND *ent = findfirst(dos_dirpath, FA_DIREC); ent != NULL;
		ent = findnext())
#else
	for (direct * ent = readdir(dir); ent != NULL; ent = readdir(dir))
#endif
	{
	    char *s = strchr(ent->d_name, '.');
	    int magent;

	    if (s != NULL)
	    {
		// if there is a dot in the name, it may be the newer
		// magnification value naming conventions: "1.000"
		*s = '\0';
		magent = atoi(ent->d_name) * 1000 + atoi(s + 1);
		*s = '.';
	    }
	    else
		// older resolution naming convention: "300", "1000"
		magent = atoi(ent->d_name);

	    if (magent <= 0)
		continue;

	    Dirent & d = path.dirs[path.dirs.size()];
	    d.name = strdup(ent->d_name);
	    d.val = magent;
	    debug(5, "    name=%s  val=%d", d.name, d.val);
	}

#ifndef	__ZTC__
	closedir(dir);
#endif
    }
    strfree(save);
}
