/*
 * Copyright (c) 1992, Bruno Grossniklaus, grossnik@iam.unibe.ch
 * 
 * I added new features for special use at the IAM and fixed some bugs.
 * 
 */

/*
 * Copyright (c) 1990, William C. Ogden, ogden@nmsu.edu
 * 
 * Permission is granted to copy and distribute this file in modified or
 * unmodified form, for noncommercial use, provided (a) this copyright notice
 * is preserved, (b) no attempt is made to restrict redistribution of this
 * file, and (c) this file is not distributed as part of any collection whose
 * redistribution is restricted by a compilation copyright.
 */


/*
 * bc_stubs.c - Notify and event callback function stubs. This file was
 * generated by `gxv' from `bc.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <gdd.h>
#include <gutil.h>
#include "bc_ui.h"

#include "bc_stubs.h"

/*
 * Global object definitions.
 */
bc_base_window_objects *Bc_base_window;
bc_find_popup_objects *Bc_find_popup;
bc_list_popup_objects *Bc_list_popup;
bc_sort_popup_objects *Bc_sort_popup;
bc_annotation_popup_objects *Bc_annotation_popup;
bc_ns_popup_objects *Bc_ns_popup;
bc_clip_buffer_popup_objects *Bc_clip_buffer_popup;
bc_abbrev_popup_objects *Bc_abbrev_popup;
bc_expand_popup_objects *Bc_expand_popup;
bc_properties_popup_objects *Bc_properties_popup;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related user interface
 * objects.  A pointer to an object's instance is stored under this key in
 * every object.  This must be a global variable.
 */

Attr_attribute  INSTANCE;

#define FILE_MENU_ITEMS 10	/* two more than actually shows */
#define NEW_BIB 2
#define LOAD_REPLACE 3
#define LOAD_MERGE 4
#define SAVE 5
#define SAVE_AS 6
#define SAVE_SELECTION 7
#define REVERT 8
#define QUIT 9

Menu_item       file_menu[FILE_MENU_ITEMS];

int             file_menu_save_inactive = FALSE;
int             file_menu_save_as_inactive = FALSE;
int             file_menu_save_selection_inactive = FALSE;
int             file_menu_revert_inactive = FALSE;
int             edit_menu_paste_inactive = FALSE;
int             edit_menu_add_selection_inactive = FALSE;
int             view_menu_list_inactive = FALSE;
int             main_menu_show_list_inactive = FALSE;
int             main_menu_updating_inactive = FALSE;
int             list_menu_show_list_with_inactive = FALSE;
int             list_menu_show_list_no_inactive = FALSE;
int             list_menu_clear_select_all_inactive = FALSE;


Notify_value
destroy_func(client, status)
	Notify_client   client;
	Destroy_status  status;
{
	if (status == DESTROY_CHECKING) {
		if (strlen((char *) xv_get(Bc_base_window->base_window_citekey, PANEL_VALUE)) > 0)
			update_item();
		if (confirm_overwrite() == 0) {
			if (xv_destroy_safe(Bc_base_window->base_window) == XV_OK)
				exit(OK);
		} else
			notify_veto_destroy(client);
	}
	return NOTIFY_DONE;
}



main(argc, argv)
	int             argc;
	char          **argv;
{
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
	INSTANCE = xv_unique_key();

	/*
	 * Initialize user interface components. Do NOT edit the object
	 * initializations by hand.
	 */
	Bc_base_window = bc_base_window_objects_initialize(NULL, NULL);
	Bc_find_popup = bc_find_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_list_popup = bc_list_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_sort_popup = bc_sort_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_annotation_popup = bc_annotation_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_ns_popup = bc_ns_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_clip_buffer_popup = bc_clip_buffer_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_abbrev_popup = bc_abbrev_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_expand_popup = bc_expand_popup_objects_initialize(NULL, Bc_base_window->base_window);
	Bc_properties_popup = bc_properties_popup_objects_initialize(NULL, Bc_base_window->base_window);

	/*
	 * Initialize the Drag Drop package.
	 */
	gdd_init_dragdrop(Bc_base_window->base_window);

	notify_interpose_destroy_func(Bc_base_window->base_window, destroy_func);

	init_bc(argc, argv);

	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Bc_base_window->base_window);
	exit(0);
}

#endif


/*
 * Menu handler for `save_selection_as (with abbrev ...)'.
 */
Menu_item
bc_save_selection_as_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	Xv_opaque       ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, file_menu_save_selection_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_save_selection_as_item0_callback:
		 * MENU_NOTIFY\n", stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			selection_print_flag = TRUE;
			selection_save_abbrev_flag = TRUE;
			get_path(pathname);
			gfm_activate (Gfm_Save_Selection_with_abbrev, pathname, gfm_filter, NULL, save_as_file_chooser, NULL, GFM_SAVE);
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `save_selection_as (no abbrev ...)'.
 */
Menu_item
bc_save_selection_as_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	Xv_opaque       ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, file_menu_save_selection_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_save_selection_as_item1_callback:
		 * MENU_NOTIFY\n", stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			selection_print_flag = TRUE;
			selection_save_abbrev_flag = FALSE;
			get_path(pathname);
			gfm_activate (Gfm_Save_Selection_no_abbrev, pathname, gfm_filter, NULL, save_as_file_chooser, NULL, GFM_SAVE);
			
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}



/*
 * Menu handler for `file_menu'.
 */
Menu
bc_file_menu_menu_callback(menu, op)
	Menu            menu;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(menu, XV_KEY_DATA, INSTANCE);
	int             s_flag, i;

	switch (op) {
	case MENU_DISPLAY:
		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);

		if ((int) xv_get(menu, MENU_NITEMS) < 2) {
			for (i = 2; i < FILE_MENU_ITEMS; i++)
				xv_set(menu, MENU_APPEND_ITEM, file_menu[i], NULL);
		}
		if (strlen((char *) xv_get(Bc_base_window->base_window_citekey, PANEL_VALUE)) > 0)
			if (update_item() == ERROR) {
				for (i = (int) xv_get(menu, MENU_NITEMS); i > 1; i--) {
					file_menu[i] = (Menu_item) xv_get(menu, MENU_NTH_ITEM, i);
					xv_set(menu, MENU_REMOVE, i, NULL);
				}
			}
		if (mod_flag)
			if (strcmp(filename + strlen(pathname) + 1, NEW_BIB_NAME) != 0)
				xv_set(menu, MENU_DEFAULT, SAVE, 0);
			else
				xv_set(menu, MENU_DEFAULT, SAVE_AS, 0);
		else
			xv_set(menu, MENU_DEFAULT, LOAD_REPLACE, 0);


		if ((mod_flag) && (strstr(filename, NEW_BIB_NAME) == NULL)) {
			file_menu_save_inactive = FALSE;
			file_menu_revert_inactive = FALSE;
		} else {
			file_menu_save_inactive = TRUE;
			file_menu_revert_inactive = TRUE;
		}

		if ((!mod_flag) && (strstr(filename, NEW_BIB_NAME) != NULL)) {
			file_menu_save_as_inactive = TRUE;
		} else {
			file_menu_save_as_inactive = FALSE;
		}

		if ((update_flag == UPDATE_OFF)
		    && (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == TRUE)) {
			file_menu_save_selection_inactive = FALSE;
		} else {
			if (((mod_flag) && (strstr(filename, NEW_BIB_NAME) != NULL)) || (strstr(filename, NEW_BIB_NAME) == NULL)) {
				get_total();
				if (total > max_total_for_list) {
					file_menu_save_selection_inactive = TRUE;
				} else {
					s_flag = FALSE;
					for (i = 0; i < total; i++) {
						if ((int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_SELECTED, i)) {
							s_flag = TRUE;
							break;
						}
					}
					file_menu_save_selection_inactive = !s_flag;
				}

			} else {
				file_menu_save_selection_inactive = TRUE;
			}
		}

		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
		break;


	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_menu_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return menu;
}




/*
 * Menu handler for `file_menu (New Bib)'.
 */
Menu_item
bc_file_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item0_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (confirm_overwrite() == OK)
				new_bib();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Load Replace ...)'.
 */
Menu_item
bc_file_menu_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item1_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (confirm_overwrite() == OK)
			{
			merge_flag = FALSE;
			get_path(pathname);
			gfm_activate (Gfm_Replace, pathname, gfm_filter, NULL, load_file_chooser, NULL, GFM_LOAD);
			}
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Load Merge ...)'.
 */
Menu_item
bc_file_menu_item2_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item2_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (confirm_overwrite() == OK)
			{
			merge_flag = TRUE;
			get_path(pathname);
			gfm_activate (Gfm_Merge, pathname, gfm_filter, NULL, load_file_chooser, NULL, GFM_LOAD);
			}
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Save)'.
 */
Menu_item
bc_file_menu_item3_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, file_menu_save_inactive, NULL);
		break;


	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item3_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK) 
			writeFile(filename);
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Save As ...)'.
 */
Menu_item
bc_file_menu_item4_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, file_menu_save_as_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item4_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			selection_print_flag = FALSE;
			get_path(pathname);
			gfm_activate (Gfm_Save_as, pathname, gfm_filter, NULL, save_as_file_chooser, NULL, GFM_SAVE);
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Revert)'.
 */
Menu_item
bc_file_menu_item6_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, file_menu_revert_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item6_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			int             result;
			
			result = notice_prompt(Bc_base_window->base_window_controls, NULL,
					       NOTICE_MESSAGE_STRINGS, "Revert will discard changes. What do you want to do?", NULL,
					       NOTICE_BUTTON_YES, "Revert to old file anyway",
					       NOTICE_BUTTON_NO, "Cancel revert", NULL);
			if (result == NOTICE_YES) {
				merge_flag = FALSE;
				loadFile(filename);
			}
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Quit)'.
 */
Menu_item
bc_file_menu_item7_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item7_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (confirm_overwrite() == OK)
			{
			if (xv_destroy_safe(Bc_base_window->base_window) == XV_OK)
				exit(OK);
			}
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Add new bib item)'.
 */
Menu_item
bc_edit_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item0_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				add_item();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Dublicate this item)'.
 */
Menu_item
bc_edit_menu_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item1_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				duplicate_item();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Delete this item)'.
 */
Menu_item
bc_edit_menu_item2_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item2_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			delete_item();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Copy this item to buffer)'.
 */
Menu_item
bc_edit_menu_item3_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item3_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				copy();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Add this item to buffer)'.
 */
Menu_item
bc_edit_menu_item4_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item4_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				add_to_buffer();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Next)'.
 */
Menu_item
bc_view_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item0_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				next_item();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Previous)'.
 */
Menu_item
bc_view_menu_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item1_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				prev_item();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (List ...)'.
 */
Menu_item
bc_view_menu_item2_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, view_menu_list_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item2_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			Rect            winr, popr, *screenr;
			screenr = (Rect *) xv_get(Bc_base_window->base_window, WIN_SCREEN_RECT);
			frame_get_rect(Bc_list_popup->list_popup, &popr);
			frame_get_rect(Bc_base_window->base_window, &winr);
			popr.r_top = winr.r_top;
			popr.r_left = winr.r_left + winr.r_width;
			if (popr.r_left + popr.r_width > screenr->r_width)
				popr.r_left = winr.r_left - popr.r_width;
			if (popr.r_top + popr.r_height > screenr->r_height)
				popr.r_top = screenr->r_height - popr.r_height;
			frame_set_rect(Bc_list_popup->list_popup, &popr);
			xv_set(Bc_list_popup->list_popup, XV_SHOW, TRUE, NULL);
			xv_set(Bc_list_popup->list_popup_list, XV_SHOW, TRUE, NULL);
			
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Find ...)'.
 */
Menu_item
bc_view_menu_item3_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item3_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
			{
			xv_set(Bc_find_popup->find_popup, XV_SHOW, TRUE, NULL);
			
			xv_set(Bc_find_popup->find_popup_ref_type, PANEL_VALUE, default_find_ref_type, NULL);
			xv_set(Bc_find_popup->find_popup_find_field_setting1, PANEL_VALUE, default_find_field1, NULL);
			xv_set(Bc_find_popup->find_popup_find_field_setting2, PANEL_VALUE, default_find_field2, NULL);
			xv_set(Bc_find_popup->find_popup_find_field_setting3, PANEL_VALUE, default_find_field3, NULL);
			xv_set(Bc_find_popup->find_popup_find_field_setting4, PANEL_VALUE, default_find_field4, NULL);
			xv_set(Bc_find_popup->find_popup_find_field_setting5, PANEL_VALUE, default_find_field5, NULL);
			
			xv_set(Bc_find_popup->find_popup_find_textfield1, PANEL_VALUE, "", NULL);
			xv_set(Bc_find_popup->find_popup_find_textfield2, PANEL_VALUE, "", NULL);
			xv_set(Bc_find_popup->find_popup_find_textfield3, PANEL_VALUE, "", NULL);
			xv_set(Bc_find_popup->find_popup_find_textfield4, PANEL_VALUE, "", NULL);
			xv_set(Bc_find_popup->find_popup_find_textfield5, PANEL_VALUE, "", NULL);
			
			xv_set(Bc_find_popup->find_popup_from_year, PANEL_VALUE, "", NULL);
			xv_set(Bc_find_popup->find_popup_to_year, PANEL_VALUE, "", NULL);
			
			xv_set(Bc_find_popup->find_popup_connect, PANEL_VALUE, default_find_connect, NULL);
			xv_set(Bc_find_popup->find_popup_findmethod, PANEL_VALUE, default_find_findmethod, NULL);
			xv_set(Bc_find_popup->find_popup_ignore_case, PANEL_VALUE, default_find_ignore_case, NULL);
			xv_set(Bc_find_popup->find_popup_fuzzy_distance, PANEL_VALUE, default_find_fuzzy_distance, NULL);
			xv_set(Bc_find_popup->find_popup_select_in_list, PANEL_VALUE, default_find_select_in_list, NULL);
			
			xv_set(Bc_find_popup->find_popup_controls, PANEL_CARET_ITEM, Bc_find_popup->find_popup_find_textfield1, NULL);
			}
			
		}
		
		xv_set(Bc_find_popup->find_popup, FRAME_RIGHT_FOOTER, " ", NULL);
		
		xv_set(Bc_find_popup->find_popup, FRAME_LEFT_FOOTER, " ", NULL);
		
		xv_set(Bc_find_popup->find_popup_fuzzy_distance, XV_SHOW, FALSE, NULL);
		
		xv_set(Bc_find_popup->find_popup_gauge, XV_SHOW, FALSE, NULL);
		
		xv_set(Bc_find_popup->find_popup_previous_button, XV_SHOW, FALSE, NULL);
		
		xv_set(Bc_find_popup->find_popup_next_button, XV_SHOW, FALSE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Sort ...)'.
 */
Menu_item
bc_view_menu_item4_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item4_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
			{
			xv_set(Bc_sort_popup->sort_popup, XV_SHOW, TRUE, NULL);
			xv_set(Bc_sort_popup->sort_popup_gauge, XV_SHOW, FALSE, NULL);
			}
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Annotation ...)'.
 */
Menu_item
bc_view_menu_item5_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item5_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			Rect            winr, popr, *screenr;
			screenr = (Rect *) xv_get(Bc_base_window->base_window, WIN_SCREEN_RECT);
			frame_get_rect(Bc_annotation_popup->annotation_popup, &popr);
			frame_get_rect(Bc_base_window->base_window, &winr);
			popr.r_top = winr.r_top + winr.r_height;
			popr.r_left = winr.r_left;
			/*
			if (popr.r_top + popr.r_height > screenr->r_height)
				popr.r_top = winr.r_top - popr.r_height;
			*/
			frame_set_rect(Bc_annotation_popup->annotation_popup, &popr);
			xv_set(Bc_annotation_popup->annotation_popup, XV_SHOW, TRUE, NULL);
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Abbreviations ...)'.
 */
Menu_item
bc_view_menu_item6_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item6_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			Rect            winr, popr, *screenr;
			screenr = (Rect *) xv_get(Bc_base_window->base_window, WIN_SCREEN_RECT);
			frame_get_rect(Bc_abbrev_popup->abbrev_popup, &popr);
			frame_get_rect(Bc_base_window->base_window, &winr);
			popr.r_top = winr.r_top + POPUP_DIST;
			popr.r_left = winr.r_left + POPUP_DIST;
			frame_set_rect(Bc_abbrev_popup->abbrev_popup, &popr);
			xv_set(Bc_abbrev_popup->abbrev_popup, XV_SHOW, TRUE, NULL);
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Other Fields ...)'.
 */
Menu_item
bc_view_menu_item7_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item7_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			Rect            winr, popr, *screenr;
			screenr = (Rect *) xv_get(Bc_base_window->base_window, WIN_SCREEN_RECT);
			frame_get_rect(Bc_ns_popup->ns_popup, &popr);
			frame_get_rect(Bc_base_window->base_window, &winr);
			popr.r_top = winr.r_top + POPUP_DIST;
			popr.r_left = screenr->r_width - popr.r_width;
			frame_set_rect(Bc_ns_popup->ns_popup, &popr);
			xv_set(Bc_ns_popup->ns_popup, XV_SHOW, TRUE, NULL);
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `view_menu (Clip Buffer ...)'.
 */
Menu_item
bc_view_menu_item8_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_item8_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			struct itimerval timer;
			extern          Notify_func update_clip();
			load_clip();
			xv_set(Bc_clip_buffer_popup->clip_buffer_popup, XV_SHOW, TRUE, NULL);
			timer.it_value.tv_usec = CLIP_UPDATE_TIME;
			timer.it_interval.tv_usec = CLIP_UPDATE_TIME;
			notify_set_itimer_func(Bc_base_window->base_window, update_clip, ITIMER_REAL, &timer, NULL);
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (NONE)'.
 */
Menu_item
bc_month_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item0_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, " ", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (jan)'.
 */
Menu_item
bc_month_menu_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item1_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#jan", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (feb)'.
 */
Menu_item
bc_month_menu_item2_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item2_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#feb", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (mar)'.
 */
Menu_item
bc_month_menu_item3_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item3_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#mar", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (apr)'.
 */
Menu_item
bc_month_menu_item4_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item4_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#apr", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (may)'.
 */
Menu_item
bc_month_menu_item5_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item5_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#may", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (jun)'.
 */
Menu_item
bc_month_menu_item6_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item6_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#jun", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (jul)'.
 */
Menu_item
bc_month_menu_item7_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item7_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#jul", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (aug)'.
 */
Menu_item
bc_month_menu_item8_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item8_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#aug", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (sep)'.
 */
Menu_item
bc_month_menu_item9_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item9_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#sep", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (oct)'.
 */
Menu_item
bc_month_menu_item10_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item10_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#oct", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (nov)'.
 */
Menu_item
bc_month_menu_item11_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item11_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#nov", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `month_menu (dec)'.
 */
Menu_item
bc_month_menu_item12_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_month_menu_item12_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_month, PANEL_VALUE, "#dec", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `list_popup_menu (Next)'.
 */
Menu_item
bc_list_popup_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_popup_menu_item0_callback:
		 * MENU_NOTIFY\n", stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			show_next_in_list();
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `list_popup_menu (Previous)'.
 */
Menu_item
bc_list_popup_menu_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_popup_menu_item1_callback:
		 * MENU_NOTIFY\n", stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			show_previous_in_list();
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `list_popup_menu (Clear All Selections)'.
 */
Menu_item
bc_list_popup_menu_item2_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, list_menu_clear_select_all_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_popup_menu_item2_callback:
		 * MENU_NOTIFY\n", stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			clear_all_selections();
			do_title();
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Event callback function for `base_window_controls'.
 */
Notify_value
bc_base_window_base_window_controls_event_callback(win, event, arg, type)
	Xv_window       win;
	Event          *event;
	Notify_arg      arg;
	Notify_event_type type;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_controls_event_callback: event %d\n",
	 * event_id(event));
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (doubleclick(event))
	{
		expand(event);
		
		
	}
	
	/* gxv_end_connections */

	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * Background event callback function for `base_window_controls'. This is a
 * function generated by guide to handle popup menu main_menu for control
 * area base_window_controls.
 */
void
bc_base_window_base_window_controls_background_handler(panel, event)
	Xv_opaque       panel;
	Event          *event;
{
	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_controls_background_handler: event
	 * %d\n", event_id(event));
	 */
	if (event_action(event) == ACTION_MENU && event_is_down(event)) {
		Menu            menu = (Menu) xv_get(panel, WIN_MENU);

		if (menu)
			menu_show(menu, panel, event, 0);
	}
}

/*
 * Drop callback function for `base_window_drop_target'.
 */
void
bc_base_window_drop_target_dropped_upon_handler(item, event, drop_info)
	Xv_opaque       item;
	Event          *event;
	GDD_DROP_INFO  *drop_info;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc: bc_base_window_drop_target_dropped_upon_handler\n",
	 * stderr); fputs("Successful Drop. GDD_DROP_INFO contents:\n",
	 * stderr);
	 */
	gdd_print_drop_info(drop_info);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	if ((first_item->field[citekey_id] == NULL) || (update_item() == OK)) {
		char            old_filename[BUFSIZ];
		char            old_pathname[BUFSIZ];
		char           *tmp;
		int             result;

		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);

		strcpy(old_filename, filename);
		strcpy(old_pathname, pathname);

		/* set filename */
		if ((drop_info->filename)) {
			strcpy(filename, drop_info->filename);
		} else if ((drop_info->tmpfile)) {
			strcpy(filename, drop_info->tmpfile);
		} else {
			fprintf(PRINT_TO, "bibcard: Sorry, no filename found\n");
			return;
		}


		/* set pathname */
		strcpy(pathname, filename);
		tmp = (char *) strrchr(pathname, '/');
		if (tmp == NULL)
			sprintf(pathname, "");
		else
			sprintf(tmp, "");

		/* make choice */
		if (first_item->field[citekey_id] != NULL) {
			result = notice_prompt(Bc_base_window->base_window_controls, NULL,
					       NOTICE_MESSAGE_STRINGS,
				   "Do you want to replace or merge?", NULL,
					       NOTICE_BUTTON, "Replace", 111,
					       NOTICE_BUTTON, "Merge", 112,
					       NOTICE_BUTTON, "Cancel", 113,
					       NULL);
			if (result == 111) {
				merge_flag = FALSE;
				loadFile(filename);
			} else if (result == 112) {
				merge_flag = TRUE;
				loadFile(filename);
				mod_flag = TRUE;
				mod_for_find_flag = TRUE;
				strcpy(filename, old_filename);
				strcpy(pathname, old_pathname);
				do_title();
			} else {
				strcpy(filename, old_filename);
				strcpy(pathname, old_pathname);
			}
		} else {
			merge_flag = FALSE;
			loadFile(filename);
		}

		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);

	}
}

/*
 * Notify callback function for `base_window_citekey'.
 */
Panel_setting
bc_base_window_base_window_citekey_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_citekey_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_ref_type'.
 */
void
bc_base_window_base_window_ref_type_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_ref_type_notify_callback: value: %u\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		/*
		 * for all values keep hide_all(); show_ref_type();
		 */
		
	}
	
	/* gxv_end_connections */

	hide_all();
	show_ref_type(value);


}

/*
 * Notify callback function for `base_window_key'.
 */
Panel_setting
bc_base_window_base_window_key_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_key_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_address'.
 */
Panel_setting
bc_base_window_base_window_address_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_address_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_author'.
 */
Panel_setting
bc_base_window_base_window_author_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_author_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_booktitle'.
 */
Panel_setting
bc_base_window_base_window_booktitle_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_booktitle_notify_callback: value:
	 * %s\n", value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_chapter'.
 */
Panel_setting
bc_base_window_base_window_chapter_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_chapter_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_crossref'.
 */
Panel_setting
bc_base_window_base_window_crossref_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_crossref_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_edition'.
 */
Panel_setting
bc_base_window_base_window_edition_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_edition_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_editor'.
 */
Panel_setting
bc_base_window_base_window_editor_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_editor_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_howpublished'.
 */
Panel_setting
bc_base_window_base_window_howpublished_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_howpublished_notify_callback: value:
	 * %s\n", value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_institution'.
 */
Panel_setting
bc_base_window_base_window_institution_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_institution_notify_callback: value:
	 * %s\n", value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		}
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_journal'.
 */
Panel_setting
bc_base_window_base_window_journal_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_journal_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_note'.
 */
Panel_setting
bc_base_window_base_window_note_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_note_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_number'.
 */
Panel_setting
bc_base_window_base_window_number_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_number_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_organization'.
 */
Panel_setting
bc_base_window_base_window_organization_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_organization_notify_callback: value:
	 * %s\n", value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_pages'.
 */
Panel_setting
bc_base_window_base_window_pages_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_pages_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_publisher'.
 */
Panel_setting
bc_base_window_base_window_publisher_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_publisher_notify_callback: value:
	 * %s\n", value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_school'.
 */
Panel_setting
bc_base_window_base_window_school_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_school_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_series'.
 */
Panel_setting
bc_base_window_base_window_series_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_series_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_title'.
 */
Panel_setting
bc_base_window_base_window_title_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_title_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_volume'.
 */
Panel_setting
bc_base_window_base_window_volume_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_volume_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_year'.
 */
Panel_setting
bc_base_window_base_window_year_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_year_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_location'.
 */
Panel_setting
bc_base_window_base_window_location_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_location_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_month'.
 */
Panel_setting
bc_base_window_base_window_month_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_month_notify_callback: value: %s\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}


/*
 * Notify callback function for `find_popup_button'.
 */
void
bc_find_popup_find_popup_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_find_popup_objects *ip = (bc_find_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc: bc_find_popup_find_popup_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (update_item() == OK) find();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `find_popup_cancel_button'.
 */
void
bc_find_popup_find_popup_cancel_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_find_popup_objects *ip = (bc_find_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_find_popup_find_popup_cancel_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		xv_set(Bc_find_popup->find_popup, FRAME_CMD_PUSHPIN_IN, FALSE, XV_SHOW, FALSE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `find_popup_previous_button'.
 */
void
bc_find_popup_find_popup_previous_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_find_popup_objects *ip = (bc_find_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_find_popup_find_popup_previous_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		show_previous_in_list();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `find_popup_next_button'.
 */
void
bc_find_popup_find_popup_next_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_find_popup_objects *ip = (bc_find_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_find_popup_find_popup_next_button_notify_callback\n", stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		show_next_in_list();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `list_popup_updating'.
 */
void
bc_list_popup_list_popup_updating_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_list_popup_list_popup_updating_notify_callback: value: %u\n",
	 * value);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 1)
	{
		update_flag = UPDATE_OFF;
		do_title();
		
		
	}
	
	if (value == 0)
	{
		if (update_item() == OK) {
			update_flag = UPDATE_ON;
			update_cite_list();
			do_title();
		} else {
			xv_set(Bc_list_popup->list_popup_updating, PANEL_VALUE, UPDATE_OFF, NULL);
		}
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `list_popup_previous_button'.
 */
void
bc_list_popup_list_popup_previous_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_list_popup_list_popup_previous_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		show_previous_in_list();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `list_popup_next_button'.
 */
void
bc_list_popup_list_popup_next_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_list_popup_list_popup_next_button_notify_callback\n", stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		show_next_in_list();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `list_popup_list'.
 */
int
bc_list_popup_list_popup_list_notify_callback(item, string, client_data, op, event, row)
	Panel_item      item;
	char           *string;
	Xv_opaque       client_data;
	Panel_list_op   op;
	Event          *event;
	int             row;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case PANEL_LIST_OP_DESELECT:
		/*
		 * fprintf(stderr, "bc:
		 * bc_list_popup_list_popup_list_notify_callback:
		 * PANEL_LIST_OP_DESELECT: %s\n",string);
		 */ break;

	case PANEL_LIST_OP_SELECT:
		/*
		 * fprintf(stderr, "bc:
		 * bc_list_popup_list_popup_list_notify_callback:
		 * PANEL_LIST_OP_SELECT: %s\n",string);
		 */ break;

	case PANEL_LIST_OP_VALIDATE:
		/*
		 * fprintf(stderr, "bc:
		 * bc_list_popup_list_popup_list_notify_callback:
		 * PANEL_LIST_OP_VALIDATE: %s\n",string);
		 */ break;

	case PANEL_LIST_OP_DELETE:
		/*
		 * fprintf(stderr, "bc:
		 * bc_list_popup_list_popup_list_notify_callback:
		 * PANEL_LIST_OP_DELETE: %s\n",string);
		 */ break;
	}

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (update_item() == OK)
			show_cite(string);
		
	}
	
	/* gxv_end_connections */

	return XV_OK;
}

/*
 * Notify callback function for `sort_popup_sort_button'.
 */
void
bc_sort_popup_sort_popup_sort_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_sort_popup_objects *ip = (bc_sort_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_sort_popup_sort_popup_sort_button_notify_callback\n", stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		sort();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `sort_popup_cancel_button'.
 */
void
bc_sort_popup_sort_popup_cancel_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_sort_popup_objects *ip = (bc_sort_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_sort_popup_sort_popup_cancel_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		xv_set(Bc_sort_popup->sort_popup, FRAME_CMD_PUSHPIN_IN, FALSE, XV_SHOW, FALSE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `clip_buffer_clear_button'.
 */
void
bc_clip_buffer_popup_clip_buffer_clear_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_clip_buffer_popup_objects *ip = (bc_clip_buffer_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_clip_buffer_popup_clip_buffer_clear_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
			int             result;
		
			unlink (clipfile_name);
			textsw_delete(Bc_clip_buffer_popup->clip_buffer_popup_textplane, NULL, TEXTSW_INFINITY);
			textsw_reset(Bc_clip_buffer_popup->clip_buffer_popup_textplane, NULL, NULL);
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `clip_buffer_save_button'.
 */
void
bc_clip_buffer_popup_clip_buffer_save_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_clip_buffer_popup_objects *ip = (bc_clip_buffer_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_clip_buffer_popup_clip_buffer_save_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
			int             locx = 0;
			int             locy = 0;
		
			if ((int) xv_get(Bc_clip_buffer_popup->clip_buffer_popup_textplane, TEXTSW_LENGTH, NULL) > 1) {
				if (textsw_store_file(Bc_clip_buffer_popup->clip_buffer_popup_textplane, clipfile_name, locx, locy)
				    != NULL) {
					notice_prompt(Bc_clip_buffer_popup->clip_buffer_popup_controls, NULL,
						      NOTICE_MESSAGE_STRINGS,
						      "Error saving clipfile", NULL,
						      NOTICE_BUTTON_YES, "Continue",
						      NULL);
				}
		}
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `clip_buffer_undo_button'.
 */
void
bc_clip_buffer_popup_clip_buffer_undo_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_clip_buffer_popup_objects *ip = (bc_clip_buffer_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_clip_buffer_popup_clip_buffer_undo_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if ((infile = fopen(clipfile_name,"r")) == NULL)
		{
		textsw_delete(Bc_clip_buffer_popup->clip_buffer_popup_textplane, NULL, TEXTSW_INFINITY);
		textsw_reset(Bc_clip_buffer_popup->clip_buffer_popup_textplane, NULL, NULL);
		} else {
			load_clip();
		}
		fclose(infile);
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `expand_popup_enter_button'.
 */
void
bc_expand_popup_expand_popup_enter_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_expand_popup_objects *ip = (bc_expand_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_expand_popup_expand_popup_enter_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		enter_expanded_text();
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `expand_popup_cancel_button'.
 */
void
bc_expand_popup_expand_popup_cancel_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_expand_popup_objects *ip = (bc_expand_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_expand_popup_expand_popup_cancel_button_notify_callback\n",
	 * stderr);
	 */
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		xv_set(Bc_expand_popup->expand_popup, FRAME_CMD_PUSHPIN_IN, FALSE, XV_SHOW, FALSE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Event callback function for `expand_popup_textplane'.
 */
Notify_value
bc_expand_popup_expand_popup_textplane_event_callback(win, event, arg, type)
	Xv_window       win;
	Event          *event;
	Notify_arg      arg;
	Notify_event_type type;
{
	bc_expand_popup_objects *ip = (bc_expand_popup_objects *) xv_get(xv_get(win, XV_OWNER), XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_expand_popup_expand_popup_textplane_event_callback: event
	 * %d\n", event_id(event)); /*
	 * 
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		
		if (event_is_ascii(event))
			enter_expanded_text();
		if (event_action(event) == ACTION_CUT ||
		    event_action(event) == ACTION_PASTE)
			enter_expanded_text();
		
	}
	
	/* gxv_end_connections */

	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * Menu handler for `edit_menu (Undo changes)'.
 */
Menu_item
bc_edit_menu_item7_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item7_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			show_current_item();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Add Selection to buffer)'.
 */
Menu_item
bc_edit_menu_item5_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, edit_menu_add_selection_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item5_callback: MENU_NOTIFY\n",
		 * stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (update_item() == OK)
				add_selection_to_buffer();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu (Paste from buffer)'.
 */
Menu_item
bc_edit_menu_item6_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, edit_menu_paste_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_item6_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			if (first_item == last_item)
				paste();
			else if (update_item() == OK)
				paste();
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `file_menu (Save Selection As ...)'.
 */
Menu_item
bc_file_menu_item5_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, file_menu_save_selection_inactive, NULL);
		break;


	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_file_menu_item5_callback: MENU_NOTIFY\n",
		 * stderr);
		 */
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `find_popup_findmethod'.
 */
void
bc_find_popup_find_popup_findmethod_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_find_popup_objects *ip = (bc_find_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_find_popup_find_popup_findmethod_notify_callback: value: %u\n",
	 * value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		xv_set(Bc_find_popup->find_popup, FRAME_RIGHT_FOOTER, "No Regular Expression", NULL);
	}
	
	if (value == 1)
	{
		xv_set(Bc_find_popup->find_popup, FRAME_RIGHT_FOOTER, "When using reg. expr., max dist. is 4. See man agrep for syntax.", NULL);
	}
	
	if (value == 0)
	{
		xv_set(Bc_find_popup->find_popup_fuzzy_distance, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(Bc_find_popup->find_popup_fuzzy_distance, XV_SHOW, TRUE, NULL);
	}
	
	/* gxv_end_connections */

}


/*
 * Menu handler for `list_popup_menu (Select All)'.
 */
Menu_item
bc_list_popup_menu_item3_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, list_menu_clear_select_all_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_popup_menu_item3_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			select_all();
			do_title();
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `updating_menu (ON)'.
 */
Menu_item
bc_updating_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	Xv_opaque       ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_updating_menu_item0_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			update_flag = UPDATE_ON;
			update_cite_list();
			do_title();
			xv_set(Bc_list_popup->list_popup_updating, PANEL_VALUE, UPDATE_ON , NULL);
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `updating_menu (OFF)'.
 */
Menu_item
bc_updating_menu_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	Xv_opaque       ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_updating_menu_item1_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			update_flag = UPDATE_OFF;
			do_title();
			xv_set(Bc_list_popup->list_popup_updating, PANEL_VALUE, UPDATE_OFF, NULL);
			
			
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `base_window_type'.
 */
Panel_setting
bc_base_window_base_window_type_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_type_notify_callback: value: %s\n",
	 * value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_signature'.
 */
Panel_setting
bc_base_window_base_window_signature_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_signature_notify_callback: value:
	 * %s\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_crindex'.
 */
Panel_setting
bc_base_window_base_window_crindex_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_crindex_notify_callback: value: %s\n",
	 * value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_date'.
 */
Panel_setting
bc_base_window_base_window_date_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_date_notify_callback: value: %s\n",
	 * value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_keywords'.
 */
Panel_setting
bc_base_window_base_window_keywords_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_keywords_notify_callback: value: %s\n",
	 * value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `base_window_isbn'.
 */
Panel_setting
bc_base_window_base_window_isbn_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char           *value = (char *) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_base_window_base_window_isbn_notify_callback: value: %s\n",
	 * value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		if (event_is_down(event) && (
			   (event_is_key_right(event) && event_id(event) == KEY_RIGHT(8)) ||
			       (event_shift_is_down(event) && event_action(event) == '\t')))
		{
		update_item();
		next_field(item, (-1));
		return (PANEL_NONE);
		} else if (event_is_down(event) && (
			  (event_is_key_right(event) && event_id(event) == KEY_RIGHT(14)) ||
						    (event_action(event) == '\n') ||
						    (event_action(event) == '\r') ||
						    (event_action(event) == '\t')))
		{
		
		update_item();
		next_field(item, 1);
		return (PANEL_NONE);
		
		} 
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Menu handler for `location_menu (NONE)'.
 */
Menu_item
bc_location_menu_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_location_menu_item0_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_base_window->base_window_location, PANEL_VALUE, " ", NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `list_menu_show_list (with Find Selections)'.
 */
Menu_item
bc_list_menu_show_list_item0_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	Xv_opaque       ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, list_menu_show_list_with_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_menu_show_list_item0_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			
			int             i;
			int             nItems = (int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_NROWS);
			
			if (mod_for_find_flag == FALSE) {
				xv_set(Bc_list_popup->list_popup_list, XV_SHOW, FALSE, NULL);
				xv_set(Bc_list_popup->list_popup, FRAME_BUSY, TRUE, NULL);
				xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);
			
				for (i = 0; i < nItems; i++)
					xv_set(Bc_list_popup->list_popup_list, PANEL_LIST_SELECT, i, found_flag[i], NULL);
			
				xv_set(Bc_list_popup->list_popup_list, XV_SHOW, TRUE, NULL);
				xv_set(Bc_list_popup->list_popup, FRAME_BUSY, FALSE, NULL);
				xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
			} else {
				            notice_prompt(Bc_base_window->base_window_controls, NULL,
			                          NOTICE_MESSAGE_STRINGS,
			                          "Changed since last find!",
						NULL,
			                          NOTICE_BUTTON_YES, "Continue",
			                          NULL);
			}
			
			
			
		}
		
		xv_set(Bc_list_popup->list_popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Bc_list_popup->list_popup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `list_menu_show_list (don't touch Selections)'.
 */
Menu_item
bc_list_menu_show_list_item1_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	Xv_opaque       ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, list_menu_show_list_no_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_menu_show_list_item1_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_list_popup->list_popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Bc_list_popup->list_popup, XV_SHOW, TRUE, NULL);
		
		xv_set(Bc_list_popup->list_popup_list, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}


/*
 * Menu handler for `main_menu (Updating)'.
 */
Menu_item
bc_main_menu_item5_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, main_menu_updating_inactive, NULL);
		break;


	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_main_menu_item5_callback: MENU_NOTIFY\n",
		 * stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `main_menu (Show List)'.
 */
Menu_item
bc_main_menu_item6_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(item, MENU_INACTIVE, main_menu_show_list_inactive, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_main_menu_item6_callback: MENU_NOTIFY\n",
		 * stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}





/*
 * Menu handler for `list_popup_menu (Hide List)'.
 */
Menu_item
bc_list_popup_menu_item4_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_popup_menu_item4_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_list_popup->list_popup_list, XV_SHOW, FALSE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `edit_menu'.
 */
Menu
bc_edit_menu_menu_callback(menu, op)
	Menu            menu;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(menu, XV_KEY_DATA, INSTANCE);
	int             s_flag, i;

	switch (op) {
	case MENU_DISPLAY:
		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);

		if (access(clipfile_name, F_OK) == OK)
			edit_menu_paste_inactive = FALSE;
		else
			edit_menu_paste_inactive = TRUE;

		if ((update_flag == UPDATE_OFF) && (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == TRUE)) {
			edit_menu_add_selection_inactive = FALSE;
		} else {
			if (((mod_flag) && (strstr(filename, NEW_BIB_NAME) != NULL)) || (strstr(filename, NEW_BIB_NAME) == NULL)) {
				get_total();
				if (total > max_total_for_list) {
					xv_set(menu, MENU_INACTIVE, TRUE, NULL);
				} else {
					s_flag = FALSE;
					for (i = 0; i < total; i++) {
						if ((int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_SELECTED, i)) {
							s_flag = TRUE;
							break;
						}
					}
					edit_menu_add_selection_inactive = !s_flag;
				}

			} else {
				edit_menu_add_selection_inactive = TRUE;
			}
		}
		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_edit_menu_menu_callback: MENU_NOTIFY\n",
		 * stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return menu;
}




/*
 * Menu handler for `view_menu'.
 */
Menu
bc_view_menu_menu_callback(menu, op)
	Menu            menu;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(menu, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);
		get_total();
		if (total > max_total_for_list) {
			view_menu_list_inactive = TRUE;
		} else {
			view_menu_list_inactive = FALSE;
		}
		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_view_menu_menu_callback: MENU_NOTIFY\n",
		 * stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return menu;
}

/*
 * Menu handler for `main_menu'.
 */
Menu
bc_main_menu_menu_callback(menu, op)
	Menu            menu;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(menu, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);
		get_total();
		if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
			main_menu_show_list_inactive = TRUE;
		} else {
			main_menu_show_list_inactive = FALSE;
		}

		if (total > max_total_for_list) {
			main_menu_updating_inactive = TRUE;
		} else {
			main_menu_updating_inactive = FALSE;
		}
		if ((mod_for_find_flag == TRUE) || xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
			list_menu_show_list_with_inactive = TRUE;
		} else {
			list_menu_show_list_with_inactive = FALSE;
		}

		if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
			list_menu_show_list_no_inactive = TRUE;
		} else {
			list_menu_show_list_no_inactive = FALSE;
		}

		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_main_menu_menu_callback: MENU_NOTIFY\n",
		 * stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return menu;
}

/*
 * Menu handler for `list_popup_menu'.
 */
Menu
bc_list_popup_menu_menu_callback(menu, op)
	Menu            menu;
	Menu_generate   op;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(menu, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);

		if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == FALSE) {
			list_menu_clear_select_all_inactive = TRUE;
		} else {
			list_menu_clear_select_all_inactive = FALSE;
		}

		if ((mod_for_find_flag == TRUE) || xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
			list_menu_show_list_with_inactive = TRUE;
		} else {
			list_menu_show_list_with_inactive = FALSE;
		}

		if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
			list_menu_show_list_no_inactive = TRUE;
		} else {
			list_menu_show_list_no_inactive = FALSE;
		}


		xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/*
		 * fputs("bc: bc_list_popup_menu_menu_callback:
		 * MENU_NOTIFY\n", stderr);
		 */

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
			{}
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return menu;
}

/*
 * Event callback function for `list_popup_show_button'.
 */
void
bc_list_popup_list_popup_show_button_event_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_list_popup_objects *ip = (bc_list_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_list_popup_list_popup_show_button_event_callback: event %d\n",
	 * event_id(event));
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (event_action(event) == ACTION_MENU)
	{
				xv_set(Bc_list_popup->list_popup, FRAME_BUSY, TRUE, NULL);
			        get_total();
				if ((mod_for_find_flag == TRUE) || xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
					list_menu_show_list_with_inactive = TRUE;
				} else {
					list_menu_show_list_with_inactive = FALSE;
				}
		
				if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) || (total > max_total_for_list)) {
					list_menu_show_list_no_inactive = TRUE;
				} else {
					list_menu_show_list_no_inactive = FALSE;
				}
		
				xv_set(Bc_list_popup->list_popup, FRAME_BUSY, FALSE, NULL);
		
	}
	
	/* gxv_end_connections */

	panel_default_handle_event(item, event);
}

/*
 * Notify callback function for `base_window_properties_button'.
 */
void
bc_base_window_base_window_properties_button_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fputs("bc:
	 * bc_base_window_base_window_properties_button_notify_callback\n",
	 * stderr);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Bc_properties_popup->properties_popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Bc_properties_popup->properties_popup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Event callback function for `properties_popup'.
 */
Notify_value
bc_properties_popup_event_callback(win, event, arg, type)
	Xv_window       win;
	Event          *event;
	Notify_arg      arg;
	Notify_event_type type;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(win, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc: bc_properties_popup_event_callback: event
	 * %d\n", event_id(event));
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (event_action(event) == ACTION_SELECT)
	{
		{}
	}
	
	/* gxv_end_connections */

	return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * Notify callback function for `properties_popup_max_total_for_list'.
 */
void
bc_properties_popup_properties_popup_max_total_for_list_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_max_total_for_list_notify_call
	 * back: value: %d\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		char  message[BUFSIZ];
		
		max_total_for_list = xv_get(Bc_properties_popup->properties_popup_max_total_for_list, PANEL_VALUE, NULL);
		sprintf (message, "Max Total: %d", max_total_for_list);
		xv_set(Bc_list_popup->list_popup,  FRAME_LEFT_FOOTER, message, NULL);
		if (update_flag == UPDATE_ON) {
			update_cite_list();	
		}
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_icon_transparent_value'.
 */
void
bc_properties_popup_properties_popup_icon_transparent_value_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	short           i;
	/*
	 * fputs("bc:
	 * bc_properties_popup_properties_popup_icon_transparent_value_notify_
	 * callback\n", stderr);
	 */
	for (i = 0; i < 1; i++) {
		if (value & 01)
			/*
			 * fprintf(stderr, "\t%dth item selected\n", i);
			 */

			/* gxv_start_connections DO NOT EDIT THIS SECTION */
			/* gxv_end_connections */

			value >>= 1;
	}
}

/*
 * Notify callback function for `properties_popup_offset_xv_y'.
 */
Panel_setting
bc_properties_popup_properties_popup_offset_xv_y_notify_callback(item, event)
	Panel_item      item;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	int             value = (int) xv_get(item, PANEL_VALUE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_offset_xv_y_notify_callback:
	 * value: %d\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		set_header();
		show_current_item();
		
		
	}
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `properties_popup_gfm_filter'.
 */
void
bc_properties_popup_properties_popup_gfm_filter_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_gfm_filter_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		        sprintf (gfm_filter,"%s", (char *) xv_get(Bc_properties_popup->properties_popup_gfm_filter, PANEL_CHOICE_STRING, value));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_ref_type'.
 */
void
bc_properties_popup_properties_popup_ref_type_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_ref_type_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_ref_type = value;
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_find_field1'.
 */
void
bc_properties_popup_properties_popup_find_field1_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_find_field1_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_field1 = value;
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_find_field2'.
 */
void
bc_properties_popup_properties_popup_find_field2_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_find_field2_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_field2 = value;
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_find_field3'.
 */
void
bc_properties_popup_properties_popup_find_field3_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_find_field3_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_field3 = value;
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_find_field4'.
 */
void
bc_properties_popup_properties_popup_find_field4_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_find_field4_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_field4 = value;
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_find_field5'.
 */
void
bc_properties_popup_properties_popup_find_field5_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_find_field5_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_field5 = value;
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_connect'.
 */
void
bc_properties_popup_properties_popup_connect_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_connect_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_connect = value;
		
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `properties_popup_findmethod'.
 */
void
bc_properties_popup_properties_popup_findmethod_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_findmethod_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		default_find_findmethod = value;
		
	}
	
	/* gxv_end_connections */

}


/*
 * Notify callback function for `properties_popup_sort_field'.
 */
void
bc_properties_popup_properties_popup_sort_field_notify_callback(item, value, event)
	Panel_item      item;
	int             value;
	Event          *event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	/*
	 * fprintf(stderr, "bc:
	 * bc_properties_popup_properties_popup_sort_field_notify_callback:
	 * value: %u\n", value);
	 */

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
		xv_set(Bc_sort_popup->sort_popup_sort_field_setting, PANEL_VALUE, value, NULL);
		
	}
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `main_menu (Properties ...)'.
 */
Menu_item
bc_main_menu_item7_callback(item, op)
	Menu_item       item;
	Menu_generate   op;
{
	bc_base_window_objects *ip = (bc_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
/*
		fputs("bc: bc_main_menu_item7_callback: MENU_NOTIFY\n", stderr);
*/

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Bc_properties_popup->properties_popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Bc_properties_popup->properties_popup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `properties_popup_ignore_case'.
 */
void
bc_properties_popup_properties_popup_ignore_case_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	short	i;
	
/*
	fputs("bc: bc_properties_popup_properties_popup_ignore_case_notify_callback\n", stderr);
	for (i = 0; i < 1; i++) {
		if (value & 01)
			fprintf(stderr, "\t%dth item selected\n", i);
*/
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		if (i == 0 && (value & 01))
		{
			default_find_ignore_case = value;
			
		}
		
		/* gxv_end_connections */

/*
		value >>= 1;
	}
*/
}

/*
 * Notify callback function for `properties_popup_select_in_list'.
 */
void
bc_properties_popup_properties_popup_select_in_list_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	bc_properties_popup_objects *ip = (bc_properties_popup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	short	i;
	
/*
	fputs("bc: bc_properties_popup_properties_popup_select_in_list_notify_callback\n", stderr);
	for (i = 0; i < 1; i++) {
		if (value & 01)
			fprintf(stderr, "\t%dth item selected\n", i);
		
*/
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		if (i == 0 && (value & 01))
		{
			default_find_select_in_list = value;
			
		}
		
		/* gxv_end_connections */

/*
		value >>= 1;
	}
*/
}
