/*
 * Copyright (c) 1992, Bruno Grossniklaus, grossnik@iam.unibe.ch
 * 
 * I added new features for special use at the IAM and fixed some bugs.
 * 
 */

/*
 * Copyright (c) 1990, William C. Ogden, ogden@nmsu.edu
 * 
 * Permission is granted to copy and distribute this file in modified or
 * unmodified form, for noncommercial use, provided (a) this copyright notice
 * is preserved, (b) no attempt is made to restrict redistribution of this
 * file, and (c) this file is not distributed as part of any collection whose
 * redistribution is restricted by a compilation copyright.
 */




#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>
#include <gfm.h>

#include "bc_macros.h"
#include "bc_globals.h"
#include "bc_show.h"

FILE           *infile;

char            pathname[MAXPATHLEN], filename[MAXPATHLEN], *clipfile_name;

int             paste_flag, merge_flag, update_flag, mod_flag, mod_for_find_flag, selection_print_flag;
int             last_field;
int             selection_save_abbrev_flag;
int             edit_count, ns_edit_count, annote_edit_count;
int             total, max_total_for_list;
int             num_of_fields, citekey_id, key_id, year_id, author_id, editor_id;
int             *found_flag;
int             default_ref_type;
int             default_find_ref_type;
int             default_find_field1, default_find_field2, default_find_field3;
int             default_find_field4, default_find_field5;
int             default_find_connect;
int             default_find_findmethod;
int             default_find_ignore_case;
int             default_find_fuzzy_distance;
int             default_find_select_in_list;
int             offset_xv_y;

Ref             current_item, last_item, first_item;
Ref             ref, prev;

Panel_item      field_ptr[NUM_OF_FIELDS], nxt_fld[NUM_OF_FIELDS], expand_item;

gfm_popup_objects *Gfm_Merge, *Gfm_Replace, *Gfm_Save_as, *Gfm_Save_Selection_with_abbrev,
               *Gfm_Save_Selection_no_abbrev;
char gfm_filter[BUFSIZ];


#ifdef UPPERCASE
struct ref_types_show_fct_struct ref_types_show_fct[NUM_OF_REF_TYPES] = {
	{"ARTICLE", "Article", show_article},
	{"BOOK", "Book", show_book},
	{"BOOKLET", "Booklet", show_booklet},
	{"CONFERENCE", "Conference", show_conference},
	{"INBOOK", "In Book", show_inbook},
	{"INCOLLECTION", "In Collection", show_incollection},
	{"INPROCEEDINGS", "In Proceedings", show_inproceedings},
	{"MANUAL", "Manual", show_manual},
	{"MASTERSTHESIS", "Masters Thesis", show_mastersthesis},
	{"MISC", "Misc", show_misc},
	{"PHDTHESIS", "PhD Thesis", show_phdthesis},
	{"PROCEEDINGS", "Proceedings", show_proceedings},
	{"TECHREPORT", "Tech Report", show_techreport},
	{"UNPUBLISHED", "Unpublished", show_unpublished},
};
#else
struct ref_types_show_fct_struct ref_types_show_fct[NUM_OF_REF_TYPES] = {
	{"article", "Article", show_article},
	{"book", "Book", show_book},
	{"booklet", "Booklet", show_booklet},
	{"conference", "Conference", show_conference},
	{"inbook", "In Book", show_inbook},
	{"incollection", "In Collection", show_incollection},
	{"inproceedings", "In Proceedings", show_inproceedings},
	{"manual", "Manual", show_manual},
	{"mastersthesis", "Masters Thesis", show_mastersthesis},
	{"misc", "Misc", show_misc},
	{"phdthesis", "PhD thesis", show_phdthesis},
	{"proceedings", "Proceedings", show_proceedings},
	{"techreport", "Tech Report", show_techreport},
	{"unpublished", "Unpublished", show_unpublished},
};
#endif

int             book_id = 1;
int             inbook_id = 4;

#ifdef UPPERCASE
char           *text_fields[NUM_OF_FIELDS][2] = {
	{"CITEKEY", "Cite Key:"},
	{"AUTHOR", "Author(s):"},
	{"ADDRESS", "Address:"},
	{"BOOKTITLE", "Booktitle:"},
	{"CHAPTER", "Chapter:"},
	{"EDITION", "Edition:"},
	{"EDITOR", "Editor(s)::"},
	{"HOWPUBLISHED", "How Published:"},
	{"INSTITUTION", "Institution:"},
	{"JOURNAL", "Journal:"},
	{"KEY", "Key:"},
	{"MONTH", "Month:"},
	{"NOTE", "Note:"},
	{"NUMBER", "Number:"},
	{"ORGANIZATION", "Organization:"},
	{"PAGES", "Pages:"},
	{"PUBLISHER", "Publisher:"},
	{"SCHOOL", "School:"},
	{"SERIES", "Series:"},
	{"TITLE", "Title:"},
	{"TYPE", "Type:"},
	{"VOLUME", "Volume:"},
	{"YEAR", "Year:"}
#ifdef CRINDEX_FIELD
	,{"CRINDEX", "Crindex:"}
#endif
#ifdef CROSS_REF_KEY_FIELD
	,{"CROSSREF", "Cross Ref Key:"}
#endif
#ifdef DATE_FIELD
	,{"DATE", "Date:"}
#endif
#ifdef KEYWORDS_FIELD
	,{"KEYWORDS", "Keywords:"}
#endif
#ifdef LOCATION_FIELD
	,{"LOCATION", "Location:"}
#endif
#ifdef SIGNATURE_FIELD
	,{"SIGNATURE", "Signature:"}
#endif
#ifdef ISBN_FIELD
	,{"ISSN_ISBN", "ISSN, ISBN:"}
#endif
};

#endif

#ifndef UPPERCASE
char           *text_fields[NUM_OF_FIELDS][2] = {
	{"citekey", "Cite Key:"},
	{"author", "Author(s):"},
	{"address", "Address:"},
	{"booktitle", "Booktitle:"},
	{"chapter", "Chapter:"},
	{"edition", "Edition:"},
	{"editor", "Editor(s)::"},
	{"howpublished", "How Published:"},
	{"institution", "Institution:"},
	{"journal", "Journal:"},
	{"key", "Key:"},
	{"month", "Month:"},
	{"note", "Note:"},
	{"number", "Number:"},
	{"organization", "Organization:"},
	{"pages", "Pages:"},
	{"publisher", "Publisher:"},
	{"school", "School:"},
	{"series", "Series:"},
	{"title", "Title:"},
	{"type", "Type:"},
	{"volume", "Volume:"},
	{"year", "Year:"}
#ifdef CRINDEX_FIELD
	,{"crindex", "Crindex:"}
#endif
#ifdef CROSS_REF_KEY_FIELD
	,{"crossref", "Cross Ref Key:"}
#endif
#ifdef DATE_FIELD
	,{"date", "Date:"}
#endif
#ifdef KEYWORDS_FIELD
	,{"keywords", "Keywords:"}
#endif
#ifdef LOCATION_FIELD
	,{"location", "Location:"}
#endif
#ifdef SIGNATURE_FIELD
	,{"signature", "Signature:"}
#endif
#ifdef ISBN_FIELD
	,{"issn_isbn", "ISSN, ISBN:"}
#endif
};
#endif
