# WebService::Fastly::Object::LoggingDatadogResponse

## Load the model package
```perl
use WebService::Fastly::Object::LoggingDatadogResponse;
```

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**name** | **string** | The name for the real-time logging configuration. | [optional] 
**placement** | **string** | Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`.  | [optional] 
**response_condition** | **string** | The name of an existing condition in the configured endpoint, or leave blank to always execute. | [optional] 
**format** | **string** | A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats). Must produce valid JSON that Datadog can ingest.  | [optional] [default to &#39;{&quot;ddsource&quot;:&quot;fastly&quot;,&quot;service&quot;:&quot;%{req.service_id}V&quot;,&quot;date&quot;:&quot;%{begin:%Y-%m-%dT%H:%M:%S%Z}t&quot;,&quot;time_start&quot;:&quot;%{begin:%Y-%m-%dT%H:%M:%S%Z}t&quot;,&quot;time_end&quot;:&quot;%{end:%Y-%m-%dT%H:%M:%S%Z}t&quot;,&quot;http&quot;:{&quot;request_time_ms&quot;:&quot;%D&quot;,&quot;method&quot;:&quot;%m&quot;,&quot;url&quot;:&quot;%{json.escape(req.url)}V&quot;,&quot;useragent&quot;:&quot;%{User-Agent}i&quot;,&quot;referer&quot;:&quot;%{Referer}i&quot;,&quot;protocol&quot;:&quot;%H&quot;,&quot;request_x_forwarded_for&quot;:&quot;%{X-Forwarded-For}i&quot;,&quot;status_code&quot;:&quot;%s&quot;},&quot;network&quot;:{&quot;client&quot;:{&quot;ip&quot;:&quot;%h&quot;,&quot;name&quot;:&quot;%{client.as.name}V&quot;,&quot;number&quot;:&quot;%{client.as.number}V&quot;,&quot;connection_speed&quot;:&quot;%{client.geo.conn_speed}V&quot;},&quot;destination&quot;:{&quot;ip&quot;:&quot;%A&quot;},&quot;geoip&quot;:{&quot;geo_city&quot;:&quot;%{client.geo.city.utf8}V&quot;,&quot;geo_country_code&quot;:&quot;%{client.geo.country_code}V&quot;,&quot;geo_continent_code&quot;:&quot;%{client.geo.continent_code}V&quot;,&quot;geo_region&quot;:&quot;%{client.geo.region}V&quot;},&quot;bytes_written&quot;:&quot;%B&quot;,&quot;bytes_read&quot;:&quot;%{req.body_bytes_read}V&quot;},&quot;host&quot;:&quot;%{Fastly-Orig-Host}i&quot;,&quot;origin_host&quot;:&quot;%v&quot;,&quot;is_ipv6&quot;:&quot;%{if(req.is_ipv6, \&quot;true\&quot;, \&quot;false\&quot;)}V&quot;,&quot;is_tls&quot;:&quot;%{if(req.is_ssl, \&quot;true\&quot;, \&quot;false\&quot;)}V&quot;,&quot;tls_client_protocol&quot;:&quot;%{json.escape(tls.client.protocol)}V&quot;,&quot;tls_client_servername&quot;:&quot;%{json.escape(tls.client.servername)}V&quot;,&quot;tls_client_cipher&quot;:&quot;%{json.escape(tls.client.cipher)}V&quot;,&quot;tls_client_cipher_sha&quot;:&quot;%{json.escape(tls.client.ciphers_sha)}V&quot;,&quot;tls_client_tlsexts_sha&quot;:&quot;%{json.escape(tls.client.tlsexts_sha)}V&quot;,&quot;is_h2&quot;:&quot;%{if(fastly_info.is_h2, \&quot;true\&quot;, \&quot;false\&quot;)}V&quot;,&quot;is_h2_push&quot;:&quot;%{if(fastly_info.h2.is_push, \&quot;true\&quot;, \&quot;false\&quot;)}V&quot;,&quot;h2_stream_id&quot;:&quot;%{fastly_info.h2.stream_id}V&quot;,&quot;request_accept_content&quot;:&quot;%{Accept}i&quot;,&quot;request_accept_language&quot;:&quot;%{Accept-Language}i&quot;,&quot;request_accept_encoding&quot;:&quot;%{Accept-Encoding}i&quot;,&quot;request_accept_charset&quot;:&quot;%{Accept-Charset}i&quot;,&quot;request_connection&quot;:&quot;%{Connection}i&quot;,&quot;request_dnt&quot;:&quot;%{DNT}i&quot;,&quot;request_forwarded&quot;:&quot;%{Forwarded}i&quot;,&quot;request_via&quot;:&quot;%{Via}i&quot;,&quot;request_cache_control&quot;:&quot;%{Cache-Control}i&quot;,&quot;request_x_requested_with&quot;:&quot;%{X-Requested-With}i&quot;,&quot;request_x_att_device_id&quot;:&quot;%{X-ATT-Device-Id}i&quot;,&quot;content_type&quot;:&quot;%{Content-Type}o&quot;,&quot;is_cacheable&quot;:&quot;%{if(fastly_info.state~\&quot;^(HIT|MISS)$\&quot;, \&quot;true\&quot;, \&quot;false\&quot;)}V&quot;,&quot;response_age&quot;:&quot;%{Age}o&quot;,&quot;response_cache_control&quot;:&quot;%{Cache-Control}o&quot;,&quot;response_expires&quot;:&quot;%{Expires}o&quot;,&quot;response_last_modified&quot;:&quot;%{Last-Modified}o&quot;,&quot;response_tsv&quot;:&quot;%{TSV}o&quot;,&quot;server_datacenter&quot;:&quot;%{server.datacenter}V&quot;,&quot;req_header_size&quot;:&quot;%{req.header_bytes_read}V&quot;,&quot;resp_header_size&quot;:&quot;%{resp.header_bytes_written}V&quot;,&quot;socket_cwnd&quot;:&quot;%{client.socket.cwnd}V&quot;,&quot;socket_nexthop&quot;:&quot;%{client.socket.nexthop}V&quot;,&quot;socket_tcpi_rcv_mss&quot;:&quot;%{client.socket.tcpi_rcv_mss}V&quot;,&quot;socket_tcpi_snd_mss&quot;:&quot;%{client.socket.tcpi_snd_mss}V&quot;,&quot;socket_tcpi_rtt&quot;:&quot;%{client.socket.tcpi_rtt}V&quot;,&quot;socket_tcpi_rttvar&quot;:&quot;%{client.socket.tcpi_rttvar}V&quot;,&quot;socket_tcpi_rcv_rtt&quot;:&quot;%{client.socket.tcpi_rcv_rtt}V&quot;,&quot;socket_tcpi_rcv_space&quot;:&quot;%{client.socket.tcpi_rcv_space}V&quot;,&quot;socket_tcpi_last_data_sent&quot;:&quot;%{client.socket.tcpi_last_data_sent}V&quot;,&quot;socket_tcpi_total_retrans&quot;:&quot;%{client.socket.tcpi_total_retrans}V&quot;,&quot;socket_tcpi_delta_retrans&quot;:&quot;%{client.socket.tcpi_delta_retrans}V&quot;,&quot;socket_ploss&quot;:&quot;%{client.socket.ploss}V&quot;}&#39;]
**format_version** | **string** | The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`.  | [optional] [default to &#39;2&#39;]
**region** | **string** | The region that log data will be sent to. | [optional] [default to &#39;US&#39;]
**token** | **string** | The API key from your Datadog account. Required. | [optional] 
**created_at** | **DateTime** | Date and time in ISO 8601 format. | [optional] [readonly] 
**deleted_at** | **DateTime** | Date and time in ISO 8601 format. | [optional] [readonly] 
**updated_at** | **DateTime** | Date and time in ISO 8601 format. | [optional] [readonly] 
**service_id** | **string** |  | [optional] [readonly] 
**version** | **string** |  | [optional] [readonly] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


