# Generated by default/object.tt
package Paws::DLM::PolicyDetails;
  use Moose;
  has Actions => (is => 'ro', isa => 'ArrayRef[Paws::DLM::Action]');
  has EventSource => (is => 'ro', isa => 'Paws::DLM::EventSource');
  has Parameters => (is => 'ro', isa => 'Paws::DLM::Parameters');
  has PolicyType => (is => 'ro', isa => 'Str');
  has ResourceLocations => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ResourceTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Schedules => (is => 'ro', isa => 'ArrayRef[Paws::DLM::Schedule]');
  has TargetTags => (is => 'ro', isa => 'ArrayRef[Paws::DLM::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DLM::PolicyDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DLM::PolicyDetails object:

  $service_obj->Method(Att1 => { Actions => $value, ..., TargetTags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DLM::PolicyDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Actions

=head1 DESCRIPTION

Specifies the configuration of a lifecycle policy.

=head1 ATTRIBUTES


=head2 Actions => ArrayRef[L<Paws::DLM::Action>]

The actions to be performed when the event-based policy is triggered.
You can specify only one action per policy.

This parameter is required for event-based policies only. If you are
creating a snapshot or AMI policy, omit this parameter.


=head2 EventSource => L<Paws::DLM::EventSource>

The event that triggers the event-based policy.

This parameter is required for event-based policies only. If you are
creating a snapshot or AMI policy, omit this parameter.


=head2 Parameters => L<Paws::DLM::Parameters>

A set of optional parameters for snapshot and AMI lifecycle policies.

This parameter is required for snapshot and AMI policies only. If you
are creating an event-based policy, omit this parameter.


=head2 PolicyType => Str

The valid target resource types and actions a policy can manage.
Specify C<EBS_SNAPSHOT_MANAGEMENT> to create a lifecycle policy that
manages the lifecycle of Amazon EBS snapshots. Specify
C<IMAGE_MANAGEMENT> to create a lifecycle policy that manages the
lifecycle of EBS-backed AMIs. Specify C<EVENT_BASED_POLICY > to create
an event-based policy that performs specific actions when a defined
event occurs in your AWS account.

The default is C<EBS_SNAPSHOT_MANAGEMENT>.


=head2 ResourceLocations => ArrayRef[Str|Undef]

The location of the resources to backup. If the source resources are
located in an AWS Region, specify C<CLOUD>. If the source resources are
located on an AWS Outpost in your account, specify C<OUTPOST>.

If you specify C<OUTPOST>, Amazon Data Lifecycle Manager backs up all
resources of the specified type with matching target tags across all of
the Outposts in your account.


=head2 ResourceTypes => ArrayRef[Str|Undef]

The target resource type for snapshot and AMI lifecycle policies. Use
C<VOLUME >to create snapshots of individual volumes or use C<INSTANCE>
to create multi-volume snapshots from the volumes for an instance.

This parameter is required for snapshot and AMI policies only. If you
are creating an event-based policy, omit this parameter.


=head2 Schedules => ArrayRef[L<Paws::DLM::Schedule>]

The schedules of policy-defined actions for snapshot and AMI lifecycle
policies. A policy can have up to four schedulesE<mdash>one mandatory
schedule and up to three optional schedules.

This parameter is required for snapshot and AMI policies only. If you
are creating an event-based policy, omit this parameter.


=head2 TargetTags => ArrayRef[L<Paws::DLM::Tag>]

The single tag that identifies targeted resources for this policy.

This parameter is required for snapshot and AMI policies only. If you
are creating an event-based policy, omit this parameter.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DLM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

