/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class DependencyTreeTransformer
implements TreeTransformer {
    private static final Pattern NPTmpPattern = Pattern.compile("NP.*-TMP.*");
    private static final Pattern NPAdvPattern = Pattern.compile("NP.*-ADV.*");
    protected final TreebankLanguagePack tlp = new PennTreebankLanguagePack();
    private static final TregexPattern matchPattern = TregexPattern.safeCompile("-NONE-=none", true);
    private static final TsurgeonPattern operation = Tsurgeon.parseOperation("prune none");

    public Tree transformTree(Tree t) {
        t.setValue(DependencyTreeTransformer.cleanUpRoot(t.value()));
        this.stripTag(t);
        return DependencyTreeTransformer.stripEmptyNode(t);
    }

    protected static String cleanUpRoot(String label) {
        if (label == null || label.equals("TOP")) {
            return "ROOT";
        }
        return label;
    }

    protected String cleanUpLabel(String label) {
        if (label == null) {
            return "";
        }
        boolean nptemp = NPTmpPattern.matcher(label).matches();
        boolean npadv = NPAdvPattern.matcher(label).matches();
        label = this.tlp.basicCategory(label);
        if (nptemp) {
            label = label + "-TMP";
        } else if (npadv) {
            label = label + "-ADV";
        }
        return label;
    }

    protected void stripTag(Tree t) {
        if (!t.isLeaf()) {
            String label = this.cleanUpLabel(t.value());
            t.setValue(label);
            for (Tree child : t.getChildrenAsList()) {
                this.stripTag(child);
            }
        }
    }

    protected static Tree stripEmptyNode(Tree t) {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = Generics.newArrayList();
        ops.add(Generics.newPair(matchPattern, operation));
        return Tsurgeon.processPatternsOnTree(ops, t);
    }
}

