#!/usr/bin/env perl
use strict;
use warnings;
use utf8;
use Encode ();
use HTTP::Tiny;
use FindBin;
use Path::Tiny;
use File::Basename 'basename';
chdir $FindBin::Bin;

my $http = HTTP::Tiny->new;

my %url = map {; "http://unicode.org/Public/emoji/latest/$_" => undef } qw(
    emoji-data.txt
    emoji-zwj-sequences.txt
    emoji-sequences.txt
);

for my $url (sort keys %url) {
    warn "-> get $url\n";
    my $file = basename $url;
    my $res = $http->mirror($url, $file);
    die "$url: $res->{status}\n" unless $res->{success};
    warn "-> unmodified $file\n" if $res->{status} == 304;
    $url{$url} = path($file)->slurp_utf8;
}

warn "-> write ../lib/Acme/RandomEmoji.pm\n";
my $code = path("RandomEmoji.pm")->slurp_utf8;
my $fh = path("../lib/Acme/RandomEmoji.pm")->openw_utf8;

print {$fh} "# THIS FILE IS AUTOMATICALLY GENERATED BY author/generate.pl\n";
print {$fh} $code;
print {$fh} "\n__DATA__\n\n";

for my $url (sort keys %url) {
    my $content = $url{$url};
    print {$fh} <<"...";
# GET FROM $url
$content
...
}

