# Generated by default/object.tt
package Paws::SecurityHub::AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails;
  use Moose;
  has Date => (is => 'ro', isa => 'Str');
  has Days => (is => 'ro', isa => 'Int');
  has StorageClass => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails object:

  $service_obj->Method(Att1 => { Date => $value, ..., StorageClass => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Date

=head1 DESCRIPTION

A rule for when objects transition to specific storage classes.

=head1 ATTRIBUTES


=head2 Date => Str

A date on which to transition objects to the specified storage class.
If you provide C<Date>, you cannot provide C<Days>.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 Days => Int

The number of days after which to transition the object to the
specified storage class. If you provide C<Days>, you cannot provide
C<Date>.


=head2 StorageClass => Str

The storage class to transition the object to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

