#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use lib 'lib';

use Hypersonic::Future;
use Hypersonic::Future::Pool;

# Compile Future (includes Pool)
Hypersonic::Future->compile();

# Test shutdown
{
    Hypersonic::Future::Pool->init;
    ok(Hypersonic::Future::Pool->is_initialized, 'Pool initialized');

    my $result = Hypersonic::Future::Pool->shutdown;
    ok($result, 'Shutdown returns true');
    ok(!Hypersonic::Future::Pool->is_initialized, 'Pool not initialized after shutdown');
}

# Test reinit after shutdown
{
    Hypersonic::Future::Pool->init;
    ok(Hypersonic::Future::Pool->is_initialized, 'Pool reinitialized');

    # Can still submit work
    my $f = Hypersonic::Future->new;
    Hypersonic::Future::Pool->submit($f, sub { return 42 }, []);

    select(undef, undef, undef, 0.1);
    Hypersonic::Future::Pool->process_ready;

    ok($f->is_done, 'Future works after reinit');
    is($f->result, 42, 'Result correct');

    Hypersonic::Future::Pool->shutdown;
}

# Test shutdown when not initialized
{
    ok(!Hypersonic::Future::Pool->is_initialized, 'Pool not initialized');
    my $result = Hypersonic::Future::Pool->shutdown;
    is($result, 0, 'Shutdown returns 0 when not initialized');
}

done_testing;
