<?php

namespace Phois\Whois;

class Whois
{
    private $domain;

    private $TLDs;

    private $subDomain;

    private $servers;

    private $data;

    private $cc_reg = array('AX' => 'RIPE', 'AF' => 'APNIC', 'AL' => 'RIPE', 'DZ' => 'AFRINIC', 'AS' => 'APNIC', 'AD' => 'RIPE', 'AO' => 'AFRINIC', 'AI' => 'ARIN', 'AQ' => 'ARIN', 'AG' => 'ARIN', 'AR' => 'LACNIC', 'AM' => 'RIPE', 'AW' => 'LACNIC', 'AU' => 'APNIC', 'AT' => 'RIPE', 'AZ' => 'RIPE', 'BS' => 'ARIN', 'BH' => 'RIPE', 'BD' => 'APNIC', 'BB' => 'ARIN', 'BY' => 'RIPE', 'BE' => 'RIPE', 'BZ' => 'LACNIC', 'BJ' => 'AFRINIC', 'BM' => 'ARIN', 'BT' => 'APNIC', 'BO' => 'LACNIC', 'BA' => 'RIPE', 'BW' => 'AFRINIC', 'BV' => 'ARIN', 'BR' => 'LACNIC', 'IO' => 'APNIC', 'BN' => 'APNIC', 'BG' => 'RIPE', 'BF' => 'AFRINIC', 'BI' => 'AFRINIC', 'KH' => 'APNIC', 'CM' => 'AFRINIC', 'CA' => 'ARIN', 'CV' => 'AFRINIC', 'KY' => 'ARIN', 'CF' => 'AFRINIC', 'TD' => 'AFRINIC', 'CL' => 'LACNIC', 'CN' => 'APNIC', 'CX' => 'APNIC', 'CC' => 'APNIC', 'CO' => 'LACNIC', 'KM' => 'AFRINIC', 'CG' => 'AFRINIC', 'CD' => 'AFRINIC', 'CK' => 'APNIC', 'CR' => 'LACNIC', 'CI' => 'AFRINIC', 'HR' => 'RIPE', 'CU' => 'LACNIC', 'CY' => 'RIPE', 'CZ' => 'RIPE', 'DK' => 'RIPE', 'DJ' => 'AFRINIC', 'DM' => 'ARIN', 'DO' => 'LACNIC', 'TL' => 'APNIC', 'EC' => 'LACNIC', 'EG' => 'AFRINIC', 'SV' => 'LACNIC', 'GQ' => 'AFRINIC', 'ER' => 'AFRINIC', 'EE' => 'RIPE', 'ET' => 'AFRINIC', 'FK' => 'LACNIC', 'FO' => 'RIPE', 'FJ' => 'APNIC', 'FI' => 'RIPE', 'FR' => 'RIPE', 'GF' => 'LACNIC', 'PF' => 'APNIC', 'TF' => 'APNIC', 'GA' => 'AFRINIC', 'GM' => 'AFRINIC', 'GE' => 'RIPE', 'DE' => 'RIPE', 'GH' => 'AFRINIC', 'GI' => 'RIPE', 'GR' => 'RIPE', 'GL' => 'RIPE', 'GD' => 'ARIN', 'GP' => 'ARIN', 'GU' => 'APNIC', 'GT' => 'LACNIC', 'GN' => 'AFRINIC', 'GW' => 'AFRINIC', 'GY' => 'LACNIC', 'HT' => 'LACNIC', 'HM' => 'ARIN', 'VA' => 'RIPE', 'HN' => 'LACNIC', 'HK' => 'APNIC', 'HU' => 'RIPE', 'IS' => 'RIPE', 'IN' => 'APNIC', 'ID' => 'APNIC', 'IR' => 'RIPE', 'IQ' => 'RIPE', 'IE' => 'RIPE', 'IL' => 'RIPE', 'IT' => 'RIPE', 'JM' => 'ARIN', 'JP' => 'APNIC', 'JO' => 'RIPE', 'KZ' => 'RIPE', 'KE' => 'AFRINIC', 'KI' => 'APNIC', 'KP' => 'APNIC', 'KR' => 'APNIC', 'KW' => 'RIPE', 'KG' => 'RIPE', 'LA' => 'APNIC', 'LV' => 'RIPE', 'LB' => 'RIPE', 'LS' => 'AFRINIC', 'LR' => 'AFRINIC', 'LY' => 'AFRINIC', 'LI' => 'RIPE', 'LT' => 'RIPE', 'LU' => 'RIPE', 'MO' => 'APNIC', 'MK' => 'RIPE', 'MG' => 'AFRINIC', 'MW' => 'AFRINIC', 'MY' => 'APNIC', 'MV' => 'APNIC', 'ML' => 'AFRINIC', 'MT' => 'RIPE', 'MH' => 'APNIC', 'MQ' => 'ARIN', 'MR' => 'AFRINIC', 'MU' => 'AFRINIC', 'YT' => 'AFRINIC', 'MX' => 'LACNIC', 'FM' => 'APNIC', 'MD' => 'RIPE', 'MC' => 'RIPE', 'MN' => 'APNIC', 'MS' => 'ARIN', 'MA' => 'AFRINIC', 'MZ' => 'AFRINIC', 'MM' => 'APNIC', 'NA' => 'AFRINIC', 'NR' => 'APNIC', 'NP' => 'APNIC', 'NL' => 'RIPE', 'AN' => 'LACNIC', 'NC' => 'APNIC', 'NZ' => 'APNIC', 'NI' => 'LACNIC', 'NE' => 'AFRINIC', 'NG' => 'AFRINIC', 'NU' => 'APNIC', 'NF' => 'APNIC', 'MP' => 'APNIC', 'NO' => 'RIPE', 'OM' => 'RIPE', 'PK' => 'APNIC', 'PW' => 'APNIC', 'PS' => 'RIPE', 'PA' => 'LACNIC', 'PG' => 'APNIC', 'PY' => 'LACNIC', 'PE' => 'LACNIC', 'PH' => 'APNIC', 'PN' => 'APNIC', 'PL' => 'RIPE', 'PT' => 'RIPE', 'PR' => 'ARIN', 'QA' => 'RIPE', 'RE' => 'AFRINIC', 'RO' => 'RIPE', 'RU' => 'RIPE', 'RW' => 'AFRINIC', 'KN' => 'ARIN', 'LC' => 'ARIN', 'VC' => 'ARIN', 'WS' => 'APNIC', 'SM' => 'RIPE', 'ST' => 'AFRINIC', 'SA' => 'RIPE', 'SN' => 'AFRINIC', 'CS' => 'RIPE', 'SC' => 'AFRINIC', 'SL' => 'AFRINIC', 'SG' => 'APNIC', 'SK' => 'RIPE', 'SI' => 'RIPE', 'SB' => 'APNIC', 'SO' => 'AFRINIC', 'ZA' => 'AFRINIC', 'GS' => 'LACNIC', 'ES' => 'RIPE', 'LK' => 'APNIC', 'SH' => 'ARIN', 'PM' => 'ARIN', 'SD' => 'AFRINIC', 'SR' => 'LACNIC', 'SJ' => 'RIPE', 'SZ' => 'AFRINIC', 'SE' => 'RIPE', 'CH' => 'RIPE', 'SY' => 'RIPE', 'TW' => 'APNIC', 'TJ' => 'RIPE', 'TZ' => 'AFRINIC', 'TH' => 'APNIC', 'TG' => 'AFRINIC', 'TK' => 'APNIC', 'TO' => 'APNIC', 'TT' => 'LACNIC', 'TN' => 'AFRINIC', 'TR' => 'RIPE', 'TM' => 'RIPE', 'TC' => 'ARIN', 'TV' => 'APNIC', 'UG' => 'AFRINIC', 'UA' => 'RIPE', 'AE' => 'RIPE', 'GB' => 'RIPE', 'US' => 'ARIN', 'UM' => 'ARIN', 'UY' => 'LACNIC', 'UZ' => 'RIPE', 'VU' => 'APNIC', 'VE' => 'LACNIC', 'VN' => 'APNIC', 'VG' => 'ARIN', 'VI' => 'ARIN', 'WF' => 'APNIC', 'EH' => 'AFRINIC', 'YE' => 'RIPE', 'ZM' => 'AFRINIC', 'ZW' => 'AFRINIC');

    /**
     * @param string $domain full domain name (without trailing dot)
     */
    public function __construct($domain)
    {
        $this->domain = $domain;
	$this->data = array('whois'=>'','org'=>'','name'=>'','email'=>'','country'=>'','asn'=>'');
        // check $domain syntax and split full domain name on subdomain and TLDs
        if (
            preg_match('/^([\p{L}\d\-]+)\.((?:[\p{L}\-]+\.?)+)$/ui', $this->domain, $matches)
            || preg_match('/^(xn\-\-[\p{L}\d\-]+)\.(xn\-\-(?:[a-z\d-]+\.?1?)+)$/ui', $this->domain, $matches)
        ) {
            $this->subDomain = $matches[1];
            $this->TLDs = $matches[2];
	    $this->data['country'] =  $this->geoip_country_code_by_name($this->subDomain.'.'.$this->TLDs);
//TR
        } elseif(preg_match('/^.*?([0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})/',$this->domain, $matches)){
		$this->subDomain = $matches[1];
		$this->TLDs = '';
		$this->data['country'] = $this->geoip_country_code_by_name($this->subDomain);
	} else
            throw new \InvalidArgumentException("Invalid $domain syntax");
        // setup whois servers array from json file
        $this->servers = json_decode(file_get_contents( __DIR__.'/whois.servers.json' ), true);
    }

    private function geoip_country_code_by_name($ip) {
                return function_exists('geoip_country_code_by_name') ?  call_user_func('geoip_country_code_by_name', $ip) : file_get_contents('http://127.0.0.1/cgi-bin/geoq.cgi?ip='.$ip);
    }


    public function info()
    {
        if ($this->isValid()) {
//TR
	    $max = 262144;
	    $string = '';
	    $string_utf8 = '';
	    $cc = isset($this->data['country'][0]) ? $this->data['country'] : (time()%5==0?'CC':'EC');
            $whois_server = isset($this->TLDs[0]) ? $this->servers[$this->TLDs][0] : 'whois.'.strtolower($this->cc_reg[$cc]).'.net';

            // If TLDs have been found
            if ($whois_server != '' && $this->isValidWhois($whois_server)) {

		$this->data['whois'] = $whois_server;

                // if whois server serve replay over HTTP protocol instead of WHOIS protocol
                if (preg_match("/^https?:\/\//i", $whois_server)) {

                    // curl session to get whois reposnse
                    $ch = curl_init();

                    curl_setopt($ch, CURLOPT_URL, $whois_server . $this->subDomain . (isset($this->TLDs[0])?'.':'') . $this->TLDs);
                    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

                    $string = curl_exec($ch);

                    if (curl_error($ch)) {
                        return "Connection error!";
                    }

                    $string = strip_tags($string);
                    curl_close($ch);

                } else {

                    // Getting whois information

                    $fp = fsockopen($whois_server, 43);
                    if (!$fp) {
                        return "Connection error!";
                    }
//TR
                    $dom = $this->subDomain . (isset($this->TLDs[0])?'.':'') . $this->TLDs;
                    fputs($fp, "$dom\r\n");

                    // Getting string
		    $i = $max;
                    $string = '';

                    // Checking whois server for .com and .net
                    if ($this->TLDs == 'com' || $this->TLDs == 'net' || !isset($this->TLDs[0])) {
                        while (!feof($fp) && 0<--$i) {
                            $line = trim(fgets($fp, 128));
                            $string .= $line;

                            if (stripos(str_replace(' ','',$line), 'whoisserver:')!==false) {
                                $whois_server = trim(preg_replace('/^.*?whois[ \t]+server[ \t]*\:[ \t]*/i','',$line));
                            }
                        }
                        // Getting whois information
		 	$dom = $this->subDomain . (isset($this->TLDs[0])?'.':'') . $this->TLDs;


			if($this->isValidWhois($whois_server)){
                        	$fp = fsockopen($whois_server, 43);
                        	if (!$fp) {
                            		return "Connection error!";
                       		}
			}
                        fputs($fp, "$dom\r\n");

                        // Getting string
                        $string = '';


			$i = $max;
                        while (!feof($fp) && 0<--$i) {
                            $string .= fgets($fp, 128);
                        }

                        // Checking for other tld's
                    } else {
			$i = $max;
                        while (!feof($fp)  && 0<--$i) {
                            $string .= fgets($fp, 128);
                        }
                    }
                    fclose($fp);
                }

		$m = array();

                $string_encoding = mb_detect_encoding($string, "UTF-8, ISO-8859-1, ISO-8859-15", true);
                $string_utf8 = htmlspecialchars(mb_convert_encoding($string, "UTF-8", $string_encoding), ENT_COMPAT, "UTF-8", true);

		$lines = explode("\n", $string_utf8);



		for($i=-1; count($lines)>++$i;){
          if(!isset($this->data['org'][0])){
                if(stripos($whois_server, 'arin')>0 || stripos($whois_server, 'lacnic')>0){
                    if(preg_match('/(?:(?:Owner)|(?:Organization)|(?:OrgName))[ \t]*\:(.*)$/i', $lines[$i], $m)){
                        $this->data['org'] = trim($m[1]);
                    }
                }elseif(preg_match('/(?:(?:^[ \t]*descr)|(?:Organization))[ \t]*\:(.*)$/i', $lines[$i], $m)){
                    $this->data['org'] = trim($m[1]);
                }
            }elseif(preg_match('/[^a-z]/', $this->data['org']) && stripos($whois_server, 'arin') === false && stripos($whois_server, 'arin') === false && preg_match('/^[ \t]*descr[ \t]*\:(.*)$/i', $lines[$i], $m)) {
                $this->data['org'] = trim($m[1]);
            }else{
                if(stripos($whois_server, 'arin')>0){
                    if(preg_match('/[ \t]*tech[\- \t]*name[ \t]*\:(.*)$/i', $lines[$i], $m)){
                        $this->data['name'] = trim($m[1]);
                    }
                }else{
                    if(preg_match('/^[ \t]*(?:(?:person)|(?:role)|(?:tech[\- \t]*name))[ \t]*\:(.*)$/i', $lines[$i], $m)){
                        $this->data['name'] = trim($m[1]);
                    }
                }
                if(((!isset($this->data['email'][0]) && isset($this->data['name'][0])) || stripos($lines[$i], 'abuse')) && preg_match('/(?:(?:e\-mail)|(?:email)|(?:mailbox))[ \t]*\:(.*?@.*?)$/i', $lines[$i], $m)){
                    $this->data['email'] = strtolower(trim($m[1]));
                }
            }
            if((!isset($this->data['country'][0]) || (isset($this->data['country'][0]) && isset($this->data['country'][2]))) && preg_match('/(?:[Cc][Oo][Uu][Nn][Tt][Rr][Yy])[ \t]*\:(.*?[A-Z][A-Z].*?)$/', $lines[$i], $m)){
                $this->data['country'] = trim($m[1]);
            }
            if((!isset($this->data['asn'][0]) || preg_match('/(?:[^\0]AS[0-9]+)|(?:AS[0-9]+[^0-9])/i',$this->data['asn'])) && preg_match('/^[^\:]+\:(.*?AS[0-9\-]+.*?)$/', $lines[$i], $m)){
                $this->data['asn'] = trim(str_replace('-','',$m[1]));
            }

		}

                array_map(function(&$v){ $v=trim(preg_replace('/[\x00-\x31]/i',' ',$v)); }, $this->data);
                
                return $string_utf8;
            } else {
                return "No whois server for this tld in list!";
            }



        } else {
            return "Domain name isn't valid!";
        }




    }

    public function htmlInfo()
    {
        return nl2br($this->info());
    }

    /**
     * @return string full domain name
     */
    public function getDomain()
    {
        return $this->domain;
    }
//TR
    public function getData()
    {
        return $this->data;
    }

    /**
     * @return string top level domains separated by dot
     */
    public function getTLDs()
    {
        return $this->TLDs;
    }

    /**
     * @return string return subdomain (low level domain)
     */
    public function getSubDomain()
    {
        return $this->subDomain;
    }

    public function isAvailable()
    {
        $whois_string = $this->info();
        $not_found_string = '';
        if (isset($this->servers[$this->TLDs][1])) {
           $not_found_string = $this->servers[$this->TLDs][1];
        }

        $whois_string2 = @preg_replace('/' . $this->domain . '/', '', $whois_string);
        $whois_string = @preg_replace("/\s+/", ' ', $whois_string);

        $array = explode (":", $not_found_string);
        if ($array[0] == "MAXCHARS") {
            if (strlen($whois_string2) <= $array[1]) {
                return true;
            } else {
                return false;
            }
        } else {
            if (preg_match("/" . $not_found_string . "/i", $whois_string)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function isValidWhois($w){
	return (preg_match('/^((?:(?:(?:domain\-registry\-whois)|(?:whois)|(?:whois\-dub)|(?:whois\-aquarelle)|(?:whois\-bzh)|(?:whois\-fe1)|(?:whois\-frogans)|(?:whois\-cl01)|(?:whois\-leclerc)|(?:whois\-ovh)|(?:whois\-paris)|(?:whois\-check)|(?:whois\-alsace))\.[a-z0-9\-]+\.[a-z]+(?:\.[a-z])?)|(?:[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}))(?:\:[0-9]+)?$/', $w) && !preg_match('/(?:^(?:(?:127)|(?:10\.)|(?:172\.16)|(?:169.254)|(?:255)|(?:0)|(?:192)|(?:224))\.)|(?:localhost)|(?:localdomain)/i', $w)) ? true : false;
    }

    public function isValid()
    {
//TR
	if(!isset($this->TLDs[0]) && preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/', $this->subDomain)){
		return true;
        }elseif (
            isset($this->servers[$this->TLDs][0])
            && strlen($this->servers[$this->TLDs][0]) > 6
        ) {
            $tmp_domain = strtolower($this->subDomain);
            if (
                preg_match("/^[a-z0-9\-]{3,}$/", $tmp_domain)
                && !preg_match("/^-|-$/", $tmp_domain) //&& !preg_match("/--/", $tmp_domain)
            ) {
                return true;
            }
        }

        return false;
    }
}
