#!/usr/bin/perl
#
# Make sure we can fetch a record in the middle of the file
# before we've ever looked at any records before it
#
# (tests _fill_offsets_to() )
#

my $file = "tf$$.txt";
my $data = "......rec0blah......rec1blah......rec2blah";

print "1..5\n";

my $N = 1;
BEGIN {
    eval {require Tie::File::FixedRecLen};

    if ($@) {
      print "1..0 # skipped... cannot use Tie::File::FixedRecLen with your version of Tie::File
";
      exit;
    }
}

print "ok $N\n"; $N++;

open F, "> $file" or die $!;
binmode F;
print F $data;
close F;


my $o = tie @a, 'Tie::File::FixedRecLen', $file, record_length => 10, pad_char => '.', autochomp => 0, recsep => 'blah';
print $o ? "ok $N\n" : "not ok $N\n";
$N++;

my $n;

# 3-5
for (2, 1, 0) {
  print $a[$_] eq "rec${_}blah" ? "ok $N\n" : "not ok $N # rec=$a[$_] ?\n";
  $N++;
}

END {
  undef $o;
  untie @a;
  1 while unlink $file;
}

