/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.lineExtractor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;

public class LineExtractionPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    private JTextField imageLoc;
    private JTextField outputDir;
    private final GUIController guiController;
    private static final Logger LOG = Logger.getLogger(LineExtractionPanel.class.getName());

    public LineExtractionPanel(GUIController guiController) {
        this.guiController = guiController;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescription(), "North");
        this.add((Component)this.getControlPanel(), "Center");
        this.add((Component)this.getExtractButton(), "East");
    }

    private JTextArea getDescription() {
        TitledBorder border = new TitledBorder("Description");
        JTextArea textArea = new JTextArea();
        textArea.setBorder(border);
        textArea.setEditable(false);
        textArea.setBackground(this.getBackground());
        String desc = "This feature will isolate lines within an image and save them individually\nto the selected output directory.";
        textArea.setText(desc);
        return textArea;
    }

    private JPanel getControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.getImageSelectPanel());
        panel.add(this.getOutputDirSelector());
        return panel;
    }

    private JPanel getExtractButton() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        JButton btn = new JButton("Extract Lines");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File imageFile = new File(LineExtractionPanel.this.imageLoc.getText());
                File outDir = new File(LineExtractionPanel.this.outputDir.getText());
                if (!imageFile.exists() || !outDir.exists()) {
                    JOptionPane.showMessageDialog(null, "Check image or output directory!");
                } else {
                    LineExtractionPanel.this.guiController.extractLines(imageFile, outDir);
                    JOptionPane.showMessageDialog(null, "Done!");
                }
            }
        });
        btnPanel.add(btn);
        return btnPanel;
    }

    private JPanel getImageSelectPanel() {
        JPanel imageSel = new JPanel();
        imageSel.setLayout(new BoxLayout(imageSel, 0));
        JLabel imgLable = new JLabel("Select Image: ");
        imageSel.add(imgLable);
        this.imageLoc = new JTextField(40);
        imageSel.add(this.imageLoc);
        JButton button = new JButton("Select");
        button.addActionListener(this.getImageSelectAction());
        imageSel.add(button);
        return imageSel;
    }

    private JPanel getOutputDirSelector() {
        JPanel dirSelectPanel = new JPanel();
        dirSelectPanel.setLayout(new BoxLayout(dirSelectPanel, 0));
        JLabel dirLabel = new JLabel("Select Output Dir: ");
        dirSelectPanel.add(dirLabel);
        this.outputDir = new JTextField(40);
        dirSelectPanel.add(this.outputDir);
        JButton button = new JButton("Select");
        button.addActionListener(this.getOutDirSelectAction());
        dirSelectPanel.add(button);
        return dirSelectPanel;
    }

    private ActionListener getImageSelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    LineExtractionPanel.this.imageLoc.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }

    private ActionListener getOutDirSelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    LineExtractionPanel.this.outputDir.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }
}

