/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.photoshop.PhotoshopDescriptor;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopDirectory
extends Directory {
    public static final int TAG_PHOTOSHOP_THUMBNAIL = 1036;
    public static final int TAG_PHOTOSHOP_THUMBNAIL_OLD = 1033;
    public static final int TAG_PHOTOSHOP_JPEG_QUALITY = 1030;
    public static final int TAG_PHOTOSHOP_URL = 1035;
    public static final int TAG_PHOTOSHOP_IPTC = 1028;
    public static final int TAG_PHOTOSHOP_CAPTION_DIGEST = 1061;
    public static final int TAG_PHOTOSHOP_SLICES = 1050;
    public static final int TAG_PHOTOSHOP_VERSION = 1057;
    public static final int TAG_PHOTOSHOP_RESOLUTION_INFO = 1005;
    public static final int TAG_PHOTOSHOP_XML = 1002;
    public static final int TAG_PHOTOSHOP_COPYRIGHT = 1034;
    public static final int TAG_PHOTOSHOP_GLOBAL_ANGLE = 1037;
    public static final int TAG_PHOTOSHOP_GLOBAL_ALTITUDE = 1049;
    public static final int TAG_PHOTOSHOP_URL_LIST = 1054;
    public static final int TAG_PHOTOSHOP_PRINT_SCALE = 1062;
    public static final int TAG_PHOTOSHOP_PRINT_FLAGS_INFO = 10000;
    public static final int TAG_PHOTOSHOP_PRINT_FLAGS = 1011;
    public static final int TAG_PHOTOSHOP_SEED_NUMBER = 1044;
    public static final int TAG_PHOTOSHOP_PIXEL_ASPECT_RATIO = 1064;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public PhotoshopDirectory() {
        this.setDescriptor(new PhotoshopDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Photoshop";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    @Nullable
    public byte[] getThumbnailBytes() {
        byte[] storedBytes = this.getByteArray(1036);
        if (storedBytes == null) {
            storedBytes = this.getByteArray(1033);
        }
        if (storedBytes == null) {
            return null;
        }
        int thumbSize = storedBytes.length - 28;
        byte[] thumbBytes = new byte[thumbSize];
        System.arraycopy(storedBytes, 28, thumbBytes, 0, thumbSize);
        return thumbBytes;
    }

    static {
        _tagNameMap.put(1036, "Thumbnail Data");
        _tagNameMap.put(1035, "URL");
        _tagNameMap.put(1028, "IPTC-NAA record");
        _tagNameMap.put(1061, "Caption digest");
        _tagNameMap.put(1050, "Slices");
        _tagNameMap.put(1057, "Version Info");
        _tagNameMap.put(1001, "Mac Print info");
        _tagNameMap.put(1002, "XML Data");
        _tagNameMap.put(1071, "Print info");
        _tagNameMap.put(1005, "Resolution Info");
        _tagNameMap.put(1011, "Print Flags");
        _tagNameMap.put(1000, "Channels, rows, columns, depth, mode");
        _tagNameMap.put(1003, "Indexed color table");
        _tagNameMap.put(1006, "Alpha channels");
        _tagNameMap.put(1007, "DisplayInfo");
        _tagNameMap.put(1008, "Caption");
        _tagNameMap.put(1009, "Border information");
        _tagNameMap.put(1010, "Background color");
        _tagNameMap.put(1011, "Print flags");
        _tagNameMap.put(1012, "Grayscale and multichannel halftoning information");
        _tagNameMap.put(1013, "Color halftoning information");
        _tagNameMap.put(1014, "Duotone halftoning information");
        _tagNameMap.put(1015, "Grayscale and multichannel transfer function");
        _tagNameMap.put(1016, "Color transfer functions");
        _tagNameMap.put(1017, "Duotone transfer functions");
        _tagNameMap.put(1018, "Duotone image information");
        _tagNameMap.put(1019, "Effective black and white values");
        _tagNameMap.put(1021, "EPS options");
        _tagNameMap.put(1022, "Quick Mask information");
        _tagNameMap.put(1024, "Layer state information");
        _tagNameMap.put(1026, "Layers group information");
        _tagNameMap.put(1029, "Image mode for raw format files");
        _tagNameMap.put(1030, "JPEG quality");
        _tagNameMap.put(1032, "Grid and guides information");
        _tagNameMap.put(1041, "ICC Untagged Profile");
        _tagNameMap.put(1033, "Photoshop 4.0 Thumbnail");
        _tagNameMap.put(1034, "Copyright flag");
        _tagNameMap.put(1037, "Global Angle");
        _tagNameMap.put(1049, "Global Altitude");
        _tagNameMap.put(10000, "Print flags information");
        _tagNameMap.put(1062, "Print Scale");
        _tagNameMap.put(1054, "URL List");
        _tagNameMap.put(1064, "Pixel Aspect Ratio");
        _tagNameMap.put(1044, "Seed number");
    }
}

