/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import org.apache.james.mime4j.dom.ServiceLoaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceLoader {
    private ServiceLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T load(Class<T> spiClass) {
        String spiResURI = "META-INF/services/" + spiClass.getName();
        ClassLoader classLoader = spiClass.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(spiResURI);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream instream = resource.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
                    while ((line = reader.readLine()) != null) {
                        Class<?> implClass;
                        int cmtIdx = (line = line.trim()).indexOf(35);
                        if (cmtIdx != -1) {
                            line = line.substring(0, cmtIdx);
                            line = line.trim();
                        }
                        if (line.length() == 0 || !spiClass.isAssignableFrom(implClass = classLoader.loadClass(line))) continue;
                        Object impl = implClass.newInstance();
                        T t = spiClass.cast(impl);
                        return t;
                    }
                    reader.close();
                }
                finally {
                    instream.close();
                }
            }
            return null;
        }
        catch (IOException ex) {
            throw new ServiceLoaderException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceLoaderException("Unknown SPI class '" + spiClass.getName() + "'", ex);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (InstantiationException ex) {
            throw new ServiceLoaderException("SPI class '" + spiClass.getName() + "' cannot be instantiated", ex);
        }
    }
}

