# -*- perl -*-

use strict;
use warnings;
use FindBin '$Bin';
use lib "$Bin/lib";

my $work_dir = "$Bin/var/tmp/work_dir";

{
  package TestApp;
  use Moose;
  
  use Catalyst;
  extends 'Catalyst';
  
  __PACKAGE__->config(
    name => __PACKAGE__,
    'Controller::Assets' => {
      include => [ "$FindBin::Bin/var/eg_src/js" ],
      type => 'js',
      minify => 1,
      work_dir => $work_dir
    },
  );

  __PACKAGE__->setup();  
  1;
}

use Test::More;
use Catalyst::Test 'TestApp';

action_redirect(
  '/assets/current.js',
  "Current redirect"
);

contenttype_is(
  TestApp->controller('Assets')->asset_path,
  'text/javascript',
  "Expected JavaScript Content-Type"
);


done_testing;