/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotxMaker {
    private final Cluster root;
    private final Collection<Path> paths;

    public DotxMaker(Cluster cluster, Collection<Path> collection) {
        this.root = cluster;
        this.paths = collection;
    }

    public String createDotString(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph unix {");
        for (String string : stringArray) {
            stringBuilder.append(string);
        }
        stringBuilder.append("compound=true;");
        this.printCluster(stringBuilder, this.root);
        for (Path path : this.paths) {
            stringBuilder.append(this.getPathString(path) + ";");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void printCluster(StringBuilder stringBuilder, Cluster cluster) {
        if (cluster.getContents().size() == 0 && cluster.getSubClusters().size() == 0) {
            throw new IllegalStateException(cluster.toString());
        }
        for (Cluster clusterable : cluster.getSubClusters()) {
            stringBuilder.append("subgraph cluster" + clusterable.getUid() + " {");
            if (clusterable.getTitleWidth() > 0.0 && clusterable.getTitleHeight() > 0.0) {
                stringBuilder.append("label=<<TABLE FIXEDSIZE=\"TRUE\" WIDTH=\"" + clusterable.getTitleWidth() + "\" HEIGHT=\"" + clusterable.getTitleHeight() + "\"><TR><TD></TD></TR></TABLE>>");
            }
            this.printCluster(stringBuilder, clusterable);
            stringBuilder.append("}");
        }
        for (Block block : cluster.getContents()) {
            stringBuilder.append("b" + block.getUid() + this.getNodeAttibute(block) + ";");
        }
    }

    private String getPathString(Path path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder("b" + path.getStart().getUid() + " -> b" + path.getEnd().getUid());
        stringBuilder.append(" [dir=none, arrowhead=none, headclip=true, tailclip=true");
        int n = path.getLength();
        if (n >= 3) {
            stringBuilder.append(",minlen=" + (n - 1));
        }
        if (path.getLabel() == null) {
            stringBuilder.append("]");
        } else {
            Dimension2D dimension2D = path.getLabel().getSize();
            stringBuilder.append(", label=<<TABLE FIXEDSIZE=\"TRUE\" WIDTH=\"" + dimension2D.getWidth() + "\" HEIGHT=\"" + dimension2D.getHeight() + "\"><TR><TD></TD></TR></TABLE>>]");
        }
        if (path.getLength() <= 1) {
            boolean bl;
            boolean bl2 = bl = path.getStart().getParent() == path.getEnd().getParent();
            if (bl) {
                stringBuilder.append("{rank=same; b" + path.getStart().getUid() + "; b" + path.getEnd().getUid() + "}");
            } else {
                Log.println("!!!!!!!!!!!!!!!!!TURNING ARROUND DOT BUG!!!!!!!!!!!!!!!!!!");
            }
        }
        return stringBuilder.toString();
    }

    private String getNodeAttibute(Block block) {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append("label=\"\",");
        stringBuilder.append("fixedsize=true,");
        stringBuilder.append("width=" + block.getSize().getWidth() / 72.0 + ",");
        stringBuilder.append("height=" + block.getSize().getHeight() / 72.0 + ",");
        stringBuilder.append("shape=rect");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

