#!perl -w
use strict;
use Text::MicroTemplate::Extended;
use FindBin qw($Bin);

{
    package BlogEntry;
    use Mouse;
    has title => (is => 'rw');
    has body  => (is => 'rw');
}

my @blog_entries = map{ BlogEntry->new($_) } (
    {
        title => 'Entry one',
        body  => 'This is my first entry.',
    },
    {
        title => 'Entry two',
        body  => 'This is my second entry.',
    },
);

my $mt = Text::MicroTemplate::Extended->new(
    include_path  => [$Bin],
    template_args => { blog_entries => \@blog_entries },
);

print $mt->render('child');
