#!/usr/bin/perl

package eBay::API::XML::Call::GetUser;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetUser.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetUser

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetUser inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetUser::GetUserRequestType;
use eBay::API::XML::Call::GetUser::GetUserResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetUser';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetUser::GetUserRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetUser::GetUserResponseType';
}

#
# input properties
#

=head2 setIncludeExpressRequirements()

Indicates if the response should include detailed information relating to
whether a user qualifies to list an item on Express. To list an item on Express, a user must qualify based on conditions described in the eBay Web Services Guide.

Default: false
SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressSellerCriteria
Title: Seller Criteria for eBay Express

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeExpressRequirements {
   my $self   = shift;
   my $sIncludeExpressRequirements = shift;
   $self->getRequestDataType()->setIncludeExpressRequirements($sIncludeExpressRequirements);
}

=head2 setItemID()

Specifies the item ID for a successfully concluded listing in which
the requestor and target user were participants (one as seller and
the other as buyer). Necessary to return certain data (like an email
address). Not necessary if the requestor is retrieving their own data.
ItemID is an optional input.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: No
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setUserID()

Specifies the user whose data will be returned by the call. UserID is
optional. If not specified, the user data returned is for
the requesting user (as specified with the eBayAuthToken).

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setUserID {
   my $self   = shift;
   my $sUserID = shift;
   $self->getRequestDataType()->setUserID($sUserID);
}



#
# output properties
#

=head2 getUser()

Contains the returned user data for the specified eBay user.

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:UserType'

=cut
       
sub getUser {
   my $self = shift;
   return $self->getResponseDataType()->getUser();
}





1;   
