#!/usr/bin/perl

package eBay::API::XML::Call::GetProducts;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProducts.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProducts

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProducts inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetProducts::GetProductsRequestType;
use eBay::API::XML::Call::GetProducts::GetProductsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetProducts';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetProducts::GetProductsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetProducts::GetProductsResponseType';
}

#
# input properties
#

=head2 setAffiliateTrackingDetails()

See the 
<a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>.
eBay uses the specified details to build a View Item URL
string in the response that includes your
affiliate tracking information in the correct format.
When a user clicks through the URL to eBay and performs
certain tasks, you may get a commission (see the URL above).
Only applicable when IncludeItemArray is specified
(because the View Item URL is only returned in item information,
not in product information).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut
       
sub setAffiliateTrackingDetails {
   my $self   = shift;
   my $pAffiliateTrackingDetails = shift;
   $self->getRequestDataType()->setAffiliateTrackingDetails($pAffiliateTrackingDetails);
}

=head2 setIncludeBuyingGuideDetails()

If true, the response includes up to 5 buying guides (if any)
for the product specified in ExternalProductID or
ProductReferenceID.
Not applicable with QueryKeywords.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeBuyingGuideDetails {
   my $self   = shift;
   my $sIncludeBuyingGuideDetails = shift;
   $self->getRequestDataType()->setIncludeBuyingGuideDetails($sIncludeBuyingGuideDetails);
}

=head2 setIncludeHistogram()

If true, the response includes a histogram that lists the
number of matching products found and the domains in which
they were found. (A domain is like a high-level category.)
Including the histogram can affect the call's performance.
You may see significantly slower response times when many
matching products are found.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeHistogram {
   my $self   = shift;
   my $sIncludeHistogram = shift;
   $self->getRequestDataType()->setIncludeHistogram($sIncludeHistogram);
}

=head2 setIncludeItemArray()

If true, the response includes items (if any) that match the
product specified in ExternalProductID or ProductReferenceID.
Not applicable with QueryKeywords.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeItemArray {
   my $self   = shift;
   my $sIncludeItemArray = shift;
   $self->getRequestDataType()->setIncludeItemArray($sIncludeItemArray);
}

=head2 setIncludeReviewDetails()

If true, the response includes up to 20 reviews (if any)
for the product specified in ExternalProductID or
ProductReferenceID.
The reviews are sorted by most helpful (most votes) first.
When you include review details, please note that
response times may be longer than 60 seconds.
Not applicable with QueryKeywords.

  RequiredInput: No
  Default: false
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeReviewDetails {
   my $self   = shift;
   my $sIncludeReviewDetails = shift;
   $self->getRequestDataType()->setIncludeReviewDetails($sIncludeReviewDetails);
}

=head2 setProductSearch()

Contains the fields that form the search query. You can query
against keywords, an eBay product reference ID (not to be confused
with an eBay product ID), or external product ID (like an ISBN).

  RequiredInput: Yes
#    Argument: 'ns:ProductSearchType'

=cut
       
sub setProductSearch {
   my $self   = shift;
   my $pProductSearch = shift;
   $self->getRequestDataType()->setProductSearch($pProductSearch);
}

=head2 setProductSort()

Sorts the list of products returned. This is mostly only useful
with QueryKeywords. (When you use ExternalProductID or
ProductReferenceID, eBay usually only returns one product.)

  RequiredInput: No
#    Argument: 'ns:ProductSortCodeType'

=cut
       
sub setProductSort {
   my $self   = shift;
   my $sProductSort = shift;
   $self->getRequestDataType()->setProductSort($sProductSort);
}



#
# output properties
#

=head2 getApproximatePages()

The total number of pages that can be returned, given the same query and
filters in the request. As GetProducts only returns up to 2000 products,
the maximum possible value is theoretically 2000 (if you were to set
EntriesPerPage to 1 in the request).

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getApproximatePages {
   my $self = shift;
   return $self->getResponseDataType()->getApproximatePages();
}

=head2 getBuyingGuideDetails()

Contains information for up to 5 buying guides that match the
query. Only returned when you set IncludeBuyingGuideDetails to
true. Buying guides provide useful information about shopping
in a particular domain, like Digital Cameras.
For example, a digital camera buying guide
could help a buyer determine what kind of digital camera
is right for them.
If no buying guides are associated with the product, this only
returns a link to the buying guide hub (the main Guides page).

  Returned: Conditionally
#    Returns: 'ns:BuyingGuideDetailsType'

=cut
       
sub getBuyingGuideDetails {
   my $self = shift;
   return $self->getResponseDataType()->getBuyingGuideDetails();
}

=head2 getCharacteristicsSetProductHistogram()

A histogram that lists the number of matching products found
and the domains in which they were found.
A <i>domain</i> is essentially
a set of categories that share certain common features
(as determined by eBay). Each domain has its own name and ID.

  Returned: Always
#    Returns: 'ns:CharacteristicsSetProductHistogramType'

=cut
       
sub getCharacteristicsSetProductHistogram {
   my $self = shift;
   return $self->getResponseDataType()->getCharacteristicsSetProductHistogram();
}

=head2 isHasMore()

If true, more pages of results are available.
That is, PageNumber is less than ApproximatePages.

  Returned: Always
#    Returns: 'xs:boolean'

=cut
       
sub isHasMore {
   my $self = shift;
   return $self->getResponseDataType()->isHasMore();
}

=head2 getItemArray()

A list of items (if any) that match the product identified in
ExternalProductID or ProductReferenceID in the request.
Only returned when you set IncludeItemArray to true.
The items are sorted by end time (ending soonest), and this order
is not configurable in the request.
Up to 200 items can be returned. All items are returned on
the first page (page 1). Not returned when you use
QueryKeywords.<br>
<br>
If ItemCount is greater than 200, use GetSearchResults if you
want to retrieve more matching items.<br>
<br>
<span class="tablenote"><b>Note:</b>
GetSearchResults doesn't currently support ProductReferenceID
queries. So, you can use ExternalProductID (if present) as input
to GetSearchResults. Otherwise, see Product.DetailsURL for
a workaround to determine a ProductID value to use with
GetSearchResults.</span>

  Returned: Conditionally
#    Returns: 'ns:ItemArrayType'

=cut
       
sub getItemArray {
   my $self = shift;
   return $self->getResponseDataType()->getItemArray();
}

=head2 getPageNumber()

The number of the page of data returned. If many products
are found and multiple pages of results are available, use
this in combination with ApproximatePages and HasMore to decide
which page to retrieve next. As GetProducts only returns
up to 2000 products, the maximum possible value is theoretically
2000 (if you were to set EntriesPerPage to 1 in the request).

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getProduct()

An eBay catalog product. This contains stock information about a
particular DVD, camera, set of golf clubs, or other product.
When you use QueryKeywords in the request, GetProducts returns a
maximum of 20 products per page.
When you use ExternalProductID or ProductReferenceID in the
request, GetProducts usually only returns 1 product.
(If more than one product matches the same ExternalProductID,
GetProducts will return all of those products. As of the time
of this writing, we expect this to be a rare case.)

  Returned: Always
#    Returns: reference to an array  
                      of 'ns:CatalogProductType'

=cut
       
sub getProduct {
   my $self = shift;
   return $self->getResponseDataType()->getProduct();
}

=head2 getTotalProducts()

The total number of matching products found.
(If more than 2000 products are found, the call fails
with an error.)

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getTotalProducts {
   my $self = shift;
   return $self->getResponseDataType()->getTotalProducts();
}





1;   
