#!/usr/bin/perl

package eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetContextualKeywordsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsRequestType

=head1 DESCRIPTION

<b>The use of this call requires approval from the eBay Developers Program.
If you would like access,
please send an email to developer-relations@ebay.com detailing your typical usage,
with estimated usage numbers for this call.</b>
<br>
<br>
This call retrieves top-ranked contextual eBay keywords and categories for a specified web
page. Results are ranked according to score. This enables developers to create
applications that are different from traditional contextual ad serving. For
instance, instead of building a standard ad banner or skyscraper ad like those
from eBay AdContext, a developer could create an application that does inline
hyperlinking of keywords on any page or create widgets for blog platforms.
Not available for SG and HK sites.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'CategoryID', 'xs:string', '1', '', '' ]
	, [ 'Encoding', 'xs:string', '', '', '' ]
	, [ 'URL', 'xs:anyURI', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryID()

The ID of the category to which keywords are to be limited.
Zero or more category IDs can be specified.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategoryID()

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->_getDataTypeArray('CategoryID');
}


=head2 setEncoding()

Web page encoding by which the URL is to be handled, such as ISO-8859-1.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setEncoding {
  my $self = shift;
  $self->{'Encoding'} = shift
}

=head2 getEncoding()

#    Returns: 'xs:string'

=cut

sub getEncoding {
  my $self = shift;
  return $self->{'Encoding'};
}


=head2 setURL()

The URL of the web page from which eBay is to extract keywords.

  RequiredInput: Yes
#    Argument: 'xs:anyURI'

=cut

sub setURL {
  my $self = shift;
  $self->{'URL'} = shift
}

=head2 getURL()

#    Returns: 'xs:anyURI'

=cut

sub getURL {
  my $self = shift;
  return $self->{'URL'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
