# Generated by default/object.tt
package Paws::NimbleStudio::SharedFileSystemConfiguration;
  use Moose;
  has Endpoint => (is => 'ro', isa => 'Str', request_name => 'endpoint', traits => ['NameInRequest']);
  has FileSystemId => (is => 'ro', isa => 'Str', request_name => 'fileSystemId', traits => ['NameInRequest']);
  has LinuxMountPoint => (is => 'ro', isa => 'Str', request_name => 'linuxMountPoint', traits => ['NameInRequest']);
  has ShareName => (is => 'ro', isa => 'Str', request_name => 'shareName', traits => ['NameInRequest']);
  has WindowsMountDrive => (is => 'ro', isa => 'Str', request_name => 'windowsMountDrive', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::SharedFileSystemConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::SharedFileSystemConfiguration object:

  $service_obj->Method(Att1 => { Endpoint => $value, ..., WindowsMountDrive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::SharedFileSystemConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Endpoint

=head1 DESCRIPTION

The configuration for a shared file storage system that is associated
with a studio resource.

=head1 ATTRIBUTES


=head2 Endpoint => Str

The endpoint of the shared file system that is accessed by the studio
component resource.


=head2 FileSystemId => Str

The unique identifier for a file system.


=head2 LinuxMountPoint => Str

The mount location for a shared file system on a Linux virtual
workstation.


=head2 ShareName => Str

The name of the file share.


=head2 WindowsMountDrive => Str

The mount location for a shared file system on a Windows virtual
workstation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

