/*-
 * Copyright (c) 2000  Peter Wemm <peter@freebsd.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This module is a the perl (using XS) shortened version of FreeBSD's kenv().
 * This doesn't have the same return as original kenv, will look for a defined
 * string in all lines returend by kenv.
 * - Laszlo Danielisz with help from Patrick Mullen
 */
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include <sys/types.h>
#include <kenv.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

MODULE = kenvperl	PACKAGE = kenvperl

void
kdumpenv()
PREINIT://The PREINIT: keyword allows extra variables to be declared immediately before or
		//after the declarations of the parameters from the INPUT: section are emitted.
		//If a variable is declared inside a CODE: section it will follow any typemap 
		//code that is emitted for the input parameters. This may result in the declaration
		// ending up after C code, which is C syntax error
    char *str, *buf, *cp;
    char *retbuf; // for storing the pointer for return
	int buflen, envlen, i;
PPCODE: //The PPCODE: keyword is an alternate form of the CODE: keyword and is used to tell
		//the xsubpp compiler that the programmer is supplying the code to control the argument
		// stack for the XSUBs return values.
	    envlen = kenv(KENV_DUMP, NULL, NULL, 0);
        
        if (envlen < 0)
                return (-1);
        for (;;) { //infinite loop
                buflen = envlen * 120 / 100;
                buf = malloc(buflen + 1);
                if (buf == NULL)
                        return (-1);
                memset(buf, 0, buflen + 1);
                envlen = kenv(KENV_DUMP, NULL, buf, buflen);
                if (envlen < 0) {
                        free(buf);
                        return (-1);
                }
                if (envlen > buflen)
                        free(buf);
                else    
                        break;
        }
// END between these tags is original kdumpenv() code
		retbuf = buf;
		i=0;
		while(i++ < buflen) {
			if(!*buf)
			*buf = '|';
		// Environment is given to us in a null-terminated series of
		// null-terminated strings.  I convert the nulls to pipes ('|') 
		// so we can return a simple string, which we then split on 
		// within perl to convert to a proper array.
		buf++;
        }

	str = retbuf;
XPUSHs(sv_2mortal(newSVpv(str, 0))); //Push an SV onto the stack, extending the stack 
free(str); //When you tell XS that you have a "char *" input buffer, it pulls out 
		   //a pointer to the string value (if any) stored in the scalar you pass in.
		   // So that buffer is allocated just like any other scalar string value buffer
		   // in Perl and is free()d in the sdame situations. So you don't need to worry 
		   //about a memory leak. 
